/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.ast.visit;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstAbstractMemberNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstByteOrder;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstEnumNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstStructNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstType;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstUnionNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstVariantNode;
import org.reaktivity.nukleus.maven.plugin.internal.generate.StructFlyweightGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeResolver;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeSpecGenerator;

public final class StructVisitor
extends AstNode.Visitor<Collection<TypeSpecGenerator<?>>> {
    private final StructFlyweightGenerator generator;
    private final TypeResolver resolver;
    private final Set<TypeSpecGenerator<?>> defaultResult;

    public StructVisitor(StructFlyweightGenerator generator, TypeResolver resolver) {
        this.generator = generator;
        this.resolver = resolver;
        this.defaultResult = Collections.singleton(generator);
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitStruct(AstStructNode structNode) {
        AstType supertype = structNode.supertype();
        if (supertype != null) {
            AstStructNode superNode = (AstStructNode)this.resolver.resolve(supertype.name());
            this.visitStruct(superNode);
        }
        super.visitStruct(structNode);
        return this.defaultResult();
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitEnum(AstEnumNode enumNode) {
        return this.defaultResult();
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitUnion(AstUnionNode unionNode) {
        return this.defaultResult();
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitVariant(AstVariantNode variantNode) {
        return this.defaultResult();
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitMember(AstAbstractMemberNode memberNode) {
        String memberName = memberNode.name();
        AstType memberType = memberNode.type();
        int size = memberNode.size();
        String sizeName = memberNode.sizeName();
        TypeName sizeTypeName = memberNode.sizeType() == null ? null : (memberNode.sizeType().isUnsignedInt() ? this.resolver.resolveUnsignedType(memberNode.sizeType()) : this.resolver.resolveType(memberNode.sizeType()));
        boolean usedAsSize = memberNode.usedAsSize();
        Object defaultValue = memberNode.defaultValue();
        AstByteOrder byteOrder = memberNode.byteOrder();
        if (memberType == AstType.ARRAY32) {
            ClassName rawType = this.resolver.resolveClass(memberType);
            TypeName[] typeArguments = memberNode.types().stream().skip(1L).map(this.resolver::resolveType).collect(Collectors.toList()).toArray(new TypeName[0]);
            ParameterizedTypeName memberTypeName = ParameterizedTypeName.get((ClassName)rawType, (TypeName[])typeArguments);
            List<AstType> memberTypes = memberNode.types();
            AstType memberUnsignedType = memberTypes.get(1);
            TypeName memberUnsignedTypeName = this.resolver.resolveUnsignedType(memberUnsignedType);
            this.generator.addMember(memberName, memberType, (TypeName)memberTypeName, memberUnsignedType, memberUnsignedTypeName, size, sizeName, sizeTypeName, false, defaultValue, byteOrder);
        } else {
            TypeName memberTypeName = this.resolver.resolveType(memberType);
            if (memberTypeName == null) {
                throw new IllegalArgumentException(String.format(" Unable to resolve type %s for field %s", memberType, memberName));
            }
            AstType memberUnsignedType = memberType.isUnsignedInt() ? memberType : null;
            TypeName memberUnsignedTypeName = this.resolver.resolveUnsignedType(memberUnsignedType);
            this.generator.addMember(memberName, memberType, memberTypeName, memberUnsignedType, memberUnsignedTypeName, size, sizeName, sizeTypeName, usedAsSize, defaultValue, byteOrder);
        }
        return this.defaultResult();
    }

    @Override
    protected Collection<TypeSpecGenerator<?>> defaultResult() {
        return this.defaultResult;
    }
}

