/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.generate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.lang.model.element.Modifier;
import org.reaktivity.nukleus.maven.plugin.internal.generate.ClassSpecGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeNames;

public final class String32FlyweightGenerator
extends ClassSpecGenerator {
    private final TypeSpec.Builder classBuilder;
    private final BuilderClassBuilder builderClassBuilder;

    public String32FlyweightGenerator(ClassName stringType) {
        super(stringType.peerClass("String32FW"));
        this.classBuilder = TypeSpec.classBuilder((ClassName)((ClassName)this.thisName)).superclass((TypeName)stringType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        this.builderClassBuilder = new BuilderClassBuilder(stringType, (ClassName)this.thisName, stringType.nestedClass("Builder"));
    }

    @Override
    public TypeSpec generate() {
        return this.classBuilder.addField(this.fieldSizeLengthConstant()).addField(this.fieldByteOrder()).addField(this.valueField()).addMethod(this.constructor()).addMethod(this.constructorByteOrder()).addMethod(this.constructorString()).addMethod(this.constructorStringAndByteOrder()).addMethod(this.constructorStringAndCharset()).addMethod(this.constructorStringAndCharsetAndByteOrder()).addMethod(this.fieldSizeLengthMethod()).addMethod(this.limitMethod()).addMethod(this.valueMethod()).addMethod(this.asStringMethod()).addMethod(this.tryWrapMethod()).addMethod(this.wrapMethod()).addMethod(this.toStringMethod()).addMethod(this.lengthMethod()).addType(this.builderClassBuilder.build()).build();
    }

    private FieldSpec fieldSizeLengthConstant() {
        return FieldSpec.builder(Integer.TYPE, (String)"FIELD_SIZE_LENGTH", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.SIZE_OF_INT", new Object[]{TypeNames.BIT_UTIL_TYPE}).build();
    }

    private FieldSpec fieldByteOrder() {
        return FieldSpec.builder(ByteOrder.class, (String)"byteOrder", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    private FieldSpec valueField() {
        return FieldSpec.builder((TypeName)TypeNames.DIRECT_BUFFER_TYPE, (String)"valueRO", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T(0L, 0)", new Object[]{TypeNames.UNSAFE_BUFFER_TYPE}).build();
    }

    private MethodSpec constructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this.byteOrder = $T.nativeOrder()", new Object[]{ByteOrder.class}).build();
    }

    private MethodSpec constructorString() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, "value", new Modifier[0]).addStatement("this(value, $T.UTF_8)", new Object[]{StandardCharsets.class}).build();
    }

    private MethodSpec constructorStringAndByteOrder() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, "value", new Modifier[0]).addParameter(ByteOrder.class, "byteOrder", new Modifier[0]).addStatement("this(value, $T.UTF_8, byteOrder)", new Object[]{StandardCharsets.class}).build();
    }

    private MethodSpec constructorStringAndCharset() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, "value", new Modifier[0]).addParameter(Charset.class, "charset", new Modifier[0]).addStatement("this(value, $T.UTF_8, $T.nativeOrder())", new Object[]{StandardCharsets.class, ByteOrder.class}).build();
    }

    private MethodSpec constructorStringAndCharsetAndByteOrder() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, "value", new Modifier[0]).addParameter(Charset.class, "charset", new Modifier[0]).addParameter(ByteOrder.class, "byteOrder", new Modifier[0]).addStatement("this.byteOrder = byteOrder", new Object[0]).beginControlFlow("if (value != null)", new Object[0]).addStatement("final byte[] encoded = value.getBytes(charset)", new Object[0]).addStatement("final $T buffer = new $T(new byte[FIELD_SIZE_LENGTH + Math.max(encoded.length, 1)])", new Object[]{TypeNames.MUTABLE_DIRECT_BUFFER_TYPE, TypeNames.UNSAFE_BUFFER_TYPE}).addStatement("buffer.putInt(0, encoded.length, byteOrder)", new Object[0]).addStatement("buffer.putBytes(FIELD_SIZE_LENGTH, encoded)", new Object[0]).addStatement("wrap(buffer, 0, buffer.capacity())", new Object[0]).nextControlFlow("else", new Object[0]).addStatement("final $T buffer = new $T(new byte[FIELD_SIZE_LENGTH + 1])", new Object[]{TypeNames.MUTABLE_DIRECT_BUFFER_TYPE, TypeNames.UNSAFE_BUFFER_TYPE}).addStatement("buffer.putInt(0, -1)", new Object[0]).addStatement("wrap(buffer, 0, buffer.capacity())", new Object[0]).endControlFlow().build();
    }

    private MethodSpec constructorByteOrder() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ByteOrder.class, "byteOrder", new Modifier[0]).addStatement("this.byteOrder = byteOrder", new Object[0]).build();
    }

    private MethodSpec fieldSizeLengthMethod() {
        return MethodSpec.methodBuilder((String)"fieldSizeLength").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return FIELD_SIZE_LENGTH", new Object[0]).build();
    }

    private MethodSpec limitMethod() {
        return MethodSpec.methodBuilder((String)"limit").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return offset() + FIELD_SIZE_LENGTH + Math.max(length(), 0)", new Object[0]).build();
    }

    private MethodSpec asStringMethod() {
        return MethodSpec.methodBuilder((String)"asString").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(String.class).beginControlFlow("if (maxLimit() == offset() || length() == -1)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("return buffer().getStringWithoutLengthUtf8(offset() + FIELD_SIZE_LENGTH, length())", new Object[0]).build();
    }

    private MethodSpec tryWrapMethod() {
        return MethodSpec.methodBuilder((String)"tryWrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(this.thisName).beginControlFlow("if (null == super.tryWrap(buffer, offset, maxLimit) || offset + FIELD_SIZE_LENGTH > maxLimit() || limit() > maxLimit)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("int length = length()", new Object[0]).beginControlFlow("if (length != -1)", new Object[0]).addStatement("valueRO.wrap(buffer, offset + FIELD_SIZE_LENGTH, length)", new Object[0]).endControlFlow().addStatement("return this", new Object[0]).build();
    }

    private MethodSpec wrapMethod() {
        return MethodSpec.methodBuilder((String)"wrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(this.thisName).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]).addStatement("checkLimit(offset + FIELD_SIZE_LENGTH, maxLimit)", new Object[0]).addStatement("checkLimit(limit(), maxLimit)", new Object[0]).addStatement("int length = length()", new Object[0]).beginControlFlow("if (length != -1)", new Object[0]).addStatement("valueRO.wrap(buffer, offset + FIELD_SIZE_LENGTH, length)", new Object[0]).endControlFlow().addStatement("return this", new Object[0]).build();
    }

    private MethodSpec valueMethod() {
        return MethodSpec.methodBuilder((String)"value").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeNames.DIRECT_BUFFER_TYPE).addStatement("return length() == -1 ? null : valueRO", new Object[0]).build();
    }

    private MethodSpec toStringMethod() {
        return MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return maxLimit() == offset() ? \"null\" : String.format(\"\\\"%s\\\"\", asString())", new Object[0]).build();
    }

    private MethodSpec lengthMethod() {
        return MethodSpec.methodBuilder((String)"length").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("int length = buffer().getInt(offset(), byteOrder) & 0xFFFFFFFF", new Object[0]).addStatement("return length < 0 ? -1 : length", new Object[0]).build();
    }

    private static final class BuilderClassBuilder {
        private final TypeSpec.Builder classBuilder;
        private final ClassName classType;
        private final ClassName stringType;
        private final ClassName string32Type;

        private BuilderClassBuilder(ClassName stringType, ClassName string32Type, ClassName builderRawType) {
            ParameterizedTypeName builderType = ParameterizedTypeName.get((ClassName)builderRawType, (TypeName[])new TypeName[]{string32Type});
            this.stringType = stringType;
            this.string32Type = string32Type;
            this.classType = string32Type.nestedClass("Builder");
            this.classBuilder = TypeSpec.classBuilder((String)this.classType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).superclass((TypeName)builderType);
        }

        public TypeSpec build() {
            return this.classBuilder.addField(this.fieldByteOrder()).addField(this.valueSetField()).addMethod(this.constructor()).addMethod(this.constructorByteOrder()).addMethod(this.wrapMethod()).addMethod(this.setMethod()).addMethod(this.setDirectBufferMethod()).addMethod(this.setStringMethod()).addMethod(this.checkLengthMethod()).addMethod(this.buildMethod()).build();
        }

        private FieldSpec fieldByteOrder() {
            return FieldSpec.builder(ByteOrder.class, (String)"byteOrder", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        }

        private FieldSpec valueSetField() {
            return FieldSpec.builder(Boolean.TYPE, (String)"valueSet", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
        }

        private MethodSpec constructor() {
            return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super(new $T())", new Object[]{this.string32Type}).addStatement("this.byteOrder = $T.nativeOrder()", new Object[]{ByteOrder.class}).build();
        }

        private MethodSpec constructorByteOrder() {
            return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ByteOrder.class, "byteOrder", new Modifier[0]).addStatement("super(new $T(byteOrder))", new Object[]{this.string32Type}).addStatement("this.byteOrder = byteOrder", new Object[0]).build();
        }

        private MethodSpec wrapMethod() {
            return MethodSpec.methodBuilder((String)"wrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.classType).addParameter((TypeName)TypeNames.MUTABLE_DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).addStatement("checkLimit(offset + FIELD_SIZE_LENGTH, maxLimit)", new Object[0]).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]).addStatement("this.valueSet = false", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec setMethod() {
            return MethodSpec.methodBuilder((String)"set").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.classType).addParameter((TypeName)this.stringType, "value", new Modifier[0]).beginControlFlow("if (value == null)", new Object[0]).addStatement("int newLimit = offset() + FIELD_SIZE_LENGTH", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("buffer().putInt(offset(), -1, byteOrder)", new Object[0]).addStatement("limit(newLimit)", new Object[0]).nextControlFlow("else", new Object[0]).addStatement("int newLimit = offset() + FIELD_SIZE_LENGTH + value.length()", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("buffer().putInt(offset(), value.length(), byteOrder)", new Object[0]).addStatement("buffer().putBytes(offset() + 4, value.buffer(), value.offset() + value.fieldSizeLength(), value.length())", new Object[0]).addStatement("limit(newLimit)", new Object[0]).endControlFlow().addStatement("valueSet = true", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec setDirectBufferMethod() {
            return MethodSpec.methodBuilder((String)"set").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.classType).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "srcBuffer", new Modifier[0]).addParameter(Integer.TYPE, "srcOffset", new Modifier[0]).addParameter(Integer.TYPE, "length", new Modifier[0]).addStatement("checkLength(length)", new Object[0]).addStatement("int offset = offset()", new Object[0]).addStatement("int newLimit = offset + length + FIELD_SIZE_LENGTH", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("buffer().putInt(offset, length, byteOrder)", new Object[0]).addStatement("buffer().putBytes(offset + 4, srcBuffer, srcOffset, length)", new Object[0]).addStatement("limit(newLimit)", new Object[0]).addStatement("valueSet = true", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec setStringMethod() {
            return MethodSpec.methodBuilder((String)"set").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.classType).addParameter(String.class, "value", new Modifier[0]).addParameter(Charset.class, "charset", new Modifier[0]).beginControlFlow("if (value == null)", new Object[0]).addStatement("int newLimit = offset() + FIELD_SIZE_LENGTH", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("buffer().putInt(offset(), -1, byteOrder)", new Object[0]).addStatement("limit(newLimit)", new Object[0]).nextControlFlow("else", new Object[0]).addStatement("byte[] charBytes = value.getBytes(charset)", new Object[0]).addStatement("checkLength(charBytes.length)", new Object[0]).addStatement("int newLimit = offset() + FIELD_SIZE_LENGTH + charBytes.length", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("buffer().putInt(offset(), charBytes.length, byteOrder)", new Object[0]).addStatement("buffer().putBytes(offset() + 4, charBytes)", new Object[0]).addStatement("limit(newLimit)", new Object[0]).endControlFlow().addStatement("valueSet = true", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec checkLengthMethod() {
            return MethodSpec.methodBuilder((String)"checkLength").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter(Integer.TYPE, "length", new Modifier[0]).addStatement("final int maxLength = $T.MAX_VALUE - 1", new Object[]{Integer.class}).beginControlFlow("if (length > maxLength)", new Object[0]).addStatement("final String msg = String.format(\"length=%d is beyond maximum length=%d\", length, maxLength)", new Object[0]).addStatement("throw new IllegalArgumentException(msg)", new Object[0]).endControlFlow().build();
        }

        private MethodSpec buildMethod() {
            return MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.string32Type).beginControlFlow("if (!valueSet)", new Object[0]).addStatement("set(null, $T.UTF_8)", new Object[]{StandardCharsets.class}).endControlFlow().addStatement("return super.build()", new Object[0]).build();
        }
    }
}

