/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.generate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.reaktivity.nukleus.maven.plugin.internal.generate.ClassSpecGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeNames;

public final class EnumFlyweightGenerator
extends ClassSpecGenerator {
    private static final Map<TypeName, String> CLASS_NAMES;
    private final TypeSpec.Builder classBuilder;
    private final BuilderClassBuilder builderClassBuilder;
    private final ClassName enumTypeName;
    private final TypeName valueTypeName;
    private final TypeName unsignedValueTypeName;

    public EnumFlyweightGenerator(ClassName enumName, ClassName flyweightName, ClassName enumTypeName, TypeName valueTypeName, TypeName valueVariantOfTypeName, TypeName unsignedValueTypeName) {
        super(enumName);
        this.enumTypeName = enumTypeName;
        this.classBuilder = TypeSpec.classBuilder((ClassName)((ClassName)this.thisName)).superclass((TypeName)flyweightName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        this.builderClassBuilder = new BuilderClassBuilder((ClassName)this.thisName, flyweightName.nestedClass("Builder"), enumTypeName, valueTypeName, valueVariantOfTypeName, unsignedValueTypeName);
        this.valueTypeName = valueTypeName;
        this.unsignedValueTypeName = unsignedValueTypeName;
    }

    @Override
    public TypeSpec generate() {
        if (this.isValueTypeNonPrimitive()) {
            this.classBuilder.addField(this.nonPrimitiveField());
            if (EnumFlyweightGenerator.isStringType((ClassName)this.valueTypeName)) {
                this.classBuilder.addMethod(this.stringMethod());
            }
        } else {
            this.classBuilder.addField(this.fieldOffsetValueConstant()).addField(this.fieldSizeValueConstant());
        }
        return this.classBuilder.addMethod(this.limitMethod()).addMethod(this.getMethod()).addMethod(this.tryWrapMethod()).addMethod(this.wrapMethod()).addMethod(this.toStringMethod()).addType(this.builderClassBuilder.build()).build();
    }

    private static Map<TypeName, String> initstringValueTypeByTypeName() {
        HashMap<TypeName, String> stringValueTypeByTypeName = new HashMap<TypeName, String>();
        stringValueTypeByTypeName.put(TypeName.BYTE, "Byte");
        stringValueTypeByTypeName.put(TypeName.SHORT, "Short");
        stringValueTypeByTypeName.put(TypeName.INT, "Int");
        stringValueTypeByTypeName.put(TypeName.LONG, "Long");
        return stringValueTypeByTypeName;
    }

    private boolean isValueTypeNonPrimitive() {
        return this.valueTypeName != null && !this.valueTypeName.isPrimitive();
    }

    private FieldSpec nonPrimitiveField() {
        String fieldName = EnumFlyweightGenerator.isStringType((ClassName)this.valueTypeName) ? "stringRO" : String.format("%sRO", EnumFlyweightGenerator.fieldName(this.valueTypeName));
        return FieldSpec.builder((TypeName)this.valueTypeName, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T()", new Object[]{this.valueTypeName}).build();
    }

    private FieldSpec fieldOffsetValueConstant() {
        return FieldSpec.builder(Integer.TYPE, (String)"FIELD_OFFSET_VALUE", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("0", new Object[0]).build();
    }

    private FieldSpec fieldSizeValueConstant() {
        String constantType = this.valueTypeName == null ? "BYTE" : CLASS_NAMES.get(this.valueTypeName).toUpperCase();
        return FieldSpec.builder(Integer.TYPE, (String)"FIELD_SIZE_VALUE", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(String.format("$T.SIZE_OF_%s", constantType), new Object[]{TypeNames.BIT_UTIL_TYPE}).build();
    }

    private MethodSpec stringMethod() {
        return MethodSpec.methodBuilder((String)"string").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.valueTypeName).addStatement("return stringRO", new Object[0]).build();
    }

    private MethodSpec limitMethod() {
        String limitMethod = !this.isValueTypeNonPrimitive() ? "" : (EnumFlyweightGenerator.isStringType((ClassName)this.valueTypeName) ? "stringRO.limit()" : String.format("%sRO.limit()", EnumFlyweightGenerator.fieldName(this.valueTypeName)));
        String returnStatement = String.format("return %s", this.isValueTypeNonPrimitive() ? limitMethod : "offset() + FIELD_SIZE_VALUE");
        return MethodSpec.methodBuilder((String)"limit").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement(returnStatement, new Object[0]).build();
    }

    private MethodSpec getMethod() {
        String bufferType = this.valueTypeName == null ? "Byte" : CLASS_NAMES.get(this.valueTypeName);
        String unsignedHex = "";
        if (this.unsignedValueTypeName != null) {
            if (this.valueTypeName.equals((Object)TypeName.BYTE)) {
                unsignedHex = " & 0xFF";
            } else if (this.valueTypeName.equals((Object)TypeName.SHORT)) {
                unsignedHex = " & 0xFFFF";
            } else if (this.valueTypeName.equals((Object)TypeName.INT)) {
                unsignedHex = " & 0xFFFF_FFFFL";
            }
        }
        Object[] objectArray = new Object[1];
        objectArray[0] = this.isValueTypeNonPrimitive() ? (EnumFlyweightGenerator.isStringType((ClassName)this.valueTypeName) ? "stringRO.asString() != null ? $T.valueOf(stringRO.asString().toUpperCase()) : null" : String.format("$T.valueOf(%sRO.get())", EnumFlyweightGenerator.fieldName(this.valueTypeName))) : String.format("$T.valueOf(buffer().get%s(offset() + FIELD_OFFSET_VALUE)%s)", bufferType, unsignedHex);
        String returnStatement = String.format("return %s", objectArray);
        return MethodSpec.methodBuilder((String)"get").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.enumTypeName).addStatement(returnStatement, new Object[]{this.enumTypeName}).build();
    }

    private MethodSpec tryWrapMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"tryWrap");
        builder.addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(this.thisName);
        if (this.isValueTypeNonPrimitive()) {
            String fieldName = EnumFlyweightGenerator.isStringType((ClassName)this.valueTypeName) ? "string" : EnumFlyweightGenerator.fieldName(this.valueTypeName);
            builder.beginControlFlow("if (super.tryWrap(buffer, offset, maxLimit) == null)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().beginControlFlow("if ($LRO.tryWrap(buffer, offset, maxLimit) == null)", new Object[]{fieldName}).addStatement("return null", new Object[0]).endControlFlow().beginControlFlow("if (limit() > maxLimit)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow();
        } else {
            builder.beginControlFlow("if (super.tryWrap(buffer, offset, maxLimit) == null || limit() > maxLimit)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow();
        }
        return builder.addStatement("return this", new Object[0]).build();
    }

    private MethodSpec wrapMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"wrap");
        builder.addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(this.thisName).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]);
        if (this.isValueTypeNonPrimitive()) {
            String fieldName = EnumFlyweightGenerator.isStringType((ClassName)this.valueTypeName) ? "string" : EnumFlyweightGenerator.fieldName(this.valueTypeName);
            builder.addStatement("$LRO.wrap(buffer, offset, maxLimit)", new Object[]{fieldName});
        }
        return builder.addStatement("checkLimit(limit(), maxLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
    }

    private MethodSpec toStringMethod() {
        return MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return maxLimit() == offset() ? \"null\" : get().toString()", new Object[0]).build();
    }

    private static boolean isStringType(ClassName classType) {
        return EnumFlyweightGenerator.isStringFWType(classType) || EnumFlyweightGenerator.isString8Type(classType) || EnumFlyweightGenerator.isString16Type(classType) || EnumFlyweightGenerator.isString32Type(classType);
    }

    private static boolean isStringFWType(ClassName classType) {
        String name = classType.simpleName();
        return "StringFW".equals(name);
    }

    private static boolean isString8Type(ClassName classType) {
        String name = classType.simpleName();
        return "String8FW".equals(name);
    }

    private static boolean isString16Type(ClassName classType) {
        String name = classType.simpleName();
        return "String16FW".equals(name);
    }

    private static boolean isString32Type(ClassName classType) {
        String name = classType.simpleName();
        return "String32FW".equals(name);
    }

    private static String fieldName(TypeName type) {
        String fieldName = ((ClassName)type).simpleName();
        return String.format("%s%s", Character.valueOf(Character.toLowerCase(fieldName.charAt(0))), fieldName.substring(1, fieldName.length() - 2));
    }

    private boolean isTypeByte() {
        return this.valueTypeName.equals((Object)TypeName.BYTE) && this.unsignedValueTypeName.equals((Object)TypeName.INT);
    }

    static {
        HashMap<TypeName, String> stringValueTypeByTypeName = new HashMap<TypeName, String>();
        stringValueTypeByTypeName.put(TypeName.BYTE, "Byte");
        stringValueTypeByTypeName.put(TypeName.SHORT, "Short");
        stringValueTypeByTypeName.put(TypeName.INT, "Int");
        stringValueTypeByTypeName.put(TypeName.LONG, "Long");
        CLASS_NAMES = stringValueTypeByTypeName;
    }

    private static final class BuilderClassBuilder {
        private final TypeSpec.Builder classBuilder;
        private final ClassName enumTypeName;
        private final ClassName classType;
        private final ClassName enumName;
        private final TypeName valueTypeName;
        private final TypeName valueVariantOfTypeName;
        private final TypeName unsignedValueTypeName;

        private BuilderClassBuilder(ClassName enumName, ClassName builderRawType, ClassName enumTypeName, TypeName valueTypeName, TypeName valueVariantOfTypeName, TypeName unsignedValueTypeName) {
            ParameterizedTypeName builderType = ParameterizedTypeName.get((ClassName)builderRawType, (TypeName[])new TypeName[]{enumName});
            this.enumName = enumName;
            this.enumTypeName = enumTypeName;
            this.classType = enumName.nestedClass("Builder");
            this.classBuilder = TypeSpec.classBuilder((String)this.classType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).superclass((TypeName)builderType);
            this.valueTypeName = valueTypeName;
            this.valueVariantOfTypeName = valueVariantOfTypeName;
            this.unsignedValueTypeName = unsignedValueTypeName;
        }

        public TypeSpec build() {
            this.classBuilder.addField(this.fieldValueSet()).addMethod(this.constructor()).addMethod(this.wrapMethod()).addMethod(this.setMethod()).addMethod(this.setEnumMethod());
            if (this.isValueNonPrimitiveType()) {
                this.classBuilder.addField(this.nonPrimitiveField());
            }
            return this.classBuilder.addMethod(this.buildMethod()).build();
        }

        private boolean isValueNonPrimitiveType() {
            return this.valueTypeName != null && !this.valueTypeName.isPrimitive();
        }

        private FieldSpec nonPrimitiveField() {
            String fieldName = EnumFlyweightGenerator.isStringType((ClassName)this.valueTypeName) ? "stringRW" : String.format("%sRW", EnumFlyweightGenerator.fieldName(this.valueTypeName));
            ClassName classType = (ClassName)this.valueTypeName;
            ClassName builderType = classType.nestedClass("Builder");
            return FieldSpec.builder((TypeName)builderType, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T.Builder()", new Object[]{this.valueTypeName}).build();
        }

        private FieldSpec fieldValueSet() {
            return FieldSpec.builder(Boolean.TYPE, (String)"valueSet", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
        }

        private MethodSpec constructor() {
            return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super(new $T())", new Object[]{this.enumName}).build();
        }

        private MethodSpec wrapMethod() {
            MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"wrap");
            builder.addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.enumName.nestedClass("Builder")).addParameter((TypeName)TypeNames.MUTABLE_DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]);
            if (this.isValueNonPrimitiveType()) {
                String fieldName = EnumFlyweightGenerator.isStringType((ClassName)this.valueTypeName) ? "string" : EnumFlyweightGenerator.fieldName(this.valueTypeName);
                builder.addStatement("$LRW.wrap(buffer, offset, maxLimit)", new Object[]{fieldName});
            }
            return builder.addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec setMethod() {
            MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"set");
            builder.addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.enumName.nestedClass("Builder")).addParameter((TypeName)this.enumName, "value", new Modifier[0]);
            if (this.isValueNonPrimitiveType()) {
                String limit;
                boolean isStringType = EnumFlyweightGenerator.isStringType((ClassName)this.valueTypeName);
                String fieldName = isStringType ? "string" : EnumFlyweightGenerator.fieldName(this.valueTypeName);
                String value = isStringType ? ".string()" : ".get().value()";
                String string = limit = isStringType ? ".build()" : "";
                if (this.valueVariantOfTypeName != this.valueTypeName && this.valueVariantOfTypeName instanceof ClassName && EnumFlyweightGenerator.isStringType((ClassName)this.valueVariantOfTypeName)) {
                    builder.addStatement("$LRW.set(value$L, $T.UTF_8)", new Object[]{fieldName, value, StandardCharsets.class});
                } else {
                    builder.addStatement("$LRW.set(value$L)", new Object[]{fieldName, value});
                }
                builder.addStatement("limit($LRW$L.limit())", new Object[]{fieldName, limit});
            } else {
                builder.addStatement("int newLimit = offset() + value.sizeof()", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("buffer().putBytes(offset(), value.buffer(), value.offset(), value.sizeof())", new Object[0]).addStatement("limit(newLimit)", new Object[0]);
            }
            return builder.addStatement("valueSet = true", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec setEnumMethod() {
            MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"set");
            builder.addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.enumName.nestedClass("Builder")).addParameter((TypeName)this.enumTypeName, "value", new Modifier[0]);
            if (this.isValueNonPrimitiveType()) {
                String limit;
                boolean isStringType = EnumFlyweightGenerator.isStringType((ClassName)this.valueTypeName);
                String fieldName = isStringType ? "string" : EnumFlyweightGenerator.fieldName(this.valueTypeName);
                String charset = isStringType ? ", charset" : "";
                String string = limit = isStringType ? ".build()" : "";
                if (isStringType) {
                    builder.addParameter(Charset.class, "charset", new Modifier[0]);
                }
                if (this.valueVariantOfTypeName != this.valueTypeName && this.valueVariantOfTypeName instanceof ClassName && EnumFlyweightGenerator.isStringType((ClassName)this.valueVariantOfTypeName)) {
                    builder.addStatement("$LRW.set(value.value()$L, $T.UTF_8)", new Object[]{fieldName, charset, StandardCharsets.class});
                } else {
                    builder.addStatement("$LRW.set(value.value()$L)", new Object[]{fieldName, charset});
                }
                builder.addStatement("limit($LRW$L.limit())", new Object[]{fieldName, limit});
            } else {
                String methodName = this.isParameterizedType() ? "value" : "ordinal";
                String bufferType = this.isParameterizedType() ? (String)CLASS_NAMES.get(this.valueTypeName) : "Byte";
                String castType = "";
                String unsignedHex = "";
                if (!this.isParameterizedType()) {
                    castType = "(byte) ";
                } else if (this.unsignedValueTypeName != null) {
                    if (this.valueTypeName.equals((Object)TypeName.BYTE)) {
                        unsignedHex = " & 0xFF)";
                        castType = "(byte) (";
                    } else if (this.valueTypeName.equals((Object)TypeName.SHORT)) {
                        unsignedHex = " & 0xFFFF)";
                        castType = "(short) (";
                    } else if (this.valueTypeName.equals((Object)TypeName.INT)) {
                        unsignedHex = " & 0xFFFF_FFFFL)";
                        castType = "(int) (";
                    }
                }
                builder.addStatement("MutableDirectBuffer buffer = buffer()", new Object[0]).addStatement("int offset = offset()", new Object[0]).addStatement("int newLimit = offset + FIELD_SIZE_VALUE", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement(String.format("buffer.put%s(offset, %svalue.%s()%s)", bufferType, castType, methodName, unsignedHex), new Object[0]).addStatement("limit(newLimit)", new Object[0]);
            }
            return builder.addStatement("valueSet = true", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec buildMethod() {
            return MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).beginControlFlow("if (!valueSet)", new Object[0]).addStatement("throw new IllegalStateException($S)", new Object[]{String.format("%s not set", this.enumTypeName.simpleName())}).endControlFlow().addStatement("return super.build()", new Object[0]).returns((TypeName)this.enumName).build();
        }

        private boolean isParameterizedType() {
            return this.valueTypeName != null;
        }

        private boolean isTypeUnsignedInt() {
            return this.valueTypeName != null && this.unsignedValueTypeName != null;
        }
    }
}

