/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.generate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.lang.model.element.Modifier;
import org.reaktivity.nukleus.maven.plugin.internal.generate.ClassSpecGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeNames;

public final class MapFWGenerator
extends ClassSpecGenerator {
    private final TypeSpec.Builder classBuilder;
    private final TypeVariableName typeVarK;
    private final TypeVariableName typeVarV;
    private final BuilderClassBuilder builderClassBuilder;

    public MapFWGenerator(ClassName flyweightType) {
        super(flyweightType.peerClass("MapFW"));
        this.typeVarK = TypeVariableName.get((String)"K", (TypeName[])new TypeName[]{flyweightType});
        this.typeVarV = TypeVariableName.get((String)"V", (TypeName[])new TypeName[]{flyweightType});
        this.classBuilder = TypeSpec.classBuilder((ClassName)((ClassName)this.thisName)).superclass((TypeName)flyweightType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addTypeVariable(this.typeVarK).addTypeVariable(this.typeVarV);
        this.builderClassBuilder = new BuilderClassBuilder((ClassName)this.thisName, flyweightType);
    }

    @Override
    public TypeSpec generate() {
        return this.classBuilder.addMethod(this.lengthMethod()).addMethod(this.fieldCountMethod()).addMethod(this.forEachMethod()).addMethod(this.entriesMethod()).addType(this.builderClassBuilder.build()).build();
    }

    private MethodSpec lengthMethod() {
        return MethodSpec.methodBuilder((String)"length").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(Integer.TYPE).build();
    }

    private MethodSpec fieldCountMethod() {
        return MethodSpec.methodBuilder((String)"fieldCount").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(Integer.TYPE).build();
    }

    private MethodSpec forEachMethod() {
        ParameterizedTypeName parameterizedConsumerType = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{this.typeVarV});
        ParameterizedTypeName parameterizedFunctionType = ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{this.typeVarK, parameterizedConsumerType});
        return MethodSpec.methodBuilder((String)"forEach").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)parameterizedFunctionType, "consumer", new Modifier[0]).build();
    }

    private MethodSpec entriesMethod() {
        return MethodSpec.methodBuilder((String)"entries").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)TypeNames.DIRECT_BUFFER_TYPE).build();
    }

    private static final class BuilderClassBuilder {
        private final TypeSpec.Builder classBuilder;
        private final TypeVariableName typeVarT;
        private final TypeVariableName typeVarKB;
        private final TypeVariableName typeVarVB;
        private final TypeName parameterizedBuilderType;

        private BuilderClassBuilder(ClassName mapType, ClassName flyweightType) {
            ClassName builderType = mapType.nestedClass("Builder");
            ClassName flyweightBuilderType = flyweightType.nestedClass("Builder");
            TypeVariableName typeVarK = TypeVariableName.get((String)"K", (TypeName[])new TypeName[]{flyweightType});
            this.typeVarKB = TypeVariableName.get((String)"KB", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)flyweightBuilderType, (TypeName[])new TypeName[]{typeVarK})});
            TypeVariableName typeVarV = TypeVariableName.get((String)"V", (TypeName[])new TypeName[]{flyweightType});
            this.typeVarVB = TypeVariableName.get((String)"VB", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)flyweightBuilderType, (TypeName[])new TypeName[]{typeVarV})});
            this.typeVarT = TypeVariableName.get((String)"T", (TypeName[])new TypeName[]{mapType});
            this.parameterizedBuilderType = ParameterizedTypeName.get((ClassName)builderType, (TypeName[])new TypeName[]{this.typeVarT, typeVarK, typeVarV, this.typeVarKB, this.typeVarVB});
            this.classBuilder = TypeSpec.classBuilder((String)builderType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT, Modifier.STATIC}).superclass((TypeName)ParameterizedTypeName.get((ClassName)flyweightBuilderType, (TypeName[])new TypeName[]{this.typeVarT})).addTypeVariable(this.typeVarT).addTypeVariable(typeVarK).addTypeVariable(typeVarV).addTypeVariable(this.typeVarKB).addTypeVariable(this.typeVarVB);
        }

        public TypeSpec build() {
            return this.classBuilder.addMethod(this.constructor()).addMethod(this.entryMethod()).addMethod(this.entriesMethod()).build();
        }

        private MethodSpec constructor() {
            return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.typeVarT, "flyweight", new Modifier[0]).addStatement("super(flyweight)", new Object[0]).build();
        }

        private MethodSpec entryMethod() {
            ClassName consumerRawType = ClassName.get(Consumer.class);
            ParameterizedTypeName consumerKeyType = ParameterizedTypeName.get((ClassName)consumerRawType, (TypeName[])new TypeName[]{this.typeVarKB});
            ParameterizedTypeName consumerValueType = ParameterizedTypeName.get((ClassName)consumerRawType, (TypeName[])new TypeName[]{this.typeVarVB});
            return MethodSpec.methodBuilder((String)"entry").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(this.parameterizedBuilderType).addParameter((TypeName)consumerKeyType, "key", new Modifier[0]).addParameter((TypeName)consumerValueType, "value", new Modifier[0]).build();
        }

        private MethodSpec entriesMethod() {
            return MethodSpec.methodBuilder((String)"entries").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(this.parameterizedBuilderType).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "srcOffset", new Modifier[0]).addParameter(Integer.TYPE, "length", new Modifier[0]).addParameter(Integer.TYPE, "fieldCount", new Modifier[0]).build();
        }
    }
}

