/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.ast.visit;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstEnumNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstUnionNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstValueNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstVariantNode;
import org.reaktivity.nukleus.maven.plugin.internal.generate.EnumFlyweightGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.EnumTypeGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeSpecGenerator;

public final class EnumVisitor
extends AstNode.Visitor<Collection<TypeSpecGenerator<?>>> {
    private final EnumTypeGenerator typeGenerator;
    private final List<TypeSpecGenerator<?>> defaultResult;

    public EnumVisitor(EnumTypeGenerator typeGenerator, EnumFlyweightGenerator flyweightGenerator) {
        this.typeGenerator = typeGenerator;
        this.defaultResult = Arrays.asList(flyweightGenerator, typeGenerator);
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitEnum(AstEnumNode enumNode) {
        super.visitEnum(enumNode);
        return this.defaultResult();
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitUnion(AstUnionNode unionNode) {
        return this.defaultResult();
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitVariant(AstVariantNode variantNode) {
        return this.defaultResult();
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitValue(AstValueNode valueNode) {
        this.typeGenerator.addValue(valueNode.name(), valueNode.value());
        return this.defaultResult();
    }

    @Override
    protected Collection<TypeSpecGenerator<?>> defaultResult() {
        return this.defaultResult;
    }
}

