/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.generate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.lang.model.element.Modifier;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstByteOrder;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstEnumNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstNamedNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstType;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstTypedefNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstVariantNode;
import org.reaktivity.nukleus.maven.plugin.internal.generate.ClassSpecGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.ClassSpecMixinGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.MethodSpecGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeNames;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeResolver;

public final class ListFlyweightGenerator
extends ClassSpecGenerator {
    private static final Map<TypeName, String> GETTER_NAMES;
    private static final Map<TypeName, String> PUTTER_NAMES;
    private static final Map<TypeName, String[]> UNSIGNED_INT_RANGES;
    private static final Map<TypeName, String> TYPE_NAMES;
    private static final Set<String> RESERVED_METHOD_NAMES;
    private static final String LENGTH = "LENGTH";
    private static final String FIELD_COUNT = "FIELD_COUNT";
    private static final String BIT_MASK = "BIT_MASK";
    private static final String FIRST_FIELD = "FIRST_FIELD";
    private final String baseName;
    private final TypeSpec.Builder builder;
    private final MemberSizeConstantGenerator memberSizeConstant;
    private final MemberOffsetConstantGenerator memberOffsetConstant;
    private final MaskConstantGenerator maskConstant;
    private final FieldIndexConstantGenerator fieldIndexConstant;
    private final DefaultValueConstantGenerator defaultValueConstant;
    private final MissingFieldByteConstantGenerator nullValueConstant;
    private final TemplateTypeFieldGenerator templateTypeField;
    private final MemberFieldGenerator memberField;
    private final OptionalOffsetsFieldGenerator optionalOffsets;
    private final LengthMethodGenerator lengthMethod;
    private final FieldCountMethodGenerator fieldCountMethod;
    private final FieldsMethodGenerator fieldsMethod;
    private final MemberAccessorGenerator memberAccessor;
    private final HasFieldMethodGenerator hasFieldMethod;
    private final WrapMethodGenerator wrapMethod;
    private final TryWrapMethodGenerator tryWrapMethod;
    private final LimitMethodGenerator limitMethod;
    private final ToStringMethodGenerator toStringMethod;
    private final BuilderClassGenerator builderClass;

    public ListFlyweightGenerator(ClassName listName, ClassName listFWName, String baseName, AstType templateType, TypeName lengthTypeName, TypeName fieldCountTypeName, Byte missingFieldByte, TypeResolver resolver, AstByteOrder byteOrder) {
        super(listName);
        this.baseName = baseName;
        this.builder = this.builder(listName, templateType, resolver);
        this.memberSizeConstant = new MemberSizeConstantGenerator(listName, this.builder, templateType, lengthTypeName, fieldCountTypeName, missingFieldByte);
        this.memberOffsetConstant = new MemberOffsetConstantGenerator(listName, this.builder, templateType, missingFieldByte);
        this.maskConstant = new MaskConstantGenerator(listName, this.builder);
        this.fieldIndexConstant = new FieldIndexConstantGenerator(listName, this.builder);
        this.defaultValueConstant = new DefaultValueConstantGenerator(listName, this.builder, resolver);
        this.nullValueConstant = new MissingFieldByteConstantGenerator(listName, this.builder, missingFieldByte, templateType, resolver);
        this.templateTypeField = new TemplateTypeFieldGenerator(listName, this.builder, templateType, resolver);
        this.memberField = new MemberFieldGenerator(listName, this.builder, resolver);
        this.optionalOffsets = new OptionalOffsetsFieldGenerator(listName, this.builder, templateType, missingFieldByte);
        this.lengthMethod = new LengthMethodGenerator(listName, this.builder, templateType, resolver);
        this.fieldCountMethod = new FieldCountMethodGenerator(listName, this.builder, templateType, fieldCountTypeName, resolver, byteOrder);
        this.fieldsMethod = new FieldsMethodGenerator(listName, this.builder, templateType, resolver);
        this.memberAccessor = new MemberAccessorGenerator(listName, this.builder, templateType, resolver, missingFieldByte, byteOrder);
        this.hasFieldMethod = new HasFieldMethodGenerator(listName, this.builder, templateType, missingFieldByte);
        this.wrapMethod = new WrapMethodGenerator(missingFieldByte, templateType, resolver);
        this.tryWrapMethod = new TryWrapMethodGenerator(missingFieldByte, templateType, resolver);
        this.limitMethod = new LimitMethodGenerator(lengthTypeName, templateType, resolver, byteOrder);
        this.toStringMethod = new ToStringMethodGenerator(missingFieldByte, templateType);
        this.builderClass = new BuilderClassGenerator(listName, listFWName, templateType, lengthTypeName, fieldCountTypeName, resolver, missingFieldByte);
    }

    public ListFlyweightGenerator addMember(String name, AstType type, TypeName typeName, TypeName unsignedTypeName, boolean usedAsSize, Object defaultValue, AstByteOrder byteOrder, boolean isRequired, AstType arrayItemTypeName, AstType variantOfMapKeyType, AstType variantOfMapValueType, ClassName mapParamName, ClassName originalMapKeyName, ClassName originalMapValueName) {
        this.memberSizeConstant.addMember(name, typeName);
        this.fieldIndexConstant.addMember(name);
        this.maskConstant.addMember(name);
        this.defaultValueConstant.addMember(name, type, typeName, unsignedTypeName, defaultValue);
        this.memberField.addMember(name, type, typeName, byteOrder, arrayItemTypeName, variantOfMapKeyType, variantOfMapValueType, mapParamName, originalMapKeyName, originalMapValueName);
        this.optionalOffsets.addMember(name);
        this.memberAccessor.addMember(name, type, typeName, unsignedTypeName, byteOrder, isRequired, defaultValue, arrayItemTypeName, variantOfMapKeyType, variantOfMapValueType, mapParamName);
        this.hasFieldMethod.addMember(name);
        this.wrapMethod.addMember(name, typeName, defaultValue, isRequired);
        this.tryWrapMethod.addMember(name, typeName, defaultValue, isRequired);
        this.toStringMethod.addMember(name, typeName, defaultValue, isRequired);
        this.builderClass.addMember(name, type, typeName, unsignedTypeName, usedAsSize, byteOrder, isRequired, arrayItemTypeName, variantOfMapKeyType, variantOfMapValueType, mapParamName, originalMapKeyName, originalMapValueName);
        return this;
    }

    @Override
    public TypeSpec generate() {
        this.memberSizeConstant.build();
        this.memberOffsetConstant.build();
        this.maskConstant.build();
        this.fieldIndexConstant.build();
        this.defaultValueConstant.build();
        this.nullValueConstant.build();
        this.templateTypeField.build();
        this.memberField.build();
        this.optionalOffsets.build();
        this.lengthMethod.build();
        this.fieldCountMethod.build();
        this.fieldsMethod.build();
        this.memberAccessor.build();
        this.hasFieldMethod.build();
        return this.builder.addField(this.bitmask()).addMethod(this.wrapMethod.generate()).addMethod(this.tryWrapMethod.generate()).addMethod(this.limitMethod.generate()).addMethod(this.toStringMethod.generate()).addType(this.builderClass.generate()).build();
    }

    private TypeSpec.Builder builder(ClassName listName, AstType templateType, TypeResolver resolver) {
        ClassName flyweightName = templateType == null ? resolver.flyweightName() : resolver.resolveClass(AstType.LIST);
        return TypeSpec.classBuilder((ClassName)listName).superclass((TypeName)flyweightName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
    }

    private FieldSpec bitmask() {
        return FieldSpec.builder(Long.TYPE, (String)"bitmask", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
    }

    private static boolean isOctetsType(TypeName type) {
        return type instanceof ClassName && "OctetsFW".equals(((ClassName)type).simpleName());
    }

    private static boolean isStringType(ClassName classType) {
        return ListFlyweightGenerator.isString8Type(classType) || ListFlyweightGenerator.isString16Type(classType) || ListFlyweightGenerator.isString32Type(classType);
    }

    private static boolean isArrayType(AstType type) {
        return AstType.ARRAY.equals(type) || AstType.ARRAY8.equals(type) || AstType.ARRAY16.equals(type) || AstType.ARRAY32.equals(type);
    }

    private static boolean isString8Type(ClassName classType) {
        String name = classType.simpleName();
        return "String8FW".equals(name);
    }

    private static boolean isString16Type(ClassName classType) {
        String name = classType.simpleName();
        return "String16FW".equals(name);
    }

    private static boolean isString32Type(ClassName classType) {
        String name = classType.simpleName();
        return "String32FW".equals(name);
    }

    private static boolean isEnumType(AstNamedNode.Kind kind) {
        return AstNamedNode.Kind.ENUM.equals((Object)kind);
    }

    private static boolean isVariantType(AstNamedNode.Kind kind) {
        return AstNamedNode.Kind.VARIANT.equals((Object)kind);
    }

    private static boolean isMapType(AstNamedNode.Kind kind) {
        return AstNamedNode.Kind.MAP.equals((Object)kind);
    }

    private static boolean isListType(AstNamedNode.Kind kind) {
        return AstNamedNode.Kind.LIST.equals((Object)kind);
    }

    private static boolean isTypedefType(AstNamedNode.Kind kind) {
        return AstNamedNode.Kind.TYPEDEF.equals((Object)kind);
    }

    private static boolean isVarintType(TypeName type) {
        return type instanceof ClassName && "Varint32FW".equals(((ClassName)type).simpleName()) || type instanceof ClassName && "Varint64FW".equals(((ClassName)type).simpleName());
    }

    private static boolean isVarint32Type(TypeName type) {
        return type instanceof ClassName && "Varint32FW".equals(((ClassName)type).simpleName());
    }

    private static boolean isVarint64Type(TypeName type) {
        return type instanceof ClassName && "Varint64FW".equals(((ClassName)type).simpleName());
    }

    private static ClassName enumClassName(TypeName enumFWTypeName) {
        String enumFWName = ((ClassName)enumFWTypeName).simpleName();
        return ClassName.bestGuess((String)enumFWName.substring(0, enumFWName.length() - 2));
    }

    private static String variantRW(ClassName className) {
        String variantFWName = className.simpleName();
        return String.format("%s%sRW", Character.valueOf(Character.toLowerCase(variantFWName.charAt(0))), variantFWName.substring(1, variantFWName.length() - 2));
    }

    private static String variantRO(ClassName className) {
        String variantFWName = className.simpleName();
        return String.format("%s%sRO", Character.valueOf(Character.toLowerCase(variantFWName.charAt(0))), variantFWName.substring(1, variantFWName.length() - 2));
    }

    private static String arraySize(String fieldName) {
        return String.format("ARRAY_SIZE_%s", ListFlyweightGenerator.constant(fieldName));
    }

    private static String fieldOffset(String fieldName) {
        return String.format("FIELD_OFFSET_%s", ListFlyweightGenerator.constant(fieldName));
    }

    private static String defaultConstant(String fieldName) {
        return String.format("DEFAULT_VALUE_%s", ListFlyweightGenerator.constant(fieldName));
    }

    private static String maskConstant(String fieldName) {
        return String.format("MASK_%s", ListFlyweightGenerator.constant(fieldName));
    }

    private static String offset(String name) {
        return String.format("%s_OFFSET", ListFlyweightGenerator.constant(name));
    }

    private static String fieldSize(String fieldName) {
        return String.format("FIELD_SIZE_%s", ListFlyweightGenerator.constant(fieldName));
    }

    private static String size(String name) {
        return String.format("%s_SIZE", ListFlyweightGenerator.constant(name));
    }

    private static String fieldIndex(String fieldName) {
        return String.format("INDEX_%s", ListFlyweightGenerator.constant(fieldName));
    }

    private static String defaultMethodName(String name) {
        return String.format("default%s%s", Character.valueOf(Character.toUpperCase(name.charAt(0))), name.substring(1));
    }

    private static String constant(String fieldName) {
        return fieldName.replaceAll("([^_A-Z])([A-Z])", "$1_$2").toUpperCase();
    }

    private static String methodName(String name) {
        return RESERVED_METHOD_NAMES.contains(name) ? name + "$" : name;
    }

    static {
        HashMap<TypeName, String> getterNames = new HashMap<TypeName, String>();
        getterNames.put(TypeName.BYTE, "getByte");
        getterNames.put(TypeName.SHORT, "getShort");
        getterNames.put(TypeName.INT, "getInt");
        getterNames.put(TypeName.LONG, "getLong");
        GETTER_NAMES = Collections.unmodifiableMap(getterNames);
        HashMap<TypeName, String> putterNames = new HashMap<TypeName, String>();
        putterNames.put(TypeName.BYTE, "putByte");
        putterNames.put(TypeName.SHORT, "putShort");
        putterNames.put(TypeName.INT, "putInt");
        putterNames.put(TypeName.LONG, "putLong");
        PUTTER_NAMES = Collections.unmodifiableMap(putterNames);
        HashMap<TypeName, String[]> unsigned = new HashMap<TypeName, String[]>();
        unsigned.put(TypeName.BYTE, new String[]{"0", "0xFFFF_FFFF_FFFF_FF00L"});
        unsigned.put(TypeName.SHORT, new String[]{"0", "0xFFFF_FFFF_FFFF_0000L"});
        unsigned.put(TypeName.INT, new String[]{"0", "0xFFFF_FFFF_0000_0000L"});
        unsigned.put(TypeName.LONG, new String[]{"0L", null});
        UNSIGNED_INT_RANGES = Collections.unmodifiableMap(unsigned);
        HashMap<TypeName, String> sizeofByName = new HashMap<TypeName, String>();
        sizeofByName.put(TypeName.BYTE, "BYTE");
        sizeofByName.put(TypeName.SHORT, "SHORT");
        sizeofByName.put(TypeName.INT, "INT");
        sizeofByName.put(TypeName.LONG, "LONG");
        TYPE_NAMES = Collections.unmodifiableMap(sizeofByName);
        RESERVED_METHOD_NAMES = new HashSet<String>(Arrays.asList("offset", "buffer", "limit", "sizeof", "maxLimit", "wrap", "checkLimit", "build", "rewrap"));
    }

    private static class ListField {
        private String fieldName;
        private TypeName type;
        private boolean isRequired;
        private Object defaultValue;

        ListField(String fieldName, TypeName type, boolean isRequired, Object defaultValue) {
            this.fieldName = fieldName;
            this.type = type;
            this.isRequired = isRequired;
            this.defaultValue = defaultValue;
        }

        public String fieldName() {
            return this.fieldName;
        }

        public TypeName type() {
            return this.type;
        }

        public boolean isRequired() {
            return this.isRequired;
        }

        public Object defaultValue() {
            return this.defaultValue;
        }
    }

    private static final class BuilderClassGenerator
    extends ClassSpecGenerator {
        private final TypeSpec.Builder builder;
        private final ClassName listType;
        private final FieldsMaskGenerator fieldsMask;
        private final MemberFieldGenerator memberField;
        private final TemplateTypeRWGenerator templateTypeRW;
        private final MemberAccessorGenerator memberAccessor;
        private final MemberMutatorGenerator memberMutator;
        private final FieldMethodGenerator fieldMethod;
        private final FieldsMethodWithVisitorGenerator fieldsMethodWithVisitor;
        private final FieldsMethodWithBufferGenerator fieldsMethodWithBuffer;
        private final WrapMethodGenerator wrapMethod;
        private final BuildMethodGenerator buildMethod;

        private BuilderClassGenerator(ClassName listType, ClassName listFWName, AstType templateType, TypeName lengthTypeName, TypeName fieldCountTypeName, TypeResolver resolver, Byte nullValue) {
            this(listType.nestedClass("Builder"), listFWName.nestedClass("Builder"), listType, templateType, lengthTypeName, fieldCountTypeName, resolver, nullValue);
        }

        private BuilderClassGenerator(ClassName thisType, ClassName listFWBuilderRawType, ClassName listType, AstType templateType, TypeName lengthTypeName, TypeName fieldCountTypeName, TypeResolver resolver, Byte nullValue) {
            super(thisType);
            this.listType = listType;
            this.builder = this.builder(listFWBuilderRawType, templateType, resolver);
            this.fieldsMask = new FieldsMaskGenerator(thisType, this.builder, nullValue, templateType);
            this.memberField = new MemberFieldGenerator(thisType, this.builder, resolver);
            this.templateTypeRW = new TemplateTypeRWGenerator(thisType, this.builder, templateType, resolver);
            this.memberAccessor = new MemberAccessorGenerator(thisType, this.builder, templateType, resolver, nullValue);
            this.memberMutator = new MemberMutatorGenerator(thisType, this.builder, templateType, resolver, nullValue);
            this.fieldMethod = new FieldMethodGenerator(nullValue, templateType, resolver);
            this.fieldsMethodWithVisitor = new FieldsMethodWithVisitorGenerator(nullValue, templateType, resolver);
            this.fieldsMethodWithBuffer = new FieldsMethodWithBufferGenerator(nullValue, templateType, resolver);
            this.wrapMethod = new WrapMethodGenerator(nullValue, templateType, resolver);
            this.buildMethod = new BuildMethodGenerator(templateType, lengthTypeName, fieldCountTypeName, nullValue, resolver);
        }

        private void addMember(String name, AstType type, TypeName typeName, TypeName unsignedType, boolean usedAsSize, AstByteOrder byteOrder, boolean isRequired, AstType arrayItemTypeName, AstType mapKeyType, AstType mapValueType, ClassName mapParamName, ClassName originalMapKeyName, ClassName originalMapValueName) {
            this.memberField.addMember(name, typeName, byteOrder, arrayItemTypeName, mapKeyType, mapValueType, mapParamName, originalMapKeyName, originalMapValueName);
            this.memberAccessor.addMember(name, type, typeName, isRequired);
            this.memberMutator.addMember(name, type, typeName, unsignedType, usedAsSize, byteOrder, isRequired, arrayItemTypeName, mapKeyType, mapValueType, mapParamName);
            this.fieldMethod.addMember(name);
            this.fieldsMethodWithVisitor.addMember(name);
            this.fieldsMethodWithBuffer.addMember(name);
            this.buildMethod.addMember(name, isRequired, byteOrder);
        }

        @Override
        public TypeSpec generate() {
            this.fieldsMask.build();
            this.memberField.build();
            this.templateTypeRW.build();
            this.memberAccessor.build();
            this.memberMutator.build();
            this.fieldMethod.mixin(this.builder);
            this.fieldsMethodWithVisitor.mixin(this.builder);
            this.fieldsMethodWithBuffer.mixin(this.builder);
            return this.builder.addMethod(this.constructor()).addMethod(this.wrapMethod.generate()).addMethod(this.buildMethod.generate()).build();
        }

        private TypeSpec.Builder builder(ClassName listBuilderName, AstType templateType, TypeResolver resolver) {
            ClassName flyweightBuilderName = templateType == null ? resolver.flyweightName().nestedClass("Builder") : listBuilderName;
            return TypeSpec.classBuilder((String)listBuilderName.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).superclass((TypeName)ParameterizedTypeName.get((ClassName)flyweightBuilderName, (TypeName[])new TypeName[]{this.listType}));
        }

        private MethodSpec constructor() {
            return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super(new $T())", new Object[]{this.listType}).build();
        }

        private final class BuildMethodGenerator
        extends MethodSpecGenerator {
            private final TypeResolver resolver;
            private final AstType templateType;
            private final TypeName lengthTypeName;
            private final TypeName fieldCountTypeName;
            private final Byte nullValue;
            private AstByteOrder byteOrder;
            private int position;
            private Map<String, Integer> requiredFieldPosition;

            private BuildMethodGenerator(AstType templateType, TypeName lengthTypeName, TypeName fieldCountTypeName, Byte nullValue, TypeResolver resolver) {
                super(MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)BuilderClassGenerator.this.listType));
                this.requiredFieldPosition = new HashMap<String, Integer>();
                this.resolver = resolver;
                this.templateType = templateType;
                this.lengthTypeName = lengthTypeName;
                this.fieldCountTypeName = fieldCountTypeName;
                this.nullValue = nullValue;
                this.byteOrder = AstByteOrder.NATIVE;
            }

            public BuildMethodGenerator addMember(String name, boolean isRequired, AstByteOrder byteOrder) {
                if (this.byteOrder == AstByteOrder.NATIVE && byteOrder == AstByteOrder.NETWORK) {
                    this.byteOrder = byteOrder;
                }
                if (isRequired) {
                    if (this.nullValue == null && this.templateType == null) {
                        this.requiredFieldPosition.put(name, 1 << this.position);
                        this.builder.addStatement("assert (fieldsMask & $L) != 0 : \"Required field \\\"$L\\\" is not set\"", new Object[]{String.format("0x%02X", this.requiredFieldPosition.get(name)), name});
                    } else {
                        this.builder.addStatement("assert lastFieldSet >= $L : \"Required field \\\"$L\\\" is not set\"", new Object[]{ListFlyweightGenerator.fieldIndex(name), name});
                    }
                }
                ++this.position;
                return this;
            }

            @Override
            public MethodSpec generate() {
                String putLength;
                if (this.templateType != null) {
                    ClassName templateTypeName = this.resolver.resolveClass(this.templateType);
                    return this.builder.addStatement("limit($L.build().limit())", new Object[]{ListFlyweightGenerator.variantRW(templateTypeName)}).addStatement("return super.build()", new Object[0]).build();
                }
                String string = this.lengthTypeName.equals((Object)TypeName.BYTE) ? "buffer().$L(offset() + $L, (byte) (limit() - offset()))" : (putLength = String.format("buffer().$L(offset() + $L, limit() - offset()%s)", this.byteOrder == AstByteOrder.NATIVE ? "" : ", $T.BIG_ENDIAN"));
                if (this.nullValue == null) {
                    return this.generateBuild(putLength);
                }
                return this.generateBuildWithDefaultNull(putLength);
            }

            private MethodSpec generateBuild(String putLength) {
                String putFieldCount;
                String string = this.fieldCountTypeName.equals((Object)TypeName.BYTE) ? "buffer().$L(offset() + $L, (byte) (Long.bitCount(fieldsMask)))" : (putFieldCount = String.format("buffer().$L(offset() + $L, Long.bitCount(fieldsMask)%s)", this.byteOrder == AstByteOrder.NATIVE ? "" : ", $T.BIG_ENDIAN"));
                if (this.byteOrder == AstByteOrder.NETWORK && !this.fieldCountTypeName.equals((Object)TypeName.BYTE)) {
                    this.builder.addStatement(putLength, new Object[]{PUTTER_NAMES.get(this.lengthTypeName), ListFlyweightGenerator.offset(ListFlyweightGenerator.LENGTH), ByteOrder.class}).addStatement(putFieldCount, new Object[]{PUTTER_NAMES.get(this.fieldCountTypeName), ListFlyweightGenerator.offset(ListFlyweightGenerator.FIELD_COUNT), ByteOrder.class}).addStatement("buffer().putLong(offset() + $L, fieldsMask, $T.BIG_ENDIAN)", new Object[]{ListFlyweightGenerator.offset(ListFlyweightGenerator.BIT_MASK), ByteOrder.class});
                } else {
                    this.builder.addStatement(putLength, new Object[]{PUTTER_NAMES.get(this.lengthTypeName), ListFlyweightGenerator.offset(ListFlyweightGenerator.LENGTH)}).addStatement(putFieldCount, new Object[]{PUTTER_NAMES.get(this.fieldCountTypeName), ListFlyweightGenerator.offset(ListFlyweightGenerator.FIELD_COUNT)}).addStatement("buffer().putLong(offset() + $L, fieldsMask)", new Object[]{ListFlyweightGenerator.offset(ListFlyweightGenerator.BIT_MASK)});
                }
                return this.builder.addStatement("return super.build()", new Object[0]).build();
            }

            private MethodSpec generateBuildWithDefaultNull(String putLength) {
                String putFieldCount;
                String string = this.fieldCountTypeName.equals((Object)TypeName.BYTE) ? "buffer().$L(offset() + $L, (byte) (lastFieldSet + 1))" : (putFieldCount = String.format("buffer().$L(offset() + $L, lastFieldSet + 1%s)", this.byteOrder == AstByteOrder.NATIVE ? "" : ", $T.BIG_ENDIAN"));
                if (this.byteOrder == AstByteOrder.NETWORK && !this.fieldCountTypeName.equals((Object)TypeName.BYTE)) {
                    this.builder.addStatement(putLength, new Object[]{PUTTER_NAMES.get(this.lengthTypeName), ListFlyweightGenerator.offset(ListFlyweightGenerator.LENGTH), ByteOrder.class}).addStatement(putFieldCount, new Object[]{PUTTER_NAMES.get(this.fieldCountTypeName), ListFlyweightGenerator.offset(ListFlyweightGenerator.FIELD_COUNT), ByteOrder.class});
                } else {
                    this.builder.addStatement(putLength, new Object[]{PUTTER_NAMES.get(this.lengthTypeName), ListFlyweightGenerator.offset(ListFlyweightGenerator.LENGTH)}).addStatement(putFieldCount, new Object[]{PUTTER_NAMES.get(this.fieldCountTypeName), ListFlyweightGenerator.offset(ListFlyweightGenerator.FIELD_COUNT)});
                }
                return this.builder.addStatement("return super.build()", new Object[0]).build();
            }
        }

        private final class WrapMethodGenerator
        extends MethodSpecGenerator {
            private final Byte nullValue;
            private final AstType templateType;
            private final TypeResolver resolver;

            private WrapMethodGenerator(Byte nullValue, AstType templateType, TypeResolver resolver) {
                super(MethodSpec.methodBuilder((String)"wrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.MUTABLE_DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(BuilderClassGenerator.this.thisName));
                this.nullValue = nullValue;
                this.templateType = templateType;
                this.resolver = resolver;
            }

            @Override
            public MethodSpec generate() {
                this.builder.addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]);
                if (this.templateType == null) {
                    this.builder.addStatement(this.nullValue == null ? "fieldsMask = 0" : "lastFieldSet = -1", new Object[0]).addStatement("int newLimit = limit() + $L", new Object[]{ListFlyweightGenerator.offset(ListFlyweightGenerator.FIRST_FIELD)}).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("limit(newLimit)", new Object[0]);
                } else {
                    this.builder.addStatement("lastFieldSet = -1", new Object[0]).addStatement("$L.wrap(buffer, offset, maxLimit)", new Object[]{ListFlyweightGenerator.variantRW(this.resolver.resolveClass(this.templateType))});
                }
                return this.builder.addStatement("return this", new Object[0]).build();
            }
        }

        private final class FieldsMethodWithBufferGenerator
        extends MethodSpecGenerator {
            private final Byte nullValue;
            private final AstType templateType;
            private final TypeResolver resolver;
            private String lastFieldName;

            private FieldsMethodWithBufferGenerator(Byte nullValue, AstType templateType, TypeResolver resolver) {
                super(MethodSpec.methodBuilder((String)"fields").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Integer.TYPE, "fieldCount", new Modifier[0]).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "index", new Modifier[0]).addParameter(Integer.TYPE, "length", new Modifier[0]).returns(BuilderClassGenerator.this.thisName));
                this.nullValue = nullValue;
                this.templateType = templateType;
                this.resolver = resolver;
            }

            public FieldsMethodWithBufferGenerator addMember(String name) {
                if (this.templateType != null) {
                    this.lastFieldName = name;
                }
                return this;
            }

            @Override
            public MethodSpec generate() {
                ClassName templateTypeName = this.resolver.resolveClass(this.templateType);
                return this.builder.addStatement("$L.fields(fieldCount, buffer, index, length)", new Object[]{ListFlyweightGenerator.variantRW(templateTypeName)}).addStatement("lastFieldSet = $L", new Object[]{this.lastFieldName != null ? ListFlyweightGenerator.fieldIndex(this.lastFieldName) : Integer.valueOf(-1)}).addStatement("return this", new Object[0]).build();
            }

            @Override
            public void mixin(TypeSpec.Builder builder) {
                if (this.templateType != null) {
                    super.mixin(builder);
                }
            }
        }

        private final class FieldsMethodWithVisitorGenerator
        extends MethodSpecGenerator {
            private final Byte nullValue;
            private final AstType templateType;
            private final TypeResolver resolver;
            private String lastFieldName;

            private FieldsMethodWithVisitorGenerator(Byte nullValue, AstType templateType, TypeResolver resolver) {
                super(MethodSpec.methodBuilder((String)"fields").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Integer.TYPE, "fieldCount", new Modifier[0]).addParameter((TypeName)resolver.flyweightName().nestedClass("Builder").nestedClass("Visitor"), "visitor", new Modifier[0]).returns(BuilderClassGenerator.this.thisName));
                this.nullValue = nullValue;
                this.templateType = templateType;
                this.resolver = resolver;
            }

            public FieldsMethodWithVisitorGenerator addMember(String name) {
                if (this.templateType != null) {
                    this.lastFieldName = name;
                }
                return this;
            }

            @Override
            public MethodSpec generate() {
                ClassName templateTypeName = this.resolver.resolveClass(this.templateType);
                return this.builder.addStatement("$L.fields(fieldCount, visitor)", new Object[]{ListFlyweightGenerator.variantRW(templateTypeName)}).addStatement("lastFieldSet = $L", new Object[]{this.lastFieldName != null ? ListFlyweightGenerator.fieldIndex(this.lastFieldName) : Integer.valueOf(-1)}).addStatement("return this", new Object[0]).build();
            }

            @Override
            public void mixin(TypeSpec.Builder builder) {
                if (this.templateType != null) {
                    super.mixin(builder);
                }
            }
        }

        private final class FieldMethodGenerator
        extends MethodSpecGenerator {
            private final Byte nullValue;
            private final AstType templateType;
            private final TypeResolver resolver;
            private String lastFieldName;

            private FieldMethodGenerator(Byte nullValue, AstType templateType, TypeResolver resolver) {
                super(MethodSpec.methodBuilder((String)"field").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)resolver.flyweightName().nestedClass("Builder").nestedClass("Visitor"), "visitor", new Modifier[0]).returns(BuilderClassGenerator.this.thisName));
                this.nullValue = nullValue;
                this.templateType = templateType;
                this.resolver = resolver;
            }

            public FieldMethodGenerator addMember(String name) {
                if (this.templateType != null) {
                    this.lastFieldName = name;
                }
                return this;
            }

            @Override
            public MethodSpec generate() {
                ClassName templateTypeName = this.resolver.resolveClass(this.templateType);
                return this.builder.addStatement("$L.field(visitor)", new Object[]{ListFlyweightGenerator.variantRW(templateTypeName)}).addStatement("lastFieldSet = $L", new Object[]{this.lastFieldName != null ? ListFlyweightGenerator.fieldIndex(this.lastFieldName) : Integer.valueOf(-1)}).addStatement("return this", new Object[0]).build();
            }

            @Override
            public void mixin(TypeSpec.Builder builder) {
                if (this.templateType != null) {
                    super.mixin(builder);
                }
            }
        }

        private static final class MemberMutatorGenerator
        extends ClassSpecMixinGenerator {
            private final AstType templateType;
            private final TypeResolver resolver;
            private final Byte nullValue;
            private int bitsOfOnes;
            private int position;
            private String priorRequiredFieldName = null;
            private String priorFieldName = null;
            private Map<String, Integer> requiredFieldPosition = new HashMap<String, Integer>();
            private List<MethodSpec> defaultNullMutators = new ArrayList<MethodSpec>();

            private MemberMutatorGenerator(ClassName thisType, TypeSpec.Builder builder, AstType templateType, TypeResolver resolver, Byte nullValue) {
                super(thisType, builder);
                this.templateType = templateType;
                this.resolver = resolver;
                this.nullValue = nullValue;
            }

            public MemberMutatorGenerator addMember(String name, AstType type, TypeName typeName, TypeName unsignedType, boolean usedAsSize, AstByteOrder byteOrder, boolean isRequired, AstType arrayItemTypeName, AstType mapKeyType, AstType mapValueType, ClassName mapParamName) {
                if (typeName.isPrimitive()) {
                    this.addPrimitiveMember(name, typeName, unsignedType, usedAsSize, byteOrder);
                } else {
                    this.addNonPrimitiveMember(name, type, typeName, isRequired, arrayItemTypeName, mapKeyType, mapValueType, mapParamName);
                }
                this.bitsOfOnes = this.bitsOfOnes << 1 | 1;
                if (isRequired) {
                    this.requiredFieldPosition.put(name, 1 << this.position);
                    this.priorRequiredFieldName = name;
                }
                this.priorFieldName = name;
                ++this.position;
                return this;
            }

            private void addPrimitiveMember(String name, TypeName type, TypeName unsignedType, boolean usedAsSize, AstByteOrder byteOrder) {
                String putterName = (String)PUTTER_NAMES.get(type);
                if (putterName == null) {
                    throw new IllegalStateException("member type not supported: " + type);
                }
                TypeName generateType = unsignedType != null ? unsignedType : type;
                CodeBlock.Builder code = CodeBlock.builder();
                code.addStatement("assert (fieldsMask & ~$L) == 0 : \"Field \\\"$L\\\" cannot be set out of order\"", new Object[]{String.format("0x%02X", this.bitsOfOnes), name});
                if (unsignedType != null) {
                    String[] range = (String[])UNSIGNED_INT_RANGES.get(type);
                    code.beginControlFlow("if (value < $L)", new Object[]{range[0]}).addStatement("throw new IllegalArgumentException(String.format($S, value))", new Object[]{String.format("Value %%d too low for field \"%s\"", name)}).endControlFlow();
                    if (range[1] != null) {
                        code.addStatement("assert (value & $L) == 0L : \"Value out of range for field \\\"$L\\\"\"", new Object[]{range[1], name});
                    }
                }
                code.addStatement("int newLimit = limit() + $L", new Object[]{ListFlyweightGenerator.fieldSize(name)}).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).add("$[", new Object[0]).add("buffer().$L(limit(), ", new Object[]{putterName});
                if (generateType != type) {
                    code.add("($T)", new Object[]{type});
                    if (type == TypeName.BYTE) {
                        code.add("(value & 0xFF)", new Object[0]);
                    } else if (type == TypeName.SHORT) {
                        code.add("(value & 0xFFFF)", new Object[0]);
                    } else if (type == TypeName.INT) {
                        code.add("(value & 0xFFFF_FFFFL)", new Object[0]);
                    } else {
                        code.add("value", new Object[0]);
                    }
                } else {
                    code.add("value", new Object[0]);
                }
                if (byteOrder == AstByteOrder.NETWORK && (type == TypeName.SHORT || type == TypeName.INT || type == TypeName.LONG)) {
                    code.add(", $T.BIG_ENDIAN", new Object[]{ByteOrder.class});
                }
                code.add(");\n$]", new Object[0]);
                code.addStatement("fieldsMask |= 1 << $L", new Object[]{ListFlyweightGenerator.fieldIndex(name)}).addStatement("limit(newLimit)", new Object[0]).addStatement("return this", new Object[0]);
                this.builder.addMethod(MethodSpec.methodBuilder((String)ListFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{usedAsSize ? Modifier.PRIVATE : Modifier.PUBLIC}).addParameter(generateType, "value", new Modifier[0]).returns((TypeName)this.thisType).addCode(code.build()).build());
            }

            private void addNonPrimitiveMember(String name, AstType type, TypeName typeName, boolean isRequired, AstType arrayItemTypeName, AstType mapKeyType, AstType mapValueType, ClassName mapParamName) {
                ClassName className = (ClassName)typeName;
                AstNamedNode namedNode = this.resolver.resolve(type.name());
                if (ListFlyweightGenerator.isStringType(className)) {
                    this.addStringType(className, name);
                } else {
                    AstNamedNode.Kind kind = namedNode.getKind();
                    if (ListFlyweightGenerator.isTypedefType(kind)) {
                        AstTypedefNode typedefNode = (AstTypedefNode)namedNode;
                        type = typedefNode.originalType();
                        className = this.resolver.resolveClass(type);
                        kind = this.resolver.resolve(type.name()).getKind();
                        if (ListFlyweightGenerator.isTypedefType(kind)) {
                            this.addNonPrimitiveMember(name, type, this.resolver.resolveType(type), isRequired, arrayItemTypeName, mapKeyType, mapValueType, mapParamName);
                            return;
                        }
                    }
                    if (ListFlyweightGenerator.isEnumType(kind)) {
                        this.addEnumType(name, type, isRequired, className);
                    } else if (ListFlyweightGenerator.isVariantType(kind)) {
                        this.addVariantType(name, type, className, isRequired, arrayItemTypeName, mapKeyType, mapValueType);
                    } else if (ListFlyweightGenerator.isMapType(kind)) {
                        this.addMapType(name, isRequired, className, mapParamName);
                    } else if (ListFlyweightGenerator.isListType(kind)) {
                        this.addListType(name, isRequired, className);
                    } else {
                        this.addUnionType(name, isRequired, className);
                    }
                }
            }

            private void addUnionType(String name, boolean isRequired, ClassName className) {
                ClassName consumerType = ClassName.get(Consumer.class);
                ClassName builderType = className.nestedClass("Builder");
                TypeName parameterType = ListFlyweightGenerator.isVarint32Type((TypeName)className) ? TypeName.INT : (ListFlyweightGenerator.isVarint64Type((TypeName)className) ? TypeName.LONG : ParameterizedTypeName.get((ClassName)consumerType, (TypeName[])new TypeName[]{builderType}));
                MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)ListFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter((TypeName)className, "value", new Modifier[0]).addStatement("assert (fieldsMask & ~$L) == 0 : \"Field \\\"$L\\\" cannot be set out of order\"", new Object[]{String.format("0x%02X", this.bitsOfOnes), name});
                if (this.templateType == null) {
                    if (this.priorRequiredFieldName != null) {
                        methodBuilder.addStatement("assert (fieldsMask & $L) != 0 : \"Prior required field \\\"$L\\\" is not set\"", new Object[]{String.format("0x%02X", this.requiredFieldPosition.get(this.priorRequiredFieldName)), this.priorRequiredFieldName});
                    }
                    methodBuilder.addStatement("int newLimit = limit() + value.sizeof()", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("buffer().putBytes(limit(), value.buffer(), value.offset(), value.sizeof())", new Object[0]).addStatement("fieldsMask |= 1 << $L", new Object[]{ListFlyweightGenerator.fieldIndex(name)}).addStatement("limit(newLimit)", new Object[0]).addStatement("return this", new Object[0]);
                    this.builder.addMethod(methodBuilder.build());
                }
                methodBuilder = MethodSpec.methodBuilder((String)ListFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter(parameterType, "mutator", new Modifier[0]);
                ClassName templateClassName = this.resolver.resolveClass(this.templateType);
                if (this.templateType == null) {
                    methodBuilder.addStatement("assert (fieldsMask & ~$L) == 0 : \"Field \\\"$L\\\" cannot be set out of order\"", new Object[]{String.format("0x%02X", this.bitsOfOnes), name});
                } else {
                    methodBuilder.addStatement("assert lastFieldSet < $L : \"Field \\\"$L\\\" cannot be set out of order\"", new Object[]{ListFlyweightGenerator.fieldIndex(name), name});
                }
                if (this.priorRequiredFieldName != null) {
                    int priorRequiredFieldPosition = this.requiredFieldPosition.get(this.priorRequiredFieldName);
                    if (priorRequiredFieldPosition == 1 << this.position >> 1) {
                        if (this.templateType == null) {
                            methodBuilder.addStatement("assert (fieldsMask & $L) != 0 : \"Prior required field \\\"$L\\\" is not set\"", new Object[]{String.format("0x%02X", this.requiredFieldPosition.get(this.priorRequiredFieldName)), this.priorRequiredFieldName});
                        } else {
                            methodBuilder.addStatement("assert lastFieldSet == $L : \"Prior required field \\\"$L\\\" is not set\"", new Object[]{ListFlyweightGenerator.fieldIndex(this.priorRequiredFieldName), this.priorRequiredFieldName});
                        }
                    } else {
                        methodBuilder.beginControlFlow("if (lastFieldSet < $L)", new Object[]{ListFlyweightGenerator.fieldIndex(this.priorFieldName)}).addStatement("$L()", new Object[]{ListFlyweightGenerator.defaultMethodName(this.priorFieldName)}).endControlFlow();
                    }
                } else if (this.nullValue != null && this.priorFieldName != null) {
                    methodBuilder.beginControlFlow("if (lastFieldSet < $L)", new Object[]{ListFlyweightGenerator.fieldIndex(this.priorFieldName)}).addStatement(String.format("default%s%s()", Character.valueOf(Character.toUpperCase(this.priorFieldName.charAt(0))), this.priorFieldName.substring(1)), new Object[0]).endControlFlow();
                }
                if (this.templateType == null) {
                    methodBuilder.addStatement("$T $LRW = this.$LRW.wrap(buffer(), limit(), maxLimit())", new Object[]{builderType, name, name}).addStatement("mutator.accept($LRW)", new Object[]{name}).addStatement("fieldsMask |= 1 << $L", new Object[]{ListFlyweightGenerator.fieldIndex(name)}).addStatement("limit($LRW.build().limit())", new Object[]{name});
                } else {
                    methodBuilder.addStatement("$L.field((b, o, m) ->\n{\n    $T $L = $LRW.wrap(b, o, m);\n    mutator.accept($L);\n    return $L.build().sizeof();\n})", new Object[]{ListFlyweightGenerator.variantRW(templateClassName), builderType, name, name, name, name});
                }
                if (this.nullValue == null && this.templateType == null) {
                    methodBuilder.addStatement("fieldsMask |= $L", new Object[]{ListFlyweightGenerator.maskConstant(name)});
                } else {
                    methodBuilder.addStatement("lastFieldSet = $L", new Object[]{ListFlyweightGenerator.fieldIndex(name)});
                    if (!isRequired) {
                        this.addDefaultNullMutator(name);
                    }
                }
                methodBuilder.addStatement("return this", new Object[0]);
                this.builder.addMethod(methodBuilder.build());
            }

            private void addVariantType(String name, AstType type, ClassName variantFlyweightName, boolean isRequired, AstType arrayItemTypeName, AstType mapKeyType, AstType mapValueType) {
                AstVariantNode variantNode = (AstVariantNode)this.resolver.resolve(type.name());
                ClassName builderType = variantFlyweightName.nestedClass("Builder");
                AstType ofType = variantNode.of();
                TypeName ofTypeName = this.resolver.resolveType(ofType);
                TypeName primitiveReturnType = ofTypeName.equals((Object)TypeName.BYTE) || ofTypeName.equals((Object)TypeName.SHORT) || ofTypeName.equals((Object)TypeName.INT) ? TypeName.INT : TypeName.LONG;
                TypeName parameterType = Objects.requireNonNullElse(this.resolver.resolveUnsignedType(variantNode.of()), ofTypeName.isPrimitive() ? primitiveReturnType : (arrayItemTypeName != null ? ParameterizedTypeName.get((ClassName)this.resolver.resolveClass(AstType.ARRAY), (TypeName[])new TypeName[]{this.resolver.resolveType(arrayItemTypeName)}) : (mapKeyType != null ? ParameterizedTypeName.get((ClassName)this.resolver.resolveClass(AstType.MAP), (TypeName[])new TypeName[]{this.resolver.resolveClass(mapKeyType), this.resolver.resolveClass(mapValueType)}) : (AstType.BOUNDED_OCTETS.equals(ofType) ? this.resolver.resolveClass(AstType.BOUNDED_OCTETS) : this.resolver.resolveClass(AstType.STRING)))));
                MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)ListFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter(parameterType, "value", new Modifier[0]);
                if (this.templateType == null) {
                    methodBuilder.addStatement("$T $LRW = $L()", new Object[]{builderType, name, name}).addStatement("$LRW.set(value)", new Object[]{name});
                } else {
                    ClassName templateClassName = this.resolver.resolveClass(this.templateType);
                    String outOfOrderCheck = "assert lastFieldSet < $L : \"Field \\\"$L\\\" cannot be set out of order\"";
                    methodBuilder.addStatement(outOfOrderCheck, new Object[]{ListFlyweightGenerator.fieldIndex(name), name});
                    if (this.priorRequiredFieldName != null) {
                        int priorRequiredFieldPosition = this.requiredFieldPosition.get(this.priorRequiredFieldName);
                        if (priorRequiredFieldPosition == 1 << this.position >> 1) {
                            methodBuilder.addStatement("assert lastFieldSet == $L : \"Prior required field \\\"$L\\\" is not set\"", new Object[]{ListFlyweightGenerator.fieldIndex(this.priorRequiredFieldName), this.priorRequiredFieldName});
                        } else {
                            methodBuilder.beginControlFlow("if (lastFieldSet < $L)", new Object[]{ListFlyweightGenerator.fieldIndex(this.priorFieldName)}).addStatement("$L()", new Object[]{ListFlyweightGenerator.defaultMethodName(this.priorFieldName)}).endControlFlow();
                        }
                    } else if (this.priorFieldName != null) {
                        methodBuilder.beginControlFlow("if (lastFieldSet < $L)", new Object[]{ListFlyweightGenerator.fieldIndex(this.priorFieldName)}).addStatement(String.format("default%s%s()", Character.valueOf(Character.toUpperCase(this.priorFieldName.charAt(0))), this.priorFieldName.substring(1)), new Object[0]).endControlFlow();
                    }
                    if (arrayItemTypeName != null) {
                        methodBuilder.addStatement("$L.field((b, o, m) ->\n$LRW.wrap(b, o, m)\n    .items(value.items(), 0, value.items().capacity(), value.fieldCount(), value.maxLength())\n    .build()\n    .sizeof());", new Object[]{ListFlyweightGenerator.variantRW(templateClassName), name});
                    } else if (mapKeyType != null) {
                        ClassName mapKeyTypeClass = this.resolver.resolveClass(mapKeyType);
                        ClassName mapKeyTypeBuilderClass = mapKeyTypeClass.nestedClass("Builder");
                        ClassName mapValueTypeClass = this.resolver.resolveClass(mapValueType);
                        ClassName mapValueTypeBuilderClass = mapValueTypeClass.nestedClass("Builder");
                        ParameterizedTypeName parameterizedMapBuilderName = ParameterizedTypeName.get((ClassName)builderType, (TypeName[])new TypeName[]{mapKeyTypeClass, mapValueTypeClass, mapKeyTypeBuilderClass, mapValueTypeBuilderClass});
                        methodBuilder.addStatement("$L.field((b, o, m) ->\n{\n$T $L = $LRW.wrap(b, o, m);\nvalue.forEach(kv -> vv -> $L.entry(k -> k.set(kv.get()), v -> v.set(vv.get())));\nreturn $L.build().sizeof();\n})", new Object[]{ListFlyweightGenerator.variantRW(templateClassName), parameterizedMapBuilderName, name, name, name, name});
                    } else {
                        methodBuilder.addStatement("$L.field((b, o, m) -> $LRW.wrap(b, o, m).set(value).build().sizeof())", new Object[]{ListFlyweightGenerator.variantRW(templateClassName), name});
                    }
                }
                if (this.nullValue == null && this.templateType == null) {
                    methodBuilder.addStatement("fieldsMask |= $L", new Object[]{ListFlyweightGenerator.maskConstant(name)});
                } else {
                    methodBuilder.addStatement("lastFieldSet = $L", new Object[]{ListFlyweightGenerator.fieldIndex(name)});
                    if (!isRequired) {
                        this.addDefaultNullMutator(name);
                    }
                }
                if (this.templateType == null) {
                    methodBuilder.addStatement("limit($LRW.build().limit())", new Object[]{name});
                }
                methodBuilder.addStatement("return this", new Object[0]);
                this.builder.addMethod(methodBuilder.build());
            }

            private void addMapType(String name, boolean isRequired, ClassName typeName, ClassName mapParamName) {
                MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)ListFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter((TypeName)ParameterizedTypeName.get((ClassName)typeName, (TypeName[])new TypeName[]{mapParamName}), "value", new Modifier[0]);
                ClassName templateClassName = this.resolver.resolveClass(this.templateType);
                String outOfOrderCheck = "assert lastFieldSet < $L : \"Field \\\"$L\\\" cannot be set out of order\"";
                methodBuilder.addStatement(outOfOrderCheck, new Object[]{ListFlyweightGenerator.fieldIndex(name), name});
                if (this.priorRequiredFieldName != null) {
                    int priorRequiredFieldPosition = this.requiredFieldPosition.get(this.priorRequiredFieldName);
                    if (priorRequiredFieldPosition == 1 << this.position >> 1) {
                        methodBuilder.addStatement("assert lastFieldSet == $L : \"Prior required field \\\"$L\\\" is not set\"", new Object[]{ListFlyweightGenerator.fieldIndex(this.priorRequiredFieldName), this.priorRequiredFieldName});
                    } else {
                        methodBuilder.beginControlFlow("if (lastFieldSet < $L)", new Object[]{ListFlyweightGenerator.fieldIndex(this.priorFieldName)}).addStatement("$L()", new Object[]{ListFlyweightGenerator.defaultMethodName(this.priorFieldName)}).endControlFlow();
                    }
                } else if (this.nullValue != null && this.priorFieldName != null) {
                    methodBuilder.beginControlFlow("if (lastFieldSet < $L)", new Object[]{ListFlyweightGenerator.fieldIndex(this.priorFieldName)}).addStatement(String.format("default%s%s()", Character.valueOf(Character.toUpperCase(this.priorFieldName.charAt(0))), this.priorFieldName.substring(1)), new Object[0]).endControlFlow();
                }
                ParameterizedTypeName parameterizedMapBuilderName = ParameterizedTypeName.get((ClassName)typeName.nestedClass("Builder"), (TypeName[])new TypeName[]{mapParamName, mapParamName.nestedClass("Builder")});
                methodBuilder.addStatement("$L.field((b, o, m) ->\n{\n$T $L = $LRW.wrap(b, o, m);\n$L.entries(value.entries(), 0, value.entries().capacity(), value.fieldCount());\nreturn $L.build().sizeof();\n})", new Object[]{ListFlyweightGenerator.variantRW(templateClassName), parameterizedMapBuilderName, name, name, name, name});
                if (this.nullValue == null && this.templateType == null) {
                    methodBuilder.addStatement("fieldsMask |= $L", new Object[]{ListFlyweightGenerator.maskConstant(name)});
                } else {
                    methodBuilder.addStatement("lastFieldSet = $L", new Object[]{ListFlyweightGenerator.fieldIndex(name)});
                    if (!isRequired) {
                        this.addDefaultNullMutator(name);
                    }
                }
                if (this.templateType == null) {
                    methodBuilder.addStatement("limit($LRW.build().limit())", new Object[]{name});
                }
                methodBuilder.addStatement("return this", new Object[0]);
                this.builder.addMethod(methodBuilder.build());
            }

            private void addListType(String name, boolean isRequired, ClassName className) {
                MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)ListFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter((TypeName)className, "value", new Modifier[0]);
                ClassName templateClassName = this.resolver.resolveClass(this.templateType);
                String outOfOrderCheck = "assert lastFieldSet < $L : \"Field \\\"$L\\\" cannot be set out of order\"";
                methodBuilder.addStatement(outOfOrderCheck, new Object[]{ListFlyweightGenerator.fieldIndex(name), name});
                if (this.priorRequiredFieldName != null) {
                    int priorRequiredFieldPosition = this.requiredFieldPosition.get(this.priorRequiredFieldName);
                    if (priorRequiredFieldPosition == 1 << this.position >> 1) {
                        methodBuilder.addStatement("assert lastFieldSet == $L : \"Prior required field \\\"$L\\\" is not set\"", new Object[]{ListFlyweightGenerator.fieldIndex(this.priorRequiredFieldName), this.priorRequiredFieldName});
                    } else {
                        methodBuilder.beginControlFlow("if (lastFieldSet < $L)", new Object[]{ListFlyweightGenerator.fieldIndex(this.priorFieldName)}).addStatement("$L()", new Object[]{ListFlyweightGenerator.defaultMethodName(this.priorFieldName)}).endControlFlow();
                    }
                } else if (this.nullValue != null && this.priorFieldName != null) {
                    methodBuilder.beginControlFlow("if (lastFieldSet < $L)", new Object[]{ListFlyweightGenerator.fieldIndex(this.priorFieldName)}).addStatement(String.format("default%s%s()", Character.valueOf(Character.toUpperCase(this.priorFieldName.charAt(0))), this.priorFieldName.substring(1)), new Object[0]).endControlFlow();
                }
                methodBuilder.addStatement("$L.field((b, o, m) -> $LRW.wrap(b, o, m).fields(value.fieldCount(), value.buffer(), value.offset(), value.sizeof()).build().sizeof())", new Object[]{ListFlyweightGenerator.variantRW(templateClassName), name});
                if (this.nullValue == null && this.templateType == null) {
                    methodBuilder.addStatement("fieldsMask |= $L", new Object[]{ListFlyweightGenerator.maskConstant(name)});
                } else {
                    methodBuilder.addStatement("lastFieldSet = $L", new Object[]{ListFlyweightGenerator.fieldIndex(name)});
                    if (!isRequired) {
                        this.addDefaultNullMutator(name);
                    }
                }
                if (this.templateType == null) {
                    methodBuilder.addStatement("limit($LRW.build().limit())", new Object[]{name});
                }
                methodBuilder.addStatement("return this", new Object[0]);
                this.builder.addMethod(methodBuilder.build());
            }

            private void addDefaultNullMutator(String name) {
                MethodSpec.Builder defaultNullMethod = MethodSpec.methodBuilder((String)ListFlyweightGenerator.defaultMethodName(name)).addModifiers(new Modifier[]{Modifier.PRIVATE}).returns((TypeName)this.thisType);
                ClassName templateClassName = this.resolver.resolveClass(this.templateType);
                if (this.priorRequiredFieldName != null) {
                    int priorRequiredFieldPosition = this.requiredFieldPosition.get(this.priorRequiredFieldName);
                    if (priorRequiredFieldPosition == 1 << this.position >> 1) {
                        defaultNullMethod.addStatement("assert lastFieldSet == $L : \"Prior required field \\\"$L\\\" is not set\";", new Object[]{ListFlyweightGenerator.fieldIndex(this.priorRequiredFieldName), this.priorRequiredFieldName});
                    } else {
                        defaultNullMethod.beginControlFlow("if (lastFieldSet < $L)", new Object[]{ListFlyweightGenerator.fieldIndex(this.priorFieldName)}).addStatement("$L()", new Object[]{ListFlyweightGenerator.defaultMethodName(this.priorFieldName)}).endControlFlow();
                    }
                } else if (this.priorFieldName != null) {
                    defaultNullMethod.beginControlFlow("if (lastFieldSet < $L)", new Object[]{ListFlyweightGenerator.fieldIndex(this.priorFieldName)}).addStatement("$L()", new Object[]{ListFlyweightGenerator.defaultMethodName(this.priorFieldName)}).endControlFlow();
                }
                if (this.templateType == null) {
                    defaultNullMethod.addStatement("int newLimit = limit() + $T.SIZE_OF_BYTE", new Object[]{TypeNames.BIT_UTIL_TYPE}).addStatement("checkLimit(limit(), newLimit)", new Object[0]).addStatement("buffer().putByte(limit(), MISSING_FIELD_BYTE)", new Object[0]).addStatement("lastFieldSet = $L", new Object[]{ListFlyweightGenerator.fieldIndex(name)}).addStatement("limit(newLimit)", new Object[0]);
                } else {
                    defaultNullMethod.addStatement("$L.field($T::missingField)", new Object[]{ListFlyweightGenerator.variantRW(templateClassName), this.thisType}).addStatement("lastFieldSet = $L", new Object[]{ListFlyweightGenerator.fieldIndex(name)});
                }
                this.defaultNullMutators.add(defaultNullMethod.addStatement("return this", new Object[0]).build());
            }

            private void addEnumType(String name, AstType type, boolean isRequired, ClassName enumFlyweightName) {
                this.addEnumTypeWithFlyweight(name, isRequired, enumFlyweightName);
                this.addEnumTypeWithEnum(name, type, enumFlyweightName);
            }

            private void addEnumTypeWithFlyweight(String name, boolean isRequired, ClassName enumFlyweightName) {
                MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)ListFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter((TypeName)enumFlyweightName, "value", new Modifier[0]);
                if (this.templateType == null) {
                    methodBuilder.addStatement("assert (fieldsMask & ~$L) == 0 : \"Field \\\"$L\\\" cannot be set out of order\"", new Object[]{String.format("0x%02X", this.bitsOfOnes), name});
                } else {
                    String outOfOrderCheck = "assert lastFieldSet < $L : \"Field \\\"$L\\\" cannot be set out of order\"";
                    methodBuilder.addStatement(outOfOrderCheck, new Object[]{ListFlyweightGenerator.fieldIndex(name), name});
                }
                if (this.priorRequiredFieldName != null) {
                    int priorRequiredFieldPosition = this.requiredFieldPosition.get(this.priorRequiredFieldName);
                    if (this.nullValue == null && this.templateType == null) {
                        methodBuilder.addStatement("assert (fieldsMask & $L) != 0 : \"Prior required field \\\"$L\\\" is not set\"", new Object[]{String.format("0x%02X", priorRequiredFieldPosition), this.priorRequiredFieldName});
                    } else if (priorRequiredFieldPosition == 1 << this.position >> 1) {
                        methodBuilder.addStatement("assert lastFieldSet == $L : \"Prior required field \\\"$L\\\" is not set\"", new Object[]{ListFlyweightGenerator.fieldIndex(this.priorRequiredFieldName), this.priorRequiredFieldName});
                    } else {
                        methodBuilder.beginControlFlow("if (lastFieldSet < $L)", new Object[]{ListFlyweightGenerator.fieldIndex(this.priorFieldName)}).addStatement("$L()", new Object[]{ListFlyweightGenerator.defaultMethodName(this.priorFieldName)}).endControlFlow();
                    }
                } else if (this.templateType != null && this.priorFieldName != null) {
                    methodBuilder.beginControlFlow("if (lastFieldSet < $L)", new Object[]{ListFlyweightGenerator.fieldIndex(this.priorFieldName)}).addStatement(String.format("default%s%s()", Character.valueOf(Character.toUpperCase(this.priorFieldName.charAt(0))), this.priorFieldName.substring(1)), new Object[0]).endControlFlow();
                }
                if (this.nullValue == null && this.templateType == null) {
                    methodBuilder.addStatement("int newLimit = limit() + value.sizeof()", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("buffer().putBytes(limit(), value.buffer(), value.offset(), value.sizeof())", new Object[0]).addStatement("fieldsMask |= $L", new Object[]{ListFlyweightGenerator.maskConstant(name)});
                } else {
                    ClassName templateClassName = this.resolver.resolveClass(this.templateType);
                    methodBuilder.addStatement("$L.field((b, o, m) -> $LRW.wrap(b, o, m).set(value).build().sizeof())", new Object[]{ListFlyweightGenerator.variantRW(templateClassName), name});
                    methodBuilder.addStatement("lastFieldSet = $L", new Object[]{ListFlyweightGenerator.fieldIndex(name)});
                    if (!isRequired) {
                        this.addDefaultNullMutator(name);
                    }
                }
                if (this.templateType == null) {
                    methodBuilder.addStatement("limit(newLimit)", new Object[0]);
                }
                methodBuilder.addStatement("return this", new Object[0]);
                this.builder.addMethod(methodBuilder.build());
            }

            private void addEnumTypeWithEnum(String name, AstType type, ClassName enumFlyweightName) {
                AstEnumNode enumNode = (AstEnumNode)this.resolver.resolve(type.name());
                ClassName enumName = enumFlyweightName.peerClass(enumNode.name());
                ClassName builderType = enumFlyweightName.nestedClass("Builder");
                MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)ListFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter((TypeName)enumName, "value", new Modifier[0]);
                if (this.templateType == null) {
                    methodBuilder.addStatement("assert (fieldsMask & ~$L) == 0 : \"Field \\\"$L\\\" cannot be set out of order\"", new Object[]{String.format("0x%02X", this.bitsOfOnes), name});
                } else {
                    String outOfOrderCheck = "assert lastFieldSet < $L : \"Field \\\"$L\\\" cannot be set out of order\"";
                    methodBuilder.addStatement(outOfOrderCheck, new Object[]{ListFlyweightGenerator.fieldIndex(name), name});
                }
                if (this.priorRequiredFieldName != null) {
                    int priorRequiredFieldPosition = this.requiredFieldPosition.get(this.priorRequiredFieldName);
                    if (this.nullValue == null && this.templateType == null) {
                        methodBuilder.addStatement("assert (fieldsMask & $L) != 0 : \"Prior required field \\\"$L\\\" is not set\"", new Object[]{String.format("0x%02X", priorRequiredFieldPosition), this.priorRequiredFieldName});
                    } else if (priorRequiredFieldPosition == 1 << this.position >> 1) {
                        methodBuilder.addStatement("assert lastFieldSet == $L : \"Prior required field \\\"$L\\\" is not set\"", new Object[]{ListFlyweightGenerator.fieldIndex(this.priorRequiredFieldName), this.priorRequiredFieldName});
                    } else {
                        methodBuilder.beginControlFlow("if (lastFieldSet < $L)", new Object[]{ListFlyweightGenerator.fieldIndex(this.priorFieldName)}).addStatement("$L()", new Object[]{ListFlyweightGenerator.defaultMethodName(this.priorFieldName)}).endControlFlow();
                    }
                } else if (this.templateType != null && this.priorFieldName != null) {
                    methodBuilder.beginControlFlow("if (lastFieldSet < $L)", new Object[]{ListFlyweightGenerator.fieldIndex(this.priorFieldName)}).addStatement(String.format("default%s%s()", Character.valueOf(Character.toUpperCase(this.priorFieldName.charAt(0))), this.priorFieldName.substring(1)), new Object[0]).endControlFlow();
                }
                if (this.templateType == null) {
                    methodBuilder.addStatement("$T $LRW = this.$LRW.wrap(buffer(), limit(), maxLimit())", new Object[]{builderType, name, name});
                    if (AstType.STRING8.equals(enumNode.valueType()) || AstType.STRING16.equals(enumNode.valueType()) || AstType.STRING32.equals(enumNode.valueType())) {
                        methodBuilder.addStatement("$LRW.set(value, $T.UTF_8)", new Object[]{name, StandardCharsets.class});
                    } else {
                        methodBuilder.addStatement("$LRW.set(value)", new Object[]{name});
                    }
                    methodBuilder.addStatement("fieldsMask |= 1 << $L", new Object[]{ListFlyweightGenerator.fieldIndex(name)}).addStatement("limit($LRW.build().limit())", new Object[]{name});
                } else {
                    ClassName templateClassName = this.resolver.resolveClass(this.templateType);
                    methodBuilder.addStatement("$L.field((b, o, m) -> $LRW.wrap(b, o, m).set(value).build().sizeof())", new Object[]{ListFlyweightGenerator.variantRW(templateClassName), name});
                    methodBuilder.addStatement("lastFieldSet = $L", new Object[]{ListFlyweightGenerator.fieldIndex(name)});
                }
                methodBuilder.addStatement("return this", new Object[0]);
                this.builder.addMethod(methodBuilder.build());
            }

            private void addStringType(ClassName className, String name) {
                ClassName builderType = className.nestedClass("Builder");
                MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)ListFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter(String.class, "value", new Modifier[0]).addStatement("assert (fieldsMask & ~$L) == 0 : \"Field \\\"$L\\\" is already set or subsequent fields are already set\"", new Object[]{String.format("0x%02X", this.bitsOfOnes), name});
                if (this.priorRequiredFieldName != null) {
                    methodBuilder.addStatement("assert (fieldsMask & $L) != 0 : \"Prior required field \\\"$L\\\" is not set\"", new Object[]{String.format("0x%02X", this.requiredFieldPosition.get(this.priorRequiredFieldName)), this.priorRequiredFieldName});
                }
                methodBuilder.addStatement("$T $LRW = $L()", new Object[]{builderType, name, ListFlyweightGenerator.methodName(name)}).addStatement("$LRW.set(value, $T.UTF_8)", new Object[]{name, StandardCharsets.class}).addStatement("fieldsMask |= 1 << $L", new Object[]{ListFlyweightGenerator.fieldIndex(name)}).addStatement("limit($LRW.build().limit())", new Object[]{name}).addStatement("return this", new Object[0]);
                this.builder.addMethod(methodBuilder.build());
                methodBuilder = MethodSpec.methodBuilder((String)ListFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter((TypeName)className, "value", new Modifier[0]).addStatement("assert (fieldsMask & ~$L) == 0 : \"Field \\\"$L\\\" is already set or subsequent fields are already set\"", new Object[]{String.format("0x%02X", this.bitsOfOnes), name});
                if (this.priorRequiredFieldName != null) {
                    methodBuilder.addStatement("assert (fieldsMask & $L) != 0 : \"Prior required field \\\"$L\\\" is not set\"", new Object[]{String.format("0x%02X", this.requiredFieldPosition.get(this.priorRequiredFieldName)), this.priorRequiredFieldName});
                }
                methodBuilder.addStatement("$T $LRW = $L()", new Object[]{builderType, name, ListFlyweightGenerator.methodName(name)}).addStatement("$LRW.set(value)", new Object[]{name}).addStatement("fieldsMask |= 1 << $L", new Object[]{ListFlyweightGenerator.fieldIndex(name)}).addStatement("limit($LRW.build().limit())", new Object[]{name}).addStatement("return this", new Object[0]);
                this.builder.addMethod(methodBuilder.build());
                methodBuilder = MethodSpec.methodBuilder((String)ListFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "length", new Modifier[0]).addStatement("assert (fieldsMask & ~$L) == 0 : \"Field \\\"$L\\\" is already set or subsequent fields are already set\"", new Object[]{String.format("0x%02X", this.bitsOfOnes), name});
                if (this.priorRequiredFieldName != null) {
                    methodBuilder.addStatement("assert (fieldsMask & $L) != 0 : \"Prior required field \\\"$L\\\" is not set\"", new Object[]{String.format("0x%02X", this.requiredFieldPosition.get(this.priorRequiredFieldName)), this.priorRequiredFieldName});
                }
                methodBuilder.addStatement("$T $LRW = $L()", new Object[]{builderType, name, ListFlyweightGenerator.methodName(name)}).addStatement("$LRW.set(buffer, offset, length)", new Object[]{name}).addStatement("fieldsMask |= 1 << $L", new Object[]{ListFlyweightGenerator.fieldIndex(name)}).addStatement("limit($LRW.build().limit())", new Object[]{name}).addStatement("return this", new Object[0]);
                this.builder.addMethod(methodBuilder.build());
            }

            @Override
            public TypeSpec.Builder build() {
                for (int i = 0; i < this.defaultNullMutators.size() - 1; ++i) {
                    this.builder.addMethod(this.defaultNullMutators.get(i));
                }
                this.bitsOfOnes = 0;
                this.position = 0;
                if (this.templateType != null) {
                    this.builder.addMethod(MethodSpec.methodBuilder((String)"missingField").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).returns(Integer.TYPE).addParameter((TypeName)TypeNames.MUTABLE_DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).addStatement("buffer.putByte(offset, MISSING_FIELD_BYTE)", new Object[0]).addStatement("return MISSING_FIELD_BYTE_SIZE", new Object[0]).build());
                }
                return super.build();
            }
        }

        private static final class MemberAccessorGenerator
        extends ClassSpecMixinGenerator {
            private final AstType templateType;
            private final TypeResolver resolver;
            private final Byte nullValue;
            private long bitsOfOnes;
            private int position;
            private String priorRequiredFieldName = null;
            private String priorFieldName = null;
            private Map<String, Integer> requiredFieldPosition = new HashMap<String, Integer>();

            private MemberAccessorGenerator(ClassName thisType, TypeSpec.Builder builder, AstType templateType, TypeResolver resolver, Byte nullValue) {
                super(thisType, builder);
                this.templateType = templateType;
                this.resolver = resolver;
                this.nullValue = nullValue;
            }

            public MemberAccessorGenerator addMember(String name, AstType type, TypeName typeName, boolean isRequired) {
                if (this.templateType == null) {
                    if (typeName instanceof ClassName) {
                        ClassName className = (ClassName)typeName;
                        AstNamedNode namedNode = this.resolver.resolve(type.name());
                        if (ListFlyweightGenerator.isStringType(className)) {
                            this.addStringType(className, name);
                        } else if (AstNamedNode.Kind.VARIANT.equals((Object)namedNode.getKind())) {
                            this.addVariantType(name, className);
                        }
                    }
                    this.bitsOfOnes = this.bitsOfOnes << 1 | 1L;
                    if (isRequired) {
                        this.requiredFieldPosition.put(name, 1 << this.position);
                        this.priorRequiredFieldName = name;
                    }
                    this.priorFieldName = name;
                    ++this.position;
                }
                return this;
            }

            private void addVariantType(String name, ClassName className) {
                ClassName builderType = className.nestedClass("Builder");
                MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)ListFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PRIVATE}).returns((TypeName)builderType);
                String outOfOrderCheck = String.format("assert %s : \"Field \\\"$L\\\" cannot be set out of order\"", this.nullValue == null ? "(fieldsMask & ~$L) == 0" : "lastFieldSet < $L");
                methodBuilder.addStatement(outOfOrderCheck, new Object[]{this.nullValue == null ? String.format("0x%02X", this.bitsOfOnes) : ListFlyweightGenerator.fieldIndex(name), name});
                if (this.priorRequiredFieldName != null) {
                    int priorRequiredFieldPosition = this.requiredFieldPosition.get(this.priorRequiredFieldName);
                    if (this.nullValue == null) {
                        methodBuilder.addStatement("assert (fieldsMask & $L) != 0 : \"Prior required field \\\"$L\\\" is not set\"", new Object[]{String.format("0x%02X", priorRequiredFieldPosition), this.priorRequiredFieldName});
                    } else if (priorRequiredFieldPosition == 1 << this.position >> 1) {
                        methodBuilder.addStatement("assert lastFieldSet == $L : \"Prior required field \\\"$L\\\" is not set\"", new Object[]{ListFlyweightGenerator.fieldIndex(this.priorRequiredFieldName), this.priorRequiredFieldName});
                    } else {
                        methodBuilder.beginControlFlow("if (lastFieldSet < $L)", new Object[]{ListFlyweightGenerator.fieldIndex(this.priorFieldName)}).addStatement("$L()", new Object[]{ListFlyweightGenerator.defaultMethodName(this.priorFieldName)}).endControlFlow();
                    }
                } else if (this.nullValue != null && this.priorFieldName != null) {
                    methodBuilder.beginControlFlow("if (lastFieldSet < $L)", new Object[]{ListFlyweightGenerator.fieldIndex(this.priorFieldName)}).addStatement(String.format("default%s%s()", Character.valueOf(Character.toUpperCase(this.priorFieldName.charAt(0))), this.priorFieldName.substring(1)), new Object[0]).endControlFlow();
                }
                methodBuilder.addStatement("return $LRW.wrap(buffer(), limit(), maxLimit())", new Object[]{name});
                this.builder.addMethod(methodBuilder.build());
            }

            private void addStringType(ClassName className, String name) {
                ClassName builderType = className.nestedClass("Builder");
                this.builder.addMethod(MethodSpec.methodBuilder((String)ListFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PRIVATE}).returns((TypeName)builderType).addStatement("return $LRW.wrap(buffer(), limit(), maxLimit())", new Object[]{name}).build());
            }
        }

        private static final class TemplateTypeRWGenerator
        extends ClassSpecMixinGenerator {
            private final AstType templateType;
            private final TypeResolver resolver;

            private TemplateTypeRWGenerator(ClassName thisType, TypeSpec.Builder builder, AstType templateType, TypeResolver resolver) {
                super(thisType, builder);
                this.templateType = templateType;
                this.resolver = resolver;
            }

            @Override
            public TypeSpec.Builder build() {
                if (this.templateType != null) {
                    ClassName templateClassName = this.resolver.resolveClass(this.templateType);
                    ClassName builderClassName = templateClassName.nestedClass("Builder");
                    this.builder.addField(FieldSpec.builder((TypeName)builderClassName, (String)ListFlyweightGenerator.variantRW(templateClassName), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T()", new Object[]{builderClassName}).build());
                }
                return super.build();
            }
        }

        private static final class MemberFieldGenerator
        extends ClassSpecMixinGenerator {
            private final TypeResolver resolver;

            private MemberFieldGenerator(ClassName thisType, TypeSpec.Builder builder, TypeResolver resolver) {
                super(thisType, builder);
                this.resolver = resolver;
            }

            public MemberFieldGenerator addMember(String name, TypeName type, AstByteOrder byteOrder, AstType arrayItemTypeName, AstType mapKeyType, AstType mapValueType, ClassName mapParamName, ClassName originalMapKeyName, ClassName originalMapValueName) {
                if (!type.isPrimitive()) {
                    String fieldRW = String.format("%sRW", name);
                    if (type instanceof ClassName) {
                        ClassName classType = (ClassName)type;
                        ClassName builderType = classType.nestedClass("Builder");
                        if ((ListFlyweightGenerator.isString16Type(classType) || ListFlyweightGenerator.isString32Type(classType)) && byteOrder == AstByteOrder.NETWORK) {
                            this.builder.addField(FieldSpec.builder((TypeName)builderType, (String)fieldRW, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T($T.BIG_ENDIAN)", new Object[]{builderType, ByteOrder.class}).build());
                        } else if (arrayItemTypeName != null) {
                            ClassName arrayItemTypeClass = this.resolver.resolveClass(arrayItemTypeName);
                            ClassName arrayItemTypeBuilderClass = arrayItemTypeClass.nestedClass("Builder");
                            ParameterizedTypeName parameterizedArrayName = ParameterizedTypeName.get((ClassName)builderType, (TypeName[])new TypeName[]{arrayItemTypeBuilderClass, arrayItemTypeClass});
                            this.builder.addField(FieldSpec.builder((TypeName)parameterizedArrayName, (String)fieldRW, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T<>(new $T(), new $T())", new Object[]{builderType, arrayItemTypeBuilderClass, arrayItemTypeClass}).build());
                        } else if (mapKeyType != null) {
                            ClassName mapKeyTypeClass = this.resolver.resolveClass(mapKeyType);
                            ClassName mapKeyTypeBuilderClass = mapKeyTypeClass.nestedClass("Builder");
                            ClassName mapValueTypeClass = this.resolver.resolveClass(mapValueType);
                            ClassName mapValueTypeBuilderClass = mapValueTypeClass.nestedClass("Builder");
                            ParameterizedTypeName parameterizedMapName = ParameterizedTypeName.get((ClassName)builderType, (TypeName[])new TypeName[]{mapKeyTypeClass, mapValueTypeClass, mapKeyTypeBuilderClass, mapValueTypeBuilderClass});
                            this.builder.addField(FieldSpec.builder((TypeName)parameterizedMapName, (String)fieldRW, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T<>(new $T(), new $T(), new $T(), new $T())", new Object[]{builderType, mapKeyTypeClass, mapValueTypeClass, mapKeyTypeBuilderClass, mapValueTypeBuilderClass}).build());
                        } else if (mapParamName != null) {
                            ParameterizedTypeName parameterizedMapName = ParameterizedTypeName.get((ClassName)builderType, (TypeName[])new TypeName[]{mapParamName, mapParamName.nestedClass("Builder")});
                            this.builder.addField(FieldSpec.builder((TypeName)parameterizedMapName, (String)fieldRW, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T<>(new $T(), new $T(), new $T(), new $T())", new Object[]{builderType, originalMapKeyName, originalMapValueName, originalMapKeyName.nestedClass("Builder"), originalMapValueName.nestedClass("Builder")}).build());
                        } else {
                            this.builder.addField(FieldSpec.builder((TypeName)builderType, (String)fieldRW, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T()", new Object[]{builderType}).build());
                        }
                    } else {
                        throw new IllegalArgumentException("Unsupported member type: " + type);
                    }
                }
                return this;
            }
        }

        private static final class FieldsMaskGenerator
        extends ClassSpecMixinGenerator {
            private final Byte nullValue;
            private final AstType templateType;

            protected FieldsMaskGenerator(ClassName thisType, TypeSpec.Builder builder, Byte nullValue, AstType templateType) {
                super(thisType, builder);
                this.nullValue = nullValue;
                this.templateType = templateType;
            }

            @Override
            public TypeSpec.Builder build() {
                if (this.nullValue == null && this.templateType == null) {
                    this.builder.addField(FieldSpec.builder(Long.TYPE, (String)"fieldsMask", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
                } else {
                    this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)"lastFieldSet", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).initializer("-1", new Object[0]).build());
                }
                return this.builder;
            }
        }
    }

    private final class ToStringMethodGenerator
    extends MethodSpecGenerator {
        private final List<ListField> fields;
        private final Byte nullValue;
        private final AstType templateType;

        private ToStringMethodGenerator(Byte nullValue, AstType templateType) {
            super(MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class));
            this.fields = new ArrayList<ListField>();
            this.nullValue = nullValue;
            this.templateType = templateType;
        }

        public ToStringMethodGenerator addMember(String name, TypeName type, Object defaultValue, boolean isRequired) {
            this.fields.add(new ListField(name, type, isRequired, defaultValue));
            return this;
        }

        @Override
        public MethodSpec generate() {
            String typeName = ListFlyweightGenerator.constant(ListFlyweightGenerator.this.baseName);
            if (this.nullValue == null && this.templateType == null) {
                this.builder.addStatement("final long bitmask = bitmask()", new Object[0]);
            }
            for (ListField listField : this.fields) {
                if (listField.isRequired() || listField.defaultValue() != null) continue;
                this.builder.addStatement("Object $L = null", new Object[]{listField.fieldName()});
            }
            this.builder.addStatement("StringBuilder format = new StringBuilder()", new Object[0]).addStatement("format.append(\"$L [bitmask={0}\")", new Object[]{typeName});
            int fieldIndex = 1;
            for (ListField field : this.fields) {
                String name = field.fieldName();
                if (field.isRequired() || field.defaultValue() != null) {
                    this.builder.addStatement("format.append(\", $L={$L}\")", new Object[]{name, fieldIndex});
                } else {
                    this.builder.beginControlFlow("if (has$L())", new Object[]{String.format("%s%s", Character.valueOf(Character.toUpperCase(name.charAt(0))), name.substring(1))}).addStatement("format.append(\", $L={$L}\")", new Object[]{name, fieldIndex}).addStatement("$L = $L()", new Object[]{name, name}).endControlFlow();
                }
                ++fieldIndex;
            }
            this.builder.addStatement("format.append(\"]\")", new Object[0]);
            CodeBlock.Builder builder = CodeBlock.builder().add("$[", new Object[0]).add("return $T.format(format.toString(), String.format(\"0x%16X\", bitmask)", new Object[]{MessageFormat.class});
            for (ListField field : this.fields) {
                String name = field.fieldName();
                if (field.isRequired() || field.defaultValue() != null) {
                    builder.add(", $L()", new Object[]{name});
                    continue;
                }
                builder.add(", $L", new Object[]{name});
            }
            builder.add(");\n$]", new Object[0]);
            return this.builder.addCode(builder.build()).build();
        }
    }

    private final class LimitMethodGenerator
    extends MethodSpecGenerator {
        private final TypeName lengthTypeName;
        private final AstType templateType;
        private final TypeResolver resolver;
        private final AstByteOrder byteOrder;

        private LimitMethodGenerator(TypeName lengthTypeName, AstType templateType, TypeResolver resolver, AstByteOrder byteOrder) {
            super(MethodSpec.methodBuilder((String)"limit"));
            this.lengthTypeName = lengthTypeName;
            this.templateType = templateType;
            this.resolver = resolver;
            this.byteOrder = byteOrder;
        }

        @Override
        public MethodSpec generate() {
            this.builder.addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE);
            if (this.templateType == null) {
                if (this.byteOrder == AstByteOrder.NATIVE) {
                    this.builder.addStatement("return offset() + buffer().$L(offset() + $L)", new Object[]{GETTER_NAMES.get(this.lengthTypeName), ListFlyweightGenerator.offset(ListFlyweightGenerator.LENGTH)});
                } else {
                    this.builder.addStatement("return offset() + buffer().$L(offset() + $L, $T.BIG_ENDIAN)", new Object[]{GETTER_NAMES.get(this.lengthTypeName), ListFlyweightGenerator.offset(ListFlyweightGenerator.LENGTH), ByteOrder.class});
                }
            } else {
                this.builder.addStatement("return $L.limit()", new Object[]{ListFlyweightGenerator.variantRO(this.resolver.resolveClass(this.templateType))});
            }
            return this.builder.build();
        }
    }

    private final class TryWrapMethodGenerator
    extends MethodSpecGenerator {
        private final List<ListField> fields;
        private final Byte missingFieldByte;
        private final AstType templateType;
        private final ClassName templateTypeName;

        private TryWrapMethodGenerator(Byte missingFieldByte, AstType templateType, TypeResolver resolver) {
            super(MethodSpec.methodBuilder((String)"tryWrap"));
            this.fields = new ArrayList<ListField>();
            this.missingFieldByte = missingFieldByte;
            this.templateType = templateType;
            this.templateTypeName = resolver.resolveClass(templateType);
        }

        public TryWrapMethodGenerator addMember(String name, TypeName type, Object defaultValue, boolean isRequired) {
            this.fields.add(new ListField(name, type, isRequired, defaultValue));
            return this;
        }

        @Override
        public MethodSpec generate() {
            this.builder.addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(ListFlyweightGenerator.this.thisName).beginControlFlow("if (super.tryWrap(buffer, offset, maxLimit) == null)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow();
            if (this.templateType == null) {
                this.builder.beginControlFlow("if (offset + $L + $L > maxLimit)", new Object[]{ListFlyweightGenerator.offset(ListFlyweightGenerator.LENGTH), ListFlyweightGenerator.size(ListFlyweightGenerator.LENGTH)});
            } else {
                this.builder.beginControlFlow("if ($L.tryWrap(buffer, offset, maxLimit) == null)", new Object[]{ListFlyweightGenerator.variantRO(this.templateTypeName)});
            }
            this.builder.addStatement("return null", new Object[0]).endControlFlow().addStatement("final int limit = limit()", new Object[0]).beginControlFlow("if (limit > maxLimit)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow();
            if (this.missingFieldByte == null && this.templateType == null) {
                this.generateTryWrap();
            } else {
                this.generateTryWrapWithDefaultNull();
            }
            return this.builder.endControlFlow().endControlFlow().beginControlFlow("if (fieldLimit > limit)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("return this", new Object[0]).build();
        }

        private void generateTryWrapWithDefaultNull() {
            this.builder.addStatement("final int fieldCount = fieldCount()", new Object[0]).addStatement("bitmask = 0", new Object[0]);
            if (this.templateType == null) {
                this.builder.addStatement("int fieldLimit = offset + $L + $L", new Object[]{ListFlyweightGenerator.offset(ListFlyweightGenerator.FIELD_COUNT), ListFlyweightGenerator.size(ListFlyweightGenerator.FIELD_COUNT)});
            } else {
                this.builder.addStatement("DirectBuffer fieldsBuffer = fields()", new Object[0]).addStatement("int fieldLimit = 0", new Object[0]);
            }
            this.builder.beginControlFlow("for (int field = $L; field < fieldCount; field++)", new Object[]{ListFlyweightGenerator.fieldIndex(this.fields.get(0).fieldName())}).beginControlFlow("if (fieldLimit + $T.SIZE_OF_BYTE > limit)", new Object[]{TypeNames.BIT_UTIL_TYPE}).addStatement("return null", new Object[0]).endControlFlow().beginControlFlow("switch (field)", new Object[0]);
            for (ListField field : this.fields) {
                String buffer;
                String fieldName = field.fieldName();
                this.builder.beginControlFlow("case $L:", new Object[]{ListFlyweightGenerator.fieldIndex(fieldName)});
                String string = buffer = this.templateType == null ? "buffer" : "fieldsBuffer";
                if (field.isRequired()) {
                    this.builder.beginControlFlow("if ($LRO.tryWrap($L, fieldLimit, maxLimit) == null)", new Object[]{fieldName, buffer}).addStatement("return null", new Object[0]).endControlFlow().addStatement("fieldLimit = $LRO.limit()", new Object[]{fieldName}).addStatement("bitmask |= 1 << $L", new Object[]{ListFlyweightGenerator.fieldIndex(fieldName)});
                } else {
                    this.builder.beginControlFlow("if ($L.getByte(fieldLimit) != MISSING_FIELD_BYTE)", new Object[]{buffer}).beginControlFlow("if ($LRO.tryWrap($L, fieldLimit, maxLimit) == null)", new Object[]{fieldName, buffer}).addStatement("return null", new Object[0]).endControlFlow().addStatement("fieldLimit = $LRO.limit()", new Object[]{fieldName}).addStatement("bitmask |= 1 << $L", new Object[]{ListFlyweightGenerator.fieldIndex(fieldName)}).endControlFlow().beginControlFlow("else", new Object[0]).addStatement("fieldLimit += MISSING_FIELD_BYTE_SIZE", new Object[0]).endControlFlow();
                }
                this.builder.addStatement("break", new Object[0]).endControlFlow();
            }
        }

        private void generateTryWrap() {
            this.builder.addStatement("final long bitmask = bitmask()", new Object[0]).addStatement("int fieldLimit = offset + $L + $L", new Object[]{ListFlyweightGenerator.offset(ListFlyweightGenerator.BIT_MASK), ListFlyweightGenerator.size(ListFlyweightGenerator.BIT_MASK)}).beginControlFlow("for (int field = $L; field < $L + 1; field++)", new Object[]{ListFlyweightGenerator.fieldIndex(this.fields.get(0).fieldName()), ListFlyweightGenerator.fieldIndex(this.fields.get(this.fields.size() - 1).fieldName())}).beginControlFlow("switch (field)", new Object[0]);
            for (ListField field : this.fields) {
                String fieldName = field.fieldName();
                this.builder.beginControlFlow("case $L:", new Object[]{ListFlyweightGenerator.fieldIndex(fieldName)});
                if (field.isRequired()) {
                    this.builder.beginControlFlow("if ((bitmask & $L) == 0)", new Object[]{ListFlyweightGenerator.maskConstant(fieldName)}).addStatement("return null", new Object[0]).endControlFlow();
                    if (field.type().isPrimitive()) {
                        this.builder.addStatement("optionalOffsets[$L] = fieldLimit", new Object[]{ListFlyweightGenerator.fieldIndex(fieldName)}).addStatement("fieldLimit += $L", new Object[]{ListFlyweightGenerator.fieldSize(fieldName)});
                    } else {
                        this.builder.beginControlFlow("if ($LRO.tryWrap(buffer, fieldLimit, maxLimit) == null)", new Object[]{fieldName}).addStatement("return null", new Object[0]).endControlFlow().addStatement("fieldLimit = $LRO.limit()", new Object[]{fieldName});
                    }
                } else {
                    this.builder.beginControlFlow("if ((bitmask & $L) != 0)", new Object[]{ListFlyweightGenerator.maskConstant(fieldName)});
                    if (field.type().isPrimitive()) {
                        this.builder.addStatement("optionalOffsets[$L] = fieldLimit", new Object[]{ListFlyweightGenerator.fieldIndex(fieldName)}).addStatement("fieldLimit += $L", new Object[]{ListFlyweightGenerator.fieldSize(fieldName)});
                    } else {
                        this.builder.beginControlFlow("if ($LRO.tryWrap(buffer, fieldLimit, maxLimit) == null)", new Object[]{fieldName}).addStatement("return null", new Object[0]).endControlFlow().addStatement("fieldLimit = $LRO.limit()", new Object[]{fieldName});
                    }
                    this.builder.endControlFlow();
                }
                this.builder.addStatement("break", new Object[0]).endControlFlow();
            }
        }
    }

    private final class WrapMethodGenerator
    extends MethodSpecGenerator {
        private final List<ListField> fields;
        private final Byte missingFieldByte;
        private final AstType templateType;
        private final ClassName templateTypeName;

        private WrapMethodGenerator(Byte missingFieldByte, AstType templateType, TypeResolver resolver) {
            super(MethodSpec.methodBuilder((String)"wrap"));
            this.fields = new ArrayList<ListField>();
            this.missingFieldByte = missingFieldByte;
            this.templateType = templateType;
            this.templateTypeName = resolver.resolveClass(templateType);
        }

        public WrapMethodGenerator addMember(String name, TypeName type, Object defaultValue, boolean isRequired) {
            this.fields.add(new ListField(name, type, isRequired, defaultValue));
            return this;
        }

        private void generateWrapWithDefaultNull() {
            this.builder.addStatement("final int fieldCount = fieldCount()", new Object[0]).addStatement("bitmask = 0", new Object[0]);
            if (this.templateType == null) {
                this.builder.addStatement("int fieldLimit = offset + $L + $L", new Object[]{ListFlyweightGenerator.offset(ListFlyweightGenerator.FIELD_COUNT), ListFlyweightGenerator.size(ListFlyweightGenerator.FIELD_COUNT)});
            } else {
                this.builder.addStatement("DirectBuffer fieldsBuffer = fields()", new Object[0]).addStatement("int fieldLimit = 0", new Object[0]);
            }
            this.builder.beginControlFlow("for (int field = $L; field < fieldCount; field++)", new Object[]{ListFlyweightGenerator.fieldIndex(this.fields.get(0).fieldName())}).addStatement("checkLimit(fieldLimit + $T.SIZE_OF_BYTE, limit)", new Object[]{TypeNames.BIT_UTIL_TYPE}).beginControlFlow("switch (field)", new Object[0]);
            for (ListField field : this.fields) {
                String buffer;
                String fieldName = field.fieldName();
                this.builder.beginControlFlow("case $L:", new Object[]{ListFlyweightGenerator.fieldIndex(fieldName)});
                String string = buffer = this.templateType == null ? "buffer" : "fieldsBuffer";
                if (field.isRequired()) {
                    this.builder.addStatement("$LRO.wrap($L, fieldLimit, maxLimit)", new Object[]{fieldName, buffer}).addStatement("fieldLimit = $LRO.limit()", new Object[]{fieldName}).addStatement("bitmask |= 1 << $L", new Object[]{ListFlyweightGenerator.fieldIndex(fieldName)});
                } else {
                    this.builder.beginControlFlow("if ($L.getByte(fieldLimit) != MISSING_FIELD_BYTE)", new Object[]{buffer}).addStatement("$LRO.wrap($L, fieldLimit, maxLimit)", new Object[]{fieldName, buffer}).addStatement("fieldLimit = $LRO.limit()", new Object[]{fieldName}).addStatement("bitmask |= 1 << $L", new Object[]{ListFlyweightGenerator.fieldIndex(fieldName)}).endControlFlow().beginControlFlow("else", new Object[0]).addStatement("fieldLimit += MISSING_FIELD_BYTE_SIZE", new Object[0]).endControlFlow();
                }
                this.builder.addStatement("break", new Object[0]).endControlFlow();
            }
        }

        private void generateWrap() {
            this.builder.addStatement("final long bitmask = bitmask()", new Object[0]).addStatement("int fieldLimit = offset + $L + $L", new Object[]{ListFlyweightGenerator.offset(ListFlyweightGenerator.BIT_MASK), ListFlyweightGenerator.size(ListFlyweightGenerator.BIT_MASK)}).beginControlFlow("for (int field = $L; field < $L + 1; field++)", new Object[]{ListFlyweightGenerator.fieldIndex(this.fields.get(0).fieldName()), ListFlyweightGenerator.fieldIndex(this.fields.get(this.fields.size() - 1).fieldName())}).beginControlFlow("switch (field)", new Object[0]);
            for (ListField field : this.fields) {
                String fieldName = field.fieldName();
                this.builder.beginControlFlow("case $L:", new Object[]{ListFlyweightGenerator.fieldIndex(fieldName)});
                if (field.isRequired()) {
                    this.builder.beginControlFlow("if ((bitmask & $L) == 0)", new Object[]{ListFlyweightGenerator.maskConstant(fieldName)}).addStatement("throw new IllegalArgumentException(\"Field \\\"$L\\\" is required but not set\")", new Object[]{fieldName}).endControlFlow();
                    if (field.type().isPrimitive()) {
                        this.builder.addStatement("optionalOffsets[$L] = fieldLimit", new Object[]{ListFlyweightGenerator.fieldIndex(fieldName)}).addStatement("fieldLimit += $L", new Object[]{ListFlyweightGenerator.fieldSize(fieldName)});
                    } else {
                        this.builder.addStatement("$LRO.wrap(buffer, fieldLimit, maxLimit)", new Object[]{fieldName}).addStatement("fieldLimit = $LRO.limit()", new Object[]{fieldName});
                    }
                } else {
                    this.builder.beginControlFlow("if ((bitmask & $L) != 0)", new Object[]{ListFlyweightGenerator.maskConstant(fieldName)});
                    if (field.type().isPrimitive()) {
                        this.builder.addStatement("optionalOffsets[$L] = fieldLimit", new Object[]{ListFlyweightGenerator.fieldIndex(fieldName)}).addStatement("fieldLimit += $L", new Object[]{ListFlyweightGenerator.fieldSize(fieldName)});
                    } else {
                        this.builder.addStatement("$LRO.wrap(buffer, fieldLimit, maxLimit)", new Object[]{fieldName}).addStatement("fieldLimit = $LRO.limit()", new Object[]{fieldName});
                    }
                    this.builder.endControlFlow();
                }
                this.builder.addStatement("break", new Object[0]).endControlFlow();
            }
        }

        @Override
        public MethodSpec generate() {
            this.builder.addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(ListFlyweightGenerator.this.thisName).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]);
            if (this.templateType == null) {
                this.builder.addStatement("checkLimit(offset + $L + $L, maxLimit)", new Object[]{ListFlyweightGenerator.offset(ListFlyweightGenerator.LENGTH), ListFlyweightGenerator.size(ListFlyweightGenerator.LENGTH)});
            } else {
                this.builder.addStatement("$L.wrap(buffer, offset, maxLimit)", new Object[]{ListFlyweightGenerator.variantRO(this.templateTypeName)});
            }
            this.builder.addStatement("final int limit = limit()", new Object[0]).addStatement("checkLimit(limit, maxLimit)", new Object[0]);
            if (this.missingFieldByte == null && this.templateType == null) {
                this.generateWrap();
            } else {
                this.generateWrapWithDefaultNull();
            }
            return this.builder.endControlFlow().endControlFlow().addStatement("checkLimit(fieldLimit, limit)", new Object[0]).addStatement("return this", new Object[0]).build();
        }
    }

    private static final class HasFieldMethodGenerator
    extends ClassSpecMixinGenerator {
        private final AstType templateType;
        private final Byte nullValue;

        protected HasFieldMethodGenerator(ClassName thisType, TypeSpec.Builder builder, AstType templateType, Byte nullValue) {
            super(thisType, builder);
            this.templateType = templateType;
            this.nullValue = nullValue;
        }

        public HasFieldMethodGenerator addMember(String memberName) {
            CodeBlock.Builder codeBlock = CodeBlock.builder();
            String bitmask = this.nullValue == null && this.templateType == null ? "bitmask()" : "bitmask";
            codeBlock.addStatement("return ($L & $L) != 0L", new Object[]{bitmask, ListFlyweightGenerator.maskConstant(memberName)});
            this.builder.addMethod(MethodSpec.methodBuilder((String)ListFlyweightGenerator.methodName(String.format("has%s%s", Character.valueOf(Character.toUpperCase(memberName.charAt(0))), memberName.substring(1)))).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addCode(codeBlock.build()).build());
            return this;
        }
    }

    private static final class MemberAccessorGenerator
    extends ClassSpecMixinGenerator {
        private final TypeResolver resolver;
        private final Byte nullValue;
        private final AstType templateType;
        private final AstByteOrder byteOrder;

        private MemberAccessorGenerator(ClassName thisType, TypeSpec.Builder builder, AstType templateType, TypeResolver resolver, Byte nullValue, AstByteOrder byteOrder) {
            super(thisType, builder);
            this.resolver = resolver;
            this.nullValue = nullValue;
            this.templateType = templateType;
            this.byteOrder = byteOrder;
        }

        public MemberAccessorGenerator addMember(String name, AstType type, TypeName typeName, TypeName unsignedType, AstByteOrder byteOrder, boolean isRequired, Object defaultValue, AstType arrayItemTypeName, AstType mapKeyType, AstType mapValueType, ClassName mapParamName) {
            if (typeName.isPrimitive()) {
                this.addPrimitiveMember(name, typeName, unsignedType, byteOrder, isRequired, defaultValue);
            } else {
                this.addNonPrimitiveMember(name, type, typeName, isRequired, defaultValue, arrayItemTypeName, mapKeyType, mapValueType, mapParamName);
            }
            return this;
        }

        @Override
        public TypeSpec.Builder build() {
            if (this.nullValue == null && this.templateType == null) {
                MethodSpec.Builder bitmaskMethodBuilder = MethodSpec.methodBuilder((String)"bitmask").addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(Long.TYPE);
                if (this.byteOrder == AstByteOrder.NATIVE) {
                    bitmaskMethodBuilder.addStatement("return buffer().getLong(offset() + $L)", new Object[]{ListFlyweightGenerator.offset(ListFlyweightGenerator.BIT_MASK)});
                } else {
                    bitmaskMethodBuilder.addStatement("return buffer().getLong(offset() + $L, $T.BIG_ENDIAN)", new Object[]{ListFlyweightGenerator.offset(ListFlyweightGenerator.BIT_MASK), ByteOrder.class});
                }
                this.builder.addMethod(bitmaskMethodBuilder.build());
            }
            return super.build();
        }

        private void addPrimitiveMember(String name, TypeName type, TypeName unsignedType, AstByteOrder byteOrder, boolean isRequired, Object defaultValue) {
            TypeName generateType = unsignedType != null ? unsignedType : type;
            CodeBlock.Builder codeBlock = CodeBlock.builder();
            String getterName = (String)GETTER_NAMES.get(type);
            if (getterName == null) {
                throw new IllegalStateException("member type not supported: " + type);
            }
            if (!isRequired && defaultValue == null) {
                codeBlock.addStatement("assert (bitmask() & (1 << $L)) != 0 : \"Field \\\"$L\\\" is not set\"", new Object[]{ListFlyweightGenerator.fieldIndex(name), name});
            }
            codeBlock.add("$[", new Object[0]).add("return ", new Object[0]);
            if (defaultValue != null) {
                codeBlock.add("(bitmask() & (1 << $L)) == 0 ? $L : ", new Object[]{ListFlyweightGenerator.fieldIndex(name), ListFlyweightGenerator.defaultConstant(name)});
            }
            if (generateType != type) {
                codeBlock.add("($T)(", new Object[]{generateType});
            }
            codeBlock.add("buffer().$L(optionalOffsets[$L]", new Object[]{getterName, ListFlyweightGenerator.fieldIndex(name)});
            if (byteOrder == AstByteOrder.NETWORK && (type == TypeName.SHORT || type == TypeName.INT || type == TypeName.LONG)) {
                codeBlock.add(", $T.BIG_ENDIAN", new Object[]{ByteOrder.class});
            }
            if (generateType != type) {
                if (type == TypeName.BYTE) {
                    codeBlock.add(") & 0xFF)", new Object[0]);
                } else if (type == TypeName.SHORT) {
                    codeBlock.add(") & 0xFFFF)", new Object[0]);
                } else if (type == TypeName.INT) {
                    codeBlock.add(") & 0xFFFF_FFFFL)", new Object[0]);
                } else if (type == TypeName.LONG) {
                    codeBlock.add(") & 0xFFFF_FFFF)", new Object[0]);
                } else {
                    codeBlock.add(")", new Object[0]);
                }
            } else {
                codeBlock.add(")", new Object[0]);
            }
            codeBlock.add(";\n$]", new Object[0]);
            this.builder.addMethod(MethodSpec.methodBuilder((String)ListFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(generateType).addCode(codeBlock.build()).build());
        }

        private void addNonPrimitiveMember(String name, AstType type, TypeName typeName, boolean isRequired, Object defaultValue, AstType arrayItemTypeName, AstType mapKeyType, AstType mapValueType, ClassName mapParamName) {
            CodeBlock.Builder codeBlock = CodeBlock.builder();
            TypeName returnType = mapParamName == null ? typeName : ParameterizedTypeName.get((ClassName)((ClassName)typeName), (TypeName[])new TypeName[]{mapParamName});
            AstNamedNode namedNode = this.resolver.resolve(type.name());
            if (namedNode == null) {
                this.addMember(defaultValue, codeBlock, name, isRequired, "$LRO");
            } else {
                if (ListFlyweightGenerator.isTypedefType(namedNode.getKind())) {
                    while (ListFlyweightGenerator.isTypedefType(namedNode.getKind())) {
                        type = ((AstTypedefNode)namedNode).originalType();
                        namedNode = this.resolver.resolve(type.name());
                    }
                }
                if (ListFlyweightGenerator.isEnumType(namedNode.getKind())) {
                    returnType = this.addEnumMember(defaultValue, codeBlock, name, type, typeName, isRequired);
                } else if (ListFlyweightGenerator.isVariantType(namedNode.getKind())) {
                    returnType = this.addVariantMember(defaultValue, codeBlock, name, type, isRequired, arrayItemTypeName, mapKeyType, mapValueType);
                } else {
                    this.addMember(defaultValue, codeBlock, name, isRequired, "$LRO");
                }
            }
            this.builder.addMethod(MethodSpec.methodBuilder((String)ListFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(returnType).addCode(codeBlock.build()).build());
        }

        private TypeName addVariantMember(Object defaultValue, CodeBlock.Builder codeBlock, String name, AstType type, boolean isRequired, AstType arrayItemTypeName, AstType mapKeyType, AstType mapValueType) {
            AstVariantNode variantNode = (AstVariantNode)this.resolver.resolve(type.name());
            AstType ofType = variantNode.of();
            TypeName ofTypeName = this.resolver.resolveType(ofType);
            TypeName primitiveReturnType = ofTypeName.equals((Object)TypeName.BYTE) || ofTypeName.equals((Object)TypeName.SHORT) || ofTypeName.equals((Object)TypeName.INT) ? TypeName.INT : TypeName.LONG;
            TypeName returnType = Objects.requireNonNullElse(this.resolver.resolveUnsignedType(ofType), ofTypeName.isPrimitive() ? primitiveReturnType : (arrayItemTypeName != null ? ParameterizedTypeName.get((ClassName)this.resolver.resolveClass(AstType.ARRAY), (TypeName[])new TypeName[]{this.resolver.resolveType(arrayItemTypeName)}) : (mapKeyType != null ? ParameterizedTypeName.get((ClassName)this.resolver.resolveClass(AstType.MAP), (TypeName[])new TypeName[]{this.resolver.resolveClass(mapKeyType), this.resolver.resolveClass(mapValueType)}) : (AstType.BOUNDED_OCTETS.equals(ofType) ? this.resolver.resolveClass(AstType.BOUNDED_OCTETS) : this.resolver.resolveClass(AstType.STRING)))));
            this.addMember(defaultValue, codeBlock, name, isRequired, "$LRO.get()");
            return returnType;
        }

        private TypeName addEnumMember(Object defaultValue, CodeBlock.Builder codeBlock, String name, AstType type, TypeName typeName, boolean isRequired) {
            AstEnumNode enumNode = (AstEnumNode)this.resolver.resolve(type.name());
            ClassName enumFlyweightName = (ClassName)typeName;
            ClassName enumName = enumFlyweightName.peerClass(enumNode.name());
            this.addMember(defaultValue, codeBlock, name, isRequired, "$LRO.get()");
            return enumName;
        }

        private void addMember(Object defaultValue, CodeBlock.Builder codeBlock, String name, boolean isRequired, String returnValue) {
            String bitmask;
            String returnStatement = String.format("return %s", returnValue);
            String string = bitmask = this.nullValue == null && this.templateType == null ? "bitmask()" : "bitmask";
            if (defaultValue != null) {
                codeBlock.addStatement("return ($L & $L) != 0L ? $LRO.get() : $L", new Object[]{bitmask, ListFlyweightGenerator.maskConstant(name), name, ListFlyweightGenerator.defaultConstant(name)});
            } else {
                codeBlock.addStatement("assert ($L & $L) != 0L : \"Field \\\"$L\\\" is not set\"", new Object[]{bitmask, ListFlyweightGenerator.maskConstant(name), name});
                codeBlock.addStatement(returnStatement, new Object[]{name});
            }
        }
    }

    private static final class FieldsMethodGenerator
    extends ClassSpecMixinGenerator {
        private final AstType templateType;
        private final ClassName templateClassName;

        private FieldsMethodGenerator(ClassName thisType, TypeSpec.Builder builder, AstType templateType, TypeResolver resolver) {
            super(thisType, builder);
            this.templateType = templateType;
            this.templateClassName = resolver.resolveClass(templateType);
        }

        @Override
        public TypeSpec.Builder build() {
            if (this.templateType != null) {
                this.builder.addMethod(MethodSpec.methodBuilder((String)"fields").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeNames.DIRECT_BUFFER_TYPE).addAnnotation(Override.class).addStatement("return $L.get().fields()", new Object[]{ListFlyweightGenerator.variantRO(this.templateClassName)}).build());
            }
            return super.build();
        }
    }

    private static final class FieldCountMethodGenerator
    extends ClassSpecMixinGenerator {
        private final AstType templateType;
        private final TypeName fieldCountType;
        private final TypeResolver resolver;
        private final AstByteOrder byteOrder;

        private FieldCountMethodGenerator(ClassName thisType, TypeSpec.Builder builder, AstType templateType, TypeName fieldCountType, TypeResolver resolver, AstByteOrder byteOrder) {
            super(thisType, builder);
            this.templateType = templateType;
            this.fieldCountType = fieldCountType;
            this.resolver = resolver;
            this.byteOrder = byteOrder;
        }

        @Override
        public TypeSpec.Builder build() {
            MethodSpec.Builder fieldCountMethodBuilder = MethodSpec.methodBuilder((String)"fieldCount").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE);
            if (this.templateType == null) {
                if (this.byteOrder == AstByteOrder.NATIVE) {
                    fieldCountMethodBuilder.addStatement("return buffer().$L(offset() + $L)", new Object[]{GETTER_NAMES.get(this.fieldCountType), ListFlyweightGenerator.offset(ListFlyweightGenerator.FIELD_COUNT)});
                } else {
                    fieldCountMethodBuilder.addStatement("return buffer().$L(offset() + $L, $T.BIG_ENDIAN)", new Object[]{GETTER_NAMES.get(this.fieldCountType), ListFlyweightGenerator.offset(ListFlyweightGenerator.FIELD_COUNT), ByteOrder.class});
                }
                this.builder.addMethod(fieldCountMethodBuilder.build());
            } else {
                this.builder.addMethod(fieldCountMethodBuilder.addAnnotation(Override.class).addStatement("return $L.get().fieldCount()", new Object[]{ListFlyweightGenerator.variantRO(this.resolver.resolveClass(this.templateType))}).build());
            }
            return super.build();
        }
    }

    private static final class LengthMethodGenerator
    extends ClassSpecMixinGenerator {
        private final AstType templateType;
        private final TypeResolver resolver;

        private LengthMethodGenerator(ClassName thisType, TypeSpec.Builder builder, AstType templateType, TypeResolver resolver) {
            super(thisType, builder);
            this.templateType = templateType;
            this.resolver = resolver;
        }

        @Override
        public TypeSpec.Builder build() {
            if (this.templateType != null) {
                this.builder.addMethod(MethodSpec.methodBuilder((String)"length").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addAnnotation(Override.class).addStatement("return $L.get().length()", new Object[]{ListFlyweightGenerator.variantRO(this.resolver.resolveClass(this.templateType))}).build());
            }
            return super.build();
        }
    }

    private static final class OptionalOffsetsFieldGenerator
    extends ClassSpecMixinGenerator {
        private final AstType templateType;
        private final Byte nullValue;
        private String memberName;

        protected OptionalOffsetsFieldGenerator(ClassName thisType, TypeSpec.Builder builder, AstType templateType, Byte nullValue) {
            super(thisType, builder);
            this.templateType = templateType;
            this.nullValue = nullValue;
        }

        public OptionalOffsetsFieldGenerator addMember(String memberName) {
            this.memberName = memberName;
            return this;
        }

        @Override
        public TypeSpec.Builder build() {
            if (this.nullValue == null && this.templateType == null) {
                this.builder.addField(FieldSpec.builder(int[].class, (String)"optionalOffsets", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer(String.format("new int[%s + 1]", ListFlyweightGenerator.fieldIndex(this.memberName)), new Object[0]).build());
            }
            return super.build();
        }
    }

    private static final class MemberFieldGenerator
    extends ClassSpecMixinGenerator {
        private final TypeResolver resolver;

        private MemberFieldGenerator(ClassName thisType, TypeSpec.Builder builder, TypeResolver resolver) {
            super(thisType, builder);
            this.resolver = resolver;
        }

        public MemberFieldGenerator addMember(String name, AstType type, TypeName typeName, AstByteOrder byteOrder, AstType arrayItemTypeName, AstType variantOfMapKeyType, AstType variantOfMapValueType, ClassName mapParamName, ClassName originalMapKeyName, ClassName originalMapValueName) {
            if (!typeName.isPrimitive()) {
                this.addNonPrimitiveMember(name, type, typeName, byteOrder, arrayItemTypeName, variantOfMapKeyType, variantOfMapValueType, mapParamName, originalMapKeyName, originalMapValueName);
            }
            return this;
        }

        private MemberFieldGenerator addNonPrimitiveMember(String name, AstType type, TypeName typeName, AstByteOrder byteOrder, AstType arrayItemTypeName, AstType variantOfMapKeyType, AstType variantOfMapValueType, ClassName mapParamName, ClassName originalMapKeyName, ClassName originalMapValueName) {
            String fieldRO = String.format("%sRO", name);
            FieldSpec.Builder fieldBuilder = FieldSpec.builder((TypeName)typeName, (String)fieldRO, (Modifier[])new Modifier[]{Modifier.PRIVATE});
            if (typeName instanceof ClassName && (ListFlyweightGenerator.isString16Type((ClassName)typeName) || ListFlyweightGenerator.isString32Type((ClassName)typeName)) && byteOrder == AstByteOrder.NETWORK) {
                fieldBuilder.initializer("new $T($T.BIG_ENDIAN)", new Object[]{typeName, ByteOrder.class});
            } else if (arrayItemTypeName != null) {
                ParameterizedTypeName parameterizedArrayName = ParameterizedTypeName.get((ClassName)this.resolver.resolveClass(type), (TypeName[])new TypeName[]{this.resolver.resolveClass(arrayItemTypeName)});
                fieldBuilder = FieldSpec.builder((TypeName)parameterizedArrayName, (String)fieldRO, (Modifier[])new Modifier[]{Modifier.PRIVATE}).initializer("new $T<>(new $T())", new Object[]{typeName, this.resolver.resolveClass(arrayItemTypeName)});
            } else if (variantOfMapKeyType != null) {
                ClassName mapKeyClassName = this.resolver.resolveClass(variantOfMapKeyType);
                ClassName mapValueClassName = this.resolver.resolveClass(variantOfMapValueType);
                ParameterizedTypeName parameterizedMapName = ParameterizedTypeName.get((ClassName)this.resolver.resolveClass(type), (TypeName[])new TypeName[]{mapKeyClassName, mapValueClassName});
                fieldBuilder = FieldSpec.builder((TypeName)parameterizedMapName, (String)fieldRO, (Modifier[])new Modifier[]{Modifier.PRIVATE}).initializer("new $T<>(new $T(), new $T())", new Object[]{typeName, mapKeyClassName, mapValueClassName});
            } else if (mapParamName != null) {
                fieldBuilder = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)((ClassName)typeName), (TypeName[])new TypeName[]{mapParamName}), (String)fieldRO, (Modifier[])new Modifier[]{Modifier.PRIVATE}).initializer("new $T<>(new $T(), new $T())", new Object[]{typeName, originalMapKeyName, originalMapValueName});
            } else {
                fieldBuilder.initializer("new $T()", new Object[]{typeName});
            }
            this.builder.addField(fieldBuilder.build());
            return this;
        }
    }

    private static final class TemplateTypeFieldGenerator
    extends ClassSpecMixinGenerator {
        private final AstType templateType;
        private final TypeResolver resolver;

        private TemplateTypeFieldGenerator(ClassName thisType, TypeSpec.Builder builder, AstType templateType, TypeResolver resolver) {
            super(thisType, builder);
            this.templateType = templateType;
            this.resolver = resolver;
        }

        @Override
        public TypeSpec.Builder build() {
            if (this.templateType != null) {
                ClassName templateClassName = this.resolver.resolveClass(this.templateType);
                this.builder.addField(FieldSpec.builder((TypeName)templateClassName, (String)ListFlyweightGenerator.variantRO(templateClassName), (Modifier[])new Modifier[]{Modifier.PRIVATE}).initializer("new $T()", new Object[]{templateClassName}).build());
            }
            return super.build();
        }
    }

    private static final class MissingFieldByteConstantGenerator
    extends ClassSpecMixinGenerator {
        private final Byte missingFieldByte;
        private final AstType templateType;
        private final TypeResolver resolver;

        private MissingFieldByteConstantGenerator(ClassName thisType, TypeSpec.Builder builder, Byte missingFieldByte, AstType templateType, TypeResolver resolver) {
            super(thisType, builder);
            this.missingFieldByte = missingFieldByte;
            this.templateType = templateType;
            this.resolver = resolver;
        }

        @Override
        public TypeSpec.Builder build() {
            if (this.missingFieldByte != null || this.templateType != null) {
                FieldSpec.Builder missingFieldByteBuilder = FieldSpec.builder(Byte.TYPE, (String)"MISSING_FIELD_BYTE", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL});
                if (this.templateType == null) {
                    missingFieldByteBuilder.initializer(String.valueOf(this.missingFieldByte), new Object[0]);
                } else {
                    missingFieldByteBuilder.initializer("$T.MISSING_FIELD_PLACEHOLDER", new Object[]{this.resolver.resolveClass(this.templateType)});
                }
                this.builder.addField(missingFieldByteBuilder.build()).addField(FieldSpec.builder(Integer.TYPE, (String)"MISSING_FIELD_BYTE_SIZE", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.SIZE_OF_BYTE", new Object[]{TypeNames.BIT_UTIL_TYPE}).build());
            }
            return super.build();
        }
    }

    private static final class DefaultValueConstantGenerator
    extends ClassSpecMixinGenerator {
        private final TypeResolver resolver;

        DefaultValueConstantGenerator(ClassName thisType, TypeSpec.Builder builder, TypeResolver resolver) {
            super(thisType, builder);
            this.resolver = resolver;
        }

        public DefaultValueConstantGenerator addMember(String fieldName, AstType type, TypeName typeName, TypeName unsignedTypeName, Object defaultValue) {
            TypeName generateType;
            TypeName typeName2 = generateType = unsignedTypeName != null ? unsignedTypeName : typeName;
            if (defaultValue != null) {
                FieldSpec.Builder defaultValueBuilder = FieldSpec.builder((TypeName)generateType, (String)ListFlyweightGenerator.defaultConstant(fieldName), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
                AstNamedNode node = this.resolver.resolve(type.name());
                if (typeName.isPrimitive()) {
                    defaultValueBuilder.initializer("$L", new Object[]{defaultValue});
                } else if (ListFlyweightGenerator.isStringType((ClassName)typeName)) {
                    defaultValueBuilder.initializer("\"$L\"", new Object[]{defaultValue});
                } else {
                    if (ListFlyweightGenerator.isTypedefType(node.getKind())) {
                        while (ListFlyweightGenerator.isTypedefType(node.getKind())) {
                            type = ((AstTypedefNode)node).originalType();
                            node = this.resolver.resolve(type.name());
                        }
                    }
                    if (ListFlyweightGenerator.isVariantType(node.getKind())) {
                        AstVariantNode variantNode = (AstVariantNode)node;
                        AstType ofType = variantNode.of();
                        TypeName typeOfConstant = Objects.requireNonNullElse(this.resolver.resolveUnsignedType(ofType), this.resolver.resolveType(ofType));
                        defaultValueBuilder = FieldSpec.builder((TypeName)typeOfConstant, (String)ListFlyweightGenerator.defaultConstant(fieldName), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
                        if (ofType.equals(AstType.STRING8) || ofType.equals(AstType.STRING16) || ofType.equals(AstType.STRING32)) {
                            defaultValueBuilder.initializer("\"$L\"", new Object[]{defaultValue});
                        } else {
                            defaultValueBuilder.initializer("$L", new Object[]{defaultValue});
                        }
                    } else if (ListFlyweightGenerator.isEnumType(node.getKind())) {
                        AstEnumNode enumNode = (AstEnumNode)node;
                        ClassName enumFlyweightName = (ClassName)typeName;
                        ClassName enumName = enumFlyweightName.peerClass(enumNode.name());
                        defaultValueBuilder = FieldSpec.builder((TypeName)enumName, (String)ListFlyweightGenerator.defaultConstant(fieldName), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$T.$L", new Object[]{enumName, defaultValue});
                    }
                }
                this.builder.addField(defaultValueBuilder.build());
            }
            return this;
        }
    }

    private static final class FieldIndexConstantGenerator
    extends ClassSpecMixinGenerator {
        private int index;

        protected FieldIndexConstantGenerator(ClassName thisType, TypeSpec.Builder builder) {
            super(thisType, builder);
        }

        public FieldIndexConstantGenerator addMember(String fieldName) {
            this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)ListFlyweightGenerator.fieldIndex(fieldName), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$L", new Object[]{this.index}).build());
            ++this.index;
            return this;
        }

        @Override
        public TypeSpec.Builder build() {
            this.index = 0;
            return super.build();
        }
    }

    private static final class MemberSizeConstantGenerator
    extends ClassSpecMixinGenerator {
        private final List<ListField> fields = new ArrayList<ListField>();
        private final AstType templateType;
        private final TypeName lengthTypeName;
        private final TypeName fieldCountTypeName;
        private final Byte nullValue;

        private MemberSizeConstantGenerator(ClassName thisType, TypeSpec.Builder builder, AstType templateType, TypeName lengthTypeName, TypeName fieldCountTypeName, Byte nullValue) {
            super(thisType, builder);
            this.templateType = templateType;
            this.lengthTypeName = lengthTypeName;
            this.fieldCountTypeName = fieldCountTypeName;
            this.nullValue = nullValue;
        }

        public MemberSizeConstantGenerator addMember(String name, TypeName type) {
            if (type.isPrimitive()) {
                this.fields.add(new ListField(name, type, false, null));
            }
            return this;
        }

        @Override
        public TypeSpec.Builder build() {
            if (this.templateType == null) {
                this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)ListFlyweightGenerator.size(ListFlyweightGenerator.LENGTH), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.SIZE_OF_$L", new Object[]{TypeNames.BIT_UTIL_TYPE, TYPE_NAMES.get(this.lengthTypeName)}).build());
                this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)ListFlyweightGenerator.size(ListFlyweightGenerator.FIELD_COUNT), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.SIZE_OF_$L", new Object[]{TypeNames.BIT_UTIL_TYPE, TYPE_NAMES.get(this.fieldCountTypeName)}).build());
                if (this.nullValue == null) {
                    this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)ListFlyweightGenerator.size(ListFlyweightGenerator.BIT_MASK), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.SIZE_OF_LONG", new Object[]{TypeNames.BIT_UTIL_TYPE}).build());
                }
            }
            for (ListField field : this.fields) {
                this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)ListFlyweightGenerator.fieldSize(field.fieldName), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.SIZE_OF_$L", new Object[]{TypeNames.BIT_UTIL_TYPE, TYPE_NAMES.get(field.type)}).build());
            }
            return super.build();
        }
    }

    private static final class MaskConstantGenerator
    extends ClassSpecMixinGenerator {
        protected MaskConstantGenerator(ClassName thisType, TypeSpec.Builder builder) {
            super(thisType, builder);
        }

        public MaskConstantGenerator addMember(String name) {
            this.builder.addField(FieldSpec.builder(Long.TYPE, (String)ListFlyweightGenerator.maskConstant(name), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("1 << $L", new Object[]{ListFlyweightGenerator.fieldIndex(name)}).build());
            return this;
        }
    }

    private static final class MemberOffsetConstantGenerator
    extends ClassSpecMixinGenerator {
        private final AstType templateType;
        private final Byte nullValue;

        private MemberOffsetConstantGenerator(ClassName thisType, TypeSpec.Builder builder, AstType templateType, Byte nullValue) {
            super(thisType, builder);
            this.templateType = templateType;
            this.nullValue = nullValue;
        }

        @Override
        public TypeSpec.Builder build() {
            if (this.templateType == null) {
                this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)ListFlyweightGenerator.offset(ListFlyweightGenerator.LENGTH), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("0", new Object[0]).build());
                this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)ListFlyweightGenerator.offset(ListFlyweightGenerator.FIELD_COUNT), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(String.format("%s + %s", ListFlyweightGenerator.offset(ListFlyweightGenerator.LENGTH), ListFlyweightGenerator.size(ListFlyweightGenerator.LENGTH)), new Object[0]).build());
                if (this.nullValue == null) {
                    this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)ListFlyweightGenerator.offset(ListFlyweightGenerator.BIT_MASK), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(String.format("%s + %s", ListFlyweightGenerator.offset(ListFlyweightGenerator.FIELD_COUNT), ListFlyweightGenerator.size(ListFlyweightGenerator.FIELD_COUNT)), new Object[0]).build());
                    this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)ListFlyweightGenerator.offset(ListFlyweightGenerator.FIRST_FIELD), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(String.format("%s + %s", ListFlyweightGenerator.offset(ListFlyweightGenerator.BIT_MASK), ListFlyweightGenerator.size(ListFlyweightGenerator.BIT_MASK)), new Object[0]).build());
                } else {
                    this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)ListFlyweightGenerator.offset(ListFlyweightGenerator.FIRST_FIELD), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(String.format("%s + %s", ListFlyweightGenerator.offset(ListFlyweightGenerator.FIELD_COUNT), ListFlyweightGenerator.size(ListFlyweightGenerator.FIELD_COUNT)), new Object[0]).build());
                }
            }
            return super.build();
        }
    }
}

