/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.generate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.lang.model.element.Modifier;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstByteOrder;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstNamedNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstType;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstVariantNode;
import org.reaktivity.nukleus.maven.plugin.internal.generate.ClassSpecGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.ClassSpecMixinGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.MethodSpecGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeNames;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeResolver;

public final class VariantFlyweightGenerator
extends ClassSpecGenerator {
    private static final Map<String, String> NUMBER_WORDS;
    private static final Map<TypeName, String> TYPE_NAMES;
    private static final Map<String, Long> BIT_MASK_LONG;
    private static final Map<String, Integer> BIT_MASK_INT;
    private static final Map<TypeName, String> CLASS_NAMES;
    private static final Set<TypeName> INTEGER_TYPES;
    private final String baseName;
    private final TypeSpec.Builder builder;
    private final MemberFieldGenerator memberField;
    private final KindConstantGenerator memberKindConstant;
    private final MemberSizeConstantGenerator memberSizeConstant;
    private final MemberOffsetConstantGenerator memberOffsetConstant;
    private final MemberFieldValueConstantGenerator memberFieldValueConstant;
    private final MissingFieldPlaceholderConstantGenerator missingFieldPlaceholderConstant;
    private final ConstructorGenerator constructor;
    private final TryWrapMethodGenerator tryWrapMethod;
    private final WrapMethodGenerator wrapMethod;
    private final WrapMethodWithArrayGenerator wrapMethodWithArray;
    private final ToStringMethodGenerator toStringMethod;
    private final StringOfTypeMethodsGenerator stringOfTypeMethods;
    private final ListOfTypeMethodsGenerator listOfTypeMethods;
    private final ArrayOfTypeMethodsGenerator arrayOfTypeMethods;
    private final OctetsOfTypeMethodsGenerator octetsOfTypeMethods;
    private final KindAccessorGenerator kindAccessor;
    private final MemberAccessorGenerator memberAccessor;
    private final LimitMethodGenerator limitMethod;
    private final MapOfTypeMethodsGenerator mapOfTypeMethods;
    private final BuilderClassGenerator builderClass;
    private final GetMethodGenerator getMethod;
    private final BitMaskConstantGenerator bitMaskConstant;
    private final TypeVariableName typeVarV;
    private final TypeVariableName typeVarO;
    private final TypeVariableName typeVarKV;
    private final TypeVariableName typeVarVV;
    private final TypeVariableName anyType = TypeVariableName.get((String)"?");

    public VariantFlyweightGenerator(ClassName variantName, ClassName flyweightName, String baseName, TypeName kindTypeName, AstType ofType, TypeName ofTypeName, TypeName unsignedOfTypeName, TypeResolver resolver, AstByteOrder byteOrder) {
        super(variantName);
        this.typeVarO = TypeVariableName.get((String)"O", (TypeName[])new TypeName[]{flyweightName});
        this.typeVarV = TypeVariableName.get((String)"V", (TypeName[])new TypeName[]{flyweightName});
        this.typeVarKV = TypeVariableName.get((String)"K", (TypeName[])new TypeName[]{flyweightName});
        this.typeVarVV = TypeVariableName.get((String)"V", (TypeName[])new TypeName[]{flyweightName});
        this.baseName = baseName;
        this.builder = this.builder(variantName, kindTypeName, ofType, resolver);
        this.memberField = new MemberFieldGenerator(variantName, kindTypeName, ofType, this.typeVarV, this.typeVarKV, this.typeVarVV, this.builder, resolver, byteOrder);
        this.memberKindConstant = new KindConstantGenerator(variantName, kindTypeName, ofType, this.builder);
        this.memberSizeConstant = new MemberSizeConstantGenerator(variantName, kindTypeName, this.builder);
        this.memberOffsetConstant = new MemberOffsetConstantGenerator(variantName, kindTypeName, this.builder);
        this.memberFieldValueConstant = new MemberFieldValueConstantGenerator(variantName, this.builder);
        this.missingFieldPlaceholderConstant = new MissingFieldPlaceholderConstantGenerator(variantName, this.builder);
        this.constructor = new ConstructorGenerator(ofType, this.typeVarV, this.typeVarKV, this.typeVarVV, byteOrder);
        this.tryWrapMethod = new TryWrapMethodGenerator(kindTypeName, ofType, resolver);
        this.wrapMethod = new WrapMethodGenerator(kindTypeName, ofType, resolver);
        this.wrapMethodWithArray = new WrapMethodWithArrayGenerator(kindTypeName, ofType, resolver);
        this.toStringMethod = new ToStringMethodGenerator(kindTypeName, ofType, resolver);
        this.stringOfTypeMethods = new StringOfTypeMethodsGenerator(variantName, this.builder, kindTypeName, ofType);
        this.listOfTypeMethods = new ListOfTypeMethodsGenerator(variantName, this.builder, kindTypeName, ofType);
        this.arrayOfTypeMethods = new ArrayOfTypeMethodsGenerator(variantName, this.builder, kindTypeName, this.typeVarV, ofType);
        this.octetsOfTypeMethods = new OctetsOfTypeMethodsGenerator(variantName, flyweightName, this.builder, kindTypeName, ofType);
        this.kindAccessor = new KindAccessorGenerator(variantName, kindTypeName, ofType, this.builder);
        this.memberAccessor = new MemberAccessorGenerator(variantName, kindTypeName, ofType, this.builder, resolver, byteOrder);
        this.limitMethod = new LimitMethodGenerator(kindTypeName, ofType, resolver);
        this.mapOfTypeMethods = new MapOfTypeMethodsGenerator(variantName, ofType, this.builder);
        this.getMethod = new GetMethodGenerator(kindTypeName, ofType, ofTypeName, unsignedOfTypeName, resolver);
        this.bitMaskConstant = new BitMaskConstantGenerator(variantName, ofTypeName, this.builder);
        this.builderClass = new BuilderClassGenerator(variantName, flyweightName, kindTypeName, ofType, ofTypeName, unsignedOfTypeName, resolver, this.typeVarO, byteOrder);
    }

    public VariantFlyweightGenerator addMember(Object kindValue, String memberName, AstType memberType, TypeName memberTypeName, TypeName unsignedMemberTypeName, int missingFieldValue, AstType mapKeyType, AstType mapValueType) {
        this.memberKindConstant.addMember(kindValue, memberName, memberType, memberTypeName);
        this.memberOffsetConstant.addMember(memberName, memberTypeName);
        this.memberFieldValueConstant.addMember(memberName, memberTypeName);
        this.memberField.addMember(memberName, memberType, memberTypeName, mapKeyType, mapValueType);
        this.memberSizeConstant.addMember(memberName, memberTypeName, unsignedMemberTypeName);
        this.missingFieldPlaceholderConstant.addMember(memberType, missingFieldValue);
        this.constructor.addMember(memberName, memberType, memberTypeName);
        this.wrapMethod.addMember(kindValue, memberName, memberTypeName, mapKeyType);
        this.wrapMethodWithArray.addMember(kindValue, memberName);
        this.tryWrapMethod.addMember(kindValue, memberName, memberTypeName, mapKeyType);
        this.toStringMethod.addMember(memberName, kindValue, memberName, memberType, memberTypeName, mapKeyType);
        this.memberAccessor.addMember(memberName, memberType, memberTypeName, unsignedMemberTypeName, mapKeyType, mapValueType);
        this.limitMethod.addMember(memberName, kindValue, memberName, memberTypeName, mapKeyType);
        this.getMethod.addMember(memberName, kindValue, memberType, memberTypeName);
        this.bitMaskConstant.addMember(memberName, memberType, memberTypeName, unsignedMemberTypeName);
        this.builderClass.addMember(kindValue, memberName, memberType, memberTypeName, unsignedMemberTypeName, mapKeyType, mapValueType);
        return this;
    }

    @Override
    public TypeSpec generate() {
        this.memberKindConstant.build();
        this.memberSizeConstant.build();
        this.missingFieldPlaceholderConstant.build();
        this.memberField.build();
        this.kindAccessor.build();
        this.memberAccessor.build();
        this.bitMaskConstant.build();
        this.constructor.mixin(this.builder);
        this.getMethod.mixin(this.builder);
        this.tryWrapMethod.mixin(this.builder);
        this.wrapMethod.mixin(this.builder);
        this.wrapMethodWithArray.mixin(this.builder);
        this.toStringMethod.mixin(this.builder);
        this.stringOfTypeMethods.build();
        this.listOfTypeMethods.build();
        this.arrayOfTypeMethods.build();
        this.octetsOfTypeMethods.build();
        this.limitMethod.mixin(this.builder);
        this.mapOfTypeMethods.build();
        return this.builder.addType(this.builderClass.generate()).build();
    }

    private TypeSpec.Builder builder(ClassName variantName, TypeName kindTypeName, AstType ofType, TypeResolver resolver) {
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((ClassName)variantName);
        if ((VariantFlyweightGenerator.isListType(ofType) || VariantFlyweightGenerator.isStringType(ofType) || VariantFlyweightGenerator.isBoundedOctetsType(ofType)) && !kindTypeName.isPrimitive()) {
            return classBuilder.superclass((TypeName)resolver.resolveClass(ofType)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        }
        if (VariantFlyweightGenerator.isArrayType(ofType)) {
            ParameterizedTypeName parameterizedOfTypeName = ParameterizedTypeName.get((ClassName)resolver.resolveClass(ofType), (TypeName[])new TypeName[]{this.typeVarV});
            return classBuilder.addTypeVariable(this.typeVarV).superclass((TypeName)parameterizedOfTypeName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        }
        if (VariantFlyweightGenerator.isMapType(ofType)) {
            return classBuilder.addTypeVariable(this.typeVarKV).addTypeVariable(this.typeVarVV).superclass((TypeName)ParameterizedTypeName.get((ClassName)resolver.resolveClass(ofType), (TypeName[])new TypeName[]{this.typeVarKV, this.typeVarVV})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        }
        return classBuilder.superclass((TypeName)resolver.flyweightName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
    }

    private static boolean isNonPrimitiveType(AstType type) {
        return VariantFlyweightGenerator.isListType(type) || VariantFlyweightGenerator.isStringType(type) || VariantFlyweightGenerator.isArrayType(type) || VariantFlyweightGenerator.isMapType(type) || VariantFlyweightGenerator.isBoundedOctetsType(type);
    }

    private static boolean isListType(AstType type) {
        return AstType.LIST.equals(type);
    }

    private static boolean isArrayType(AstType type) {
        return AstType.ARRAY.equals(type) || AstType.ARRAY8.equals(type) || AstType.ARRAY16.equals(type) || AstType.ARRAY32.equals(type);
    }

    private static boolean isMapType(AstType type) {
        return AstType.MAP.equals(type);
    }

    private static boolean isBoundedOctetsType(AstType type) {
        return AstType.BOUNDED_OCTETS.equals(type);
    }

    private static boolean isStringType(AstType type) {
        return AstType.STRING.equals(type) || AstType.STRING8.equals(type) || AstType.STRING16.equals(type) || AstType.STRING32.equals(type);
    }

    private static boolean isStringType(ClassName classType) {
        return VariantFlyweightGenerator.isString8Type(classType) || VariantFlyweightGenerator.isString16Type(classType) || VariantFlyweightGenerator.isString32Type(classType);
    }

    private static boolean isString8Type(ClassName classType) {
        String name = classType.simpleName();
        return "String8FW".equals(name);
    }

    private static boolean isString16Type(ClassName classType) {
        String name = classType.simpleName();
        return "String16FW".equals(name);
    }

    private static boolean isString32Type(ClassName classType) {
        String name = classType.simpleName();
        return "String32FW".equals(name);
    }

    private static ClassName enumClassName(TypeName enumFWTypeName) {
        String enumFWName = ((ClassName)enumFWTypeName).simpleName();
        return ClassName.bestGuess((String)enumFWName.substring(0, enumFWName.length() - 2));
    }

    private static String enumFWName(TypeName enumFWTypeName) {
        String enumFWName = ((ClassName)enumFWTypeName).simpleName();
        return String.format("%s%s", Character.valueOf(Character.toLowerCase(enumFWName.charAt(0))), enumFWName.substring(1, enumFWName.length() - 2));
    }

    private static String fieldName(TypeName type) {
        String fieldName = ((ClassName)type).simpleName();
        return String.format("%s%s", Character.valueOf(Character.toLowerCase(fieldName.charAt(0))), fieldName.substring(1, fieldName.length() - 2));
    }

    private static String enumRO(TypeName enumFWTypeName) {
        String enumFWName = ((ClassName)enumFWTypeName).simpleName();
        return String.format("%s%sRO", Character.valueOf(Character.toLowerCase(enumFWName.charAt(0))), enumFWName.substring(1, enumFWName.length() - 2));
    }

    private static String enumRW(TypeName enumFWTypeName) {
        String enumFWName = ((ClassName)enumFWTypeName).simpleName();
        return String.format("%s%sRW", Character.valueOf(Character.toLowerCase(enumFWName.charAt(0))), enumFWName.substring(1, enumFWName.length() - 2));
    }

    private static String listClassName(String listTypeName) {
        return String.format("%s%sFW", Character.valueOf(Character.toUpperCase(listTypeName.charAt(0))), listTypeName.substring(1));
    }

    private static int typeSize(AstType type) {
        return Integer.parseInt(type.name().replaceAll("\\D+", ""));
    }

    private static String bitMask(String fieldName) {
        return String.format("BIT_MASK_%s", VariantFlyweightGenerator.constant(fieldName));
    }

    private static String value(String fieldName) {
        String filteredName = NUMBER_WORDS.get(fieldName) == null ? fieldName : NUMBER_WORDS.get(fieldName);
        return String.format("FIELD_VALUE_%s", VariantFlyweightGenerator.constant(filteredName));
    }

    private static String kind(String fieldName) {
        String filteredName = NUMBER_WORDS.get(fieldName) == null ? fieldName : NUMBER_WORDS.get(fieldName);
        return String.format("KIND_%s", VariantFlyweightGenerator.constant(filteredName));
    }

    private static String offset(String fieldName) {
        return String.format("FIELD_OFFSET_%s", VariantFlyweightGenerator.constant(fieldName));
    }

    private static String size(String fieldName) {
        String filteredName = NUMBER_WORDS.get(fieldName) == null ? fieldName : NUMBER_WORDS.get(fieldName);
        return String.format("FIELD_SIZE_%s", VariantFlyweightGenerator.constant(filteredName));
    }

    private static String getAs(String fieldName) {
        String filteredName = NUMBER_WORDS.get(fieldName) == null ? fieldName : NUMBER_WORDS.get(fieldName);
        return String.format("getAs%s%s", Character.valueOf(Character.toUpperCase(filteredName.charAt(0))), filteredName.substring(1));
    }

    private static String setAs(String fieldName) {
        String filteredName = NUMBER_WORDS.get(fieldName) == null ? fieldName : NUMBER_WORDS.get(fieldName);
        return String.format("setAs%s%s", Character.valueOf(Character.toUpperCase(filteredName.charAt(0))), filteredName.substring(1));
    }

    private static String constant(String fieldName) {
        return fieldName.replaceAll("([^_A-Z])([A-Z])", "$1_$2").toUpperCase();
    }

    static {
        HashMap<String, String> numberByWord = new HashMap<String, String>();
        numberByWord.put("0", "zero");
        numberByWord.put("1", "one");
        NUMBER_WORDS = Collections.unmodifiableMap(numberByWord);
        HashMap<TypeName, String> typeNames = new HashMap<TypeName, String>();
        typeNames.put(TypeName.BYTE, "Byte");
        typeNames.put(TypeName.CHAR, "Char");
        typeNames.put(TypeName.SHORT, "Short");
        typeNames.put(TypeName.INT, "Int");
        typeNames.put(TypeName.FLOAT, "Float");
        typeNames.put(TypeName.LONG, "Long");
        typeNames.put(TypeName.DOUBLE, "Double");
        TYPE_NAMES = Collections.unmodifiableMap(typeNames);
        HashMap<String, Long> longBitMaskValues = new HashMap<String, Long>();
        longBitMaskValues.put("int8", -128L);
        longBitMaskValues.put("int16", -32768L);
        longBitMaskValues.put("int24", -8388608L);
        longBitMaskValues.put("int32", (Long)Integer.MIN_VALUE);
        BIT_MASK_LONG = Collections.unmodifiableMap(longBitMaskValues);
        HashMap<String, Integer> intBitMaskValues = new HashMap<String, Integer>();
        intBitMaskValues.put("int8", -128);
        intBitMaskValues.put("int16", (Integer)Short.MIN_VALUE);
        intBitMaskValues.put("int24", -8388608);
        BIT_MASK_INT = Collections.unmodifiableMap(intBitMaskValues);
        HashMap<TypeName, String> classNames = new HashMap<TypeName, String>();
        classNames.put(TypeName.BYTE, "Byte");
        classNames.put(TypeName.SHORT, "Short");
        classNames.put(TypeName.INT, "Integer");
        classNames.put(TypeName.FLOAT, "Float");
        classNames.put(TypeName.LONG, "Long");
        classNames.put(TypeName.DOUBLE, "Double");
        CLASS_NAMES = Collections.unmodifiableMap(classNames);
        HashSet<TypeName> integerTypes = new HashSet<TypeName>();
        integerTypes.add(TypeName.INT);
        integerTypes.add(TypeName.SHORT);
        integerTypes.add(TypeName.BYTE);
        INTEGER_TYPES = integerTypes;
    }

    private static final class BuilderClassGenerator
    extends ClassSpecGenerator {
        private final TypeSpec.Builder builder;
        private final ClassName variantType;
        private final KindMethodGenerator kindMethod;
        private final ItemMethodGenerator itemMethod;
        private final EntryMethodGenerator entryMethod;
        private final EntriesMethodGenerator entriesMethod;
        private final MaxKindMethodGenerator maxKindMethod;
        private final MinKindMethodGenerator minKindMethod;
        private final FieldMethodGenerator fieldMethod;
        private final FieldsMethodGenerator fieldsMethod;
        private final ConstructorGenerator constructor;
        private final SetAsFieldMethodGenerator setAsFieldMethod;
        private final SetAsFieldMethodForStringOfTypeGenerator setAsFieldMethodForStringOfType;
        private final SetAsFieldMethodForOctetsOfTypeGenerator setAsFieldMethodForOctetsOfType;
        private final SetWithSpecificKindMethodGenerator setWithSpecificKindMethod;
        private final MemberFieldGenerator memberField;
        private final WrapMethodGenerator wrapMethod;
        private final WrapMethodWithArrayGenerator wrapMethodWithArray;
        private final ResetMethodGenerator resetMethod;
        private final SizeOfMethodGenerator sizeOfMethod;
        private final RebuildMethodGenerator rebuildMethod;
        private final SetMethodGenerator setMethod;
        private final SetMethodWithBufferGenerator setMethodWithBuffer;
        private final SetMethodWithStringGenerator setMethodWithString;
        private final SetMethodWithByteArrayGenerator setMethodWithByteArray;
        private final BuildMethodGenerator buildMethod;
        private final SetList32FieldsMethodGenerator setList32FieldsMethod;
        private final ArrayFieldGenerator arrayField;
        private final TypeVariableName typeVarB;
        private final TypeVariableName typeVarV;
        private final TypeVariableName typeVarK;
        private final TypeVariableName typeVarO;
        private final TypeVariableName typeVarKB;
        private final TypeVariableName typeVarKV;
        private final TypeVariableName typeVarVB;
        private final TypeVariableName typeVarVV;

        private BuilderClassGenerator(ClassName thisVariantType, ClassName flyweightType, TypeName kindTypeName, AstType ofType, TypeName ofTypeName, TypeName unsignedOfTypeName, TypeResolver resolver, TypeVariableName typeVarO, AstByteOrder byteOrder) {
            this(thisVariantType.nestedClass("Builder"), flyweightType, flyweightType.nestedClass("Builder"), thisVariantType, kindTypeName, ofType, ofTypeName, unsignedOfTypeName, resolver, typeVarO, byteOrder);
        }

        private BuilderClassGenerator(ClassName thisVariantBuilderType, ClassName flyweightType, ClassName flyweightBuilderRawType, ClassName thisVariantType, TypeName kindTypeName, AstType ofType, TypeName ofTypeName, TypeName unsignedOfTypeName, TypeResolver resolver, TypeVariableName typeVarO, AstByteOrder byteOrder) {
            super(thisVariantBuilderType);
            this.typeVarO = typeVarO;
            this.typeVarK = TypeVariableName.get((String)"K");
            this.typeVarV = TypeVariableName.get((String)"V", (TypeName[])new TypeName[]{flyweightType});
            this.typeVarB = TypeVariableName.get((String)"B", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)flyweightBuilderRawType, (TypeName[])new TypeName[]{this.typeVarV})});
            this.typeVarKV = TypeVariableName.get((String)"K", (TypeName[])new TypeName[]{flyweightType});
            this.typeVarKB = TypeVariableName.get((String)"KB", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)flyweightBuilderRawType, (TypeName[])new TypeName[]{this.typeVarKV})});
            this.typeVarVV = TypeVariableName.get((String)"V", (TypeName[])new TypeName[]{flyweightType});
            this.typeVarVB = TypeVariableName.get((String)"VB", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)flyweightBuilderRawType, (TypeName[])new TypeName[]{this.typeVarVV})});
            this.builder = TypeSpec.classBuilder((String)thisVariantBuilderType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
            this.builder(flyweightBuilderRawType, thisVariantType, kindTypeName, ofType, resolver);
            this.variantType = thisVariantType;
            this.kindMethod = new KindMethodGenerator(kindTypeName, ofType);
            this.maxKindMethod = new MaxKindMethodGenerator(kindTypeName, ofType);
            this.minKindMethod = new MinKindMethodGenerator(kindTypeName, ofType);
            this.itemMethod = new ItemMethodGenerator(thisVariantType, this.builder, ofType);
            this.entryMethod = new EntryMethodGenerator(ofType);
            this.entriesMethod = new EntriesMethodGenerator(ofType);
            this.fieldMethod = new FieldMethodGenerator(flyweightBuilderRawType, ofType);
            this.fieldsMethod = new FieldsMethodGenerator(thisVariantBuilderType, ofType, flyweightBuilderRawType, this.builder);
            this.wrapMethod = new WrapMethodGenerator(ofType, kindTypeName);
            this.wrapMethodWithArray = new WrapMethodWithArrayGenerator(thisVariantType, ofType, kindTypeName, resolver);
            this.resetMethod = new ResetMethodGenerator(thisVariantType, ofType, kindTypeName, resolver);
            this.sizeOfMethod = new SizeOfMethodGenerator(thisVariantType, kindTypeName, ofType, this.builder);
            this.rebuildMethod = new RebuildMethodGenerator(thisVariantType, kindTypeName, ofType, ofTypeName, this.builder);
            this.setAsFieldMethod = new SetAsFieldMethodGenerator(thisVariantBuilderType, kindTypeName, ofType, ofTypeName, this.builder, resolver, byteOrder);
            this.setAsFieldMethodForStringOfType = new SetAsFieldMethodForStringOfTypeGenerator(thisVariantBuilderType, kindTypeName, ofType, ofTypeName, this.builder);
            this.setAsFieldMethodForOctetsOfType = new SetAsFieldMethodForOctetsOfTypeGenerator(thisVariantBuilderType, kindTypeName, ofType, this.builder);
            this.setWithSpecificKindMethod = new SetWithSpecificKindMethodGenerator(kindTypeName, ofType, resolver);
            this.memberField = new MemberFieldGenerator(thisVariantBuilderType, kindTypeName, this.typeVarB, this.typeVarV, this.typeVarKB, this.typeVarKV, this.typeVarVB, this.typeVarVV, ofType, this.builder, resolver, byteOrder);
            this.constructor = new ConstructorGenerator(thisVariantType, ofType, this.typeVarB, this.typeVarV, this.typeVarKB, this.typeVarKV, this.typeVarVB, this.typeVarVV);
            this.setMethod = new SetMethodGenerator(ofType, ofTypeName, unsignedOfTypeName, kindTypeName, resolver);
            this.setMethodWithBuffer = new SetMethodWithBufferGenerator(kindTypeName, ofType);
            this.setMethodWithString = new SetMethodWithStringGenerator(kindTypeName, ofType);
            this.setMethodWithByteArray = new SetMethodWithByteArrayGenerator(kindTypeName, ofType);
            this.buildMethod = new BuildMethodGenerator(kindTypeName, thisVariantType, ofType);
            this.setList32FieldsMethod = new SetList32FieldsMethodGenerator(ofType);
            this.arrayField = new ArrayFieldGenerator(thisVariantType, flyweightBuilderRawType, kindTypeName, ofType, resolver, this.builder);
        }

        private void builder(ClassName flyweightBuilderRawType, ClassName thisVariantType, TypeName kindTypeName, AstType ofType, TypeResolver resolver) {
            if ((VariantFlyweightGenerator.isStringType(ofType) || VariantFlyweightGenerator.isListType(ofType) || VariantFlyweightGenerator.isBoundedOctetsType(ofType)) && !kindTypeName.isPrimitive()) {
                ClassName ofTypeClassBuilderName = resolver.resolveClass(ofType).nestedClass("Builder");
                this.builder.superclass((TypeName)ParameterizedTypeName.get((ClassName)ofTypeClassBuilderName, (TypeName[])new TypeName[]{thisVariantType})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            } else if (VariantFlyweightGenerator.isArrayType(ofType)) {
                ClassName ofTypeBuilderName = resolver.resolveClass(ofType).nestedClass("Builder");
                ParameterizedTypeName parameterizedVariantType = ParameterizedTypeName.get((ClassName)thisVariantType, (TypeName[])new TypeName[]{this.typeVarV});
                ParameterizedTypeName parameterizedSuperType = ParameterizedTypeName.get((ClassName)ofTypeBuilderName, (TypeName[])new TypeName[]{parameterizedVariantType, this.typeVarB, this.typeVarV});
                this.builder.addTypeVariable(this.typeVarB).addTypeVariable(this.typeVarV).superclass((TypeName)parameterizedSuperType);
            } else if (VariantFlyweightGenerator.isMapType(ofType)) {
                ClassName mapBuilderType = resolver.resolveClass(ofType).nestedClass("Builder");
                ParameterizedTypeName parameterizedVariantType = ParameterizedTypeName.get((ClassName)thisVariantType, (TypeName[])new TypeName[]{this.typeVarKV, this.typeVarVV});
                ParameterizedTypeName parameterizedSuperType = ParameterizedTypeName.get((ClassName)mapBuilderType, (TypeName[])new TypeName[]{parameterizedVariantType, this.typeVarKV, this.typeVarVV, this.typeVarKB, this.typeVarVB});
                this.builder.addTypeVariable(this.typeVarKV).addTypeVariable(this.typeVarVV).addTypeVariable(this.typeVarKB).addTypeVariable(this.typeVarVB).superclass((TypeName)parameterizedSuperType);
            } else {
                this.builder.superclass((TypeName)ParameterizedTypeName.get((ClassName)flyweightBuilderRawType, (TypeName[])new TypeName[]{thisVariantType}));
            }
        }

        private void addMember(Object kindValue, String memberName, AstType memberType, TypeName memberTypeName, TypeName unsignedMemberTypeName, AstType mapKeyType, AstType mapValueType) {
            this.maxKindMethod.addMember(memberName);
            this.minKindMethod.addMember(memberName, memberTypeName, unsignedMemberTypeName);
            this.itemMethod.addMember(memberType);
            this.entryMethod.addMember(memberType);
            this.entriesMethod.addMember(memberType);
            this.fieldMethod.addMember(memberType);
            this.fieldsMethod.addMember(memberType);
            this.wrapMethod.addMember(memberType);
            this.setAsFieldMethod.addMember(kindValue, memberName, memberType, memberTypeName, unsignedMemberTypeName, mapKeyType, mapValueType);
            this.setAsFieldMethodForStringOfType.addMember(memberName, memberType, memberTypeName);
            this.setAsFieldMethodForOctetsOfType.addMember(memberName, memberType, memberTypeName);
            this.setWithSpecificKindMethod.addMember(kindValue, memberName);
            this.memberField.addMember(memberName, memberType, memberTypeName, mapKeyType, mapValueType);
            this.constructor.addMember(memberName, memberTypeName);
            this.setMethod.addMember(memberName, memberType, memberTypeName, unsignedMemberTypeName);
            this.setMethodWithBuffer.addMember(memberName, memberTypeName, unsignedMemberTypeName);
            this.setMethodWithString.addMember(memberName, memberTypeName, unsignedMemberTypeName);
            this.setMethodWithByteArray.addMember(memberName, memberTypeName, unsignedMemberTypeName);
            this.buildMethod.addMember(memberType);
            this.setList32FieldsMethod.addMember(memberType);
        }

        @Override
        public TypeSpec generate() {
            this.maxKindMethod.mixin(this.builder);
            this.itemMethod.build();
            this.entryMethod.mixin(this.builder);
            this.entriesMethod.mixin(this.builder);
            this.fieldMethod.mixin(this.builder);
            this.fieldsMethod.build();
            this.setAsFieldMethod.build();
            this.setAsFieldMethodForStringOfType.build();
            this.setAsFieldMethodForOctetsOfType.build();
            this.setWithSpecificKindMethod.mixin(this.builder);
            this.memberField.build();
            this.setMethod.mixin(this.builder);
            this.setMethodWithBuffer.mixin(this.builder);
            this.setMethodWithString.mixin(this.builder);
            this.setMethodWithByteArray.mixin(this.builder);
            this.wrapMethod.mixin(this.builder);
            this.wrapMethodWithArray.mixin(this.builder);
            this.resetMethod.mixin(this.builder);
            this.sizeOfMethod.build();
            this.rebuildMethod.build();
            this.buildMethod.mixin(this.builder);
            this.setList32FieldsMethod.mixin(this.builder);
            this.minKindMethod.mixin(this.builder);
            this.kindMethod.mixin(this.builder);
            this.arrayField.build();
            return this.builder.addMethod(this.constructor.generate()).build();
        }

        private static final class ArrayFieldGenerator
        extends ClassSpecMixinGenerator {
            private ArrayFieldGenerator(ClassName thisType, ClassName flyweightBuilderRawType, TypeName kindTypeName, AstType ofType, TypeResolver resolver, TypeSpec.Builder builder) {
                super(thisType, builder);
                if (VariantFlyweightGenerator.isStringType(ofType) && !kindTypeName.isPrimitive()) {
                    ClassName arrayClassName = resolver.resolveClass(AstType.ARRAY);
                    ClassName arrayBuilderClassName = arrayClassName.nestedClass("Builder");
                    WildcardTypeName typeParamT = WildcardTypeName.subtypeOf((TypeName)ParameterizedTypeName.get((ClassName)arrayClassName, (TypeName[])new TypeName[]{thisType}));
                    WildcardTypeName typeParamB = WildcardTypeName.subtypeOf((TypeName)ParameterizedTypeName.get((ClassName)flyweightBuilderRawType, (TypeName[])new TypeName[]{thisType}));
                    ParameterizedTypeName arrayTypeName = ParameterizedTypeName.get((ClassName)arrayBuilderClassName, (TypeName[])new TypeName[]{typeParamT, typeParamB, thisType});
                    builder.addField(FieldSpec.builder((TypeName)arrayTypeName, (String)"array", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
                }
            }
        }

        private static final class MemberFieldGenerator
        extends ClassSpecMixinGenerator {
            private final AstType ofType;
            private final TypeVariableName typeVarB;
            private final TypeVariableName typeVarV;
            private final TypeVariableName typeVarKB;
            private final TypeVariableName typeVarKV;
            private final TypeVariableName typeVarVB;
            private final TypeVariableName typeVarVV;
            private final TypeResolver resolver;
            private final AstByteOrder byteOrder;

            private MemberFieldGenerator(ClassName thisType, TypeName kindTypeName, TypeVariableName typeVarB, TypeVariableName typeVarV, TypeVariableName typeVarKB, TypeVariableName typeVarKV, TypeVariableName typeVarVB, TypeVariableName typeVarVV, AstType ofType, TypeSpec.Builder builder, TypeResolver resolver, AstByteOrder byteOrder) {
                super(thisType, builder);
                this.ofType = ofType;
                this.typeVarB = typeVarB;
                this.typeVarV = typeVarV;
                this.typeVarKB = typeVarKB;
                this.typeVarKV = typeVarKV;
                this.typeVarVB = typeVarVB;
                this.typeVarVV = typeVarVV;
                this.resolver = resolver;
                this.byteOrder = byteOrder;
                if (!kindTypeName.isPrimitive() && ofType != null) {
                    ClassName classType = (ClassName)kindTypeName;
                    ClassName builderType = classType.nestedClass("Builder");
                    builder.addField(FieldSpec.builder((TypeName)builderType, (String)VariantFlyweightGenerator.enumRW(kindTypeName), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T()", new Object[]{builderType}).build());
                }
            }

            public MemberFieldGenerator addMember(String memberName, AstType memberType, TypeName memberTypeName, AstType mapKeyType, AstType mapValueType) {
                if (memberTypeName != null && !memberTypeName.isPrimitive()) {
                    String fieldRW = String.format("%sRW", !memberType.isDynamicType() ? memberName : VariantFlyweightGenerator.fieldName(memberTypeName));
                    ClassName classType = (ClassName)memberTypeName;
                    ClassName builderType = classType.nestedClass("Builder");
                    if (VariantFlyweightGenerator.isArrayType(this.ofType)) {
                        ParameterizedTypeName parameterizedBuilderType = ParameterizedTypeName.get((ClassName)builderType, (TypeName[])new TypeName[]{this.typeVarB, this.typeVarV});
                        this.builder.addField(FieldSpec.builder((TypeName)parameterizedBuilderType, (String)fieldRW, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
                    } else if (VariantFlyweightGenerator.isMapType(this.ofType)) {
                        ParameterizedTypeName parameterizedBuilderType = ParameterizedTypeName.get((ClassName)builderType, (TypeName[])new TypeName[]{this.typeVarKV, this.typeVarVV, this.typeVarKB, this.typeVarVB});
                        this.builder.addField(FieldSpec.builder((TypeName)parameterizedBuilderType, (String)fieldRW, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
                    } else if (mapKeyType != null) {
                        ClassName mapKeyName = this.resolver.resolveClass(mapKeyType);
                        ClassName mapValueName = this.resolver.resolveClass(mapValueType);
                        ParameterizedTypeName parameterizedBuilderType = ParameterizedTypeName.get((ClassName)builderType, (TypeName[])new TypeName[]{mapKeyName, mapValueName, mapKeyName.nestedClass("Builder"), mapValueName.nestedClass("Builder")});
                        this.builder.addField(FieldSpec.builder((TypeName)parameterizedBuilderType, (String)fieldRW, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
                        this.builder.addMethod(MethodSpec.methodBuilder((String)fieldRW).addModifiers(new Modifier[]{Modifier.PRIVATE}).returns((TypeName)parameterizedBuilderType).beginControlFlow("if ($L == null)", new Object[]{fieldRW}).addStatement("$L = new $T<>(new $T(), new $T(), new $T.Builder(), new $T.Builder())", new Object[]{fieldRW, builderType, mapKeyName, mapValueName, mapKeyName, mapValueName}).endControlFlow().addStatement("return $L", new Object[]{fieldRW}).build());
                    } else if (VariantFlyweightGenerator.isListType(this.ofType) || VariantFlyweightGenerator.isBoundedOctetsType(this.ofType) || VariantFlyweightGenerator.isStringType(this.ofType)) {
                        if (this.byteOrder == AstByteOrder.NATIVE || memberType.equals(AstType.LIST0) || memberType.equals(AstType.LIST8) || memberType.equals(AstType.BOUNDED_OCTETS8) || memberType.equals(AstType.STRING8)) {
                            this.builder.addField(FieldSpec.builder((TypeName)builderType, (String)fieldRW, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T()", new Object[]{builderType}).build());
                        } else {
                            this.builder.addField(FieldSpec.builder((TypeName)builderType, (String)fieldRW, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T($T.BIG_ENDIAN)", new Object[]{builderType, ByteOrder.class}).build());
                        }
                    } else {
                        this.builder.addField(FieldSpec.builder((TypeName)builderType, (String)fieldRW, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T()", new Object[]{builderType}).build());
                    }
                }
                return this;
            }
        }

        private static final class SetList32FieldsMethodGenerator
        extends MethodSpecGenerator {
            private final AstType ofType;

            private SetList32FieldsMethodGenerator(AstType ofType) {
                super(MethodSpec.methodBuilder((String)"setList32Fields").addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(Integer.TYPE).addParameter((TypeName)TypeNames.MUTABLE_DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]));
                this.ofType = ofType;
            }

            public SetList32FieldsMethodGenerator addMember(AstType memberType) {
                if (AstType.LIST32.equals(memberType)) {
                    this.builder.addStatement("List32FW list32 = list32RW.build()", new Object[0]).addStatement("final DirectBuffer fields = list32.fields()", new Object[0]).addStatement("buffer.putBytes(offset, fields, 0, fields.capacity())", new Object[0]).addStatement("return fields.capacity()", new Object[0]);
                }
                return this;
            }

            @Override
            public MethodSpec generate() {
                return this.builder.build();
            }

            @Override
            public void mixin(TypeSpec.Builder builder) {
                if (VariantFlyweightGenerator.isListType(this.ofType)) {
                    super.mixin(builder);
                }
            }
        }

        private static final class RebuildMethodGenerator
        extends ClassSpecMixinGenerator {
            private RebuildMethodGenerator(ClassName thisType, TypeName kindTypeName, AstType ofType, TypeName ofTypeName, TypeSpec.Builder builder) {
                super(thisType, builder);
                if (VariantFlyweightGenerator.isStringType(ofType) && !kindTypeName.isPrimitive()) {
                    builder.addMethod(MethodSpec.methodBuilder((String)"rebuild").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)thisType).addParameter((TypeName)thisType, "item", new Modifier[0]).addParameter(Integer.TYPE, "maxLength", new Modifier[0]).addStatement("assert array != null", new Object[0]).addStatement("$T rebuildKind = minKind(maxLength)", new Object[]{VariantFlyweightGenerator.enumClassName(kindTypeName)}).addStatement("$T newItem = item", new Object[]{thisType}).addStatement("$T value = item.get()", new Object[]{ofTypeName}).addStatement("final int valueOffset = array.limit() == array.fieldsOffset() ?\narray.fieldsOffset() + item.$LRO.sizeof() : array.limit()", new Object[]{VariantFlyweightGenerator.enumFWName(kindTypeName)}).beginControlFlow("if (value.offset() != valueOffset || !item.kind().equals(rebuildKind))", new Object[0]).addStatement("setAs(rebuildKind, value)", new Object[0]).addStatement("newItem = flyweight().wrap(buffer(), array.limit(), limit(), array.flyweight())", new Object[0]).endControlFlow().addStatement("return newItem", new Object[0]).build());
                }
            }
        }

        private static final class SizeOfMethodGenerator
        extends ClassSpecMixinGenerator {
            private SizeOfMethodGenerator(ClassName thisType, TypeName kindTypeName, AstType ofType, TypeSpec.Builder builder) {
                super(thisType, builder);
                if (VariantFlyweightGenerator.isStringType(ofType) && !kindTypeName.isPrimitive()) {
                    builder.addMethod(MethodSpec.methodBuilder((String)"sizeof").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("final int offset = array == null || array.limit() == array.fieldsOffset() ? $LRW.limit() : array.limit()", new Object[]{VariantFlyweightGenerator.enumFWName(kindTypeName)}).addStatement("return limit() - offset", new Object[0]).build());
                }
            }
        }

        private final class ResetMethodGenerator
        extends MethodSpecGenerator {
            private final ClassName variantType;
            private final AstType ofType;
            private final TypeName kindTypeName;
            private final TypeResolver resolver;

            private ResetMethodGenerator(ClassName variantType, AstType ofType, TypeName kindTypeName, TypeResolver resolver) {
                super(MethodSpec.methodBuilder((String)"reset").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class));
                this.variantType = variantType;
                this.ofType = ofType;
                this.kindTypeName = kindTypeName;
                this.resolver = resolver;
            }

            @Override
            public MethodSpec generate() {
                ClassName arrayClassName = this.resolver.resolveClass(AstType.ARRAY);
                ClassName arrayBuilderClassName = arrayClassName.nestedClass("Builder");
                ClassName flyweightBuilderClassName = this.resolver.flyweightName().nestedClass("Builder");
                WildcardTypeName typeParamT = WildcardTypeName.subtypeOf((TypeName)ParameterizedTypeName.get((ClassName)arrayClassName, (TypeName[])new TypeName[]{this.variantType}));
                WildcardTypeName typeParamB = WildcardTypeName.subtypeOf((TypeName)ParameterizedTypeName.get((ClassName)flyweightBuilderClassName, (TypeName[])new TypeName[]{this.variantType}));
                ParameterizedTypeName parameterizedArrayBuilderType = ParameterizedTypeName.get((ClassName)arrayBuilderClassName, (TypeName[])new TypeName[]{typeParamT, typeParamB, this.variantType});
                return this.builder.addParameter((TypeName)parameterizedArrayBuilderType, "array", new Modifier[0]).addStatement("flyweight().kind = null", new Object[0]).build();
            }

            @Override
            public void mixin(TypeSpec.Builder builder) {
                if (VariantFlyweightGenerator.isStringType(this.ofType) && !this.kindTypeName.isPrimitive()) {
                    super.mixin(builder);
                }
            }
        }

        private final class WrapMethodWithArrayGenerator
        extends MethodSpecGenerator {
            private final ClassName variantType;
            private final AstType ofType;
            private final TypeName kindTypeName;
            private final TypeResolver resolver;

            private WrapMethodWithArrayGenerator(ClassName variantType, AstType ofType, TypeName kindTypeName, TypeResolver resolver) {
                super(MethodSpec.methodBuilder((String)"wrap").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(BuilderClassGenerator.this.thisName));
                this.variantType = variantType;
                this.ofType = ofType;
                this.kindTypeName = kindTypeName;
                this.resolver = resolver;
            }

            @Override
            public MethodSpec generate() {
                ClassName arrayClassName = this.resolver.resolveClass(AstType.ARRAY);
                ClassName arrayBuilderClassName = arrayClassName.nestedClass("Builder");
                ClassName flyweightBuilderClassName = this.resolver.flyweightName().nestedClass("Builder");
                WildcardTypeName typeParamT = WildcardTypeName.subtypeOf((TypeName)ParameterizedTypeName.get((ClassName)arrayClassName, (TypeName[])new TypeName[]{this.variantType}));
                WildcardTypeName typeParamB = WildcardTypeName.subtypeOf((TypeName)ParameterizedTypeName.get((ClassName)flyweightBuilderClassName, (TypeName[])new TypeName[]{this.variantType}));
                ParameterizedTypeName parameterizedArrayBuilderType = ParameterizedTypeName.get((ClassName)arrayBuilderClassName, (TypeName[])new TypeName[]{typeParamT, typeParamB, this.variantType});
                return this.builder.addParameter((TypeName)parameterizedArrayBuilderType, "array", new Modifier[0]).addStatement("super.wrap(array.buffer(), array.fieldsOffset(), array.maxLimit())", new Object[0]).addStatement("limit(array.limit())", new Object[0]).addStatement("this.array = array", new Object[0]).addStatement("return this", new Object[0]).build();
            }

            @Override
            public void mixin(TypeSpec.Builder builder) {
                if (VariantFlyweightGenerator.isStringType(this.ofType) && !this.kindTypeName.isPrimitive()) {
                    super.mixin(builder);
                }
            }
        }

        private final class WrapMethodGenerator
        extends MethodSpecGenerator {
            private final AstType ofType;
            private final TypeName kindTypeName;
            private final List<Integer> size;

            private WrapMethodGenerator(AstType ofType, TypeName kindTypeName) {
                super(MethodSpec.methodBuilder((String)"wrap").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(BuilderClassGenerator.this.thisName).addParameter((TypeName)TypeNames.MUTABLE_DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]));
                this.size = new ArrayList<Integer>();
                this.ofType = ofType;
                this.kindTypeName = kindTypeName;
            }

            public WrapMethodGenerator addMember(AstType memberType) {
                if (VariantFlyweightGenerator.isListType(this.ofType) || VariantFlyweightGenerator.isArrayType(this.ofType) || VariantFlyweightGenerator.isMapType(this.ofType)) {
                    this.size.add(VariantFlyweightGenerator.typeSize(memberType));
                }
                return this;
            }

            @Override
            public MethodSpec generate() {
                if (VariantFlyweightGenerator.isStringType(this.ofType) && !this.kindTypeName.isPrimitive()) {
                    this.builder.addStatement("this.array = null", new Object[0]);
                }
                if (!(VariantFlyweightGenerator.isListType(this.ofType) || VariantFlyweightGenerator.isArrayType(this.ofType) || VariantFlyweightGenerator.isMapType(this.ofType))) {
                    return this.builder.addStatement("return this", new Object[0]).build();
                }
                Collections.sort(this.size);
                int largestListSize = this.size.get(this.size.size() - 1);
                if (VariantFlyweightGenerator.isArrayType(this.ofType)) {
                    this.builder.returns((TypeName)ParameterizedTypeName.get((ClassName)((ClassName)BuilderClassGenerator.this.thisName), (TypeName[])new TypeName[]{BuilderClassGenerator.this.typeVarB, BuilderClassGenerator.this.typeVarV})).addStatement("kind($L)", new Object[]{VariantFlyweightGenerator.kind(String.format("array%d", largestListSize))}).addStatement("array$LRW.wrap(buffer, limit(), maxLimit)", new Object[]{largestListSize});
                } else if (VariantFlyweightGenerator.isMapType(this.ofType)) {
                    this.builder.returns((TypeName)ParameterizedTypeName.get((ClassName)((ClassName)BuilderClassGenerator.this.thisName), (TypeName[])new TypeName[]{BuilderClassGenerator.this.typeVarKV, BuilderClassGenerator.this.typeVarVV, BuilderClassGenerator.this.typeVarKB, BuilderClassGenerator.this.typeVarVB})).addStatement("kind($L)", new Object[]{VariantFlyweightGenerator.kind(String.format("map%d", largestListSize))}).addStatement("map$LRW.wrap(buffer, limit(), maxLimit)", new Object[]{largestListSize});
                } else {
                    this.builder.addStatement("kind($L)", new Object[]{VariantFlyweightGenerator.kind(String.format("list%d", largestListSize))}).addStatement("list$LRW.wrap(buffer, limit(), maxLimit)", new Object[]{largestListSize});
                }
                return this.builder.addStatement("return this", new Object[0]).build();
            }
        }

        private final class EntriesMethodGenerator
        extends MethodSpecGenerator {
            private final AstType ofType;
            private final List<Integer> size;

            private EntriesMethodGenerator(AstType ofType) {
                super(MethodSpec.methodBuilder((String)"entries"));
                this.size = new ArrayList<Integer>();
                this.ofType = ofType;
            }

            public EntriesMethodGenerator addMember(AstType memberType) {
                if (VariantFlyweightGenerator.isMapType(this.ofType)) {
                    this.size.add(VariantFlyweightGenerator.typeSize(memberType));
                }
                return this;
            }

            @Override
            public MethodSpec generate() {
                Collections.sort(this.size);
                int largestListSize = this.size.get(this.size.size() - 1);
                return this.builder.addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)((ClassName)BuilderClassGenerator.this.thisName), (TypeName[])new TypeName[]{BuilderClassGenerator.this.typeVarKV, BuilderClassGenerator.this.typeVarVV, BuilderClassGenerator.this.typeVarKB, BuilderClassGenerator.this.typeVarVB})).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "index", new Modifier[0]).addParameter(Integer.TYPE, "length", new Modifier[0]).addParameter(Integer.TYPE, "fieldCount", new Modifier[0]).addStatement("map$LRW.entries(buffer, index, length, fieldCount)", new Object[]{largestListSize}).addStatement("limit(map$LRW.limit())", new Object[]{largestListSize}).addStatement("return this", new Object[0]).build();
            }

            @Override
            public void mixin(TypeSpec.Builder builder) {
                if (VariantFlyweightGenerator.isMapType(this.ofType)) {
                    super.mixin(builder);
                }
            }
        }

        private final class EntryMethodGenerator
        extends MethodSpecGenerator {
            private final AstType ofType;
            private final List<Integer> size;

            private EntryMethodGenerator(AstType ofType) {
                super(MethodSpec.methodBuilder((String)"entry"));
                this.size = new ArrayList<Integer>();
                this.ofType = ofType;
            }

            public EntryMethodGenerator addMember(AstType memberType) {
                if (VariantFlyweightGenerator.isMapType(this.ofType)) {
                    this.size.add(VariantFlyweightGenerator.typeSize(memberType));
                }
                return this;
            }

            @Override
            public MethodSpec generate() {
                ClassName consumerRawType = ClassName.get(Consumer.class);
                ParameterizedTypeName consumerKeyType = ParameterizedTypeName.get((ClassName)consumerRawType, (TypeName[])new TypeName[]{BuilderClassGenerator.this.typeVarKB});
                ParameterizedTypeName consumerValueType = ParameterizedTypeName.get((ClassName)consumerRawType, (TypeName[])new TypeName[]{BuilderClassGenerator.this.typeVarVB});
                Collections.sort(this.size);
                int largestListSize = this.size.get(this.size.size() - 1);
                return this.builder.addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)((ClassName)BuilderClassGenerator.this.thisName), (TypeName[])new TypeName[]{BuilderClassGenerator.this.typeVarKV, BuilderClassGenerator.this.typeVarVV, BuilderClassGenerator.this.typeVarKB, BuilderClassGenerator.this.typeVarVB})).addParameter((TypeName)consumerKeyType, "key", new Modifier[0]).addParameter((TypeName)consumerValueType, "value", new Modifier[0]).addStatement("map$LRW.entry(key, value)", new Object[]{largestListSize}).addStatement("limit(map$LRW.limit())", new Object[]{largestListSize}).addStatement("return this", new Object[0]).build();
            }

            @Override
            public void mixin(TypeSpec.Builder builder) {
                if (VariantFlyweightGenerator.isMapType(this.ofType)) {
                    super.mixin(builder);
                }
            }
        }

        private final class ItemsMethodGenerator
        extends MethodSpecGenerator {
            private final AstType ofType;
            private final List<Integer> size;

            private ItemsMethodGenerator(AstType ofType) {
                super(MethodSpec.methodBuilder((String)"item"));
                this.size = new ArrayList<Integer>();
                this.ofType = ofType;
            }

            public ItemsMethodGenerator addMember(AstType memberType) {
                if (VariantFlyweightGenerator.isArrayType(this.ofType)) {
                    this.size.add(VariantFlyweightGenerator.typeSize(memberType));
                }
                return this;
            }

            @Override
            public MethodSpec generate() {
                Collections.sort(this.size);
                int largestListSize = this.size.get(this.size.size() - 1);
                ParameterizedTypeName consumerType = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{BuilderClassGenerator.this.typeVarB});
                return this.builder.addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)((ClassName)BuilderClassGenerator.this.thisName), (TypeName[])new TypeName[]{BuilderClassGenerator.this.typeVarB, BuilderClassGenerator.this.typeVarV})).addParameter((TypeName)consumerType, "consumer", new Modifier[0]).addStatement("array$LRW.item(consumer)", new Object[]{largestListSize}).addStatement("limit(array$LRW.limit())", new Object[]{largestListSize}).addStatement("return this", new Object[0]).build();
            }

            @Override
            public void mixin(TypeSpec.Builder builder) {
                if (VariantFlyweightGenerator.isArrayType(this.ofType)) {
                    super.mixin(builder);
                }
            }
        }

        private final class ItemMethodGenerator
        extends ClassSpecMixinGenerator {
            private final AstType ofType;
            private final List<Integer> size;

            private ItemMethodGenerator(ClassName thisType, TypeSpec.Builder builder, AstType ofType) {
                super(thisType, builder);
                this.size = new ArrayList<Integer>();
                this.ofType = ofType;
            }

            public ItemMethodGenerator addMember(AstType memberType) {
                if (VariantFlyweightGenerator.isArrayType(this.ofType)) {
                    this.size.add(VariantFlyweightGenerator.typeSize(memberType));
                }
                return this;
            }

            @Override
            public TypeSpec.Builder build() {
                if (VariantFlyweightGenerator.isArrayType(this.ofType)) {
                    Collections.sort(this.size);
                    int largestListSize = this.size.get(this.size.size() - 1);
                    ParameterizedTypeName consumerType = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{BuilderClassGenerator.this.typeVarB});
                    ParameterizedTypeName returnType = ParameterizedTypeName.get((ClassName)((ClassName)BuilderClassGenerator.this.thisName), (TypeName[])new TypeName[]{BuilderClassGenerator.this.typeVarB, BuilderClassGenerator.this.typeVarV});
                    return this.builder.addMethod(MethodSpec.methodBuilder((String)"item").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)returnType).addParameter((TypeName)consumerType, "consumer", new Modifier[0]).addStatement("array$LRW.item(consumer)", new Object[]{largestListSize}).addStatement("limit(array$LRW.limit())", new Object[]{largestListSize}).addStatement("return this", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"items").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)returnType).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "srcOffset", new Modifier[0]).addParameter(Integer.TYPE, "length", new Modifier[0]).addParameter(Integer.TYPE, "fieldCount", new Modifier[0]).addParameter(Integer.TYPE, "maxLength", new Modifier[0]).addStatement("array$LRW.items(buffer, srcOffset, length, fieldCount, maxLength)", new Object[]{largestListSize}).addStatement("limit(array$LRW.limit())", new Object[]{largestListSize}).addStatement("return this", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"fieldsOffset").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return array$LRW.fieldsOffset()", new Object[]{largestListSize}).build());
                }
                return super.build();
            }
        }

        private final class MinKindMethodGenerator
        extends MethodSpecGenerator {
            private final Set<TypeWidth> kindTypeSet;
            private final TypeName kindTypeName;
            private final AstType ofType;

            private MinKindMethodGenerator(TypeName kindTypeName, AstType ofType) {
                super(MethodSpec.methodBuilder((String)"minKind").addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(Integer.TYPE, "length", new Modifier[0]));
                this.kindTypeSet = new TreeSet<TypeWidth>();
                this.kindTypeName = kindTypeName;
                this.ofType = ofType;
            }

            public MinKindMethodGenerator addMember(String kindTypeName, TypeName kindType, TypeName unsignedKindType) {
                if (VariantFlyweightGenerator.isStringType(this.ofType)) {
                    int memberWidth = Integer.parseInt(kindTypeName.replaceAll("\\D+", ""));
                    this.kindTypeSet.add(new TypeWidth(kindType, unsignedKindType, kindTypeName, memberWidth, Integer.MAX_VALUE));
                }
                return this;
            }

            @Override
            public MethodSpec generate() {
                this.builder.addStatement("int highestByteIndex = Integer.numberOfTrailingZeros(Integer.highestOneBit(length)) >> 3", new Object[0]).beginControlFlow("switch (highestByteIndex)", new Object[0]);
                int lastCaseSet = -1;
                for (TypeWidth type : this.kindTypeSet) {
                    int width = type.width();
                    switch (width) {
                        case 8: {
                            this.addCase8(type);
                            lastCaseSet = 0;
                            break;
                        }
                        case 16: {
                            this.addCase16(type, lastCaseSet);
                            lastCaseSet = 1;
                            break;
                        }
                        case 32: {
                            this.addCase32(type, lastCaseSet);
                            lastCaseSet = 3;
                        }
                    }
                }
                return this.builder.beginControlFlow("default:", new Object[0]).addStatement("throw new IllegalArgumentException(\"Illegal length: \" + length)", new Object[0]).endControlFlow().endControlFlow().returns((TypeName)VariantFlyweightGenerator.enumClassName(this.kindTypeName)).build();
            }

            private void addCase8(TypeWidth type) {
                this.builder.beginControlFlow("case 0:", new Object[0]).addStatement("return $L", new Object[]{VariantFlyweightGenerator.kind(type.kindTypeName())}).endControlFlow();
            }

            private void addCase16(TypeWidth type, int lastCaseSet) {
                if (lastCaseSet < 0) {
                    this.builder.beginControlFlow("case 0:", new Object[0]).endControlFlow();
                }
                this.builder.beginControlFlow("case 1:", new Object[0]).addStatement("return $L", new Object[]{VariantFlyweightGenerator.kind(type.kindTypeName())}).endControlFlow();
            }

            private void addCase32(TypeWidth type, int lastCaseSet) {
                if (lastCaseSet < 0) {
                    this.builder.beginControlFlow("case 0:", new Object[0]).endControlFlow();
                }
                if (lastCaseSet < 1) {
                    this.builder.beginControlFlow("case 1:", new Object[0]).endControlFlow();
                }
                this.builder.beginControlFlow("case 2:", new Object[0]).endControlFlow().beginControlFlow("case 3:", new Object[0]).addStatement("return $L", new Object[]{VariantFlyweightGenerator.kind(type.kindTypeName())}).endControlFlow();
            }

            @Override
            public void mixin(TypeSpec.Builder builder) {
                if (VariantFlyweightGenerator.isStringType(this.ofType) && !this.kindTypeName.isPrimitive()) {
                    super.mixin(builder);
                }
            }
        }

        private final class MaxKindMethodGenerator
        extends MethodSpecGenerator {
            private final TypeName kindTypeName;
            private final AstType ofType;
            private int maxKindSize;
            private String maxMemberName;

            private MaxKindMethodGenerator(TypeName kindTypeName, AstType ofType) {
                super(MethodSpec.methodBuilder((String)"maxKind").addModifiers(new Modifier[]{Modifier.PUBLIC}));
                this.kindTypeName = kindTypeName;
                this.ofType = ofType;
            }

            public MaxKindMethodGenerator addMember(String memberName) {
                int kindSize;
                if (VariantFlyweightGenerator.isStringType(this.ofType) && !this.kindTypeName.isPrimitive() && memberName != null && !Character.isDigit(memberName.charAt(0)) && this.maxKindSize < (kindSize = Integer.parseInt(memberName.replaceAll("\\D+", "")))) {
                    this.maxMemberName = memberName;
                    this.maxKindSize = kindSize;
                }
                return this;
            }

            @Override
            public MethodSpec generate() {
                return this.builder.returns((TypeName)VariantFlyweightGenerator.enumClassName(this.kindTypeName)).addStatement("return $L", new Object[]{VariantFlyweightGenerator.kind(this.maxMemberName)}).build();
            }

            @Override
            public void mixin(TypeSpec.Builder builder) {
                if (VariantFlyweightGenerator.isStringType(this.ofType) && !this.kindTypeName.isPrimitive()) {
                    super.mixin(builder);
                }
            }
        }

        private final class KindMethodGenerator
        extends MethodSpecGenerator {
            private final AstType ofType;

            private KindMethodGenerator(TypeName kindTypeName, AstType ofType) {
                super(MethodSpec.methodBuilder((String)"kind").addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(BuilderClassGenerator.this.thisName));
                this.ofType = ofType;
                if (kindTypeName.isPrimitive()) {
                    this.builder.addParameter(Integer.TYPE, "value", new Modifier[0]).addStatement("buffer().putByte(offset() + $L, (byte)(value & 0xFF))", new Object[]{VariantFlyweightGenerator.offset("kind")});
                } else {
                    if (VariantFlyweightGenerator.isNonPrimitiveType(ofType)) {
                        if (VariantFlyweightGenerator.isArrayType(ofType)) {
                            this.builder.returns((TypeName)ParameterizedTypeName.get((ClassName)((ClassName)BuilderClassGenerator.this.thisName), (TypeName[])new TypeName[]{BuilderClassGenerator.this.typeVarB, BuilderClassGenerator.this.typeVarV}));
                        } else if (VariantFlyweightGenerator.isMapType(ofType)) {
                            this.builder.returns((TypeName)ParameterizedTypeName.get((ClassName)((ClassName)BuilderClassGenerator.this.thisName), (TypeName[])new TypeName[]{BuilderClassGenerator.this.typeVarKV, BuilderClassGenerator.this.typeVarVV, BuilderClassGenerator.this.typeVarKB, BuilderClassGenerator.this.typeVarVB}));
                        }
                    }
                    this.builder.addParameter((TypeName)VariantFlyweightGenerator.enumClassName(kindTypeName), "value", new Modifier[0]).addStatement("$L.wrap(buffer(), offset(), maxLimit())", new Object[]{VariantFlyweightGenerator.enumRW(kindTypeName)}).addStatement("$L.set(value)", new Object[]{VariantFlyweightGenerator.enumRW(kindTypeName)}).addStatement("limit($L.build().limit())", new Object[]{VariantFlyweightGenerator.enumRW(kindTypeName)});
                }
                this.builder.addStatement("return this", new Object[0]);
            }

            @Override
            public MethodSpec generate() {
                return this.builder.build();
            }

            @Override
            public void mixin(TypeSpec.Builder builder) {
                if (this.ofType != null) {
                    super.mixin(builder);
                }
            }
        }

        private static final class FieldsMethodGenerator
        extends ClassSpecMixinGenerator {
            private final AstType ofType;
            private final List<Integer> listSize = new ArrayList<Integer>();
            private final ClassName flyweightBuilderType;

            private FieldsMethodGenerator(ClassName thisType, AstType ofType, ClassName flyweightBuilderType, TypeSpec.Builder builder) {
                super(thisType, builder);
                this.ofType = ofType;
                this.flyweightBuilderType = flyweightBuilderType;
            }

            public FieldsMethodGenerator addMember(AstType memberType) {
                if (VariantFlyweightGenerator.isListType(this.ofType)) {
                    this.listSize.add(VariantFlyweightGenerator.typeSize(memberType));
                }
                return this;
            }

            @Override
            public TypeSpec.Builder build() {
                if (VariantFlyweightGenerator.isListType(this.ofType)) {
                    Collections.sort(this.listSize);
                    int largestListSize = this.listSize.get(this.listSize.size() - 1);
                    this.builder.addMethod(MethodSpec.methodBuilder((String)"fields").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter(Integer.TYPE, "fieldCount", new Modifier[0]).addParameter((TypeName)this.flyweightBuilderType.nestedClass("Visitor"), "visitor", new Modifier[0]).addStatement("list$LRW.fields(fieldCount, visitor)", new Object[]{largestListSize}).addStatement("limit(list$LRW.limit())", new Object[]{largestListSize}).addStatement("return this", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"fields").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter(Integer.TYPE, "fieldCount", new Modifier[0]).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "index", new Modifier[0]).addParameter(Integer.TYPE, "length", new Modifier[0]).addStatement("list$LRW.fields(fieldCount, buffer, index, length)", new Object[]{largestListSize}).addStatement("limit(list$LRW.limit())", new Object[]{largestListSize}).addStatement("return this", new Object[0]).build());
                }
                return super.build();
            }
        }

        private final class FieldMethodGenerator
        extends MethodSpecGenerator {
            private final AstType ofType;
            private final List<Integer> listSize;

            private FieldMethodGenerator(ClassName builderRawType, AstType ofType) {
                super(MethodSpec.methodBuilder((String)"field").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(BuilderClassGenerator.this.thisName).addParameter((TypeName)builderRawType.nestedClass("Visitor"), "mutator", new Modifier[0]));
                this.listSize = new ArrayList<Integer>();
                this.ofType = ofType;
            }

            public FieldMethodGenerator addMember(AstType memberType) {
                if (VariantFlyweightGenerator.isListType(this.ofType)) {
                    this.listSize.add(VariantFlyweightGenerator.typeSize(memberType));
                }
                return this;
            }

            @Override
            public MethodSpec generate() {
                Collections.sort(this.listSize);
                int largestListSize = this.listSize.get(this.listSize.size() - 1);
                return this.builder.addStatement("list$LRW.field(mutator)", new Object[]{largestListSize}).addStatement("limit(list$LRW.limit())", new Object[]{largestListSize}).addStatement("return this", new Object[0]).build();
            }

            @Override
            public void mixin(TypeSpec.Builder builder) {
                if (VariantFlyweightGenerator.isListType(this.ofType)) {
                    super.mixin(builder);
                }
            }
        }

        private final class BuildMethodGenerator
        extends MethodSpecGenerator {
            private final List<Integer> sizes;
            private final TypeName kindTypeName;
            private final AstType ofType;
            private final ClassName variantType;
            private AstType largestListTypeName;

            private BuildMethodGenerator(TypeName kindTypeName, ClassName variantType, AstType ofType) {
                super(MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)variantType));
                this.sizes = new ArrayList<Integer>();
                this.kindTypeName = kindTypeName;
                this.ofType = ofType;
                this.largestListTypeName = AstType.LIST0;
                this.variantType = variantType;
                if (VariantFlyweightGenerator.isArrayType(ofType)) {
                    this.builder.returns((TypeName)ParameterizedTypeName.get((ClassName)variantType, (TypeName[])new TypeName[]{BuilderClassGenerator.this.typeVarV}));
                } else if (VariantFlyweightGenerator.isMapType(ofType)) {
                    this.builder.returns((TypeName)ParameterizedTypeName.get((ClassName)variantType, (TypeName[])new TypeName[]{BuilderClassGenerator.this.typeVarKV, BuilderClassGenerator.this.typeVarVV}));
                }
            }

            public BuildMethodGenerator addMember(AstType memberType) {
                if (VariantFlyweightGenerator.isListType(this.ofType) || VariantFlyweightGenerator.isArrayType(this.ofType) || VariantFlyweightGenerator.isMapType(this.ofType)) {
                    if (VariantFlyweightGenerator.typeSize(memberType) > VariantFlyweightGenerator.typeSize(this.largestListTypeName)) {
                        this.largestListTypeName = memberType;
                    }
                    this.sizes.add(VariantFlyweightGenerator.typeSize(memberType));
                }
                return this;
            }

            @Override
            public MethodSpec generate() {
                if (VariantFlyweightGenerator.isListType(this.ofType)) {
                    this.generateListType();
                } else {
                    if (VariantFlyweightGenerator.isArrayType(this.ofType)) {
                        return this.generateArrayType();
                    }
                    if (VariantFlyweightGenerator.isMapType(this.ofType)) {
                        this.generateMapType();
                    }
                }
                this.builder.beginControlFlow("default:", new Object[0]).addStatement("throw new IllegalArgumentException(\"Illegal length: \" + length)", new Object[0]).endControlFlow().endControlFlow();
                if (VariantFlyweightGenerator.isListType(this.ofType)) {
                    this.builder.endControlFlow();
                }
                return this.builder.addStatement("return super.build()", new Object[0]).build();
            }

            private MethodSpec generateArrayType() {
                Collections.sort(this.sizes);
                int largestSize = this.sizes.get(this.sizes.size() - 1);
                this.builder.addStatement("Array$LFW array$L = array$LRW.build()", new Object[]{largestSize, largestSize, largestSize}).addStatement("long length = Math.max(array$L.length(), array$L.fieldCount())", new Object[]{largestSize, largestSize}).addStatement("int highestByteIndex = Long.numberOfTrailingZeros(Long.highestOneBit(length)) >> 3", new Object[0]).beginControlFlow("switch (highestByteIndex)", new Object[0]);
                int priorSize = -1;
                for (int size : this.sizes) {
                    switch (size) {
                        case 8: {
                            this.builder.beginControlFlow("case 0:", new Object[0]).endControlFlow().beginControlFlow("case 8:", new Object[0]).addStatement("$L.wrap(buffer(), offset(), maxLimit())", new Object[]{VariantFlyweightGenerator.enumRW(this.kindTypeName)}).addStatement("$L.set(KIND_ARRAY8)", new Object[]{VariantFlyweightGenerator.enumRW(this.kindTypeName)}).addStatement("int fieldCount = array$L.fieldCount()", new Object[]{largestSize}).addStatement("array8RW.wrap(buffer(), $L.limit(), maxLimit())", new Object[]{VariantFlyweightGenerator.enumRW(this.kindTypeName)}).addStatement("array8RW.items(array$L.items(), 0, array$L.items().capacity(), fieldCount, array$L.maxLength())", new Object[]{largestSize, largestSize, largestSize}).addStatement("limit(array8RW.limit())", new Object[0]).addStatement("break", new Object[0]).endControlFlow();
                            priorSize = 8;
                            break;
                        }
                        case 16: {
                            if (priorSize < 8) {
                                this.builder.beginControlFlow("case 0:", new Object[0]).endControlFlow().beginControlFlow("case 8:", new Object[0]).endControlFlow();
                            }
                            this.builder.beginControlFlow("case 1:", new Object[0]);
                            if (largestSize == 16) {
                                this.builder.addStatement("limit(array16.limit())", new Object[0]);
                            } else {
                                this.builder.addStatement("$L.wrap(buffer(), offset(), maxLimit())", new Object[]{VariantFlyweightGenerator.enumRW(this.kindTypeName)}).addStatement("$L.set(KIND_ARRAY16)", new Object[]{VariantFlyweightGenerator.enumRW(this.kindTypeName)}).addStatement("int fieldCount = array$L.fieldCount()", new Object[]{largestSize}).addStatement("array16RW.wrap(buffer(), $L.limit(), maxLimit())", new Object[]{VariantFlyweightGenerator.enumRW(this.kindTypeName)}).addStatement("array16RW.items(array$L.items(), 0, array$L.items().capacity(), fieldCount, array$L.maxLength())", new Object[]{largestSize, largestSize, largestSize}).addStatement("limit(array16RW.limit())", new Object[0]);
                            }
                            this.builder.addStatement("break", new Object[0]).endControlFlow();
                            priorSize = 16;
                            break;
                        }
                        case 32: {
                            switch (priorSize) {
                                case -1: {
                                    this.builder.beginControlFlow("case 0:", new Object[0]).endControlFlow().beginControlFlow("case 8:", new Object[0]).endControlFlow().beginControlFlow("case 1:", new Object[0]).endControlFlow();
                                    break;
                                }
                                case 8: {
                                    this.builder.beginControlFlow("case 1:", new Object[0]).endControlFlow();
                                }
                            }
                            this.builder.beginControlFlow("case 2:", new Object[0]).endControlFlow().beginControlFlow("case 3:", new Object[0]).addStatement("limit(array$L.limit())", new Object[]{largestSize}).addStatement("break", new Object[0]).endControlFlow();
                        }
                    }
                }
                return this.builder.beginControlFlow("default:", new Object[0]).addStatement("throw new IllegalArgumentException(\"Illegal length: \" + length)", new Object[0]).endControlFlow().endControlFlow().addStatement("final $T variant = super.build()", new Object[]{ParameterizedTypeName.get((ClassName)this.variantType, (TypeName[])new TypeName[]{BuilderClassGenerator.this.typeVarV})}).addStatement("variant.maxLength(array$L.maxLength())", new Object[]{largestSize}).addStatement("return variant", new Object[0]).build();
            }

            private void generateMapType() {
                Collections.sort(this.sizes);
                int largestSize = this.sizes.get(this.sizes.size() - 1);
                this.builder.addStatement("Map$LFW map$L = map$LRW.build()", new Object[]{largestSize, largestSize, largestSize}).addStatement("long length = Math.max(map$L.length(), map$L.fieldCount())", new Object[]{largestSize, largestSize}).addStatement("int highestByteIndex = Long.numberOfTrailingZeros(Long.highestOneBit(length)) >> 3", new Object[0]).addStatement("int fieldCount = map$L.fieldCount()", new Object[]{largestSize}).beginControlFlow("switch (highestByteIndex)", new Object[0]);
                int priorSize = -1;
                for (int size : this.sizes) {
                    switch (size) {
                        case 8: {
                            this.builder.beginControlFlow("case 0:", new Object[0]).endControlFlow().beginControlFlow("case 8:", new Object[0]).addStatement("$L.wrap(buffer(), offset(), maxLimit())", new Object[]{VariantFlyweightGenerator.enumRW(this.kindTypeName)}).addStatement("$L.set(KIND_MAP8)", new Object[]{VariantFlyweightGenerator.enumRW(this.kindTypeName)}).addStatement("map8RW.wrap(buffer(), $L.limit(), maxLimit())", new Object[]{VariantFlyweightGenerator.enumRW(this.kindTypeName)}).addStatement("map8RW.entries(map$L.entries(), 0, map$L.entries().capacity(), fieldCount)", new Object[]{largestSize, largestSize}).addStatement("limit(map8RW.build().limit())", new Object[0]).addStatement("break", new Object[0]).endControlFlow();
                            priorSize = 8;
                            break;
                        }
                        case 16: {
                            if (priorSize < 8) {
                                this.builder.beginControlFlow("case 0:", new Object[0]).endControlFlow().beginControlFlow("case 8:", new Object[0]).endControlFlow();
                            }
                            this.builder.beginControlFlow("case 1:", new Object[0]);
                            if (largestSize == 16) {
                                this.builder.addStatement("limit(map16.limit())", new Object[0]);
                            } else {
                                this.builder.addStatement("$L.wrap(buffer(), offset(), maxLimit())", new Object[]{VariantFlyweightGenerator.enumRW(this.kindTypeName)}).addStatement("$L.set(KIND_MAP16)", new Object[]{VariantFlyweightGenerator.enumRW(this.kindTypeName)}).addStatement("map16RW.wrap(buffer(), $L.limit(), maxLimit())", new Object[]{VariantFlyweightGenerator.enumRW(this.kindTypeName)}).addStatement("map16RW.entries(map$L.entries(), 0, map$L.entries().capacity(), fieldCount)", new Object[]{largestSize, largestSize}).addStatement("limit(map16RW.build().limit())", new Object[0]);
                            }
                            this.builder.addStatement("break", new Object[0]).endControlFlow();
                            priorSize = 16;
                            break;
                        }
                        case 32: {
                            switch (priorSize) {
                                case -1: {
                                    this.builder.beginControlFlow("case 0:", new Object[0]).endControlFlow().beginControlFlow("case 8:", new Object[0]).endControlFlow().beginControlFlow("case 1:", new Object[0]).endControlFlow();
                                    break;
                                }
                                case 8: {
                                    this.builder.beginControlFlow("case 1:", new Object[0]).endControlFlow();
                                }
                            }
                            this.builder.beginControlFlow("case 2:", new Object[0]).endControlFlow().beginControlFlow("case 3:", new Object[0]).addStatement("limit(map$L.limit())", new Object[]{largestSize}).addStatement("break", new Object[0]).endControlFlow();
                        }
                    }
                }
            }

            private void generateListType() {
                this.builder.addStatement("$LFW kind = $L.build()", new Object[]{VariantFlyweightGenerator.enumClassName(this.kindTypeName), VariantFlyweightGenerator.enumRW(this.kindTypeName)}).beginControlFlow("if (kind.get() == $L)", new Object[]{VariantFlyweightGenerator.kind(this.largestListTypeName.name())}).addStatement("$L $L = $LRW.build()", new Object[]{VariantFlyweightGenerator.listClassName(this.largestListTypeName.name()), this.largestListTypeName, this.largestListTypeName}).addStatement("long length = $L.fieldCount() == 0 ? 0 : Math.max($L.length(), $L.fieldCount())", new Object[]{this.largestListTypeName, this.largestListTypeName, this.largestListTypeName}).addStatement("int highestByteIndex = Long.numberOfTrailingZeros(Long.highestOneBit(length)) >> 3", new Object[0]).beginControlFlow("switch (highestByteIndex)", new Object[0]);
                Collections.sort(this.sizes);
                for (int size : this.sizes) {
                    switch (size) {
                        case 8: {
                            this.builder.beginControlFlow("case 0:", new Object[0]);
                            if (this.largestListTypeName.equals(AstType.LIST8)) {
                                this.builder.addStatement("limit(list8.limit())", new Object[0]);
                            } else {
                                this.builder.addStatement("$L.wrap(buffer(), offset(), maxLimit())", new Object[]{VariantFlyweightGenerator.enumRW(this.kindTypeName)}).addStatement("$L.set(KIND_LIST8)", new Object[]{VariantFlyweightGenerator.enumRW(this.kindTypeName)}).addStatement("list8RW.wrap(buffer(), $L.limit(), maxLimit())", new Object[]{VariantFlyweightGenerator.enumRW(this.kindTypeName)}).addStatement("list8RW.fields(list32.fieldCount(), this::setList32Fields)", new Object[0]).addStatement("limit(list8RW.build().limit())", new Object[0]).addStatement("break", new Object[0]);
                            }
                            this.builder.endControlFlow();
                            break;
                        }
                        case 32: {
                            this.builder.beginControlFlow("case 1:", new Object[0]).endControlFlow().beginControlFlow("case 2:", new Object[0]).endControlFlow().beginControlFlow("case 3:", new Object[0]).addStatement("limit(list32.limit())", new Object[0]).addStatement("break", new Object[0]).endControlFlow();
                        }
                    }
                }
                if (this.sizes.get(0) == 0) {
                    if (this.largestListTypeName.equals(AstType.LIST0)) {
                        this.builder.addStatement("limit(list0.limit())", new Object[0]);
                    } else {
                        this.builder.beginControlFlow("case 8:", new Object[0]).addStatement("$L.wrap(buffer(), offset(), maxLimit())", new Object[]{VariantFlyweightGenerator.enumRW(this.kindTypeName)}).addStatement("$L.set(KIND_LIST0)", new Object[]{VariantFlyweightGenerator.enumRW(this.kindTypeName)}).addStatement("list0RW.wrap(buffer(), $L.limit(), maxLimit())", new Object[]{VariantFlyweightGenerator.enumRW(this.kindTypeName)}).addStatement("limit(list0RW.build().limit())", new Object[0]).addStatement("break", new Object[0]).endControlFlow();
                    }
                }
            }

            @Override
            public void mixin(TypeSpec.Builder builder) {
                if (VariantFlyweightGenerator.isListType(this.ofType) || VariantFlyweightGenerator.isArrayType(this.ofType) || VariantFlyweightGenerator.isMapType(this.ofType)) {
                    super.mixin(builder);
                }
            }
        }

        private final class SetWithSpecificKindMethodGenerator
        extends MethodSpecGenerator {
            private final Set<TypeWidth> kindTypeSet;
            private final AstType ofType;
            private final TypeName kindTypeName;

            private SetWithSpecificKindMethodGenerator(TypeName kindTypeName, AstType ofType, TypeResolver resolver) {
                super(MethodSpec.methodBuilder((String)"setAs").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(BuilderClassGenerator.this.thisName));
                this.kindTypeSet = new TreeSet<TypeWidth>();
                this.ofType = ofType;
                this.kindTypeName = kindTypeName;
                if (VariantFlyweightGenerator.isStringType(ofType) && !kindTypeName.isPrimitive()) {
                    ClassName kindName = VariantFlyweightGenerator.enumClassName(kindTypeName);
                    this.builder.addParameter((TypeName)kindName, "kind", new Modifier[0]).addParameter((TypeName)resolver.resolveClass(ofType), "value", new Modifier[0]).beginControlFlow("switch (kind)", new Object[0]);
                }
            }

            public SetWithSpecificKindMethodGenerator addMember(Object kindValue, String memberName) {
                if (VariantFlyweightGenerator.isStringType(this.ofType) && !this.kindTypeName.isPrimitive()) {
                    this.builder.beginControlFlow("case $L:", new Object[]{kindValue}).addStatement("$L(value)", new Object[]{VariantFlyweightGenerator.setAs(memberName)}).addStatement("break", new Object[0]).endControlFlow();
                }
                return this;
            }

            @Override
            public MethodSpec generate() {
                return this.builder.endControlFlow().addStatement("return this", new Object[0]).build();
            }

            @Override
            public void mixin(TypeSpec.Builder builder) {
                if (VariantFlyweightGenerator.isStringType(this.ofType) && !this.kindTypeName.isPrimitive()) {
                    super.mixin(builder);
                }
            }
        }

        private static final class SetAsFieldMethodForOctetsOfTypeGenerator
        extends ClassSpecMixinGenerator {
            private final TypeName kindTypeName;
            private final AstType ofType;

            private SetAsFieldMethodForOctetsOfTypeGenerator(ClassName thisType, TypeName kindTypeName, AstType ofType, TypeSpec.Builder builder) {
                super(thisType, builder);
                this.kindTypeName = kindTypeName;
                this.ofType = ofType;
            }

            public SetAsFieldMethodForOctetsOfTypeGenerator addMember(String memberName, AstType memberType, TypeName memberTypeName) {
                if (VariantFlyweightGenerator.isBoundedOctetsType(this.ofType) && !this.kindTypeName.isPrimitive()) {
                    MethodSpec.Builder setAsMethodWithBufferBuilder = MethodSpec.methodBuilder((String)VariantFlyweightGenerator.setAs(memberType.isDynamicType() ? VariantFlyweightGenerator.fieldName(memberTypeName) : memberName)).addModifiers(new Modifier[]{Modifier.PRIVATE}).returns((TypeName)this.thisType).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "value", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "length", new Modifier[0]).addStatement("kind($L)", new Object[]{VariantFlyweightGenerator.kind(memberName)}).addStatement("$T.Builder $L = $LRW.wrap(buffer(), limit(), maxLimit())", new Object[]{memberTypeName, memberName, memberName}).addStatement("$L.set(value, offset, length)", new Object[]{memberName}).addStatement("limit($L.build().limit())", new Object[]{memberName}).addStatement("return this", new Object[0]);
                    this.builder.addMethod(setAsMethodWithBufferBuilder.build());
                    MethodSpec.Builder setAsMethodWithByteArrayBuilder = MethodSpec.methodBuilder((String)VariantFlyweightGenerator.setAs(memberType.isDynamicType() ? VariantFlyweightGenerator.fieldName(memberTypeName) : memberName)).addModifiers(new Modifier[]{Modifier.PRIVATE}).returns((TypeName)this.thisType).addParameter(byte[].class, "value", new Modifier[0]).addStatement("kind($L)", new Object[]{VariantFlyweightGenerator.kind(memberName)}).addStatement("$T.Builder $L = $LRW.wrap(buffer(), limit(), maxLimit())", new Object[]{memberTypeName, memberName, memberName}).addStatement("$L.set(value)", new Object[]{memberName}).addStatement("limit($L.build().limit())", new Object[]{memberName}).addStatement("return this", new Object[0]);
                    this.builder.addMethod(setAsMethodWithByteArrayBuilder.build());
                }
                return this;
            }
        }

        private static final class SetAsFieldMethodForStringOfTypeGenerator
        extends ClassSpecMixinGenerator {
            private final TypeName kindTypeName;
            private final AstType ofType;
            private final TypeName ofTypeName;

            private SetAsFieldMethodForStringOfTypeGenerator(ClassName thisType, TypeName kindTypeName, AstType ofType, TypeName ofTypeName, TypeSpec.Builder builder) {
                super(thisType, builder);
                this.kindTypeName = kindTypeName;
                this.ofType = ofType;
                this.ofTypeName = ofTypeName;
            }

            public SetAsFieldMethodForStringOfTypeGenerator addMember(String memberName, AstType memberType, TypeName memberTypeName) {
                if (VariantFlyweightGenerator.isStringType(this.ofType) && !this.kindTypeName.isPrimitive()) {
                    String kindName = VariantFlyweightGenerator.enumFWName(this.kindTypeName);
                    MethodSpec.Builder setAsMethodWithStringFWBuilder = MethodSpec.methodBuilder((String)VariantFlyweightGenerator.setAs(memberType.isDynamicType() ? VariantFlyweightGenerator.fieldName(memberTypeName) : memberName)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(this.ofTypeName, "value", new Modifier[0]).addStatement("kind($L)", new Object[]{VariantFlyweightGenerator.kind(memberName)}).addStatement("int offset = array == null || array.limit() == array.fieldsOffset() ? $LRW.limit() : array.limit()", new Object[]{kindName}).addStatement("$T $L = $LRW.wrap(buffer(), offset, maxLimit()).set(value).build()", new Object[]{memberTypeName, memberName, memberName}).addStatement("limit($L.limit())", new Object[]{memberName}).returns((TypeName)this.thisType).addStatement("return this", new Object[0]);
                    this.builder.addMethod(setAsMethodWithStringFWBuilder.build());
                    MethodSpec.Builder setAsMethodWithBufferBuilder = MethodSpec.methodBuilder((String)VariantFlyweightGenerator.setAs(memberType.isDynamicType() ? VariantFlyweightGenerator.fieldName(memberTypeName) : memberName)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "srcBuffer", new Modifier[0]).addParameter(Integer.TYPE, "srcOffset", new Modifier[0]).addParameter(Integer.TYPE, "length", new Modifier[0]).addStatement("kind($L)", new Object[]{VariantFlyweightGenerator.kind(memberName)}).addStatement("int offset = array == null || array.limit() == array.fieldsOffset() ? $LRW.limit() : array.limit()", new Object[]{kindName}).addStatement("$T $L = $LRW.wrap(buffer(), offset, maxLimit()).set(srcBuffer, srcOffset, length).build()", new Object[]{memberTypeName, memberName, memberName}).addStatement("limit($L.limit())", new Object[]{memberName}).returns((TypeName)this.thisType).addStatement("return this", new Object[0]);
                    this.builder.addMethod(setAsMethodWithBufferBuilder.build());
                    MethodSpec.Builder setAsMethodWithStringBuilder = MethodSpec.methodBuilder((String)VariantFlyweightGenerator.setAs(memberType.isDynamicType() ? VariantFlyweightGenerator.fieldName(memberTypeName) : memberName)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, "value", new Modifier[0]).addParameter(Charset.class, "charset", new Modifier[0]).addStatement("kind($L)", new Object[]{VariantFlyweightGenerator.kind(memberName)}).addStatement("int offset = array == null || array.limit() == array.fieldsOffset() ? $LRW.limit() : array.limit()", new Object[]{kindName}).addStatement("$T $L = $LRW.wrap(buffer(), offset, maxLimit()).set(value, charset).build()", new Object[]{memberTypeName, memberName, memberName}).addStatement("limit($L.limit())", new Object[]{memberName}).returns((TypeName)this.thisType).addStatement("return this", new Object[0]);
                    this.builder.addMethod(setAsMethodWithStringBuilder.build());
                }
                return this;
            }
        }

        private static final class SetAsFieldMethodGenerator
        extends ClassSpecMixinGenerator {
            private final TypeName kindTypeName;
            private final AstType ofType;
            private final TypeName ofTypeName;
            private final TypeResolver resolver;
            private final AstByteOrder byteOrder;

            private SetAsFieldMethodGenerator(ClassName thisType, TypeName kindTypeName, AstType ofType, TypeName ofTypeName, TypeSpec.Builder builder, TypeResolver resolver, AstByteOrder byteOrder) {
                super(thisType, builder);
                this.kindTypeName = kindTypeName;
                this.ofType = ofType;
                this.ofTypeName = ofTypeName;
                this.resolver = resolver;
                this.byteOrder = byteOrder;
            }

            public SetAsFieldMethodGenerator addMember(Object kindValue, String memberName, AstType memberType, TypeName memberTypeName, TypeName unsignedMemberTypeName, AstType mapKeyType, AstType mapValueType) {
                if (!VariantFlyweightGenerator.isArrayType(this.ofType) && !VariantFlyweightGenerator.isMapType(this.ofType)) {
                    if (memberTypeName != null) {
                        CodeBlock.Builder code = memberTypeName.isPrimitive() ? this.addPrimitiveMember(memberName, memberType, memberTypeName, unsignedMemberTypeName) : this.addNonPrimitiveMember(kindValue, memberName, memberTypeName, mapKeyType, mapValueType);
                        TypeName parameterType = TypeName.INT;
                        if (this.ofType == null) {
                            parameterType = memberTypeName;
                        } else if (memberTypeName.isPrimitive()) {
                            if (!memberTypeName.equals((Object)TypeName.BYTE) && !memberTypeName.equals((Object)TypeName.SHORT)) {
                                parameterType = Objects.requireNonNullElse(unsignedMemberTypeName, memberTypeName);
                            }
                        } else {
                            parameterType = this.ofTypeName;
                        }
                        MethodSpec.Builder setAsMethodBuilder = MethodSpec.methodBuilder((String)VariantFlyweightGenerator.setAs(memberType.isDynamicType() ? VariantFlyweightGenerator.fieldName(memberTypeName) : memberName)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(parameterType, VariantFlyweightGenerator.isListType(this.ofType) ? "list" : "value", new Modifier[0]);
                        setAsMethodBuilder.returns((TypeName)this.thisType).addCode(code.build()).addStatement("return this", new Object[0]);
                        if (!VariantFlyweightGenerator.isStringType(this.ofType) || this.kindTypeName.isPrimitive()) {
                            this.builder.addMethod(setAsMethodBuilder.build());
                        }
                    } else if (memberType != null) {
                        CodeBlock.Builder code = this.addConstantValueMember(memberName);
                        this.builder.addMethod(MethodSpec.methodBuilder((String)VariantFlyweightGenerator.setAs(memberName)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addCode(code.build()).addStatement("return this", new Object[0]).build());
                    }
                }
                return this;
            }

            public CodeBlock.Builder addPrimitiveMember(String memberName, AstType memberType, TypeName memberTypeName, TypeName unsignedMemberTypeName) {
                CodeBlock.Builder code = CodeBlock.builder();
                code.addStatement("kind($L)", new Object[]{VariantFlyweightGenerator.kind(memberName)});
                if (this.kindTypeName.isPrimitive()) {
                    code.addStatement("int newLimit = offset() + $L + $L", new Object[]{VariantFlyweightGenerator.offset(memberName), VariantFlyweightGenerator.size(memberName)});
                } else {
                    code.addStatement("int newLimit = limit() + $L", new Object[]{VariantFlyweightGenerator.size(memberName)});
                }
                code.addStatement("checkLimit(newLimit, maxLimit())", new Object[0]);
                if (memberType == AstType.INT24 || memberType == AstType.UINT24) {
                    return this.addInt24Member(code, memberName);
                }
                String putterName = String.format("put%s", TYPE_NAMES.get(memberTypeName));
                if (putterName == null) {
                    throw new IllegalStateException("member type not supported: " + memberTypeName);
                }
                String castType = "";
                String unsignedHex = "";
                if (unsignedMemberTypeName != null) {
                    if (memberTypeName.equals((Object)TypeName.BYTE)) {
                        castType = "(byte) (";
                        unsignedHex = " & 0xFF)";
                    } else if (memberTypeName.equals((Object)TypeName.SHORT)) {
                        castType = "(short) (";
                        unsignedHex = " & 0xFFFF)";
                    } else if (memberTypeName.equals((Object)TypeName.INT)) {
                        castType = "(int) (";
                        unsignedHex = " & 0xFFFF_FFFFL)";
                    }
                } else if (memberTypeName.equals((Object)TypeName.BYTE)) {
                    castType = "(byte) ";
                } else if (memberTypeName.equals((Object)TypeName.SHORT)) {
                    castType = "(short) ";
                }
                String primitiveKindMemberPutStatement = "buffer().%s(offset() + $L, %svalue%s%s)";
                String nonPrimitiveKindMemberPutStatement = "buffer().%s(limit(), %svalue%s%s)";
                String byteOrderMark = "";
                if (this.byteOrder == AstByteOrder.NETWORK && (memberTypeName == TypeName.SHORT || memberTypeName == TypeName.INT || memberTypeName == TypeName.LONG)) {
                    byteOrderMark = ", $T.BIG_ENDIAN";
                }
                String putStatement = String.format(this.kindTypeName.isPrimitive() ? primitiveKindMemberPutStatement : nonPrimitiveKindMemberPutStatement, putterName, castType, unsignedHex, byteOrderMark);
                if (this.kindTypeName.isPrimitive()) {
                    if ("".equals(byteOrderMark)) {
                        code.addStatement(putStatement, new Object[]{VariantFlyweightGenerator.offset(memberName)});
                    } else {
                        code.addStatement(putStatement, new Object[]{VariantFlyweightGenerator.offset(memberName), ByteOrder.class});
                    }
                } else if ("".equals(byteOrderMark)) {
                    code.addStatement(putStatement, new Object[0]);
                } else {
                    code.addStatement(putStatement, new Object[]{ByteOrder.class});
                }
                code.addStatement("limit(newLimit)", new Object[0]);
                return code;
            }

            public CodeBlock.Builder addInt24Member(CodeBlock.Builder code, String memberName) {
                String offsetStatement = this.kindTypeName.isPrimitive() ? String.format("int offset = offset() + %s", VariantFlyweightGenerator.offset(memberName)) : "int offset = limit()";
                return code.addStatement(offsetStatement, new Object[0]).beginControlFlow("if ($T.NATIVE_BYTE_ORDER != $T.BIG_ENDIAN)", new Object[]{TypeNames.BUFFER_UTIL_TYPE, ByteOrder.class}).addStatement("buffer().putByte(offset, (byte) (value >> 16))", new Object[0]).addStatement("buffer().putByte(offset + 1, (byte) (value >> 8))", new Object[0]).addStatement("buffer().putByte(offset + 2, (byte) value)", new Object[0]).endControlFlow().beginControlFlow("else", new Object[0]).addStatement("buffer().putByte(offset, (byte) value)", new Object[0]).addStatement("buffer().putByte(offset + 1, (byte) (value >> 8))", new Object[0]).addStatement("buffer().putByte(offset + 2, (byte) (value >> 16))", new Object[0]).endControlFlow().addStatement("limit(newLimit)", new Object[0]);
            }

            public CodeBlock.Builder addNonPrimitiveMember(Object kindValue, String memberName, TypeName memberTypeName, AstType mapKeyType, AstType mapValueType) {
                CodeBlock.Builder code = CodeBlock.builder();
                if (this.ofType == null) {
                    if (mapKeyType == null) {
                        code.addStatement("$T.Builder $L = $LRW.wrap(buffer(), offset(), maxLimit())", new Object[]{memberTypeName, VariantFlyweightGenerator.fieldName(memberTypeName), VariantFlyweightGenerator.fieldName(memberTypeName)}).addStatement("$L.set(value.get())", new Object[]{VariantFlyweightGenerator.fieldName(memberTypeName)}).addStatement("limit($L.build().limit())", new Object[]{VariantFlyweightGenerator.fieldName(memberTypeName)});
                    } else {
                        ClassName mapKeyTypeName = this.resolver.resolveClass(mapKeyType);
                        ClassName mapValueTypeName = this.resolver.resolveClass(mapValueType);
                        ParameterizedTypeName parameterizedMapBuilderType = ParameterizedTypeName.get((ClassName)((ClassName)memberTypeName).nestedClass("Builder"), (TypeName[])new TypeName[]{mapKeyTypeName, mapValueTypeName, mapKeyTypeName.nestedClass("Builder"), mapValueTypeName.nestedClass("Builder")});
                        code.addStatement("$T $L = $LRW().wrap(buffer(), offset(), maxLimit())", new Object[]{parameterizedMapBuilderType, VariantFlyweightGenerator.fieldName(memberTypeName), VariantFlyweightGenerator.fieldName(memberTypeName)}).addStatement("$L.entries(value.entries(), 0, value.entries().capacity(), value.fieldCount())", new Object[]{VariantFlyweightGenerator.fieldName(memberTypeName)}).addStatement("limit($L.build().limit())", new Object[]{VariantFlyweightGenerator.fieldName(memberTypeName)});
                    }
                } else {
                    if (this.resolver.resolve(memberName) != null && this.resolver.resolve(memberName).getKind() == AstNamedNode.Kind.VARIANT) {
                        String fieldName = VariantFlyweightGenerator.fieldName(memberTypeName);
                        code.addStatement("kind($L)", new Object[]{VariantFlyweightGenerator.kind(kindValue.toString())}).addStatement("$LRW.wrap(buffer(), limit(), maxLimit())", new Object[]{fieldName}).addStatement("$LRW.set(value)", new Object[]{fieldName}).addStatement("limit($LRW.limit())", new Object[]{fieldName});
                    } else {
                        code.addStatement("kind($L)", new Object[]{VariantFlyweightGenerator.kind(memberName)});
                    }
                    if (this.kindTypeName.isPrimitive()) {
                        code.addStatement("$T.Builder $L = $LRW.wrap(buffer(), offset() + $L, maxLimit())", new Object[]{memberTypeName, memberName, memberName, VariantFlyweightGenerator.offset(memberName)});
                    } else if (VariantFlyweightGenerator.isListType(this.ofType) || VariantFlyweightGenerator.isBoundedOctetsType(this.ofType)) {
                        code.addStatement("$T.Builder $L = $LRW.wrap(buffer(), limit(), maxLimit())", new Object[]{memberTypeName, memberName, memberName});
                    }
                    if (VariantFlyweightGenerator.isListType(this.ofType)) {
                        code.addStatement("final DirectBuffer fields = list.fields()", new Object[0]).addStatement("$L.fields(list.fieldCount(), fields, 0, fields.capacity())", new Object[]{memberName}).addStatement("limit($L.build().limit())", new Object[]{memberName});
                    } else if (VariantFlyweightGenerator.isBoundedOctetsType(this.ofType)) {
                        code.addStatement("$L.set(value)", new Object[]{memberName}).addStatement("limit($L.build().limit())", new Object[]{memberName});
                    } else if (VariantFlyweightGenerator.isStringType(this.ofType) && this.kindTypeName.isPrimitive()) {
                        code.addStatement("$L.set(value.asString(), $T.UTF_8)", new Object[]{memberName, StandardCharsets.class}).addStatement("$T $LRO = $L.build()", new Object[]{memberTypeName, memberName, memberName});
                        code.addStatement("limit($LRO.limit())", new Object[]{memberName});
                    }
                }
                return code;
            }

            public CodeBlock.Builder addConstantValueMember(String memberName) {
                CodeBlock.Builder code = CodeBlock.builder();
                if (this.kindTypeName.isPrimitive()) {
                    code.addStatement("int newLimit = offset() + $L", new Object[]{VariantFlyweightGenerator.size("kind")}).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("kind($L)", new Object[]{VariantFlyweightGenerator.kind(memberName)}).addStatement("limit(newLimit)", new Object[0]);
                } else {
                    code.addStatement("kind($L)", new Object[]{VariantFlyweightGenerator.kind(memberName)});
                }
                return code;
            }

            @Override
            public TypeSpec.Builder build() {
                return super.build();
            }
        }

        private class TypeWidth
        implements Comparable<TypeWidth> {
            private TypeName kindType;
            private TypeName unsignedKindType;
            private String kindTypeName;
            private int width;
            private int value;

            TypeWidth(TypeName kindType, TypeName unsignedKindType, String kindTypeName, int width, int value) {
                this.kindType = kindType;
                this.unsignedKindType = unsignedKindType;
                this.kindTypeName = kindTypeName;
                this.width = width;
                this.value = value;
            }

            public TypeName kindType() {
                return this.kindType;
            }

            public TypeName unsignedKindType() {
                return this.unsignedKindType;
            }

            public String kindTypeName() {
                return this.kindTypeName;
            }

            public int width() {
                return this.width;
            }

            public int value() {
                return this.value;
            }

            @Override
            public int compareTo(TypeWidth anotherType) {
                return this.width != anotherType.width() ? this.width - anotherType.width() : this.value - anotherType.value();
            }
        }

        private final class SetMethodWithByteArrayGenerator
        extends MethodSpecGenerator {
            private final Set<TypeWidth> kindTypeSet;
            private final AstType ofType;
            private final TypeName kindType;

            private SetMethodWithByteArrayGenerator(TypeName kindTypeName, AstType ofType) {
                super(MethodSpec.methodBuilder((String)"set").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(BuilderClassGenerator.this.thisName));
                this.kindTypeSet = new TreeSet<TypeWidth>();
                this.ofType = ofType;
                this.kindType = kindTypeName;
            }

            public SetMethodWithByteArrayGenerator addMember(String kindTypeName, TypeName kindType, TypeName unsignedKindType) {
                if (VariantFlyweightGenerator.isBoundedOctetsType(this.ofType) && !kindType.isPrimitive()) {
                    if (Character.isDigit(kindTypeName.charAt(0))) {
                        String constantDigit = kindTypeName.substring(0, 1);
                        TypeWidth currentType = new TypeWidth(kindType, unsignedKindType, kindTypeName, "0".equals(constantDigit) ? 0 : 8, Integer.parseInt(constantDigit));
                        this.kindTypeSet.add(currentType);
                    } else {
                        String typeSize = kindTypeName.replaceAll("\\D+", "");
                        int memberWidth = !typeSize.isEmpty() ? Integer.parseInt(typeSize) : 8;
                        this.kindTypeSet.add(new TypeWidth(kindType, unsignedKindType, kindTypeName, memberWidth, Integer.MAX_VALUE));
                    }
                }
                return this;
            }

            @Override
            public MethodSpec generate() {
                this.builder.addParameter(byte[].class, "value", new Modifier[0]).addStatement("int highestByteIndex = Integer.numberOfTrailingZeros(Integer.highestOneBit(value.length)) >> 3", new Object[0]).beginControlFlow("switch (highestByteIndex)", new Object[0]);
                int lastCaseSet = -1;
                String setAsStatement = "$L(value)";
                for (TypeWidth type : this.kindTypeSet) {
                    int width = type.width();
                    switch (width) {
                        case 8: {
                            this.builder.beginControlFlow("case 0:", new Object[0]).addStatement("$L(value)", new Object[]{VariantFlyweightGenerator.setAs(type.kindTypeName())}).addStatement("break", new Object[0]).endControlFlow();
                            lastCaseSet = 0;
                            break;
                        }
                        case 16: {
                            if (lastCaseSet < 0) {
                                this.builder.beginControlFlow("case 0:", new Object[0]).endControlFlow();
                            }
                            this.builder.beginControlFlow("case 1:", new Object[0]).addStatement("$L(value)", new Object[]{VariantFlyweightGenerator.setAs(type.kindTypeName())}).addStatement("break", new Object[0]).endControlFlow();
                            lastCaseSet = 1;
                            break;
                        }
                        case 32: {
                            if (lastCaseSet < 0) {
                                this.builder.beginControlFlow("case 0:", new Object[0]).endControlFlow();
                            }
                            if (lastCaseSet == 0) {
                                this.builder.beginControlFlow("case 1:", new Object[0]).endControlFlow();
                            }
                            this.builder.beginControlFlow("case 2:", new Object[0]).endControlFlow().beginControlFlow("case 3:", new Object[0]).addStatement("$L(value)", new Object[]{VariantFlyweightGenerator.setAs(type.kindTypeName())}).addStatement("break", new Object[0]).endControlFlow();
                        }
                    }
                }
                this.builder.beginControlFlow("default:", new Object[0]).addStatement("throw new IllegalArgumentException(\"Illegal value: \" + value)", new Object[0]).endControlFlow().endControlFlow();
                return this.builder.addStatement("return this", new Object[0]).build();
            }

            @Override
            public void mixin(TypeSpec.Builder builder) {
                if (VariantFlyweightGenerator.isBoundedOctetsType(this.ofType) && !this.kindType.isPrimitive()) {
                    super.mixin(builder);
                }
            }
        }

        private final class SetMethodWithStringGenerator
        extends MethodSpecGenerator {
            private final Set<TypeWidth> kindTypeSet;
            private final AstType ofType;
            private final TypeName kindType;

            private SetMethodWithStringGenerator(TypeName kindTypeName, AstType ofType) {
                super(MethodSpec.methodBuilder((String)"set").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(BuilderClassGenerator.this.thisName));
                this.kindTypeSet = new TreeSet<TypeWidth>();
                this.ofType = ofType;
                this.kindType = kindTypeName;
            }

            public SetMethodWithStringGenerator addMember(String kindTypeName, TypeName kindType, TypeName unsignedKindType) {
                if (VariantFlyweightGenerator.isStringType(this.ofType) && !kindType.isPrimitive()) {
                    if (Character.isDigit(kindTypeName.charAt(0))) {
                        String constantDigit = kindTypeName.substring(0, 1);
                        TypeWidth currentType = new TypeWidth(kindType, unsignedKindType, kindTypeName, "0".equals(constantDigit) ? 0 : 8, Integer.parseInt(constantDigit));
                        this.kindTypeSet.add(currentType);
                    } else {
                        String typeSize = kindTypeName.replaceAll("\\D+", "");
                        int memberWidth = !typeSize.isEmpty() ? Integer.parseInt(typeSize) : 8;
                        this.kindTypeSet.add(new TypeWidth(kindType, unsignedKindType, kindTypeName, memberWidth, Integer.MAX_VALUE));
                    }
                }
                return this;
            }

            @Override
            public MethodSpec generate() {
                this.builder.addParameter(String.class, "value", new Modifier[0]).addParameter(Charset.class, "charset", new Modifier[0]).addStatement("int length = value.length()", new Object[0]).addStatement("int highestByteIndex = Integer.numberOfTrailingZeros(Integer.highestOneBit(length)) >> 3", new Object[0]).beginControlFlow("switch (highestByteIndex)", new Object[0]);
                int lastCaseSet = -1;
                for (TypeWidth type : this.kindTypeSet) {
                    int width = type.width();
                    switch (width) {
                        case 8: {
                            this.builder.beginControlFlow("case 0:", new Object[0]).addStatement("$L(value, charset)", new Object[]{VariantFlyweightGenerator.setAs(type.kindTypeName())}).addStatement("break", new Object[0]).endControlFlow();
                            lastCaseSet = 0;
                            break;
                        }
                        case 16: {
                            if (lastCaseSet < 0) {
                                this.builder.beginControlFlow("case 0:", new Object[0]).endControlFlow();
                            }
                            this.builder.beginControlFlow("case 1:", new Object[0]).addStatement("$L(value, charset)", new Object[]{VariantFlyweightGenerator.setAs(type.kindTypeName())}).addStatement("break", new Object[0]).endControlFlow();
                            lastCaseSet = 1;
                            break;
                        }
                        case 32: {
                            if (lastCaseSet < 0) {
                                this.builder.beginControlFlow("case 0:", new Object[0]).endControlFlow();
                            }
                            if (lastCaseSet == 0) {
                                this.builder.beginControlFlow("case 1:", new Object[0]).endControlFlow();
                            }
                            this.builder.beginControlFlow("case 2:", new Object[0]).endControlFlow().beginControlFlow("case 3:", new Object[0]).addStatement("$L(value, charset)", new Object[]{VariantFlyweightGenerator.setAs(type.kindTypeName())}).addStatement("break", new Object[0]).endControlFlow();
                        }
                    }
                }
                this.builder.beginControlFlow("default:", new Object[0]).addStatement("throw new IllegalArgumentException(\"Illegal value: \" + value)", new Object[0]).endControlFlow().endControlFlow();
                return this.builder.addStatement("return this", new Object[0]).build();
            }

            @Override
            public void mixin(TypeSpec.Builder builder) {
                if (VariantFlyweightGenerator.isStringType(this.ofType) && !this.kindType.isPrimitive()) {
                    super.mixin(builder);
                }
            }
        }

        private final class SetMethodWithBufferGenerator
        extends MethodSpecGenerator {
            private final Set<TypeWidth> kindTypeSet;
            private final AstType ofType;
            private final TypeName kindType;

            private SetMethodWithBufferGenerator(TypeName kindTypeName, AstType ofType) {
                super(MethodSpec.methodBuilder((String)"set").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(BuilderClassGenerator.this.thisName));
                this.kindTypeSet = new TreeSet<TypeWidth>();
                this.ofType = ofType;
                this.kindType = kindTypeName;
            }

            public SetMethodWithBufferGenerator addMember(String kindTypeName, TypeName kindType, TypeName unsignedKindType) {
                if ((VariantFlyweightGenerator.isStringType(this.ofType) || VariantFlyweightGenerator.isBoundedOctetsType(this.ofType)) && !kindType.isPrimitive()) {
                    if (Character.isDigit(kindTypeName.charAt(0))) {
                        String constantDigit = kindTypeName.substring(0, 1);
                        TypeWidth currentType = new TypeWidth(kindType, unsignedKindType, kindTypeName, "0".equals(constantDigit) ? 0 : 8, Integer.parseInt(constantDigit));
                        this.kindTypeSet.add(currentType);
                    } else {
                        String typeSize = kindTypeName.replaceAll("\\D+", "");
                        int memberWidth = !typeSize.isEmpty() ? Integer.parseInt(typeSize) : 8;
                        this.kindTypeSet.add(new TypeWidth(kindType, unsignedKindType, kindTypeName, memberWidth, Integer.MAX_VALUE));
                    }
                }
                return this;
            }

            @Override
            public MethodSpec generate() {
                this.builder.addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, VariantFlyweightGenerator.isStringType(this.ofType) ? "srcBuffer" : "value", new Modifier[0]).addParameter(Integer.TYPE, VariantFlyweightGenerator.isStringType(this.ofType) ? "srcOffset" : "offset", new Modifier[0]).addParameter(Integer.TYPE, "length", new Modifier[0]).addStatement("int highestByteIndex = Integer.numberOfTrailingZeros(Integer.highestOneBit(length)) >> 3", new Object[0]).beginControlFlow("switch (highestByteIndex)", new Object[0]);
                int lastCaseSet = -1;
                String setAsStatement = VariantFlyweightGenerator.isStringType(this.ofType) ? "$L(srcBuffer, srcOffset, length)" : "$L(value, offset, length)";
                for (TypeWidth type : this.kindTypeSet) {
                    int width = type.width();
                    switch (width) {
                        case 8: {
                            this.builder.beginControlFlow("case 0:", new Object[0]).addStatement(setAsStatement, new Object[]{VariantFlyweightGenerator.setAs(type.kindTypeName())}).addStatement("break", new Object[0]).endControlFlow();
                            lastCaseSet = 0;
                            break;
                        }
                        case 16: {
                            if (lastCaseSet < 0) {
                                this.builder.beginControlFlow("case 0:", new Object[0]).endControlFlow();
                            }
                            this.builder.beginControlFlow("case 1:", new Object[0]).addStatement(setAsStatement, new Object[]{VariantFlyweightGenerator.setAs(type.kindTypeName())}).addStatement("break", new Object[0]).endControlFlow();
                            lastCaseSet = 1;
                            break;
                        }
                        case 32: {
                            if (lastCaseSet < 0) {
                                this.builder.beginControlFlow("case 0:", new Object[0]).endControlFlow();
                            }
                            if (lastCaseSet == 0) {
                                this.builder.beginControlFlow("case 1:", new Object[0]).endControlFlow();
                            }
                            this.builder.beginControlFlow("case 2:", new Object[0]).endControlFlow().beginControlFlow("case 3:", new Object[0]).addStatement(setAsStatement, new Object[]{VariantFlyweightGenerator.setAs(type.kindTypeName())}).addStatement("break", new Object[0]).endControlFlow();
                        }
                    }
                }
                String exception = String.format("throw new IllegalArgumentException(\"Illegal %s: \" + %s)", VariantFlyweightGenerator.isStringType(this.ofType) ? "length" : "value", VariantFlyweightGenerator.isStringType(this.ofType) ? "length" : "value");
                this.builder.beginControlFlow("default:", new Object[0]).addStatement(exception, new Object[0]).endControlFlow().endControlFlow();
                return this.builder.addStatement("return this", new Object[0]).build();
            }

            @Override
            public void mixin(TypeSpec.Builder builder) {
                if ((VariantFlyweightGenerator.isStringType(this.ofType) || VariantFlyweightGenerator.isBoundedOctetsType(this.ofType)) && !this.kindType.isPrimitive()) {
                    super.mixin(builder);
                }
            }
        }

        private final class SetMethodGenerator
        extends MethodSpecGenerator {
            private final Set<TypeWidth> kindTypeSet;
            private final AstType ofType;
            private final TypeName ofTypeName;
            private final TypeName unsignedOfType;
            private final TypeResolver resolver;
            private final TypeName kindTypeName;
            boolean isList0Type;
            boolean isCaseVariantType;

            private SetMethodGenerator(AstType ofType, TypeName ofTypeName, TypeName unsignedOfType, TypeName kindTypeName, TypeResolver resolver) {
                super(MethodSpec.methodBuilder((String)"set").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(BuilderClassGenerator.this.thisName));
                this.kindTypeSet = new TreeSet<TypeWidth>();
                this.isList0Type = false;
                this.isCaseVariantType = false;
                this.ofType = ofType;
                this.ofTypeName = ofTypeName;
                this.unsignedOfType = unsignedOfType;
                this.kindTypeName = kindTypeName;
                this.resolver = resolver;
                if ((VariantFlyweightGenerator.isStringType(ofType) || VariantFlyweightGenerator.isBoundedOctetsType(ofType)) && !kindTypeName.isPrimitive()) {
                    this.builder.addAnnotation(Override.class);
                }
            }

            public SetMethodGenerator addMember(String kindTypeName, AstType memberType, TypeName kindType, TypeName unsignedKindType) {
                if (this.ofType == null) {
                    return this;
                }
                if (Character.isDigit(kindTypeName.charAt(0))) {
                    String constantDigit = kindTypeName.substring(0, 1);
                    TypeWidth currentType = new TypeWidth(kindType, unsignedKindType, kindTypeName, "0".equals(constantDigit) ? 0 : 8, Integer.parseInt(constantDigit));
                    this.kindTypeSet.add(currentType);
                } else if (this.resolver.resolve(kindTypeName) != null && this.resolver.resolve(kindTypeName).getKind() == AstNamedNode.Kind.VARIANT) {
                    AstVariantNode node = (AstVariantNode)this.resolver.resolve(kindTypeName);
                    String typeSize = node.of().toString().replaceAll("\\D+", "");
                    int memberWidth = !typeSize.isEmpty() ? Integer.parseInt(typeSize) : 8;
                    this.kindTypeSet.add(new TypeWidth(kindType, unsignedKindType, VariantFlyweightGenerator.fieldName(kindType), memberWidth, Integer.MAX_VALUE));
                    this.isCaseVariantType = true;
                } else {
                    String typeSize;
                    if (AstType.LIST0.equals(memberType)) {
                        this.isList0Type = true;
                    }
                    int memberWidth = !(typeSize = kindTypeName.replaceAll("\\D+", "")).isEmpty() ? Integer.parseInt(typeSize) : 8;
                    this.kindTypeSet.add(new TypeWidth(kindType, unsignedKindType, kindTypeName, memberWidth, Integer.MAX_VALUE));
                }
                return this;
            }

            @Override
            public void mixin(TypeSpec.Builder builder) {
                if (this.ofTypeName != null && !VariantFlyweightGenerator.isMapType(this.ofType) && !VariantFlyweightGenerator.isArrayType(this.ofType)) {
                    super.mixin(builder);
                }
            }

            @Override
            public MethodSpec generate() {
                boolean hasConstant = false;
                boolean isParameterTypeLong = TypeName.LONG.equals((Object)this.ofTypeName) || TypeName.LONG.equals((Object)this.unsignedOfType);
                this.addVariableDefinitions();
                this.builder.beginControlFlow("switch (highestByteIndex)", new Object[0]);
                int lastCaseSet = -1;
                for (TypeWidth type : this.kindTypeSet) {
                    int width = type.width();
                    switch (width) {
                        case 8: {
                            hasConstant = this.addCase8(type, isParameterTypeLong, hasConstant);
                            lastCaseSet = 0;
                            break;
                        }
                        case 16: {
                            hasConstant = this.addCase16(type, hasConstant, isParameterTypeLong, lastCaseSet);
                            lastCaseSet = 1;
                            break;
                        }
                        case 32: {
                            hasConstant = this.addCase32(type, hasConstant, isParameterTypeLong, lastCaseSet);
                            lastCaseSet = 3;
                            break;
                        }
                        case 64: {
                            hasConstant = this.addCase64(type, hasConstant, isParameterTypeLong, lastCaseSet);
                        }
                    }
                }
                if (this.ofTypeName.isPrimitive() && !this.isCaseVariantType) {
                    if (this.unsignedOfType == null) {
                        this.addSignedNegativeIntBlock();
                    } else {
                        this.addUnsignedIntZeroCase();
                    }
                }
                if (this.isList0Type) {
                    this.builder.beginControlFlow("case 8:", new Object[0]).addStatement("setAsList0(list)", new Object[0]).addStatement("break", new Object[0]).endControlFlow();
                }
                String parameterName = VariantFlyweightGenerator.isListType(this.ofType) ? "list" : "value";
                this.builder.beginControlFlow("default:", new Object[0]).addStatement("throw new IllegalArgumentException(\"Illegal $L: \" + $L)", new Object[]{parameterName, parameterName}).endControlFlow().endControlFlow();
                TypeName parameterType = Objects.requireNonNullElseGet(this.unsignedOfType, () -> this.ofTypeName.isPrimitive() ? (this.ofTypeName.equals((Object)TypeName.LONG) ? TypeName.LONG : TypeName.INT) : this.ofTypeName);
                return this.builder.addParameter(parameterType, VariantFlyweightGenerator.isListType(this.ofType) ? "list" : "value", new Modifier[0]).addStatement("return this", new Object[0]).build();
            }

            private boolean addCase8(TypeWidth type, boolean isParameterTypeLong, boolean hasConstant) {
                if (type.value() != Integer.MAX_VALUE) {
                    this.builder.beginControlFlow("case 0:", new Object[0]).beginControlFlow("switch ($Lvalue)", new Object[]{isParameterTypeLong ? "(int) " : ""}).beginControlFlow("case $L:", new Object[]{type.value()}).addStatement("$L()", new Object[]{VariantFlyweightGenerator.setAs(type.kindTypeName())}).addStatement("break", new Object[0]).endControlFlow();
                    hasConstant = true;
                } else if (hasConstant) {
                    this.addDefaultCase(type, isParameterTypeLong);
                    hasConstant = false;
                } else {
                    this.builder.beginControlFlow("case 0:", new Object[0]);
                    if (VariantFlyweightGenerator.isListType(this.ofType)) {
                        this.builder.addStatement("$L(list)", new Object[]{VariantFlyweightGenerator.setAs(type.kindTypeName())});
                    } else if (VariantFlyweightGenerator.isStringType(this.ofType) && !this.kindTypeName.isPrimitive()) {
                        this.builder.addStatement("$L(value)", new Object[]{VariantFlyweightGenerator.setAs(type.kindTypeName())});
                    } else {
                        this.builder.addStatement(String.format("$L(%svalue)", isParameterTypeLong ? "(int) " : ""), new Object[]{VariantFlyweightGenerator.setAs(type.kindTypeName())});
                    }
                    this.builder.addStatement("break", new Object[0]).endControlFlow();
                }
                return hasConstant;
            }

            private boolean addCase16(TypeWidth type, boolean hasConstant, boolean isParameterTypeLong, int lastCaseSet) {
                if (hasConstant) {
                    this.addDefaultCase(type, isParameterTypeLong);
                    hasConstant = false;
                }
                if (lastCaseSet < 0) {
                    this.builder.beginControlFlow("case 0:", new Object[0]).endControlFlow();
                }
                this.builder.beginControlFlow("case 1:", new Object[0]);
                if (VariantFlyweightGenerator.isStringType(this.ofType) && !this.kindTypeName.isPrimitive()) {
                    this.builder.addStatement("$L(value)", new Object[]{VariantFlyweightGenerator.setAs(type.kindTypeName())});
                } else {
                    this.builder.addStatement(String.format("$L(%svalue)", isParameterTypeLong ? "(int) " : ""), new Object[]{VariantFlyweightGenerator.setAs(type.kindTypeName())});
                }
                this.builder.addStatement("break", new Object[0]).endControlFlow();
                return hasConstant;
            }

            private boolean addCase32(TypeWidth type, boolean hasConstant, boolean isParameterTypeLong, int lastCaseSet) {
                if (hasConstant) {
                    this.addDefaultCase(type, isParameterTypeLong);
                    hasConstant = false;
                }
                if (lastCaseSet < 0) {
                    this.builder.beginControlFlow("case 0:", new Object[0]).endControlFlow();
                }
                if (lastCaseSet < 1) {
                    this.builder.beginControlFlow("case 1:", new Object[0]).endControlFlow();
                }
                this.builder.beginControlFlow("case 2:", new Object[0]).endControlFlow().beginControlFlow("case 3:", new Object[0]);
                if (VariantFlyweightGenerator.isListType(this.ofType)) {
                    this.builder.addStatement("$L(list)", new Object[]{VariantFlyweightGenerator.setAs(type.kindTypeName())});
                } else if (VariantFlyweightGenerator.isStringType(this.ofType) && !this.kindTypeName.isPrimitive()) {
                    this.builder.addStatement("$L(value)", new Object[]{VariantFlyweightGenerator.setAs(type.kindTypeName())});
                } else {
                    Object[] objectArray = new Object[1];
                    objectArray[0] = this.ofTypeName.equals((Object)TypeName.LONG) ? (type.unsignedKindType() == null ? "(int) " : "") : "";
                    this.builder.addStatement(String.format("$L(%svalue)", objectArray), new Object[]{VariantFlyweightGenerator.setAs(type.kindTypeName())});
                }
                this.builder.addStatement("break", new Object[0]).endControlFlow();
                return hasConstant;
            }

            private boolean addCase64(TypeWidth type, boolean hasConstant, boolean isParameterTypeLong, int lastCaseSet) {
                if (hasConstant) {
                    this.addDefaultCase(type, isParameterTypeLong);
                    hasConstant = false;
                }
                if (lastCaseSet < 3) {
                    for (int i = lastCaseSet + 1; i <= 3; ++i) {
                        this.builder.beginControlFlow("case $L:", new Object[]{i}).endControlFlow();
                    }
                }
                this.builder.beginControlFlow("case 4:", new Object[0]).endControlFlow().beginControlFlow("case 5:", new Object[0]).endControlFlow().beginControlFlow("case 6:", new Object[0]).endControlFlow();
                if (!this.ofTypeName.isPrimitive() || this.isCaseVariantType) {
                    this.builder.beginControlFlow("case 7:", new Object[0]).endControlFlow().beginControlFlow("case 8:", new Object[0]).addStatement("$L(value)", new Object[]{VariantFlyweightGenerator.setAs(type.kindTypeName())}).addStatement("break", new Object[0]).endControlFlow();
                } else {
                    this.builder.beginControlFlow("case 7:", new Object[0]).addStatement("$L(value)", new Object[]{VariantFlyweightGenerator.setAs(type.kindTypeName())}).addStatement("break", new Object[0]).endControlFlow();
                }
                return hasConstant;
            }

            private void addDefaultCase(TypeWidth type, boolean isParameterTypeLong) {
                this.builder.beginControlFlow("default:", new Object[0]).addStatement("$L($Lvalue)", new Object[]{VariantFlyweightGenerator.setAs(type.kindTypeName()), isParameterTypeLong ? "(int) " : ""}).addStatement("break", new Object[0]).endControlFlow().endControlFlow().addStatement("break", new Object[0]).endControlFlow();
            }

            private void addVariableDefinitions() {
                if (VariantFlyweightGenerator.isListType(this.ofType)) {
                    this.builder.addStatement("int length = Math.max(list.length(), list.fieldCount())", new Object[0]).addStatement("int highestByteIndex = Long.numberOfTrailingZeros(Long.highestOneBit(length)) >> 3", new Object[0]);
                } else if (!this.ofTypeName.isPrimitive()) {
                    this.builder.addStatement("int length = value.length()", new Object[0]).addStatement("int highestByteIndex = Integer.numberOfTrailingZeros(Integer.highestOneBit(length)) >> 3", new Object[0]);
                } else if (this.unsignedOfType == null) {
                    TypeName className = this.ofTypeName.equals((Object)TypeName.LONG) ? TypeName.LONG : TypeName.INT;
                    this.builder.addStatement("int highestByteIndex = ($L.numberOfTrailingZeros($L.highestOneBit(value)) + 1)  >> 3", new Object[]{CLASS_NAMES.get(className), CLASS_NAMES.get(className)});
                } else {
                    this.builder.addStatement("int highestByteIndex = $L.numberOfTrailingZeros($L.highestOneBit(value)) >> 3", new Object[]{CLASS_NAMES.get(this.unsignedOfType), CLASS_NAMES.get(this.unsignedOfType)});
                }
            }

            private void addUnsignedIntZeroCase() {
                TypeWidth typeZero = this.kindTypeSet.iterator().next();
                this.builder.beginControlFlow(String.format("case %s:", this.unsignedOfType.equals((Object)TypeName.LONG) ? "8" : "4"), new Object[0]);
                if (typeZero.width() == 0) {
                    this.builder.addStatement("$L()", new Object[]{VariantFlyweightGenerator.setAs(typeZero.kindTypeName())});
                } else {
                    this.builder.addStatement("$L(0)", new Object[]{VariantFlyweightGenerator.setAs(typeZero.kindTypeName())});
                }
                this.builder.addStatement("break", new Object[0]).endControlFlow();
            }

            private void addSignedNegativeIntBlock() {
                this.builder.beginControlFlow(String.format("case %s:", this.ofTypeName.equals((Object)TypeName.LONG) ? "8" : "4"), new Object[0]);
                Iterator<TypeWidth> iterator = this.kindTypeSet.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    TypeWidth currentType = iterator.next();
                    String kindTypeName = currentType.kindTypeName();
                    if (i == 0) {
                        if (currentType.width() == 0) {
                            this.builder.beginControlFlow("if (value == 0)", new Object[0]).addStatement("$L()", new Object[]{VariantFlyweightGenerator.setAs(kindTypeName)}).endControlFlow();
                        } else if (iterator.hasNext() || currentType.kindType().equals((Object)TypeName.BYTE) || currentType.kindType().equals((Object)TypeName.SHORT)) {
                            this.builder.beginControlFlow("if ((value & $L) == $L || value == 0)", new Object[]{VariantFlyweightGenerator.bitMask(kindTypeName), VariantFlyweightGenerator.bitMask(kindTypeName)}).addStatement(String.format("$L(%svalue)", currentType.kindType().equals((Object)TypeName.LONG) ? "" : (this.ofTypeName.equals((Object)TypeName.LONG) ? "(int) " : "")), new Object[]{VariantFlyweightGenerator.setAs(currentType.kindTypeName())}).endControlFlow();
                        } else {
                            this.builder.addStatement(String.format("$L(%svalue)", currentType.kindType().equals((Object)TypeName.LONG) ? "" : (this.ofTypeName.equals((Object)TypeName.LONG) ? "(int) " : "")), new Object[]{VariantFlyweightGenerator.setAs(currentType.kindTypeName())});
                        }
                    } else if (!iterator.hasNext() && currentType.value() == Integer.MAX_VALUE) {
                        this.builder.beginControlFlow("else", new Object[0]).addStatement(String.format("$L(%svalue)", currentType.kindType().equals((Object)TypeName.LONG) ? "" : (this.ofTypeName.equals((Object)TypeName.LONG) ? "(int) " : "")), new Object[]{VariantFlyweightGenerator.setAs(kindTypeName)}).endControlFlow();
                    } else if (currentType.value() == Integer.MAX_VALUE) {
                        this.builder.beginControlFlow("else if ((value & $L) == $L)", new Object[]{VariantFlyweightGenerator.bitMask(kindTypeName), VariantFlyweightGenerator.bitMask(kindTypeName)}).addStatement(String.format("$L(%svalue)", this.ofTypeName.equals((Object)TypeName.LONG) ? "(int) " : ""), new Object[]{VariantFlyweightGenerator.setAs(kindTypeName)}).endControlFlow();
                    }
                    ++i;
                }
                this.builder.addStatement("break", new Object[0]);
                this.builder.endControlFlow();
            }
        }

        private static final class ConstructorGenerator
        extends MethodSpecGenerator {
            private final ClassName thisVariantType;
            private final AstType ofType;

            private ConstructorGenerator(ClassName thisVariantType, AstType ofType, TypeVariableName typeVarB, TypeVariableName typeVarV, TypeVariableName typeVarKB, TypeVariableName typeVarKV, TypeVariableName typeVarVB, TypeVariableName typeVarVV) {
                super(MethodSpec.constructorBuilder());
                this.thisVariantType = thisVariantType;
                this.ofType = ofType;
                if (VariantFlyweightGenerator.isArrayType(ofType)) {
                    this.builder.addParameter((TypeName)typeVarB, "itemRW", new Modifier[0]).addParameter((TypeName)typeVarV, "itemRO", new Modifier[0]).addStatement("super(new $T<>(itemRO))", new Object[]{thisVariantType});
                } else if (VariantFlyweightGenerator.isMapType(ofType)) {
                    this.builder.addParameter((TypeName)typeVarKV, "keyRO", new Modifier[0]).addParameter((TypeName)typeVarVV, "valueRO", new Modifier[0]).addParameter((TypeName)typeVarKB, "keyRW", new Modifier[0]).addParameter((TypeName)typeVarVB, "valueRW", new Modifier[0]).addStatement("super(new $T<>(keyRO, valueRO))", new Object[]{thisVariantType});
                }
            }

            public ConstructorGenerator addMember(String memberName, TypeName memberTypeName) {
                if (VariantFlyweightGenerator.isArrayType(this.ofType)) {
                    this.builder.addStatement("$LRW = new $T.Builder<>(itemRW, itemRO)", new Object[]{memberName, memberTypeName});
                } else if (VariantFlyweightGenerator.isMapType(this.ofType)) {
                    this.builder.addStatement("$LRW = new $T.Builder<>(keyRO, valueRO, keyRW, valueRW)", new Object[]{memberName, memberTypeName});
                }
                return this;
            }

            @Override
            public MethodSpec generate() {
                if (!VariantFlyweightGenerator.isArrayType(this.ofType) && !VariantFlyweightGenerator.isMapType(this.ofType)) {
                    return this.builder.addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super(new $T())", new Object[]{this.thisVariantType}).build();
                }
                return this.builder.addModifiers(new Modifier[]{Modifier.PUBLIC}).build();
            }
        }
    }

    private final class MapOfTypeMethodsGenerator
    extends ClassSpecMixinGenerator {
        private MapOfTypeMethodsGenerator(ClassName thisType, AstType ofType, TypeSpec.Builder builder) {
            super(thisType, builder);
            if (VariantFlyweightGenerator.isMapType(ofType)) {
                ParameterizedTypeName parameterizedConsumerType = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{VariantFlyweightGenerator.this.typeVarVV});
                ParameterizedTypeName parameterizedFunctionType = ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{VariantFlyweightGenerator.this.typeVarKV, parameterizedConsumerType});
                builder.addMethod(MethodSpec.methodBuilder((String)"length").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return get().length()", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"fieldCount").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return get().fieldCount()", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"forEach").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)parameterizedFunctionType, "consumer", new Modifier[0]).addStatement("get().forEach(consumer)", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"entries").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeNames.DIRECT_BUFFER_TYPE).addStatement("return get().entries()", new Object[0]).build());
            }
        }
    }

    private final class LimitMethodGenerator
    extends MethodSpecGenerator {
        private final TypeName kindTypeName;
        private final AstType ofType;
        private final TypeResolver resolver;

        private LimitMethodGenerator(TypeName kindTypeName, AstType ofType, TypeResolver resolver) {
            super(MethodSpec.methodBuilder((String)"limit").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE));
            this.kindTypeName = kindTypeName;
            this.ofType = ofType;
            this.resolver = resolver;
            if (!VariantFlyweightGenerator.isNonPrimitiveType(ofType)) {
                this.builder.beginControlFlow("switch (kind())", new Object[0]);
            }
        }

        public LimitMethodGenerator addMember(String name, Object kindValue, String memberName, TypeName memberTypeName, AstType mapKeyType) {
            if (!VariantFlyweightGenerator.isNonPrimitiveType(this.ofType)) {
                this.builder.beginControlFlow("case $L:", new Object[]{this.kindTypeName.isPrimitive() ? VariantFlyweightGenerator.kind(memberName) : kindValue});
                if (memberTypeName == null) {
                    if (this.ofType != null) {
                        if (this.kindTypeName.isPrimitive()) {
                            this.builder.addStatement("return offset()", new Object[0]);
                        } else {
                            this.builder.addStatement("return $L.limit()", new Object[]{VariantFlyweightGenerator.enumRO(this.kindTypeName)});
                        }
                    }
                } else if (TypeNames.DIRECT_BUFFER_TYPE.equals((Object)memberTypeName) || memberTypeName.isPrimitive()) {
                    if (this.kindTypeName.isPrimitive()) {
                        this.builder.addStatement("return offset() + $L + $L", new Object[]{VariantFlyweightGenerator.offset(memberName), VariantFlyweightGenerator.size(memberName)});
                    } else {
                        this.builder.addStatement("return $L.limit() + $L", new Object[]{VariantFlyweightGenerator.enumRO(this.kindTypeName), VariantFlyweightGenerator.size(memberName)});
                    }
                } else if (this.ofType == null) {
                    if (mapKeyType == null) {
                        this.builder.addStatement("return $LRO.limit()", new Object[]{VariantFlyweightGenerator.fieldName(memberTypeName)});
                    } else {
                        this.builder.addStatement("return $L().limit()", new Object[]{VariantFlyweightGenerator.fieldName(memberTypeName)});
                    }
                } else if (this.resolver.resolve(name) != null && this.resolver.resolve(name).getKind() == AstNamedNode.Kind.VARIANT) {
                    this.builder.addStatement("return $LRO.limit()", new Object[]{VariantFlyweightGenerator.fieldName(memberTypeName)});
                } else {
                    this.builder.addStatement("return $L().limit()", new Object[]{VariantFlyweightGenerator.getAs(memberName)});
                }
                this.builder.endControlFlow();
            }
            return this;
        }

        @Override
        public MethodSpec generate() {
            if (VariantFlyweightGenerator.isNonPrimitiveType(this.ofType)) {
                return this.builder.addStatement("return get().limit()", new Object[0]).build();
            }
            this.builder.beginControlFlow("default:", new Object[0]);
            if (this.kindTypeName.isPrimitive()) {
                this.builder.addStatement("return offset()", new Object[0]);
            } else if (this.ofType == null) {
                this.builder.addStatement("return offset()", new Object[0]);
            } else {
                this.builder.addStatement("return $L.limit()", new Object[]{VariantFlyweightGenerator.enumRO(this.kindTypeName)});
            }
            return this.builder.endControlFlow().endControlFlow().build();
        }
    }

    private static final class BitMaskConstantGenerator
    extends ClassSpecMixinGenerator {
        private final TypeName ofTypeName;

        private BitMaskConstantGenerator(ClassName thisType, TypeName ofTypeName, TypeSpec.Builder builder) {
            super(thisType, builder);
            this.ofTypeName = ofTypeName;
        }

        public BitMaskConstantGenerator addMember(String kindTypeName, AstType memberType, TypeName memberTypeName, TypeName unsignedMemberTypeName) {
            if (this.ofTypeName != null && unsignedMemberTypeName == null && memberTypeName != null && !memberType.isDynamicType()) {
                boolean isTypeInt = INTEGER_TYPES.contains(this.ofTypeName);
                TypeName bitMaskType = isTypeInt ? TypeName.INT : TypeName.LONG;
                FieldSpec.Builder bitMaskField = FieldSpec.builder((TypeName)bitMaskType, (String)VariantFlyweightGenerator.bitMask(kindTypeName), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL});
                if (isTypeInt) {
                    if (BIT_MASK_INT.get(kindTypeName) != null) {
                        bitMaskField.initializer("$L", new Object[]{BIT_MASK_INT.get(kindTypeName)});
                        this.builder.addField(bitMaskField.build());
                    }
                } else if (BIT_MASK_LONG.get(kindTypeName) != null) {
                    bitMaskField.initializer("$LL", new Object[]{BIT_MASK_LONG.get(kindTypeName)});
                    this.builder.addField(bitMaskField.build());
                }
            }
            return this;
        }
    }

    private final class GetMethodGenerator
    extends MethodSpecGenerator {
        private final TypeName kindTypeName;
        private final AstType ofType;
        private final TypeName ofTypeName;
        private final TypeName unsignedOfType;
        private final TypeResolver resolver;

        private GetMethodGenerator(TypeName kindTypeName, AstType ofType, TypeName ofTypeName, TypeName unsignedOfType, TypeResolver resolver) {
            super(MethodSpec.methodBuilder((String)"get").addModifiers(new Modifier[]{Modifier.PUBLIC}));
            this.kindTypeName = kindTypeName;
            this.ofType = ofType;
            this.ofTypeName = ofTypeName;
            this.unsignedOfType = unsignedOfType;
            this.resolver = resolver;
            this.builder.beginControlFlow("switch (kind())", new Object[0]);
        }

        public GetMethodGenerator addMember(String name, Object kindValue, AstType memberType, TypeName memberTypeName) {
            if (this.ofType == null) {
                return this;
            }
            Object kind = this.kindTypeName.isPrimitive() ? VariantFlyweightGenerator.kind(name) : kindValue;
            this.builder.beginControlFlow("case $L:", new Object[]{kind});
            if (VariantFlyweightGenerator.isNonPrimitiveType(this.ofType)) {
                this.builder.addStatement("return $LRO", new Object[]{name});
            } else {
                String fieldName;
                String string = fieldName = memberType.isDynamicType() && memberTypeName != null ? VariantFlyweightGenerator.fieldName(memberTypeName) : name;
                if (memberTypeName == null || memberTypeName.isPrimitive()) {
                    this.builder.addStatement("return $L()", new Object[]{VariantFlyweightGenerator.getAs(fieldName)});
                } else if (this.resolver.resolve(name) != null && this.resolver.resolve(name).getKind() == AstNamedNode.Kind.VARIANT) {
                    this.builder.addStatement("return $L().get()", new Object[]{VariantFlyweightGenerator.getAs(fieldName)});
                } else {
                    this.builder.addStatement("return $L().asString()", new Object[]{VariantFlyweightGenerator.getAs(fieldName)});
                }
            }
            this.builder.endControlFlow();
            return this;
        }

        @Override
        public MethodSpec generate() {
            TypeName primitiveReturnType;
            TypeName typeName = primitiveReturnType = this.ofTypeName.equals((Object)TypeName.BYTE) || this.ofTypeName.equals((Object)TypeName.SHORT) || this.ofTypeName.equals((Object)TypeName.INT) ? TypeName.INT : TypeName.LONG;
            Object returnType = VariantFlyweightGenerator.isListType(this.ofType) || VariantFlyweightGenerator.isStringType(this.ofType) || VariantFlyweightGenerator.isBoundedOctetsType(this.ofType) ? this.ofTypeName : (VariantFlyweightGenerator.isArrayType(this.ofType) ? ParameterizedTypeName.get((ClassName)this.resolver.resolveClass(this.ofType), (TypeName[])new TypeName[]{VariantFlyweightGenerator.this.typeVarV}) : (VariantFlyweightGenerator.isMapType(this.ofType) ? ParameterizedTypeName.get((ClassName)this.resolver.resolveClass(this.ofType), (TypeName[])new TypeName[]{VariantFlyweightGenerator.this.typeVarKV, VariantFlyweightGenerator.this.typeVarVV}) : Objects.requireNonNullElseGet(this.unsignedOfType, () -> this.ofTypeName.isPrimitive() ? primitiveReturnType : ClassName.bestGuess((String)"String"))));
            return this.builder.beginControlFlow("default:", new Object[0]).addStatement("throw new IllegalStateException(\"Unrecognized kind: \" + kind())", new Object[0]).endControlFlow().endControlFlow().returns(returnType).build();
        }

        @Override
        public void mixin(TypeSpec.Builder builder) {
            if (this.ofTypeName != null) {
                super.mixin(builder);
            }
        }
    }

    private static final class MemberAccessorGenerator
    extends ClassSpecMixinGenerator {
        private final TypeName kindTypeName;
        private final AstType ofType;
        private final TypeResolver resolver;
        private final AstByteOrder byteOrder;

        private MemberAccessorGenerator(ClassName thisType, TypeName kindTypeName, AstType ofType, TypeSpec.Builder builder, TypeResolver resolver, AstByteOrder byteOrder) {
            super(thisType, builder);
            this.kindTypeName = kindTypeName;
            this.ofType = ofType;
            this.resolver = resolver;
            this.byteOrder = byteOrder;
        }

        public MemberAccessorGenerator addMember(String name, AstType memberType, TypeName memberTypeName, TypeName unsignedMemberTypeName, AstType mapKeyType, AstType mapValueType) {
            if (memberType == null) {
                return this;
            }
            CodeBlock.Builder codeBlock = CodeBlock.builder();
            if (memberTypeName != null && memberTypeName.isPrimitive()) {
                if (memberType == AstType.INT24 || memberType == AstType.UINT24) {
                    return this.addInt24Member(name);
                }
                String getterName = String.format("get%s", TYPE_NAMES.get(memberTypeName));
                if (getterName == null) {
                    throw new IllegalStateException("member type not supported: " + memberTypeName);
                }
                String unsignedHex = "";
                if (unsignedMemberTypeName != null) {
                    if (memberTypeName.equals((Object)TypeName.BYTE)) {
                        unsignedHex = " & 0xFF";
                    } else if (memberTypeName.equals((Object)TypeName.SHORT)) {
                        unsignedHex = " & 0xFFFF";
                    } else if (memberTypeName.equals((Object)TypeName.INT)) {
                        unsignedHex = " & 0xFFFF_FFFFL";
                    }
                }
                String byteOrderStatement = "";
                if (this.byteOrder == AstByteOrder.NETWORK && (memberTypeName == TypeName.SHORT || memberTypeName == TypeName.INT || memberTypeName == TypeName.LONG)) {
                    byteOrderStatement = ", $T.BIG_ENDIAN";
                }
                String getStatement = String.format(this.kindTypeName.isPrimitive() ? "return buffer().$L(offset() + $L%s)$L" : "return buffer().$L($L.limit()%s)$L", byteOrderStatement);
                if (this.kindTypeName.isPrimitive()) {
                    if ("".equals(byteOrderStatement)) {
                        codeBlock.addStatement(getStatement, new Object[]{getterName, VariantFlyweightGenerator.offset(name), unsignedHex});
                    } else {
                        codeBlock.addStatement(getStatement, new Object[]{getterName, VariantFlyweightGenerator.offset(name), ByteOrder.class, unsignedHex});
                    }
                } else if ("".equals(byteOrderStatement)) {
                    codeBlock.addStatement(getStatement, new Object[]{getterName, VariantFlyweightGenerator.enumRO(this.kindTypeName), unsignedHex});
                } else {
                    codeBlock.addStatement(getStatement, new Object[]{getterName, VariantFlyweightGenerator.enumRO(this.kindTypeName), ByteOrder.class, unsignedHex});
                }
            } else if (mapKeyType != null) {
                String memberName = VariantFlyweightGenerator.fieldName(memberTypeName);
                ClassName mapKeyTypeName = this.resolver.resolveClass(mapKeyType);
                ClassName mapValueTypeName = this.resolver.resolveClass(mapValueType);
                codeBlock.beginControlFlow("if ($LRO == null)", new Object[]{memberName}).addStatement("$LRO = new $T<>(new $T(), new $T())", new Object[]{memberName, memberTypeName, mapKeyTypeName, mapValueTypeName}).endControlFlow().addStatement("return $LRO", new Object[]{memberName});
            } else if (memberTypeName != null && VariantFlyweightGenerator.isStringType((ClassName)memberTypeName)) {
                codeBlock.addStatement("return $LRO", new Object[]{name});
            } else if (memberType.isDynamicType() && memberTypeName != null) {
                codeBlock.addStatement("return $LRO", new Object[]{VariantFlyweightGenerator.fieldName(memberTypeName)});
            } else {
                codeBlock.addStatement("return $L", new Object[]{VariantFlyweightGenerator.value(name)});
            }
            TypeName returnType = this.returnType(name, memberTypeName, unsignedMemberTypeName, mapKeyType, mapValueType);
            if (!VariantFlyweightGenerator.isNonPrimitiveType(this.ofType)) {
                String accessorName = memberType.isDynamicType() && memberTypeName != null ? VariantFlyweightGenerator.fieldName(memberTypeName) : name;
                this.builder.addMethod(MethodSpec.methodBuilder((String)(mapKeyType == null ? VariantFlyweightGenerator.getAs(accessorName) : accessorName)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(returnType).addCode(codeBlock.build()).build());
            }
            return this;
        }

        private TypeName returnType(String name, TypeName memberTypeName, TypeName unsignedMemberTypeName, AstType mapKeyType, AstType mapValueType) {
            TypeName returnType = TypeName.INT;
            if (memberTypeName != null && !memberTypeName.equals((Object)TypeName.BYTE) && !memberTypeName.equals((Object)TypeName.SHORT)) {
                returnType = Objects.requireNonNullElse(unsignedMemberTypeName, mapKeyType == null ? memberTypeName : ParameterizedTypeName.get((ClassName)((ClassName)memberTypeName), (TypeName[])new TypeName[]{this.resolver.resolveClass(mapKeyType), this.resolver.resolveClass(mapValueType)}));
            }
            return returnType;
        }

        private MemberAccessorGenerator addInt24Member(String name) {
            String offsetStatement = this.kindTypeName.isPrimitive() ? String.format("int offset = offset() + %s", VariantFlyweightGenerator.offset(name)) : String.format("int offset = %s.limit()", VariantFlyweightGenerator.enumRO(this.kindTypeName));
            this.builder.addMethod(MethodSpec.methodBuilder((String)VariantFlyweightGenerator.getAs(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.INT).addStatement(offsetStatement, new Object[0]).addStatement("int bits = (buffer().getByte(offset) & 0xff) << 16 | (buffer().getByte(offset + 1) & 0xff) << 8 | (buffer().getByte(offset + 2) & 0xff)", new Object[0]).beginControlFlow("if ($T.NATIVE_BYTE_ORDER != $T.BIG_ENDIAN)", new Object[]{TypeNames.BUFFER_UTIL_TYPE, ByteOrder.class}).addStatement("bits = (buffer().getByte(offset) & 0xff) | (buffer().getByte(offset + 1) & 0xff) << 8 | (buffer().getByte(offset + 2) & 0xff) << 16", new Object[0]).endControlFlow().addStatement("return bits", new Object[0]).build());
            return this;
        }
    }

    private static final class KindAccessorGenerator
    extends ClassSpecMixinGenerator {
        private final TypeName kindTypeName;
        private final AstType ofType;

        private KindAccessorGenerator(ClassName thisType, TypeName kindTypeName, AstType ofType, TypeSpec.Builder builder) {
            super(thisType, builder);
            this.kindTypeName = kindTypeName;
            this.ofType = ofType;
        }

        @Override
        public TypeSpec.Builder build() {
            if (this.kindTypeName.isPrimitive()) {
                this.builder.addMethod(MethodSpec.methodBuilder((String)"kind").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return buffer().getByte(offset() + $L) & 0xFF", new Object[]{VariantFlyweightGenerator.offset("kind")}).build());
            } else {
                String enumFWName = ((ClassName)this.kindTypeName).simpleName();
                ClassName enumName = ClassName.bestGuess((String)enumFWName.substring(0, enumFWName.length() - 2));
                MethodSpec.Builder kindMethodBuilder = MethodSpec.methodBuilder((String)"kind").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)enumName);
                if (VariantFlyweightGenerator.isStringType(this.ofType)) {
                    this.builder.addField(FieldSpec.builder((TypeName)enumName, (String)"kind", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
                    kindMethodBuilder.addStatement("return kind", new Object[0]);
                } else {
                    kindMethodBuilder.addStatement("return $L.get()", new Object[]{VariantFlyweightGenerator.enumRO(this.kindTypeName)});
                }
                this.builder.addMethod(kindMethodBuilder.build());
            }
            return super.build();
        }
    }

    private static final class OctetsOfTypeMethodsGenerator
    extends ClassSpecMixinGenerator {
        private OctetsOfTypeMethodsGenerator(ClassName thisType, ClassName flyweightType, TypeSpec.Builder builder, TypeName kindTypeName, AstType ofType) {
            super(thisType, builder);
            if (VariantFlyweightGenerator.isBoundedOctetsType(ofType) && !kindTypeName.isPrimitive()) {
                TypeVariableName typeVarT = TypeVariableName.get((String)"T");
                ParameterizedTypeName visitorType = ParameterizedTypeName.get((ClassName)flyweightType.nestedClass("Visitor"), (TypeName[])new TypeName[]{typeVarT});
                builder.addMethod(MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)typeVarT).addTypeVariable(typeVarT).addParameter((TypeName)visitorType, "visitor", new Modifier[0]).addStatement("return get().get(visitor)", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"value").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeNames.DIRECT_BUFFER_TYPE).addStatement("return get().value()", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"length").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return get().length()", new Object[0]).build());
            }
        }
    }

    private static final class ArrayOfTypeMethodsGenerator
    extends ClassSpecMixinGenerator {
        private ArrayOfTypeMethodsGenerator(ClassName thisType, TypeSpec.Builder builder, TypeName kindTypeName, TypeVariableName typeVarV, AstType ofType) {
            super(thisType, builder);
            if (VariantFlyweightGenerator.isArrayType(ofType) && !kindTypeName.isPrimitive()) {
                WildcardTypeName itemType = WildcardTypeName.supertypeOf((TypeName)typeVarV);
                ParameterizedTypeName parameterizedConsumerType = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{itemType});
                ParameterizedTypeName parameterizedPredicateType = ParameterizedTypeName.get((ClassName)ClassName.get(Predicate.class), (TypeName[])new TypeName[]{itemType});
                builder.addMethod(MethodSpec.methodBuilder((String)"length").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return get().length()", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"fieldCount").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return get().fieldCount()", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"fieldsOffset").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return get().fieldsOffset()", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"maxLength").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return get().maxLength()", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"forEach").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE).addParameter((TypeName)parameterizedConsumerType, "consumer", new Modifier[0]).addStatement("get().forEach(consumer)", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"anyMatch").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addParameter((TypeName)parameterizedPredicateType, "predicate", new Modifier[0]).addStatement("return get().anyMatch(predicate)", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"matchFirst").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)typeVarV).addParameter((TypeName)parameterizedPredicateType, "predicate", new Modifier[0]).addStatement("return get().matchFirst(predicate)", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"isEmpty").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addStatement("return get().isEmpty()", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"items").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeNames.DIRECT_BUFFER_TYPE).addStatement("return get().items()", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"maxLength").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE).addParameter(Integer.TYPE, "maxLength", new Modifier[0]).addStatement("get().maxLength(maxLength)", new Object[0]).build());
            }
        }
    }

    private static final class ListOfTypeMethodsGenerator
    extends ClassSpecMixinGenerator {
        private ListOfTypeMethodsGenerator(ClassName thisType, TypeSpec.Builder builder, TypeName kindTypeName, AstType ofType) {
            super(thisType, builder);
            if (VariantFlyweightGenerator.isListType(ofType) && !kindTypeName.isPrimitive()) {
                builder.addMethod(MethodSpec.methodBuilder((String)"length").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return get().length()", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"fieldCount").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return get().fieldCount()", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"fields").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeNames.DIRECT_BUFFER_TYPE).addStatement("return get().fields()", new Object[0]).build());
            }
        }
    }

    private static final class StringOfTypeMethodsGenerator
    extends ClassSpecMixinGenerator {
        private StringOfTypeMethodsGenerator(ClassName thisType, TypeSpec.Builder builder, TypeName kindTypeName, AstType ofType) {
            super(thisType, builder);
            if (VariantFlyweightGenerator.isStringType(ofType) && !kindTypeName.isPrimitive()) {
                builder.addMethod(MethodSpec.methodBuilder((String)"fieldSizeLength").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return get().fieldSizeLength()", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"asString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return get().asString()", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"length").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return get().length()", new Object[0]).build());
            }
        }
    }

    private final class ToStringMethodGenerator
    extends MethodSpecGenerator {
        private final TypeName kindTypeName;
        private final AstType ofType;
        private final TypeResolver resolver;

        private ToStringMethodGenerator(TypeName kindTypeName, AstType ofType, TypeResolver resolver) {
            super(MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class));
            this.kindTypeName = kindTypeName;
            this.ofType = ofType;
            this.resolver = resolver;
            if (!(VariantFlyweightGenerator.isListType(ofType) || VariantFlyweightGenerator.isArrayType(ofType) || VariantFlyweightGenerator.isMapType(ofType) || VariantFlyweightGenerator.isBoundedOctetsType(ofType))) {
                this.builder.beginControlFlow("switch (kind())", new Object[0]);
            }
        }

        public ToStringMethodGenerator addMember(String name, Object kindValue, String memberName, AstType memberType, TypeName memberTypeName, AstType mapKeyType) {
            if (!(VariantFlyweightGenerator.isListType(this.ofType) || VariantFlyweightGenerator.isArrayType(this.ofType) || VariantFlyweightGenerator.isMapType(this.ofType) || VariantFlyweightGenerator.isBoundedOctetsType(this.ofType))) {
                this.builder.beginControlFlow("case $L:", new Object[]{this.kindTypeName.isPrimitive() && memberType != null ? VariantFlyweightGenerator.kind(memberName) : kindValue});
                if (memberType != null) {
                    if (VariantFlyweightGenerator.isStringType(memberType)) {
                        this.builder.addStatement("return String.format(\"$L [$L=%s]\", $LRO.asString())", new Object[]{VariantFlyweightGenerator.constant(VariantFlyweightGenerator.this.baseName), memberName, memberName});
                    } else if (memberTypeName == null || memberTypeName.isPrimitive()) {
                        this.builder.addStatement("return String.format(\"$L [$L=%d]\", $L())", new Object[]{VariantFlyweightGenerator.constant(VariantFlyweightGenerator.this.baseName), NUMBER_WORDS.get(memberName) == null ? memberName : NUMBER_WORDS.get(memberName), VariantFlyweightGenerator.getAs(memberName)});
                    } else if (this.ofType == null) {
                        if (mapKeyType == null) {
                            this.builder.addStatement("return $LRO.toString()", new Object[]{VariantFlyweightGenerator.fieldName(memberTypeName)});
                        } else {
                            this.builder.addStatement("return $L().toString()", new Object[]{VariantFlyweightGenerator.fieldName(memberTypeName)});
                        }
                    } else if (this.resolver.resolve(name) != null && this.resolver.resolve(name).getKind() == AstNamedNode.Kind.VARIANT) {
                        this.builder.addStatement("return $LRO.toString()", new Object[]{VariantFlyweightGenerator.fieldName(memberTypeName)});
                    } else {
                        this.builder.addStatement("return String.format(\"$L [$L=%s]\", $L())", new Object[]{VariantFlyweightGenerator.constant(VariantFlyweightGenerator.this.baseName), memberName, VariantFlyweightGenerator.getAs(memberName)});
                    }
                }
                this.builder.endControlFlow();
            }
            return this;
        }

        @Override
        public MethodSpec generate() {
            if (VariantFlyweightGenerator.isListType(this.ofType) || VariantFlyweightGenerator.isArrayType(this.ofType) || VariantFlyweightGenerator.isMapType(this.ofType) || VariantFlyweightGenerator.isBoundedOctetsType(this.ofType)) {
                this.builder.addStatement("return get().toString()", new Object[0]);
            } else {
                this.builder.beginControlFlow("default:", new Object[0]).addStatement("return String.format(\"$L [unknown]\")", new Object[]{VariantFlyweightGenerator.constant(VariantFlyweightGenerator.this.baseName)}).endControlFlow().endControlFlow();
            }
            return this.builder.build();
        }
    }

    private final class WrapMethodWithArrayGenerator
    extends MethodSpecGenerator {
        private final TypeName kindTypeName;
        private final AstType ofType;

        private WrapMethodWithArrayGenerator(TypeName kindTypeName, AstType ofType, TypeResolver resolver) {
            super(MethodSpec.methodBuilder((String)"wrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).addParameter(resolver.resolveType(AstType.ARRAY), "array", new Modifier[0]).returns(VariantFlyweightGenerator.this.thisName));
            this.kindTypeName = kindTypeName;
            this.ofType = ofType;
            if (VariantFlyweightGenerator.isStringType(ofType) && !kindTypeName.isPrimitive()) {
                String enumFieldName = VariantFlyweightGenerator.enumFWName(kindTypeName);
                this.builder.addStatement("final int fieldsOffset = array.fieldsOffset()", new Object[0]).addStatement("super.wrap(buffer, fieldsOffset, maxLimit)", new Object[0]).addStatement("final $L $L = $L.wrap(buffer, fieldsOffset, maxLimit)", new Object[]{((ClassName)kindTypeName).simpleName(), enumFieldName, VariantFlyweightGenerator.enumRO(kindTypeName)}).addStatement("final int kindPadding = offset == fieldsOffset ? 0 : offset - fieldsOffset - $L.sizeof()", new Object[]{enumFieldName}).beginControlFlow("if (kind == null)", new Object[0]).addStatement("kind = $L.get()", new Object[]{enumFieldName}).endControlFlow().beginControlFlow("switch (kind())", new Object[0]);
            }
        }

        public WrapMethodWithArrayGenerator addMember(Object kindValue, String memberName) {
            if (VariantFlyweightGenerator.isStringType(this.ofType) && !this.kindTypeName.isPrimitive()) {
                this.builder.beginControlFlow("case $L:", new Object[]{kindValue}).addStatement("$LRO.wrap(buffer, $L.limit() + kindPadding, maxLimit)", new Object[]{memberName, VariantFlyweightGenerator.enumFWName(this.kindTypeName)}).addStatement("break", new Object[0]).endControlFlow();
            }
            return this;
        }

        @Override
        public MethodSpec generate() {
            return this.builder.beginControlFlow("default:", new Object[0]).addStatement("break", new Object[0]).endControlFlow().endControlFlow().addStatement("checkLimit(limit(), maxLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        @Override
        public void mixin(TypeSpec.Builder builder) {
            if (VariantFlyweightGenerator.isStringType(this.ofType) && !this.kindTypeName.isPrimitive()) {
                super.mixin(builder);
            }
        }
    }

    private final class WrapMethodGenerator
    extends MethodSpecGenerator {
        private final TypeName kindTypeName;
        private final AstType ofType;
        private final TypeResolver resolver;

        private WrapMethodGenerator(TypeName kindTypeName, AstType ofType, TypeResolver resolver) {
            super(MethodSpec.methodBuilder((String)"wrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(VariantFlyweightGenerator.this.thisName).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]));
            this.kindTypeName = kindTypeName;
            this.ofType = ofType;
            this.resolver = resolver;
            if (!kindTypeName.isPrimitive()) {
                this.builder.addStatement("final $L $L = $L.wrap(buffer, offset, maxLimit)", new Object[]{((ClassName)kindTypeName).simpleName(), VariantFlyweightGenerator.enumFWName(kindTypeName), VariantFlyweightGenerator.enumRO(kindTypeName)});
            }
            if (VariantFlyweightGenerator.isArrayType(ofType)) {
                this.builder.returns((TypeName)ParameterizedTypeName.get((ClassName)((ClassName)VariantFlyweightGenerator.this.thisName), (TypeName[])new TypeName[]{VariantFlyweightGenerator.this.typeVarV}));
            } else if (VariantFlyweightGenerator.isMapType(ofType)) {
                this.builder.returns((TypeName)ParameterizedTypeName.get((ClassName)((ClassName)VariantFlyweightGenerator.this.thisName), (TypeName[])new TypeName[]{VariantFlyweightGenerator.this.typeVarKV, VariantFlyweightGenerator.this.typeVarVV}));
            }
            if (VariantFlyweightGenerator.isStringType(ofType) && !kindTypeName.isPrimitive()) {
                this.builder.addStatement("kind = $L.get()", new Object[]{VariantFlyweightGenerator.enumFWName(kindTypeName)}).beginControlFlow("switch (kind)", new Object[0]);
            } else {
                this.builder.beginControlFlow("switch (kind())", new Object[0]);
            }
        }

        public WrapMethodGenerator addMember(Object kindValue, String memberName, TypeName memberTypeName, AstType mapKeyType) {
            this.builder.beginControlFlow("case $L:", new Object[]{this.kindTypeName.isPrimitive() ? VariantFlyweightGenerator.kind(memberName) : kindValue});
            if (VariantFlyweightGenerator.isNonPrimitiveType(this.ofType)) {
                this.builder.addStatement("$LRO.wrap(buffer, offset + $L, maxLimit)", new Object[]{memberName, this.kindTypeName.isPrimitive() ? VariantFlyweightGenerator.offset(memberName) : String.format("%s.sizeof()", VariantFlyweightGenerator.enumFWName(this.kindTypeName))});
            } else if (mapKeyType != null) {
                this.builder.addStatement("$L().wrap(buffer, offset, maxLimit)", new Object[]{VariantFlyweightGenerator.fieldName(memberTypeName)});
            } else if (this.ofType == null && memberTypeName != null) {
                this.builder.addStatement("$LRO.wrap(buffer, offset, maxLimit)", new Object[]{VariantFlyweightGenerator.fieldName(memberTypeName)});
            } else if (this.resolver.resolve(memberName) != null && this.resolver.resolve(memberName).getKind() == AstNamedNode.Kind.VARIANT) {
                this.builder.addStatement("$LRO.wrap(buffer, offset + $L, maxLimit)", new Object[]{VariantFlyweightGenerator.fieldName(memberTypeName), this.kindTypeName.isPrimitive() ? VariantFlyweightGenerator.offset(memberName) : String.format("%s.sizeof()", VariantFlyweightGenerator.enumFWName(this.kindTypeName))});
            }
            if (this.ofType != null || memberTypeName != null) {
                this.builder.addStatement("break", new Object[0]);
            }
            this.builder.endControlFlow();
            return this;
        }

        @Override
        public MethodSpec generate() {
            return this.builder.beginControlFlow("default:", new Object[0]).addStatement("break", new Object[0]).endControlFlow().endControlFlow().addStatement("checkLimit(limit(), maxLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
        }
    }

    private final class TryWrapMethodGenerator
    extends MethodSpecGenerator {
        private final TypeName kindTypeName;
        private final AstType ofType;
        private final TypeResolver resolver;

        private TryWrapMethodGenerator(TypeName kindTypeName, AstType ofType, TypeResolver resolver) {
            super(MethodSpec.methodBuilder((String)"tryWrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(VariantFlyweightGenerator.this.thisName).beginControlFlow("if (super.tryWrap(buffer, offset, maxLimit) == null)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow());
            this.kindTypeName = kindTypeName;
            this.ofType = ofType;
            this.resolver = resolver;
            if (!kindTypeName.isPrimitive()) {
                this.builder.addStatement("final $L $L = $L.tryWrap(buffer, offset, maxLimit)", new Object[]{((ClassName)kindTypeName).simpleName(), VariantFlyweightGenerator.enumFWName(kindTypeName), VariantFlyweightGenerator.enumRO(kindTypeName)}).beginControlFlow(!VariantFlyweightGenerator.isStringType(ofType) ? "if ($L == null || kind() == null)" : "if ($L == null)", new Object[]{VariantFlyweightGenerator.enumFWName(kindTypeName)}).addStatement("return null", new Object[0]).endControlFlow();
            }
            if (VariantFlyweightGenerator.isArrayType(ofType)) {
                this.builder.returns((TypeName)ParameterizedTypeName.get((ClassName)((ClassName)VariantFlyweightGenerator.this.thisName), (TypeName[])new TypeName[]{VariantFlyweightGenerator.this.typeVarV}));
            } else if (VariantFlyweightGenerator.isMapType(ofType)) {
                this.builder.returns((TypeName)ParameterizedTypeName.get((ClassName)((ClassName)VariantFlyweightGenerator.this.thisName), (TypeName[])new TypeName[]{VariantFlyweightGenerator.this.typeVarKV, VariantFlyweightGenerator.this.typeVarVV}));
            }
            if (VariantFlyweightGenerator.isStringType(ofType) && !kindTypeName.isPrimitive()) {
                this.builder.addStatement("kind = $L.get()", new Object[]{VariantFlyweightGenerator.enumFWName(kindTypeName)}).beginControlFlow("switch (kind)", new Object[0]);
            } else {
                this.builder.beginControlFlow("switch (kind())", new Object[0]);
            }
        }

        public TryWrapMethodGenerator addMember(Object kindValue, String memberName, TypeName memberTypeName, AstType mapKeyType) {
            this.builder.beginControlFlow("case $L:", new Object[]{this.kindTypeName.isPrimitive() ? VariantFlyweightGenerator.kind(memberName) : kindValue});
            if (VariantFlyweightGenerator.isNonPrimitiveType(this.ofType)) {
                this.builder.beginControlFlow("if ($LRO.tryWrap(buffer, offset + $L, maxLimit) == null)", new Object[]{memberName, this.kindTypeName.isPrimitive() ? VariantFlyweightGenerator.offset(memberName) : String.format("%s.sizeof()", VariantFlyweightGenerator.enumFWName(this.kindTypeName))}).addStatement("return null", new Object[0]).endControlFlow();
            } else if (mapKeyType != null) {
                this.builder.beginControlFlow("if ($L().tryWrap(buffer, offset, maxLimit) == null)", new Object[]{VariantFlyweightGenerator.fieldName(memberTypeName)}).addStatement("return null", new Object[0]).endControlFlow();
            } else if (this.ofType == null && memberTypeName != null) {
                this.builder.beginControlFlow("if ($LRO.tryWrap(buffer, offset, maxLimit) == null)", new Object[]{VariantFlyweightGenerator.fieldName(memberTypeName)}).addStatement("return null", new Object[0]).endControlFlow();
            } else if (this.resolver.resolve(memberName) != null && this.resolver.resolve(memberName).getKind() == AstNamedNode.Kind.VARIANT) {
                this.builder.beginControlFlow("if ($LRO.tryWrap(buffer, offset + $L, maxLimit) == null)", new Object[]{VariantFlyweightGenerator.fieldName(memberTypeName), this.kindTypeName.isPrimitive() ? VariantFlyweightGenerator.offset(memberName) : String.format("%s.sizeof()", VariantFlyweightGenerator.enumFWName(this.kindTypeName))}).addStatement("return null", new Object[0]).endControlFlow();
            }
            if (this.ofType != null || memberTypeName != null) {
                this.builder.addStatement("break", new Object[0]);
            }
            this.builder.endControlFlow();
            return this;
        }

        @Override
        public MethodSpec generate() {
            return this.builder.beginControlFlow("default:", new Object[0]).addStatement("break", new Object[0]).endControlFlow().endControlFlow().beginControlFlow("if (limit() > maxLimit)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("return this", new Object[0]).build();
        }
    }

    private static final class ConstructorGenerator
    extends MethodSpecGenerator {
        private final AstType ofType;
        private final TypeVariableName typeVarV;
        private final TypeVariableName typeVarKV;
        private final TypeVariableName typeVarVV;
        private final AstByteOrder byteOrder;

        private ConstructorGenerator(AstType ofType, TypeVariableName typeVarV, TypeVariableName typeVarKV, TypeVariableName typeVarVV, AstByteOrder byteOrder) {
            super(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}));
            this.ofType = ofType;
            this.typeVarV = typeVarV;
            this.typeVarKV = typeVarKV;
            this.typeVarVV = typeVarVV;
            this.byteOrder = byteOrder;
        }

        public ConstructorGenerator addMember(String memberName, AstType memberType, TypeName memberTypeName) {
            if (VariantFlyweightGenerator.isArrayType(this.ofType)) {
                if (this.byteOrder == AstByteOrder.NATIVE || memberType.equals(AstType.ARRAY8)) {
                    this.builder.addStatement("$LRO = new $T<>(type)", new Object[]{memberName, memberTypeName});
                } else {
                    this.builder.addStatement("$LRO = new $T<>(type, $T.BIG_ENDIAN)", new Object[]{memberName, memberTypeName, ByteOrder.class});
                }
            } else if (VariantFlyweightGenerator.isMapType(this.ofType)) {
                if (this.byteOrder == AstByteOrder.NATIVE || memberType.equals(AstType.MAP8)) {
                    this.builder.addStatement("$LRO = new $T<>(keyType, valueType)", new Object[]{memberName, memberTypeName});
                } else {
                    this.builder.addStatement("$LRO = new $T<>(keyType, valueType, $T.BIG_ENDIAN)", new Object[]{memberName, memberTypeName, ByteOrder.class});
                }
            }
            return this;
        }

        @Override
        public MethodSpec generate() {
            if (VariantFlyweightGenerator.isArrayType(this.ofType)) {
                this.builder.addParameter((TypeName)this.typeVarV, "type", new Modifier[0]);
            } else if (VariantFlyweightGenerator.isMapType(this.ofType)) {
                this.builder.addParameter((TypeName)this.typeVarKV, "keyType", new Modifier[0]).addParameter((TypeName)this.typeVarVV, "valueType", new Modifier[0]);
            }
            return this.builder.build();
        }

        @Override
        public void mixin(TypeSpec.Builder builder) {
            if (VariantFlyweightGenerator.isArrayType(this.ofType) || VariantFlyweightGenerator.isMapType(this.ofType)) {
                super.mixin(builder);
            }
        }
    }

    private static final class MissingFieldPlaceholderConstantGenerator
    extends ClassSpecMixinGenerator {
        private int missingFieldValue;

        private MissingFieldPlaceholderConstantGenerator(ClassName thisType, TypeSpec.Builder builder) {
            super(thisType, builder);
        }

        public MissingFieldPlaceholderConstantGenerator addMember(AstType memberType, int missingFieldValue) {
            if ((AstType.LIST32.equals(memberType) || AstType.LIST8.equals(memberType)) && missingFieldValue != 0) {
                this.missingFieldValue = missingFieldValue;
            }
            return this;
        }

        @Override
        public TypeSpec.Builder build() {
            if (this.missingFieldValue != 0) {
                this.builder.addField(FieldSpec.builder(Byte.TYPE, (String)"MISSING_FIELD_PLACEHOLDER", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(String.valueOf(this.missingFieldValue), new Object[0]).build());
            }
            return super.build();
        }
    }

    private static final class MemberFieldValueConstantGenerator
    extends ClassSpecMixinGenerator {
        private MemberFieldValueConstantGenerator(ClassName thisType, TypeSpec.Builder builder) {
            super(thisType, builder);
        }

        public MemberFieldValueConstantGenerator addMember(String memberName, TypeName memberTypeName) {
            if (memberName != null && memberTypeName == null) {
                this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)VariantFlyweightGenerator.value(memberName), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(memberName, new Object[0]).build());
            }
            return this;
        }
    }

    private static final class MemberOffsetConstantGenerator
    extends ClassSpecMixinGenerator {
        private final TypeName kindName;

        private MemberOffsetConstantGenerator(ClassName thisType, TypeName kindName, TypeSpec.Builder builder) {
            super(thisType, builder);
            this.kindName = kindName;
            if (kindName.isPrimitive()) {
                builder.addField(FieldSpec.builder(Integer.TYPE, (String)VariantFlyweightGenerator.offset("kind"), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("0", new Object[0]).build());
            }
        }

        public MemberOffsetConstantGenerator addMember(String memberName, TypeName memberTypeName) {
            if (this.kindName.isPrimitive() && memberTypeName != null) {
                this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)VariantFlyweightGenerator.offset(memberName), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(String.format("%s + %s", VariantFlyweightGenerator.offset("kind"), VariantFlyweightGenerator.size("kind")), new Object[0]).build());
            }
            return this;
        }
    }

    private static final class MemberSizeConstantGenerator
    extends ClassSpecMixinGenerator {
        private MemberSizeConstantGenerator(ClassName thisType, TypeName kindName, TypeSpec.Builder builder) {
            super(thisType, builder);
            if (kindName.isPrimitive()) {
                builder.addField(FieldSpec.builder(Integer.TYPE, (String)VariantFlyweightGenerator.size("kind"), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.SIZE_OF_BYTE", new Object[]{TypeNames.BIT_UTIL_TYPE}).build());
            }
        }

        public MemberSizeConstantGenerator addMember(String name, TypeName memberTypeName, TypeName unsignedMemberTypeName) {
            if (memberTypeName != null && memberTypeName.isPrimitive()) {
                this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)VariantFlyweightGenerator.size(name), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.SIZE_OF_$L", new Object[]{TypeNames.BIT_UTIL_TYPE, ((String)TYPE_NAMES.get(memberTypeName)).toUpperCase()}).build());
            }
            return this;
        }
    }

    private static final class KindConstantGenerator
    extends ClassSpecMixinGenerator {
        private final TypeName kindName;
        private final AstType ofType;

        private KindConstantGenerator(ClassName thisType, TypeName kindName, AstType ofType, TypeSpec.Builder builder) {
            super(thisType, builder);
            this.kindName = kindName;
            this.ofType = ofType;
        }

        public KindConstantGenerator addMember(Object kindValue, String name, AstType memberType, TypeName memberTypeName) {
            FieldSpec field;
            String kindName = name;
            if (memberTypeName != null && memberType.isDynamicType() || this.ofType == null) {
                kindName = kindValue.toString();
            }
            if (this.kindName.isPrimitive()) {
                field = FieldSpec.builder(Integer.TYPE, (String)VariantFlyweightGenerator.kind(kindName), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$L", new Object[]{kindValue}).build();
            } else {
                ClassName enumTypeName = VariantFlyweightGenerator.enumClassName(this.kindName);
                field = FieldSpec.builder((TypeName)enumTypeName, (String)VariantFlyweightGenerator.kind(kindName), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$L.$L", new Object[]{enumTypeName.simpleName(), kindValue}).build();
            }
            this.builder.addField(field);
            return this;
        }
    }

    private static final class MemberFieldGenerator
    extends ClassSpecMixinGenerator {
        private final AstType ofType;
        private final TypeVariableName typeVarV;
        private final TypeVariableName typeVarKV;
        private final TypeVariableName typeVarVV;
        private final TypeResolver resolver;
        private final AstByteOrder byteOrder;

        private MemberFieldGenerator(ClassName thisType, TypeName kindName, AstType ofType, TypeVariableName typeVarV, TypeVariableName typeVarKV, TypeVariableName typeVarVV, TypeSpec.Builder builder, TypeResolver resolver, AstByteOrder byteOrder) {
            super(thisType, builder);
            this.ofType = ofType;
            this.typeVarV = typeVarV;
            this.typeVarKV = typeVarKV;
            this.typeVarVV = typeVarVV;
            this.resolver = resolver;
            this.byteOrder = byteOrder;
            if (!kindName.isPrimitive()) {
                String kindTypeVariableName = VariantFlyweightGenerator.enumRO(kindName);
                builder.addField(FieldSpec.builder((TypeName)kindName, (String)kindTypeVariableName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T()", new Object[]{kindName}).build());
            }
        }

        public MemberFieldGenerator addMember(String name, AstType memberType, TypeName memberTypeName, AstType mapKeyType, AstType mapValueType) {
            if (memberTypeName != null && !memberTypeName.isPrimitive()) {
                FieldSpec.Builder fieldBuilder;
                String fieldRO = String.format("%sRO", name);
                if (memberType != null && memberType.isDynamicType() || this.ofType == null) {
                    fieldRO = String.format("%sRO", VariantFlyweightGenerator.fieldName(memberTypeName));
                }
                if (VariantFlyweightGenerator.isArrayType(this.ofType)) {
                    ParameterizedTypeName parameterizedArrayType = ParameterizedTypeName.get((ClassName)((ClassName)memberTypeName), (TypeName[])new TypeName[]{this.typeVarV});
                    fieldBuilder = FieldSpec.builder((TypeName)parameterizedArrayType, (String)fieldRO, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                } else if (VariantFlyweightGenerator.isMapType(this.ofType)) {
                    ParameterizedTypeName parameterizedMapType = ParameterizedTypeName.get((ClassName)((ClassName)memberTypeName), (TypeName[])new TypeName[]{this.typeVarKV, this.typeVarVV});
                    fieldBuilder = FieldSpec.builder((TypeName)parameterizedMapType, (String)fieldRO, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                } else if (mapKeyType != null) {
                    ParameterizedTypeName parameterizedMapTypeName = ParameterizedTypeName.get((ClassName)((ClassName)memberTypeName), (TypeName[])new TypeName[]{this.resolver.resolveClass(mapKeyType), this.resolver.resolveClass(mapValueType)});
                    fieldBuilder = FieldSpec.builder((TypeName)parameterizedMapTypeName, (String)fieldRO, (Modifier[])new Modifier[]{Modifier.PRIVATE});
                } else if (VariantFlyweightGenerator.isListType(this.ofType) || VariantFlyweightGenerator.isBoundedOctetsType(this.ofType) || VariantFlyweightGenerator.isStringType(this.ofType)) {
                    fieldBuilder = FieldSpec.builder((TypeName)memberTypeName, (String)fieldRO, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                    if (this.byteOrder == AstByteOrder.NATIVE || memberType.equals(AstType.LIST0) || memberType.equals(AstType.LIST8) || memberType.equals(AstType.BOUNDED_OCTETS8) || memberType.equals(AstType.STRING8)) {
                        fieldBuilder.initializer("new $T()", new Object[]{memberTypeName});
                    } else {
                        fieldBuilder.initializer("new $T($T.BIG_ENDIAN)", new Object[]{memberTypeName, ByteOrder.class});
                    }
                } else {
                    fieldBuilder = FieldSpec.builder((TypeName)memberTypeName, (String)fieldRO, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T()", new Object[]{memberTypeName});
                }
                this.builder.addField(fieldBuilder.build());
            }
            return this;
        }
    }
}

