/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.generate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.util.function.Consumer;
import javax.lang.model.element.Modifier;
import org.reaktivity.nukleus.maven.plugin.internal.generate.ClassSpecGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeNames;

public final class FlyweightGenerator
extends ClassSpecGenerator {
    private final TypeSpec.Builder classBuilder;
    private final ClassName arrayType;
    private final BuilderClassBuilder builderClassBuilder;

    public FlyweightGenerator(ClassName flyweightType, ClassName arrayType) {
        super(flyweightType);
        this.classBuilder = TypeSpec.classBuilder((ClassName)((ClassName)this.thisName)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
        this.arrayType = arrayType;
        this.builderClassBuilder = new BuilderClassBuilder((ClassName)this.thisName, arrayType);
    }

    @Override
    public TypeSpec generate() {
        return this.classBuilder.addField(this.bufferField()).addField(this.emptyBytesField()).addField(this.offsetField()).addField(this.maxLimitField()).addField(this.compareBufferField()).addMethod(this.offsetMethod()).addMethod(this.bufferMethod()).addMethod(this.limitMethod()).addMethod(this.sizeofMethod()).addMethod(this.maxLimitMethod()).addMethod(this.tryWrapMethod()).addMethod(this.wrapMethod()).addMethod(this.wrapWithArrayMethod()).addMethod(this.checkLimitMethod()).addMethod(this.equalsMethod()).addMethod(this.hashCodeMethod()).addType(this.visitorInterface()).addType(this.builderClassBuilder.build()).build();
    }

    private TypeSpec visitorInterface() {
        TypeVariableName typeVarT = TypeVariableName.get((String)"T");
        return TypeSpec.interfaceBuilder((ClassName)((ClassName)this.thisName).nestedClass("Visitor")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(typeVarT).addAnnotation(FunctionalInterface.class).addMethod(MethodSpec.methodBuilder((String)"visit").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)typeVarT).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).build()).build();
    }

    private FieldSpec bufferField() {
        return FieldSpec.builder((TypeName)TypeNames.DIRECT_BUFFER_TYPE, (String)"buffer", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
    }

    private FieldSpec offsetField() {
        return FieldSpec.builder(Integer.TYPE, (String)"offset", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
    }

    private FieldSpec maxLimitField() {
        return FieldSpec.builder(Integer.TYPE, (String)"maxLimit", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
    }

    private FieldSpec compareBufferField() {
        return FieldSpec.builder((TypeName)TypeNames.UNSAFE_BUFFER_TYPE, (String)"compareBuffer", (Modifier[])new Modifier[]{Modifier.PRIVATE}).initializer("new UnsafeBuffer(EMPTY_BYTES)", new Object[0]).build();
    }

    private FieldSpec emptyBytesField() {
        return FieldSpec.builder(byte[].class, (String)"EMPTY_BYTES", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).initializer("new byte[0]", new Object[0]).build();
    }

    private MethodSpec maxLimitMethod() {
        return MethodSpec.methodBuilder((String)"maxLimit").addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(Integer.TYPE).addStatement("return maxLimit", new Object[0]).build();
    }

    private MethodSpec offsetMethod() {
        return MethodSpec.methodBuilder((String)"offset").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(Integer.TYPE).addStatement("return offset", new Object[0]).build();
    }

    private MethodSpec bufferMethod() {
        return MethodSpec.methodBuilder((String)"buffer").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns((TypeName)TypeNames.DIRECT_BUFFER_TYPE).addStatement("return buffer", new Object[0]).build();
    }

    private MethodSpec limitMethod() {
        return MethodSpec.methodBuilder((String)"limit").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(Integer.TYPE).build();
    }

    private MethodSpec sizeofMethod() {
        return MethodSpec.methodBuilder((String)"sizeof").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(Integer.TYPE).addStatement("return limit() - offset()", new Object[0]).build();
    }

    private MethodSpec tryWrapMethod() {
        return MethodSpec.methodBuilder((String)"tryWrap").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(this.thisName).beginControlFlow("if (offset > maxLimit)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("this.buffer = buffer", new Object[0]).addStatement("this.offset = offset", new Object[0]).addStatement("this.maxLimit = maxLimit", new Object[0]).addStatement("return this", new Object[0]).build();
    }

    private MethodSpec wrapMethod() {
        return MethodSpec.methodBuilder((String)"wrap").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(this.thisName).beginControlFlow("if (offset > maxLimit)", new Object[0]).addStatement("final String msg = String.format(\"offset=%d is beyond maxLimit=%d\", offset, maxLimit)", new Object[0]).addStatement("throw new IndexOutOfBoundsException(msg)", new Object[0]).endControlFlow().addStatement("this.buffer = buffer", new Object[0]).addStatement("this.offset = offset", new Object[0]).addStatement("this.maxLimit = maxLimit", new Object[0]).addStatement("return this", new Object[0]).build();
    }

    private MethodSpec wrapWithArrayMethod() {
        return MethodSpec.methodBuilder((String)"wrap").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).addParameter((TypeName)this.arrayType, "array", new Modifier[0]).returns(this.thisName).addStatement("wrap(buffer, offset, maxLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
    }

    private MethodSpec checkLimitMethod() {
        return MethodSpec.methodBuilder((String)"checkLimit").addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.STATIC, Modifier.FINAL}).addParameter(Integer.TYPE, "limit", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).beginControlFlow("if (limit > maxLimit)", new Object[0]).addStatement("final String msg = String.format(\"limit=%d is beyond maxLimit=%d\", limit, maxLimit)", new Object[0]).addStatement("throw new IndexOutOfBoundsException(msg)", new Object[0]).endControlFlow().build();
    }

    private MethodSpec equalsMethod() {
        return MethodSpec.methodBuilder((String)"equals").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Object.class, "obj", new Modifier[0]).returns(Boolean.TYPE).beginControlFlow("if (this == obj)", new Object[0]).addStatement("return true", new Object[0]).nextControlFlow("else if (obj == null || !(obj instanceof Flyweight))", new Object[0]).addStatement("return false", new Object[0]).nextControlFlow("else", new Object[0]).addStatement("Flyweight that = (Flyweight) obj", new Object[0]).addStatement("compareBuffer.wrap(buffer, offset, sizeof())", new Object[0]).addStatement("that.compareBuffer.wrap(that.buffer, that.offset, that.sizeof())", new Object[0]).addStatement("return compareBuffer.equals(that.compareBuffer)", new Object[0]).endControlFlow().build();
    }

    private MethodSpec hashCodeMethod() {
        return MethodSpec.methodBuilder((String)"hashCode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("int result = 1", new Object[0]).beginControlFlow("for (int i = offset; i < limit(); i++)", new Object[0]).addStatement("result = 31 * result + buffer.getByte(i)", new Object[0]).endControlFlow().addStatement("return result", new Object[0]).build();
    }

    private static final class BuilderClassBuilder {
        private final TypeSpec.Builder classBuilder;
        private final ClassName thisRawName;
        private final ClassName arrayType;
        private final ParameterizedTypeName thisName;
        private final TypeVariableName typeVarT;

        private BuilderClassBuilder(ClassName flyweightType, ClassName arrayType) {
            this.thisRawName = flyweightType.nestedClass("Builder");
            this.arrayType = arrayType;
            this.typeVarT = TypeVariableName.get((String)"T");
            this.thisName = ParameterizedTypeName.get((ClassName)this.thisRawName, (TypeName[])new TypeName[]{this.typeVarT});
            this.classBuilder = TypeSpec.classBuilder((String)this.thisRawName.simpleName()).addTypeVariable(this.typeVarT.withBounds(new TypeName[]{flyweightType})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT, Modifier.STATIC});
        }

        public TypeSpec build() {
            return this.classBuilder.addField(this.flyweightField()).addField(this.bufferField()).addField(this.offsetField()).addField(this.limitField()).addField(this.maxLimitField()).addMethod(this.limitAccessor()).addMethod(this.maxLimitAccessor()).addMethod(this.buildMethod()).addMethod(this.resetMethod()).addMethod(this.rewrapMethod()).addMethod(this.constructor()).addMethod(this.flyweightAccessor()).addMethod(this.bufferAccessor()).addMethod(this.offsetAccessor()).addMethod(this.sizeofAccessor()).addMethod(this.limitMutator()).addMethod(this.wrapMethod()).addMethod(this.wrapWithArrayMethod()).addMethod(this.iterateMethod()).addMethod(this.rebuildMethod()).addMethod(this.setMethod()).addType(this.visitorInterface()).build();
        }

        private TypeSpec visitorInterface() {
            return TypeSpec.interfaceBuilder((ClassName)this.thisRawName.nestedClass("Visitor")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(FunctionalInterface.class).addMethod(MethodSpec.methodBuilder((String)"visit").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)TypeNames.MUTABLE_DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(Integer.TYPE).build()).build();
        }

        private FieldSpec flyweightField() {
            return FieldSpec.builder((TypeName)this.typeVarT, (String)"flyweight", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        }

        private FieldSpec bufferField() {
            return FieldSpec.builder((TypeName)TypeNames.MUTABLE_DIRECT_BUFFER_TYPE, (String)"buffer", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
        }

        private FieldSpec offsetField() {
            return FieldSpec.builder(Integer.TYPE, (String)"offset", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
        }

        private FieldSpec limitField() {
            return FieldSpec.builder(Integer.TYPE, (String)"limit", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
        }

        private FieldSpec maxLimitField() {
            return FieldSpec.builder(Integer.TYPE, (String)"maxLimit", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
        }

        private MethodSpec limitAccessor() {
            return MethodSpec.methodBuilder((String)"limit").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(Integer.TYPE).addStatement("return limit", new Object[0]).build();
        }

        private MethodSpec maxLimitAccessor() {
            return MethodSpec.methodBuilder((String)"maxLimit").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(Integer.TYPE).addStatement("return maxLimit", new Object[0]).build();
        }

        private MethodSpec buildMethod() {
            return MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.typeVarT).addStatement("flyweight.wrap(buffer, offset, limit)", new Object[0]).addStatement("return flyweight", new Object[0]).build();
        }

        private MethodSpec resetMethod() {
            ClassName arrayBuilderRawType = this.arrayType.nestedClass("Builder");
            WildcardTypeName arrayParametricTypeT = WildcardTypeName.subtypeOf((TypeName)ParameterizedTypeName.get((ClassName)this.arrayType, (TypeName[])new TypeName[]{this.typeVarT}));
            WildcardTypeName arrayParametricTypeB = WildcardTypeName.subtypeOf((TypeName)ParameterizedTypeName.get((ClassName)this.thisRawName, (TypeName[])new TypeName[]{this.typeVarT}));
            ParameterizedTypeName parameterizedArrayBuilderType = ParameterizedTypeName.get((ClassName)arrayBuilderRawType, (TypeName[])new TypeName[]{arrayParametricTypeT, arrayParametricTypeB, this.typeVarT});
            return MethodSpec.methodBuilder((String)"reset").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)parameterizedArrayBuilderType, "array", new Modifier[0]).build();
        }

        private MethodSpec rewrapMethod() {
            return MethodSpec.methodBuilder((String)"rewrap").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisName).addStatement("this.limit = this.offset", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec constructor() {
            return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter((TypeName)this.typeVarT, "flyweight", new Modifier[0]).addStatement("this.flyweight = flyweight", new Object[0]).build();
        }

        private MethodSpec flyweightAccessor() {
            return MethodSpec.methodBuilder((String)"flyweight").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns((TypeName)this.typeVarT).addStatement("return flyweight", new Object[0]).build();
        }

        private MethodSpec bufferAccessor() {
            return MethodSpec.methodBuilder((String)"buffer").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns((TypeName)TypeNames.MUTABLE_DIRECT_BUFFER_TYPE).addStatement("return buffer", new Object[0]).build();
        }

        private MethodSpec offsetAccessor() {
            return MethodSpec.methodBuilder((String)"offset").addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(Integer.TYPE).addStatement("return offset", new Object[0]).build();
        }

        private MethodSpec sizeofAccessor() {
            return MethodSpec.methodBuilder((String)"sizeof").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return limit - offset", new Object[0]).build();
        }

        private MethodSpec limitMutator() {
            return MethodSpec.methodBuilder((String)"limit").addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).addParameter(Integer.TYPE, "limit", new Modifier[0]).addStatement("this.limit = limit", new Object[0]).build();
        }

        private MethodSpec wrapMethod() {
            return MethodSpec.methodBuilder((String)"wrap").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisName).addParameter((TypeName)TypeNames.MUTABLE_DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).addStatement("this.buffer = buffer", new Object[0]).addStatement("this.offset = offset", new Object[0]).addStatement("this.limit = offset", new Object[0]).addStatement("this.maxLimit = maxLimit", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec wrapWithArrayMethod() {
            ClassName arrayBuilderRawType = this.arrayType.nestedClass("Builder");
            WildcardTypeName arrayParametricTypeT = WildcardTypeName.subtypeOf((TypeName)ParameterizedTypeName.get((ClassName)this.arrayType, (TypeName[])new TypeName[]{this.typeVarT}));
            WildcardTypeName arrayParametricTypeB = WildcardTypeName.subtypeOf((TypeName)ParameterizedTypeName.get((ClassName)this.thisRawName, (TypeName[])new TypeName[]{this.typeVarT}));
            ParameterizedTypeName parameterizedArrayBuilderType = ParameterizedTypeName.get((ClassName)arrayBuilderRawType, (TypeName[])new TypeName[]{arrayParametricTypeT, arrayParametricTypeB, this.typeVarT});
            return MethodSpec.methodBuilder((String)"wrap").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisName).addParameter((TypeName)parameterizedArrayBuilderType, "array", new Modifier[0]).addStatement("this.buffer = array.buffer()", new Object[0]).addStatement("this.offset = array.limit()", new Object[0]).addStatement("this.limit = array.limit()", new Object[0]).addStatement("this.maxLimit = array.maxLimit()", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec iterateMethod() {
            TypeVariableName typeVarE = TypeVariableName.get((String)"E");
            ClassName consumerType = ClassName.get(Consumer.class);
            ClassName iterableType = ClassName.get(Iterable.class);
            return MethodSpec.methodBuilder((String)"iterate").addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(typeVarE).returns((TypeName)this.thisName).addParameter((TypeName)ParameterizedTypeName.get((ClassName)iterableType, (TypeName[])new TypeName[]{typeVarE}), "iterable", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)consumerType, (TypeName[])new TypeName[]{typeVarE}), "action", new Modifier[0]).addStatement("iterable.forEach(action)", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec rebuildMethod() {
            return MethodSpec.methodBuilder((String)"rebuild").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.typeVarT).addParameter((TypeName)this.typeVarT, "item", new Modifier[0]).addParameter(Integer.TYPE, "maxLength", new Modifier[0]).addStatement("return item", new Object[0]).build();
        }

        private MethodSpec setMethod() {
            return MethodSpec.methodBuilder((String)"set").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisName).addParameter((TypeName)this.typeVarT, "value", new Modifier[0]).addStatement("buffer().putBytes(offset(), value.buffer(), value.offset(), value.sizeof())", new Object[0]).addStatement("limit(limit() + value.sizeof())", new Object[0]).addStatement("return this", new Object[0]).build();
        }
    }
}

