/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.generate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import javax.lang.model.element.Modifier;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstAbstractMemberNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstByteOrder;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstEnumNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstNamedNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstType;
import org.reaktivity.nukleus.maven.plugin.internal.generate.ClassSpecGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.ClassSpecMixinGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.MethodSpecGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeNames;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeResolver;

public final class StructFlyweightGenerator
extends ClassSpecGenerator {
    private static final Set<String> RESERVED_METHOD_NAMES = new HashSet<String>(Arrays.asList("offset", "buffer", "limit", "sizeof", "maxLimit", "wrap", "checkLimit", "build", "rewrap"));
    private static final ClassName INT_ITERATOR_CLASS_NAME = ClassName.get(PrimitiveIterator.OfInt.class);
    private static final ClassName LONG_ITERATOR_CLASS_NAME = ClassName.get(PrimitiveIterator.OfLong.class);
    private static final ClassName STRING_CLASS_NAME = ClassName.get(String.class);
    private static final Map<TypeName, String> GETTER_NAMES;
    private final String baseName;
    private final TypeSpec.Builder builder;
    private final TypeIdGenerator typeId;
    private final MemberFieldGenerator memberField;
    private final MemberSizeConstantGenerator memberSizeConstant;
    private final MemberOffsetConstantGenerator memberOffsetConstant;
    private final MemberAccessorGenerator memberAccessor;
    private final TryWrapMethodGenerator tryWrapMethod;
    private final WrapMethodGenerator wrapMethod;
    private final LimitMethodGenerator limitMethod;
    private final ToStringMethodGenerator toStringMethod;
    private final BuilderClassGenerator builderClass;

    public StructFlyweightGenerator(ClassName structName, ClassName flyweightName, String baseName, TypeResolver resolver) {
        super(structName);
        this.baseName = baseName;
        this.builder = TypeSpec.classBuilder((ClassName)structName).superclass((TypeName)flyweightName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        this.typeId = new TypeIdGenerator(structName, this.builder);
        this.memberSizeConstant = new MemberSizeConstantGenerator(structName, this.builder);
        this.memberOffsetConstant = new MemberOffsetConstantGenerator(structName, this.builder);
        this.memberField = new MemberFieldGenerator(structName, this.builder);
        this.memberAccessor = new MemberAccessorGenerator(structName, this.builder);
        this.tryWrapMethod = new TryWrapMethodGenerator(structName);
        this.wrapMethod = new WrapMethodGenerator(structName);
        this.limitMethod = new LimitMethodGenerator();
        this.toStringMethod = new ToStringMethodGenerator();
        this.builderClass = new BuilderClassGenerator(structName, flyweightName, resolver);
    }

    public StructFlyweightGenerator typeId(int typeId) {
        this.typeId.typeId(typeId);
        return this;
    }

    public StructFlyweightGenerator addMember(String name, AstType type, TypeName typeName, AstType unsignedType, TypeName unsignedTypeName, int size, String sizeName, TypeName sizeTypeName, boolean usedAsSize, Object defaultValue, AstByteOrder byteOrder) {
        this.memberOffsetConstant.addMember(name, typeName, unsignedTypeName, size, sizeName);
        this.memberSizeConstant.addMember(name, type, typeName, unsignedType, unsignedTypeName, size);
        this.memberField.addMember(name, typeName, unsignedTypeName, size, sizeName, byteOrder, defaultValue);
        this.memberAccessor.addMember(name, type, typeName, unsignedType, unsignedTypeName, byteOrder, size, sizeName, defaultValue);
        this.limitMethod.addMember(name, typeName, unsignedTypeName, size, sizeName);
        this.tryWrapMethod.addMember(name, type, typeName, unsignedType, unsignedTypeName, size, sizeName, defaultValue);
        this.wrapMethod.addMember(name, type, typeName, unsignedTypeName, size, sizeName, defaultValue);
        this.toStringMethod.addMember(name, typeName, unsignedTypeName, size, sizeName);
        this.builderClass.addMember(name, type, typeName, unsignedType, unsignedTypeName, size, sizeName, sizeTypeName, usedAsSize, defaultValue, byteOrder);
        return this;
    }

    @Override
    public TypeSpec generate() {
        this.typeId.build();
        this.memberOffsetConstant.build();
        this.memberSizeConstant.build();
        this.memberField.build();
        this.memberAccessor.build();
        return this.builder.addMethod(this.wrapMethod.generate()).addMethod(this.tryWrapMethod.generate()).addMethod(this.limitMethod.generate()).addMethod(this.toStringMethod.generate()).addType(this.builderClass.generate()).build();
    }

    private static boolean isOctetsType(TypeName type) {
        return type instanceof ClassName && "OctetsFW".equals(((ClassName)type).simpleName());
    }

    private static boolean isStringType(ClassName classType) {
        return StructFlyweightGenerator.isString8Type(classType) || StructFlyweightGenerator.isString16Type(classType) || StructFlyweightGenerator.isString32Type(classType);
    }

    private static boolean isString8Type(ClassName classType) {
        String name = classType.simpleName();
        return "String8FW".equals(name);
    }

    private static boolean isString16Type(ClassName classType) {
        String name = classType.simpleName();
        return "String16FW".equals(name);
    }

    private static boolean isString32Type(ClassName classType) {
        String name = classType.simpleName();
        return "String32FW".equals(name);
    }

    private static boolean isVarbyteuintType(TypeName type) {
        return type instanceof ClassName && "Varbyteuint32FW".equals(((ClassName)type).simpleName());
    }

    private static boolean isVarintType(TypeName type) {
        return type instanceof ClassName && "Varint32FW".equals(((ClassName)type).simpleName()) || type instanceof ClassName && "Varint64FW".equals(((ClassName)type).simpleName());
    }

    private static boolean isVarbyteuint32Type(TypeName type) {
        return type instanceof ClassName && "Varbyteuint32FW".equals(((ClassName)type).simpleName());
    }

    private static boolean isVarint32Type(TypeName type) {
        return type instanceof ClassName && "Varint32FW".equals(((ClassName)type).simpleName());
    }

    private static boolean isVarint64Type(TypeName type) {
        return type instanceof ClassName && "Varint64FW".equals(((ClassName)type).simpleName());
    }

    private static boolean isStringType(TypeName type) {
        return type instanceof ClassName && ("String8FW".equals(((ClassName)type).simpleName()) || "String16FW".equals(((ClassName)type).simpleName()) || "String32FW".equals(((ClassName)type).simpleName()));
    }

    private static boolean isEnumType(AstNamedNode.Kind kind) {
        return AstNamedNode.Kind.ENUM.equals((Object)kind);
    }

    private static String index(String fieldName) {
        return String.format("INDEX_%s", StructFlyweightGenerator.constant(fieldName));
    }

    private static String initCap(String value) {
        return Character.toUpperCase(value.charAt(0)) + value.substring(1);
    }

    private static String arraySize(String fieldName) {
        return String.format("ARRAY_SIZE_%s", StructFlyweightGenerator.constant(fieldName));
    }

    private static String offset(String fieldName) {
        return String.format("FIELD_OFFSET_%s", StructFlyweightGenerator.constant(fieldName));
    }

    private static String size(String fieldName) {
        return String.format("FIELD_SIZE_%s", StructFlyweightGenerator.constant(fieldName));
    }

    private static String constant(String fieldName) {
        return fieldName.replaceAll("([^_A-Z])([A-Z])", "$1_$2").toUpperCase();
    }

    private static String dynamicLimit(String fieldName) {
        return "limit" + StructFlyweightGenerator.initCap(fieldName);
    }

    private static String iterator(String fieldName) {
        return "iterator" + StructFlyweightGenerator.initCap(fieldName);
    }

    private static ClassName iteratorClass(ClassName structName, TypeName type, TypeName unsignedType) {
        TypeName generateType = unsignedType != null ? unsignedType : type;
        return generateType == TypeName.LONG ? structName.nestedClass("LongPrimitiveIterator") : structName.nestedClass("IntPrimitiveIterator");
    }

    private static String methodName(String name) {
        return RESERVED_METHOD_NAMES.contains(name) ? name + "$" : name;
    }

    static {
        HashMap<TypeName, String> getterNames = new HashMap<TypeName, String>();
        getterNames.put(TypeName.BYTE, "getByte");
        getterNames.put(TypeName.CHAR, "getChar");
        getterNames.put(TypeName.SHORT, "getShort");
        getterNames.put(TypeName.FLOAT, "getFloat");
        getterNames.put(TypeName.INT, "getInt");
        getterNames.put(TypeName.DOUBLE, "getDouble");
        getterNames.put(TypeName.LONG, "getLong");
        GETTER_NAMES = Collections.unmodifiableMap(getterNames);
    }

    private static final class BuilderClassGenerator
    extends ClassSpecGenerator {
        private final TypeSpec.Builder builder;
        private final ClassName structType;
        private final MemberConstantGenerator memberConstant;
        private final MemberFieldGenerator memberField;
        private final MemberAccessorGenerator memberAccessor;
        private final MemberMutatorGenerator memberMutator;
        private final WrapMethodGenerator wrapMethod;
        private final WrapMethodWithArrayGenerator wrapMethodWithArray;
        private final TypeResolver resolver;
        private String priorFieldIfDefaulted;
        private boolean priorDefaultedIsPrimitive;
        private boolean priorDefaultedIsEnum;
        private boolean priorDefaultedIsString;
        private Object priorDefaultValue;
        private String priorSizeName;
        private TypeName priorSizeType;

        private BuilderClassGenerator(ClassName structType, ClassName flyweightType, TypeResolver resolver) {
            this(structType.nestedClass("Builder"), flyweightType.nestedClass("Builder"), structType, resolver);
        }

        private BuilderClassGenerator(ClassName thisType, ClassName builderRawType, ClassName structType, TypeResolver resolver) {
            super(thisType);
            this.builder = TypeSpec.classBuilder((String)thisType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).superclass((TypeName)ParameterizedTypeName.get((ClassName)builderRawType, (TypeName[])new TypeName[]{structType}));
            this.structType = structType;
            this.memberConstant = new MemberConstantGenerator(thisType, resolver, this.builder);
            this.memberField = new MemberFieldGenerator(thisType, this.builder);
            this.memberAccessor = new MemberAccessorGenerator(thisType, this.builder);
            this.memberMutator = new MemberMutatorGenerator(thisType, resolver, this.builder);
            this.wrapMethod = new WrapMethodGenerator(thisType, this.builder);
            this.wrapMethodWithArray = new WrapMethodWithArrayGenerator(structType, resolver);
            this.resolver = resolver;
        }

        private void addMember(String name, AstType type, TypeName typeName, AstType unsignedType, TypeName unsignedTypeName, int size, String sizeName, TypeName sizeType, boolean usedAsSize, Object defaultValue, AstByteOrder byteOrder) {
            if (usedAsSize) {
                defaultValue = 0;
            }
            Consumer<CodeBlock.Builder> defaultPriorField = this.priorFieldIfDefaulted == null ? null : b -> this.defaultPriorField((CodeBlock.Builder)b);
            this.memberConstant.addMember(name, type, typeName, unsignedTypeName, size, sizeName, usedAsSize, defaultValue);
            this.memberField.addMember(name, typeName, unsignedTypeName, size, sizeName, usedAsSize, byteOrder);
            this.memberAccessor.addMember(name, typeName, unsignedTypeName, usedAsSize, size, sizeName, defaultValue, this.priorFieldIfDefaulted, defaultPriorField);
            this.memberMutator.addMember(name, type, typeName, unsignedType, unsignedTypeName, usedAsSize, size, sizeName, sizeType, byteOrder, defaultValue, this.priorFieldIfDefaulted, defaultPriorField);
            this.wrapMethod.addMember(name, typeName, unsignedTypeName, usedAsSize, size, sizeName, sizeType, byteOrder, defaultValue, this.priorFieldIfDefaulted, defaultPriorField);
            this.wrapMethodWithArray.addMember(name, typeName, usedAsSize, size, sizeName);
            if (defaultValue != null || BuilderClassGenerator.isImplicitlyDefaulted(typeName, size, sizeName, type, this.resolver)) {
                this.priorFieldIfDefaulted = name;
                this.priorDefaultedIsPrimitive = typeName.isPrimitive() || StructFlyweightGenerator.isVarintType(typeName) || StructFlyweightGenerator.isVarbyteuintType(typeName);
                this.priorDefaultedIsString = StructFlyweightGenerator.isStringType(typeName);
                AstNamedNode node = type != null ? this.resolver.resolve(type.name()) : null;
                this.priorDefaultedIsEnum = node != null && StructFlyweightGenerator.isEnumType(node.getKind());
                this.priorDefaultValue = defaultValue;
                this.priorSizeName = sizeName;
                this.priorSizeType = sizeType;
            } else {
                this.priorFieldIfDefaulted = null;
            }
        }

        @Override
        public TypeSpec generate() {
            this.memberConstant.build();
            this.memberField.build();
            this.memberAccessor.build();
            this.memberMutator.build();
            return this.builder.addMethod(this.constructor()).addMethod(this.wrapMethod.generate()).addMethod(this.wrapMethodWithArray.generate()).addMethod(this.rewrapMethod()).addMethod(this.buildMethod()).build();
        }

        private MethodSpec constructor() {
            return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super(new $T())", new Object[]{this.structType}).build();
        }

        private MethodSpec buildMethod() {
            MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.structType);
            if (this.priorFieldIfDefaulted != null) {
                builder.beginControlFlow("if (lastFieldSet < $L)", new Object[]{StructFlyweightGenerator.index(this.priorFieldIfDefaulted)});
                CodeBlock.Builder code = CodeBlock.builder();
                this.defaultPriorField(code);
                builder.addCode(code.build());
                builder.endControlFlow();
            }
            return builder.addStatement("assert lastFieldSet == FIELD_COUNT - 1", new Object[0]).addStatement("lastFieldSet = -1", new Object[0]).addStatement("return super.build()", new Object[0]).build();
        }

        private MethodSpec rewrapMethod() {
            return MethodSpec.methodBuilder((String)"rewrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.thisName).addStatement("super.rewrap()", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private static String appendMethodName(String fieldName) {
            return String.format("append%s", StructFlyweightGenerator.initCap(fieldName));
        }

        private static String defaultName(String fieldName) {
            return String.format("DEFAULT_%s", StructFlyweightGenerator.constant(fieldName));
        }

        private static boolean isImplicitlyDefaulted(TypeName typeName, int size, String sizeName, AstType type, TypeResolver resolver) {
            boolean isEnumType;
            boolean result = false;
            AstNamedNode node = type != null ? resolver.resolve(type.name()) : null;
            boolean bl = isEnumType = node != null && StructFlyweightGenerator.isEnumType(node.getKind());
            if (!(!(typeName instanceof ClassName) || StructFlyweightGenerator.isStringType((ClassName)typeName) || StructFlyweightGenerator.isVarintType(typeName) || StructFlyweightGenerator.isVarbyteuintType(typeName) || isEnumType)) {
                ClassName classType = (ClassName)typeName;
                result = "OctetsFW".equals(classType.simpleName()) ? size == -1 && sizeName == null : true;
            }
            if (typeName instanceof ParameterizedTypeName) {
                ParameterizedTypeName parameterizedType = (ParameterizedTypeName)typeName;
                if ("ListFW".equals(parameterizedType.rawType.simpleName()) || "Array32FW".equals(parameterizedType.rawType.simpleName())) {
                    result = true;
                }
            }
            return result;
        }

        private static String dynamicOffset(String fieldName) {
            return String.format("dynamicOffset%s", StructFlyweightGenerator.initCap(fieldName));
        }

        private static String dynamicValue(String fieldName) {
            return String.format("dynamicValue%s", StructFlyweightGenerator.initCap(fieldName));
        }

        private void defaultPriorField(CodeBlock.Builder code) {
            if (this.priorDefaultValue != null && this.priorDefaultedIsPrimitive) {
                code.addStatement("$L($L)", new Object[]{this.priorFieldIfDefaulted, BuilderClassGenerator.defaultName(this.priorFieldIfDefaulted)});
            } else if (this.priorDefaultValue == AstAbstractMemberNode.NULL_DEFAULT) {
                if (StructFlyweightGenerator.isVarintType(this.priorSizeType)) {
                    code.addStatement("$L(-1)", new Object[]{StructFlyweightGenerator.methodName(this.priorSizeName)}).addStatement("lastFieldSet = $L", new Object[]{StructFlyweightGenerator.index(this.priorFieldIfDefaulted)});
                } else if (StructFlyweightGenerator.isVarbyteuintType(this.priorSizeType)) {
                    code.addStatement("$L(0)", new Object[]{StructFlyweightGenerator.methodName(this.priorSizeName)}).addStatement("lastFieldSet = $L", new Object[]{StructFlyweightGenerator.index(this.priorFieldIfDefaulted)});
                } else if (this.priorDefaultedIsString) {
                    code.addStatement("$L((String) null)", new Object[]{this.priorFieldIfDefaulted});
                } else {
                    code.addStatement("$L(b -> { })", new Object[]{this.priorFieldIfDefaulted});
                    code.addStatement("int limit = limit()", new Object[0]);
                    code.addStatement("limit($L)", new Object[]{BuilderClassGenerator.dynamicOffset(this.priorSizeName)});
                    code.addStatement("$L(-1)", new Object[]{StructFlyweightGenerator.methodName(this.priorSizeName)});
                    code.addStatement("limit(limit)", new Object[0]);
                }
            } else if (this.priorDefaultedIsEnum) {
                code.addStatement("$L(b -> b.set($L))", new Object[]{this.priorFieldIfDefaulted, BuilderClassGenerator.defaultName(this.priorFieldIfDefaulted)});
            } else if (this.priorDefaultedIsString) {
                code.addStatement("$L($L)", new Object[]{this.priorFieldIfDefaulted, this.priorDefaultValue});
            } else {
                code.addStatement("$L(b -> { })", new Object[]{this.priorFieldIfDefaulted});
            }
        }

        private final class WrapMethodWithArrayGenerator
        extends MethodSpecGenerator {
            private final TypeName parameterizedArrayBuilderType;

            private WrapMethodWithArrayGenerator(ClassName structType, TypeResolver resolver) {
                super(MethodSpec.methodBuilder((String)"wrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(BuilderClassGenerator.this.thisName).addStatement("super.wrap(array)", new Object[0]));
                ClassName arrayClassName = resolver.resolveClass(AstType.ARRAY);
                ClassName arrayBuilderClassName = arrayClassName.nestedClass("Builder");
                ClassName flyweightBuilderClassName = resolver.flyweightName().nestedClass("Builder");
                WildcardTypeName typeParamT = WildcardTypeName.subtypeOf((TypeName)ParameterizedTypeName.get((ClassName)arrayClassName, (TypeName[])new TypeName[]{structType}));
                WildcardTypeName typeParamB = WildcardTypeName.subtypeOf((TypeName)ParameterizedTypeName.get((ClassName)flyweightBuilderClassName, (TypeName[])new TypeName[]{structType}));
                this.parameterizedArrayBuilderType = ParameterizedTypeName.get((ClassName)arrayBuilderClassName, (TypeName[])new TypeName[]{typeParamT, typeParamB, structType});
            }

            public WrapMethodWithArrayGenerator addMember(String name, TypeName type, boolean usedAsSize, int size, String sizeName) {
                if (usedAsSize && !StructFlyweightGenerator.isVarintType(type) && !StructFlyweightGenerator.isVarbyteuintType(type) || type.isPrimitive() && (size != -1 || sizeName != null)) {
                    this.builder.addStatement("$L = -1", new Object[]{BuilderClassGenerator.dynamicOffset(name)});
                }
                return this;
            }

            @Override
            public MethodSpec generate() {
                return this.builder.addParameter(this.parameterizedArrayBuilderType, "array", new Modifier[0]).addStatement("lastFieldSet = -1", new Object[0]).addStatement("return this", new Object[0]).build();
            }
        }

        private final class WrapMethodGenerator
        extends MethodSpecGenerator {
            private WrapMethodGenerator(ClassName thisType, TypeSpec.Builder builder) {
                super(MethodSpec.methodBuilder((String)"wrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.MUTABLE_DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(BuilderClassGenerator.this.thisName).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]));
            }

            public WrapMethodGenerator addMember(String name, TypeName type, TypeName unsignedType, boolean usedAsSize, int size, String sizeName, TypeName sizeType, AstByteOrder byteOrder, Object defaultValue, String priorFieldIfDefaulted, Consumer<CodeBlock.Builder> defaultPriorField) {
                if (usedAsSize && !StructFlyweightGenerator.isVarintType(type) && !StructFlyweightGenerator.isVarbyteuintType(type) || type.isPrimitive() && (size != -1 || sizeName != null)) {
                    this.builder.addStatement("$L = -1", new Object[]{BuilderClassGenerator.dynamicOffset(name)});
                }
                return this;
            }

            @Override
            public MethodSpec generate() {
                return this.builder.addStatement("lastFieldSet = -1", new Object[0]).addStatement("limit(offset)", new Object[0]).addStatement("return this", new Object[0]).build();
            }
        }

        private static final class MemberMutatorGenerator
        extends ClassSpecMixinGenerator {
            private static final Map<TypeName, String> PUTTER_NAMES;
            private static final Map<TypeName, String[]> UNSIGNED_INT_RANGES;
            private final TypeResolver resolver;
            private String priorRequiredField = null;
            private boolean priorFieldIsAutomaticallySet;

            private MemberMutatorGenerator(ClassName thisType, TypeResolver resolver, TypeSpec.Builder builder) {
                super(thisType, builder);
                this.resolver = resolver;
            }

            public MemberMutatorGenerator addMember(String name, AstType type, TypeName typeName, AstType unsignedType, TypeName unsignedTypeName, boolean usedAsSize, int size, String sizeName, TypeName sizeTypeName, AstByteOrder byteOrder, Object defaultValue, String priorFieldIfDefaulted, Consumer<CodeBlock.Builder> defaultPriorField) {
                boolean automaticallySet;
                boolean bl = automaticallySet = usedAsSize && !StructFlyweightGenerator.isVarintType(typeName) && !StructFlyweightGenerator.isVarbyteuintType(typeName);
                if (typeName.isPrimitive()) {
                    if (sizeName != null) {
                        this.addIntegerVariableArrayIteratorMutator(name, typeName, unsignedTypeName, sizeName, sizeTypeName, defaultValue, priorFieldIfDefaulted, defaultPriorField);
                        this.addIntegerVariableArrayAppendMutator(name, type, typeName, unsignedTypeName, byteOrder, sizeName, sizeTypeName, priorFieldIfDefaulted, defaultPriorField);
                    } else if (size != -1) {
                        this.addIntegerFixedArrayIteratorMutator(name, typeName, unsignedTypeName, size, priorFieldIfDefaulted, defaultPriorField);
                        this.addIntegerFixedArrayAppendMutator(name, type, typeName, unsignedTypeName, byteOrder, size, priorFieldIfDefaulted, defaultPriorField);
                    } else {
                        this.addPrimitiveMember(name, type, typeName, unsignedType, unsignedTypeName, usedAsSize, byteOrder, priorFieldIfDefaulted, defaultPriorField);
                    }
                } else {
                    this.addNonPrimitiveMember(name, typeName, usedAsSize, size, sizeName, sizeTypeName, defaultValue, priorFieldIfDefaulted, defaultPriorField);
                }
                this.priorFieldIsAutomaticallySet = automaticallySet;
                if (defaultValue == null && !BuilderClassGenerator.isImplicitlyDefaulted(typeName, size, sizeName, type, this.resolver) && !automaticallySet) {
                    this.priorRequiredField = name;
                }
                return this;
            }

            private void addPrimitiveMember(String name, AstType type, TypeName typeName, AstType unsignedType, TypeName unsignedTypeName, boolean usedAsSize, AstByteOrder byteOrder, String priorFieldIfDefaulted, Consumer<CodeBlock.Builder> defaultPriorField) {
                boolean automaticallySet = usedAsSize && !StructFlyweightGenerator.isVarintType(typeName) && !StructFlyweightGenerator.isVarbyteuintType(typeName);
                String putterName = PUTTER_NAMES.get(typeName);
                if (putterName == null) {
                    throw new IllegalStateException("member type not supported: " + typeName);
                }
                TypeName generateTypeName = unsignedTypeName != null ? unsignedTypeName : typeName;
                CodeBlock.Builder code = CodeBlock.builder();
                if (unsignedTypeName != null) {
                    this.generateUnsignedIntRangeCheck(name, typeName, code);
                }
                if (priorFieldIfDefaulted != null) {
                    this.generateDefaultPriorField(priorFieldIfDefaulted, defaultPriorField, code);
                }
                if (!automaticallySet) {
                    code.addStatement("assert lastFieldSet == $L - 1", new Object[]{StructFlyweightGenerator.index(name)});
                }
                code.addStatement("int newLimit = limit() + $L", new Object[]{StructFlyweightGenerator.size(name)}).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]);
                if (type.bits() == 24) {
                    if (byteOrder == AstByteOrder.NETWORK) {
                        code.addStatement("buffer().putByte(limit(), (byte) (value >> 16))", new Object[0]);
                        code.addStatement("buffer().putByte(limit() + 1, (byte) (value >> 8))", new Object[0]);
                        code.addStatement("buffer().putByte(limit() + 2, (byte) value)", new Object[0]);
                    } else {
                        code.beginControlFlow("if ($T.NATIVE_BYTE_ORDER == $T.BIG_ENDIAN)", new Object[]{TypeNames.BUFFER_UTIL_TYPE, ByteOrder.class});
                        code.addStatement("buffer().putByte(limit(), (byte) (value >> 16))", new Object[0]);
                        code.addStatement("buffer().putByte(limit() + 1, (byte) (value >> 8))", new Object[0]);
                        code.addStatement("buffer().putByte(limit() + 2, (byte) value)", new Object[0]);
                        code.nextControlFlow("else", new Object[0]);
                        code.addStatement("buffer().putByte(limit(), (byte) value)", new Object[0]);
                        code.addStatement("buffer().putByte(limit() + 1, (byte) (value >> 8))", new Object[0]);
                        code.addStatement("buffer().putByte(limit() + 2, (byte) (value >> 16))", new Object[0]);
                        code.endControlFlow();
                    }
                } else {
                    code.add("$[", new Object[0]).add("buffer().$L(limit(), ", new Object[]{putterName});
                    if (generateTypeName != typeName) {
                        code.add("($T)", new Object[]{typeName});
                        switch (type.bits()) {
                            case 8: {
                                code.add("(value & 0xFF)", new Object[0]);
                                break;
                            }
                            case 16: {
                                code.add("(value & 0xFFFF)", new Object[0]);
                                break;
                            }
                            case 24: {
                                code.add("(value & 0x00FF_FFFF)", new Object[0]);
                                break;
                            }
                            case 32: {
                                code.add("(value & 0xFFFF_FFFFL)", new Object[0]);
                                break;
                            }
                            default: {
                                code.add("value", new Object[0]);
                                break;
                            }
                        }
                    } else {
                        code.add("value", new Object[0]);
                    }
                    if (byteOrder == AstByteOrder.NETWORK && (typeName == TypeName.SHORT || typeName == TypeName.INT || typeName == TypeName.LONG)) {
                        code.add(", $T.BIG_ENDIAN", new Object[]{ByteOrder.class});
                    }
                    code.add(");\n$]", new Object[0]);
                }
                if (usedAsSize) {
                    code.addStatement("$L = limit()", new Object[]{BuilderClassGenerator.dynamicOffset(name)});
                }
                if (!automaticallySet) {
                    code.addStatement("lastFieldSet = $L", new Object[]{StructFlyweightGenerator.index(name)});
                }
                code.addStatement("limit(newLimit)", new Object[0]).addStatement("return this", new Object[0]);
                this.builder.addMethod(MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{usedAsSize ? Modifier.PRIVATE : Modifier.PUBLIC}).addParameter(generateTypeName, "value", new Modifier[0]).returns((TypeName)this.thisType).addCode(code.build()).build());
            }

            private void addIntegerFixedArrayIteratorMutator(String name, TypeName type, TypeName unsignedType, int size, String priorFieldIfDefaulted, Consumer<CodeBlock.Builder> defaultPriorField) {
                ClassName iteratorType;
                CodeBlock.Builder code = CodeBlock.builder();
                if (this.priorRequiredField != null) {
                    code.addStatement("assert lastFieldSet >= $L", new Object[]{StructFlyweightGenerator.index(this.priorRequiredField)});
                }
                TypeName inputType = unsignedType != null ? unsignedType : type;
                TypeName valueType = inputType == TypeName.LONG ? TypeName.LONG : TypeName.INT;
                ClassName className = iteratorType = inputType == TypeName.LONG ? LONG_ITERATOR_CLASS_NAME : INT_ITERATOR_CLASS_NAME;
                if (defaultPriorField != null) {
                    this.generateDefaultPriorField(priorFieldIfDefaulted, defaultPriorField, code);
                }
                code.beginControlFlow("if (values == null)", new Object[0]);
                code.addStatement("throw new $T($S)", new Object[]{IllegalArgumentException.class, String.format("fixed size array %s cannot be set to null", name)});
                code.endControlFlow();
                code.addStatement("int count = 0", new Object[0]);
                code.beginControlFlow("while (values.hasNext())", new Object[0]);
                code.addStatement("$T value = values.next$L()", new Object[]{valueType, valueType == TypeName.LONG ? "Long" : "Int"});
                code.add("$[", new Object[0]);
                code.add("$L(", new Object[]{BuilderClassGenerator.appendMethodName(name)});
                if (valueType != type) {
                    code.add("($T)", new Object[]{inputType});
                    if (unsignedType != null) {
                        if (type == TypeName.BYTE) {
                            code.add("(value & 0xFF))", new Object[0]);
                        } else if (type == TypeName.SHORT) {
                            code.add("(value & 0xFFFF))", new Object[0]);
                        } else if (type == TypeName.INT) {
                            code.add("(value & 0xFFFF_FFFFL))", new Object[0]);
                        }
                    } else {
                        code.add("value)", new Object[0]);
                    }
                } else {
                    code.add("value)", new Object[0]);
                }
                code.add(";\n$]", new Object[0]);
                code.addStatement("count++", new Object[0]);
                code.endControlFlow();
                code.beginControlFlow("if (count < $L)", new Object[]{StructFlyweightGenerator.arraySize(name)});
                code.addStatement("throw new $T($S)", new Object[]{IllegalArgumentException.class, String.format("Not enough values for %s", name)});
                code.endControlFlow();
                code.addStatement("return this", new Object[0]);
                this.builder.addMethod(MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)iteratorType, "values", new Modifier[0]).returns((TypeName)this.thisType).addCode(code.build()).build());
            }

            private void addIntegerFixedArrayAppendMutator(String name, AstType type, TypeName typeName, TypeName unsignedTypeName, AstByteOrder byteOrder, int size, String priorFieldIfDefaulted, Consumer<CodeBlock.Builder> defaultPriorField) {
                TypeName inputType;
                String putterName = PUTTER_NAMES.get(typeName);
                if (putterName == null) {
                    throw new IllegalStateException("member type not supported: " + typeName);
                }
                CodeBlock.Builder code = CodeBlock.builder();
                if (this.priorRequiredField != null) {
                    code.addStatement("assert lastFieldSet >= $L", new Object[]{StructFlyweightGenerator.index(this.priorRequiredField)});
                }
                if (unsignedTypeName != null) {
                    this.generateUnsignedIntRangeCheck(name, typeName, code);
                }
                code.beginControlFlow("if ($L == -1)", new Object[]{BuilderClassGenerator.dynamicOffset(name)});
                if (defaultPriorField != null) {
                    this.generateDefaultPriorField(priorFieldIfDefaulted, defaultPriorField, code);
                }
                code.addStatement("assert lastFieldSet == $L - 1", new Object[]{StructFlyweightGenerator.index(name)}).addStatement("$L = limit()", new Object[]{BuilderClassGenerator.dynamicOffset(name)}).endControlFlow();
                code.addStatement("int newLimit = limit() + $L", new Object[]{StructFlyweightGenerator.size(name)}).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("int newSize = (newLimit - $L) / $L", new Object[]{BuilderClassGenerator.dynamicOffset(name), StructFlyweightGenerator.size(name)}).beginControlFlow("if (newSize == $L)", new Object[]{StructFlyweightGenerator.arraySize(name)}).addStatement("lastFieldSet = $L", new Object[]{StructFlyweightGenerator.index(name)}).endControlFlow();
                TypeName typeName2 = inputType = unsignedTypeName != null ? unsignedTypeName : typeName;
                if (type.bits() == 24) {
                    if (byteOrder == AstByteOrder.NETWORK) {
                        code.addStatement("buffer().putByte(limit(), (byte) (value >> 16))", new Object[0]);
                        code.addStatement("buffer().putByte(limit() + 1, (byte) (value >> 8))", new Object[0]);
                        code.addStatement("buffer().putByte(limit() + 2, (byte) value)", new Object[0]);
                    } else {
                        code.beginControlFlow("if ($T.NATIVE_BYTE_ORDER == $T.BIG_ENDIAN)", new Object[]{TypeNames.BUFFER_UTIL_TYPE, ByteOrder.class});
                        code.addStatement("buffer().putByte(limit(), (byte) (value >> 16))", new Object[0]);
                        code.addStatement("buffer().putByte(limit() + 1, (byte) (value >> 8))", new Object[0]);
                        code.addStatement("buffer().putByte(limit() + 2, (byte) value)", new Object[0]);
                        code.nextControlFlow("else", new Object[0]);
                        code.addStatement("buffer().putByte(limit(), (byte) value)", new Object[0]);
                        code.addStatement("buffer().putByte(limit() + 1, (byte) (value >> 8))", new Object[0]);
                        code.addStatement("buffer().putByte(limit() + 2, (byte) (value >> 16))", new Object[0]);
                        code.endControlFlow();
                    }
                } else {
                    code.add("$[", new Object[0]).add("buffer().$L(limit(), ", new Object[]{putterName});
                    if (inputType != typeName) {
                        code.add("($T)", new Object[]{typeName});
                        if (unsignedTypeName != null) {
                            if (typeName == TypeName.BYTE) {
                                code.add("(value & 0xFF)", new Object[0]);
                            } else if (typeName == TypeName.SHORT) {
                                code.add("(value & 0xFFFF)", new Object[0]);
                            } else if (typeName == TypeName.INT) {
                                code.add("(value & 0xFFFF_FFFFL)", new Object[]{ByteOrder.class});
                            } else {
                                code.add("value", new Object[0]);
                            }
                        } else {
                            code.add("value", new Object[0]);
                        }
                    } else {
                        code.add("value", new Object[0]);
                    }
                    if (byteOrder == AstByteOrder.NETWORK) {
                        code.add(", $T.BIG_ENDIAN", new Object[]{ByteOrder.class});
                    }
                    code.add(");\n$]", new Object[0]);
                }
                code.addStatement("limit(newLimit)", new Object[0]).addStatement("return this", new Object[0]);
                this.builder.addMethod(MethodSpec.methodBuilder((String)BuilderClassGenerator.appendMethodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(inputType, "value", new Modifier[0]).returns((TypeName)this.thisType).addCode(code.build()).build());
            }

            private void addIntegerVariableArrayIteratorMutator(String name, TypeName type, TypeName unsignedType, String sizeName, TypeName sizeType, Object defaultValue, String priorFieldIfDefaulted, Consumer<CodeBlock.Builder> defaultPriorField) {
                ClassName iteratorType;
                CodeBlock.Builder code = CodeBlock.builder();
                if (this.priorRequiredField != null) {
                    code.addStatement("assert lastFieldSet >= $L", new Object[]{StructFlyweightGenerator.index(this.priorRequiredField)});
                }
                code.addStatement("assert lastFieldSet <= $L", new Object[]{StructFlyweightGenerator.index(name)});
                TypeName inputType = unsignedType != null ? unsignedType : type;
                TypeName valueType = inputType == TypeName.LONG ? TypeName.LONG : TypeName.INT;
                ClassName className = iteratorType = inputType == TypeName.LONG ? LONG_ITERATOR_CLASS_NAME : INT_ITERATOR_CLASS_NAME;
                if (defaultPriorField != null) {
                    this.generateDefaultPriorField(priorFieldIfDefaulted, defaultPriorField, code);
                }
                if (defaultValue != null) {
                    code.beginControlFlow("if (values == null || !values.hasNext())", new Object[0]);
                    code.addStatement("int limit = limit()", new Object[0]);
                    code.addStatement("limit($L)", new Object[]{BuilderClassGenerator.dynamicOffset(sizeName)});
                    code.add("$[", new Object[0]);
                    code.add("$L(values == null ? ", new Object[]{StructFlyweightGenerator.methodName(sizeName)});
                    if (sizeType == TypeName.BYTE || sizeType == TypeName.SHORT) {
                        code.add("($T) ", new Object[]{sizeType});
                    }
                    code.add("-1 : 0)", new Object[0]);
                    code.add(";\n$]", new Object[0]);
                } else {
                    code.beginControlFlow("if (values == null)", new Object[0]);
                    code.addStatement("throw new $T($S + $S)", new Object[]{IllegalArgumentException.class, name, " does not default to null so cannot be set to null"});
                    code.endControlFlow();
                    code.beginControlFlow("if (!values.hasNext())", new Object[0]);
                    code.addStatement("int limit = limit()", new Object[0]);
                    code.addStatement("limit($L)", new Object[]{BuilderClassGenerator.dynamicOffset(sizeName)});
                    code.addStatement("$L(0)", new Object[]{StructFlyweightGenerator.methodName(sizeName)});
                }
                code.addStatement("limit(limit)", new Object[0]);
                code.addStatement("assert lastFieldSet == $L - 1", new Object[]{StructFlyweightGenerator.index(name)});
                code.addStatement("lastFieldSet = $L", new Object[]{StructFlyweightGenerator.index(name)});
                code.nextControlFlow("else", new Object[0]);
                code.beginControlFlow("while (values.hasNext())", new Object[0]);
                code.addStatement("$T value = values.next$L()", new Object[]{valueType, valueType == TypeName.LONG ? "Long" : "Int"});
                code.add("$[", new Object[0]);
                code.add("$L(", new Object[]{BuilderClassGenerator.appendMethodName(name)});
                if (valueType != type) {
                    code.add("($T)", new Object[]{inputType});
                    if (unsignedType != null) {
                        if (type == TypeName.BYTE) {
                            code.add("(value & 0xFF))", new Object[0]);
                        } else if (type == TypeName.SHORT) {
                            code.add("(value & 0xFFFF))", new Object[0]);
                        } else if (type == TypeName.INT) {
                            code.add("(value & 0xFFFF_FFFFL))", new Object[0]);
                        }
                    } else {
                        code.add("value)", new Object[0]);
                    }
                } else {
                    code.add("value)", new Object[0]);
                }
                code.add(";\n$]", new Object[0]);
                code.endControlFlow();
                code.endControlFlow();
                code.addStatement("return this", new Object[0]);
                this.builder.addMethod(MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)iteratorType, "values", new Modifier[0]).returns((TypeName)this.thisType).addCode(code.build()).build());
            }

            private void addIntegerVariableArrayAppendMutator(String name, AstType type, TypeName typeName, TypeName unsignedTypeName, AstByteOrder byteOrder, String sizeName, TypeName sizeType, String priorFieldIfDefaulted, Consumer<CodeBlock.Builder> defaultPriorField) {
                TypeName inputType;
                String putterName = PUTTER_NAMES.get(typeName);
                if (putterName == null) {
                    throw new IllegalStateException("member type not supported: " + typeName);
                }
                CodeBlock.Builder code = CodeBlock.builder();
                if (this.priorRequiredField != null) {
                    code.addStatement("assert lastFieldSet >= $L", new Object[]{StructFlyweightGenerator.index(this.priorRequiredField)});
                }
                code.addStatement("assert lastFieldSet <= $L", new Object[]{StructFlyweightGenerator.index(name)});
                if (unsignedTypeName != null) {
                    this.generateUnsignedIntRangeCheck(name, typeName, code);
                }
                code.beginControlFlow("if (lastFieldSet < $L)", new Object[]{StructFlyweightGenerator.index(name)});
                if (defaultPriorField != null) {
                    this.generateDefaultPriorField(priorFieldIfDefaulted, defaultPriorField, code);
                }
                code.addStatement("assert lastFieldSet == $L - 1", new Object[]{StructFlyweightGenerator.index(name)}).addStatement("$L = limit()", new Object[]{BuilderClassGenerator.dynamicOffset(name)}).addStatement("lastFieldSet = $L", new Object[]{StructFlyweightGenerator.index(name)}).endControlFlow();
                code.addStatement("int newLimit = limit() + $L", new Object[]{StructFlyweightGenerator.size(name)}).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]);
                TypeName typeName2 = inputType = unsignedTypeName != null ? unsignedTypeName : typeName;
                if (type.bits() == 24) {
                    if (byteOrder == AstByteOrder.NETWORK) {
                        code.addStatement("buffer().putByte(limit(), (byte) (value >> 16))", new Object[0]);
                        code.addStatement("buffer().putByte(limit() + 1, (byte) (value >> 8))", new Object[0]);
                        code.addStatement("buffer().putByte(limit() + 2, (byte) value)", new Object[0]);
                    } else {
                        code.beginControlFlow("if ($T.NATIVE_BYTE_ORDER == $T.BIG_ENDIAN)", new Object[]{TypeNames.BUFFER_UTIL_TYPE, ByteOrder.class});
                        code.addStatement("buffer().putByte(limit(), (byte) (value >> 16))", new Object[0]);
                        code.addStatement("buffer().putByte(limit() + 1, (byte) (value >> 8))", new Object[0]);
                        code.addStatement("buffer().putByte(limit() + 2, (byte) value)", new Object[0]);
                        code.nextControlFlow("else", new Object[0]);
                        code.addStatement("buffer().putByte(limit(), (byte) value)", new Object[0]);
                        code.addStatement("buffer().putByte(limit() + 1, (byte) (value >> 8))", new Object[0]);
                        code.addStatement("buffer().putByte(limit() + 2, (byte) (value >> 16))", new Object[0]);
                        code.endControlFlow();
                    }
                } else {
                    code.add("$[", new Object[0]).add("buffer().$L(limit(), ", new Object[]{putterName});
                    if (inputType != typeName) {
                        code.add("($T)", new Object[]{typeName});
                        if (typeName == TypeName.BYTE) {
                            code.add("(value & 0xFF)", new Object[0]);
                        } else if (typeName == TypeName.SHORT) {
                            code.add("(value & 0xFFFF)", new Object[0]);
                        } else if (typeName == TypeName.INT) {
                            code.add("(value & 0xFFFF_FFFFL)", new Object[0]);
                        } else {
                            code.add("value", new Object[0]);
                        }
                    } else {
                        code.add("value", new Object[0]);
                    }
                    if (byteOrder == AstByteOrder.NETWORK) {
                        code.add(", $T.BIG_ENDIAN", new Object[]{ByteOrder.class});
                    }
                    code.add(");\n$]", new Object[0]);
                }
                code.addStatement("lastFieldSet = $L", new Object[]{StructFlyweightGenerator.index(name)}).addStatement("limit($L)", new Object[]{BuilderClassGenerator.dynamicOffset(sizeName)}).addStatement("int newSize = (newLimit - $L) / $L", new Object[]{BuilderClassGenerator.dynamicOffset(name), StructFlyweightGenerator.size(name)});
                code.add("$[", new Object[0]);
                code.add("$L(", new Object[]{StructFlyweightGenerator.methodName(sizeName)});
                if (sizeType == TypeName.BYTE || sizeType == TypeName.SHORT) {
                    code.add("($T) ", new Object[]{sizeType});
                }
                code.add("newSize)", new Object[0]);
                code.add(";\n$]", new Object[0]);
                code.addStatement("limit(newLimit)", new Object[0]).addStatement("return this", new Object[0]);
                this.builder.addMethod(MethodSpec.methodBuilder((String)BuilderClassGenerator.appendMethodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(inputType, "value", new Modifier[0]).returns((TypeName)this.thisType).addCode(code.build()).build());
            }

            private void generateUnsignedIntRangeCheck(String name, TypeName typeName, CodeBlock.Builder code) {
                String[] range = UNSIGNED_INT_RANGES.get(typeName);
                code.beginControlFlow("if (value < $L)", new Object[]{range[0]}).addStatement("throw new IllegalArgumentException(String.format($S, value))", new Object[]{String.format("Value %%d too low for field \"%s\"", name)}).endControlFlow();
                if (range[1] != null) {
                    code.beginControlFlow("if (value > $L)", new Object[]{range[1]}).addStatement("throw new IllegalArgumentException(String.format($S, value))", new Object[]{String.format("Value %%d too high for field \"%s\"", name)}).endControlFlow();
                }
            }

            private void generateDefaultPriorField(String priorFieldIfDefaulted, Consumer<CodeBlock.Builder> defaultPriorField, CodeBlock.Builder code) {
                if (this.priorFieldIsAutomaticallySet) {
                    code.beginControlFlow("if ($L == -1)", new Object[]{BuilderClassGenerator.dynamicOffset(priorFieldIfDefaulted)});
                } else {
                    code.beginControlFlow("if (lastFieldSet < $L)", new Object[]{StructFlyweightGenerator.index(priorFieldIfDefaulted)});
                }
                defaultPriorField.accept(code);
                code.endControlFlow();
            }

            private void addNonPrimitiveMember(String name, TypeName type, boolean usedAsSize, int size, String sizeName, TypeName sizeType, Object defaultValue, String priorDefaulted, Consumer<CodeBlock.Builder> defaultPriorField) {
                if (type instanceof ClassName) {
                    ClassName className = (ClassName)type;
                    this.addClassType(name, className, usedAsSize, size, sizeName, sizeType, defaultValue, priorDefaulted, defaultPriorField);
                } else if (type instanceof ParameterizedTypeName) {
                    ParameterizedTypeName parameterizedType = (ParameterizedTypeName)type;
                    this.addParameterizedType(name, parameterizedType, priorDefaulted, defaultPriorField);
                } else {
                    this.builder.addMethod(MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter(type, "value", new Modifier[0]).addStatement("$LRW.set(value)", new Object[]{name}).addStatement("return this", new Object[0]).build());
                }
            }

            private void addClassType(String name, ClassName className, boolean usedAsSize, int size, String sizeName, TypeName sizeType, Object defaultValue, String priorFieldIfDefaulted, Consumer<CodeBlock.Builder> defaultPriorField) {
                if (StructFlyweightGenerator.isStringType(className)) {
                    this.addStringType(className, name);
                } else if (TypeNames.DIRECT_BUFFER_TYPE.equals((Object)className)) {
                    this.addDirectBufferType(name);
                } else if ("OctetsFW".equals(className.simpleName())) {
                    this.addOctetsType(className, name, size, sizeName, sizeType, defaultValue);
                } else {
                    ClassName consumerType = ClassName.get(Consumer.class);
                    ClassName builderType = className.nestedClass("Builder");
                    TypeName parameterType = StructFlyweightGenerator.isVarint32Type((TypeName)className) ? TypeName.INT : (StructFlyweightGenerator.isVarint64Type((TypeName)className) ? TypeName.LONG : (StructFlyweightGenerator.isVarbyteuint32Type((TypeName)className) ? TypeName.INT : ParameterizedTypeName.get((ClassName)consumerType, (TypeName[])new TypeName[]{builderType})));
                    String parameterName = StructFlyweightGenerator.isVarintType((TypeName)className) || StructFlyweightGenerator.isVarbyteuintType((TypeName)className) ? "value" : "mutator";
                    CodeBlock.Builder code = CodeBlock.builder();
                    if (priorFieldIfDefaulted != null) {
                        code.beginControlFlow("if (lastFieldSet < $L)", new Object[]{StructFlyweightGenerator.index(priorFieldIfDefaulted)});
                        defaultPriorField.accept(code);
                        code.endControlFlow();
                    }
                    code.addStatement("assert lastFieldSet == $L - 1", new Object[]{StructFlyweightGenerator.index(name)}).addStatement("$T $LRW = this.$LRW.wrap(buffer(), limit(), maxLimit())", new Object[]{builderType, name, name});
                    if (StructFlyweightGenerator.isVarintType((TypeName)className) || StructFlyweightGenerator.isVarbyteuintType((TypeName)className)) {
                        code.addStatement("$LRW.set($L)", new Object[]{name, parameterName});
                        if (usedAsSize) {
                            code.addStatement("$L = $L", new Object[]{BuilderClassGenerator.dynamicValue(name), parameterName});
                        }
                    } else {
                        code.addStatement("$L.accept($LRW)", new Object[]{parameterName, name});
                    }
                    code.addStatement("limit($LRW.build().limit())", new Object[]{name}).addStatement("lastFieldSet = $L", new Object[]{StructFlyweightGenerator.index(name)}).addStatement("return this", new Object[0]);
                    this.builder.addMethod(MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter(parameterType, parameterName, new Modifier[0]).addCode(code.build()).build());
                    code = CodeBlock.builder();
                    if (priorFieldIfDefaulted != null) {
                        code.beginControlFlow("if (lastFieldSet < $L)", new Object[]{StructFlyweightGenerator.index(priorFieldIfDefaulted)});
                        defaultPriorField.accept(code);
                        code.endControlFlow();
                    }
                    code.addStatement("assert lastFieldSet == $L - 1", new Object[]{StructFlyweightGenerator.index(name)}).addStatement("int newLimit = limit() + field.sizeof()", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("buffer().putBytes(limit(), field.buffer(), field.offset(), field.sizeof())", new Object[0]).addStatement("limit(newLimit)", new Object[0]).addStatement("lastFieldSet = $L", new Object[]{StructFlyweightGenerator.index(name)}).addStatement("return this", new Object[0]);
                    this.builder.addMethod(MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter((TypeName)className, "field", new Modifier[0]).addCode(code.build()).build());
                }
            }

            private void addOctetsType(ClassName className, String name, int size, String sizeName, TypeName sizeType, Object defaultValue) {
                this.addOctetsOctetsFWMutator(className, name, size, sizeName, sizeType, defaultValue);
                this.addOctetsConsumerBuilderMutator(className, name, size, sizeName, sizeType);
                this.addOctetsBufferMutator(className, name, size, sizeName, sizeType);
            }

            private void addOctetsOctetsFWMutator(ClassName className, String name, int size, String sizeName, TypeName sizeType, Object defaultValue) {
                ClassName builderType = className.nestedClass("Builder");
                CodeBlock.Builder code = CodeBlock.builder();
                if (size >= 0) {
                    code.addStatement("$T $LRW = $L()", new Object[]{builderType, name, StructFlyweightGenerator.methodName(name)}).addStatement("$LRW.set(value)", new Object[]{name}).addStatement("int expectedLimit = $LRW.maxLimit()", new Object[]{name}).addStatement("int actualLimit = $LRW.build().limit()", new Object[]{name}).beginControlFlow("if (actualLimit != expectedLimit)", new Object[0]).addStatement("throw new IllegalStateException(String.format($S, actualLimit - limit(), expectedLimit - limit()))", new Object[]{String.format("%%d instead of %%d bytes have been set for field \"%s\"", name)}).endControlFlow().addStatement("limit($LRW.maxLimit())", new Object[]{name});
                } else if (sizeName != null) {
                    code.addStatement("int size$$", new Object[0]).addStatement("int newLimit", new Object[0]).addStatement("$T $LRW = $L()", new Object[]{builderType, name, StructFlyweightGenerator.methodName(name)});
                    if (StructFlyweightGenerator.isVarbyteuintType(sizeType)) {
                        code.beginControlFlow("if (value == null)", new Object[0]).addStatement("size$$ = 0", new Object[0]).addStatement("newLimit = limit()", new Object[0]).nextControlFlow("else", new Object[0]).addStatement("$LRW.set(value)", new Object[]{name}).addStatement("newLimit = $LRW.build().limit()", new Object[]{name}).addStatement("size$$ = newLimit - limit()", new Object[0]).endControlFlow();
                    } else if (defaultValue == AstAbstractMemberNode.NULL_DEFAULT) {
                        code.beginControlFlow("if (value == null)", new Object[0]).addStatement("size$$ = -1", new Object[0]).addStatement("newLimit = limit()", new Object[0]).nextControlFlow("else", new Object[0]).addStatement("$LRW.set(value)", new Object[]{name}).addStatement("newLimit = $LRW.build().limit()", new Object[]{name}).addStatement("size$$ = newLimit - limit()", new Object[0]).endControlFlow();
                    } else {
                        code.beginControlFlow("if (value == null)", new Object[0]).addStatement("throw new IllegalArgumentException($S)", new Object[]{String.format("value cannot be null for field \"%s\" that does not default to null", name)}).endControlFlow().addStatement("$LRW.set(value)", new Object[]{name}).addStatement("newLimit = $LRW.build().limit()", new Object[]{name}).addStatement("size$$ = newLimit - limit()", new Object[0]);
                    }
                    if (StructFlyweightGenerator.isVarintType(sizeType) || StructFlyweightGenerator.isVarbyteuintType(sizeType)) {
                        code.beginControlFlow("if (size$$ != $L)", new Object[]{BuilderClassGenerator.dynamicValue(sizeName)}).addStatement("throw new IllegalStateException(String.format($S, size$$, $L, $S))", new Object[]{String.format("%%d bytes have been set for field \"%s\", does not match value %%d set in %%s", name), BuilderClassGenerator.dynamicValue(sizeName), sizeName}).endControlFlow();
                    } else {
                        code.addStatement("limit($L)", new Object[]{BuilderClassGenerator.dynamicOffset(sizeName)}).addStatement("$L(size$$)", new Object[]{sizeName});
                    }
                    code.addStatement("limit(newLimit)", new Object[0]);
                } else {
                    code.addStatement("$T $LRW = $L()", new Object[]{builderType, name, StructFlyweightGenerator.methodName(name)}).addStatement("$LRW.set(value)", new Object[]{name}).addStatement("limit($LRW.build().limit())", new Object[]{name});
                }
                code.addStatement("lastFieldSet = $L", new Object[]{StructFlyweightGenerator.index(name)}).addStatement("return this", new Object[0]);
                this.builder.addMethod(MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter((TypeName)className, "value", new Modifier[0]).addCode(code.build()).build());
            }

            private void addOctetsConsumerBuilderMutator(ClassName className, String name, int size, String sizeName, TypeName sizeType) {
                ClassName builderType = className.nestedClass("Builder");
                ClassName consumerType = ClassName.get(Consumer.class);
                ParameterizedTypeName mutatorType = ParameterizedTypeName.get((ClassName)consumerType, (TypeName[])new TypeName[]{builderType});
                CodeBlock.Builder code = CodeBlock.builder();
                code.addStatement("$T $LRW = $L()", new Object[]{builderType, name, StructFlyweightGenerator.methodName(name)}).addStatement("mutator.accept($LRW)", new Object[]{name});
                if (size >= 0) {
                    code.addStatement("int expectedLimit = $LRW.maxLimit()", new Object[]{name}).addStatement("int actualLimit = $LRW.build().limit()", new Object[]{name}).beginControlFlow("if (actualLimit != expectedLimit)", new Object[0]).addStatement("throw new IllegalStateException(String.format($S, actualLimit - limit(), expectedLimit - limit()))", new Object[]{String.format("%%d instead of %%d bytes have been set for field \"%s\"", name)}).endControlFlow();
                    code.addStatement("limit($LRW.maxLimit())", new Object[]{name});
                } else if (sizeName != null) {
                    code.addStatement("int newLimit = $LRW.build().limit()", new Object[]{name}).addStatement("int size$$ = newLimit - limit()", new Object[0]);
                    if (StructFlyweightGenerator.isVarintType(sizeType) || StructFlyweightGenerator.isVarbyteuintType(sizeType)) {
                        code.beginControlFlow("if (size$$ != $L)", new Object[]{BuilderClassGenerator.dynamicValue(sizeName)}).addStatement("throw new IllegalStateException(String.format($S, size$$, $L, $S))", new Object[]{String.format("%%d bytes have been set for field \"%s\", does not match value %%d set in %%s", name), BuilderClassGenerator.dynamicValue(sizeName), sizeName}).endControlFlow();
                    } else {
                        code.addStatement("limit($L)", new Object[]{BuilderClassGenerator.dynamicOffset(sizeName)}).addStatement("$L(size$$)", new Object[]{sizeName});
                    }
                    code.addStatement("limit(newLimit)", new Object[0]);
                } else {
                    code.addStatement("limit($LRW.build().limit())", new Object[]{name});
                }
                code.addStatement("lastFieldSet = $L", new Object[]{StructFlyweightGenerator.index(name)}).addStatement("return this", new Object[0]);
                this.builder.addMethod(MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter((TypeName)mutatorType, "mutator", new Modifier[0]).addCode(code.build()).build());
            }

            private void addOctetsBufferMutator(ClassName className, String name, int size, String sizeName, TypeName sizeType) {
                ClassName builderType = className.nestedClass("Builder");
                CodeBlock.Builder code = CodeBlock.builder();
                code.addStatement("$T $LRW = $L()", new Object[]{builderType, name, StructFlyweightGenerator.methodName(name)});
                if (size >= 0) {
                    code.addStatement("int fieldSize = $LRW.maxLimit() - limit()", new Object[]{name}).beginControlFlow("if (length != fieldSize)", new Object[0]).addStatement("throw new IllegalArgumentException(String.format($S, length, fieldSize))", new Object[]{String.format("Invalid length %%d for field \"%s\", expected %%d", name)}).endControlFlow();
                }
                code.addStatement("$LRW.set(buffer, offset, length)", new Object[]{name});
                if (sizeName != null) {
                    code.addStatement("int newLimit = $LRW.build().limit()", new Object[]{name}).addStatement("int size$$ = newLimit - limit()", new Object[0]);
                    if (StructFlyweightGenerator.isVarintType(sizeType) || StructFlyweightGenerator.isVarbyteuintType(sizeType)) {
                        code.beginControlFlow("if (size$$ != $L)", new Object[]{BuilderClassGenerator.dynamicValue(sizeName)}).addStatement("throw new IllegalStateException(String.format($S, size$$, $L, $S))", new Object[]{String.format("%%d bytes have been set for field \"%s\", does not match value %%d set in %%s", name), BuilderClassGenerator.dynamicValue(sizeName), sizeName}).endControlFlow();
                    } else {
                        code.addStatement("limit($L)", new Object[]{BuilderClassGenerator.dynamicOffset(sizeName)}).addStatement("$L(size$$)", new Object[]{sizeName});
                    }
                    code.addStatement("limit(newLimit)", new Object[0]);
                } else {
                    code.addStatement("limit($LRW.build().limit())", new Object[]{name});
                }
                code.addStatement("lastFieldSet = $L", new Object[]{StructFlyweightGenerator.index(name)}).addStatement("return this", new Object[0]);
                this.builder.addMethod(MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "length", new Modifier[0]).addCode(code.build()).build());
            }

            private void addStringType(ClassName className, String name) {
                ClassName builderType = className.nestedClass("Builder");
                this.builder.addMethod(MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter(String.class, "value", new Modifier[0]).addStatement("$T $LRW = $L()", new Object[]{builderType, name, StructFlyweightGenerator.methodName(name)}).addStatement("$LRW.set(value, $T.UTF_8)", new Object[]{name, StandardCharsets.class}).addStatement("lastFieldSet = $L", new Object[]{StructFlyweightGenerator.index(name)}).addStatement("limit($LRW.build().limit())", new Object[]{name}).addStatement("return this", new Object[0]).build());
                this.builder.addMethod(MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter((TypeName)className, "value", new Modifier[0]).addStatement("$T $LRW = $L()", new Object[]{builderType, name, StructFlyweightGenerator.methodName(name)}).addStatement("$LRW.set(value)", new Object[]{name}).addStatement("lastFieldSet = $L", new Object[]{StructFlyweightGenerator.index(name)}).addStatement("limit($LRW.build().limit())", new Object[]{name}).addStatement("return this", new Object[0]).build());
                this.builder.addMethod(MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "length", new Modifier[0]).addStatement("$T $LRW = $L()", new Object[]{builderType, name, StructFlyweightGenerator.methodName(name)}).addStatement("$LRW.set(buffer, offset, length)", new Object[]{name}).addStatement("lastFieldSet = $L", new Object[]{StructFlyweightGenerator.index(name)}).addStatement("limit($LRW.build().limit())", new Object[]{name}).addStatement("return this", new Object[0]).build());
            }

            private void addDirectBufferType(String name) {
                this.builder.addMethod(MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(IntUnaryOperator.class, "mutator", new Modifier[0]).addParameter(IntConsumer.class, "error", new Modifier[0]).returns((TypeName)this.thisType).addStatement("int length = mutator.applyAsInt(offset() + $L)", new Object[]{StructFlyweightGenerator.offset(name)}).beginControlFlow("if (length < 0)", new Object[0]).addStatement("error.accept(length)", new Object[0]).addStatement("limit(offset() + $L)", new Object[]{StructFlyweightGenerator.offset(name)}).nextControlFlow("else", new Object[0]).addStatement("limit(offset() + $L + length)", new Object[]{StructFlyweightGenerator.offset(name)}).endControlFlow().addStatement("return this", new Object[0]).build());
                this.builder.addMethod(MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(IntUnaryOperator.class, "mutator", new Modifier[0]).returns((TypeName)this.thisType).addStatement("int length = mutator.applyAsInt(offset() + $L)", new Object[]{StructFlyweightGenerator.offset(name)}).beginControlFlow("if (length < 0)", new Object[0]).addStatement("throw new IllegalStateException()", new Object[0]).endControlFlow().addStatement("limit(offset() + $L + length)", new Object[]{StructFlyweightGenerator.offset(name)}).addStatement("return this", new Object[0]).build());
                this.builder.addMethod(MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "value", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "length", new Modifier[0]).returns((TypeName)this.thisType).addStatement("buffer().putBytes(offset() + $L, value, offset, length)", new Object[]{StructFlyweightGenerator.offset(name)}).addStatement("limit(offset() + $L + length)", new Object[]{StructFlyweightGenerator.offset(name)}).addStatement("return this", new Object[0]).build());
                this.builder.addMethod(MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "value", new Modifier[0]).returns((TypeName)this.thisType).addStatement("buffer().putBytes(offset() + $L, value, 0, value.capacity())", new Object[]{StructFlyweightGenerator.offset(name)}).addStatement("limit(offset() + $L + value.capacity())", new Object[]{StructFlyweightGenerator.offset(name)}).addStatement("return this", new Object[0]).build());
                this.builder.addMethod(MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeNames.BYTE_ARRAY, "value", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "length", new Modifier[0]).returns((TypeName)this.thisType).addStatement("buffer().putBytes(offset() + $L, value, offset, length)", new Object[]{StructFlyweightGenerator.offset(name)}).addStatement("limit(offset() + $L + length)", new Object[]{StructFlyweightGenerator.offset(name)}).addStatement("return this", new Object[0]).build());
                this.builder.addMethod(MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeNames.BYTE_ARRAY, "value", new Modifier[0]).returns((TypeName)this.thisType).addStatement("buffer().putBytes(offset() + $L, value, 0, value.length)", new Object[]{StructFlyweightGenerator.offset(name)}).addStatement("limit(offset() + $L + value.length)", new Object[]{StructFlyweightGenerator.offset(name)}).addStatement("return this", new Object[0]).build());
                this.builder.addMethod(MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, "value", new Modifier[0]).returns((TypeName)this.thisType).addStatement("int length = buffer().putStringWithoutLengthUtf8(offset() + $L, value)", new Object[]{StructFlyweightGenerator.offset(name)}).addStatement("limit(offset() + $L + length)", new Object[]{StructFlyweightGenerator.offset(name)}).addStatement("return this", new Object[0]).build());
            }

            private void addParameterizedType(String name, ParameterizedTypeName parameterizedType, String priorFieldIfDefaulted, Consumer<CodeBlock.Builder> defaultPriorField) {
                ClassName rawType = parameterizedType.rawType;
                ClassName itemType = (ClassName)parameterizedType.typeArguments.get(0);
                ClassName builderRawType = rawType.nestedClass("Builder");
                ClassName itemBuilderType = itemType.nestedClass("Builder");
                ParameterizedTypeName builderType = ParameterizedTypeName.get((ClassName)builderRawType, (TypeName[])new TypeName[]{itemBuilderType, itemType});
                ClassName consumerType = ClassName.get(Consumer.class);
                ParameterizedTypeName mutatorType = ParameterizedTypeName.get((ClassName)consumerType, (TypeName[])new TypeName[]{builderType});
                CodeBlock.Builder code = CodeBlock.builder();
                if (priorFieldIfDefaulted != null) {
                    code.beginControlFlow("if (lastFieldSet < $L)", new Object[]{StructFlyweightGenerator.index(priorFieldIfDefaulted)});
                    defaultPriorField.accept(code);
                    code.endControlFlow();
                }
                code.addStatement("assert lastFieldSet == $L - 1", new Object[]{StructFlyweightGenerator.index(name)}).addStatement("$T $LRW = this.$LRW.wrap(buffer(), limit(), maxLimit())", new Object[]{builderType, name, name}).addStatement("mutator.accept($LRW)", new Object[]{name}).addStatement("limit($LRW.build().limit())", new Object[]{name}).addStatement("lastFieldSet = $L", new Object[]{StructFlyweightGenerator.index(name)}).addStatement("return this", new Object[0]);
                this.builder.addMethod(MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter((TypeName)mutatorType, "mutator", new Modifier[0]).addCode(code.build()).build());
                if ("Array32FW".equals(rawType.simpleName())) {
                    code = CodeBlock.builder();
                    if (priorFieldIfDefaulted != null) {
                        code.beginControlFlow("if (lastFieldSet < $L)", new Object[]{StructFlyweightGenerator.index(priorFieldIfDefaulted)});
                        defaultPriorField.accept(code);
                        code.endControlFlow();
                    }
                    code.addStatement("assert lastFieldSet == $L - 1", new Object[]{StructFlyweightGenerator.index(name)}).addStatement("int newLimit = limit() + field.sizeof()", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("buffer().putBytes(limit(), field.buffer(), field.offset(), field.sizeof())", new Object[0]).addStatement("limit(newLimit)", new Object[0]).addStatement("lastFieldSet = $L", new Object[]{StructFlyweightGenerator.index(name)}).addStatement("return this", new Object[0]);
                    this.builder.addMethod(MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter((TypeName)ParameterizedTypeName.get((ClassName)rawType, (TypeName[])new TypeName[]{itemType}), "field", new Modifier[0]).addCode(code.build()).build());
                    code = CodeBlock.builder();
                    if (priorFieldIfDefaulted != null) {
                        code.beginControlFlow("if (lastFieldSet < $L)", new Object[]{StructFlyweightGenerator.index(priorFieldIfDefaulted)});
                        defaultPriorField.accept(code);
                        code.endControlFlow();
                    }
                    code.addStatement("assert lastFieldSet >= $L - 1", new Object[]{StructFlyweightGenerator.index(name)}).beginControlFlow("if (lastFieldSet < $L)", new Object[]{StructFlyweightGenerator.index(name)}).addStatement("$LRW.wrap(buffer(), limit(), maxLimit())", new Object[]{name}).endControlFlow().addStatement("$LRW.item(mutator)", new Object[]{name}).addStatement("limit($LRW.build().limit())", new Object[]{name}).addStatement("lastFieldSet = $L", new Object[]{StructFlyweightGenerator.index(name)}).addStatement("return this", new Object[0]);
                    ParameterizedTypeName itemMutatorType = ParameterizedTypeName.get((ClassName)consumerType, (TypeName[])new TypeName[]{itemBuilderType});
                    this.builder.addMethod(MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name + "Item")).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter((TypeName)itemMutatorType, "mutator", new Modifier[0]).addCode(code.build()).build());
                }
            }

            static {
                HashMap<TypeName, String> putterNames = new HashMap<TypeName, String>();
                putterNames.put(TypeName.BYTE, "putByte");
                putterNames.put(TypeName.CHAR, "putChar");
                putterNames.put(TypeName.SHORT, "putShort");
                putterNames.put(TypeName.FLOAT, "putFloat");
                putterNames.put(TypeName.INT, "putInt");
                putterNames.put(TypeName.DOUBLE, "putDouble");
                putterNames.put(TypeName.LONG, "putLong");
                PUTTER_NAMES = Collections.unmodifiableMap(putterNames);
                HashMap<TypeName, String[]> unsigned = new HashMap<TypeName, String[]>();
                unsigned.put(TypeName.BYTE, new String[]{"0", "0XFF"});
                unsigned.put(TypeName.SHORT, new String[]{"0", "0xFFFF"});
                unsigned.put(TypeName.INT, new String[]{"0", "0xFFFFFFFFL"});
                unsigned.put(TypeName.LONG, new String[]{"0L", null});
                UNSIGNED_INT_RANGES = Collections.unmodifiableMap(unsigned);
            }
        }

        private static final class MemberAccessorGenerator
        extends ClassSpecMixinGenerator {
            private boolean priorFieldIsAutomaticallySet;

            private MemberAccessorGenerator(ClassName thisType, TypeSpec.Builder builder) {
                super(thisType, builder);
            }

            public MemberAccessorGenerator addMember(String name, TypeName type, TypeName unsignedType, boolean usedAsSize, int size, String sizeName, Object defaultValue, String priorFieldIfDefaulted, Consumer<CodeBlock.Builder> defaultPriorField) {
                if (type instanceof ClassName) {
                    ClassName classType = (ClassName)type;
                    if (StructFlyweightGenerator.isStringType(classType)) {
                        this.addStringType(name, classType, priorFieldIfDefaulted, defaultPriorField);
                    } else if ("OctetsFW".equals(classType.simpleName())) {
                        this.addOctetsType(name, classType, size, sizeName, defaultValue, priorFieldIfDefaulted, defaultPriorField);
                    }
                }
                this.priorFieldIsAutomaticallySet = usedAsSize && !StructFlyweightGenerator.isVarintType(type) && !StructFlyweightGenerator.isVarbyteuintType(type);
                return this;
            }

            private void addOctetsType(String name, ClassName className, int size, String sizeName, Object defaultValue, String priorFieldIfDefaulted, Consumer<CodeBlock.Builder> defaultPriorField) {
                String fieldRW = String.format("%sRW", name);
                ClassName builderType = className.nestedClass("Builder");
                CodeBlock.Builder code = CodeBlock.builder();
                if (priorFieldIfDefaulted != null) {
                    if (!this.priorFieldIsAutomaticallySet) {
                        code.beginControlFlow("if (lastFieldSet < $L)", new Object[]{StructFlyweightGenerator.index(priorFieldIfDefaulted)});
                    }
                    defaultPriorField.accept(code);
                    if (!this.priorFieldIsAutomaticallySet) {
                        code.endControlFlow();
                    }
                }
                code.addStatement("assert lastFieldSet == $L - 1", new Object[]{StructFlyweightGenerator.index(name)});
                if (size >= 0) {
                    code.addStatement("int newLimit = limit() + $L", new Object[]{size});
                    code.addStatement("checkLimit(newLimit, maxLimit())", new Object[0]);
                    code.addStatement("return $L.wrap(buffer(), limit(), newLimit)", new Object[]{fieldRW});
                } else {
                    code.addStatement("return $L.wrap(buffer(), limit(), maxLimit())", new Object[]{fieldRW});
                }
                this.builder.addMethod(MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PRIVATE}).returns((TypeName)builderType).addCode(code.build()).build());
            }

            private void addStringType(String name, ClassName classType, String priorFieldIfDefaulted, Consumer<CodeBlock.Builder> defaultPriorField) {
                String fieldRW = String.format("%sRW", name);
                ClassName builderType = classType.nestedClass("Builder");
                CodeBlock.Builder code = CodeBlock.builder();
                if (priorFieldIfDefaulted != null) {
                    if (!this.priorFieldIsAutomaticallySet) {
                        code.beginControlFlow("if (lastFieldSet < $L)", new Object[]{StructFlyweightGenerator.index(priorFieldIfDefaulted)});
                    }
                    defaultPriorField.accept(code);
                    if (!this.priorFieldIsAutomaticallySet) {
                        code.endControlFlow();
                    }
                }
                code.addStatement("assert lastFieldSet == $L - 1", new Object[]{StructFlyweightGenerator.index(name)}).addStatement("return $L.wrap(buffer(), limit(), maxLimit())", new Object[]{fieldRW});
                this.builder.addMethod(MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PRIVATE}).returns((TypeName)builderType).addCode(code.build()).build());
            }
        }

        private static final class MemberFieldGenerator
        extends ClassSpecMixinGenerator {
            private MemberFieldGenerator(ClassName thisType, TypeSpec.Builder builder) {
                super(thisType, builder);
            }

            public MemberFieldGenerator addMember(String name, TypeName type, TypeName unsignedType, int size, String sizeName, boolean usedAsSize, AstByteOrder byteOrder) {
                if (usedAsSize && (StructFlyweightGenerator.isVarintType(type) || StructFlyweightGenerator.isVarbyteuintType(type))) {
                    this.builder.addField(FieldSpec.builder((TypeName)TypeName.INT, (String)BuilderClassGenerator.dynamicValue(name), (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
                }
                if (usedAsSize && !StructFlyweightGenerator.isVarintType(type) && !StructFlyweightGenerator.isVarbyteuintType(type)) {
                    this.builder.addField(FieldSpec.builder((TypeName)TypeName.INT, (String)BuilderClassGenerator.dynamicOffset(name), (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
                } else if (type.isPrimitive()) {
                    if (size != -1 || sizeName != null) {
                        this.builder.addField(FieldSpec.builder((TypeName)TypeName.INT, (String)BuilderClassGenerator.dynamicOffset(name), (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
                    }
                } else {
                    String fieldRW = String.format("%sRW", name);
                    if (!TypeNames.DIRECT_BUFFER_TYPE.equals((Object)type)) {
                        if (type instanceof ParameterizedTypeName) {
                            ParameterizedTypeName parameterizedType = (ParameterizedTypeName)type;
                            ClassName rawType = parameterizedType.rawType;
                            ClassName itemType = (ClassName)parameterizedType.typeArguments.get(0);
                            ClassName builderRawType = rawType.nestedClass("Builder");
                            ClassName itemBuilderType = itemType.nestedClass("Builder");
                            ParameterizedTypeName builderType = ParameterizedTypeName.get((ClassName)builderRawType, (TypeName[])new TypeName[]{itemBuilderType, itemType});
                            this.builder.addField(FieldSpec.builder((TypeName)builderType, (String)fieldRW, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T(new $T(), new $T())", new Object[]{builderType, itemBuilderType, itemType}).build());
                        } else if (type instanceof ClassName) {
                            ClassName classType = (ClassName)type;
                            ClassName builderType = classType.nestedClass("Builder");
                            if ((StructFlyweightGenerator.isString16Type(classType) || StructFlyweightGenerator.isString32Type(classType)) && byteOrder == AstByteOrder.NETWORK) {
                                this.builder.addField(FieldSpec.builder((TypeName)builderType, (String)fieldRW, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T($T.BIG_ENDIAN)", new Object[]{builderType, ByteOrder.class}).build());
                            } else {
                                this.builder.addField(FieldSpec.builder((TypeName)builderType, (String)fieldRW, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T()", new Object[]{builderType}).build());
                            }
                        } else {
                            throw new IllegalArgumentException("Unsupported member type: " + type);
                        }
                    }
                }
                return this;
            }
        }

        private static final class MemberConstantGenerator
        extends ClassSpecMixinGenerator {
            private final TypeResolver resolver;
            private int nextIndex;

            private MemberConstantGenerator(ClassName thisType, TypeResolver resolver, TypeSpec.Builder builder) {
                super(thisType, builder);
                this.resolver = resolver;
            }

            public MemberConstantGenerator addMember(String name, AstType type, TypeName typeName, TypeName unsignedType, int size, String sizeName, boolean usedAsSize, Object defaultValue) {
                boolean automaticallySet;
                boolean bl = automaticallySet = usedAsSize && !StructFlyweightGenerator.isVarintType(typeName) && !StructFlyweightGenerator.isVarbyteuintType(typeName);
                if (!automaticallySet) {
                    this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)StructFlyweightGenerator.index(name), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(Integer.toString(this.nextIndex++), new Object[0]).build());
                }
                boolean isOctetsType = StructFlyweightGenerator.isOctetsType(typeName);
                if (defaultValue != null && !isOctetsType) {
                    TypeName generateType;
                    Object defaultValueToSet = defaultValue == AstAbstractMemberNode.NULL_DEFAULT ? null : defaultValue;
                    TypeName typeName2 = generateType = unsignedType != null ? unsignedType : typeName;
                    if (size != -1 || sizeName != null) {
                        ClassName className = generateType = generateType == TypeName.LONG ? LONG_ITERATOR_CLASS_NAME : INT_ITERATOR_CLASS_NAME;
                    }
                    if (StructFlyweightGenerator.isVarbyteuint32Type(typeName)) {
                        generateType = TypeName.INT;
                    } else if (StructFlyweightGenerator.isVarint32Type(typeName)) {
                        generateType = TypeName.INT;
                    } else if (StructFlyweightGenerator.isVarint64Type(typeName)) {
                        generateType = TypeName.LONG;
                    } else if (StructFlyweightGenerator.isStringType(typeName)) {
                        generateType = STRING_CLASS_NAME;
                    }
                    AstNamedNode node = this.resolver.resolve(type.name());
                    if (node != null && StructFlyweightGenerator.isEnumType(node.getKind())) {
                        AstEnumNode enumNode = (AstEnumNode)node;
                        ClassName enumFlyweightName = (ClassName)typeName;
                        ClassName enumName = enumFlyweightName.peerClass(enumNode.name());
                        this.builder.addField(FieldSpec.builder((TypeName)enumName, (String)BuilderClassGenerator.defaultName(name), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$T.$L", new Object[]{enumName, Objects.toString(defaultValueToSet)}).build());
                    } else {
                        this.builder.addField(FieldSpec.builder((TypeName)generateType, (String)BuilderClassGenerator.defaultName(name), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(Objects.toString(defaultValueToSet), new Object[0]).build());
                    }
                }
                return this;
            }

            @Override
            public TypeSpec.Builder build() {
                this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)"FIELD_COUNT", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(Integer.toString(this.nextIndex), new Object[0]).build()).addField(FieldSpec.builder(Integer.TYPE, (String)"lastFieldSet", (Modifier[])new Modifier[]{Modifier.PRIVATE}).initializer("-1", new Object[0]).build());
                return super.build();
            }
        }
    }

    private final class ToStringMethodGenerator
    extends MethodSpecGenerator {
        private final List<String> formats;
        private final List<String> args;

        private ToStringMethodGenerator() {
            super(MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class));
            this.formats = new LinkedList<String>();
            this.args = new LinkedList<String>();
        }

        public ToStringMethodGenerator addMember(String name, TypeName type, TypeName unsignedType, int size, String sizeName) {
            boolean isArray = size != -1 || sizeName != null;
            this.formats.add(String.format("%s=%%%s", name, type.isPrimitive() && !isArray ? "d" : "s"));
            if (type instanceof ClassName && StructFlyweightGenerator.isStringType((ClassName)type)) {
                this.args.add(String.format("%sRO.asString()", name));
            } else {
                this.args.add(String.format("%s()", name));
            }
            return this;
        }

        @Override
        public MethodSpec generate() {
            String typeName = StructFlyweightGenerator.constant(StructFlyweightGenerator.this.baseName);
            if (this.formats.isEmpty()) {
                this.builder.addStatement("return $S", new Object[]{typeName});
            } else {
                String format = String.format("%s [%s]", typeName, String.join((CharSequence)", ", this.formats));
                this.builder.addStatement("return String.format($S, $L)", new Object[]{format, String.join((CharSequence)", ", this.args)});
            }
            return this.builder.build();
        }
    }

    private final class WrapMethodGenerator
    extends MethodSpecGenerator {
        private final ClassName thisType;
        private String anchorLimit;

        private WrapMethodGenerator(ClassName thisType) {
            super(MethodSpec.methodBuilder((String)"wrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(StructFlyweightGenerator.this.thisName));
            this.builder.addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]);
            this.thisType = thisType;
        }

        public WrapMethodGenerator addMember(String name, AstType type, TypeName typeName, TypeName unsignedTypeName, int size, String sizeName, Object defaultValue) {
            if (TypeNames.DIRECT_BUFFER_TYPE.equals((Object)typeName)) {
                this.builder.addStatement("$LRO.wrap(buffer, offset + $L, maxLimit - (offset + $L))", new Object[]{name, StructFlyweightGenerator.offset(name), StructFlyweightGenerator.offset(name)});
            } else if (!typeName.isPrimitive()) {
                this.addNonPrimitiveMember(name, typeName, unsignedTypeName, size, sizeName, defaultValue);
            } else if (size != -1) {
                this.addFixedIntegerArrayMember(name, type, typeName, unsignedTypeName, size);
            } else if (sizeName != null) {
                this.addVariableIntegerArrayMember(name, type, typeName, unsignedTypeName, sizeName);
            }
            return this;
        }

        private void addFixedIntegerArrayMember(String name, AstType type, TypeName typeName, TypeName unsignedTypeName, int size) {
            String offsetName;
            ClassName iteratorClass = StructFlyweightGenerator.iteratorClass(this.thisType, typeName, unsignedTypeName);
            TypeName targetType = unsignedTypeName != null ? unsignedTypeName : typeName;
            targetType = targetType == TypeName.LONG ? targetType : TypeName.INT;
            CodeBlock.Builder code = CodeBlock.builder();
            if (this.anchorLimit != null) {
                offsetName = "offset" + StructFlyweightGenerator.initCap(name);
                code.addStatement("final int $L = $L + $L", new Object[]{offsetName, this.anchorLimit, StructFlyweightGenerator.offset(name)});
            } else {
                offsetName = "offset + " + StructFlyweightGenerator.offset(name);
            }
            code.add("$[", new Object[0]).add("$L = new $T($S, $L, $L, $L, o -> ", new Object[]{StructFlyweightGenerator.iterator(name), iteratorClass, name, offsetName, StructFlyweightGenerator.size(name), StructFlyweightGenerator.arraySize(name)});
            this.addBufferGet(code, targetType, type, typeName, unsignedTypeName, "o");
            code.add(")", new Object[0]).add(";\n$]", new Object[0]);
            this.builder.addCode(code.build());
        }

        private void addVariableIntegerArrayMember(String name, AstType type, TypeName typeName, TypeName unsignedTypeName, String sizeName) {
            ClassName iteratorClass = StructFlyweightGenerator.iteratorClass(this.thisType, typeName, unsignedTypeName);
            String offsetName = "offset" + StructFlyweightGenerator.initCap(name);
            String limitName = "limit" + StructFlyweightGenerator.initCap(name);
            TypeName targetType = unsignedTypeName != null ? unsignedTypeName : typeName;
            targetType = targetType == TypeName.LONG ? targetType : TypeName.INT;
            CodeBlock.Builder code = CodeBlock.builder();
            if (this.anchorLimit != null) {
                code.addStatement("final int $L = $L + $L", new Object[]{offsetName, this.anchorLimit, StructFlyweightGenerator.offset(name)});
            } else {
                code.addStatement("final int $L = offset + $L", new Object[]{offsetName, StructFlyweightGenerator.offset(name)});
            }
            code.add("$[", new Object[0]).add("$L = $L() == -1 ? null :\n", new Object[]{StructFlyweightGenerator.iterator(name), StructFlyweightGenerator.methodName(sizeName)}).add("new $T($S, $L, $L, (int) $L(), o -> ", new Object[]{iteratorClass, name, offsetName, StructFlyweightGenerator.size(name), StructFlyweightGenerator.methodName(sizeName)});
            this.addBufferGet(code, targetType, type, typeName, unsignedTypeName, "o");
            code.add(")", new Object[0]).add(";\n$]", new Object[0]).addStatement("$L = $L() == -1 ? $L : $L + $L * $L()", new Object[]{limitName, StructFlyweightGenerator.methodName(sizeName), offsetName, offsetName, StructFlyweightGenerator.size(name), StructFlyweightGenerator.methodName(sizeName)});
            this.builder.addCode(code.build());
            this.anchorLimit = limitName;
        }

        private void addNonPrimitiveMember(String name, TypeName type, TypeName unsignedType, int size, String sizeName, Object defaultValue) {
            if (this.anchorLimit != null) {
                if (size >= 0) {
                    this.builder.addStatement("$LRO.wrap(buffer, $L + $L, $L + $L + $L)", new Object[]{name, this.anchorLimit, StructFlyweightGenerator.offset(name), this.anchorLimit, StructFlyweightGenerator.offset(name), size});
                } else if (sizeName != null) {
                    if (defaultValue == AstAbstractMemberNode.NULL_DEFAULT) {
                        this.builder.addStatement("$LRO.wrap(buffer, $L + $L, $L + $L + ((int) $L() == -1 ? 0 : (int) $L()))", new Object[]{name, this.anchorLimit, StructFlyweightGenerator.offset(name), this.anchorLimit, StructFlyweightGenerator.offset(name), StructFlyweightGenerator.methodName(sizeName), StructFlyweightGenerator.methodName(sizeName)});
                    } else {
                        this.builder.addStatement("$LRO.wrap(buffer, $L + $L, $L + $L + (int) $L())", new Object[]{name, this.anchorLimit, StructFlyweightGenerator.offset(name), this.anchorLimit, StructFlyweightGenerator.offset(name), StructFlyweightGenerator.methodName(sizeName)});
                    }
                } else {
                    this.builder.addStatement("$LRO.wrap(buffer, $L + $L, maxLimit)", new Object[]{name, this.anchorLimit, StructFlyweightGenerator.offset(name)});
                }
            } else if (size >= 0) {
                this.builder.addStatement("$LRO.wrap(buffer, offset + $L, offset + $L + $L)", new Object[]{name, StructFlyweightGenerator.offset(name), StructFlyweightGenerator.offset(name), size});
            } else if (sizeName != null) {
                if (defaultValue == AstAbstractMemberNode.NULL_DEFAULT) {
                    this.builder.addStatement("$LRO.wrap(buffer, offset + $L, offset + $L + ((int) $L() == -1 ? 0 : (int) $L()))", new Object[]{name, StructFlyweightGenerator.offset(name), StructFlyweightGenerator.offset(name), StructFlyweightGenerator.methodName(sizeName), StructFlyweightGenerator.methodName(sizeName)});
                } else {
                    this.builder.addStatement("$LRO.wrap(buffer, offset + $L, offset + $L + (int) $L())", new Object[]{name, StructFlyweightGenerator.offset(name), StructFlyweightGenerator.offset(name), StructFlyweightGenerator.methodName(sizeName)});
                }
            } else {
                this.builder.addStatement("$LRO.wrap(buffer, offset + $L, maxLimit)", new Object[]{name, StructFlyweightGenerator.offset(name)});
            }
            this.anchorLimit = name + "RO.limit()";
        }

        private void addBufferGet(CodeBlock.Builder codeBlock, TypeName targetType, AstType type, TypeName typeName, TypeName unsignedTypeName, String offset) {
            if (type.bits() == 24) {
                if (type.isUnsignedInt()) {
                    codeBlock.add("$T.NATIVE_BYTE_ORDER == $T.BIG_ENDIAN ? ", new Object[]{TypeNames.BUFFER_UTIL_TYPE, ByteOrder.class}).add("(buffer().getByte($L) & 0xff) << 16 |", new Object[]{offset}).add(" (buffer().getByte($L + 1) & 0xff) << 8 |", new Object[]{offset}).add(" (buffer().getByte($L + 2) & 0xff)", new Object[]{offset}).add(" : ", new Object[0]).add("(buffer().getByte($L + 2) & 0xff) << 16 |", new Object[]{offset}).add(" (buffer().getByte($L + 1) & 0xff) << 8 |", new Object[]{offset}).add(" (buffer().getByte($L) & 0xff)", new Object[]{offset});
                } else {
                    codeBlock.add("$T.NATIVE_BYTE_ORDER == $T.BIG_ENDIAN ? ", new Object[]{TypeNames.BUFFER_UTIL_TYPE, ByteOrder.class}).add("buffer().getByte($L) << 16 |", new Object[]{offset}).add(" (buffer().getByte($L + 1) & 0xff) << 8 |", new Object[]{offset}).add(" (buffer().getByte($L + 2) & 0xff)", new Object[]{offset}).add(" : ", new Object[0]).add("buffer().getByte($L + 2) << 16 |", new Object[]{offset}).add(" (buffer().getByte($L + 1) & 0xff) << 8 |", new Object[]{offset}).add(" (buffer().getByte($L) & 0xff)", new Object[]{offset});
                }
            } else {
                String getterName = (String)GETTER_NAMES.get(typeName);
                if (getterName == null) {
                    throw new IllegalStateException("member type not supported: " + typeName);
                }
                if (targetType != typeName) {
                    codeBlock.add("($T)(", new Object[]{targetType});
                }
                codeBlock.add("buffer().$L($L", new Object[]{getterName, offset});
                if (targetType != typeName && unsignedTypeName != null) {
                    if (typeName == TypeName.BYTE) {
                        codeBlock.add(") & 0xFF)", new Object[0]);
                    } else if (typeName == TypeName.SHORT) {
                        codeBlock.add(") & 0xFFFF)", new Object[]{ByteOrder.class});
                    } else if (typeName == TypeName.INT) {
                        codeBlock.add(") & 0xFFFF_FFFFL)", new Object[]{ByteOrder.class});
                    } else {
                        codeBlock.add(")", new Object[0]);
                    }
                } else {
                    codeBlock.add(")", new Object[0]);
                }
                if (targetType != typeName && unsignedTypeName == null) {
                    codeBlock.add(")", new Object[0]);
                }
            }
        }

        @Override
        public MethodSpec generate() {
            return this.builder.addStatement("checkLimit(limit(), maxLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
        }
    }

    private final class TryWrapMethodGenerator
    extends MethodSpecGenerator {
        private final ClassName thisType;
        private String anchorLimit;
        private boolean limitDeclared;

        private TryWrapMethodGenerator(ClassName thisType) {
            super(MethodSpec.methodBuilder((String)"tryWrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(StructFlyweightGenerator.this.thisName));
            this.addFailIfStatement("null == super.tryWrap(buffer, offset, maxLimit)", new Object[0]);
            this.thisType = thisType;
        }

        private void addFailIfStatement(String string, Object ... args) {
            this.builder.beginControlFlow("if (" + string + ")", args);
            this.builder.addStatement("return null", new Object[0]);
            this.builder.endControlFlow();
        }

        private void declareLimit() {
            if (!this.limitDeclared) {
                this.builder.addStatement("int limit", new Object[0]);
                this.limitDeclared = true;
            }
        }

        public TryWrapMethodGenerator addMember(String name, AstType type, TypeName typeName, AstType unsignedType, TypeName unsignedTypeName, int size, String sizeName, Object defaultValue) {
            if (TypeNames.DIRECT_BUFFER_TYPE.equals((Object)typeName)) {
                this.addFailIfStatement("null == $LRO.wrap(buffer, offset + $L, maxLimit - (offset + $L))", name, StructFlyweightGenerator.offset(name), StructFlyweightGenerator.offset(name));
            } else if (!typeName.isPrimitive()) {
                this.addNonPrimitiveMember(name, typeName, unsignedTypeName, size, sizeName, defaultValue);
            } else if (size != -1) {
                this.addFixedIntegerArrayMember(name, type, typeName, unsignedType, unsignedTypeName, size);
            } else if (sizeName != null) {
                this.addVariableIntegerArrayMember(name, type, typeName, unsignedType, unsignedTypeName, sizeName);
            }
            return this;
        }

        private void addFixedIntegerArrayMember(String name, AstType type, TypeName typeName, AstType unsignedType, TypeName unsignedTypeName, int size) {
            String offsetName;
            ClassName iteratorClass = StructFlyweightGenerator.iteratorClass(this.thisType, typeName, unsignedTypeName);
            TypeName targetTypeName = unsignedTypeName != null ? unsignedTypeName : typeName;
            targetTypeName = targetTypeName == TypeName.LONG ? targetTypeName : TypeName.INT;
            CodeBlock.Builder code = CodeBlock.builder();
            if (this.anchorLimit != null) {
                offsetName = "offset" + StructFlyweightGenerator.initCap(name);
                code.addStatement("final int $L = $L + $L", new Object[]{offsetName, this.anchorLimit, StructFlyweightGenerator.offset(name)});
            } else {
                offsetName = "offset + " + StructFlyweightGenerator.offset(name);
            }
            code.add("$[", new Object[0]).add("$L = new $T($S, $L, $L, $L, o -> ", new Object[]{StructFlyweightGenerator.iterator(name), iteratorClass, name, offsetName, StructFlyweightGenerator.size(name), StructFlyweightGenerator.arraySize(name)});
            this.addBufferGet(code, targetTypeName, type, typeName, unsignedTypeName, "o");
            code.add(")", new Object[0]).add(";\n$]", new Object[0]);
            this.builder.addCode(code.build());
        }

        private void addVariableIntegerArrayMember(String name, AstType type, TypeName typeName, AstType unsignedType, TypeName unsignedTypeName, String sizeName) {
            ClassName iteratorClass = StructFlyweightGenerator.iteratorClass(this.thisType, typeName, unsignedTypeName);
            String offsetName = "offset" + StructFlyweightGenerator.initCap(name);
            String limitName = "limit" + StructFlyweightGenerator.initCap(name);
            TypeName targetType = unsignedTypeName != null ? unsignedTypeName : typeName;
            targetType = targetType == TypeName.LONG ? targetType : TypeName.INT;
            CodeBlock.Builder code = CodeBlock.builder();
            if (this.anchorLimit != null) {
                code.addStatement("final int $L = $L + $L", new Object[]{offsetName, this.anchorLimit, StructFlyweightGenerator.offset(name)});
            } else {
                code.addStatement("final int $L = offset + $L", new Object[]{offsetName, StructFlyweightGenerator.offset(name)});
            }
            code.add("$[", new Object[0]).add("$L = $L() == -1 ? null :\n", new Object[]{StructFlyweightGenerator.iterator(name), StructFlyweightGenerator.methodName(sizeName)}).add("new $T($S, $L, $L, (int) $L(), o -> ", new Object[]{iteratorClass, name, offsetName, StructFlyweightGenerator.size(name), StructFlyweightGenerator.methodName(sizeName)});
            this.addBufferGet(code, targetType, type, typeName, unsignedTypeName, "o");
            code.add(")", new Object[0]).add(";\n$]", new Object[0]).addStatement("$L = $L() == -1 ? $L : $L + $L * $L()", new Object[]{limitName, StructFlyweightGenerator.methodName(sizeName), offsetName, offsetName, StructFlyweightGenerator.size(name), StructFlyweightGenerator.methodName(sizeName)});
            this.builder.addCode(code.build());
            this.anchorLimit = limitName;
        }

        private void addNonPrimitiveMember(String name, TypeName type, TypeName unsignedType, int size, String sizeName, Object defaultValue) {
            boolean sized;
            boolean bl = sized = size >= 0 || sizeName != null;
            if (sized) {
                this.declareLimit();
            }
            if (this.anchorLimit != null) {
                if (size >= 0) {
                    this.builder.addStatement("limit = $L + $L + $L", new Object[]{this.anchorLimit, StructFlyweightGenerator.offset(name), size});
                } else if (sizeName != null) {
                    if (defaultValue == AstAbstractMemberNode.NULL_DEFAULT) {
                        this.builder.addStatement("limit = $L + $L + ((int) $L() == -1 ? 0 : (int) $L()) ", new Object[]{this.anchorLimit, StructFlyweightGenerator.offset(name), StructFlyweightGenerator.methodName(sizeName), StructFlyweightGenerator.methodName(sizeName)});
                    } else {
                        this.builder.addStatement("limit = $L + $L + (int) $L()", new Object[]{this.anchorLimit, StructFlyweightGenerator.offset(name), StructFlyweightGenerator.methodName(sizeName)});
                    }
                }
                if (sized) {
                    this.addFailIfStatement("limit > maxLimit || null == $LRO.tryWrap(buffer, $L + $L, limit)", name, this.anchorLimit, StructFlyweightGenerator.offset(name));
                } else {
                    this.addFailIfStatement("null == $LRO.tryWrap(buffer, $L + $L, maxLimit)", name, this.anchorLimit, StructFlyweightGenerator.offset(name));
                }
            } else {
                if (size >= 0) {
                    this.builder.addStatement("limit = offset + $L + $L", new Object[]{StructFlyweightGenerator.offset(name), size});
                } else if (sizeName != null) {
                    if (defaultValue == AstAbstractMemberNode.NULL_DEFAULT) {
                        this.builder.addStatement("limit = offset + $L + ((int) $L() == -1 ? 0 : (int) $L())", new Object[]{StructFlyweightGenerator.offset(name), StructFlyweightGenerator.methodName(sizeName), StructFlyweightGenerator.methodName(sizeName)});
                    } else {
                        this.builder.addStatement("limit = offset + $L + (int) $L()", new Object[]{StructFlyweightGenerator.offset(name), StructFlyweightGenerator.methodName(sizeName)});
                    }
                }
                if (sized) {
                    this.addFailIfStatement("limit > maxLimit || null == $LRO.tryWrap(buffer, offset + $L, limit)", name, StructFlyweightGenerator.offset(name));
                } else {
                    this.addFailIfStatement("null == $LRO.tryWrap(buffer, offset + $L, maxLimit)", name, StructFlyweightGenerator.offset(name));
                }
            }
            this.anchorLimit = name + "RO.limit()";
        }

        private void addBufferGet(CodeBlock.Builder codeBlock, TypeName targetTypeName, AstType type, TypeName typeName, TypeName unsignedTypeName, String offset) {
            if (type.bits() == 24) {
                if (type.isUnsignedInt()) {
                    codeBlock.add("$T.NATIVE_BYTE_ORDER == $T.BIG_ENDIAN ? ", new Object[]{TypeNames.BUFFER_UTIL_TYPE, ByteOrder.class}).add("(buffer().getByte($L) & 0xff) << 16 |", new Object[]{offset}).add(" (buffer().getByte($L + 1) & 0xff) << 8 |", new Object[]{offset}).add(" (buffer().getByte($L + 2) & 0xff)", new Object[]{offset}).add(" : ", new Object[0]).add("(buffer().getByte($L + 2) & 0xff) << 16 |", new Object[]{offset}).add(" (buffer().getByte($L + 1) & 0xff) << 8 |", new Object[]{offset}).add(" (buffer().getByte($L) & 0xff)", new Object[]{offset});
                } else {
                    codeBlock.add("$T.NATIVE_BYTE_ORDER == $T.BIG_ENDIAN ? ", new Object[]{TypeNames.BUFFER_UTIL_TYPE, ByteOrder.class}).add("buffer().getByte($L) << 16 |", new Object[]{offset}).add(" (buffer().getByte($L + 1) & 0xff) << 8 |", new Object[]{offset}).add(" (buffer().getByte($L + 2) & 0xff)", new Object[]{offset}).add(" : ", new Object[0]).add("buffer().getByte($L + 2) << 16 |", new Object[]{offset}).add(" (buffer().getByte($L + 1) & 0xff) << 8 |", new Object[]{offset}).add(" (buffer().getByte($L) & 0xff)", new Object[]{offset});
                }
            } else {
                String getterName = (String)GETTER_NAMES.get(typeName);
                if (getterName == null) {
                    throw new IllegalStateException("member type not supported: " + typeName);
                }
                if (targetTypeName != typeName) {
                    codeBlock.add("($T)(", new Object[]{targetTypeName});
                }
                codeBlock.add("buffer().$L($L", new Object[]{getterName, offset});
                if (targetTypeName != typeName && unsignedTypeName != null) {
                    if (typeName == TypeName.BYTE) {
                        codeBlock.add(") & 0xFF)", new Object[0]);
                    } else if (typeName == TypeName.SHORT) {
                        codeBlock.add(") & 0xFFFF)", new Object[]{ByteOrder.class});
                    } else if (typeName == TypeName.INT) {
                        codeBlock.add(") & 0xFFFF_FFFFL)", new Object[]{ByteOrder.class});
                    } else {
                        codeBlock.add(")", new Object[0]);
                    }
                } else {
                    codeBlock.add(")", new Object[0]);
                }
                if (targetTypeName != typeName && unsignedTypeName == null) {
                    codeBlock.add(")", new Object[0]);
                }
            }
        }

        @Override
        public MethodSpec generate() {
            this.addFailIfStatement("limit() > maxLimit", new Object[0]);
            return this.builder.addStatement("return this", new Object[0]).build();
        }
    }

    private final class LimitMethodGenerator
    extends MethodSpecGenerator {
        private String anchorName;
        private TypeName anchorType;
        private String lastName;
        private TypeName lastType;
        private int lastSize;
        private String lastSizeName;

        private LimitMethodGenerator() {
            super(MethodSpec.methodBuilder((String)"limit").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE));
        }

        public LimitMethodGenerator addMember(String name, TypeName type, TypeName unsignedType, int size, String sizeName) {
            if (!type.isPrimitive() || type.isPrimitive() && sizeName != null) {
                this.anchorName = name;
                this.anchorType = type;
            }
            this.lastName = name;
            this.lastType = type;
            this.lastSize = size;
            this.lastSizeName = sizeName;
            return this;
        }

        @Override
        public MethodSpec generate() {
            if (this.lastName == null) {
                this.builder.addStatement("return offset()", new Object[0]);
            } else {
                CodeBlock.Builder code = CodeBlock.builder();
                code.add("$[", new Object[0]);
                if (this.anchorName != null) {
                    if (TypeNames.DIRECT_BUFFER_TYPE.equals((Object)this.anchorType)) {
                        code.add("return $L().capacity()", new Object[]{StructFlyweightGenerator.methodName(this.anchorName)});
                    } else if (this.anchorType.isPrimitive()) {
                        code.add("return $L", new Object[]{StructFlyweightGenerator.dynamicLimit(this.anchorName)});
                    } else {
                        code.add("return $LRO.limit()", new Object[]{this.anchorName});
                    }
                } else {
                    code.add("return offset()", new Object[0]);
                }
                if (this.lastType.isPrimitive()) {
                    if (this.lastSize != -1) {
                        code.add(" + $L + ($L * $L)", new Object[]{StructFlyweightGenerator.offset(this.lastName), StructFlyweightGenerator.size(this.lastName), StructFlyweightGenerator.arraySize(this.lastName)});
                    } else if (this.lastSizeName == null) {
                        code.add(" + $L + $L", new Object[]{StructFlyweightGenerator.offset(this.lastName), StructFlyweightGenerator.size(this.lastName)});
                    }
                }
                code.add(";\n$]", new Object[0]);
                this.builder.addCode(code.build());
            }
            return this.builder.build();
        }
    }

    private static final class MemberAccessorGenerator
    extends ClassSpecMixinGenerator {
        private String anchorLimit;

        private MemberAccessorGenerator(ClassName thisType, TypeSpec.Builder builder) {
            super(thisType, builder);
        }

        public MemberAccessorGenerator addMember(String name, AstType type, TypeName typeName, AstType unsignedType, TypeName unsignedTypeName, AstByteOrder byteOrder, int size, String sizeName, Object defaultValue) {
            if (typeName.isPrimitive()) {
                if (size != -1 || sizeName != null) {
                    this.addIntegerArrayMember(name, typeName, unsignedTypeName, byteOrder, sizeName);
                } else {
                    this.addPrimitiveMember(name, type, typeName, unsignedType, unsignedTypeName, byteOrder);
                }
            } else {
                this.addNonPrimitiveMember(name, typeName, unsignedTypeName, sizeName, defaultValue);
            }
            return this;
        }

        private void addIntegerArrayMember(String name, TypeName type, TypeName unsignedType, AstByteOrder byteOrder, String sizeName) {
            TypeName generateType = unsignedType != null ? unsignedType : type;
            generateType = generateType == TypeName.LONG ? LONG_ITERATOR_CLASS_NAME : INT_ITERATOR_CLASS_NAME;
            this.builder.addMethod(MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(generateType).beginControlFlow("if ($L != null)", new Object[]{StructFlyweightGenerator.iterator(name)}).addStatement("$L.index = 0", new Object[]{StructFlyweightGenerator.iterator(name)}).endControlFlow().addStatement("return $L", new Object[]{StructFlyweightGenerator.iterator(name)}).build());
            if (sizeName != null) {
                this.anchorLimit = StructFlyweightGenerator.dynamicLimit(name);
            }
        }

        private void addNonPrimitiveMember(String name, TypeName type, TypeName unsignedType, String sizeName, Object defaultValue) {
            CodeBlock.Builder codeBlock = CodeBlock.builder();
            if (TypeNames.DIRECT_BUFFER_TYPE.equals((Object)type)) {
                MethodSpec.Builder consumerMethod = MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(IntBinaryOperator.class, "accessor", new Modifier[0]).returns(type);
                if (this.anchorLimit != null) {
                    consumerMethod.addStatement("accessor.applyAsInt($L + $L, $LRO.capacity())", new Object[]{this.anchorLimit, StructFlyweightGenerator.offset(name), name});
                } else {
                    consumerMethod.addStatement("accessor.applyAsInt(offset() + $L, $LRO.capacity())", new Object[]{StructFlyweightGenerator.offset(name), name});
                }
                this.builder.addMethod(consumerMethod.addStatement("return $LRO", new Object[]{name}).build());
            }
            TypeName returnType = type;
            if (defaultValue == AstAbstractMemberNode.NULL_DEFAULT && sizeName != null) {
                codeBlock.addStatement("return $L() == -1 ? null : $LRO", new Object[]{StructFlyweightGenerator.methodName(sizeName), name});
            } else if (StructFlyweightGenerator.isVarintType(type)) {
                codeBlock.addStatement("return $LRO.value()", new Object[]{name});
                returnType = StructFlyweightGenerator.isVarint32Type(type) ? TypeName.INT : TypeName.LONG;
            } else if (StructFlyweightGenerator.isVarbyteuint32Type(type)) {
                codeBlock.addStatement("return $LRO.value()", new Object[]{name});
                returnType = TypeName.INT;
            } else {
                codeBlock.addStatement("return $LRO", new Object[]{name});
            }
            this.anchorLimit = name + "RO." + (TypeNames.DIRECT_BUFFER_TYPE.equals((Object)type) ? "capacity()" : "limit()");
            this.builder.addMethod(MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(returnType).addCode(codeBlock.build()).build());
        }

        private void addPrimitiveMember(String name, AstType type, TypeName typeName, AstType unsignedType, TypeName unsignedTypeName, AstByteOrder byteOrder) {
            TypeName generateType = unsignedTypeName != null ? unsignedTypeName : typeName;
            CodeBlock.Builder codeBlock = CodeBlock.builder();
            String getterName = (String)GETTER_NAMES.get(typeName);
            if (getterName == null) {
                throw new IllegalStateException("member type not supported: " + typeName);
            }
            if (type.bits() == 24) {
                if (this.anchorLimit != null) {
                    codeBlock.addStatement("int offset = $L + $L", new Object[]{this.anchorLimit, StructFlyweightGenerator.offset(name)});
                } else {
                    codeBlock.addStatement("int offset = offset() + $L", new Object[]{StructFlyweightGenerator.offset(name)});
                }
                codeBlock.add("$[", new Object[0]).add("int bits = (buffer().getByte(offset) & 0xff) << 16 |", new Object[0]).add(" (buffer().getByte(offset + 1) & 0xff) << 8 |", new Object[0]).add(" (buffer().getByte(offset + 2) & 0xff)", new Object[0]).add(";\n$]", new Object[0]);
                if (byteOrder != AstByteOrder.NETWORK) {
                    codeBlock.beginControlFlow("if ($T.NATIVE_BYTE_ORDER != $T.BIG_ENDIAN)", new Object[]{TypeNames.BUFFER_UTIL_TYPE, ByteOrder.class});
                    codeBlock.addStatement("bits = Integer.reverseBytes(bits) >> 8", new Object[0]);
                    codeBlock.endControlFlow();
                }
                codeBlock.addStatement("return bits", new Object[0]);
            } else {
                codeBlock.add("$[", new Object[0]).add("return ", new Object[0]);
                if (generateType != typeName) {
                    codeBlock.add("($T)(", new Object[]{generateType});
                }
                if (this.anchorLimit != null) {
                    codeBlock.add("buffer().$L($L + $L", new Object[]{getterName, this.anchorLimit, StructFlyweightGenerator.offset(name)});
                } else {
                    codeBlock.add("buffer().$L(offset() + $L", new Object[]{getterName, StructFlyweightGenerator.offset(name)});
                }
                if (byteOrder == AstByteOrder.NETWORK && (typeName == TypeName.SHORT || typeName == TypeName.INT || typeName == TypeName.LONG)) {
                    codeBlock.add(", $T.BIG_ENDIAN", new Object[]{ByteOrder.class});
                }
                if (generateType != typeName) {
                    if (typeName == TypeName.BYTE) {
                        codeBlock.add(") & 0xFF)", new Object[0]);
                    } else if (typeName == TypeName.SHORT) {
                        codeBlock.add(") & 0xFFFF)", new Object[0]);
                    } else if (typeName == TypeName.INT) {
                        codeBlock.add(") & 0xFFFF_FFFFL)", new Object[0]);
                    } else if (typeName == TypeName.LONG) {
                        codeBlock.add(") & 0xFFFF_FFFF)", new Object[0]);
                    } else {
                        codeBlock.add(")", new Object[0]);
                    }
                } else {
                    codeBlock.add(")", new Object[0]);
                }
                codeBlock.add(";\n$]", new Object[0]);
            }
            this.builder.addMethod(MethodSpec.methodBuilder((String)StructFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(generateType).addCode(codeBlock.build()).build());
        }
    }

    private static final class MemberFieldGenerator
    extends ClassSpecMixinGenerator {
        private boolean generateIntPrimitiveIterator;
        private boolean generateLongPrimitiveIterator;

        private MemberFieldGenerator(ClassName thisType, TypeSpec.Builder builder) {
            super(thisType, builder);
        }

        public MemberFieldGenerator addMember(String name, TypeName type, TypeName unsignedType, int size, String sizeName, AstByteOrder byteOrder, Object defaultValue) {
            if (!type.isPrimitive()) {
                this.addNonPrimitiveMember(name, type, unsignedType, byteOrder, defaultValue);
            } else if (size != -1 || sizeName != null) {
                this.addIntegerArrayMember(name, type, unsignedType, sizeName != null);
            }
            return this;
        }

        private void addIntegerArrayMember(String name, TypeName type, TypeName unsignedType, boolean variableLength) {
            TypeName generateType;
            if (variableLength) {
                this.builder.addField(TypeName.INT, StructFlyweightGenerator.dynamicLimit(name), new Modifier[]{Modifier.PRIVATE});
            }
            ClassName iteratorClass = StructFlyweightGenerator.iteratorClass(this.thisType, type, unsignedType);
            this.builder.addField((TypeName)iteratorClass, StructFlyweightGenerator.iterator(name), new Modifier[]{Modifier.PRIVATE});
            TypeName typeName = generateType = unsignedType != null ? unsignedType : type;
            if (generateType == TypeName.LONG) {
                this.generateLongPrimitiveIterator = true;
            } else {
                this.generateIntPrimitiveIterator = true;
            }
        }

        private MemberFieldGenerator addNonPrimitiveMember(String name, TypeName type, TypeName unsignedType, AstByteOrder byteOrder, Object defaultValue) {
            String fieldRO = String.format("%sRO", name);
            FieldSpec.Builder fieldBuilder = FieldSpec.builder((TypeName)type, (String)fieldRO, (Modifier[])new Modifier[]{Modifier.PRIVATE});
            if (defaultValue == null) {
                fieldBuilder.addModifiers(new Modifier[]{Modifier.FINAL});
            }
            if (TypeNames.DIRECT_BUFFER_TYPE.equals((Object)type)) {
                fieldBuilder.initializer("new $T(new byte[0])", new Object[]{TypeNames.UNSAFE_BUFFER_TYPE});
            } else if (type instanceof ParameterizedTypeName) {
                ParameterizedTypeName parameterizedType = (ParameterizedTypeName)type;
                TypeName typeArgument = (TypeName)parameterizedType.typeArguments.get(0);
                fieldBuilder.initializer("new $T(new $T())", new Object[]{type, typeArgument});
            } else if (type instanceof ClassName && (StructFlyweightGenerator.isString16Type((ClassName)type) || StructFlyweightGenerator.isString32Type((ClassName)type)) && byteOrder == AstByteOrder.NETWORK) {
                fieldBuilder.initializer("new $T($T.BIG_ENDIAN)", new Object[]{type, ByteOrder.class});
            } else {
                fieldBuilder.initializer("new $T()", new Object[]{type});
            }
            this.builder.addField(fieldBuilder.build());
            return this;
        }

        @Override
        public TypeSpec.Builder build() {
            if (this.generateIntPrimitiveIterator) {
                this.generateIntPrimitiveIteratorInnerClass();
            }
            if (this.generateLongPrimitiveIterator) {
                this.generateLongPrimitiveIteratorInnerClass();
            }
            return super.build();
        }

        private void generateIntPrimitiveIteratorInnerClass() {
            ClassName intIterator = this.thisType.nestedClass("IntPrimitiveIterator");
            TypeSpec.Builder builder = TypeSpec.classBuilder((String)intIterator.simpleName()).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addSuperinterface((TypeName)INT_ITERATOR_CLASS_NAME);
            builder.addField(String.class, "fieldName", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            builder.addField(Integer.TYPE, "offset", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            builder.addField(Integer.TYPE, "fieldSize", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            builder.addField(Integer.TYPE, "count", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            builder.addField(IntUnaryOperator.class, "accessor", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            builder.addField(Integer.TYPE, "index", new Modifier[]{Modifier.PRIVATE});
            builder.addMethod(MethodSpec.constructorBuilder().addParameter(String.class, "fieldName", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "fieldSize", new Modifier[0]).addParameter(Integer.TYPE, "count", new Modifier[0]).addParameter(IntUnaryOperator.class, "accessor", new Modifier[0]).addStatement("this.fieldName = fieldName", new Object[0]).addStatement("this.offset = offset", new Object[0]).addStatement("this.fieldSize = fieldSize", new Object[0]).addStatement("this.count = count", new Object[0]).addStatement("this.accessor = accessor", new Object[0]).build());
            builder.addMethod(MethodSpec.methodBuilder((String)"hasNext").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addStatement("return index < count", new Object[0]).build());
            builder.addMethod(MethodSpec.methodBuilder((String)"nextInt").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).beginControlFlow("if (!hasNext())", new Object[0]).addStatement("throw new $T(fieldName + \": \" + index)", new Object[]{NoSuchElementException.class}).endControlFlow().addStatement("return accessor.applyAsInt(offset + fieldSize * index++)", new Object[0]).build());
            builder.addMethod(MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("StringBuffer result = new StringBuffer().append($S)", new Object[]{"["}).addStatement("boolean first = true", new Object[0]).beginControlFlow("while(hasNext())", new Object[0]).beginControlFlow("if (!first)", new Object[0]).addStatement("result.append($S)", new Object[]{", "}).endControlFlow().addStatement("result.append(nextInt())", new Object[0]).addStatement("first = false", new Object[0]).endControlFlow().addStatement("result.append($S)", new Object[]{"]"}).addStatement("return result.toString()", new Object[0]).build());
            this.builder.addType(builder.build());
        }

        private void generateLongPrimitiveIteratorInnerClass() {
            ClassName longIterator = this.thisType.nestedClass("LongPrimitiveIterator");
            TypeSpec.Builder builder = TypeSpec.classBuilder((String)longIterator.simpleName()).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addSuperinterface((TypeName)LONG_ITERATOR_CLASS_NAME);
            builder.addField(String.class, "fieldName", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            builder.addField(Integer.TYPE, "offset", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            builder.addField(Integer.TYPE, "fieldSize", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            builder.addField(Integer.TYPE, "count", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            builder.addField(IntToLongFunction.class, "accessor", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            builder.addField(Integer.TYPE, "index", new Modifier[]{Modifier.PRIVATE});
            builder.addMethod(MethodSpec.constructorBuilder().addParameter(String.class, "fieldName", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "fieldSize", new Modifier[0]).addParameter(Integer.TYPE, "count", new Modifier[0]).addParameter(IntToLongFunction.class, "accessor", new Modifier[0]).addStatement("this.fieldName = fieldName", new Object[0]).addStatement("this.offset = offset", new Object[0]).addStatement("this.fieldSize = fieldSize", new Object[0]).addStatement("this.count = count", new Object[0]).addStatement("this.accessor = accessor", new Object[0]).build());
            builder.addMethod(MethodSpec.methodBuilder((String)"hasNext").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addStatement("return index < count", new Object[0]).build());
            builder.addMethod(MethodSpec.methodBuilder((String)"nextLong").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Long.TYPE).beginControlFlow("if (!hasNext())", new Object[0]).addStatement("throw new $T(fieldName + \": \" + index)", new Object[]{NoSuchElementException.class}).endControlFlow().addStatement("return accessor.applyAsLong(offset + fieldSize * index++)", new Object[0]).build());
            builder.addMethod(MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("StringBuffer result = new StringBuffer().append($S)", new Object[]{"["}).addStatement("boolean first = true", new Object[0]).beginControlFlow("while(hasNext())", new Object[0]).beginControlFlow("if (!first)", new Object[0]).addStatement("result.append($S)", new Object[]{", "}).endControlFlow().addStatement("result.append(nextLong())", new Object[0]).addStatement("first = false", new Object[0]).endControlFlow().addStatement("result.append($S)", new Object[]{"]"}).addStatement("return result.toString()", new Object[0]).build());
            this.builder.addType(builder.build());
        }
    }

    private static final class MemberOffsetConstantGenerator
    extends ClassSpecMixinGenerator {
        private String previousName;
        private int previousSize = -1;

        private MemberOffsetConstantGenerator(ClassName thisType, TypeSpec.Builder builder) {
            super(thisType, builder);
        }

        public MemberOffsetConstantGenerator addMember(String name, TypeName type, TypeName unsignedType, int size, String sizeName) {
            String initializer = this.previousName == null ? "0" : (this.previousSize == -1 ? String.format("%s + %s", StructFlyweightGenerator.offset(this.previousName), StructFlyweightGenerator.size(this.previousName)) : String.format("%s + (%s * %s)", StructFlyweightGenerator.offset(this.previousName), StructFlyweightGenerator.size(this.previousName), StructFlyweightGenerator.arraySize(this.previousName)));
            this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)StructFlyweightGenerator.offset(name), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(initializer, new Object[0]).build());
            boolean isFixedSize = type.isPrimitive() && sizeName == null;
            this.previousName = isFixedSize ? name : null;
            this.previousSize = size;
            return this;
        }
    }

    private static final class MemberSizeConstantGenerator
    extends ClassSpecMixinGenerator {
        private MemberSizeConstantGenerator(ClassName thisType, TypeSpec.Builder builder) {
            super(thisType, builder);
        }

        public MemberSizeConstantGenerator addMember(String name, AstType type, TypeName typeName, AstType unsignedType, TypeName unsignedTypeName, int size) {
            if (typeName.isPrimitive()) {
                this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)StructFlyweightGenerator.size(name), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$L", new Object[]{type.bits() >> 3}).build());
                if (size != -1) {
                    this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)StructFlyweightGenerator.arraySize(name), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$L", new Object[]{Integer.toString(size)}).build());
                }
            }
            return this;
        }
    }

    private static final class TypeIdGenerator
    extends ClassSpecMixinGenerator {
        private int typeId;

        private TypeIdGenerator(ClassName thisType, TypeSpec.Builder builder) {
            super(thisType, builder);
        }

        public void typeId(int typeId) {
            this.typeId = typeId;
        }

        @Override
        public TypeSpec.Builder build() {
            if (this.typeId != 0) {
                this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)"TYPE_ID", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$L", new Object[]{String.format("0x%08x", this.typeId)}).build());
                this.builder.addMethod(MethodSpec.methodBuilder((String)"typeId").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return TYPE_ID", new Object[0]).build());
            }
            return this.builder;
        }
    }
}

