/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.ast.parse;

import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.antlr.v4.runtime.RuleContext;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstByteOrder;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstEnumNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstListMemberNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstListNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstMapNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstScopeNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstSpecificationNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstStructMemberNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstStructNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstType;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstTypedefNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstUnionCaseNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstUnionNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstValueNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstVariantCaseNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstVariantNode;
import org.reaktivity.nukleus.maven.plugin.internal.parser.NukleusBaseVisitor;
import org.reaktivity.nukleus.maven.plugin.internal.parser.NukleusParser;

public final class AstParser
extends NukleusBaseVisitor<AstNode> {
    private final Deque<AstScopeNode.Builder> scopeBuilders = new LinkedList<AstScopeNode.Builder>();
    private final Deque<String> qualifiedPrefixes = new LinkedList<String>();
    private final Map<String, AstType> astTypesByQualifiedName = new HashMap<String, AstType>();
    private final Map<AstType, Function<RuleContext, Object>> parserByType;
    private AstSpecificationNode.Builder specificationBuilder;
    private AstStructNode.Builder structBuilder;
    private AstStructMemberNode.Builder memberBuilder;
    private AstUnionNode.Builder unionBuilder;
    private AstUnionCaseNode.Builder caseBuilder;
    private AstByteOrder byteOrder = AstByteOrder.NATIVE;

    public AstParser() {
        this.parserByType = AstParser.initParserByType();
    }

    private static Map<AstType, Function<RuleContext, Object>> initParserByType() {
        HashMap<AstType, Function<RuleContext, Object>> valueTypeByName = new HashMap<AstType, Function<RuleContext, Object>>();
        valueTypeByName.put(AstType.UINT8, AstParser::parseShort);
        valueTypeByName.put(AstType.UINT16, AstParser::parseInt);
        valueTypeByName.put(AstType.UINT24, AstParser::parseMedium);
        valueTypeByName.put(AstType.UINT32, AstParser::parseLong);
        valueTypeByName.put(AstType.UINT64, AstParser::parseLong);
        valueTypeByName.put(AstType.INT8, AstParser::parseByte);
        valueTypeByName.put(AstType.INT16, AstParser::parseShort);
        valueTypeByName.put(AstType.INT24, AstParser::parseMedium);
        valueTypeByName.put(AstType.INT32, AstParser::parseInt);
        valueTypeByName.put(AstType.INT64, AstParser::parseLong);
        valueTypeByName.put(AstType.STRING8, AstParser::parseString);
        valueTypeByName.put(AstType.STRING16, AstParser::parseString);
        valueTypeByName.put(AstType.STRING32, AstParser::parseString);
        return valueTypeByName;
    }

    @Override
    public AstSpecificationNode visitSpecification(NukleusParser.SpecificationContext ctx) {
        this.specificationBuilder = new AstSpecificationNode.Builder();
        super.visitSpecification(ctx);
        return this.specificationBuilder.build();
    }

    @Override
    public AstScopeNode visitScope(NukleusParser.ScopeContext ctx) {
        String name = ctx.ID().getText();
        AstScopeNode.Builder scopeBuilder = new AstScopeNode.Builder();
        scopeBuilder.depth(this.scopeBuilders.size());
        scopeBuilder.name(name);
        String qualifiedName = name;
        if (!this.qualifiedPrefixes.isEmpty()) {
            String qualifiedPrefix = this.qualifiedPrefixes.peekFirst();
            qualifiedName = String.format("%s%s", qualifiedPrefix, name);
        }
        this.qualifiedPrefixes.addFirst(String.format("%s::", qualifiedName));
        AstByteOrder byteOrder = this.byteOrder;
        this.scopeBuilders.offer(scopeBuilder);
        super.visitScope(ctx);
        this.scopeBuilders.pollLast();
        this.qualifiedPrefixes.removeFirst();
        this.byteOrder = byteOrder;
        AstScopeNode.Builder parent = this.scopeBuilders.peekLast();
        if (parent != null) {
            AstScopeNode scopeNode = scopeBuilder.build();
            parent.scope(scopeNode);
            return scopeNode;
        }
        if (this.specificationBuilder != null) {
            AstScopeNode scopeNode = scopeBuilder.build();
            this.specificationBuilder.scope(scopeNode);
            return scopeNode;
        }
        return scopeBuilder.build();
    }

    @Override
    public AstNode visitOptionByteOrder(NukleusParser.OptionByteOrderContext ctx) {
        if (ctx.KW_NATIVE() != null) {
            this.byteOrder = AstByteOrder.NATIVE;
        } else if (ctx.KW_NETWORK() != null) {
            this.byteOrder = AstByteOrder.NETWORK;
        } else {
            throw new IllegalStateException("Unexpected byte order option");
        }
        return (AstNode)super.visitOptionByteOrder(ctx);
    }

    @Override
    public AstEnumNode visitEnum_type(NukleusParser.Enum_typeContext ctx) {
        AstEnumNode.Builder enumBuilder = new EnumVisitor().visitEnum_type(ctx);
        AstEnumNode enumeration = enumBuilder.build();
        AstScopeNode.Builder scopeBuilder = this.scopeBuilders.peekLast();
        if (scopeBuilder != null) {
            scopeBuilder.enumeration(enumeration);
        }
        return enumeration;
    }

    @Override
    public AstVariantNode visitVariant_type(NukleusParser.Variant_typeContext ctx) {
        AstVariantNode.Builder variantBuilder = new VariantVisitor().visitVariant_type(ctx);
        AstVariantNode variant = variantBuilder.build();
        AstScopeNode.Builder scopeBuilder = this.scopeBuilders.peekLast();
        if (scopeBuilder != null) {
            scopeBuilder.variant(variant);
        }
        return variant;
    }

    @Override
    public AstTypedefNode visitTypedef_type(NukleusParser.Typedef_typeContext ctx) {
        AstTypedefNode.Builder typeDefBuilder = new AstTypedefNode.Builder();
        String prefix = this.qualifiedPrefixes.peekFirst();
        String typedefName = ctx.typedeftype.getText();
        String originalTypeName = ctx.originaltype.getText();
        String qualifiedTypedefName = String.format("%s%s", prefix, typedefName);
        this.astTypesByQualifiedName.put(qualifiedTypedefName, AstType.dynamicType(qualifiedTypedefName));
        typeDefBuilder.name(typedefName);
        AstType originalType = this.astTypesByQualifiedName.get(originalTypeName);
        if (originalType == null) {
            originalType = this.qualifiedPrefixes.stream().map(qp -> String.format("%s%s", qp, originalTypeName)).map(this.astTypesByQualifiedName::get).filter(Objects::nonNull).findFirst().orElse(AstType.dynamicType(originalTypeName));
        }
        typeDefBuilder.originalType(originalType);
        AstTypedefNode typeDef = typeDefBuilder.build();
        AstScopeNode.Builder scopeBuilder = this.scopeBuilders.peekLast();
        if (scopeBuilder != null) {
            scopeBuilder.typedef(typeDef);
        }
        return typeDef;
    }

    @Override
    public AstNode visitMap_type(NukleusParser.Map_typeContext ctx) {
        AstMapNode.Builder mapBuilder = new AstMapNode.Builder();
        String prefix = this.qualifiedPrefixes.peekFirst();
        String mapName = ctx.ID().getText();
        String templateTypeName = ctx.templatetype.getText();
        String keyTypeName = ctx.keytype.getText();
        String valueTypeName = ctx.valuetype.getText();
        String qualifiedMapName = String.format("%s%s", prefix, mapName);
        this.astTypesByQualifiedName.put(qualifiedMapName, AstType.dynamicType(qualifiedMapName));
        mapBuilder.name(mapName);
        AstType templateType = Objects.requireNonNullElse(this.astTypesByQualifiedName.get(templateTypeName), this.lookUpAstType(templateTypeName));
        AstType keyType = Objects.requireNonNullElse(this.astTypesByQualifiedName.get(keyTypeName), this.lookUpAstType(keyTypeName));
        AstType valueType = Objects.requireNonNullElse(this.astTypesByQualifiedName.get(valueTypeName), this.lookUpAstType(valueTypeName));
        mapBuilder.templateMapType(templateType);
        mapBuilder.keyType(keyType);
        mapBuilder.valueType(valueType);
        AstMapNode map = mapBuilder.build();
        AstScopeNode.Builder scopeBuilder = this.scopeBuilders.peekLast();
        if (scopeBuilder != null) {
            scopeBuilder.map(map);
        }
        return map;
    }

    @Override
    public AstListNode visitList_type(NukleusParser.List_typeContext ctx) {
        AstListNode.Builder listBuilder = new ListVisitor().visitList_type(ctx);
        AstListNode list = listBuilder.build();
        AstScopeNode.Builder scopeBuilder = this.scopeBuilders.peekLast();
        if (scopeBuilder != null) {
            scopeBuilder.list(list);
        }
        return list;
    }

    @Override
    public AstStructNode visitStruct_type(NukleusParser.Struct_typeContext ctx) {
        this.structBuilder = new AstStructNode.Builder();
        String structName = ctx.ID().getText();
        String prefix = this.qualifiedPrefixes.peekFirst();
        String qualifiedName = String.format("%s%s", prefix, structName);
        this.astTypesByQualifiedName.put(qualifiedName, AstType.dynamicType(qualifiedName));
        this.structBuilder.name(structName);
        NukleusParser.Scoped_nameContext scopedName = ctx.scoped_name();
        if (scopedName != null) {
            String superTypeName = scopedName.getText();
            AstType astTypeName = this.astTypesByQualifiedName.get(superTypeName);
            if (astTypeName == null) {
                Iterator<String> prefixIterator = this.qualifiedPrefixes.iterator();
                String currentPrefix = this.qualifiedPrefixes.peekFirst();
                while (prefixIterator.hasNext() && this.astTypesByQualifiedName.get(String.format("%s%s", currentPrefix, superTypeName)) == null) {
                    currentPrefix = prefixIterator.next();
                }
                this.structBuilder.supertype(this.astTypesByQualifiedName.getOrDefault(String.format("%s%s", currentPrefix, superTypeName), AstType.dynamicType(superTypeName)));
            } else {
                this.structBuilder.supertype(astTypeName);
            }
        }
        super.visitStruct_type(ctx);
        AstScopeNode.Builder scopeBuilder = this.scopeBuilders.peekLast();
        if (scopeBuilder != null) {
            AstStructNode struct = this.structBuilder.build();
            scopeBuilder.struct(struct);
            return struct;
        }
        return this.structBuilder.build();
    }

    @Override
    public AstStructMemberNode visitMember(NukleusParser.MemberContext ctx) {
        this.memberBuilder = new AstStructMemberNode.Builder();
        this.memberBuilder.byteOrder(this.byteOrder);
        super.visitMember(ctx);
        AstStructMemberNode member = this.memberBuilder.build();
        this.memberBuilder = null;
        if (this.caseBuilder != null) {
            this.caseBuilder.member(member);
        } else if (this.structBuilder != null) {
            this.structBuilder.member(member);
        }
        return member;
    }

    @Override
    public AstStructMemberNode visitUnbounded_member(NukleusParser.Unbounded_memberContext ctx) {
        this.memberBuilder = new AstStructMemberNode.Builder();
        super.visitUnbounded_member(ctx);
        AstStructMemberNode member = this.memberBuilder.build();
        this.memberBuilder = null;
        if (this.caseBuilder != null) {
            this.caseBuilder.member(member);
        } else if (this.structBuilder != null) {
            this.structBuilder.member(member);
        }
        return member;
    }

    @Override
    public AstNode visitUint_member_with_default(NukleusParser.Uint_member_with_defaultContext ctx) {
        this.memberBuilder.defaultValue(AstParser.parseInt((RuleContext)ctx.uint_literal()));
        return (AstNode)super.visitUint_member_with_default(ctx);
    }

    @Override
    public AstNode visitInt_member_with_default(NukleusParser.Int_member_with_defaultContext ctx) {
        this.memberBuilder.defaultValue(AstParser.parseInt(ctx.int_literal()));
        return (AstNode)super.visitInt_member_with_default(ctx);
    }

    @Override
    public AstNode visitString_member_with_default(NukleusParser.String_member_with_defaultContext ctx) {
        this.memberBuilder.defaultValue(AstParser.parseString((RuleContext)ctx.string_literal()));
        return (AstNode)super.visitString_member_with_default(ctx);
    }

    @Override
    public AstNode visitString_member_with_null_default(NukleusParser.String_member_with_null_defaultContext ctx) {
        this.memberBuilder.defaultToNull();
        return (AstNode)super.visitString_member_with_null_default(ctx);
    }

    @Override
    public AstNode visitEnum_member_with_default(NukleusParser.Enum_member_with_defaultContext ctx) {
        this.memberBuilder.defaultValue(ctx.ID().getText());
        return (AstNode)super.visitEnum_member_with_default(ctx);
    }

    @Override
    public AstNode visitInteger_array_member(NukleusParser.Integer_array_memberContext ctx) {
        if (ctx.positive_int_const() != null) {
            this.memberBuilder.size(Integer.parseInt(ctx.positive_int_const().getText()));
        } else if (ctx.ID() != null) {
            this.memberBuilder.sizeName(ctx.ID().getText());
        }
        return (AstNode)super.visitInteger_array_member(ctx);
    }

    @Override
    public AstNode visitArray_member(NukleusParser.Array_memberContext ctx) {
        this.memberBuilder.type(AstType.ARRAY32);
        return (AstNode)super.visitArray_member(ctx);
    }

    @Override
    public AstNode visitDefault_null(NukleusParser.Default_nullContext ctx) {
        this.memberBuilder.defaultToNull();
        return (AstNode)super.visitDefault_null(ctx);
    }

    @Override
    public AstUnionNode visitUnion_type(NukleusParser.Union_typeContext ctx) {
        this.unionBuilder = new AstUnionNode.Builder();
        String prefix = this.qualifiedPrefixes.peekFirst();
        String unionName = ctx.ID().getText();
        String qualifiedUnionName = String.format("%s%s", prefix, unionName);
        this.astTypesByQualifiedName.put(qualifiedUnionName, AstType.dynamicType(qualifiedUnionName));
        this.unionBuilder.name(unionName);
        NukleusParser.Scoped_nameContext kindType = ctx.kindtype;
        if (kindType != null) {
            String kindTypeName = kindType.getText();
            AstType astTypeName = Objects.requireNonNullElse(this.astTypesByQualifiedName.get(kindTypeName), this.lookUpAstType(kindTypeName));
            this.unionBuilder.kindType(astTypeName);
        } else {
            this.unionBuilder.kindType(AstType.UINT8);
        }
        NukleusParser.Scoped_nameContext superType = ctx.supertype;
        if (superType != null) {
            String superTypeName = superType.getText();
            AstType astTypeName = Objects.requireNonNullElse(this.astTypesByQualifiedName.get(superTypeName), this.lookUpAstType(superTypeName));
            this.unionBuilder.superType(astTypeName);
        }
        super.visitUnion_type(ctx);
        AstUnionNode union = this.unionBuilder.build();
        this.unionBuilder = null;
        AstScopeNode.Builder scopeBuilder = this.scopeBuilders.peekLast();
        if (scopeBuilder != null) {
            scopeBuilder.union(union);
        }
        return union;
    }

    @Override
    public AstUnionCaseNode visitCase_member(NukleusParser.Case_memberContext ctx) {
        this.caseBuilder = new AstUnionCaseNode.Builder().value(ctx.uint_literal() != null ? Integer.decode(ctx.uint_literal().getText()) : ctx.ID().getText());
        super.visitCase_member(ctx);
        AstUnionCaseNode caseN = this.caseBuilder.build();
        this.caseBuilder = null;
        if (this.unionBuilder != null) {
            this.unionBuilder.caseN(caseN);
        }
        return caseN;
    }

    @Override
    public AstNode visitDeclarator(NukleusParser.DeclaratorContext ctx) {
        this.memberBuilder.name(ctx.ID().toString());
        return (AstNode)super.visitDeclarator(ctx);
    }

    @Override
    public AstNode visitVarint_array_member(NukleusParser.Varint_array_memberContext ctx) {
        this.memberBuilder.type(AstType.ARRAY32);
        return (AstNode)super.visitVarint_array_member(ctx);
    }

    @Override
    public AstNode visitVarbyteuint32_type(NukleusParser.Varbyteuint32_typeContext ctx) {
        this.memberBuilder.type(AstType.VARBYTEUINT32);
        return (AstNode)super.visitVarbyteuint32_type(ctx);
    }

    @Override
    public AstNode visitVarint32_type(NukleusParser.Varint32_typeContext ctx) {
        this.memberBuilder.type(AstType.VARINT32);
        return (AstNode)super.visitVarint32_type(ctx);
    }

    @Override
    public AstNode visitVarint64_type(NukleusParser.Varint64_typeContext ctx) {
        this.memberBuilder.type(AstType.VARINT64);
        return (AstNode)super.visitVarint64_type(ctx);
    }

    @Override
    public AstNode visitInt64_type(NukleusParser.Int64_typeContext ctx) {
        this.memberBuilder.type(AstType.INT64);
        return (AstNode)super.visitInt64_type(ctx);
    }

    @Override
    public AstNode visitInt32_type(NukleusParser.Int32_typeContext ctx) {
        this.memberBuilder.type(AstType.INT32);
        return (AstNode)super.visitInt32_type(ctx);
    }

    @Override
    public AstNode visitInt24_type(NukleusParser.Int24_typeContext ctx) {
        this.memberBuilder.type(AstType.INT24);
        return (AstNode)super.visitInt24_type(ctx);
    }

    @Override
    public AstNode visitInt16_type(NukleusParser.Int16_typeContext ctx) {
        this.memberBuilder.type(AstType.INT16);
        return (AstNode)super.visitInt16_type(ctx);
    }

    @Override
    public AstNode visitInt8_type(NukleusParser.Int8_typeContext ctx) {
        this.memberBuilder.type(AstType.INT8);
        return (AstNode)super.visitInt8_type(ctx);
    }

    @Override
    public AstNode visitUint64_type(NukleusParser.Uint64_typeContext ctx) {
        this.memberBuilder.type(AstType.UINT64);
        return (AstNode)super.visitUint64_type(ctx);
    }

    @Override
    public AstNode visitUint32_type(NukleusParser.Uint32_typeContext ctx) {
        this.memberBuilder.type(AstType.UINT32);
        return (AstNode)super.visitUint32_type(ctx);
    }

    @Override
    public AstNode visitUint16_type(NukleusParser.Uint16_typeContext ctx) {
        this.memberBuilder.type(AstType.UINT16);
        return (AstNode)super.visitUint16_type(ctx);
    }

    @Override
    public AstNode visitUint24_type(NukleusParser.Uint24_typeContext ctx) {
        this.memberBuilder.type(AstType.UINT24);
        return (AstNode)super.visitUint24_type(ctx);
    }

    @Override
    public AstNode visitUint8_type(NukleusParser.Uint8_typeContext ctx) {
        this.memberBuilder.type(AstType.UINT8);
        return (AstNode)super.visitUint8_type(ctx);
    }

    @Override
    public AstNode visitString8_type(NukleusParser.String8_typeContext ctx) {
        this.memberBuilder.type(AstType.STRING8);
        return (AstNode)super.visitString8_type(ctx);
    }

    @Override
    public AstNode visitString16_type(NukleusParser.String16_typeContext ctx) {
        this.memberBuilder.type(AstType.STRING16);
        return (AstNode)super.visitString16_type(ctx);
    }

    @Override
    public AstNode visitString32_type(NukleusParser.String32_typeContext ctx) {
        this.memberBuilder.type(AstType.STRING32);
        return (AstNode)super.visitString32_type(ctx);
    }

    @Override
    public AstNode visitOctets_type(NukleusParser.Octets_typeContext ctx) {
        this.memberBuilder.type(AstType.OCTETS);
        if (ctx.positive_int_const() != null) {
            this.memberBuilder.size(Integer.parseInt(ctx.positive_int_const().getText()));
        } else if (ctx.ID() != null) {
            this.memberBuilder.sizeName(ctx.ID().getText());
        }
        return (AstNode)super.visitOctets_type(ctx);
    }

    @Override
    public AstNode visitUnbounded_octets_type(NukleusParser.Unbounded_octets_typeContext ctx) {
        this.memberBuilder.type(AstType.OCTETS);
        return (AstNode)super.visitUnbounded_octets_type(ctx);
    }

    @Override
    public AstNode visitScoped_name(NukleusParser.Scoped_nameContext ctx) {
        String typeName = ctx.getText();
        if (this.memberBuilder != null) {
            AstType astTypeName = this.astTypesByQualifiedName.get(typeName);
            if (astTypeName == null) {
                astTypeName = this.qualifiedPrefixes.stream().map(qp -> String.format("%s%s", qp, typeName)).map(this.astTypesByQualifiedName::get).filter(Objects::nonNull).findFirst().orElse(AstType.dynamicType(typeName));
            }
            this.memberBuilder.type(astTypeName);
        }
        return (AstNode)super.visitScoped_name(ctx);
    }

    @Override
    public AstNode visitType_id(NukleusParser.Type_idContext ctx) {
        if (this.structBuilder != null) {
            this.structBuilder.typeId(AstParser.parseInt((RuleContext)ctx.uint_literal()));
        }
        return (AstNode)super.visitType_id(ctx);
    }

    private static byte parseByte(RuleContext ctx) {
        return AstParser.parseByte(ctx.getText());
    }

    private static byte parseByte(String text) {
        return Byte.decode(text);
    }

    private static short parseShort(RuleContext ctx) {
        return AstParser.parseShort(ctx.getText());
    }

    private static short parseShort(String text) {
        return Short.decode(text);
    }

    private static int parseMedium(RuleContext ctx) {
        String text = ctx.getText();
        int value = AstParser.parseInt(text);
        if ((value & 0x7F000000) != 0) {
            throw new NumberFormatException(String.format("Value out of range for medium int (%s)", text));
        }
        return ctx != null ? value : 0;
    }

    private static int parseInt(NukleusParser.Int_literalContext ctx) {
        return ctx != null ? AstParser.parseInt(ctx.getText()) : 0;
    }

    private static int parseInt(RuleContext ctx) {
        return ctx != null ? AstParser.parseInt(ctx.getText()) : 0;
    }

    private static int parseInt(String text) {
        return Integer.decode(text);
    }

    private static long parseLong(RuleContext ctx) {
        return AstParser.parseLong(ctx.getText());
    }

    private static long parseLong(String text) {
        return Long.decode(text.substring(0, text.length() - 1));
    }

    private static String parseString(RuleContext ctx) {
        return ctx.getText();
    }

    private AstType lookUpAstType(String name) {
        return this.qualifiedPrefixes.stream().map(qp -> String.format("%s%s", qp, name)).map(this.astTypesByQualifiedName::get).filter(Objects::nonNull).findFirst().orElse(AstType.dynamicType(name));
    }

    public final class EnumVisitor
    extends NukleusBaseVisitor<AstEnumNode.Builder> {
        private final AstEnumNode.Builder enumBuilder = new AstEnumNode.Builder();
        private AstValueNode.Builder valueBuilder;

        @Override
        public AstEnumNode.Builder visitEnum_type(NukleusParser.Enum_typeContext ctx) {
            String prefix = (String)AstParser.this.qualifiedPrefixes.peekFirst();
            String enumName = ctx.ID().getText();
            String qualifiedEnumName = String.format("%s%s", prefix, enumName);
            AstParser.this.astTypesByQualifiedName.put(qualifiedEnumName, AstType.dynamicType(qualifiedEnumName));
            this.enumBuilder.name(enumName);
            return (AstEnumNode.Builder)super.visitEnum_type(ctx);
        }

        protected AstEnumNode.Builder defaultResult() {
            return this.enumBuilder;
        }

        @Override
        public AstEnumNode.Builder visitInt8_type(NukleusParser.Int8_typeContext ctx) {
            this.enumBuilder.valueType(AstType.INT8);
            return (AstEnumNode.Builder)super.visitInt8_type(ctx);
        }

        @Override
        public AstEnumNode.Builder visitInt16_type(NukleusParser.Int16_typeContext ctx) {
            this.enumBuilder.valueType(AstType.INT16);
            return (AstEnumNode.Builder)super.visitInt16_type(ctx);
        }

        @Override
        public AstEnumNode.Builder visitInt32_type(NukleusParser.Int32_typeContext ctx) {
            this.enumBuilder.valueType(AstType.INT32);
            return (AstEnumNode.Builder)super.visitInt32_type(ctx);
        }

        @Override
        public AstEnumNode.Builder visitInt64_type(NukleusParser.Int64_typeContext ctx) {
            this.enumBuilder.valueType(AstType.INT64);
            return (AstEnumNode.Builder)super.visitInt64_type(ctx);
        }

        @Override
        public AstEnumNode.Builder visitUint8_type(NukleusParser.Uint8_typeContext ctx) {
            this.enumBuilder.valueType(AstType.UINT8);
            return (AstEnumNode.Builder)super.visitUint8_type(ctx);
        }

        @Override
        public AstEnumNode.Builder visitUint16_type(NukleusParser.Uint16_typeContext ctx) {
            this.enumBuilder.valueType(AstType.UINT16);
            return (AstEnumNode.Builder)super.visitUint16_type(ctx);
        }

        @Override
        public AstEnumNode.Builder visitUint32_type(NukleusParser.Uint32_typeContext ctx) {
            this.enumBuilder.valueType(AstType.UINT32);
            return (AstEnumNode.Builder)super.visitUint32_type(ctx);
        }

        @Override
        public AstEnumNode.Builder visitUint64_type(NukleusParser.Uint64_typeContext ctx) {
            this.enumBuilder.valueType(AstType.UINT64);
            return (AstEnumNode.Builder)super.visitUint64_type(ctx);
        }

        @Override
        public AstEnumNode.Builder visitString8_type(NukleusParser.String8_typeContext ctx) {
            this.enumBuilder.valueType(AstType.STRING8);
            return (AstEnumNode.Builder)super.visitString8_type(ctx);
        }

        @Override
        public AstEnumNode.Builder visitString16_type(NukleusParser.String16_typeContext ctx) {
            this.enumBuilder.valueType(AstType.STRING16);
            return (AstEnumNode.Builder)super.visitString16_type(ctx);
        }

        @Override
        public AstEnumNode.Builder visitString32_type(NukleusParser.String32_typeContext ctx) {
            this.enumBuilder.valueType(AstType.STRING32);
            return (AstEnumNode.Builder)super.visitString32_type(ctx);
        }

        @Override
        public AstEnumNode.Builder visitDeclarator(NukleusParser.DeclaratorContext ctx) {
            String enumType = ctx.ID().getText();
            AstType astEnumType = Objects.requireNonNullElse((AstType)AstParser.this.astTypesByQualifiedName.get(enumType), AstParser.this.lookUpAstType(enumType));
            this.enumBuilder.valueType(astEnumType);
            return (AstEnumNode.Builder)super.visitDeclarator(ctx);
        }

        @Override
        public AstEnumNode.Builder visitEnum_value(NukleusParser.Enum_valueContext ctx) {
            this.valueBuilder = new AstValueNode.Builder().name(ctx.ID().getText()).ordinal(this.enumBuilder.size());
            AstEnumNode.Builder result = (AstEnumNode.Builder)super.visitEnum_value(ctx);
            AstValueNode value = this.valueBuilder.build();
            this.enumBuilder.value(value);
            this.valueBuilder = null;
            return result;
        }

        @Override
        public AstEnumNode.Builder visitInt_literal(NukleusParser.Int_literalContext ctx) {
            return this.visitLiteral((RuleContext)ctx);
        }

        @Override
        public AstEnumNode.Builder visitUint_literal(NukleusParser.Uint_literalContext ctx) {
            return this.visitLiteral((RuleContext)ctx);
        }

        @Override
        public AstEnumNode.Builder visitString_literal(NukleusParser.String_literalContext ctx) {
            return this.visitLiteral((RuleContext)ctx);
        }

        private AstEnumNode.Builder visitLiteral(RuleContext ctx) {
            Function parser = (Function)AstParser.this.parserByType.get(this.enumBuilder.valueType());
            String parsed = parser != null ? parser.apply(ctx) : ctx.getText();
            this.valueBuilder.value(parsed);
            return this.defaultResult();
        }
    }

    public final class VariantVisitor
    extends NukleusBaseVisitor<AstVariantNode.Builder> {
        private final AstVariantNode.Builder variantBuilder = new AstVariantNode.Builder();

        public VariantVisitor() {
            this.variantBuilder.byteOrder(AstParser.this.byteOrder);
        }

        @Override
        public AstVariantNode.Builder visitVariant_type(NukleusParser.Variant_typeContext ctx) {
            String prefix = (String)AstParser.this.qualifiedPrefixes.peekFirst();
            String variantName = ctx.ID().getText();
            String qualifiedVariantName = String.format("%s%s", prefix, variantName);
            AstParser.this.astTypesByQualifiedName.put(qualifiedVariantName, AstType.dynamicType(qualifiedVariantName));
            this.variantBuilder.name(variantName);
            return (AstVariantNode.Builder)super.visitVariant_type(ctx);
        }

        @Override
        public AstVariantNode.Builder visitKind(NukleusParser.KindContext ctx) {
            VariantKindVisitor variantKindVisitor = new VariantKindVisitor(this.variantBuilder);
            return variantKindVisitor.visitKind(ctx);
        }

        @Override
        public AstVariantNode.Builder visitVariant_of_type(NukleusParser.Variant_of_typeContext ctx) {
            return (AstVariantNode.Builder)super.visitVariant_of_type(ctx);
        }

        @Override
        public AstVariantNode.Builder visitVariant_case_member(NukleusParser.Variant_case_memberContext ctx) {
            AstVariantCaseNode.Builder variantCaseNodeBuilder = new VariantCaseVisitor().visitVariant_case_member(ctx);
            AstVariantCaseNode caseN = variantCaseNodeBuilder.build();
            this.variantBuilder.caseN(caseN);
            return this.variantBuilder;
        }

        @Override
        public AstVariantNode.Builder visitVariant_case_member_no_type(NukleusParser.Variant_case_member_no_typeContext ctx) {
            AstVariantCaseNode.Builder variantCaseNodeBuilder = new VariantCaseVisitor().visitVariant_case_member_no_type(ctx);
            AstVariantCaseNode caseN = variantCaseNodeBuilder.build();
            this.variantBuilder.caseN(caseN);
            return this.variantBuilder;
        }

        @Override
        public AstVariantNode.Builder visitVariant_case_member_without_of(NukleusParser.Variant_case_member_without_ofContext ctx) {
            AstVariantCaseNode.Builder variantCaseNodeBuilder = new VariantCaseVisitor().visitVariant_case_member_without_of(ctx);
            AstVariantCaseNode caseN = variantCaseNodeBuilder.build();
            this.variantBuilder.caseN(caseN);
            return this.variantBuilder;
        }

        @Override
        public AstVariantNode.Builder visitString_type(NukleusParser.String_typeContext ctx) {
            this.variantBuilder.of(AstType.STRING);
            return (AstVariantNode.Builder)super.visitString_type(ctx);
        }

        @Override
        public AstVariantNode.Builder visitList_keyword(NukleusParser.List_keywordContext ctx) {
            this.variantBuilder.of(AstType.LIST);
            return (AstVariantNode.Builder)super.visitList_keyword(ctx);
        }

        @Override
        public AstVariantNode.Builder visitArray_keyword(NukleusParser.Array_keywordContext ctx) {
            this.variantBuilder.of(AstType.ARRAY);
            return (AstVariantNode.Builder)super.visitArray_keyword(ctx);
        }

        @Override
        public AstVariantNode.Builder visitMap_keyword(NukleusParser.Map_keywordContext ctx) {
            this.variantBuilder.of(AstType.MAP);
            return (AstVariantNode.Builder)super.visitMap_keyword(ctx);
        }

        @Override
        public AstVariantNode.Builder visitOctets_keyword(NukleusParser.Octets_keywordContext ctx) {
            this.variantBuilder.of(AstType.BOUNDED_OCTETS);
            return (AstVariantNode.Builder)super.visitOctets_keyword(ctx);
        }

        @Override
        public AstVariantNode.Builder visitInt64_type(NukleusParser.Int64_typeContext ctx) {
            this.variantBuilder.of(AstType.INT64);
            return (AstVariantNode.Builder)super.visitInt64_type(ctx);
        }

        @Override
        public AstVariantNode.Builder visitInt32_type(NukleusParser.Int32_typeContext ctx) {
            this.variantBuilder.of(AstType.INT32);
            return (AstVariantNode.Builder)super.visitInt32_type(ctx);
        }

        @Override
        public AstVariantNode.Builder visitInt16_type(NukleusParser.Int16_typeContext ctx) {
            this.variantBuilder.of(AstType.INT16);
            return (AstVariantNode.Builder)super.visitInt16_type(ctx);
        }

        @Override
        public AstVariantNode.Builder visitInt8_type(NukleusParser.Int8_typeContext ctx) {
            this.variantBuilder.of(AstType.INT8);
            return (AstVariantNode.Builder)super.visitInt8_type(ctx);
        }

        @Override
        public AstVariantNode.Builder visitUint64_type(NukleusParser.Uint64_typeContext ctx) {
            this.variantBuilder.of(AstType.UINT64);
            return (AstVariantNode.Builder)super.visitUint64_type(ctx);
        }

        @Override
        public AstVariantNode.Builder visitUint32_type(NukleusParser.Uint32_typeContext ctx) {
            this.variantBuilder.of(AstType.UINT32);
            return (AstVariantNode.Builder)super.visitUint32_type(ctx);
        }

        @Override
        public AstVariantNode.Builder visitUint24_type(NukleusParser.Uint24_typeContext ctx) {
            this.variantBuilder.of(AstType.UINT24);
            return (AstVariantNode.Builder)super.visitUint24_type(ctx);
        }

        @Override
        public AstVariantNode.Builder visitUint16_type(NukleusParser.Uint16_typeContext ctx) {
            this.variantBuilder.of(AstType.UINT16);
            return (AstVariantNode.Builder)super.visitUint16_type(ctx);
        }

        @Override
        public AstVariantNode.Builder visitUint8_type(NukleusParser.Uint8_typeContext ctx) {
            this.variantBuilder.of(AstType.UINT8);
            return (AstVariantNode.Builder)super.visitUint8_type(ctx);
        }

        protected AstVariantNode.Builder defaultResult() {
            return this.variantBuilder;
        }

        public final class OctetsMemberVisitor
        extends NukleusBaseVisitor<AstVariantCaseNode.Builder> {
            private final AstVariantCaseNode.Builder variantCaseBuilder;

            public OctetsMemberVisitor(AstVariantCaseNode.Builder variantCaseBuilder) {
                this.variantCaseBuilder = variantCaseBuilder;
            }

            @Override
            public AstVariantCaseNode.Builder visitUint32_type(NukleusParser.Uint32_typeContext ctx) {
                this.variantCaseBuilder.type(AstType.BOUNDED_OCTETS32);
                return this.variantCaseBuilder;
            }

            @Override
            public AstVariantCaseNode.Builder visitUint16_type(NukleusParser.Uint16_typeContext ctx) {
                this.variantCaseBuilder.type(AstType.BOUNDED_OCTETS16);
                return this.variantCaseBuilder;
            }

            @Override
            public AstVariantCaseNode.Builder visitUint8_type(NukleusParser.Uint8_typeContext ctx) {
                this.variantCaseBuilder.type(AstType.BOUNDED_OCTETS8);
                return this.variantCaseBuilder;
            }
        }

        public final class MapMemberVisitor
        extends NukleusBaseVisitor<AstVariantCaseNode.Builder> {
            private final AstVariantCaseNode.Builder variantCaseBuilder;

            public MapMemberVisitor(AstVariantCaseNode.Builder variantCaseBuilder) {
                this.variantCaseBuilder = variantCaseBuilder;
            }

            @Override
            public AstVariantCaseNode.Builder visitUint32_type(NukleusParser.Uint32_typeContext ctx) {
                this.variantCaseBuilder.type(AstType.MAP32);
                return this.variantCaseBuilder;
            }

            @Override
            public AstVariantCaseNode.Builder visitUint16_type(NukleusParser.Uint16_typeContext ctx) {
                this.variantCaseBuilder.type(AstType.MAP16);
                return this.variantCaseBuilder;
            }

            @Override
            public AstVariantCaseNode.Builder visitUint8_type(NukleusParser.Uint8_typeContext ctx) {
                this.variantCaseBuilder.type(AstType.MAP8);
                return this.variantCaseBuilder;
            }
        }

        public final class VariantArrayMemberVisitor
        extends NukleusBaseVisitor<AstVariantCaseNode.Builder> {
            private final AstVariantCaseNode.Builder variantCaseBuilder;

            public VariantArrayMemberVisitor(AstVariantCaseNode.Builder variantCaseBuilder) {
                this.variantCaseBuilder = variantCaseBuilder;
            }

            @Override
            public AstVariantCaseNode.Builder visitUint32_type(NukleusParser.Uint32_typeContext ctx) {
                this.variantCaseBuilder.type(AstType.ARRAY32);
                return this.variantCaseBuilder;
            }

            @Override
            public AstVariantCaseNode.Builder visitUint16_type(NukleusParser.Uint16_typeContext ctx) {
                this.variantCaseBuilder.type(AstType.ARRAY16);
                return this.variantCaseBuilder;
            }

            @Override
            public AstVariantCaseNode.Builder visitUint8_type(NukleusParser.Uint8_typeContext ctx) {
                this.variantCaseBuilder.type(AstType.ARRAY8);
                return this.variantCaseBuilder;
            }
        }

        public final class VariantListMemberVisitor
        extends NukleusBaseVisitor<AstVariantCaseNode.Builder> {
            private final AstVariantCaseNode.Builder variantCaseBuilder;

            public VariantListMemberVisitor(AstVariantCaseNode.Builder variantCaseBuilder) {
                this.variantCaseBuilder = variantCaseBuilder;
            }

            @Override
            public AstVariantCaseNode.Builder visitVariant_list_member(NukleusParser.Variant_list_memberContext ctx) {
                if (ctx.UNSIGNED_INTEGER_LITERAL(0) != null) {
                    this.variantCaseBuilder.type(AstType.LIST0);
                    return this.variantCaseBuilder;
                }
                if (ctx.uint_literal() != null) {
                    this.variantCaseBuilder.missingFieldValue(AstParser.parseInt((RuleContext)ctx.uint_literal()));
                }
                return (AstVariantCaseNode.Builder)super.visitVariant_list_member(ctx);
            }

            @Override
            public AstVariantCaseNode.Builder visitUint32_type(NukleusParser.Uint32_typeContext ctx) {
                this.variantCaseBuilder.type(AstType.LIST32);
                return this.variantCaseBuilder;
            }

            @Override
            public AstVariantCaseNode.Builder visitUint8_type(NukleusParser.Uint8_typeContext ctx) {
                this.variantCaseBuilder.type(AstType.LIST8);
                return this.variantCaseBuilder;
            }
        }

        public final class VariantCaseValueVisitor
        extends NukleusBaseVisitor<Object> {
            @Override
            public Object visitUint_literal(NukleusParser.Uint_literalContext ctx) {
                return Integer.decode(ctx.getText());
            }

            @Override
            public Object visitDeclarator(NukleusParser.DeclaratorContext ctx) {
                return ctx.ID().getText();
            }
        }

        public final class VariantCaseVisitor
        extends NukleusBaseVisitor<AstVariantCaseNode.Builder> {
            private final AstVariantCaseNode.Builder variantCaseBuilder = new AstVariantCaseNode.Builder();

            @Override
            public AstVariantCaseNode.Builder visitVariant_case_member(NukleusParser.Variant_case_memberContext ctx) {
                super.visitVariant_case_member(ctx);
                return this.variantCaseBuilder;
            }

            @Override
            public AstVariantCaseNode.Builder visitVariant_case_member_no_type(NukleusParser.Variant_case_member_no_typeContext ctx) {
                super.visitVariant_case_member_no_type(ctx);
                return this.variantCaseBuilder;
            }

            @Override
            public AstVariantCaseNode.Builder visitVariant_case_member_without_of(NukleusParser.Variant_case_member_without_ofContext ctx) {
                super.visitVariant_case_member_without_of(ctx);
                return this.variantCaseBuilder;
            }

            @Override
            public AstVariantCaseNode.Builder visitDefined_variant_member(NukleusParser.Defined_variant_memberContext ctx) {
                String typeName = ctx.declarator().getText();
                AstType astTypeName = Objects.requireNonNullElse((AstType)AstParser.this.astTypesByQualifiedName.get(typeName), AstParser.this.lookUpAstType(typeName));
                this.variantCaseBuilder.type(astTypeName);
                return (AstVariantCaseNode.Builder)super.visitDefined_variant_member(ctx);
            }

            @Override
            public AstVariantCaseNode.Builder visitDefined_variant_member_with_parametric_type(NukleusParser.Defined_variant_member_with_parametric_typeContext ctx) {
                String typeName = ctx.membertype.getText();
                AstType astTypeName = Objects.requireNonNullElse((AstType)AstParser.this.astTypesByQualifiedName.get(typeName), AstParser.this.lookUpAstType(typeName));
                this.variantCaseBuilder.type(astTypeName);
                String typeParam = ctx.param1.getText();
                AstType astTypeParam = Objects.requireNonNullElse((AstType)AstParser.this.astTypesByQualifiedName.get(typeParam), AstParser.this.lookUpAstType(typeParam));
                this.variantCaseBuilder.typeParam(astTypeParam);
                if (ctx.param2 != null) {
                    String secondTypeParam = ctx.param2.getText();
                    this.variantCaseBuilder.typeParam(Objects.requireNonNullElse((AstType)AstParser.this.astTypesByQualifiedName.get(secondTypeParam), AstParser.this.lookUpAstType(secondTypeParam)));
                }
                return (AstVariantCaseNode.Builder)super.visitDefined_variant_member_with_parametric_type(ctx);
            }

            @Override
            public AstVariantCaseNode.Builder visitVariant_case_value(NukleusParser.Variant_case_valueContext ctx) {
                this.variantCaseBuilder.value(new VariantCaseValueVisitor().visitVariant_case_value(ctx));
                return this.variantCaseBuilder;
            }

            @Override
            public AstVariantCaseNode.Builder visitInt8_type(NukleusParser.Int8_typeContext ctx) {
                this.variantCaseBuilder.type(AstType.INT8);
                return (AstVariantCaseNode.Builder)super.visitInt8_type(ctx);
            }

            @Override
            public AstVariantCaseNode.Builder visitInt16_type(NukleusParser.Int16_typeContext ctx) {
                this.variantCaseBuilder.type(AstType.INT16);
                return (AstVariantCaseNode.Builder)super.visitInt16_type(ctx);
            }

            @Override
            public AstVariantCaseNode.Builder visitInt24_type(NukleusParser.Int24_typeContext ctx) {
                this.variantCaseBuilder.type(AstType.INT24);
                return (AstVariantCaseNode.Builder)super.visitInt24_type(ctx);
            }

            @Override
            public AstVariantCaseNode.Builder visitInt32_type(NukleusParser.Int32_typeContext ctx) {
                this.variantCaseBuilder.type(AstType.INT32);
                return (AstVariantCaseNode.Builder)super.visitInt32_type(ctx);
            }

            @Override
            public AstVariantCaseNode.Builder visitInt64_type(NukleusParser.Int64_typeContext ctx) {
                this.variantCaseBuilder.type(AstType.INT64);
                return (AstVariantCaseNode.Builder)super.visitInt64_type(ctx);
            }

            @Override
            public AstVariantCaseNode.Builder visitUint8_type(NukleusParser.Uint8_typeContext ctx) {
                this.variantCaseBuilder.type(AstType.UINT8);
                return (AstVariantCaseNode.Builder)super.visitUint8_type(ctx);
            }

            @Override
            public AstVariantCaseNode.Builder visitUint16_type(NukleusParser.Uint16_typeContext ctx) {
                this.variantCaseBuilder.type(AstType.UINT16);
                return (AstVariantCaseNode.Builder)super.visitUint16_type(ctx);
            }

            @Override
            public AstVariantCaseNode.Builder visitUint24_type(NukleusParser.Uint24_typeContext ctx) {
                this.variantCaseBuilder.type(AstType.UINT24);
                return (AstVariantCaseNode.Builder)super.visitUint24_type(ctx);
            }

            @Override
            public AstVariantCaseNode.Builder visitUint32_type(NukleusParser.Uint32_typeContext ctx) {
                this.variantCaseBuilder.type(AstType.UINT32);
                return (AstVariantCaseNode.Builder)super.visitUint32_type(ctx);
            }

            @Override
            public AstVariantCaseNode.Builder visitUint64_type(NukleusParser.Uint64_typeContext ctx) {
                this.variantCaseBuilder.type(AstType.UINT64);
                return (AstVariantCaseNode.Builder)super.visitUint64_type(ctx);
            }

            @Override
            public AstVariantCaseNode.Builder visitString8_type(NukleusParser.String8_typeContext ctx) {
                this.variantCaseBuilder.type(AstType.STRING8);
                return (AstVariantCaseNode.Builder)super.visitString8_type(ctx);
            }

            @Override
            public AstVariantCaseNode.Builder visitString16_type(NukleusParser.String16_typeContext ctx) {
                this.variantCaseBuilder.type(AstType.STRING16);
                return (AstVariantCaseNode.Builder)super.visitString16_type(ctx);
            }

            @Override
            public AstVariantCaseNode.Builder visitString32_type(NukleusParser.String32_typeContext ctx) {
                this.variantCaseBuilder.type(AstType.STRING32);
                return (AstVariantCaseNode.Builder)super.visitString32_type(ctx);
            }

            @Override
            public AstVariantCaseNode.Builder visitVariant_int_literal(NukleusParser.Variant_int_literalContext ctx) {
                this.variantCaseBuilder.type(AstType.dynamicType(ctx.getText()));
                return (AstVariantCaseNode.Builder)super.visitVariant_int_literal(ctx);
            }

            @Override
            public AstVariantCaseNode.Builder visitVariant_list_member(NukleusParser.Variant_list_memberContext ctx) {
                AstVariantCaseNode.Builder variantListMemberVisitor = new VariantListMemberVisitor(this.variantCaseBuilder).visitVariant_list_member(ctx);
                return this.variantCaseBuilder;
            }

            @Override
            public AstVariantCaseNode.Builder visitVariant_array_member(NukleusParser.Variant_array_memberContext ctx) {
                AstVariantCaseNode.Builder variantArrayMemberVisitor = (AstVariantCaseNode.Builder)new VariantArrayMemberVisitor(this.variantCaseBuilder).visitVariant_array_member(ctx);
                return this.variantCaseBuilder;
            }

            @Override
            public AstVariantCaseNode.Builder visitVariant_map_member(NukleusParser.Variant_map_memberContext ctx) {
                AstVariantCaseNode.Builder variantMapMemberVisitor = (AstVariantCaseNode.Builder)new MapMemberVisitor(this.variantCaseBuilder).visitVariant_map_member(ctx);
                return this.variantCaseBuilder;
            }

            @Override
            public AstVariantCaseNode.Builder visitVariant_octets_member(NukleusParser.Variant_octets_memberContext ctx) {
                AstVariantCaseNode.Builder variantOctetsMemberVisitor = (AstVariantCaseNode.Builder)new OctetsMemberVisitor(this.variantCaseBuilder).visitVariant_octets_member(ctx);
                return this.variantCaseBuilder;
            }
        }

        public final class VariantKindVisitor
        extends NukleusBaseVisitor<AstVariantNode.Builder> {
            private AstVariantNode.Builder variantBuilder;

            public VariantKindVisitor(AstVariantNode.Builder variantBuilder) {
                this.variantBuilder = variantBuilder;
            }

            @Override
            public AstVariantNode.Builder visitKind(NukleusParser.KindContext ctx) {
                if (ctx.KW_UINT8() != null) {
                    this.variantBuilder.kindType(AstType.UINT8);
                }
                return (AstVariantNode.Builder)super.visitKind(ctx);
            }

            @Override
            public AstVariantNode.Builder visitScoped_name(NukleusParser.Scoped_nameContext ctx) {
                String kindTypeName = ctx.getText();
                AstType astTypeName = (AstType)AstParser.this.astTypesByQualifiedName.get(kindTypeName);
                if (astTypeName == null) {
                    astTypeName = AstParser.this.qualifiedPrefixes.stream().map(qp -> String.format("%s%s", qp, kindTypeName)).map(AstParser.this.astTypesByQualifiedName::get).filter(Objects::nonNull).findFirst().orElse(AstType.dynamicType(kindTypeName));
                }
                this.variantBuilder.kindType(astTypeName);
                return (AstVariantNode.Builder)super.visitScoped_name(ctx);
            }
        }
    }

    public final class ListVisitor
    extends NukleusBaseVisitor<AstListNode.Builder> {
        private final AstListNode.Builder listBuilder = new AstListNode.Builder();
        private AstListMemberNode.Builder listMemberBuilder;

        @Override
        public AstListNode.Builder visitList_type(NukleusParser.List_typeContext ctx) {
            String prefix = (String)AstParser.this.qualifiedPrefixes.peekFirst();
            String listName = ctx.ID().getText();
            String qualifiedListName = String.format("%s%s", prefix, listName);
            AstParser.this.astTypesByQualifiedName.put(qualifiedListName, AstType.dynamicType(qualifiedListName));
            this.listBuilder.name(listName);
            this.listBuilder.byteOrder(AstParser.this.byteOrder);
            return (AstListNode.Builder)super.visitList_type(ctx);
        }

        @Override
        public AstListNode.Builder visitList_params(NukleusParser.List_paramsContext ctx) {
            AstListNode.Builder builder = (AstListNode.Builder)new ListParamsVisitor(this.listBuilder).visitList_params(ctx);
            return this.listBuilder;
        }

        @Override
        public AstListNode.Builder visitList_using(NukleusParser.List_usingContext ctx) {
            AstListNode.Builder builder = (AstListNode.Builder)new ListParamsVisitor(this.listBuilder).visitList_using(ctx);
            return this.listBuilder;
        }

        @Override
        public AstListNode.Builder visitList_member(NukleusParser.List_memberContext ctx) {
            this.listMemberBuilder = new AstListMemberNode.Builder();
            this.listMemberBuilder.byteOrder(AstParser.this.byteOrder);
            if (ctx.KW_REQUIRED() != null) {
                this.listMemberBuilder.isRequired(true);
            }
            super.visitList_member(ctx);
            AstListMemberNode member = this.listMemberBuilder.build();
            this.listBuilder.member(member);
            this.listMemberBuilder = null;
            return this.listBuilder;
        }

        @Override
        public AstListNode.Builder visitDeclarator(NukleusParser.DeclaratorContext ctx) {
            this.listMemberBuilder.name(ctx.ID().toString());
            return (AstListNode.Builder)super.visitDeclarator(ctx);
        }

        @Override
        public AstListNode.Builder visitUint_member_with_default(NukleusParser.Uint_member_with_defaultContext ctx) {
            this.listMemberBuilder.defaultValue(AstParser.parseInt((RuleContext)ctx.uint_literal()));
            return (AstListNode.Builder)super.visitUint_member_with_default(ctx);
        }

        @Override
        public AstListNode.Builder visitInt_member_with_default(NukleusParser.Int_member_with_defaultContext ctx) {
            this.listMemberBuilder.defaultValue(AstParser.parseInt(ctx.int_literal()));
            return (AstListNode.Builder)super.visitInt_member_with_default(ctx);
        }

        @Override
        public AstListNode.Builder visitNon_primitive_member_with_default(NukleusParser.Non_primitive_member_with_defaultContext ctx) {
            if (ctx.ID() != null) {
                this.listMemberBuilder.defaultValue(ctx.ID().getText());
            } else {
                this.listMemberBuilder.defaultValue(ctx.int_literal().getText());
            }
            return (AstListNode.Builder)super.visitNon_primitive_member_with_default(ctx);
        }

        @Override
        public AstListNode.Builder visitArray_member(NukleusParser.Array_memberContext ctx) {
            this.listMemberBuilder.type(AstType.ARRAY32);
            return (AstListNode.Builder)super.visitArray_member(ctx);
        }

        @Override
        public AstListNode.Builder visitMember_with_parametric_type(NukleusParser.Member_with_parametric_typeContext ctx) {
            this.listMemberBuilder.name(ctx.name.getText());
            String typeName = ctx.membertype.getText();
            AstType astTypeName = Objects.requireNonNullElse((AstType)AstParser.this.astTypesByQualifiedName.get(typeName), AstParser.this.lookUpAstType(typeName));
            this.listMemberBuilder.type(astTypeName);
            String typeParam = ctx.param1.getText();
            AstType astTypeParam = Objects.requireNonNullElse((AstType)AstParser.this.astTypesByQualifiedName.get(typeParam), AstParser.this.lookUpAstType(typeParam));
            this.listMemberBuilder.typeParam(astTypeParam);
            if (ctx.param2 != null) {
                String secondTypeParam = ctx.param2.getText();
                this.listMemberBuilder.typeParam(Objects.requireNonNullElse((AstType)AstParser.this.astTypesByQualifiedName.get(secondTypeParam), AstParser.this.lookUpAstType(secondTypeParam)));
            }
            return (AstListNode.Builder)super.visitMember_with_parametric_type(ctx);
        }

        @Override
        public AstListNode.Builder visitVarint_array_member(NukleusParser.Varint_array_memberContext ctx) {
            this.listMemberBuilder.type(AstType.ARRAY32);
            return (AstListNode.Builder)super.visitVarint_array_member(ctx);
        }

        @Override
        public AstListNode.Builder visitVarint32_type(NukleusParser.Varint32_typeContext ctx) {
            this.listMemberBuilder.type(AstType.VARINT32);
            return (AstListNode.Builder)super.visitVarint32_type(ctx);
        }

        @Override
        public AstListNode.Builder visitVarint64_type(NukleusParser.Varint64_typeContext ctx) {
            this.listMemberBuilder.type(AstType.VARINT64);
            return (AstListNode.Builder)super.visitVarint64_type(ctx);
        }

        @Override
        public AstListNode.Builder visitInt64_type(NukleusParser.Int64_typeContext ctx) {
            this.listMemberBuilder.type(AstType.INT64);
            return (AstListNode.Builder)super.visitInt64_type(ctx);
        }

        @Override
        public AstListNode.Builder visitInt32_type(NukleusParser.Int32_typeContext ctx) {
            this.listMemberBuilder.type(AstType.INT32);
            return (AstListNode.Builder)super.visitInt32_type(ctx);
        }

        @Override
        public AstListNode.Builder visitInt16_type(NukleusParser.Int16_typeContext ctx) {
            this.listMemberBuilder.type(AstType.INT16);
            return (AstListNode.Builder)super.visitInt16_type(ctx);
        }

        @Override
        public AstListNode.Builder visitInt8_type(NukleusParser.Int8_typeContext ctx) {
            this.listMemberBuilder.type(AstType.INT8);
            return (AstListNode.Builder)super.visitInt8_type(ctx);
        }

        @Override
        public AstListNode.Builder visitUint64_type(NukleusParser.Uint64_typeContext ctx) {
            this.listMemberBuilder.type(AstType.UINT64);
            return (AstListNode.Builder)super.visitUint64_type(ctx);
        }

        @Override
        public AstListNode.Builder visitUint32_type(NukleusParser.Uint32_typeContext ctx) {
            this.listMemberBuilder.type(AstType.UINT32);
            return (AstListNode.Builder)super.visitUint32_type(ctx);
        }

        @Override
        public AstListNode.Builder visitUint16_type(NukleusParser.Uint16_typeContext ctx) {
            this.listMemberBuilder.type(AstType.UINT16);
            return (AstListNode.Builder)super.visitUint16_type(ctx);
        }

        @Override
        public AstListNode.Builder visitUint8_type(NukleusParser.Uint8_typeContext ctx) {
            this.listMemberBuilder.type(AstType.UINT8);
            return (AstListNode.Builder)super.visitUint8_type(ctx);
        }

        @Override
        public AstListNode.Builder visitString8_type(NukleusParser.String8_typeContext ctx) {
            this.listMemberBuilder.type(AstType.STRING8);
            return (AstListNode.Builder)super.visitString8_type(ctx);
        }

        @Override
        public AstListNode.Builder visitString16_type(NukleusParser.String16_typeContext ctx) {
            this.listMemberBuilder.type(AstType.STRING16);
            return (AstListNode.Builder)super.visitString16_type(ctx);
        }

        @Override
        public AstListNode.Builder visitString32_type(NukleusParser.String32_typeContext ctx) {
            this.listMemberBuilder.type(AstType.STRING32);
            return (AstListNode.Builder)super.visitString32_type(ctx);
        }

        @Override
        public AstListNode.Builder visitUnbounded_octets_type(NukleusParser.Unbounded_octets_typeContext ctx) {
            this.listMemberBuilder.type(AstType.OCTETS);
            return (AstListNode.Builder)super.visitUnbounded_octets_type(ctx);
        }

        @Override
        public AstListNode.Builder visitScoped_name(NukleusParser.Scoped_nameContext ctx) {
            String typeName = ctx.getText();
            AstType astTypeName = (AstType)AstParser.this.astTypesByQualifiedName.get(typeName);
            if (astTypeName == null) {
                astTypeName = AstParser.this.qualifiedPrefixes.stream().map(qp -> String.format("%s%s", qp, typeName)).map(AstParser.this.astTypesByQualifiedName::get).filter(Objects::nonNull).findFirst().orElse(AstType.dynamicType(typeName));
            }
            this.listMemberBuilder.type(astTypeName);
            return (AstListNode.Builder)super.visitScoped_name(ctx);
        }

        protected AstListNode.Builder defaultResult() {
            return this.listBuilder;
        }

        public final class ListParamsVisitor
        extends NukleusBaseVisitor<AstListNode.Builder> {
            private final AstListNode.Builder listBuilder;

            public ListParamsVisitor(AstListNode.Builder listBuilder) {
                this.listBuilder = listBuilder;
            }

            @Override
            public AstListNode.Builder visitUint8_type(NukleusParser.Uint8_typeContext ctx) {
                this.listBuilder.lengthType(AstType.UINT8);
                this.listBuilder.fieldCountType(AstType.UINT8);
                return (AstListNode.Builder)super.visitUint8_type(ctx);
            }

            @Override
            public AstListNode.Builder visitUint16_type(NukleusParser.Uint16_typeContext ctx) {
                this.listBuilder.lengthType(AstType.UINT16);
                this.listBuilder.fieldCountType(AstType.UINT16);
                return (AstListNode.Builder)super.visitUint16_type(ctx);
            }

            @Override
            public AstListNode.Builder visitUint32_type(NukleusParser.Uint32_typeContext ctx) {
                this.listBuilder.lengthType(AstType.UINT32);
                this.listBuilder.fieldCountType(AstType.UINT32);
                return (AstListNode.Builder)super.visitUint32_type(ctx);
            }

            @Override
            public AstListNode.Builder visitUint64_type(NukleusParser.Uint64_typeContext ctx) {
                this.listBuilder.lengthType(AstType.UINT64);
                this.listBuilder.fieldCountType(AstType.UINT64);
                return (AstListNode.Builder)super.visitUint64_type(ctx);
            }

            @Override
            public AstListNode.Builder visitUint_literal(NukleusParser.Uint_literalContext ctx) {
                Byte missingFieldByte = AstParser.parseByte((RuleContext)ctx);
                this.listBuilder.missingFieldByte(missingFieldByte);
                return (AstListNode.Builder)super.visitUint_literal(ctx);
            }

            @Override
            public AstListNode.Builder visitDeclarator(NukleusParser.DeclaratorContext ctx) {
                String superTypeName = ctx.ID().getText();
                AstType astTypeName = (AstType)AstParser.this.astTypesByQualifiedName.get(superTypeName);
                if (astTypeName == null) {
                    astTypeName = AstParser.this.qualifiedPrefixes.stream().map(qp -> String.format("%s%s", qp, superTypeName)).map(AstParser.this.astTypesByQualifiedName::get).filter(Objects::nonNull).findFirst().orElse(AstType.dynamicType(superTypeName));
                }
                this.listBuilder.templateType(astTypeName);
                return (AstListNode.Builder)super.visitDeclarator(ctx);
            }
        }
    }
}

