/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.ast.visit;

import com.squareup.javapoet.TypeName;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstEnumNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstNamedNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstStructNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstType;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstUnionNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstVariantCaseNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstVariantNode;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeResolver;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeSpecGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.VariantFlyweightGenerator;

public final class VariantVisitor
extends AstNode.Visitor<Collection<TypeSpecGenerator<?>>> {
    private final VariantFlyweightGenerator generator;
    private final TypeResolver resolver;
    private final Set<TypeSpecGenerator<?>> defaultResult;

    public VariantVisitor(VariantFlyweightGenerator generator, TypeResolver resolver) {
        this.generator = generator;
        this.resolver = resolver;
        this.defaultResult = Collections.singleton(generator);
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitStruct(AstStructNode structNode) {
        return this.defaultResult();
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitEnum(AstEnumNode enumNode) {
        return this.defaultResult();
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitUnion(AstUnionNode unionNode) {
        return this.defaultResult();
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitVariant(AstVariantNode variantNode) {
        return (Collection)super.visitVariant(variantNode);
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitVariantCase(AstVariantCaseNode variantCaseNode) {
        AstVariantNode varNode;
        AstType ofType;
        AstNamedNode memberTypeNode;
        Object value = variantCaseNode.value();
        AstType memberType = variantCaseNode.type();
        AstType mapKeyType = null;
        AstType mapValueType = null;
        AstNamedNode astNamedNode = memberTypeNode = memberType == null ? null : this.resolver.resolve(memberType.name());
        if (memberTypeNode != null && memberTypeNode.getKind() == AstNamedNode.Kind.VARIANT && AstType.MAP.equals(ofType = (varNode = (AstVariantNode)memberTypeNode).of())) {
            mapKeyType = variantCaseNode.typeParams().get(0);
            mapValueType = variantCaseNode.typeParams().get(1);
        }
        int missingFieldValue = variantCaseNode.missingFieldValue();
        TypeName typeName = this.resolver.resolveType(memberType);
        TypeName unsignedTypeName = this.resolver.resolveUnsignedType(memberType);
        String memberTypeName = memberType != null ? memberType.name() : null;
        this.generator.addMember(value, memberTypeName, memberType, typeName, unsignedTypeName, missingFieldValue, mapKeyType, mapValueType);
        return this.defaultResult();
    }

    @Override
    protected Collection<TypeSpecGenerator<?>> defaultResult() {
        return this.defaultResult;
    }
}

