/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.generate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.lang.model.element.Modifier;
import org.reaktivity.nukleus.maven.plugin.internal.generate.ClassSpecGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeNames;

public final class Array8FWGenerator
extends ClassSpecGenerator {
    private final TypeSpec.Builder classBuilder;
    private final TypeVariableName typeVarV;
    private final TypeName parameterizedArray8Type;
    private final BuilderClassBuilder builderClassBuilder;

    public Array8FWGenerator(ClassName flyweightType, ClassName arrayType) {
        super(flyweightType.peerClass("Array8FW"));
        this.typeVarV = TypeVariableName.get((String)"V", (TypeName[])new TypeName[]{flyweightType});
        this.parameterizedArray8Type = ParameterizedTypeName.get((ClassName)((ClassName)this.thisName), (TypeName[])new TypeName[]{this.typeVarV});
        this.classBuilder = TypeSpec.classBuilder((ClassName)((ClassName)this.thisName)).superclass((TypeName)ParameterizedTypeName.get((ClassName)arrayType, (TypeName[])new TypeName[]{this.typeVarV})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addTypeVariable(this.typeVarV);
        this.builderClassBuilder = new BuilderClassBuilder(flyweightType, arrayType, (ClassName)this.thisName);
    }

    @Override
    public TypeSpec generate() {
        return this.classBuilder.addField(this.lengthSizeConstant()).addField(this.fieldCountSizeConstant()).addField(this.lengthOffsetConstant()).addField(this.fieldCountOffsetConstant()).addField(this.fieldsOffsetConstant()).addField(this.lengthMaxValueConstant()).addField(this.emptyBufferConstant()).addField(this.itemField()).addField(this.itemsField()).addField(this.maxLengthField()).addMethod(this.constructor()).addMethod(this.lengthMethod()).addMethod(this.fieldsOffsetMethod()).addMethod(this.fieldCountMethod()).addMethod(this.maxLengthMethod()).addMethod(this.forEachMethod()).addMethod(this.anyMatchMethod()).addMethod(this.matchFirstMethod()).addMethod(this.isEmptyMethod()).addMethod(this.itemsMethod()).addMethod(this.wrapMethod()).addMethod(this.tryWrapMethod()).addMethod(this.limitMethod()).addMethod(this.toStringMethod()).addMethod(this.maxLengthSetterMethod()).addType(this.builderClassBuilder.build()).build();
    }

    private FieldSpec lengthSizeConstant() {
        return FieldSpec.builder(Integer.TYPE, (String)"LENGTH_SIZE", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.SIZE_OF_BYTE", new Object[]{TypeNames.BIT_UTIL_TYPE}).build();
    }

    private FieldSpec fieldCountSizeConstant() {
        return FieldSpec.builder(Integer.TYPE, (String)"FIELD_COUNT_SIZE", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.SIZE_OF_BYTE", new Object[]{TypeNames.BIT_UTIL_TYPE}).build();
    }

    private FieldSpec lengthOffsetConstant() {
        return FieldSpec.builder(Integer.TYPE, (String)"LENGTH_OFFSET", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("0", new Object[0]).build();
    }

    private FieldSpec fieldCountOffsetConstant() {
        return FieldSpec.builder(Integer.TYPE, (String)"FIELD_COUNT_OFFSET", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("LENGTH_OFFSET + LENGTH_SIZE", new Object[0]).build();
    }

    private FieldSpec fieldsOffsetConstant() {
        return FieldSpec.builder(Integer.TYPE, (String)"FIELDS_OFFSET", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("FIELD_COUNT_OFFSET + FIELD_COUNT_SIZE", new Object[0]).build();
    }

    private FieldSpec lengthMaxValueConstant() {
        return FieldSpec.builder(Integer.TYPE, (String)"LENGTH_MAX_VALUE", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("0xFF", new Object[0]).build();
    }

    private FieldSpec emptyBufferConstant() {
        return FieldSpec.builder((TypeName)TypeNames.DIRECT_BUFFER_TYPE, (String)"EMPTY_BUFFER", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new $T()", new Object[]{TypeNames.UNSAFE_BUFFER_TYPE}).build();
    }

    private FieldSpec itemField() {
        return FieldSpec.builder((TypeName)this.typeVarV, (String)"itemRO", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    private FieldSpec itemsField() {
        return FieldSpec.builder((TypeName)TypeNames.DIRECT_BUFFER_TYPE, (String)"itemsRO", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T(0L, 0)", new Object[]{TypeNames.UNSAFE_BUFFER_TYPE}).build();
    }

    private FieldSpec maxLengthField() {
        return FieldSpec.builder(Integer.TYPE, (String)"maxLength", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
    }

    private MethodSpec constructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.typeVarV, "itemRO", new Modifier[0]).addStatement("this.itemRO = itemRO", new Object[0]).build();
    }

    private MethodSpec lengthMethod() {
        return MethodSpec.methodBuilder((String)"length").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return buffer().getByte(offset() + LENGTH_OFFSET)", new Object[0]).build();
    }

    private MethodSpec fieldsOffsetMethod() {
        return MethodSpec.methodBuilder((String)"fieldsOffset").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return offset() + FIELDS_OFFSET", new Object[0]).build();
    }

    private MethodSpec fieldCountMethod() {
        return MethodSpec.methodBuilder((String)"fieldCount").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return buffer().getByte(offset() + FIELD_COUNT_OFFSET)", new Object[0]).build();
    }

    private MethodSpec maxLengthMethod() {
        return MethodSpec.methodBuilder((String)"maxLength").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return maxLength", new Object[0]).build();
    }

    private MethodSpec forEachMethod() {
        WildcardTypeName itemType = WildcardTypeName.supertypeOf((TypeName)this.typeVarV);
        ParameterizedTypeName consumerType = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{itemType});
        return MethodSpec.methodBuilder((String)"forEach").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)consumerType, "consumer", new Modifier[0]).returns(Void.TYPE).addStatement("int offset = offset() + FIELDS_OFFSET", new Object[0]).beginControlFlow("for (int i = 0; i < fieldCount(); i++)", new Object[0]).addStatement("itemRO.wrap(buffer(), offset, limit(), this)", new Object[0]).addStatement("consumer.accept(itemRO)", new Object[0]).addStatement("offset = itemRO.limit()", new Object[0]).endControlFlow().build();
    }

    private MethodSpec anyMatchMethod() {
        WildcardTypeName itemType = WildcardTypeName.supertypeOf((TypeName)this.typeVarV);
        ParameterizedTypeName predicateType = ParameterizedTypeName.get((ClassName)ClassName.get(Predicate.class), (TypeName[])new TypeName[]{itemType});
        return MethodSpec.methodBuilder((String)"anyMatch").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)predicateType, "predicate", new Modifier[0]).returns(Boolean.TYPE).addStatement("int offset = offset() + FIELDS_OFFSET", new Object[0]).beginControlFlow("for (int i = 0; i < fieldCount(); i++)", new Object[0]).addStatement("itemRO.wrap(buffer(), offset, maxLimit(), this)", new Object[0]).beginControlFlow("if (predicate.test(itemRO))", new Object[0]).addStatement("return true", new Object[0]).endControlFlow().addStatement("offset = itemRO.limit()", new Object[0]).endControlFlow().addStatement("return false", new Object[0]).build();
    }

    private MethodSpec matchFirstMethod() {
        WildcardTypeName itemType = WildcardTypeName.supertypeOf((TypeName)this.typeVarV);
        ParameterizedTypeName predicateType = ParameterizedTypeName.get((ClassName)ClassName.get(Predicate.class), (TypeName[])new TypeName[]{itemType});
        return MethodSpec.methodBuilder((String)"matchFirst").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)predicateType, "predicate", new Modifier[0]).returns((TypeName)this.typeVarV).addStatement("int offset = offset() + FIELDS_OFFSET", new Object[0]).beginControlFlow("for (int i = 0; i < fieldCount(); i++)", new Object[0]).addStatement("itemRO.wrap(buffer(), offset, maxLimit(), this)", new Object[0]).beginControlFlow("if (predicate.test(itemRO))", new Object[0]).addStatement("return itemRO", new Object[0]).endControlFlow().addStatement("offset = itemRO.limit()", new Object[0]).endControlFlow().addStatement("return null", new Object[0]).build();
    }

    private MethodSpec isEmptyMethod() {
        return MethodSpec.methodBuilder((String)"isEmpty").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addStatement("return fieldCount() == 0", new Object[0]).build();
    }

    private MethodSpec itemsMethod() {
        return MethodSpec.methodBuilder((String)"items").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeNames.DIRECT_BUFFER_TYPE).addStatement("return itemsRO", new Object[0]).build();
    }

    private MethodSpec wrapMethod() {
        return MethodSpec.methodBuilder((String)"wrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(this.parameterizedArray8Type).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]).addStatement("final int itemsSize = limit() - fieldsOffset()", new Object[0]).beginControlFlow("if (itemsSize == 0)", new Object[0]).addStatement("itemsRO.wrap(EMPTY_BUFFER, 0, 0)", new Object[0]).endControlFlow().beginControlFlow("else", new Object[0]).addStatement("itemsRO.wrap(buffer, offset + FIELDS_OFFSET, itemsSize)", new Object[0]).endControlFlow().addStatement("checkLimit(limit(), maxLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
    }

    private MethodSpec tryWrapMethod() {
        return MethodSpec.methodBuilder((String)"tryWrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(this.parameterizedArray8Type).beginControlFlow("if (offset + FIELDS_OFFSET > maxLimit)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().beginControlFlow("if (super.tryWrap(buffer, offset, maxLimit) == null)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("final int itemsSize = limit() - fieldsOffset()", new Object[0]).beginControlFlow("if (itemsSize == 0)", new Object[0]).addStatement("itemsRO.wrap(EMPTY_BUFFER, 0, 0)", new Object[0]).endControlFlow().beginControlFlow("else", new Object[0]).addStatement("itemsRO.wrap(buffer, offset + FIELDS_OFFSET, itemsSize)", new Object[0]).endControlFlow().beginControlFlow("if (limit() > maxLimit)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("return this", new Object[0]).build();
    }

    private MethodSpec limitMethod() {
        return MethodSpec.methodBuilder((String)"limit").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return offset() + LENGTH_SIZE + length()", new Object[0]).build();
    }

    private MethodSpec toStringMethod() {
        return MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return String.format(\"array8<%d, %d>\", length(), fieldCount())", new Object[0]).build();
    }

    private MethodSpec maxLengthSetterMethod() {
        return MethodSpec.methodBuilder((String)"maxLength").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Integer.TYPE, "maxLength", new Modifier[0]).returns(Void.TYPE).addStatement("this.maxLength = maxLength", new Object[0]).build();
    }

    private static final class BuilderClassBuilder {
        private final TypeSpec.Builder classBuilder;
        private final TypeVariableName typeVarB;
        private final TypeVariableName typeVarV;
        private final TypeName parameterizedArray8Type;
        private final TypeName parameterizedArray8BuilderType;

        private BuilderClassBuilder(ClassName flyweight, ClassName arrayType, ClassName array8Type) {
            ClassName array8BuilderRawType = array8Type.nestedClass("Builder");
            ClassName flyweightBuilderRawType = flyweight.nestedClass("Builder");
            ClassName arrayBuilderRawType = arrayType.nestedClass("Builder");
            this.typeVarV = TypeVariableName.get((String)"V", (TypeName[])new TypeName[]{flyweight});
            this.typeVarB = TypeVariableName.get((String)"B", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)flyweightBuilderRawType, (TypeName[])new TypeName[]{this.typeVarV})});
            this.parameterizedArray8Type = ParameterizedTypeName.get((ClassName)array8Type, (TypeName[])new TypeName[]{this.typeVarV});
            this.parameterizedArray8BuilderType = ParameterizedTypeName.get((ClassName)array8BuilderRawType, (TypeName[])new TypeName[]{this.typeVarB, this.typeVarV});
            ParameterizedTypeName superClassType = ParameterizedTypeName.get((ClassName)arrayBuilderRawType, (TypeName[])new TypeName[]{this.parameterizedArray8Type, this.typeVarB, this.typeVarV});
            this.classBuilder = TypeSpec.classBuilder((String)array8BuilderRawType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).superclass((TypeName)superClassType).addTypeVariable(this.typeVarB).addTypeVariable(this.typeVarV);
        }

        public TypeSpec build() {
            return this.classBuilder.addField(this.itemRWField()).addField(this.itemROField()).addField(this.fieldCountField()).addField(this.maxLengthField()).addMethod(this.constructor()).addMethod(this.fieldsOffsetMethod()).addMethod(this.itemMethod()).addMethod(this.itemsMethod()).addMethod(this.wrapMethod()).addMethod(this.buildMethod()).build();
        }

        private FieldSpec itemRWField() {
            return FieldSpec.builder((TypeName)this.typeVarB, (String)"itemRW", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        }

        private FieldSpec itemROField() {
            return FieldSpec.builder((TypeName)this.typeVarV, (String)"itemRO", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        }

        private FieldSpec fieldCountField() {
            return FieldSpec.builder(Integer.TYPE, (String)"fieldCount", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
        }

        private FieldSpec maxLengthField() {
            return FieldSpec.builder(Integer.TYPE, (String)"maxLength", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
        }

        private MethodSpec constructor() {
            return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.typeVarB, "itemRW", new Modifier[0]).addParameter((TypeName)this.typeVarV, "itemRO", new Modifier[0]).addStatement("super(new Array8FW<>(itemRO))", new Object[0]).addStatement("this.itemRW = itemRW", new Object[0]).addStatement("this.itemRO = itemRO", new Object[0]).build();
        }

        private MethodSpec fieldsOffsetMethod() {
            return MethodSpec.methodBuilder((String)"fieldsOffset").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return offset() + FIELDS_OFFSET", new Object[0]).build();
        }

        private MethodSpec itemMethod() {
            ParameterizedTypeName consumerType = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{this.typeVarB});
            return MethodSpec.methodBuilder((String)"item").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.parameterizedArray8BuilderType).addParameter((TypeName)consumerType, "consumer", new Modifier[0]).addStatement("itemRW.wrap(this)", new Object[0]).addStatement("consumer.accept(itemRW)", new Object[0]).addStatement("itemRW.build()", new Object[0]).addStatement("maxLength = Math.max(maxLength, itemRW.sizeof())", new Object[0]).addStatement("checkLimit(itemRW.limit(), maxLimit())", new Object[0]).addStatement("limit(itemRW.limit())", new Object[0]).addStatement("fieldCount++", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec itemsMethod() {
            return MethodSpec.methodBuilder((String)"items").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.parameterizedArray8BuilderType).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "srcOffset", new Modifier[0]).addParameter(Integer.TYPE, "length", new Modifier[0]).addParameter(Integer.TYPE, "fieldCount", new Modifier[0]).addParameter(Integer.TYPE, "maxLength", new Modifier[0]).addStatement("buffer().putBytes(offset() + FIELDS_OFFSET, buffer, srcOffset, length)", new Object[0]).addStatement("int newLimit = offset() + FIELDS_OFFSET + length", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("limit(newLimit)", new Object[0]).addStatement("this.fieldCount = fieldCount", new Object[0]).addStatement("this.maxLength = maxLength", new Object[0]).addStatement("assert length <= LENGTH_MAX_VALUE : \"Length is too large\"", new Object[0]).addStatement("assert fieldCount <= LENGTH_MAX_VALUE : \"Field count is too large\"", new Object[0]).addStatement("buffer().putByte(offset() + LENGTH_OFFSET, (byte) (length + FIELD_COUNT_SIZE))", new Object[0]).addStatement("buffer().putByte(offset() + FIELD_COUNT_OFFSET, (byte) fieldCount)", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec wrapMethod() {
            return MethodSpec.methodBuilder((String)"wrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.parameterizedArray8BuilderType).addParameter((TypeName)TypeNames.MUTABLE_DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]).addStatement("int newLimit = offset + FIELDS_OFFSET", new Object[0]).addStatement("checkLimit(newLimit, maxLimit)", new Object[0]).addStatement("limit(newLimit)", new Object[0]).addStatement("fieldCount = 0", new Object[0]).addStatement("maxLength = 0", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec buildMethod() {
            return MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.parameterizedArray8Type).addStatement("int length = limit() - offset() - FIELD_COUNT_OFFSET", new Object[0]).addStatement("assert length <= LENGTH_MAX_VALUE : \"Length is too large\"", new Object[0]).addStatement("assert fieldCount <= LENGTH_MAX_VALUE : \"Field count is too large\"", new Object[0]).addStatement("buffer().putByte(offset() + LENGTH_OFFSET, (byte) length)", new Object[0]).addStatement("buffer().putByte(offset() + FIELD_COUNT_OFFSET, (byte) fieldCount)", new Object[0]).addStatement("final ArrayFW<V> array = super.build()", new Object[0]).addStatement("final int maxLimit = maxLimit()", new Object[0]).addStatement("limit(fieldsOffset())", new Object[0]).addStatement("int itemOffset = fieldsOffset()", new Object[0]).addStatement("itemRW.reset(this)", new Object[0]).beginControlFlow("for (int i = 0; i < fieldCount; i++)", new Object[0]).addStatement("final Flyweight item = itemRO.wrap(buffer(), itemOffset, maxLimit, array)", new Object[0]).addStatement("itemOffset = item.limit()", new Object[0]).addStatement("final Flyweight newItem = itemRW.wrap(this).rebuild((V) item, maxLength)", new Object[0]).addStatement("final int newLimit = newItem.limit()", new Object[0]).addStatement("assert newLimit <= itemOffset", new Object[0]).addStatement("limit(newLimit)", new Object[0]).endControlFlow().addStatement("length = limit() - offset() - FIELD_COUNT_OFFSET", new Object[0]).addStatement("buffer().putByte(offset() + LENGTH_OFFSET, (byte) length)", new Object[0]).addStatement("final Array8FW<V> array8 = super.build()", new Object[0]).addStatement("array8.maxLength(maxLength)", new Object[0]).addStatement("return array8", new Object[0]).build();
        }
    }
}

