/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.ast;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstAbstractMemberNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstByteOrder;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstType;

public final class AstListMemberNode
extends AstAbstractMemberNode {
    private final List<AstType> typeParams;
    private final boolean required;

    private AstListMemberNode(String name, List<AstType> types, int size, String sizeName, Object defaultValue, AstByteOrder byteOrder, List<AstType> typeParams, boolean required) {
        super(name, types, size, sizeName, defaultValue, byteOrder);
        this.typeParams = typeParams;
        this.required = required;
    }

    public List<AstType> typeParams() {
        return this.typeParams;
    }

    public boolean isRequired() {
        return this.required;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.types, this.defaultValue, this.byteOrder, this.typeParams, this.required});
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AstListMemberNode)) {
            return false;
        }
        AstListMemberNode that = (AstListMemberNode)o;
        return this.required == that.required && Objects.equals(this.name, that.name) && Objects.deepEquals(this.types, that.types) && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals((Object)this.byteOrder, (Object)that.byteOrder) && Objects.equals(this.typeParams, that.typeParams);
    }

    @Override
    public String toString() {
        return String.format("MEMBER [name=%s, types=%s, defaultValue=%s, byteOrder=%s, typeParams=%s, required=%s]", new Object[]{this.name, this.types, this.defaultValue, this.byteOrder, this.typeParams, this.required});
    }

    public static final class Builder
    extends AstAbstractMemberNode.Builder<AstListMemberNode> {
        private List<AstType> typeParams = new LinkedList<AstType>();
        private boolean required;

        public Builder typeParam(AstType typeParam) {
            this.typeParams.add(Objects.requireNonNull(typeParam));
            return this;
        }

        public Builder isRequired(boolean required) {
            this.required = required;
            return this;
        }

        @Override
        public AstListMemberNode build() {
            return new AstListMemberNode(this.name, this.types, this.size, this.sizeName, this.defaultValue, this.byteOrder, this.typeParams, this.required);
        }
    }
}

