/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.ast.visit;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstByteOrder;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstEnumNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstListNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstMapNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstNamedNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstScopeNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstStructNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstType;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstTypedefNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstUnionNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstVariantNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.visit.EnumVisitor;
import org.reaktivity.nukleus.maven.plugin.internal.ast.visit.ListVisitor;
import org.reaktivity.nukleus.maven.plugin.internal.ast.visit.StructVisitor;
import org.reaktivity.nukleus.maven.plugin.internal.ast.visit.UnionVisitor;
import org.reaktivity.nukleus.maven.plugin.internal.ast.visit.VariantVisitor;
import org.reaktivity.nukleus.maven.plugin.internal.generate.EnumFlyweightGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.EnumTypeGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.ListFlyweightGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.MapFlyweightGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.StructFlyweightGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeResolver;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeSpecGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.UnionFlyweightGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.VariantFlyweightGenerator;

public final class ScopeVisitor
extends AstNode.Visitor<Collection<TypeSpecGenerator<?>>> {
    private final String scopeName;
    private final String packageName;
    private final TypeResolver resolver;
    private final List<String> targetScopes;
    private final Collection<TypeSpecGenerator<?>> defaultResult;

    public ScopeVisitor(String scopeName, String packageName, TypeResolver resolver, List<String> targetScopes) {
        this.scopeName = Objects.requireNonNull(scopeName);
        this.packageName = Objects.requireNonNull(packageName);
        this.resolver = Objects.requireNonNull(resolver);
        this.targetScopes = Objects.requireNonNull(targetScopes);
        this.defaultResult = new LinkedList();
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitScope(AstScopeNode scopeNode) {
        if (!this.targetScopes.stream().anyMatch(this::shouldVisit)) {
            return this.defaultResult();
        }
        return (Collection)super.visitScope(scopeNode);
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitNestedScope(AstScopeNode scopeNode) {
        String nestedName = scopeNode.name();
        String subscopeName = String.format("%s::%s", this.scopeName, nestedName);
        String subpackageName = String.format("%s.%s", this.packageName, nestedName);
        return new ScopeVisitor(subscopeName, subpackageName, this.resolver, this.targetScopes).visitScope(scopeNode);
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitStruct(AstStructNode structNode) {
        if (!this.targetScopes.stream().anyMatch(this::shouldVisit)) {
            return this.defaultResult();
        }
        String baseName = structNode.name();
        AstType structType = AstType.dynamicType(String.format("%s::%s", this.scopeName, baseName));
        ClassName structName = this.resolver.resolveClass(structType);
        StructFlyweightGenerator generator = new StructFlyweightGenerator(structName, this.resolver.flyweightName(), baseName, this.resolver);
        generator.typeId(this.findTypeId(structNode));
        return new StructVisitor(generator, this.resolver).visitStruct(structNode);
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitTypedef(AstTypedefNode typedefNode) {
        if (!this.targetScopes.stream().anyMatch(this::shouldVisit)) {
            return this.defaultResult();
        }
        AstNamedNode originalNode = this.resolver.resolve(typedefNode.originalType().name());
        AstNamedNode newNode = originalNode.withName(typedefNode.name());
        AstNamedNode.Kind kind = newNode.getKind();
        switch (kind) {
            case STRUCT: {
                return this.visitStruct((AstStructNode)newNode);
            }
            case UNION: {
                return this.visitUnion((AstUnionNode)newNode);
            }
            case VARIANT: {
                return this.visitVariant((AstVariantNode)newNode);
            }
            case LIST: {
                return this.visitList((AstListNode)newNode);
            }
            case ENUM: {
                return this.visitEnum((AstEnumNode)newNode);
            }
            case TYPEDEF: {
                return this.visitTypedef((AstTypedefNode)newNode);
            }
        }
        return this.defaultResult();
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitMap(AstMapNode mapNode) {
        if (!this.targetScopes.stream().anyMatch(this::shouldVisit)) {
            return this.defaultResult();
        }
        AstVariantNode templateNode = (AstVariantNode)this.resolver.resolve(mapNode.templateMapType().name());
        if (AstType.MAP.equals(templateNode.of())) {
            String baseName = mapNode.name();
            AstType mapType = AstType.dynamicType(String.format("%s::%s", this.scopeName, baseName));
            ClassName mapName = this.resolver.resolveClass(mapType);
            ClassName templateMapTypeName = this.resolver.resolveClass(mapNode.templateMapType());
            ClassName mapKeyTypeName = this.resolver.resolveClass(mapNode.keyType());
            ClassName mapValueTypeName = this.resolver.resolveClass(mapNode.valueType());
            MapFlyweightGenerator generator = new MapFlyweightGenerator(mapName, this.resolver.flyweightName(), templateMapTypeName, mapNode.keyType(), mapKeyTypeName, mapNode.valueType(), mapValueTypeName, this.resolver);
            this.defaultResult.add(generator);
        }
        return this.defaultResult();
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitUnion(AstUnionNode unionNode) {
        if (!this.targetScopes.stream().anyMatch(this::shouldVisit)) {
            return this.defaultResult();
        }
        String baseName = unionNode.name();
        AstType unionType = AstType.dynamicType(String.format("%s::%s", this.scopeName, baseName));
        ClassName unionName = this.resolver.resolveClass(unionType);
        AstType unionSuperType = unionNode.superType();
        TypeName kindTypeName = unionNode.kindType().equals(AstType.UINT8) ? this.resolver.resolveType(AstType.UINT8) : this.resolver.resolveClass(unionNode.kindType());
        UnionFlyweightGenerator generator = new UnionFlyweightGenerator(unionName, this.resolver.flyweightName(), baseName, unionSuperType, kindTypeName, this.resolver);
        return new UnionVisitor(generator, this.resolver).visitUnion(unionNode);
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitEnum(AstEnumNode enumNode) {
        TypeName valueTypeName;
        if (!this.targetScopes.stream().anyMatch(this::shouldVisit)) {
            return this.defaultResult();
        }
        String baseName = enumNode.name();
        AstType enumType = AstType.dynamicType(String.format("%s::%s", this.scopeName, baseName));
        AstType valueType = enumNode.valueType();
        TypeName enumClassValueTypeName = valueTypeName = this.resolver.resolveType(valueType);
        TypeName unsignedValueTypeName = this.resolver.resolveUnsignedType(valueType);
        if (valueType != null && valueType.isDynamicType()) {
            AstVariantNode variantNode = (AstVariantNode)this.resolver.resolve(valueType.name());
            enumClassValueTypeName = this.resolver.resolveType(variantNode.of());
            unsignedValueTypeName = this.resolver.resolveUnsignedType(variantNode.of());
        }
        ClassName enumFlyweightName = this.resolver.resolveClass(enumType);
        ClassName enumTypeName = enumFlyweightName.peerClass(baseName);
        EnumTypeGenerator typeGenerator = new EnumTypeGenerator(enumTypeName, enumClassValueTypeName, unsignedValueTypeName);
        EnumFlyweightGenerator flyweightGenerator = new EnumFlyweightGenerator(enumFlyweightName, this.resolver.flyweightName(), enumTypeName, valueTypeName, enumClassValueTypeName, unsignedValueTypeName);
        return new EnumVisitor(typeGenerator, flyweightGenerator).visitEnum(enumNode);
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitVariant(AstVariantNode variantNode) {
        if (!this.targetScopes.stream().anyMatch(this::shouldVisit)) {
            return this.defaultResult();
        }
        String baseName = variantNode.name();
        AstType variantType = AstType.dynamicType(String.format("%s::%s", this.scopeName, baseName));
        ClassName variantName = this.resolver.resolveClass(variantType);
        TypeName kindTypeName = variantNode.kindType().equals(AstType.UINT8) ? this.resolver.resolveType(AstType.UINT8) : this.resolver.resolveClass(variantNode.kindType());
        AstType ofType = variantNode.of();
        ClassName flyweightName = this.resolver.flyweightName();
        TypeName ofTypeName = this.resolver.resolveType(variantNode.of());
        TypeName unsignedOfTypeName = this.resolver.resolveUnsignedType(variantNode.of());
        AstByteOrder byteOrder = variantNode.byteOrder();
        VariantFlyweightGenerator generator = new VariantFlyweightGenerator(variantName, flyweightName, baseName, kindTypeName, ofType, ofTypeName, unsignedOfTypeName, this.resolver, byteOrder);
        return new VariantVisitor(generator, this.resolver).visitVariant(variantNode);
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitList(AstListNode listNode) {
        if (!this.targetScopes.stream().anyMatch(this::shouldVisit)) {
            return this.defaultResult();
        }
        String baseName = listNode.name();
        AstType listType = AstType.dynamicType(String.format("%s::%s", this.scopeName, baseName));
        ClassName listName = this.resolver.resolveClass(listType);
        AstType templateType = listNode.templateType();
        TypeName lengthTypeName = this.resolver.resolveType(listNode.lengthType());
        TypeName fieldCountTypeName = this.resolver.resolveType(listNode.fieldCountType());
        Byte missingFieldByte = listNode.missingFieldByte();
        AstByteOrder byteOrder = listNode.byteOrder();
        ListFlyweightGenerator generator = new ListFlyweightGenerator(listName, this.resolver.resolveClass(AstType.LIST), baseName, templateType, lengthTypeName, fieldCountTypeName, missingFieldByte, this.resolver, byteOrder);
        return new ListVisitor(generator, this.resolver).visitList(listNode);
    }

    @Override
    protected Collection<TypeSpecGenerator<?>> defaultResult() {
        return this.defaultResult;
    }

    @Override
    protected Collection<TypeSpecGenerator<?>> aggregateResult(Collection<TypeSpecGenerator<?>> aggregate, Collection<TypeSpecGenerator<?>> nextResult) {
        if (nextResult != aggregate) {
            aggregate.addAll(nextResult);
        }
        return aggregate;
    }

    private boolean shouldVisit(String target) {
        return target.equals(this.scopeName) || this.scopeName.startsWith(target + "::") || target.startsWith(this.scopeName + "::");
    }

    private int findTypeId(AstStructNode structNode) {
        AstStructNode currentNode = structNode;
        while (currentNode != null && currentNode.typeId() == 0 && currentNode.supertype() != null) {
            AstNamedNode namedNode = this.resolver.resolve(currentNode.supertype().name());
            currentNode = namedNode.getKind() == AstNamedNode.Kind.STRUCT ? (AstStructNode)namedNode : null;
        }
        return currentNode != null ? currentNode.typeId() : 0;
    }
}

