/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.generate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.lang.model.element.Modifier;
import org.reaktivity.nukleus.maven.plugin.internal.generate.ClassSpecGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeNames;

public final class ArrayFWGenerator
extends ClassSpecGenerator {
    private final TypeSpec.Builder classBuilder;
    private final BuilderClassBuilder builderClassBuilder;
    private final TypeVariableName typeVarV;

    public ArrayFWGenerator(ClassName flyweightType) {
        super(flyweightType.peerClass("ArrayFW"));
        this.typeVarV = TypeVariableName.get((String)"V", (TypeName[])new TypeName[]{flyweightType});
        this.classBuilder = TypeSpec.classBuilder((ClassName)((ClassName)this.thisName)).superclass((TypeName)flyweightType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addTypeVariable(this.typeVarV);
        this.builderClassBuilder = new BuilderClassBuilder((ClassName)this.thisName, flyweightType);
    }

    @Override
    public TypeSpec generate() {
        return this.classBuilder.addMethod(this.lengthMethod()).addMethod(this.fieldCountMethod()).addMethod(this.fieldsOffsetMethod()).addMethod(this.maxLengthMethod()).addMethod(this.forEachMethod()).addMethod(this.anyMatchMethod()).addMethod(this.matchFirstMethod()).addMethod(this.isEmptyMethod()).addMethod(this.itemsMethod()).addMethod(this.maxLengthMutatorMethod()).addType(this.builderClassBuilder.build()).build();
    }

    private MethodSpec lengthMethod() {
        return MethodSpec.methodBuilder((String)"length").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(Integer.TYPE).build();
    }

    private MethodSpec fieldCountMethod() {
        return MethodSpec.methodBuilder((String)"fieldCount").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(Integer.TYPE).build();
    }

    private MethodSpec fieldsOffsetMethod() {
        return MethodSpec.methodBuilder((String)"fieldsOffset").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(Integer.TYPE).build();
    }

    private MethodSpec maxLengthMethod() {
        return MethodSpec.methodBuilder((String)"maxLength").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(Integer.TYPE).build();
    }

    private MethodSpec forEachMethod() {
        WildcardTypeName itemType = WildcardTypeName.supertypeOf((TypeName)this.typeVarV);
        ParameterizedTypeName consumerType = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{itemType});
        return MethodSpec.methodBuilder((String)"forEach").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(Void.TYPE).addParameter((TypeName)consumerType, "consumer", new Modifier[0]).build();
    }

    private MethodSpec anyMatchMethod() {
        WildcardTypeName itemType = WildcardTypeName.supertypeOf((TypeName)this.typeVarV);
        ParameterizedTypeName predicateType = ParameterizedTypeName.get((ClassName)ClassName.get(Predicate.class), (TypeName[])new TypeName[]{itemType});
        return MethodSpec.methodBuilder((String)"anyMatch").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(Boolean.TYPE).addParameter((TypeName)predicateType, "predicate", new Modifier[0]).build();
    }

    private MethodSpec matchFirstMethod() {
        WildcardTypeName itemType = WildcardTypeName.supertypeOf((TypeName)this.typeVarV);
        ParameterizedTypeName predicateType = ParameterizedTypeName.get((ClassName)ClassName.get(Predicate.class), (TypeName[])new TypeName[]{itemType});
        return MethodSpec.methodBuilder((String)"matchFirst").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)this.typeVarV).addParameter((TypeName)predicateType, "predicate", new Modifier[0]).build();
    }

    private MethodSpec isEmptyMethod() {
        return MethodSpec.methodBuilder((String)"isEmpty").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(Boolean.TYPE).build();
    }

    private MethodSpec itemsMethod() {
        return MethodSpec.methodBuilder((String)"items").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)TypeNames.DIRECT_BUFFER_TYPE).build();
    }

    private MethodSpec maxLengthMutatorMethod() {
        return MethodSpec.methodBuilder((String)"maxLength").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(Void.TYPE).addParameter(Integer.TYPE, "maxLength", new Modifier[0]).build();
    }

    private static final class BuilderClassBuilder {
        private final TypeSpec.Builder classBuilder;
        private final TypeVariableName typeVarB;
        private final TypeVariableName typeVarT;
        private final TypeName parameterizedBuilderType;

        private BuilderClassBuilder(ClassName arrayType, ClassName flyweightType) {
            TypeVariableName typeVarV = TypeVariableName.get((String)"V", (TypeName[])new TypeName[]{flyweightType});
            this.typeVarT = TypeVariableName.get((String)"T", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)arrayType, (TypeName[])new TypeName[]{typeVarV})});
            ClassName flyweightBuilderType = flyweightType.nestedClass("Builder");
            ClassName arrayBuilderType = arrayType.nestedClass("Builder");
            this.typeVarB = TypeVariableName.get((String)"B", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)flyweightBuilderType, (TypeName[])new TypeName[]{typeVarV})});
            this.parameterizedBuilderType = ParameterizedTypeName.get((ClassName)arrayBuilderType, (TypeName[])new TypeName[]{this.typeVarT, this.typeVarB, typeVarV});
            this.classBuilder = TypeSpec.classBuilder((String)arrayBuilderType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT, Modifier.STATIC}).superclass((TypeName)ParameterizedTypeName.get((ClassName)flyweightBuilderType, (TypeName[])new TypeName[]{this.typeVarT})).addTypeVariable(this.typeVarT).addTypeVariable(this.typeVarB).addTypeVariable(typeVarV);
        }

        public TypeSpec build() {
            return this.classBuilder.addMethod(this.constructor()).addMethod(this.itemMethod()).addMethod(this.itemsMethod()).addMethod(this.fieldsOffsetMethod()).build();
        }

        private MethodSpec constructor() {
            return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.typeVarT, "flyweight", new Modifier[0]).addStatement("super(flyweight)", new Object[0]).build();
        }

        private MethodSpec itemMethod() {
            ParameterizedTypeName consumerType = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{this.typeVarB});
            return MethodSpec.methodBuilder((String)"item").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)consumerType, "consumer", new Modifier[0]).returns(this.parameterizedBuilderType).build();
        }

        private MethodSpec itemsMethod() {
            return MethodSpec.methodBuilder((String)"items").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(this.parameterizedBuilderType).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "srcOffset", new Modifier[0]).addParameter(Integer.TYPE, "length", new Modifier[0]).addParameter(Integer.TYPE, "fieldCount", new Modifier[0]).addParameter(Integer.TYPE, "maxLength", new Modifier[0]).build();
        }

        private MethodSpec fieldsOffsetMethod() {
            return MethodSpec.methodBuilder((String)"fieldsOffset").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(Integer.TYPE).build();
        }
    }
}

