/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.generate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import javax.lang.model.element.Modifier;
import org.reaktivity.nukleus.maven.plugin.internal.generate.ClassSpecGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeNames;

public final class ListFWGenerator
extends ClassSpecGenerator {
    private final TypeSpec.Builder classBuilder;
    private final BuilderClassBuilder builderClassBuilder;

    public ListFWGenerator(ClassName flyweightType) {
        super(flyweightType.peerClass("ListFW"));
        this.classBuilder = TypeSpec.classBuilder((ClassName)((ClassName)this.thisName)).superclass((TypeName)flyweightType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
        this.builderClassBuilder = new BuilderClassBuilder((ClassName)this.thisName, flyweightType.nestedClass("Builder"));
    }

    @Override
    public TypeSpec generate() {
        return this.classBuilder.addMethod(this.lengthMethod()).addMethod(this.fieldCountMethod()).addMethod(this.fieldsMethod()).addType(this.builderClassBuilder.build()).build();
    }

    private MethodSpec lengthMethod() {
        return MethodSpec.methodBuilder((String)"length").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(Integer.TYPE).build();
    }

    public MethodSpec fieldCountMethod() {
        return MethodSpec.methodBuilder((String)"fieldCount").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(Integer.TYPE).build();
    }

    public MethodSpec fieldsMethod() {
        return MethodSpec.methodBuilder((String)"fields").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)TypeNames.DIRECT_BUFFER_TYPE).build();
    }

    private static final class BuilderClassBuilder {
        private final TypeSpec.Builder classBuilder;
        private final ClassName classType;
        private final ClassName visitorType;
        private final TypeName parameterizedListBuildertype;
        private final TypeVariableName typeVarT = TypeVariableName.get((String)"T");

        private BuilderClassBuilder(ClassName listType, ClassName builderRawType) {
            ParameterizedTypeName builderType = ParameterizedTypeName.get((ClassName)builderRawType, (TypeName[])new TypeName[]{this.typeVarT});
            this.parameterizedListBuildertype = ParameterizedTypeName.get((ClassName)listType.nestedClass("Builder"), (TypeName[])new TypeName[]{this.typeVarT});
            this.classType = listType.nestedClass("Builder");
            this.classBuilder = TypeSpec.classBuilder((String)this.classType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT, Modifier.STATIC}).addTypeVariable(TypeVariableName.get((String)"T", (TypeName[])new TypeName[]{listType})).superclass((TypeName)builderType);
            this.visitorType = builderRawType.nestedClass("Visitor");
        }

        public TypeSpec build() {
            return this.classBuilder.addMethod(this.constructor()).addMethod(this.fieldMethod()).addMethod(this.fieldsMethodViaVisitor()).addMethod(this.fieldsMethodViaBuffer()).build();
        }

        private MethodSpec constructor() {
            return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.typeVarT, "flyweight", new Modifier[0]).addStatement("super(flyweight)", new Object[0]).build();
        }

        private MethodSpec fieldMethod() {
            return MethodSpec.methodBuilder((String)"field").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(this.parameterizedListBuildertype).addParameter((TypeName)this.visitorType, "visitor", new Modifier[0]).build();
        }

        private MethodSpec fieldsMethodViaVisitor() {
            return MethodSpec.methodBuilder((String)"fields").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(this.parameterizedListBuildertype).addParameter(Integer.TYPE, "fieldCount", new Modifier[0]).addParameter((TypeName)this.visitorType, "visitor", new Modifier[0]).build();
        }

        private MethodSpec fieldsMethodViaBuffer() {
            return MethodSpec.methodBuilder((String)"fields").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(this.parameterizedListBuildertype).addParameter(Integer.TYPE, "fieldCount", new Modifier[0]).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "index", new Modifier[0]).addParameter(Integer.TYPE, "length", new Modifier[0]).build();
        }
    }
}

