/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.ast;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstNamedNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstType;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstUnionCaseNode;

public final class AstUnionNode
extends AstNamedNode {
    private final List<AstUnionCaseNode> cases;
    private final AstType superType;
    private final AstType kindType;

    @Override
    public <R> R accept(AstNode.Visitor<R> visitor) {
        return visitor.visitUnion(this);
    }

    @Override
    public AstNamedNode withName(String name) {
        return new AstUnionNode(name, this.cases, this.superType, this.kindType);
    }

    @Override
    public AstNamedNode.Kind getKind() {
        return AstNamedNode.Kind.UNION;
    }

    public List<AstUnionCaseNode> cases() {
        return this.cases;
    }

    public AstType superType() {
        return this.superType;
    }

    public AstType kindType() {
        return this.kindType;
    }

    @Override
    public int hashCode() {
        return this.superType != null ? this.superType.hashCode() << 13 ^ this.name.hashCode() << 11 ^ this.cases.hashCode() << 7 ^ this.kindType.hashCode() : this.name.hashCode() << 11 ^ this.cases.hashCode() << 7 ^ this.kindType.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AstUnionNode)) {
            return false;
        }
        AstUnionNode that = (AstUnionNode)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.cases, that.cases) && Objects.equals(this.superType, that.superType) && Objects.equals(this.kindType, that.kindType);
    }

    private AstUnionNode(String name, List<AstUnionCaseNode> cases, AstType superType, AstType kindType) {
        super(name);
        this.cases = Collections.unmodifiableList(cases);
        this.superType = superType;
        this.kindType = kindType;
    }

    public static final class Builder
    extends AstNamedNode.Builder<AstUnionNode> {
        private List<AstUnionCaseNode> cases = new LinkedList<AstUnionCaseNode>();
        private AstType superType;
        private AstType kindType;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder caseN(AstUnionCaseNode caseN) {
            this.cases.add(caseN);
            return this;
        }

        public Builder superType(AstType superType) {
            this.superType = superType;
            return this;
        }

        public Builder kindType(AstType kindType) {
            this.kindType = kindType;
            return this;
        }

        @Override
        public AstUnionNode build() {
            return new AstUnionNode(this.name, this.cases, this.superType, this.kindType);
        }
    }
}

