/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.generate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.lang.reflect.Type;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.lang.model.element.Modifier;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstAbstractMemberNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstByteOrder;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstNamedNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstType;
import org.reaktivity.nukleus.maven.plugin.internal.generate.ClassSpecGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.ClassSpecMixinGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.MethodSpecGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeNames;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeResolver;

public final class UnionFlyweightGenerator
extends ClassSpecGenerator {
    private static final Set<String> RESERVED_METHOD_NAMES = new HashSet<String>(Arrays.asList("offset", "buffer", "limit", "sizeof", "maxLimit", "wrap", "checkLimit", "build", "rewrap"));
    private final String baseName;
    private final TypeSpec.Builder builder;
    private final MemberFieldGenerator memberField;
    private final KindConstantGenerator memberKindConstant;
    private final MemberSizeConstantGenerator memberSizeConstant;
    private final MemberOffsetConstantGenerator memberOffsetConstant;
    private final KindAccessorGenerator kindAccessor;
    private final MemberAccessorGenerator memberAccessor;
    private final TryWrapMethodGenerator tryWrapMethod;
    private final WrapMethodGenerator wrapMethod;
    private final LimitMethodGenerator limitMethod;
    private final ToStringMethodGenerator toStringMethod;
    private final BuilderClassGenerator builderClass;

    public UnionFlyweightGenerator(ClassName unionName, ClassName flyweightName, String baseName, AstType superType, TypeName kindTypeName, TypeResolver resolver) {
        super(unionName);
        this.baseName = baseName;
        this.builder = TypeSpec.classBuilder((ClassName)unionName).superclass((TypeName)flyweightName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        this.memberKindConstant = new KindConstantGenerator(unionName, kindTypeName, this.builder);
        this.memberSizeConstant = new MemberSizeConstantGenerator(unionName, superType, kindTypeName, this.builder);
        this.memberOffsetConstant = new MemberOffsetConstantGenerator(unionName, superType, kindTypeName, this.builder);
        this.memberField = new MemberFieldGenerator(unionName, kindTypeName, this.builder);
        this.kindAccessor = new KindAccessorGenerator(unionName, kindTypeName, this.builder);
        this.memberAccessor = new MemberAccessorGenerator(unionName, flyweightName.nestedClass("Visitor"), this.builder);
        this.tryWrapMethod = new TryWrapMethodGenerator(kindTypeName);
        this.wrapMethod = new WrapMethodGenerator(kindTypeName);
        this.limitMethod = new LimitMethodGenerator(superType);
        this.toStringMethod = new ToStringMethodGenerator(superType);
        this.builderClass = new BuilderClassGenerator(unionName, flyweightName, superType, kindTypeName, resolver);
    }

    public UnionFlyweightGenerator addMember(Object value, String name, AstType type, TypeName typeName, TypeName unsignedType, int size, String sizeName, AstByteOrder byteOrder) {
        this.memberKindConstant.addMember(value, name);
        this.memberOffsetConstant.addMember(name);
        this.memberSizeConstant.addMember(name, typeName, size);
        this.memberField.addMember(name, typeName, byteOrder);
        this.memberAccessor.addMember(name, typeName, unsignedType, byteOrder);
        this.tryWrapMethod.addMember(value, name, typeName, size, sizeName);
        this.wrapMethod.addMember(value, name, typeName, size, sizeName);
        this.limitMethod.addMember(value, name, typeName);
        this.toStringMethod.addMember(value, name, typeName);
        this.builderClass.addMember(name, type, typeName, size, sizeName, byteOrder);
        return this;
    }

    public UnionFlyweightGenerator addParentMember(String name, AstType type, TypeName typeName, AstType unsignedType, TypeName unsignedTypeName, int size, String sizeName, TypeName sizeTypeName, boolean usedAsSize, Object defaultValue, AstByteOrder byteOrder) {
        this.memberSizeConstant.addParentMember(name, type, typeName);
        this.memberOffsetConstant.addParentMember(name, type, typeName);
        this.memberAccessor.addMember(name, typeName, unsignedTypeName, byteOrder);
        this.limitMethod.addParentMember(name);
        this.toStringMethod.addParentMember(name, typeName);
        this.builderClass.addParentMember(name, type, typeName, unsignedType, unsignedTypeName, size, sizeName, sizeTypeName, usedAsSize, defaultValue, byteOrder);
        return this;
    }

    public UnionFlyweightGenerator addMemberAfterParentMember() {
        this.memberSizeConstant.addKindSizeAfterParentMember();
        this.memberOffsetConstant.addKindOffsetAfterParentMember();
        this.builderClass.addMemberAfterParentMember();
        return this;
    }

    @Override
    public TypeSpec generate() {
        this.memberKindConstant.build();
        this.memberOffsetConstant.build();
        this.memberSizeConstant.build();
        this.memberField.build();
        this.kindAccessor.build();
        this.memberAccessor.build();
        return this.builder.addMethod(this.tryWrapMethod.generate()).addMethod(this.wrapMethod.generate()).addMethod(this.limitMethod.generate()).addMethod(this.toStringMethod.generate()).addType(this.builderClass.generate()).build();
    }

    private static boolean isStringType(ClassName classType) {
        String name = classType.simpleName();
        return "StringFW".equals(name) || UnionFlyweightGenerator.isString16Type(classType) || UnionFlyweightGenerator.isString32Type(classType);
    }

    private static boolean isString16Type(ClassName classType) {
        String name = classType.simpleName();
        return "String16FW".equals(name);
    }

    private static boolean isString32Type(ClassName classType) {
        String name = classType.simpleName();
        return "String32FW".equals(name);
    }

    private static boolean isVarintType(TypeName type) {
        return type instanceof ClassName && "Varint32FW".equals(((ClassName)type).simpleName()) || type instanceof ClassName && "Varint64FW".equals(((ClassName)type).simpleName());
    }

    private static boolean isVarbyteuintType(TypeName type) {
        return type instanceof ClassName && "Varbyteuint32FW".equals(((ClassName)type).simpleName());
    }

    private static String index(String fieldName) {
        return String.format("INDEX_%s", UnionFlyweightGenerator.constant(fieldName));
    }

    private static String initCap(String value) {
        return Character.toUpperCase(value.charAt(0)) + value.substring(1);
    }

    private static String kind(String fieldName) {
        return String.format("KIND_%s", UnionFlyweightGenerator.constant(fieldName));
    }

    private static String offset(String fieldName) {
        return String.format("FIELD_OFFSET_%s", UnionFlyweightGenerator.constant(fieldName));
    }

    private static String size(String fieldName) {
        return String.format("FIELD_SIZE_%s", UnionFlyweightGenerator.constant(fieldName));
    }

    private static String fieldName(TypeName type) {
        String fieldName = ((ClassName)type).simpleName();
        return String.format("%s%s", Character.valueOf(Character.toLowerCase(fieldName.charAt(0))), fieldName.substring(1, fieldName.length() - 2));
    }

    private static ClassName enumClassName(TypeName enumFWTypeName) {
        String enumFWName = ((ClassName)enumFWTypeName).simpleName();
        return ClassName.bestGuess((String)enumFWName.substring(0, enumFWName.length() - 2));
    }

    private static String enumRO(TypeName enumFWTypeName) {
        String enumFWName = ((ClassName)enumFWTypeName).simpleName();
        return String.format("%s%sRO", Character.valueOf(Character.toLowerCase(enumFWName.charAt(0))), enumFWName.substring(1, enumFWName.length() - 2));
    }

    private static String enumRW(TypeName enumFWTypeName) {
        String enumFWName = ((ClassName)enumFWTypeName).simpleName();
        return String.format("%s%sRW", Character.valueOf(Character.toLowerCase(enumFWName.charAt(0))), enumFWName.substring(1, enumFWName.length() - 2));
    }

    private static String constant(String fieldName) {
        return fieldName.replaceAll("([^_A-Z])([A-Z])", "$1_$2").toUpperCase();
    }

    private static String methodName(String name) {
        return RESERVED_METHOD_NAMES.contains(name) ? name + "$" : name;
    }

    private static final class BuilderClassGenerator
    extends ClassSpecGenerator {
        private final TypeSpec.Builder builder;
        private final ClassName unionType;
        private final MemberConstantGenerator memberConstant;
        private final MemberFieldGenerator memberField;
        private final MemberAccessorGenerator memberAccessor;
        private final MemberMutatorGenerator memberMutator;
        private final WrapMethodGenerator wrapMethod;
        private final BuildMethodGenerator buildMethod;
        private String priorFieldIfDefaulted;
        private boolean priorDefaultedIsPrimitive;
        private Object priorDefaultValue;
        private String priorSizeName;
        private TypeName priorSizeType;

        private BuilderClassGenerator(ClassName unionType, ClassName flyweightType, AstType superType, TypeName kindTypeName, TypeResolver resolver) {
            this(unionType.nestedClass("Builder"), flyweightType.nestedClass("Builder"), unionType, superType, kindTypeName, resolver);
        }

        private BuilderClassGenerator(ClassName thisType, ClassName builderRawType, ClassName unionType, AstType superType, TypeName kindTypeName, TypeResolver resolver) {
            super(thisType);
            this.builder = TypeSpec.classBuilder((String)thisType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).superclass((TypeName)ParameterizedTypeName.get((ClassName)builderRawType, (TypeName[])new TypeName[]{unionType}));
            this.unionType = unionType;
            this.wrapMethod = new WrapMethodGenerator(superType);
            this.memberConstant = new MemberConstantGenerator(thisType, superType, this.builder);
            this.memberField = new MemberFieldGenerator(thisType, kindTypeName, this.builder);
            this.memberAccessor = new MemberAccessorGenerator(thisType, kindTypeName, this.builder);
            this.memberMutator = new MemberMutatorGenerator(thisType, superType, kindTypeName, this.builder, resolver);
            this.buildMethod = new BuildMethodGenerator(unionType, superType, this.builder);
        }

        private void addMember(String name, AstType type, TypeName typeName, int size, String sizeName, AstByteOrder byteOrder) {
            this.memberMutator.lookaheadMember(name, typeName);
            this.memberField.addMember(name, typeName, byteOrder);
            this.memberAccessor.addMember(name, typeName, size, sizeName, byteOrder);
            this.memberMutator.addMember(name, type, typeName, sizeName);
        }

        private void addParentMember(String name, AstType type, TypeName typeName, AstType unsignedType, TypeName unsignedTypeName, int size, String sizeName, TypeName sizeTypeName, boolean usedAsSize, Object defaultValue, AstByteOrder byteOrder) {
            Consumer<CodeBlock.Builder> defaultPriorField = this.priorFieldIfDefaulted == null ? null : this::defaultPriorField;
            this.memberConstant.addParentMember(name);
            this.memberMutator.addParentMember(name, type, typeName, unsignedType, unsignedTypeName, usedAsSize, byteOrder, this.priorFieldIfDefaulted, defaultPriorField);
            this.buildMethod.addParentMember(name);
            if (defaultValue != null) {
                this.priorFieldIfDefaulted = name;
                this.priorDefaultedIsPrimitive = typeName.isPrimitive() || UnionFlyweightGenerator.isVarintType(typeName) || UnionFlyweightGenerator.isVarbyteuintType(typeName);
                this.priorDefaultValue = defaultValue;
                this.priorSizeName = sizeName;
                this.priorSizeType = sizeTypeName;
            } else {
                this.priorFieldIfDefaulted = null;
            }
        }

        private void addMemberAfterParentMember() {
            this.memberMutator.addKindAfterParentMember();
        }

        @Override
        public TypeSpec generate() {
            this.memberField.build();
            this.memberAccessor.build();
            this.memberMutator.build();
            this.memberConstant.build();
            this.buildMethod.build();
            return this.builder.addMethod(this.constructor()).addMethod(this.wrapMethod.generate()).build();
        }

        private MethodSpec constructor() {
            return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super(new $T())", new Object[]{this.unionType}).build();
        }

        private static String defaultName(String fieldName) {
            return String.format("DEFAULT_%s", UnionFlyweightGenerator.constant(fieldName));
        }

        private static String dynamicOffset(String fieldName) {
            return String.format("dynamicOffset%s", UnionFlyweightGenerator.initCap(fieldName));
        }

        private void defaultPriorField(CodeBlock.Builder code) {
            if (this.priorDefaultValue != null && this.priorDefaultedIsPrimitive) {
                code.addStatement("$L($L)", new Object[]{this.priorFieldIfDefaulted, BuilderClassGenerator.defaultName(this.priorFieldIfDefaulted)});
            } else if (this.priorDefaultValue == AstAbstractMemberNode.NULL_DEFAULT) {
                if (UnionFlyweightGenerator.isVarintType(this.priorSizeType)) {
                    code.addStatement("$L(-1)", new Object[]{UnionFlyweightGenerator.methodName(this.priorSizeName)}).addStatement("lastFieldSet = $L", new Object[]{UnionFlyweightGenerator.index(this.priorFieldIfDefaulted)});
                } else if (UnionFlyweightGenerator.isVarbyteuintType(this.priorSizeType)) {
                    code.addStatement("$L(0)", new Object[]{UnionFlyweightGenerator.methodName(this.priorSizeName)}).addStatement("lastFieldSet = $L", new Object[]{UnionFlyweightGenerator.index(this.priorFieldIfDefaulted)});
                } else {
                    code.addStatement("$L(b -> { })", new Object[]{this.priorFieldIfDefaulted});
                    code.addStatement("int limit = limit()", new Object[0]);
                    code.addStatement("limit($L)", new Object[]{BuilderClassGenerator.dynamicOffset(this.priorSizeName)});
                    code.addStatement("$L(-1)", new Object[]{UnionFlyweightGenerator.methodName(this.priorSizeName)});
                    code.addStatement("limit(limit)", new Object[0]);
                }
            } else {
                code.addStatement("$L(b -> { })", new Object[]{this.priorFieldIfDefaulted});
            }
        }

        private final class BuildMethodGenerator
        extends ClassSpecMixinGenerator {
            private String lastParentMemberName;
            private final AstType superType;

            private BuildMethodGenerator(ClassName thisType, AstType superType, TypeSpec.Builder builder) {
                super(thisType, builder);
                this.superType = superType;
            }

            public BuildMethodGenerator addParentMember(String name) {
                this.lastParentMemberName = name;
                return this;
            }

            @Override
            public TypeSpec.Builder build() {
                if (this.superType != null) {
                    this.builder.addMethod(MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addStatement("assert lastFieldSet == $L : \"Field \\\"$L\\\" is not set\"", new Object[]{UnionFlyweightGenerator.index(this.lastParentMemberName), this.lastParentMemberName}).addStatement("return super.build()", new Object[0]).build());
                }
                return super.build();
            }
        }

        private final class WrapMethodGenerator
        extends MethodSpecGenerator {
            private WrapMethodGenerator(AstType superType) {
                super(MethodSpec.methodBuilder((String)"wrap").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(BuilderClassGenerator.this.thisName).addParameter((TypeName)TypeNames.MUTABLE_DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]));
                if (superType != null) {
                    this.builder.addStatement("lastFieldSet = -1", new Object[0]);
                }
                this.builder.addStatement("return this", new Object[0]);
            }

            @Override
            public MethodSpec generate() {
                return this.builder.build();
            }
        }

        private static final class MemberMutatorGenerator
        extends ClassSpecMixinGenerator {
            private static final Map<TypeName, String> PUTTER_NAMES;
            private static final Map<TypeName, String[]> UNSIGNED_INT_RANGES;
            private final TypeResolver resolver;
            private boolean priorFieldIsAutomaticallySet;
            private String nextName;
            private TypeName nextType;
            private String deferredName;
            private AstType deferredType;
            private TypeName deferredTypeName;
            private String deferredSizeName;
            private String lastParentMemberName;

            private MemberMutatorGenerator(ClassName thisType, AstType superType, TypeName kindTypeName, TypeSpec.Builder builder, TypeResolver resolver) {
                super(thisType, builder);
                this.resolver = resolver;
                if (superType == null) {
                    MethodSpec.Builder kindMethodBuilder = MethodSpec.methodBuilder((String)"kind").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)thisType);
                    if (kindTypeName.isPrimitive()) {
                        kindMethodBuilder.addParameter(Integer.TYPE, "value", new Modifier[0]).addStatement("buffer().putByte(offset() + $L, (byte)(value & 0xFF))", new Object[]{UnionFlyweightGenerator.offset("kind")});
                    } else {
                        kindMethodBuilder.addParameter((TypeName)UnionFlyweightGenerator.enumClassName(kindTypeName), "value", new Modifier[0]).addStatement("$L.wrap(buffer(), offset(), maxLimit())", new Object[]{UnionFlyweightGenerator.enumRW(kindTypeName)}).addStatement("$L.set(value)", new Object[]{UnionFlyweightGenerator.enumRW(kindTypeName)}).addStatement("limit($L.build().limit())", new Object[]{UnionFlyweightGenerator.enumRW(kindTypeName)});
                    }
                    kindMethodBuilder.addStatement("return this", new Object[0]);
                    builder.addMethod(kindMethodBuilder.build());
                }
            }

            public void lookaheadMember(String name, TypeName type) {
                this.nextName = name;
                this.nextType = type;
                this.addDeferredMemberIfNecessary();
            }

            public MemberMutatorGenerator addMember(String name, AstType type, TypeName typeName, String sizeName) {
                this.deferredName = name;
                this.deferredType = type;
                this.deferredTypeName = typeName;
                this.deferredSizeName = sizeName;
                return this;
            }

            public MemberMutatorGenerator addParentMember(String name, AstType type, TypeName typeName, AstType unsignedType, TypeName unsignedTypeName, boolean usedAsSize, AstByteOrder byteOrder, String priorFieldIfDefaulted, Consumer<CodeBlock.Builder> defaultPriorField) {
                boolean automaticallySet;
                boolean bl = automaticallySet = usedAsSize && !UnionFlyweightGenerator.isVarintType(typeName) && !UnionFlyweightGenerator.isVarbyteuintType(typeName);
                if (typeName.isPrimitive()) {
                    this.addPrimitiveParentMember(name, type, typeName, unsignedType, unsignedTypeName, usedAsSize, byteOrder, priorFieldIfDefaulted, defaultPriorField);
                }
                this.priorFieldIsAutomaticallySet = automaticallySet;
                this.lastParentMemberName = name;
                return this;
            }

            private MemberMutatorGenerator addKindAfterParentMember() {
                this.builder.addMethod(MethodSpec.methodBuilder((String)"kind").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Integer.TYPE, "value", new Modifier[0]).returns((TypeName)this.thisType).addStatement("assert lastFieldSet == $L : \"Field \\\"$L\\\" is not set\"", new Object[]{UnionFlyweightGenerator.index(this.lastParentMemberName), this.lastParentMemberName}).addStatement("buffer().putByte(offset() + $L, (byte)(value & 0xFF))", new Object[]{UnionFlyweightGenerator.offset("kind")}).addStatement("return this", new Object[0]).build());
                return this;
            }

            private void addPrimitiveParentMember(String name, AstType type, TypeName typeName, AstType unsignedType, TypeName unsignedTypeName, boolean usedAsSize, AstByteOrder byteOrder, String priorFieldIfDefaulted, Consumer<CodeBlock.Builder> defaultPriorField) {
                boolean automaticallySet = usedAsSize && !UnionFlyweightGenerator.isVarintType(typeName) && !UnionFlyweightGenerator.isVarbyteuintType(typeName);
                String putterName = PUTTER_NAMES.get(typeName);
                if (putterName == null) {
                    throw new IllegalStateException("member type not supported: " + typeName);
                }
                TypeName generateTypeName = unsignedTypeName != null ? unsignedTypeName : typeName;
                CodeBlock.Builder code = CodeBlock.builder();
                if (unsignedTypeName != null) {
                    this.generateUnsignedIntRangeCheck(name, typeName, code);
                }
                if (priorFieldIfDefaulted != null) {
                    this.generateDefaultPriorField(priorFieldIfDefaulted, defaultPriorField, code);
                }
                if (!automaticallySet) {
                    code.addStatement("assert lastFieldSet == $L - 1", new Object[]{UnionFlyweightGenerator.index(name)});
                }
                code.addStatement("int newLimit = limit() + $L", new Object[]{UnionFlyweightGenerator.size(name)}).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]);
                if (type.bits() == 24) {
                    if (byteOrder == AstByteOrder.NETWORK) {
                        code.addStatement("buffer().putByte(limit(), (byte) (value >> 16))", new Object[0]);
                        code.addStatement("buffer().putByte(limit() + 1, (byte) (value >> 8))", new Object[0]);
                        code.addStatement("buffer().putByte(limit() + 2, (byte) value)", new Object[0]);
                    } else {
                        code.beginControlFlow("if ($T.NATIVE_BYTE_ORDER == $T.BIG_ENDIAN)", new Object[]{TypeNames.BUFFER_UTIL_TYPE, ByteOrder.class});
                        code.addStatement("buffer().putByte(limit(), (byte) (value >> 16))", new Object[0]);
                        code.addStatement("buffer().putByte(limit() + 1, (byte) (value >> 8))", new Object[0]);
                        code.addStatement("buffer().putByte(limit() + 2, (byte) value)", new Object[0]);
                        code.nextControlFlow("else", new Object[0]);
                        code.addStatement("buffer().putByte(limit(), (byte) value)", new Object[0]);
                        code.addStatement("buffer().putByte(limit() + 1, (byte) (value >> 8))", new Object[0]);
                        code.addStatement("buffer().putByte(limit() + 2, (byte) (value >> 16))", new Object[0]);
                        code.endControlFlow();
                    }
                } else {
                    code.add("$[", new Object[0]).add("buffer().$L(limit(), ", new Object[]{putterName});
                    if (generateTypeName != typeName) {
                        code.add("($T)", new Object[]{typeName});
                        switch (type.bits()) {
                            case 8: {
                                code.add("(value & 0xFF)", new Object[0]);
                                break;
                            }
                            case 16: {
                                code.add("(value & 0xFFFF)", new Object[0]);
                                break;
                            }
                            case 24: {
                                code.add("(value & 0x00FF_FFFF)", new Object[0]);
                                break;
                            }
                            case 32: {
                                code.add("(value & 0xFFFF_FFFFL)", new Object[0]);
                                break;
                            }
                            default: {
                                code.add("value", new Object[0]);
                                break;
                            }
                        }
                    } else {
                        code.add("value", new Object[0]);
                    }
                    if (byteOrder == AstByteOrder.NETWORK && (typeName == TypeName.SHORT || typeName == TypeName.INT || typeName == TypeName.LONG)) {
                        code.add(", $T.BIG_ENDIAN", new Object[]{ByteOrder.class});
                    }
                    code.add(");\n$]", new Object[0]);
                }
                if (usedAsSize) {
                    code.addStatement("$L = limit()", new Object[]{MemberMutatorGenerator.dynamicOffset(name)});
                }
                if (!automaticallySet) {
                    code.addStatement("lastFieldSet = $L", new Object[]{UnionFlyweightGenerator.index(name)});
                }
                code.addStatement("limit(newLimit)", new Object[0]).addStatement("return this", new Object[0]);
                this.builder.addMethod(MethodSpec.methodBuilder((String)UnionFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{usedAsSize ? Modifier.PRIVATE : Modifier.PUBLIC}).addParameter(generateTypeName, "value", new Modifier[0]).returns((TypeName)this.thisType).addCode(code.build()).build());
            }

            private void generateUnsignedIntRangeCheck(String name, TypeName typeName, CodeBlock.Builder code) {
                String[] range = UNSIGNED_INT_RANGES.get(typeName);
                code.beginControlFlow("if (value < $L)", new Object[]{range[0]}).addStatement("throw new IllegalArgumentException(String.format($S, value))", new Object[]{String.format("Value %%d too low for field \"%s\"", name)}).endControlFlow();
                if (range[1] != null) {
                    code.beginControlFlow("if (value > $L)", new Object[]{range[1]}).addStatement("throw new IllegalArgumentException(String.format($S, value))", new Object[]{String.format("Value %%d too high for field \"%s\"", name)}).endControlFlow();
                }
            }

            private void generateDefaultPriorField(String priorFieldIfDefaulted, Consumer<CodeBlock.Builder> defaultPriorField, CodeBlock.Builder code) {
                if (this.priorFieldIsAutomaticallySet) {
                    code.beginControlFlow("if ($L == -1)", new Object[]{MemberMutatorGenerator.dynamicOffset(priorFieldIfDefaulted)});
                } else {
                    code.beginControlFlow("if (lastFieldSet < $L)", new Object[]{UnionFlyweightGenerator.index(priorFieldIfDefaulted)});
                }
                defaultPriorField.accept(code);
                code.endControlFlow();
            }

            private static String dynamicOffset(String fieldName) {
                return String.format("dynamicOffset%s", UnionFlyweightGenerator.initCap(fieldName));
            }

            @Override
            public TypeSpec.Builder build() {
                this.addDeferredMemberIfNecessary();
                return super.build();
            }

            private MemberMutatorGenerator addDeferredMemberIfNecessary() {
                if (this.deferredName == null || this.deferredTypeName == null) {
                    return this;
                }
                String name = this.deferredName;
                TypeName type = this.deferredTypeName;
                String sizeName = this.deferredSizeName;
                this.deferredName = null;
                this.deferredTypeName = null;
                this.deferredSizeName = null;
                if (type.isPrimitive()) {
                    this.addPrimitiveMember(name, type);
                } else {
                    this.addNonPrimitiveMember(name, type, sizeName);
                }
                return this;
            }

            private void addPrimitiveMember(String name, TypeName type) {
                String putterName = PUTTER_NAMES.get(type);
                if (putterName == null) {
                    throw new IllegalStateException("member type not supported: " + type);
                }
                String statement = String.format("buffer().%s(offset() + $L, value)", putterName);
                CodeBlock.Builder code = CodeBlock.builder().addStatement("kind($L)", new Object[]{UnionFlyweightGenerator.kind(name)}).addStatement(statement, new Object[]{UnionFlyweightGenerator.offset(name)});
                if (this.nextType instanceof ParameterizedTypeName) {
                    code.addStatement("$L(offset() + $L + $L)", new Object[]{this.nextName, UnionFlyweightGenerator.offset(name), UnionFlyweightGenerator.size(name)});
                }
                code.addStatement("limit(offset() + $L + $L)", new Object[]{UnionFlyweightGenerator.offset(name), UnionFlyweightGenerator.size(name)});
                code.addStatement("return this", new Object[0]);
                this.builder.addMethod(MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(type, "value", new Modifier[0]).returns((TypeName)this.thisType).addCode(code.build()).build());
            }

            private void addNonPrimitiveMember(String name, TypeName type, String sizeName) {
                if (type instanceof ClassName) {
                    ClassName className = (ClassName)type;
                    this.addClassType(name, className, sizeName);
                } else if (type instanceof ParameterizedTypeName) {
                    ParameterizedTypeName parameterizedType = (ParameterizedTypeName)type;
                    this.addParameterizedType(name, parameterizedType);
                } else {
                    this.builder.addMethod(MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter(type, "value", new Modifier[0]).addStatement("kind($L)", new Object[]{UnionFlyweightGenerator.kind(name)}).addStatement("$L().set(value)", new Object[]{name}).addStatement("return this", new Object[0]).build());
                }
            }

            private void addClassType(String name, ClassName className, String sizeName) {
                AstNamedNode kindNode = this.resolver.resolve(this.deferredType.name());
                if ("String8FW".equals(className.simpleName()) || "String16FW".equals(className.simpleName()) || "String32FW".equals(className.simpleName())) {
                    CodeBlock.Builder codeBlock = CodeBlock.builder();
                    ClassName builderType = className.nestedClass("Builder");
                    codeBlock.addStatement("kind($L)", new Object[]{UnionFlyweightGenerator.kind(name)}).addStatement("$T $L = $L()", new Object[]{builderType, name, name}).addStatement("$L.set(value, $T.UTF_8)", new Object[]{name, StandardCharsets.class});
                    if (this.nextType instanceof ParameterizedTypeName) {
                        codeBlock.addStatement("$L($L.build().limit())", new Object[]{this.nextName, name});
                    }
                    codeBlock.addStatement("limit($L.build().limit())", new Object[]{name}).addStatement("return this", new Object[0]);
                    this.builder.addMethod(MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter(String.class, "value", new Modifier[0]).addCode(codeBlock.build()).build());
                    codeBlock = CodeBlock.builder();
                    codeBlock.addStatement("kind($L)", new Object[]{UnionFlyweightGenerator.kind(name)}).addStatement("$T $L = $L()", new Object[]{builderType, name, name}).addStatement("$L.set(value)", new Object[]{name});
                    if (this.nextType instanceof ParameterizedTypeName) {
                        codeBlock.addStatement("$L($L.build().limit())", new Object[]{this.nextName, name});
                    }
                    codeBlock.addStatement("limit($L.build().limit())", new Object[]{name}).addStatement("return this", new Object[0]);
                    this.builder.addMethod(MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter(this.resolver.resolveType(AstType.STRING), "value", new Modifier[0]).addCode(codeBlock.build()).build());
                } else if (TypeNames.DIRECT_BUFFER_TYPE.equals((Object)className)) {
                    this.addDirectBufferType(name);
                } else if (kindNode != null && kindNode.getKind() == AstNamedNode.Kind.LIST) {
                    ClassName builderType = className.nestedClass("Builder");
                    CodeBlock.Builder code = CodeBlock.builder().addStatement("final int fieldCount = value.fieldCount()", new Object[0]).addStatement("final $T fields = value.fields()", new Object[]{TypeNames.DIRECT_BUFFER_TYPE}).addStatement("final int length = fields.capacity()", new Object[0]).addStatement("kind($L)", new Object[]{UnionFlyweightGenerator.kind(name)}).addStatement("$T $L = $L()", new Object[]{builderType, name, name}).addStatement("$L.fields(fieldCount, fields, 0, length)", new Object[]{name}).addStatement("limit($L.build().limit())", new Object[]{name}).addStatement("return this", new Object[0]);
                    this.builder.addMethod(MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter((TypeName)className, "value", new Modifier[0]).addCode(code.build()).build());
                } else {
                    ClassName consumerType = ClassName.get(Consumer.class);
                    ClassName builderType = className.nestedClass("Builder");
                    ParameterizedTypeName mutatorType = ParameterizedTypeName.get((ClassName)consumerType, (TypeName[])new TypeName[]{builderType});
                    CodeBlock.Builder code = CodeBlock.builder().addStatement("kind($L)", new Object[]{UnionFlyweightGenerator.kind(name)});
                    if (sizeName != null) {
                        code.addStatement("$T $L = $L(maxLimit())", new Object[]{builderType, name, name});
                    } else {
                        code.addStatement("$T $L = $L()", new Object[]{builderType, name, name});
                    }
                    code.addStatement("mutator.accept($L)", new Object[]{name}).addStatement("limit($L.build().limit())", new Object[]{name}).addStatement("return this", new Object[0]);
                    this.builder.addMethod(MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter((TypeName)mutatorType, "mutator", new Modifier[0]).addCode(code.build()).build());
                    code = CodeBlock.builder();
                    code.addStatement("kind($L)", new Object[]{UnionFlyweightGenerator.kind(name)}).addStatement("int newLimit = limit() + field.sizeof()", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("buffer().putBytes(limit(), field.buffer(), field.offset(), field.sizeof())", new Object[0]).addStatement("limit(newLimit)", new Object[0]).addStatement("return this", new Object[0]);
                    this.builder.addMethod(MethodSpec.methodBuilder((String)UnionFlyweightGenerator.methodName(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter((TypeName)className, "field", new Modifier[0]).addCode(code.build()).build());
                }
            }

            private void addDirectBufferType(String name) {
                TypeVariableName typeVarT = TypeVariableName.get((String)"T");
                ClassName biconsumerRawType = ClassName.get(BiConsumer.class);
                ParameterizedTypeName consumerType = ParameterizedTypeName.get(Consumer.class, (Type[])new Type[]{byte[].class});
                ParameterizedTypeName converterType = ParameterizedTypeName.get((ClassName)biconsumerRawType, (TypeName[])new TypeName[]{typeVarT, consumerType});
                this.builder.addMethod(MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(typeVarT).addParameter((TypeName)typeVarT, "value", new Modifier[0]).addParameter((TypeName)converterType, "converter", new Modifier[0]).returns((TypeName)this.thisType).addStatement("converter.accept(value, this::$L)", new Object[]{name}).addStatement("return this", new Object[0]).build());
                this.builder.addMethod(MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "value", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "length", new Modifier[0]).returns((TypeName)this.thisType).addStatement("kind($L)", new Object[]{UnionFlyweightGenerator.kind(name)}).addStatement("$L().putBytes(0, value, offset, length)", new Object[]{name}).addStatement("limit(offset() + $L + length)", new Object[]{UnionFlyweightGenerator.offset(name)}).addStatement("return this", new Object[0]).build());
                this.builder.addMethod(MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "value", new Modifier[0]).returns((TypeName)this.thisType).addStatement("kind($L)", new Object[]{UnionFlyweightGenerator.kind(name)}).addStatement("$L().putBytes(0, value, 0, value.capacity())", new Object[]{name}).addStatement("limit(offset() + $L + value.capacity())", new Object[]{UnionFlyweightGenerator.offset(name)}).addStatement("return this", new Object[0]).build());
                this.builder.addMethod(MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeNames.BYTE_ARRAY, "value", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "length", new Modifier[0]).returns((TypeName)this.thisType).addStatement("kind($L)", new Object[]{UnionFlyweightGenerator.kind(name)}).addStatement("$L().putBytes(0, value, offset, length)", new Object[]{name}).addStatement("limit(offset() + $L + length)", new Object[]{UnionFlyweightGenerator.offset(name)}).addStatement("return this", new Object[0]).build());
                this.builder.addMethod(MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeNames.BYTE_ARRAY, "value", new Modifier[0]).returns((TypeName)this.thisType).addStatement("kind($L)", new Object[]{UnionFlyweightGenerator.kind(name)}).addStatement("$L().putBytes(0, value, 0, value.length)", new Object[]{name}).addStatement("limit(offset() + $L + value.length)", new Object[]{UnionFlyweightGenerator.offset(name)}).addStatement("return this", new Object[0]).build());
                this.builder.addMethod(MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, "value", new Modifier[0]).returns((TypeName)this.thisType).addStatement("kind($L)", new Object[]{UnionFlyweightGenerator.kind(name)}).addStatement("int length = buffer().putStringWithoutLengthUtf8(offset() + $L, value)", new Object[]{UnionFlyweightGenerator.offset(name)}).addStatement("limit(offset() + $L + length)", new Object[]{UnionFlyweightGenerator.offset(name)}).addStatement("return this", new Object[0]).build());
            }

            private void addParameterizedType(String name, ParameterizedTypeName parameterizedType) {
                ClassName consumerType = ClassName.get(Consumer.class);
                ClassName itemType = (ClassName)parameterizedType.typeArguments.get(0);
                ClassName itemBuilderType = itemType.nestedClass("Builder");
                ParameterizedTypeName mutatorType = ParameterizedTypeName.get((ClassName)consumerType, (TypeName[])new TypeName[]{itemBuilderType});
                this.builder.addMethod(MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.thisType).addParameter((TypeName)mutatorType, "mutator", new Modifier[0]).addStatement("kind($L)", new Object[]{UnionFlyweightGenerator.kind(name)}).addStatement("$L().item(mutator)", new Object[]{name}).addStatement("super.limit($LRW.limit())", new Object[]{name}).addStatement("return this", new Object[0]).build());
            }

            static {
                HashMap<TypeName, String> putterNames = new HashMap<TypeName, String>();
                putterNames.put(TypeName.BYTE, "putByte");
                putterNames.put(TypeName.CHAR, "putChar");
                putterNames.put(TypeName.SHORT, "putShort");
                putterNames.put(TypeName.FLOAT, "putFloat");
                putterNames.put(TypeName.INT, "putInt");
                putterNames.put(TypeName.DOUBLE, "putDouble");
                putterNames.put(TypeName.LONG, "putLong");
                PUTTER_NAMES = Collections.unmodifiableMap(putterNames);
                HashMap<TypeName, String[]> unsigned = new HashMap<TypeName, String[]>();
                unsigned.put(TypeName.BYTE, new String[]{"0", "0XFF"});
                unsigned.put(TypeName.SHORT, new String[]{"0", "0xFFFF"});
                unsigned.put(TypeName.INT, new String[]{"0", "0xFFFFFFFFL"});
                unsigned.put(TypeName.LONG, new String[]{"0L", null});
                UNSIGNED_INT_RANGES = Collections.unmodifiableMap(unsigned);
            }
        }

        private static final class MemberAccessorGenerator
        extends ClassSpecMixinGenerator {
            private final TypeName kindTypeName;

            private MemberAccessorGenerator(ClassName thisType, TypeName kindTypeName, TypeSpec.Builder builder) {
                super(thisType, builder);
                this.kindTypeName = kindTypeName;
            }

            public MemberAccessorGenerator addMember(String name, TypeName type, int size, String sizeName, AstByteOrder byteOrder) {
                if (!type.isPrimitive()) {
                    if (TypeNames.DIRECT_BUFFER_TYPE.equals((Object)type)) {
                        Object limit = size >= 0 ? "offset() + " + UnionFlyweightGenerator.offset(name) + " + " + UnionFlyweightGenerator.size(name) : (sizeName != null ? sizeName + "()" : "maxLimit()");
                        this.builder.addMethod(MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PRIVATE}).beginControlFlow("if ($LRW == null)", new Object[]{name}).addStatement("$LRW = new $T(new byte[0])", new Object[]{name, TypeNames.UNSAFE_BUFFER_TYPE}).endControlFlow().addStatement("$LRW.wrap(buffer(), offset() + $L, $L)", new Object[]{name, UnionFlyweightGenerator.offset(name), limit}).addStatement("return $LRW", new Object[]{name}).returns((TypeName)TypeNames.MUTABLE_DIRECT_BUFFER_TYPE).build());
                    } else if (type instanceof ParameterizedTypeName) {
                        ParameterizedTypeName parameterizedType = (ParameterizedTypeName)type;
                        ClassName rawType = parameterizedType.rawType;
                        ClassName itemType = (ClassName)parameterizedType.typeArguments.get(0);
                        ClassName builderRawType = rawType.nestedClass("Builder");
                        ClassName itemBuilderType = itemType.nestedClass("Builder");
                        ParameterizedTypeName builderType = ParameterizedTypeName.get((ClassName)builderRawType, (TypeName[])new TypeName[]{itemBuilderType, itemType});
                        this.builder.addMethod(MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(Integer.TYPE, "offset", new Modifier[0]).beginControlFlow("if ($LRW == null)", new Object[]{name}).addStatement("$LRW = new $T(new $T(), new $T())", new Object[]{name, builderType, itemBuilderType, itemType}).endControlFlow().addStatement("return $LRW.wrap(buffer(), offset, maxLimit())", new Object[]{name}).returns((TypeName)builderType).build());
                    } else if (type instanceof ClassName) {
                        ClassName classType = (ClassName)type;
                        ClassName builderType = classType.nestedClass("Builder");
                        Object limit = size >= 0 ? "offset() + " + UnionFlyweightGenerator.offset(name) + " + " + UnionFlyweightGenerator.size(name) : (sizeName != null ? sizeName + "()" : "maxLimit()");
                        MethodSpec.Builder accessorBuilder = MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PRIVATE}).returns((TypeName)builderType);
                        if (this.kindTypeName.isPrimitive()) {
                            accessorBuilder.addStatement("int newLimit = $L", new Object[]{limit}).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]);
                        }
                        if ((UnionFlyweightGenerator.isString16Type(classType) || UnionFlyweightGenerator.isString32Type(classType)) && byteOrder == AstByteOrder.NETWORK) {
                            accessorBuilder.beginControlFlow("if ($LRW == null)", new Object[]{name}).addStatement("$LRW = new $T($T.BIG_ENDIAN)", new Object[]{name, builderType, ByteOrder.class}).endControlFlow();
                        } else {
                            accessorBuilder.beginControlFlow("if ($LRW == null)", new Object[]{name}).addStatement("$LRW = new $T()", new Object[]{name, builderType}).endControlFlow();
                        }
                        if (this.kindTypeName.isPrimitive()) {
                            accessorBuilder.addStatement("return $LRW.wrap(buffer(), offset() + $L, newLimit)", new Object[]{name, UnionFlyweightGenerator.offset(name)});
                        } else {
                            accessorBuilder.addStatement("return $LRW.wrap(buffer(), offset() + $L.sizeof(), maxLimit())", new Object[]{name, UnionFlyweightGenerator.enumRW(this.kindTypeName)});
                        }
                        this.builder.addMethod(accessorBuilder.build());
                        if (sizeName != null) {
                            this.builder.addMethod(MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(Integer.TYPE, "limit", new Modifier[0]).addStatement("return $LRW.wrap(buffer(), offset() + $L, limit)", new Object[]{name, UnionFlyweightGenerator.offset(name)}).returns((TypeName)builderType).build());
                        }
                    } else {
                        throw new IllegalArgumentException("Unsupported member type: " + type);
                    }
                }
                return this;
            }
        }

        private static final class MemberFieldGenerator
        extends ClassSpecMixinGenerator {
            private MemberFieldGenerator(ClassName thisType, TypeName kindTypeName, TypeSpec.Builder builder) {
                super(thisType, builder);
                if (!kindTypeName.isPrimitive()) {
                    ClassName builderType = ((ClassName)kindTypeName).nestedClass("Builder");
                    builder.addField(FieldSpec.builder((TypeName)builderType, (String)UnionFlyweightGenerator.enumRW(kindTypeName), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T()", new Object[]{builderType}).build());
                }
            }

            public MemberFieldGenerator addMember(String name, TypeName type, AstByteOrder byteOrder) {
                if (!type.isPrimitive()) {
                    String fieldRW = String.format("%sRW", name);
                    if (TypeNames.DIRECT_BUFFER_TYPE.equals((Object)type)) {
                        this.builder.addField(FieldSpec.builder((TypeName)TypeNames.MUTABLE_DIRECT_BUFFER_TYPE, (String)fieldRW, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
                    } else if (type instanceof ParameterizedTypeName) {
                        ParameterizedTypeName parameterizedType = (ParameterizedTypeName)type;
                        ClassName rawType = parameterizedType.rawType;
                        ClassName itemType = (ClassName)parameterizedType.typeArguments.get(0);
                        ClassName builderRawType = rawType.nestedClass("Builder");
                        ClassName itemBuilderType = itemType.nestedClass("Builder");
                        ParameterizedTypeName builderType = ParameterizedTypeName.get((ClassName)builderRawType, (TypeName[])new TypeName[]{itemBuilderType, itemType});
                        this.builder.addField(FieldSpec.builder((TypeName)builderType, (String)fieldRW, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
                    } else if (type instanceof ClassName) {
                        ClassName classType = (ClassName)type;
                        ClassName builderType = classType.nestedClass("Builder");
                        if ((UnionFlyweightGenerator.isString16Type(classType) || UnionFlyweightGenerator.isString32Type(classType)) && byteOrder == AstByteOrder.NETWORK) {
                            this.builder.addField(FieldSpec.builder((TypeName)builderType, (String)fieldRW, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
                        } else {
                            this.builder.addField(FieldSpec.builder((TypeName)builderType, (String)fieldRW, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
                        }
                    } else {
                        throw new IllegalArgumentException("Unsupported member type: " + type);
                    }
                }
                return this;
            }
        }

        private static final class MemberConstantGenerator
        extends ClassSpecMixinGenerator {
            private final AstType superType;
            private int nextIndex;

            private MemberConstantGenerator(ClassName thisType, AstType superType, TypeSpec.Builder builder) {
                super(thisType, builder);
                this.superType = superType;
            }

            public MemberConstantGenerator addParentMember(String name) {
                this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)UnionFlyweightGenerator.index(name), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(Integer.toString(this.nextIndex++), new Object[0]).build());
                return this;
            }

            @Override
            public TypeSpec.Builder build() {
                if (this.superType != null) {
                    this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)"lastFieldSet", (Modifier[])new Modifier[]{Modifier.PRIVATE}).initializer("-1", new Object[0]).build());
                }
                return super.build();
            }
        }
    }

    private final class ToStringMethodGenerator
    extends MethodSpecGenerator {
        private final AstType superType;
        private final StringBuilder fieldStringBuilder;
        private final StringBuilder fieldMethodBuilder;
        private String lastParentMemberName;

        private ToStringMethodGenerator(AstType superType) {
            super(MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).beginControlFlow("switch (kind())", new Object[0]));
            this.fieldStringBuilder = new StringBuilder();
            this.fieldMethodBuilder = new StringBuilder();
            this.superType = superType;
        }

        public ToStringMethodGenerator addMember(Object value, String name, TypeName typeName) {
            String fieldString = this.fieldStringBuilder.toString();
            String fieldMethod = this.fieldMethodBuilder.toString();
            this.builder.beginControlFlow("case $L:", new Object[]{value instanceof String ? value.toString() : UnionFlyweightGenerator.kind(name)});
            if (typeName instanceof ClassName && UnionFlyweightGenerator.isStringType((ClassName)typeName)) {
                this.builder.addStatement("return String.format(\"$L [$L$L=%s]\", $L$L().asString())", new Object[]{UnionFlyweightGenerator.constant(UnionFlyweightGenerator.this.baseName), fieldString, name, fieldMethod, name});
            } else if (typeName.isPrimitive()) {
                this.builder.addStatement("return String.format(\"$L [$L$L=%d]\", $L$L())", new Object[]{UnionFlyweightGenerator.constant(UnionFlyweightGenerator.this.baseName), fieldString, name, fieldMethod, name});
            } else {
                this.builder.addStatement("return String.format(\"$L [$L$L=%s]\", $L$L())", new Object[]{UnionFlyweightGenerator.constant(UnionFlyweightGenerator.this.baseName), fieldString, name, fieldMethod, name});
            }
            this.builder.endControlFlow();
            return this;
        }

        public ToStringMethodGenerator addParentMember(String name, TypeName typeName) {
            if (typeName.isPrimitive()) {
                this.fieldStringBuilder.append(String.format("%s=%%d, ", name));
                this.fieldMethodBuilder.append(String.format("%s(), ", name));
            } else if (typeName instanceof ClassName && UnionFlyweightGenerator.isStringType((ClassName)typeName)) {
                this.fieldMethodBuilder.append(String.format("%sRO.asString(), ", name));
            } else {
                this.fieldStringBuilder.append(String.format("%s=%%s, ", name));
                this.fieldMethodBuilder.append(String.format("%s(), ", name));
            }
            this.lastParentMemberName = name;
            return this;
        }

        @Override
        public MethodSpec generate() {
            this.builder.beginControlFlow("default:", new Object[0]);
            if (this.superType == null) {
                this.builder.addStatement("return String.format(\"$L [unknown]\")", new Object[]{UnionFlyweightGenerator.constant(UnionFlyweightGenerator.this.baseName)});
            } else {
                this.builder.addStatement("return String.format(\"$L [$L=%d]\", $L())", new Object[]{UnionFlyweightGenerator.constant(UnionFlyweightGenerator.this.baseName), this.lastParentMemberName, this.lastParentMemberName});
            }
            return this.builder.endControlFlow().endControlFlow().build();
        }
    }

    private final class WrapMethodGenerator
    extends MethodSpecGenerator {
        private final TypeName kindTypeName;

        private WrapMethodGenerator(TypeName kindTypeName) {
            super(MethodSpec.methodBuilder((String)"wrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(UnionFlyweightGenerator.this.thisName).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]));
            this.kindTypeName = kindTypeName;
            if (!kindTypeName.isPrimitive()) {
                this.builder.addStatement("final $T $L = $L.wrap(buffer, offset, maxLimit)", new Object[]{kindTypeName, UnionFlyweightGenerator.fieldName(kindTypeName), UnionFlyweightGenerator.enumRO(kindTypeName)});
            }
            this.builder.beginControlFlow("switch (kind())", new Object[0]);
        }

        public WrapMethodGenerator addMember(Object value, String name, TypeName type, int size, String sizeName) {
            this.builder.beginControlFlow("case $L:", new Object[]{value instanceof String ? value.toString() : UnionFlyweightGenerator.kind(name)});
            if (TypeNames.DIRECT_BUFFER_TYPE.equals((Object)type)) {
                this.builder.addStatement("$L().wrap(buffer, offset + $L, $L)", new Object[]{name, UnionFlyweightGenerator.offset(name), UnionFlyweightGenerator.size(name)});
            } else if (!type.isPrimitive()) {
                if (size >= 0) {
                    this.builder.addStatement("$L().wrap(buffer, offset + $L, offset + $L + $L)", new Object[]{name, UnionFlyweightGenerator.offset(name), UnionFlyweightGenerator.offset(name), size});
                } else if (sizeName != null) {
                    this.builder.addStatement("$L().wrap(buffer, offset + $L, offset + $L + $L())", new Object[]{name, UnionFlyweightGenerator.offset(name), UnionFlyweightGenerator.offset(name), sizeName});
                } else if (!this.kindTypeName.isPrimitive()) {
                    this.builder.addStatement("$L().wrap(buffer, offset + $L.sizeof(), maxLimit)", new Object[]{name, UnionFlyweightGenerator.fieldName(this.kindTypeName)});
                } else {
                    this.builder.addStatement("$L().wrap(buffer, offset + $L, maxLimit)", new Object[]{name, UnionFlyweightGenerator.offset(name)});
                }
            }
            this.builder.addStatement("break", new Object[0]).endControlFlow();
            return this;
        }

        @Override
        public MethodSpec generate() {
            return this.builder.beginControlFlow("default:", new Object[0]).addStatement("break", new Object[0]).endControlFlow().endControlFlow().addStatement("checkLimit(limit(), maxLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
        }
    }

    private final class TryWrapMethodGenerator
    extends MethodSpecGenerator {
        private final TypeName kindTypeName;

        private TryWrapMethodGenerator(TypeName kindTypeName) {
            super(MethodSpec.methodBuilder((String)"tryWrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(UnionFlyweightGenerator.this.thisName));
            this.kindTypeName = kindTypeName;
            this.addFailIfStatement("super.tryWrap(buffer, offset, maxLimit) == null", new Object[0]);
            if (!kindTypeName.isPrimitive()) {
                this.builder.addStatement("final $T $L = $L.tryWrap(buffer, offset, maxLimit)", new Object[]{kindTypeName, UnionFlyweightGenerator.fieldName(kindTypeName), UnionFlyweightGenerator.enumRO(kindTypeName)});
                this.addFailIfStatement(String.format("%s == null", UnionFlyweightGenerator.fieldName(kindTypeName)), new Object[0]);
            }
            this.builder.beginControlFlow("switch (kind())", new Object[0]);
        }

        public TryWrapMethodGenerator addMember(Object value, String name, TypeName type, int size, String sizeName) {
            this.builder.beginControlFlow("case $L:", new Object[]{value instanceof String ? value.toString() : UnionFlyweightGenerator.kind(name)});
            if (TypeNames.DIRECT_BUFFER_TYPE.equals((Object)type)) {
                this.addFailIfStatement("$L().tryWrap(buffer, offset + $L, $L) == null", name, UnionFlyweightGenerator.offset(name), UnionFlyweightGenerator.size(name));
            } else if (!type.isPrimitive()) {
                if (size >= 0) {
                    this.addFailIfStatement("$L().tryWrap(buffer, offset + $L, offset + $L + $L) == null", name, UnionFlyweightGenerator.offset(name), UnionFlyweightGenerator.offset(name), size);
                } else if (sizeName != null) {
                    this.addFailIfStatement("$L().tryWrap(buffer, offset + $L, offset + $L + $L()) == null", name, UnionFlyweightGenerator.offset(name), UnionFlyweightGenerator.offset(name), sizeName);
                } else if (!this.kindTypeName.isPrimitive()) {
                    this.addFailIfStatement("$L().tryWrap(buffer, offset + $L.sizeof(), maxLimit) == null", name, UnionFlyweightGenerator.fieldName(this.kindTypeName));
                } else {
                    this.addFailIfStatement("$L().tryWrap(buffer, offset + $L, maxLimit) == null", name, UnionFlyweightGenerator.offset(name));
                }
            }
            this.builder.addStatement("break", new Object[0]).endControlFlow();
            return this;
        }

        @Override
        public MethodSpec generate() {
            return this.builder.beginControlFlow("default:", new Object[0]).addStatement("break", new Object[0]).endControlFlow().endControlFlow().beginControlFlow("if (limit() > maxLimit)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("return this", new Object[0]).build();
        }

        private void addFailIfStatement(String string, Object ... args) {
            this.builder.beginControlFlow("if (" + string + ")", args);
            this.builder.addStatement("return null", new Object[0]);
            this.builder.endControlFlow();
        }
    }

    private final class LimitMethodGenerator
    extends MethodSpecGenerator {
        private final AstType superType;
        private String lastParentMemberName;

        private LimitMethodGenerator(AstType superType) {
            super(MethodSpec.methodBuilder((String)"limit").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).beginControlFlow("switch (kind())", new Object[0]));
            this.superType = superType;
        }

        public LimitMethodGenerator addMember(Object value, String name, TypeName type) {
            this.builder.beginControlFlow("case $L:", new Object[]{value instanceof String ? value.toString() : UnionFlyweightGenerator.kind(name)});
            if (TypeNames.DIRECT_BUFFER_TYPE.equals((Object)type) || type.isPrimitive()) {
                this.builder.addStatement("return offset() + $L + $L", new Object[]{UnionFlyweightGenerator.offset(name), UnionFlyweightGenerator.size(name)});
            } else {
                this.builder.addStatement("return $L().limit()", new Object[]{name});
            }
            this.builder.endControlFlow();
            return this;
        }

        public LimitMethodGenerator addParentMember(String name) {
            this.lastParentMemberName = name;
            return this;
        }

        @Override
        public MethodSpec generate() {
            this.builder.beginControlFlow("default:", new Object[0]);
            if (this.superType == null) {
                this.builder.addStatement("return offset()", new Object[0]);
            } else {
                this.builder.addStatement("return offset() + $L + $L", new Object[]{UnionFlyweightGenerator.offset(this.lastParentMemberName), UnionFlyweightGenerator.size(this.lastParentMemberName)});
            }
            return this.builder.endControlFlow().endControlFlow().build();
        }
    }

    private static final class MemberAccessorGenerator
    extends ClassSpecMixinGenerator {
        private static final Map<TypeName, String> GETTER_NAMES;
        private final ClassName visitorRawType;

        private MemberAccessorGenerator(ClassName thisType, ClassName visitorRawType, TypeSpec.Builder builder) {
            super(thisType, builder);
            this.visitorRawType = visitorRawType;
        }

        public MemberAccessorGenerator addMember(String name, TypeName type, TypeName unsignedType, AstByteOrder byteOrder) {
            TypeName publicType = unsignedType != null ? unsignedType : type;
            CodeBlock.Builder codeBlock = CodeBlock.builder();
            if (type.isPrimitive()) {
                String getterName = GETTER_NAMES.get(type);
                if (getterName == null) {
                    throw new IllegalStateException("member type not supported: " + type);
                }
                codeBlock.add("$[", new Object[0]).add("return ", new Object[0]);
                if (publicType != type) {
                    codeBlock.add("($T)(", new Object[]{publicType});
                }
                codeBlock.add("buffer().$L(offset() + $L", new Object[]{getterName, UnionFlyweightGenerator.offset(name)});
                if (publicType != type) {
                    if (type == TypeName.BYTE) {
                        codeBlock.add(") & 0xFF)", new Object[0]);
                    } else if (type == TypeName.SHORT) {
                        codeBlock.add(", $T.BIG_ENDIAN) & 0xFFFF)", new Object[]{ByteOrder.class});
                    } else if (type == TypeName.INT) {
                        codeBlock.add(", $T.BIG_ENDIAN) & 0xFFFF_FFFF)", new Object[]{ByteOrder.class});
                    } else {
                        codeBlock.add(")", new Object[0]);
                    }
                } else {
                    codeBlock.add(")", new Object[0]);
                }
                codeBlock.add(";\n$]", new Object[0]);
            } else {
                codeBlock.beginControlFlow("if ($LRO == null)", new Object[]{name});
                if (TypeNames.DIRECT_BUFFER_TYPE.equals((Object)type)) {
                    codeBlock.addStatement("$LRO = new $T(new byte[0])", new Object[]{name, TypeNames.UNSAFE_BUFFER_TYPE});
                } else if (type instanceof ParameterizedTypeName) {
                    ParameterizedTypeName parameterizedType = (ParameterizedTypeName)type;
                    TypeName typeArgument = (TypeName)parameterizedType.typeArguments.get(0);
                    codeBlock.addStatement("$LRO = new $T(new $T())", new Object[]{name, type, typeArgument});
                } else if (type instanceof ClassName && (UnionFlyweightGenerator.isString16Type((ClassName)type) || UnionFlyweightGenerator.isString32Type((ClassName)type)) && byteOrder == AstByteOrder.NETWORK) {
                    codeBlock.addStatement("$LRO = new $T($T.BIG_ENDIAN)", new Object[]{name, type, ByteOrder.class});
                } else {
                    codeBlock.addStatement("$LRO = new $T()", new Object[]{name, type});
                }
                codeBlock.endControlFlow();
                if (TypeNames.DIRECT_BUFFER_TYPE.equals((Object)type)) {
                    TypeVariableName typeVarT = TypeVariableName.get((String)"T");
                    ParameterizedTypeName visitorType = ParameterizedTypeName.get((ClassName)this.visitorRawType, (TypeName[])new TypeName[]{typeVarT});
                    this.builder.addMethod(MethodSpec.methodBuilder((String)name).addTypeVariable(typeVarT).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)visitorType, "visitor", new Modifier[0]).returns((TypeName)typeVarT).addStatement("return visitor.visit($LRO, 0, $L)", new Object[]{name, UnionFlyweightGenerator.size(name)}).build());
                }
                codeBlock.addStatement("return $LRO", new Object[]{name});
            }
            this.builder.addMethod(MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(publicType).addCode(codeBlock.build()).build());
            return this;
        }

        static {
            HashMap<TypeName, String> getterNames = new HashMap<TypeName, String>();
            getterNames.put(TypeName.BYTE, "getByte");
            getterNames.put(TypeName.CHAR, "getChar");
            getterNames.put(TypeName.SHORT, "getShort");
            getterNames.put(TypeName.FLOAT, "getFloat");
            getterNames.put(TypeName.INT, "getInt");
            getterNames.put(TypeName.DOUBLE, "getDouble");
            getterNames.put(TypeName.LONG, "getLong");
            GETTER_NAMES = Collections.unmodifiableMap(getterNames);
        }
    }

    private static final class KindAccessorGenerator
    extends ClassSpecMixinGenerator {
        private KindAccessorGenerator(ClassName thisType, TypeName kindTypeName, TypeSpec.Builder builder) {
            super(thisType, builder);
            MethodSpec.Builder kindMethodBuilder = MethodSpec.methodBuilder((String)"kind").addModifiers(new Modifier[]{Modifier.PUBLIC});
            if (kindTypeName.isPrimitive()) {
                kindMethodBuilder.addStatement("return buffer().getByte(offset() + $L) & 0xFF", new Object[]{UnionFlyweightGenerator.offset("kind")}).returns(Integer.TYPE);
            } else {
                kindMethodBuilder.addStatement("return $L.get()", new Object[]{UnionFlyweightGenerator.enumRO(kindTypeName)}).returns((TypeName)UnionFlyweightGenerator.enumClassName(kindTypeName));
            }
            builder.addMethod(kindMethodBuilder.build());
        }
    }

    private static final class MemberFieldGenerator
    extends ClassSpecMixinGenerator {
        private MemberFieldGenerator(ClassName thisType, TypeName kindTypeName, TypeSpec.Builder builder) {
            super(thisType, builder);
            if (!kindTypeName.isPrimitive()) {
                builder.addField(FieldSpec.builder((TypeName)kindTypeName, (String)UnionFlyweightGenerator.enumRO(kindTypeName), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T()", new Object[]{kindTypeName}).build());
            }
        }

        public MemberFieldGenerator addMember(String name, TypeName type, AstByteOrder byteOrder) {
            if (!type.isPrimitive()) {
                String fieldRO = String.format("%sRO", name);
                FieldSpec.Builder fieldBuilder = FieldSpec.builder((TypeName)type, (String)fieldRO, (Modifier[])new Modifier[]{Modifier.PRIVATE});
                this.builder.addField(fieldBuilder.build());
            }
            return this;
        }
    }

    private static final class MemberOffsetConstantGenerator
    extends ClassSpecMixinGenerator {
        private final TypeName kindTypeName;
        private String previousName;

        private MemberOffsetConstantGenerator(ClassName thisType, AstType superType, TypeName kindTypeName, TypeSpec.Builder builder) {
            super(thisType, builder);
            this.kindTypeName = kindTypeName;
            if (superType == null && kindTypeName.isPrimitive()) {
                builder.addField(FieldSpec.builder(Integer.TYPE, (String)UnionFlyweightGenerator.offset("kind"), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("0", new Object[0]).build());
            }
        }

        public MemberOffsetConstantGenerator addParentMember(String name, AstType type, TypeName typeName) {
            String initializer = this.previousName == null ? "0" : String.format("%s + %s", UnionFlyweightGenerator.offset(this.previousName), UnionFlyweightGenerator.size(this.previousName));
            this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)UnionFlyweightGenerator.offset(name), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(initializer, new Object[0]).build());
            boolean isFixedSize = typeName.isPrimitive();
            this.previousName = isFixedSize ? name : null;
            return this;
        }

        public MemberOffsetConstantGenerator addKindOffsetAfterParentMember() {
            this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)UnionFlyweightGenerator.offset("kind"), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(String.format("%s + %s", UnionFlyweightGenerator.offset(this.previousName), UnionFlyweightGenerator.size(this.previousName)), new Object[0]).build());
            return this;
        }

        public MemberOffsetConstantGenerator addMember(String name) {
            if (this.kindTypeName.isPrimitive()) {
                this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)UnionFlyweightGenerator.offset(name), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(String.format("%s + %s", UnionFlyweightGenerator.offset("kind"), UnionFlyweightGenerator.size("kind")), new Object[0]).build());
            }
            return this;
        }
    }

    private static final class MemberSizeConstantGenerator
    extends ClassSpecMixinGenerator {
        private static final Map<TypeName, String> SIZEOF_BY_NAME = MemberSizeConstantGenerator.initSizeofByName();

        private MemberSizeConstantGenerator(ClassName thisType, AstType superType, TypeName kindTypeName, TypeSpec.Builder builder) {
            super(thisType, builder);
            if (superType == null && kindTypeName.isPrimitive()) {
                builder.addField(FieldSpec.builder(Integer.TYPE, (String)UnionFlyweightGenerator.size("kind"), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.SIZE_OF_BYTE", new Object[]{TypeNames.BIT_UTIL_TYPE}).build());
            }
        }

        public MemberSizeConstantGenerator addParentMember(String name, AstType type, TypeName typeName) {
            if (typeName.isPrimitive()) {
                this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)UnionFlyweightGenerator.size(name), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.SIZE_OF_$L", new Object[]{TypeNames.BIT_UTIL_TYPE, SIZEOF_BY_NAME.get(typeName)}).build());
            }
            return this;
        }

        public MemberSizeConstantGenerator addKindSizeAfterParentMember() {
            this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)UnionFlyweightGenerator.size("kind"), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.SIZE_OF_BYTE", new Object[]{TypeNames.BIT_UTIL_TYPE}).build());
            return this;
        }

        public MemberSizeConstantGenerator addMember(String name, TypeName typeName, int size) {
            if (typeName.isPrimitive()) {
                this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)UnionFlyweightGenerator.size(name), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.SIZE_OF_$L", new Object[]{TypeNames.BIT_UTIL_TYPE, SIZEOF_BY_NAME.get(typeName)}).build());
            } else if (size > 0) {
                this.builder.addField(FieldSpec.builder(Integer.TYPE, (String)UnionFlyweightGenerator.size(name), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$L", new Object[]{size}).build());
            }
            return this;
        }

        private static Map<TypeName, String> initSizeofByName() {
            HashMap<TypeName, String> sizeofByName = new HashMap<TypeName, String>();
            sizeofByName.put(TypeName.BOOLEAN, "BOOLEAN");
            sizeofByName.put(TypeName.BYTE, "BYTE");
            sizeofByName.put(TypeName.CHAR, "CHAR");
            sizeofByName.put(TypeName.SHORT, "SHORT");
            sizeofByName.put(TypeName.INT, "INT");
            sizeofByName.put(TypeName.FLOAT, "FLOAT");
            sizeofByName.put(TypeName.LONG, "LONG");
            sizeofByName.put(TypeName.DOUBLE, "DOUBLE");
            return sizeofByName;
        }
    }

    private static final class KindConstantGenerator
    extends ClassSpecMixinGenerator {
        private final TypeName kindTypeName;

        private KindConstantGenerator(ClassName thisType, TypeName kindTypeName, TypeSpec.Builder builder) {
            super(thisType, builder);
            this.kindTypeName = kindTypeName;
        }

        public KindConstantGenerator addMember(Object value, String name) {
            FieldSpec kindConstant = value instanceof String ? FieldSpec.builder((TypeName)UnionFlyweightGenerator.enumClassName(this.kindTypeName), (String)UnionFlyweightGenerator.kind(name), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$T.$L", new Object[]{UnionFlyweightGenerator.enumClassName(this.kindTypeName), value}).build() : FieldSpec.builder(Integer.TYPE, (String)UnionFlyweightGenerator.kind(name), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$L", new Object[]{value}).build();
            this.builder.addField(kindConstant);
            return this;
        }
    }
}

