/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.maven.plugins.nukleus.internal.ast;

import java.util.Objects;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstNamedNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstType;

public final class AstTypedefNode
extends AstNamedNode {
    private final AstType originalType;

    @Override
    public <R> R accept(AstNode.Visitor<R> visitor) {
        return visitor.visitTypedef(this);
    }

    public AstType originalType() {
        return this.originalType;
    }

    @Override
    public AstNamedNode withName(String name) {
        return new AstTypedefNode(name, this.originalType);
    }

    @Override
    public AstNamedNode.Kind getKind() {
        return AstNamedNode.Kind.TYPEDEF;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() << 7 ^ this.originalType.hashCode() << 3;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AstTypedefNode)) {
            return false;
        }
        AstTypedefNode that = (AstTypedefNode)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.originalType, that.originalType);
    }

    private AstTypedefNode(String name, AstType originalType) {
        super(name);
        this.originalType = originalType;
    }

    public static final class Builder
    extends AstNamedNode.Builder<AstTypedefNode> {
        private AstType originalType;

        public Builder originalType(AstType originalType) {
            this.originalType = originalType;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public AstTypedefNode build() {
            return new AstTypedefNode(this.name, this.originalType);
        }
    }
}

