/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.maven.plugins.nukleus.internal.ast;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstType;

public final class AstVariantCaseNode
extends AstNode {
    private final Object value;
    private final AstType type;
    private final int missingFieldValue;
    private final List<AstType> typeParams;

    @Override
    public <R> R accept(AstNode.Visitor<R> visitor) {
        return visitor.visitVariantCase(this);
    }

    public Object value() {
        return this.value;
    }

    public AstType type() {
        return this.type;
    }

    public int missingFieldValue() {
        return this.missingFieldValue;
    }

    public List<AstType> typeParams() {
        return this.typeParams;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.type, this.missingFieldValue, this.typeParams);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AstVariantCaseNode)) {
            return false;
        }
        AstVariantCaseNode that = (AstVariantCaseNode)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.type, that.type) && this.missingFieldValue == that.missingFieldValue && Objects.equals(this.typeParams, that.typeParams);
    }

    private AstVariantCaseNode(Object value, AstType type, int missingFieldValue, List<AstType> typeParams) {
        this.value = value;
        this.type = type;
        this.missingFieldValue = missingFieldValue;
        this.typeParams = typeParams;
    }

    public String toString() {
        return String.format("CASE [value=%s, type=%s, missingFieldValue=%s, typeParams=%s]", this.value, this.type, this.missingFieldValue, this.typeParams);
    }

    public static final class Builder
    extends AstNode.Builder<AstVariantCaseNode> {
        private Object value;
        private AstType type;
        private int missingFieldValue;
        private List<AstType> typeParams = new LinkedList<AstType>();

        public Builder value(Object value) {
            this.value = value;
            return this;
        }

        public Builder type(AstType type) {
            this.type = type;
            return this;
        }

        public Builder typeParam(AstType typeParam) {
            this.typeParams.add(Objects.requireNonNull(typeParam));
            return this;
        }

        public Builder missingFieldValue(int missingFieldValue) {
            this.missingFieldValue = missingFieldValue;
            return this;
        }

        @Override
        public AstVariantCaseNode build() {
            return new AstVariantCaseNode(this.value, this.type, this.missingFieldValue, this.typeParams);
        }
    }
}

