/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.maven.plugins.nukleus.internal.generate;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import javax.lang.model.element.Modifier;
import org.reaktivity.maven.plugins.nukleus.internal.generate.ClassSpecGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.TypeNames;

public final class OctetsFlyweightGenerator
extends ClassSpecGenerator {
    private final ClassName visitorRawType;
    private final TypeSpec.Builder classBuilder;
    private final BuilderClassBuilder builderClassBuilder;

    public OctetsFlyweightGenerator(ClassName flyweightType) {
        super(flyweightType.peerClass("OctetsFW"));
        this.visitorRawType = flyweightType.nestedClass("Visitor");
        this.classBuilder = TypeSpec.classBuilder((ClassName)((ClassName)this.thisName)).superclass((TypeName)flyweightType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        this.builderClassBuilder = new BuilderClassBuilder((ClassName)this.thisName, flyweightType);
    }

    @Override
    public TypeSpec generate() {
        return this.classBuilder.addField(this.valueField()).addMethod(this.getMethod()).addMethod(this.valueMethod()).addMethod(this.limitMethod()).addMethod(this.tryWrapMethod()).addMethod(this.wrapMethod()).addMethod(this.toStringMethod()).addType(this.builderClassBuilder.build()).build();
    }

    private FieldSpec valueField() {
        return FieldSpec.builder((TypeName)TypeNames.DIRECT_BUFFER_TYPE, (String)"valueRO", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T(0L, 0)", new Object[]{TypeNames.UNSAFE_BUFFER_TYPE}).build();
    }

    private MethodSpec getMethod() {
        TypeVariableName typeVarT = TypeVariableName.get((String)"T");
        ParameterizedTypeName visitorType = ParameterizedTypeName.get((ClassName)this.visitorRawType, (TypeName[])new TypeName[]{typeVarT});
        return MethodSpec.methodBuilder((String)"get").addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(typeVarT).addParameter((TypeName)visitorType, "visitor", new Modifier[0]).returns((TypeName)typeVarT).addStatement("DirectBuffer buffer = buffer()", new Object[0]).addStatement("int offset = offset()", new Object[0]).addStatement("int limit = limit()", new Object[0]).addStatement("return visitor.visit(buffer, offset, limit)", new Object[0]).build();
    }

    private MethodSpec valueMethod() {
        return MethodSpec.methodBuilder((String)"value").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeNames.DIRECT_BUFFER_TYPE).addStatement("return valueRO", new Object[0]).build();
    }

    private MethodSpec limitMethod() {
        return MethodSpec.methodBuilder((String)"limit").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return maxLimit()", new Object[0]).build();
    }

    private MethodSpec tryWrapMethod() {
        return MethodSpec.methodBuilder((String)"tryWrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(this.thisName).beginControlFlow("if (null == super.tryWrap(buffer, offset, maxLimit))", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("final int sizeof = sizeof()", new Object[0]).addStatement("valueRO.wrap(buffer, sizeof != 0 ? offset : 0, sizeof)", new Object[0]).addStatement("return this", new Object[0]).build();
    }

    private MethodSpec wrapMethod() {
        return MethodSpec.methodBuilder((String)"wrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(this.thisName).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]).addStatement("final int sizeof = sizeof()", new Object[0]).addStatement("valueRO.wrap(buffer, sizeof != 0 ? offset : 0, sizeof)", new Object[0]).addStatement("return this", new Object[0]).build();
    }

    private MethodSpec toStringMethod() {
        return MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return String.format(\"octets[%d]\", sizeof())", new Object[0]).build();
    }

    private static final class BuilderClassBuilder {
        private final TypeSpec.Builder classBuilder;
        private final ClassName classType;
        private final ClassName octetsType;
        private final ClassName visitorType;

        private BuilderClassBuilder(ClassName octetsType, ClassName flyweightType) {
            ClassName builderRawType = flyweightType.nestedClass("Builder");
            ParameterizedTypeName builderType = ParameterizedTypeName.get((ClassName)builderRawType, (TypeName[])new TypeName[]{octetsType});
            this.octetsType = octetsType;
            this.classType = octetsType.nestedClass("Builder");
            this.visitorType = builderRawType.nestedClass("Visitor");
            this.classBuilder = TypeSpec.classBuilder((String)this.classType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).superclass((TypeName)builderType);
        }

        public TypeSpec build() {
            return this.classBuilder.addMethod(this.constructor()).addMethod(this.wrapMethod()).addMethod(this.resetMethod()).addMethod(this.setMethod()).addMethod(this.setMethodViaBuffer()).addMethod(this.setMethodViaByteArray()).addMethod(this.setMethodViaMutator()).addMethod(this.putMethod()).addMethod(this.putMethodViaBuffer()).addMethod(this.putMethodViaByteArray()).addMethod(this.putMethodViaMutator()).build();
        }

        private MethodSpec constructor() {
            return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super(new $T())", new Object[]{this.octetsType}).build();
        }

        private MethodSpec wrapMethod() {
            return MethodSpec.methodBuilder((String)"wrap").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.octetsType.nestedClass("Builder")).addParameter((TypeName)TypeNames.MUTABLE_DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec resetMethod() {
            return MethodSpec.methodBuilder((String)"reset").addAnnotation(AnnotationSpec.builder(Deprecated.class).build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.octetsType.nestedClass("Builder")).addStatement("limit(offset())", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec setMethod() {
            return MethodSpec.methodBuilder((String)"set").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.octetsType.nestedClass("Builder")).addParameter((TypeName)this.octetsType, "value", new Modifier[0]).addStatement("int newLimit = offset() + value.sizeof()", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("buffer().putBytes(offset(), value.buffer(), value.offset(), value.sizeof())", new Object[0]).addStatement("limit(newLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec setMethodViaBuffer() {
            return MethodSpec.methodBuilder((String)"set").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.octetsType.nestedClass("Builder")).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "value", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "length", new Modifier[0]).addStatement("int newLimit = offset() + length", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("buffer().putBytes(offset(), value, offset, length)", new Object[0]).addStatement("limit(newLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec setMethodViaByteArray() {
            return MethodSpec.methodBuilder((String)"set").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.octetsType.nestedClass("Builder")).addParameter(byte[].class, "value", new Modifier[0]).addStatement("int newLimit = offset() + value.length", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("buffer().putBytes(offset(), value)", new Object[0]).addStatement("limit(newLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec setMethodViaMutator() {
            return MethodSpec.methodBuilder((String)"set").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.octetsType.nestedClass("Builder")).addParameter((TypeName)this.visitorType, "visitor", new Modifier[0]).addStatement("int length = visitor.visit(buffer(), offset(), maxLimit())", new Object[0]).addStatement("checkLimit(offset() + length, maxLimit())", new Object[0]).addStatement("limit(offset() + length)", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec putMethodViaMutator() {
            return MethodSpec.methodBuilder((String)"put").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.octetsType.nestedClass("Builder")).addParameter((TypeName)this.visitorType, "visitor", new Modifier[0]).addStatement("int length = visitor.visit(buffer(), limit(), maxLimit())", new Object[0]).addStatement("checkLimit(limit() + length, maxLimit())", new Object[0]).addStatement("limit(limit() + length)", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec putMethod() {
            return MethodSpec.methodBuilder((String)"put").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.octetsType.nestedClass("Builder")).addParameter((TypeName)this.octetsType, "value", new Modifier[0]).addStatement("int newLimit = limit() + value.sizeof()", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("buffer().putBytes(limit(), value.buffer(), value.offset(), value.sizeof())", new Object[0]).addStatement("limit(newLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec putMethodViaBuffer() {
            return MethodSpec.methodBuilder((String)"put").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.octetsType.nestedClass("Builder")).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "value", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "length", new Modifier[0]).addStatement("int newLimit = limit() + length", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("buffer().putBytes(limit(), value, offset, length)", new Object[0]).addStatement("limit(newLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec putMethodViaByteArray() {
            return MethodSpec.methodBuilder((String)"put").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.octetsType.nestedClass("Builder")).addParameter(byte[].class, "value", new Modifier[0]).addStatement("int newLimit = limit() + value.length", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("buffer().putBytes(limit(), value)", new Object[0]).addStatement("limit(newLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
        }
    }
}

