/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.maven.plugins.nukleus.internal.generate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstEnumNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstListNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstMapNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstNamedNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstScopeNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstSpecificationNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstStructNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstType;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstTypedefNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstUnionNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstVariantNode;

public final class TypeResolver {
    private final String packageName;
    private final Map<String, AstNamedNode> namedNodesByName = new HashMap<String, AstNamedNode>();
    private final Map<AstType, TypeName> namesByType;
    private final Map<AstType, TypeName> namesByUnsignedType;

    public TypeResolver(String packageName) {
        this.namesByType = TypeResolver.initNamesByType(packageName);
        this.namesByUnsignedType = TypeResolver.initNamesByUnsignedType(packageName);
        this.packageName = packageName;
    }

    public AstNamedNode resolve(String qualifiedName) {
        return this.namedNodesByName.get(qualifiedName);
    }

    public ClassName flyweightName() {
        return (ClassName)this.namesByType.get(AstType.FLYWEIGHT);
    }

    public TypeName resolveType(AstType type) {
        return this.namesByType.get(type);
    }

    public TypeName resolveUnsignedType(AstType type) {
        return this.namesByUnsignedType.get(type);
    }

    public ClassName resolveClass(AstType type) {
        return (ClassName)this.namesByType.get(type);
    }

    public void visit(AstSpecificationNode specification) {
        this.namedNodesByName.putAll(specification.accept(new QualifiedNameVisitor()));
        this.namesByType.putAll(specification.accept(new ClassNameVisitor(this.packageName)));
    }

    private static Map<AstType, TypeName> initNamesByType(String packageName) {
        HashMap<AstType, TypeName> namesByType = new HashMap<AstType, TypeName>();
        namesByType.put(AstType.FLYWEIGHT, (TypeName)ClassName.get((String)packageName, (String)"Flyweight", (String[])new String[0]));
        namesByType.put(AstType.STRING, (TypeName)ClassName.get((String)packageName, (String)"StringFW", (String[])new String[0]));
        namesByType.put(AstType.STRING8, (TypeName)ClassName.get((String)packageName, (String)"String8FW", (String[])new String[0]));
        namesByType.put(AstType.STRING16, (TypeName)ClassName.get((String)packageName, (String)"String16FW", (String[])new String[0]));
        namesByType.put(AstType.STRING32, (TypeName)ClassName.get((String)packageName, (String)"String32FW", (String[])new String[0]));
        namesByType.put(AstType.VARSTRING, (TypeName)ClassName.get((String)packageName, (String)"VarStringFW", (String[])new String[0]));
        namesByType.put(AstType.ARRAY, (TypeName)ClassName.get((String)packageName, (String)"ArrayFW", (String[])new String[0]));
        namesByType.put(AstType.ARRAY8, (TypeName)ClassName.get((String)packageName, (String)"Array8FW", (String[])new String[0]));
        namesByType.put(AstType.ARRAY16, (TypeName)ClassName.get((String)packageName, (String)"Array16FW", (String[])new String[0]));
        namesByType.put(AstType.ARRAY32, (TypeName)ClassName.get((String)packageName, (String)"Array32FW", (String[])new String[0]));
        namesByType.put(AstType.LIST, (TypeName)ClassName.get((String)packageName, (String)"ListFW", (String[])new String[0]));
        namesByType.put(AstType.LIST0, (TypeName)ClassName.get((String)packageName, (String)"List0FW", (String[])new String[0]));
        namesByType.put(AstType.LIST8, (TypeName)ClassName.get((String)packageName, (String)"List8FW", (String[])new String[0]));
        namesByType.put(AstType.LIST32, (TypeName)ClassName.get((String)packageName, (String)"List32FW", (String[])new String[0]));
        namesByType.put(AstType.OCTETS, (TypeName)ClassName.get((String)packageName, (String)"OctetsFW", (String[])new String[0]));
        namesByType.put(AstType.BOUNDED_OCTETS, (TypeName)ClassName.get((String)packageName, (String)"BoundedOctetsFW", (String[])new String[0]));
        namesByType.put(AstType.BOUNDED_OCTETS8, (TypeName)ClassName.get((String)packageName, (String)"BoundedOctets8FW", (String[])new String[0]));
        namesByType.put(AstType.BOUNDED_OCTETS16, (TypeName)ClassName.get((String)packageName, (String)"BoundedOctets16FW", (String[])new String[0]));
        namesByType.put(AstType.BOUNDED_OCTETS32, (TypeName)ClassName.get((String)packageName, (String)"BoundedOctets32FW", (String[])new String[0]));
        namesByType.put(AstType.MAP, (TypeName)ClassName.get((String)packageName, (String)"MapFW", (String[])new String[0]));
        namesByType.put(AstType.MAP8, (TypeName)ClassName.get((String)packageName, (String)"Map8FW", (String[])new String[0]));
        namesByType.put(AstType.MAP16, (TypeName)ClassName.get((String)packageName, (String)"Map16FW", (String[])new String[0]));
        namesByType.put(AstType.MAP32, (TypeName)ClassName.get((String)packageName, (String)"Map32FW", (String[])new String[0]));
        namesByType.put(AstType.INT8, TypeName.BYTE);
        namesByType.put(AstType.UINT8, TypeName.BYTE);
        namesByType.put(AstType.INT16, TypeName.SHORT);
        namesByType.put(AstType.UINT16, TypeName.SHORT);
        namesByType.put(AstType.INT24, TypeName.INT);
        namesByType.put(AstType.UINT24, TypeName.INT);
        namesByType.put(AstType.INT32, TypeName.INT);
        namesByType.put(AstType.UINT32, TypeName.INT);
        namesByType.put(AstType.VARBYTEUINT32, (TypeName)ClassName.get((String)packageName, (String)"Varbyteuint32FW", (String[])new String[0]));
        namesByType.put(AstType.VARINT32, (TypeName)ClassName.get((String)packageName, (String)"Varint32FW", (String[])new String[0]));
        namesByType.put(AstType.VARINT64, (TypeName)ClassName.get((String)packageName, (String)"Varint64FW", (String[])new String[0]));
        namesByType.put(AstType.INT64, TypeName.LONG);
        namesByType.put(AstType.UINT64, TypeName.LONG);
        return namesByType;
    }

    private static Map<AstType, TypeName> initNamesByUnsignedType(String packageName) {
        HashMap<AstType, TypeName> namesByUnsignedType = new HashMap<AstType, TypeName>();
        namesByUnsignedType.put(AstType.UINT8, TypeName.INT);
        namesByUnsignedType.put(AstType.UINT16, TypeName.INT);
        namesByUnsignedType.put(AstType.UINT24, TypeName.INT);
        namesByUnsignedType.put(AstType.UINT32, TypeName.LONG);
        namesByUnsignedType.put(AstType.UINT64, TypeName.LONG);
        namesByUnsignedType.put(AstType.VARBYTEUINT32, (TypeName)ClassName.get((String)packageName, (String)"Varbyteuint32FW", (String[])new String[0]));
        return namesByUnsignedType;
    }

    private static final class QualifiedNameVisitor
    extends AstNode.Visitor<Map<String, AstNamedNode>> {
        private final Map<String, AstNamedNode> namedNodesByName = new HashMap<String, AstNamedNode>();
        private final Deque<String> nestedNames = new LinkedList<String>();

        private QualifiedNameVisitor() {
        }

        @Override
        public Map<String, AstNamedNode> visitScope(AstScopeNode scopeNode) {
            try {
                this.nestedNames.addLast(scopeNode.name());
                Map map = (Map)super.visitScope(scopeNode);
                return map;
            }
            finally {
                this.nestedNames.removeLast();
            }
        }

        @Override
        public Map<String, AstNamedNode> visitStruct(AstStructNode structNode) {
            return this.visitNamedNode(structNode, node -> (Map)super.visitStruct((AstStructNode)node));
        }

        @Override
        public Map<String, AstNamedNode> visitEnum(AstEnumNode enumNode) {
            return this.visitNamedNode(enumNode, node -> (Map)super.visitEnum((AstEnumNode)node));
        }

        @Override
        public Map<String, AstNamedNode> visitList(AstListNode listNode) {
            return this.visitNamedNode(listNode, node -> (Map)super.visitList((AstListNode)node));
        }

        @Override
        public Map<String, AstNamedNode> visitTypedef(AstTypedefNode typedefNode) {
            return this.visitNamedNode(typedefNode, node -> (Map)super.visitTypedef((AstTypedefNode)node));
        }

        @Override
        public Map<String, AstNamedNode> visitMap(AstMapNode mapNode) {
            return this.visitNamedNode(mapNode, node -> (Map)super.visitMap((AstMapNode)node));
        }

        @Override
        public Map<String, AstNamedNode> visitUnion(AstUnionNode unionNode) {
            return this.visitNamedNode(unionNode, node -> (Map)super.visitUnion((AstUnionNode)node));
        }

        @Override
        public Map<String, AstNamedNode> visitVariant(AstVariantNode variantNode) {
            return this.visitNamedNode(variantNode, node -> (Map)super.visitVariant((AstVariantNode)node));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, AstNamedNode> visitNamedNode(AstNamedNode namedNode, Function<AstNamedNode, Map<String, AstNamedNode>> visit) {
            try {
                this.nestedNames.addLast(namedNode.name());
                String qualifiedName = String.join((CharSequence)"::", this.nestedNames);
                this.namedNodesByName.put(qualifiedName, namedNode);
                Map<String, AstNamedNode> map = visit.apply(namedNode);
                return map;
            }
            finally {
                this.nestedNames.removeLast();
            }
        }

        @Override
        protected Map<String, AstNamedNode> defaultResult() {
            return this.namedNodesByName;
        }
    }

    private static final class ClassNameVisitor
    extends AstNode.Visitor<Map<AstType, TypeName>> {
        private final String packageName;
        private final Map<AstType, TypeName> namesByType;
        private final Deque<String> scopedNames;

        private ClassNameVisitor(String packageName) {
            this.packageName = packageName;
            this.namesByType = new HashMap<AstType, TypeName>();
            this.scopedNames = new LinkedList<String>();
        }

        @Override
        public Map<AstType, TypeName> visitScope(AstScopeNode scopeNode) {
            try {
                this.scopedNames.addLast(scopeNode.name());
                Map map = (Map)super.visitScope(scopeNode);
                return map;
            }
            finally {
                this.scopedNames.removeLast();
            }
        }

        @Override
        public Map<AstType, TypeName> visitEnum(AstEnumNode enumNode) {
            return this.visitNamedType(enumNode, enumNode.name(), x$0 -> (Map)super.visitEnum((AstEnumNode)x$0));
        }

        @Override
        public Map<AstType, TypeName> visitStruct(AstStructNode structNode) {
            return this.visitNamedType(structNode, structNode.name(), x$0 -> (Map)super.visitStruct((AstStructNode)x$0));
        }

        @Override
        public Map<AstType, TypeName> visitUnion(AstUnionNode unionNode) {
            return this.visitNamedType(unionNode, unionNode.name(), x$0 -> (Map)super.visitUnion((AstUnionNode)x$0));
        }

        @Override
        public Map<AstType, TypeName> visitVariant(AstVariantNode variantNode) {
            return this.visitNamedType(variantNode, variantNode.name(), x$0 -> (Map)super.visitVariant((AstVariantNode)x$0));
        }

        @Override
        public Map<AstType, TypeName> visitList(AstListNode listNode) {
            return this.visitNamedType(listNode, listNode.name(), x$0 -> (Map)super.visitList((AstListNode)x$0));
        }

        @Override
        public Map<AstType, TypeName> visitTypedef(AstTypedefNode typedefNode) {
            return this.visitNamedType(typedefNode, typedefNode.name(), x$0 -> (Map)super.visitTypedef((AstTypedefNode)x$0));
        }

        @Override
        public Map<AstType, TypeName> visitMap(AstMapNode mapNode) {
            return this.visitNamedType(mapNode, mapNode.name(), x$0 -> (Map)super.visitMap((AstMapNode)x$0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <N extends AstNode> Map<AstType, TypeName> visitNamedType(N node, String nodeName, Function<N, Map<AstType, TypeName>> visit) {
            ArrayList<String> packageParts = new ArrayList<String>(this.scopedNames);
            packageParts.set(0, this.packageName);
            String classPackage = String.join((CharSequence)".", packageParts);
            try {
                this.scopedNames.addLast(nodeName);
                String scopedName = String.join((CharSequence)"::", this.scopedNames);
                AstType type = AstType.dynamicType(scopedName);
                String simpleName = nodeName + "FW";
                ClassName className = ClassName.get((String)classPackage, (String)simpleName, (String[])new String[0]);
                this.namesByType.put(type, (TypeName)className);
                Map<AstType, TypeName> map = visit.apply(node);
                return map;
            }
            finally {
                this.scopedNames.removeLast();
            }
        }

        @Override
        protected Map<AstType, TypeName> defaultResult() {
            return this.namesByType;
        }
    }
}

