/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.maven.plugins.nukleus.internal.generate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.reaktivity.maven.plugins.nukleus.internal.generate.ClassSpecGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.TypeNames;

public final class Varint64FlyweightGenerator
extends ClassSpecGenerator {
    private final TypeSpec.Builder classBuilder;
    private final BuilderClassBuilder builderClassBuilder;

    public Varint64FlyweightGenerator(ClassName flyweightType) {
        super(flyweightType.peerClass("Varint64FW"));
        this.classBuilder = TypeSpec.classBuilder((ClassName)((ClassName)this.thisName)).superclass((TypeName)flyweightType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        this.builderClassBuilder = new BuilderClassBuilder((ClassName)this.thisName, flyweightType.nestedClass("Builder"));
    }

    @Override
    public TypeSpec generate() {
        return this.classBuilder.addField(this.fieldSize()).addMethod(this.limitMethod()).addMethod(this.valueMethod()).addMethod(this.tryWrapMethod()).addMethod(this.wrapMethod()).addMethod(this.toStringMethod()).addMethod(this.length0Method()).addType(this.builderClassBuilder.build()).build();
    }

    private FieldSpec fieldSize() {
        return FieldSpec.builder(Integer.TYPE, (String)"size", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
    }

    private MethodSpec limitMethod() {
        return MethodSpec.methodBuilder((String)"limit").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return offset() + size", new Object[0]).build();
    }

    private MethodSpec valueMethod() {
        return MethodSpec.methodBuilder((String)"value").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Long.TYPE).addStatement("long value = 0L", new Object[0]).addStatement("int i = 0;", new Object[0]).addStatement("long b", new Object[0]).addStatement("int pos  = offset()", new Object[0]).beginControlFlow("while (((b = buffer().getByte(pos++)) & 0x80L) != 0)", new Object[0]).addStatement("value |= (b & 0x7F) << i", new Object[0]).addStatement("i += 7", new Object[0]).beginControlFlow("if (i > 65)", new Object[0]).addStatement("throw new $T($S)", new Object[]{IllegalArgumentException.class, "varint64 value too long"}).endControlFlow().endControlFlow().addStatement("long unsigned = value | (b << i);", new Object[0]).addStatement("long result = (((unsigned << 63) >> 63) ^ unsigned) >> 1", new Object[0]).addStatement("result = result ^ (unsigned & (1L << 63))", new Object[0]).addStatement("return result", new Object[0]).build();
    }

    private MethodSpec tryWrapMethod() {
        return MethodSpec.methodBuilder((String)"tryWrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(this.thisName).beginControlFlow("if (null == super.tryWrap(buffer, offset, maxLimit) || maxLimit - offset  < 1)", new Object[0]).addStatement("return null", new Object[0]).nextControlFlow("else if (maxLimit - offset >= 10 && (buffer.getLong(offset) & 0x80808080_80808080L) == 0x80808080_80808080L && (buffer.getByte(offset + Long.BYTES) & 0x80) == 0x80 && (buffer.getByte(offset + Long.BYTES + Byte.BYTES) & 0xfe) != 0)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("size = length0()", new Object[0]).beginControlFlow("if (limit() > maxLimit)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("return this", new Object[0]).build();
    }

    private MethodSpec wrapMethod() {
        return MethodSpec.methodBuilder((String)"wrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(this.thisName).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]).addStatement("checkLimit(offset + 1, maxLimit)", new Object[0]).addStatement("size = length0()", new Object[0]).addStatement("checkLimit(limit(), maxLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
    }

    private MethodSpec toStringMethod() {
        return MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return Long.toString(value())", new Object[0]).build();
    }

    private MethodSpec length0Method() {
        return MethodSpec.methodBuilder((String)"length0").addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(Integer.TYPE).addStatement("int pos = offset()", new Object[0]).addStatement("byte b = (byte) 0", new Object[0]).addStatement("final int maxPos = Math.min(pos + 10,  maxLimit())", new Object[0]).beginControlFlow("while (pos < maxPos && ((b = buffer().getByte(pos)) & 0x80L) != 0)", new Object[0]).addStatement("pos++", new Object[0]).endControlFlow().addStatement("int size = 1 + pos - offset()", new Object[0]).addStatement("int mask = size < 10 ? 0x80 : 0xfe", new Object[0]).beginControlFlow("if ((b & mask) != 0 && size >= 10)", new Object[0]).addStatement("throw new $T(String.format($S, offset()))", new Object[]{IllegalArgumentException.class, "varint64 value at offset %d exceeds 64 bits"}).endControlFlow().addStatement("return size", new Object[0]).build();
    }

    private static final class BuilderClassBuilder {
        private final TypeSpec.Builder classBuilder;
        private final ClassName classType;
        private final ClassName flyweightType;

        private BuilderClassBuilder(ClassName flyweightType, ClassName builderRawType) {
            ParameterizedTypeName builderType = ParameterizedTypeName.get((ClassName)builderRawType, (TypeName[])new TypeName[]{flyweightType});
            this.flyweightType = flyweightType;
            this.classType = flyweightType.nestedClass("Builder");
            this.classBuilder = TypeSpec.classBuilder((String)this.classType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).superclass((TypeName)builderType);
        }

        public TypeSpec build() {
            return this.classBuilder.addField(this.fieldValueSet()).addMethod(this.constructor()).addMethod(this.wrapMethod()).addMethod(this.setMethod()).addMethod(this.buildMethod()).build();
        }

        private FieldSpec fieldValueSet() {
            return FieldSpec.builder(Boolean.TYPE, (String)"valueSet", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
        }

        private MethodSpec constructor() {
            return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super(new $T())", new Object[]{this.flyweightType}).build();
        }

        private MethodSpec wrapMethod() {
            return MethodSpec.methodBuilder((String)"wrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.flyweightType.nestedClass("Builder")).addParameter((TypeName)TypeNames.MUTABLE_DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).addStatement("checkLimit(offset + 1, maxLimit)", new Object[0]).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]).addStatement("this.valueSet = false", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec setMethod() {
            return MethodSpec.methodBuilder((String)"set").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.flyweightType.nestedClass("Builder")).addParameter(Long.TYPE, "value", new Modifier[0]).addStatement("long zigzagged = (value << 1) ^ (value >> 63)", new Object[0]).addStatement("int pos = offset()", new Object[0]).addStatement("int bits = zigzagged == 0L ? 1 : 1 + $1T.numberOfTrailingZeros($1T.highestOneBit(zigzagged))", new Object[]{Long.class}).addStatement("int size = bits / 7", new Object[0]).beginControlFlow("if (size * 7 < bits)", new Object[0]).addStatement("size++", new Object[0]).endControlFlow().addStatement("int newLimit = pos + size", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).beginControlFlow("while ((zigzagged & 0xFFFFFFFF_FFFFFF80L) != 0L)", new Object[0]).addStatement("buffer().putByte(pos++, (byte) ((zigzagged & 0x7FL) | 0x80L))", new Object[0]).addStatement("zigzagged >>>= 7", new Object[0]).endControlFlow().addStatement("buffer().putByte(pos, (byte) (zigzagged & 0x7FL))", new Object[0]).addStatement("limit(newLimit)", new Object[0]).addStatement("valueSet = true", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec buildMethod() {
            return MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).beginControlFlow("if (!valueSet)", new Object[0]).addStatement("throw new $T($S)", new Object[]{IllegalArgumentException.class, "value not set"}).endControlFlow().addStatement("return super.build()", new Object[0]).returns((TypeName)this.flyweightType).build();
        }
    }
}

