/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.maven.plugins.nukleus.internal;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.reaktivity.maven.plugins.nukleus.internal.Parser;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstSpecificationNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstType;
import org.reaktivity.maven.plugins.nukleus.internal.ast.visit.ScopeVisitor;
import org.reaktivity.maven.plugins.nukleus.internal.generate.Array16FWGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.Array32FWGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.Array8FWGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.ArrayFWGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.BoundedOctets16FlyweightGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.BoundedOctets32FlyweightGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.BoundedOctets8FlyweightGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.BoundedOctetsFlyweightGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.FlyweightGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.List0FWGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.List32FWGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.List8FWGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.ListFWGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.Map16FWGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.Map32FWGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.Map8FWGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.MapFWGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.OctetsFlyweightGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.String16FlyweightGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.String32FlyweightGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.String8FlyweightGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.StringFlyweightGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.TypeResolver;
import org.reaktivity.maven.plugins.nukleus.internal.generate.TypeSpecGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.VarStringFlyweightGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.Varint32FlyweightGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.Varint64FlyweightGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.Varuint32FlyweightGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.Varuint32nFlyweightGenerator;

public class Generator {
    private String scopeNames = "test";
    private File inputDirectory = new File("src/test/resources/test-project");
    private File outputDirectory = new File("target/generated-test-sources/test-reaktivity");
    private String packageName = "org.reaktivity.reaktor.internal.test.types";
    private Parser parser = new Parser();

    public static void main(String[] args) throws IOException {
        Generator generator = new Generator();
        generator.error(System.out::println).warn(System.out::println);
        boolean verbose = false;
        if (args.length > 0) {
            block8: for (int i = 0; i < args.length; ++i) {
                switch (args[i]) {
                    case "-v": {
                        verbose = true;
                        continue block8;
                    }
                    case "-d": {
                        String baseDir = args[i + 1];
                        ++i;
                        generator.inputDirectory = new File(baseDir + "/src/test/resources/test-project");
                        generator.outputDirectory = new File(baseDir + "/target/generated-test-sources/test-reaktivity");
                    }
                }
            }
        }
        if (verbose) {
            generator.debug(System.out::println);
        }
        generator.generate();
    }

    void generate() throws IOException {
        this.generate(this.createClassLoader());
    }

    void generate(ClassLoader loader) throws IOException {
        List<String> targetScopes = Collections.unmodifiableList(Arrays.asList(this.scopeNames.split("\\s+")));
        List<AstSpecificationNode> specifications = this.parser.parseAST(targetScopes, loader);
        TypeResolver resolver = new TypeResolver(this.packageName);
        specifications.forEach(resolver::visit);
        HashSet<TypeSpecGenerator> typeSpecs = new HashSet<TypeSpecGenerator>();
        for (AstSpecificationNode specification : specifications) {
            String scopeName = specification.scope().name();
            ScopeVisitor visitor = new ScopeVisitor(scopeName, this.packageName, resolver, targetScopes);
            typeSpecs.addAll((Collection)specification.accept(visitor));
        }
        ClassName flyweightType = resolver.resolveClass(AstType.FLYWEIGHT);
        ClassName stringType = resolver.resolveClass(AstType.STRING);
        ParameterizedTypeName arrayType = ParameterizedTypeName.get((ClassName)resolver.resolveClass(AstType.ARRAY), (TypeName[])new TypeName[]{TypeVariableName.get((String)"V", (TypeName[])new TypeName[]{flyweightType})});
        ClassName listType = resolver.resolveClass(AstType.LIST);
        ParameterizedTypeName mapType = ParameterizedTypeName.get((ClassName)resolver.resolveClass(AstType.MAP), (TypeName[])new TypeName[]{TypeVariableName.get((String)"K", (TypeName[])new TypeName[]{flyweightType}), TypeVariableName.get((String)"V", (TypeName[])new TypeName[]{flyweightType})});
        ClassName boundedOctetsType = resolver.resolveClass(AstType.BOUNDED_OCTETS);
        typeSpecs.add(new FlyweightGenerator(flyweightType, arrayType));
        typeSpecs.add(new OctetsFlyweightGenerator(flyweightType));
        typeSpecs.add(new StringFlyweightGenerator(flyweightType));
        typeSpecs.add(new String8FlyweightGenerator(stringType));
        typeSpecs.add(new String16FlyweightGenerator(stringType));
        typeSpecs.add(new String32FlyweightGenerator(stringType));
        typeSpecs.add(new VarStringFlyweightGenerator(stringType));
        typeSpecs.add(new ArrayFWGenerator(flyweightType));
        typeSpecs.add(new Array8FWGenerator(flyweightType, arrayType));
        typeSpecs.add(new Array16FWGenerator(flyweightType, arrayType));
        typeSpecs.add(new Array32FWGenerator(flyweightType, arrayType));
        typeSpecs.add(new Varint32FlyweightGenerator(flyweightType));
        typeSpecs.add(new Varint64FlyweightGenerator(flyweightType));
        typeSpecs.add(new Varuint32FlyweightGenerator(flyweightType));
        typeSpecs.add(new Varuint32nFlyweightGenerator(flyweightType));
        typeSpecs.add(new ListFWGenerator(flyweightType));
        typeSpecs.add(new List32FWGenerator(flyweightType, listType));
        typeSpecs.add(new List8FWGenerator(flyweightType, listType));
        typeSpecs.add(new List0FWGenerator(flyweightType, listType));
        typeSpecs.add(new MapFWGenerator(flyweightType, mapType));
        typeSpecs.add(new Map8FWGenerator(flyweightType, mapType));
        typeSpecs.add(new Map16FWGenerator(flyweightType, mapType));
        typeSpecs.add(new Map32FWGenerator(flyweightType, mapType));
        typeSpecs.add(new BoundedOctetsFlyweightGenerator(flyweightType));
        typeSpecs.add(new BoundedOctets8FlyweightGenerator(flyweightType, boundedOctetsType));
        typeSpecs.add(new BoundedOctets16FlyweightGenerator(flyweightType, boundedOctetsType));
        typeSpecs.add(new BoundedOctets32FlyweightGenerator(flyweightType, boundedOctetsType));
        System.out.println("Generating to " + this.outputDirectory);
        if (this.outputDirectory.exists()) {
            Files.walk(this.outputDirectory.toPath(), new FileVisitOption[0]).map(Path::toFile).filter(File::isFile).forEach(f -> f.setWritable(true));
        }
        for (TypeSpecGenerator typeSpec : typeSpecs) {
            JavaFile sourceFile = JavaFile.builder((String)typeSpec.className().packageName(), (TypeSpec)typeSpec.generate()).addFileComment("TODO: license", new Object[0]).skipJavaLangImports(true).build();
            sourceFile.writeTo(this.outputDirectory);
        }
        if (this.outputDirectory.exists()) {
            Files.walk(this.outputDirectory.toPath(), new FileVisitOption[0]).map(Path::toFile).filter(File::isFile).forEach(f -> f.setWritable(false));
        }
    }

    Generator debug(Consumer<String> debug) {
        this.parser.debug(debug);
        return this;
    }

    Generator error(Consumer<String> error) {
        this.parser.error(error);
        return this;
    }

    Generator warn(Consumer<String> warn) {
        this.parser.warn(warn);
        return this;
    }

    void setScopeNames(String scopeNames) {
        this.scopeNames = scopeNames;
    }

    void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    void setInputDirectory(File inputDirectory) {
        this.inputDirectory = inputDirectory;
    }

    void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    private ClassLoader createClassLoader() throws MalformedURLException {
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        return new URLClassLoader(new URL[]{this.inputDirectory.getAbsoluteFile().toURI().toURL()}, parent);
    }
}

