/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.maven.plugins.nukleus.internal.ast;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstByteOrder;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstType;

public abstract class AstAbstractMemberNode
extends AstNode {
    public static final Object NULL_DEFAULT = new Object();
    protected final String name;
    protected final List<AstType> types;
    protected final int size;
    protected final String sizeName;
    protected final Object defaultValue;
    protected final AstByteOrder byteOrder;
    private AstType sizeType;
    private boolean usedAsSize;

    AstAbstractMemberNode(String name, List<AstType> types, int size, String sizeName, Object defaultValue, AstByteOrder byteOrder) {
        this.name = Objects.requireNonNull(name);
        this.types = Collections.unmodifiableList(AstAbstractMemberNode.requireNotEmpty(Objects.requireNonNull(types)));
        this.size = size;
        this.sizeName = sizeName;
        this.defaultValue = defaultValue;
        this.byteOrder = byteOrder;
    }

    @Override
    public <R> R accept(AstNode.Visitor<R> visitor) {
        return visitor.visitMember(this);
    }

    public String name() {
        return this.name;
    }

    public AstType type() {
        return this.types.get(0);
    }

    public List<AstType> types() {
        return this.types;
    }

    public int size() {
        return this.size;
    }

    public String sizeName() {
        return this.sizeName;
    }

    public AstType sizeType() {
        return this.sizeType;
    }

    public void sizeType(AstType sizeType) {
        this.sizeType = sizeType;
    }

    public void usedAsSize(boolean value) {
        this.usedAsSize = value;
    }

    public boolean usedAsSize() {
        return this.usedAsSize;
    }

    public Object defaultValue() {
        return this.defaultValue;
    }

    public AstByteOrder byteOrder() {
        return this.byteOrder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.types, this.sizeName, this.size, this.defaultValue, this.byteOrder});
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AstAbstractMemberNode)) {
            return false;
        }
        AstAbstractMemberNode that = (AstAbstractMemberNode)o;
        return this.size == that.size && Objects.equals(this.name, that.name) && Objects.deepEquals(this.types, that.types) && Objects.equals(this.sizeName, that.sizeName) && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals((Object)this.byteOrder, (Object)that.byteOrder);
    }

    public String toString() {
        String size = this.size == 0 ? this.sizeName : Integer.toString(this.size);
        return String.format("MEMBER [name=%s, size=%s, types=%s, defaultValue=%s, byteOrder=%s]", new Object[]{this.name, size, this.types, this.defaultValue, this.byteOrder});
    }

    private static <T extends Collection<?>> T requireNotEmpty(T c) {
        if (c.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return c;
    }

    public static abstract class Builder<T extends AstAbstractMemberNode>
    extends AstNode.Builder<T> {
        protected String name;
        protected List<AstType> types = new LinkedList<AstType>();
        protected int size = -1;
        protected String sizeName;
        protected Object defaultValue;
        protected AstByteOrder byteOrder = AstByteOrder.NATIVE;

        public Builder<T> name(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> type(AstType type) {
            this.types.add(Objects.requireNonNull(type));
            return this;
        }

        public Builder<T> size(int size) {
            this.size = size;
            return this;
        }

        public Builder<T> sizeName(String sizeName) {
            this.sizeName = sizeName;
            return this;
        }

        public Builder<T> defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder<T> defaultToNull() {
            this.defaultValue = NULL_DEFAULT;
            return this;
        }

        public Builder<T> byteOrder(AstByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }
    }
}

