/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.maven.plugins.nukleus.internal.ast;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstNamedNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstStructMemberNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstType;

public final class AstStructNode
extends AstNamedNode {
    private final int typeId;
    private final AstType supertype;
    private final List<AstStructMemberNode> members;

    @Override
    public <R> R accept(AstNode.Visitor<R> visitor) {
        return visitor.visitStruct(this);
    }

    public int typeId() {
        return this.typeId;
    }

    public AstType supertype() {
        return this.supertype;
    }

    public List<AstStructMemberNode> members() {
        return this.members;
    }

    @Override
    public AstNamedNode withName(String name) {
        return new AstStructNode(name, this.typeId, this.supertype, this.members);
    }

    @Override
    public AstNamedNode.Kind getKind() {
        return AstNamedNode.Kind.STRUCT;
    }

    @Override
    public int hashCode() {
        return this.supertype != null ? this.name.hashCode() << 11 ^ this.supertype.hashCode() << 7 ^ this.members.hashCode() << 3 ^ this.typeId : this.name.hashCode() << 11 ^ this.members.hashCode() << 3 ^ this.typeId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AstStructNode)) {
            return false;
        }
        AstStructNode that = (AstStructNode)o;
        return Objects.equals(this.name, that.name) && this.typeId == that.typeId && Objects.equals(this.supertype, that.supertype) && Objects.equals(this.members, that.members);
    }

    private AstStructNode(String name, int typeId, AstType supertype, List<AstStructMemberNode> members) {
        super(name);
        this.typeId = typeId;
        this.supertype = supertype;
        this.members = Collections.unmodifiableList(members);
    }

    public static final class Builder
    extends AstNamedNode.Builder<AstStructNode> {
        private AstType supertype;
        private int typeId;
        private List<AstStructMemberNode> members = new LinkedList<AstStructMemberNode>();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder typeId(int typeId) {
            this.typeId = typeId;
            return this;
        }

        public Builder supertype(AstType supertype) {
            this.supertype = supertype;
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Builder member(AstStructMemberNode member) {
            if (member.sizeName() != null) {
                boolean sizeIsVarint;
                String target = member.sizeName();
                Optional<AstStructMemberNode> sizeField = this.members.stream().filter(n -> target.equals(n.name())).findFirst();
                if (!sizeField.isPresent()) throw new IllegalArgumentException(String.format("Size field \"%s\" not found for field \"%s\"", member.sizeName(), member.name()));
                AstStructMemberNode size = sizeField.get();
                member.sizeType(size.type());
                if (size.defaultValue() != null) {
                    throw new IllegalArgumentException(String.format("Size field \"%s\" for field \"%s\" must not have a default value's", member.sizeName(), member.name()));
                }
                boolean defaultsToNull = member.defaultValue() == AstStructMemberNode.NULL_DEFAULT;
                boolean bl = sizeIsVarint = size.type() == AstType.VARINT32 || size.type() == AstType.VARINT64;
                if (sizeIsVarint) {
                    if (member.type() != AstType.OCTETS) throw new IllegalArgumentException(String.format("Size field \"%s\" for field \"%s\" may not be of type varint", member.sizeName(), member.name()));
                    size.usedAsSize(true);
                } else {
                    if (defaultsToNull && !size.type().isSignedInt()) {
                        throw new IllegalArgumentException(String.format("Size field \"%s\" for field \"%s\" defaulting to null must be a signed integer type", member.sizeName(), member.name()));
                    }
                    if (!defaultsToNull && !size.type().isUnsignedInt()) {
                        throw new IllegalArgumentException(String.format("Size field \"%s\" for field \"%s\" must be an unsigned integer type", member.sizeName(), member.name()));
                    }
                    size.usedAsSize(true);
                }
            }
            this.members.add(member);
            return this;
        }

        @Override
        public AstStructNode build() {
            return new AstStructNode(this.name, this.typeId, this.supertype, this.members);
        }
    }
}

