/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.maven.plugins.nukleus.internal.ast;

import java.util.Objects;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstNode;

public final class AstValueNode
extends AstNode {
    private final String name;
    private final int ordinal;
    private final Object value;

    private AstValueNode(String name, int ordinal, Object value) {
        this.name = Objects.requireNonNull(name);
        this.ordinal = ordinal;
        this.value = value;
    }

    @Override
    public <R> R accept(AstNode.Visitor<R> visitor) {
        return visitor.visitValue(this);
    }

    public String name() {
        return this.name;
    }

    public int size() {
        return this.ordinal;
    }

    public Object value() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() << 3 ^ this.ordinal;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AstValueNode)) {
            return false;
        }
        AstValueNode that = (AstValueNode)o;
        return this.ordinal == that.ordinal && Objects.equals(this.name, that.name);
    }

    public String toString() {
        return String.format("VALUE [name=%s, ordinal=%d, value=%s]", this.name, this.ordinal, this.value);
    }

    public static final class Builder
    extends AstNode.Builder<AstValueNode> {
        private String name;
        private int ordinal;
        private Object value;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder ordinal(int ordinal) {
            this.ordinal = ordinal;
            return this;
        }

        public Builder value(Object value) {
            this.value = value;
            return this;
        }

        @Override
        public AstValueNode build() {
            return new AstValueNode(this.name, this.ordinal, this.value);
        }
    }
}

