/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.maven.plugins.nukleus.internal.generate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.nio.ByteOrder;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.lang.model.element.Modifier;
import org.reaktivity.maven.plugins.nukleus.internal.generate.ParameterizedTypeSpecGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.TypeNames;

public class ArrayFlyweightGenerator
extends ParameterizedTypeSpecGenerator {
    private final TypeSpec.Builder classBuilder;
    private final BuilderClassBuilder builderClassBuilder;

    public ArrayFlyweightGenerator(ClassName flyweightType) {
        this(flyweightType, "ArrayFW");
    }

    protected ArrayFlyweightGenerator(ClassName flyweightType, String className) {
        super(ParameterizedTypeName.get((ClassName)flyweightType.peerClass(className), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")}));
        TypeVariableName typeVarT = TypeVariableName.get((String)"T");
        TypeVariableName itemType = typeVarT.withBounds(new TypeName[]{flyweightType});
        this.classBuilder = TypeSpec.classBuilder((ClassName)this.thisRawName).superclass((TypeName)flyweightType).addTypeVariable(itemType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        this.builderClassBuilder = new BuilderClassBuilder((ParameterizedTypeName)this.thisName, flyweightType.nestedClass("Builder"));
    }

    @Override
    public TypeSpec generate() {
        return this.classBuilder.addField(this.fieldSizeLengthConstant()).addField(this.fieldByteOrder()).addField(this.fieldItemRO()).addMethod(this.constructor()).addMethod(this.constructorByteOrder()).addMethod(this.limitMethod()).addMethod(this.tryWrapMethod()).addMethod(this.wrapMethod()).addMethod(this.forEachMethod()).addMethod(this.anyMatchMethod()).addMethod(this.matchFirstMethod()).addMethod(this.isEmptyMethod()).addMethod(this.toStringMethod()).addMethod(this.length0Method()).addType(this.builderClassBuilder.build()).build();
    }

    private FieldSpec fieldSizeLengthConstant() {
        return FieldSpec.builder(Integer.TYPE, (String)"FIELD_SIZE_LENGTH", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.BYTES", new Object[]{Integer.class}).build();
    }

    private FieldSpec fieldByteOrder() {
        return FieldSpec.builder(ByteOrder.class, (String)"byteOrder", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    private FieldSpec fieldItemRO() {
        TypeName itemType = (TypeName)((ParameterizedTypeName)this.thisName).typeArguments.get(0);
        return FieldSpec.builder((TypeName)itemType, (String)"itemRO", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    private MethodSpec constructor() {
        TypeName itemType = (TypeName)((ParameterizedTypeName)this.thisName).typeArguments.get(0);
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(itemType, "itemRO", new Modifier[0]).addStatement("this.itemRO = $T.requireNonNull(itemRO)", new Object[]{Objects.class}).addStatement("this.byteOrder = $T.nativeOrder()", new Object[]{ByteOrder.class}).build();
    }

    private MethodSpec constructorByteOrder() {
        TypeName itemType = (TypeName)((ParameterizedTypeName)this.thisName).typeArguments.get(0);
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(itemType, "itemRO", new Modifier[0]).addParameter(ByteOrder.class, "byteOrder", new Modifier[0]).addStatement("this.itemRO = $T.requireNonNull(itemRO)", new Object[]{Objects.class}).addStatement("this.byteOrder = byteOrder", new Object[0]).build();
    }

    private MethodSpec limitMethod() {
        return MethodSpec.methodBuilder((String)"limit").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return offset() + FIELD_SIZE_LENGTH + length0()", new Object[0]).build();
    }

    private MethodSpec tryWrapMethod() {
        return MethodSpec.methodBuilder((String)"tryWrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(this.thisName).beginControlFlow("if (null == super.tryWrap(buffer, offset, maxLimit) || offset + FIELD_SIZE_LENGTH > maxLimit)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().beginControlFlow("if (length0() < 0)", new Object[0]).addStatement("throw new $T(String.format($S, offset))", new Object[]{IllegalArgumentException.class, "Invalid list at offset %d: size < 0"}).endControlFlow().beginControlFlow("if (limit() > maxLimit)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("return this", new Object[0]).build();
    }

    private MethodSpec wrapMethod() {
        return MethodSpec.methodBuilder((String)"wrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(this.thisName).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]).addStatement("checkLimit(offset + FIELD_SIZE_LENGTH, maxLimit)", new Object[0]).beginControlFlow("if (length0() < 0)", new Object[0]).addStatement("throw new $T(String.format($S, offset))", new Object[]{IllegalArgumentException.class, "Invalid list at offset %d: size < 0"}).endControlFlow().addStatement("checkLimit(limit(), maxLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
    }

    private MethodSpec forEachMethod() {
        ClassName consumerRawType = ClassName.get(Consumer.class);
        TypeName tType = (TypeName)((ParameterizedTypeName)this.thisName).typeArguments.get(0);
        WildcardTypeName itemType = WildcardTypeName.supertypeOf((TypeName)tType);
        ParameterizedTypeName consumerType = ParameterizedTypeName.get((ClassName)consumerRawType, (TypeName[])new TypeName[]{itemType});
        return MethodSpec.methodBuilder((String)"forEach").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)consumerType, "consumer", new Modifier[0]).returns(this.thisName).beginControlFlow("for (int offset = offset() + FIELD_SIZE_LENGTH; offset < limit(); offset = itemRO.limit())", new Object[0]).addStatement("itemRO.wrap(buffer(), offset, limit())", new Object[0]).addStatement("consumer.accept(itemRO)", new Object[0]).endControlFlow().addStatement("return this", new Object[0]).build();
    }

    private MethodSpec anyMatchMethod() {
        ClassName predicateRawType = ClassName.get(Predicate.class);
        WildcardTypeName itemType = WildcardTypeName.supertypeOf((TypeName)((TypeName)((ParameterizedTypeName)this.thisName).typeArguments.get(0)));
        ParameterizedTypeName consumerType = ParameterizedTypeName.get((ClassName)predicateRawType, (TypeName[])new TypeName[]{itemType});
        return MethodSpec.methodBuilder((String)"anyMatch").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)consumerType, "predicate", new Modifier[0]).returns(TypeName.BOOLEAN).beginControlFlow("for (int offset = offset() + FIELD_SIZE_LENGTH; offset < limit(); offset = itemRO.limit())", new Object[0]).addStatement("itemRO.wrap(buffer(), offset, maxLimit())", new Object[0]).beginControlFlow("if (predicate.test(itemRO))", new Object[0]).addStatement("return true", new Object[0]).endControlFlow().endControlFlow().addStatement("return false", new Object[0]).build();
    }

    private MethodSpec matchFirstMethod() {
        ClassName predicateRawType = ClassName.get(Predicate.class);
        TypeName tType = (TypeName)((ParameterizedTypeName)this.thisName).typeArguments.get(0);
        WildcardTypeName itemType = WildcardTypeName.supertypeOf((TypeName)tType);
        ParameterizedTypeName consumerType = ParameterizedTypeName.get((ClassName)predicateRawType, (TypeName[])new TypeName[]{itemType});
        return MethodSpec.methodBuilder((String)"matchFirst").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)consumerType, "predicate", new Modifier[0]).returns(tType).beginControlFlow("for (int offset = offset() + FIELD_SIZE_LENGTH; offset < limit(); offset = itemRO.limit())", new Object[0]).addStatement("itemRO.wrap(buffer(), offset, maxLimit())", new Object[0]).beginControlFlow("if (predicate.test(itemRO))", new Object[0]).addStatement("return itemRO", new Object[0]).endControlFlow().endControlFlow().addStatement("return null", new Object[0]).build();
    }

    private MethodSpec isEmptyMethod() {
        return MethodSpec.methodBuilder((String)"isEmpty").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).addStatement("return length0() == 0", new Object[0]).build();
    }

    private MethodSpec toStringMethod() {
        return MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return String.format($S, length0())", new Object[]{"ARRAY containing %d bytes of data"}).build();
    }

    private MethodSpec length0Method() {
        return MethodSpec.methodBuilder((String)"length0").addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(Integer.TYPE).addStatement("return buffer().getInt(offset(), byteOrder)", new Object[0]).build();
    }

    private static final class BuilderClassBuilder {
        private final TypeSpec.Builder classBuilder;
        private final ParameterizedTypeName classType;
        private final ParameterizedTypeName enclosingType;
        private final TypeVariableName typeVarB;
        private TypeVariableName typeVarT;

        private BuilderClassBuilder(ParameterizedTypeName enclosingType, ClassName builderRawType) {
            ParameterizedTypeName builderType = ParameterizedTypeName.get((ClassName)builderRawType, (TypeName[])new TypeName[]{enclosingType});
            ClassName flyweightType = builderRawType.enclosingClassName();
            ClassName classRawType = enclosingType.rawType.nestedClass("Builder");
            this.typeVarB = TypeVariableName.get((String)"B");
            this.typeVarT = TypeVariableName.get((String)"T");
            this.enclosingType = enclosingType;
            this.classType = ParameterizedTypeName.get((ClassName)classRawType, (TypeName[])new TypeName[]{this.typeVarB, this.typeVarT});
            this.classBuilder = TypeSpec.classBuilder((ClassName)this.classType.rawType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addTypeVariable(this.typeVarB.withBounds(new TypeName[]{ParameterizedTypeName.get((ClassName)builderRawType, (TypeName[])new TypeName[]{this.typeVarT})})).addTypeVariable(this.typeVarT.withBounds(new TypeName[]{flyweightType})).superclass((TypeName)builderType);
        }

        public TypeSpec build() {
            return this.classBuilder.addField(this.fieldByteOrder()).addField(this.fieldItemRW()).addMethod(this.constructor()).addMethod(this.constructorByteOrder()).addMethod(this.wrapMethod()).addMethod(this.itemMethod()).addMethod(this.buildMethod()).build();
        }

        private FieldSpec fieldByteOrder() {
            return FieldSpec.builder(ByteOrder.class, (String)"byteOrder", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        }

        private FieldSpec fieldItemRW() {
            return FieldSpec.builder((TypeName)this.typeVarB, (String)"itemRW", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        }

        private MethodSpec constructor() {
            return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.typeVarB, "itemRW", new Modifier[0]).addParameter((TypeName)this.typeVarT, "itemRO", new Modifier[0]).addStatement("super(new $T(itemRO))", new Object[]{this.enclosingType}).addStatement("this.byteOrder = $T.nativeOrder()", new Object[]{ByteOrder.class}).addStatement("this.itemRW = itemRW", new Object[0]).build();
        }

        private MethodSpec constructorByteOrder() {
            return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.typeVarB, "itemRW", new Modifier[0]).addParameter((TypeName)this.typeVarT, "itemRO", new Modifier[0]).addParameter(ByteOrder.class, "byteOrder", new Modifier[0]).addStatement("super(new $T(itemRO))", new Object[]{this.enclosingType}).addStatement("this.byteOrder = byteOrder", new Object[0]).addStatement("this.itemRW = itemRW", new Object[0]).build();
        }

        private MethodSpec wrapMethod() {
            return MethodSpec.methodBuilder((String)"wrap").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.classType).addParameter((TypeName)TypeNames.MUTABLE_DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]).addStatement("int newLimit = offset + FIELD_SIZE_LENGTH", new Object[0]).addStatement("checkLimit(newLimit, maxLimit)", new Object[0]).addStatement("super.limit(newLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec itemMethod() {
            ClassName consumerRawType = ClassName.get(Consumer.class);
            ParameterizedTypeName mutatorType = ParameterizedTypeName.get((ClassName)consumerRawType, (TypeName[])new TypeName[]{this.typeVarB});
            return MethodSpec.methodBuilder((String)"item").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.classType).addParameter((TypeName)mutatorType, "mutator", new Modifier[0]).addStatement("itemRW.wrap(buffer(), limit(), maxLimit())", new Object[0]).addStatement("mutator.accept(itemRW)", new Object[0]).addStatement("limit(itemRW.build().limit())", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec buildMethod() {
            return MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.enclosingType).addStatement("int sizeInBytes = limit() - offset() - FIELD_SIZE_LENGTH", new Object[0]).addStatement("buffer().putInt(offset(), sizeInBytes, byteOrder)", new Object[0]).addStatement("return super.build()", new Object[0]).build();
        }
    }
}

