/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.maven.plugins.nukleus.internal.generate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import javax.lang.model.element.Modifier;
import org.reaktivity.maven.plugins.nukleus.internal.generate.ClassSpecGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.TypeNames;

public final class BoundedOctetsFlyweightGenerator
extends ClassSpecGenerator {
    private final TypeSpec.Builder classBuilder;
    private final ClassName visitorRawType;
    private final BuilderClassBuilder builderClassBuilder;

    public BoundedOctetsFlyweightGenerator(ClassName flyweightType) {
        super(flyweightType.peerClass("BoundedOctetsFW"));
        this.visitorRawType = flyweightType.nestedClass("Visitor");
        this.classBuilder = TypeSpec.classBuilder((ClassName)((ClassName)this.thisName)).superclass((TypeName)flyweightType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
        this.builderClassBuilder = new BuilderClassBuilder((ClassName)this.thisName, flyweightType);
    }

    @Override
    public TypeSpec generate() {
        return this.classBuilder.addMethod(this.valueMethod()).addMethod(this.getMethod()).addMethod(this.lengthMethod()).addType(this.builderClassBuilder.build()).build();
    }

    private MethodSpec valueMethod() {
        return MethodSpec.methodBuilder((String)"value").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)TypeNames.DIRECT_BUFFER_TYPE).build();
    }

    private MethodSpec getMethod() {
        TypeVariableName typeVarT = TypeVariableName.get((String)"T");
        ParameterizedTypeName visitorType = ParameterizedTypeName.get((ClassName)this.visitorRawType, (TypeName[])new TypeName[]{typeVarT});
        return MethodSpec.methodBuilder((String)"get").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)typeVarT).addTypeVariable(typeVarT).addParameter((TypeName)visitorType, "visitor", new Modifier[0]).build();
    }

    private MethodSpec lengthMethod() {
        return MethodSpec.methodBuilder((String)"length").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(Integer.TYPE).build();
    }

    private static final class BuilderClassBuilder {
        private final TypeSpec.Builder classBuilder;
        private final TypeVariableName typeVarT;
        private final TypeName parameterizedBuilderType;
        private final ClassName boundedOctetsType;

        private BuilderClassBuilder(ClassName boundedOctetsType, ClassName flyweightType) {
            ClassName builderRawType = boundedOctetsType.nestedClass("Builder");
            ClassName flyweightBuilderType = flyweightType.nestedClass("Builder");
            this.typeVarT = TypeVariableName.get((String)"T", (TypeName[])new TypeName[]{boundedOctetsType});
            this.parameterizedBuilderType = ParameterizedTypeName.get((ClassName)builderRawType, (TypeName[])new TypeName[]{this.typeVarT});
            this.boundedOctetsType = boundedOctetsType;
            this.classBuilder = TypeSpec.classBuilder((String)builderRawType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT, Modifier.STATIC}).superclass((TypeName)ParameterizedTypeName.get((ClassName)flyweightBuilderType, (TypeName[])new TypeName[]{this.typeVarT})).addTypeVariable(this.typeVarT);
        }

        public TypeSpec build() {
            return this.classBuilder.addMethod(this.constructor()).addMethod(this.setWithFlyweight()).addMethod(this.setWithBuffer()).addMethod(this.setWithByteArray()).build();
        }

        private MethodSpec constructor() {
            return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.typeVarT, "flyweight", new Modifier[0]).addStatement("super(flyweight)", new Object[0]).build();
        }

        private MethodSpec setWithFlyweight() {
            return MethodSpec.methodBuilder((String)"set").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(this.parameterizedBuilderType).addParameter((TypeName)this.boundedOctetsType, "value", new Modifier[0]).build();
        }

        private MethodSpec setWithBuffer() {
            return MethodSpec.methodBuilder((String)"set").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(this.parameterizedBuilderType).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "value", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "length", new Modifier[0]).build();
        }

        private MethodSpec setWithByteArray() {
            return MethodSpec.methodBuilder((String)"set").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(this.parameterizedBuilderType).addParameter(byte[].class, "value", new Modifier[0]).build();
        }
    }
}

