/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.maven.plugins.nukleus.internal.generate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.reaktivity.maven.plugins.nukleus.internal.generate.ClassSpecGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.TypeNames;

public final class List8FWGenerator
extends ClassSpecGenerator {
    private final TypeSpec.Builder classBuilder;
    private final BuilderClassBuilder builderClassBuilder;

    public List8FWGenerator(ClassName flyweightType, ClassName listType) {
        super(listType.peerClass("List8FW"));
        this.classBuilder = TypeSpec.classBuilder((ClassName)((ClassName)this.thisName)).superclass((TypeName)listType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        this.builderClassBuilder = new BuilderClassBuilder((ClassName)this.thisName, flyweightType.nestedClass("Builder"), listType.nestedClass("Builder"));
    }

    @Override
    public TypeSpec generate() {
        return this.classBuilder.addField(this.fieldsField()).addField(this.lengthSizeConstant()).addField(this.fieldCountSizeConstant()).addField(this.lengthOffsetConstant()).addField(this.fieldCountOffsetConstant()).addField(this.fieldsOffsetConstant()).addField(this.lengthMaxValueConstant()).addMethod(this.limitMethod()).addMethod(this.lengthMethod()).addMethod(this.fieldCountMethod()).addMethod(this.fieldsMethod()).addMethod(this.tryWrapMethod()).addMethod(this.wrapMethod()).addMethod(this.toStringMethod()).addType(this.builderClassBuilder.build()).build();
    }

    private FieldSpec fieldsField() {
        return FieldSpec.builder((TypeName)TypeNames.DIRECT_BUFFER_TYPE, (String)"fieldsRO", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T(0L, 0)", new Object[]{TypeNames.UNSAFE_BUFFER_TYPE}).build();
    }

    private FieldSpec lengthSizeConstant() {
        return FieldSpec.builder(Integer.TYPE, (String)"LENGTH_SIZE", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.SIZE_OF_BYTE", new Object[]{TypeNames.BIT_UTIL_TYPE}).build();
    }

    private FieldSpec fieldCountSizeConstant() {
        return FieldSpec.builder(Integer.TYPE, (String)"FIELD_COUNT_SIZE", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.SIZE_OF_BYTE", new Object[]{TypeNames.BIT_UTIL_TYPE}).build();
    }

    private FieldSpec lengthOffsetConstant() {
        return FieldSpec.builder(Integer.TYPE, (String)"LENGTH_OFFSET", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("0", new Object[0]).build();
    }

    private FieldSpec fieldCountOffsetConstant() {
        return FieldSpec.builder(Integer.TYPE, (String)"FIELD_COUNT_OFFSET", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("LENGTH_OFFSET + LENGTH_SIZE", new Object[0]).build();
    }

    private FieldSpec fieldsOffsetConstant() {
        return FieldSpec.builder(Integer.TYPE, (String)"FIELDS_OFFSET", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("FIELD_COUNT_OFFSET + FIELD_COUNT_SIZE", new Object[0]).build();
    }

    private FieldSpec lengthMaxValueConstant() {
        return FieldSpec.builder(Integer.TYPE, (String)"LENGTH_MAX_VALUE", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("0xFF", new Object[0]).build();
    }

    private MethodSpec limitMethod() {
        return MethodSpec.methodBuilder((String)"limit").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return offset() + LENGTH_SIZE + length()", new Object[0]).build();
    }

    private MethodSpec lengthMethod() {
        return MethodSpec.methodBuilder((String)"length").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return buffer().getByte(offset() + LENGTH_OFFSET) & 0xFF", new Object[0]).build();
    }

    private MethodSpec fieldCountMethod() {
        return MethodSpec.methodBuilder((String)"fieldCount").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return buffer().getByte(offset() + FIELD_COUNT_OFFSET) & 0xFF", new Object[0]).build();
    }

    private MethodSpec fieldsMethod() {
        return MethodSpec.methodBuilder((String)"fields").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeNames.DIRECT_BUFFER_TYPE).addStatement("return fieldsRO", new Object[0]).build();
    }

    private MethodSpec tryWrapMethod() {
        return MethodSpec.methodBuilder((String)"tryWrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(this.thisName).beginControlFlow("if (super.tryWrap(buffer, offset, maxLimit) == null)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("final int fieldsSize = length() - FIELD_COUNT_SIZE", new Object[0]).addStatement("fieldsRO.wrap(buffer, offset + FIELDS_OFFSET, fieldsSize)", new Object[0]).beginControlFlow("if (limit() > maxLimit)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("return this", new Object[0]).build();
    }

    private MethodSpec wrapMethod() {
        return MethodSpec.methodBuilder((String)"wrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(this.thisName).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]).addStatement("final int fieldsSize = length() - FIELD_COUNT_SIZE", new Object[0]).addStatement("fieldsRO.wrap(buffer, offset + FIELDS_OFFSET, fieldsSize)", new Object[0]).addStatement("checkLimit(limit(), maxLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
    }

    private MethodSpec toStringMethod() {
        return MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return String.format(\"list8<%d, %d>\", length(), fieldCount())", new Object[0]).build();
    }

    private static final class BuilderClassBuilder {
        private final TypeSpec.Builder classBuilder;
        private final ClassName classType;
        private final ClassName listType;
        private final ClassName visitorType;

        private BuilderClassBuilder(ClassName listType, ClassName flyweightBuilderRawType, ClassName listBuilderRawType) {
            ParameterizedTypeName builderType = ParameterizedTypeName.get((ClassName)listBuilderRawType, (TypeName[])new TypeName[]{listType});
            this.listType = listType;
            this.classType = listType.nestedClass("Builder");
            this.classBuilder = TypeSpec.classBuilder((String)this.classType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).superclass((TypeName)builderType);
            this.visitorType = flyweightBuilderRawType.nestedClass("Visitor");
        }

        public TypeSpec build() {
            return this.classBuilder.addField(this.fieldCount()).addMethod(this.constructor()).addMethod(this.fieldMethod()).addMethod(this.fieldsMethodViaVisitor()).addMethod(this.fieldsMethodViaBuffer()).addMethod(this.wrapMethod()).addMethod(this.buildMethod()).build();
        }

        private FieldSpec fieldCount() {
            return FieldSpec.builder(Integer.TYPE, (String)"fieldCount", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
        }

        private MethodSpec constructor() {
            return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super(new List8FW())", new Object[0]).build();
        }

        private MethodSpec fieldMethod() {
            return MethodSpec.methodBuilder((String)"field").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.listType.nestedClass("Builder")).addParameter((TypeName)this.visitorType, "visitor", new Modifier[0]).addStatement("int length = visitor.visit(buffer(), limit(), maxLimit())", new Object[0]).addStatement("fieldCount++", new Object[0]).addStatement("int newLimit = limit() + length", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("limit(newLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec fieldsMethodViaVisitor() {
            return MethodSpec.methodBuilder((String)"fields").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.listType.nestedClass("Builder")).addParameter(Integer.TYPE, "fieldCount", new Modifier[0]).addParameter((TypeName)this.visitorType, "visitor", new Modifier[0]).addStatement("int length = visitor.visit(buffer(), limit(), maxLimit())", new Object[0]).addStatement("this.fieldCount += fieldCount", new Object[0]).addStatement("int newLimit = limit() + length", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("limit(newLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec fieldsMethodViaBuffer() {
            return MethodSpec.methodBuilder((String)"fields").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.listType.nestedClass("Builder")).addParameter(Integer.TYPE, "fieldCount", new Modifier[0]).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "index", new Modifier[0]).addParameter(Integer.TYPE, "length", new Modifier[0]).addStatement("this.fieldCount += fieldCount", new Object[0]).addStatement("int newLimit = limit() + length", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("buffer().putBytes(limit(), buffer, index, length)", new Object[0]).addStatement("limit(newLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec wrapMethod() {
            return MethodSpec.methodBuilder((String)"wrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.listType.nestedClass("Builder")).addParameter((TypeName)TypeNames.MUTABLE_DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]).addStatement("int newLimit = offset + FIELDS_OFFSET", new Object[0]).addStatement("checkLimit(newLimit, maxLimit)", new Object[0]).addStatement("limit(newLimit)", new Object[0]).addStatement("this.fieldCount = 0", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec buildMethod() {
            return MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.listType).addStatement("int length = limit() - offset() - FIELD_COUNT_OFFSET", new Object[0]).addStatement("assert length <= LENGTH_MAX_VALUE : \"Length is too large\"", new Object[0]).addStatement("assert fieldCount <= LENGTH_MAX_VALUE : \"Field count is too large\"", new Object[0]).addStatement("buffer().putByte(offset() + LENGTH_OFFSET, (byte) length)", new Object[0]).addStatement("buffer().putByte(offset() + FIELD_COUNT_OFFSET, (byte) fieldCount)", new Object[0]).addStatement("return super.build()", new Object[0]).build();
        }
    }
}

