/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.maven.plugins.nukleus.internal.generate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.reaktivity.maven.plugins.nukleus.internal.generate.ClassSpecGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.TypeNames;

public final class Varuint32nFlyweightGenerator
extends ClassSpecGenerator {
    private final TypeSpec.Builder classBuilder;
    private final BuilderClassBuilder builderClassBuilder;

    public Varuint32nFlyweightGenerator(ClassName flyweightType) {
        super(flyweightType.peerClass("Varuint32nFW"));
        this.classBuilder = TypeSpec.classBuilder((ClassName)((ClassName)this.thisName)).superclass((TypeName)flyweightType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        this.builderClassBuilder = new BuilderClassBuilder((ClassName)this.thisName, flyweightType.nestedClass("Builder"));
    }

    @Override
    public TypeSpec generate() {
        return this.classBuilder.addField(this.fieldSize()).addMethod(this.limitMethod()).addMethod(this.valueMethod()).addMethod(this.tryWrapMethod()).addMethod(this.wrapMethod()).addMethod(this.toStringMethod()).addMethod(this.length0Method()).addType(this.builderClassBuilder.build()).build();
    }

    private FieldSpec fieldSize() {
        return FieldSpec.builder(Integer.TYPE, (String)"size", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
    }

    private MethodSpec limitMethod() {
        return MethodSpec.methodBuilder((String)"limit").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return offset() + size", new Object[0]).build();
    }

    private MethodSpec valueMethod() {
        return MethodSpec.methodBuilder((String)"value").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("final DirectBuffer buffer = buffer()", new Object[0]).addStatement("final int offset = offset()", new Object[0]).addStatement("final int limit = limit()", new Object[0]).addStatement("int value = 0", new Object[0]).addStatement("int progress = offset", new Object[0]).beginControlFlow("if (progress < limit)", new Object[0]).addStatement("int shift = 0", new Object[0]).addStatement("int bits", new Object[0]).beginControlFlow("do", new Object[0]).addStatement("bits = buffer.getByte(progress)", new Object[0]).addStatement("value |= (bits & 0x7F) << shift", new Object[0]).addStatement("shift += 7", new Object[0]).addStatement("progress++", new Object[0]).endControlFlow("while (progress < limit && (bits & 0x80) != 0)", new Object[0]).endControlFlow().addStatement("return value - 1", new Object[0]).build();
    }

    private MethodSpec tryWrapMethod() {
        return MethodSpec.methodBuilder((String)"tryWrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(this.thisName).beginControlFlow("if (null == super.tryWrap(buffer, offset, maxLimit) || maxLimit - offset < 1)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("size = length0()", new Object[0]).beginControlFlow("if (size < 0 || size > 5 || limit() > maxLimit)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("return this", new Object[0]).build();
    }

    private MethodSpec wrapMethod() {
        return MethodSpec.methodBuilder((String)"wrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(this.thisName).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]).addStatement("checkLimit(offset + 1, maxLimit)", new Object[0]).addStatement("size = length0()", new Object[0]).beginControlFlow("if (size < 0 || size > 5)", new Object[0]).addStatement("throw new $T(String.format($S, offset))", new Object[]{IllegalArgumentException.class, "varuint32 value at offset %d exceeds 32 bits"}).endControlFlow().addStatement("checkLimit(limit(), maxLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
    }

    private MethodSpec toStringMethod() {
        return MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return Integer.toString(value())", new Object[0]).build();
    }

    private MethodSpec length0Method() {
        return MethodSpec.methodBuilder((String)"length0").addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(Integer.TYPE).addStatement("final DirectBuffer buffer = buffer()", new Object[0]).addStatement("final int offset = offset()", new Object[0]).addStatement("final int maxPos = Math.min(offset + 5,  maxLimit())", new Object[0]).addStatement("int index = 0", new Object[0]).beginControlFlow("while (index + offset < maxPos && (buffer.getByte(index + offset) & 0x80) != 0)", new Object[0]).addStatement("index++", new Object[0]).endControlFlow().addStatement("int size = 1 + index", new Object[0]).addStatement("return size", new Object[0]).build();
    }

    private static final class BuilderClassBuilder {
        private final TypeSpec.Builder classBuilder;
        private final ClassName classType;
        private final ClassName flyweightType;

        private BuilderClassBuilder(ClassName flyweightType, ClassName builderRawType) {
            ParameterizedTypeName builderType = ParameterizedTypeName.get((ClassName)builderRawType, (TypeName[])new TypeName[]{flyweightType});
            this.flyweightType = flyweightType;
            this.classType = flyweightType.nestedClass("Builder");
            this.classBuilder = TypeSpec.classBuilder((String)this.classType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).superclass((TypeName)builderType);
        }

        public TypeSpec build() {
            return this.classBuilder.addField(this.fieldValueSet()).addMethod(this.constructor()).addMethod(this.wrapMethod()).addMethod(this.setMethod()).addMethod(this.buildMethod()).build();
        }

        private FieldSpec fieldValueSet() {
            return FieldSpec.builder(Boolean.TYPE, (String)"valueSet", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
        }

        private MethodSpec constructor() {
            return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super(new $T())", new Object[]{this.flyweightType}).build();
        }

        private MethodSpec wrapMethod() {
            return MethodSpec.methodBuilder((String)"wrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.flyweightType.nestedClass("Builder")).addParameter((TypeName)TypeNames.MUTABLE_DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).addStatement("checkLimit(offset + 1, maxLimit)", new Object[0]).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]).addStatement("this.valueSet = false", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec setMethod() {
            return MethodSpec.methodBuilder((String)"set").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.flyweightType.nestedClass("Builder")).addParameter(Integer.TYPE, "nvalue", new Modifier[0]).beginControlFlow("if (nvalue < -1 || nvalue > 0x0FFFFFFF)", new Object[0]).addStatement("throw new $T(String.format($S, nvalue))", new Object[]{IllegalArgumentException.class, "Input value %d out of range"}).endControlFlow().addStatement("final MutableDirectBuffer buffer = buffer()", new Object[0]).addStatement("int value = nvalue + 1", new Object[0]).addStatement("int progress = offset()", new Object[0]).beginControlFlow("do", new Object[0]).addStatement("int bits = value & 0x7F", new Object[0]).addStatement("value >>= 7", new Object[0]).beginControlFlow("if (value != 0)", new Object[0]).addStatement("bits |= 0x80", new Object[0]).endControlFlow().addStatement("buffer.putByte(progress++, (byte) (bits & 0xFF))", new Object[0]).endControlFlow("while (value > 0)", new Object[0]).addStatement("int newLimit = progress", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("limit(newLimit)", new Object[0]).addStatement("valueSet = true", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec buildMethod() {
            return MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).beginControlFlow("if (!valueSet)", new Object[0]).addStatement("throw new $T($S)", new Object[]{IllegalArgumentException.class, "value not set"}).endControlFlow().addStatement("return super.build()", new Object[0]).returns((TypeName)this.flyweightType).build();
        }
    }
}

