/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.mqtt.internal.types;

import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.mqtt.internal.types.ArrayFW;
import org.reaktivity.specification.mqtt.internal.types.Flyweight;
import org.reaktivity.specification.mqtt.internal.types.String16FW;

public final class MqttUserPropertyFW
extends Flyweight {
    public static final int FIELD_OFFSET_KEY = 0;
    public static final int FIELD_OFFSET_VALUE = 0;
    private final String16FW keyRO = new String16FW();
    private final String16FW valueRO = new String16FW();

    public String16FW key() {
        return this.keyRO;
    }

    public String16FW value() {
        return this.valueRO;
    }

    @Override
    public MqttUserPropertyFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.keyRO.wrap(buffer, offset + 0, maxLimit);
        this.valueRO.wrap(buffer, this.keyRO.limit() + 0, maxLimit);
        MqttUserPropertyFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public MqttUserPropertyFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.keyRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        if (null == this.valueRO.tryWrap(buffer, this.keyRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.valueRO.limit();
    }

    public String toString() {
        return String.format("MQTT_USER_PROPERTY [key=%s, value=%s]", this.keyRO.asString(), this.valueRO.asString());
    }

    public static final class Builder
    extends Flyweight.Builder<MqttUserPropertyFW> {
        private static final int INDEX_KEY = 0;
        private static final int INDEX_VALUE = 1;
        private static final int FIELD_COUNT = 2;
        private final String16FW.Builder keyRW = new String16FW.Builder();
        private final String16FW.Builder valueRW = new String16FW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new MqttUserPropertyFW());
        }

        private String16FW.Builder key() {
            assert (this.lastFieldSet == -1);
            return this.keyRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder key(String value) {
            String16FW.Builder keyRW = this.key();
            keyRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 0;
            this.limit(keyRW.build().limit());
            return this;
        }

        public Builder key(String16FW value) {
            String16FW.Builder keyRW = this.key();
            keyRW.set(value);
            this.lastFieldSet = 0;
            this.limit(keyRW.build().limit());
            return this;
        }

        public Builder key(DirectBuffer buffer, int offset, int length) {
            String16FW.Builder keyRW = this.key();
            keyRW.set(buffer, offset, length);
            this.lastFieldSet = 0;
            this.limit(keyRW.build().limit());
            return this;
        }

        private String16FW.Builder value() {
            assert (this.lastFieldSet == 0);
            return this.valueRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder value(String value) {
            String16FW.Builder valueRW = this.value();
            valueRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 1;
            this.limit(valueRW.build().limit());
            return this;
        }

        public Builder value(String16FW value) {
            String16FW.Builder valueRW = this.value();
            valueRW.set(value);
            this.lastFieldSet = 1;
            this.limit(valueRW.build().limit());
            return this;
        }

        public Builder value(DirectBuffer buffer, int offset, int length) {
            String16FW.Builder valueRW = this.value();
            valueRW.set(buffer, offset, length);
            this.lastFieldSet = 1;
            this.limit(valueRW.build().limit());
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<MqttUserPropertyFW>, ? extends Flyweight.Builder<MqttUserPropertyFW>, MqttUserPropertyFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public MqttUserPropertyFW build() {
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (MqttUserPropertyFW)super.build();
        }
    }
}

