/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.mqtt.internal.types.stream;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.mqtt.internal.types.Array32FW;
import org.reaktivity.specification.mqtt.internal.types.ArrayFW;
import org.reaktivity.specification.mqtt.internal.types.Flyweight;
import org.reaktivity.specification.mqtt.internal.types.MqttCapabilities;
import org.reaktivity.specification.mqtt.internal.types.MqttCapabilitiesFW;
import org.reaktivity.specification.mqtt.internal.types.MqttUserPropertyFW;
import org.reaktivity.specification.mqtt.internal.types.String16FW;
import org.reaktivity.specification.mqtt.internal.types.Varbyteuint32FW;

public final class MqttBeginExFW
extends Flyweight {
    public static final int FIELD_OFFSET_TYPE_ID = 0;
    private static final int FIELD_SIZE_TYPE_ID = 4;
    public static final int FIELD_OFFSET_CAPABILITIES = 4;
    public static final int FIELD_OFFSET_CLIENT_ID = 0;
    public static final int FIELD_OFFSET_TOPIC = 0;
    public static final int FIELD_OFFSET_SUBSCRIPTION_ID = 0;
    public static final int FIELD_OFFSET_PROPERTIES = 0;
    private MqttCapabilitiesFW capabilitiesRO = new MqttCapabilitiesFW();
    private final String16FW clientIdRO = new String16FW();
    private final String16FW topicRO = new String16FW();
    private Varbyteuint32FW subscriptionIdRO = new Varbyteuint32FW();
    private final Array32FW<MqttUserPropertyFW> propertiesRO = new Array32FW<MqttUserPropertyFW>(new MqttUserPropertyFW());

    public int typeId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public MqttCapabilitiesFW capabilities() {
        return this.capabilitiesRO;
    }

    public String16FW clientId() {
        return this.clientIdRO;
    }

    public String16FW topic() {
        return this.topicRO;
    }

    public int subscriptionId() {
        return this.subscriptionIdRO.value();
    }

    public Array32FW<MqttUserPropertyFW> properties() {
        return this.propertiesRO;
    }

    @Override
    public MqttBeginExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.capabilitiesRO.wrap(buffer, offset + 4, maxLimit);
        this.clientIdRO.wrap(buffer, this.capabilitiesRO.limit() + 0, maxLimit);
        this.topicRO.wrap(buffer, this.clientIdRO.limit() + 0, maxLimit);
        this.subscriptionIdRO.wrap(buffer, this.topicRO.limit() + 0, maxLimit);
        this.propertiesRO.wrap(buffer, this.subscriptionIdRO.limit() + 0, maxLimit);
        MqttBeginExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public MqttBeginExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.capabilitiesRO.tryWrap(buffer, offset + 4, maxLimit)) {
            return null;
        }
        if (null == this.clientIdRO.tryWrap(buffer, this.capabilitiesRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.topicRO.tryWrap(buffer, this.clientIdRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.subscriptionIdRO.tryWrap(buffer, this.topicRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.propertiesRO.tryWrap(buffer, this.subscriptionIdRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.propertiesRO.limit();
    }

    public String toString() {
        return String.format("MQTT_BEGIN_EX [typeId=%d, capabilities=%s, clientId=%s, topic=%s, subscriptionId=%s, properties=%s]", this.typeId(), this.capabilities(), this.clientIdRO.asString(), this.topicRO.asString(), this.subscriptionId(), this.properties());
    }

    public static final class Builder
    extends Flyweight.Builder<MqttBeginExFW> {
        private static final int INDEX_TYPE_ID = 0;
        private static final int INDEX_CAPABILITIES = 1;
        public static final MqttCapabilities DEFAULT_CAPABILITIES = MqttCapabilities.PUBLISH_AND_SUBSCRIBE;
        private static final int INDEX_CLIENT_ID = 2;
        private static final int INDEX_TOPIC = 3;
        private static final int INDEX_SUBSCRIPTION_ID = 4;
        public static final int DEFAULT_SUBSCRIPTION_ID = 0;
        private static final int INDEX_PROPERTIES = 5;
        private static final int FIELD_COUNT = 6;
        private final MqttCapabilitiesFW.Builder capabilitiesRW = new MqttCapabilitiesFW.Builder();
        private final String16FW.Builder clientIdRW = new String16FW.Builder();
        private final String16FW.Builder topicRW = new String16FW.Builder();
        private final Varbyteuint32FW.Builder subscriptionIdRW = new Varbyteuint32FW.Builder();
        private final Array32FW.Builder<MqttUserPropertyFW.Builder, MqttUserPropertyFW> propertiesRW = new Array32FW.Builder<MqttUserPropertyFW.Builder, MqttUserPropertyFW>(new MqttUserPropertyFW.Builder(), new MqttUserPropertyFW());
        private int lastFieldSet = -1;

        public Builder() {
            super(new MqttBeginExFW());
        }

        public Builder typeId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            MqttBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder capabilities(Consumer<MqttCapabilitiesFW.Builder> mutator) {
            assert (this.lastFieldSet == 0);
            MqttCapabilitiesFW.Builder capabilitiesRW = this.capabilitiesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(capabilitiesRW);
            this.limit(capabilitiesRW.build().limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder capabilities(MqttCapabilitiesFW field) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + field.sizeof();
            MqttBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        private String16FW.Builder clientId() {
            if (this.lastFieldSet < 1) {
                this.capabilities((MqttCapabilitiesFW.Builder b) -> b.set(DEFAULT_CAPABILITIES));
            }
            assert (this.lastFieldSet == 1);
            return this.clientIdRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder clientId(String value) {
            String16FW.Builder clientIdRW = this.clientId();
            clientIdRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 2;
            this.limit(clientIdRW.build().limit());
            return this;
        }

        public Builder clientId(String16FW value) {
            String16FW.Builder clientIdRW = this.clientId();
            clientIdRW.set(value);
            this.lastFieldSet = 2;
            this.limit(clientIdRW.build().limit());
            return this;
        }

        public Builder clientId(DirectBuffer buffer, int offset, int length) {
            String16FW.Builder clientIdRW = this.clientId();
            clientIdRW.set(buffer, offset, length);
            this.lastFieldSet = 2;
            this.limit(clientIdRW.build().limit());
            return this;
        }

        private String16FW.Builder topic() {
            assert (this.lastFieldSet == 2);
            return this.topicRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder topic(String value) {
            String16FW.Builder topicRW = this.topic();
            topicRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 3;
            this.limit(topicRW.build().limit());
            return this;
        }

        public Builder topic(String16FW value) {
            String16FW.Builder topicRW = this.topic();
            topicRW.set(value);
            this.lastFieldSet = 3;
            this.limit(topicRW.build().limit());
            return this;
        }

        public Builder topic(DirectBuffer buffer, int offset, int length) {
            String16FW.Builder topicRW = this.topic();
            topicRW.set(buffer, offset, length);
            this.lastFieldSet = 3;
            this.limit(topicRW.build().limit());
            return this;
        }

        public Builder subscriptionId(int value) {
            assert (this.lastFieldSet == 3);
            Varbyteuint32FW.Builder subscriptionIdRW = this.subscriptionIdRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            subscriptionIdRW.set(value);
            this.limit(subscriptionIdRW.build().limit());
            this.lastFieldSet = 4;
            return this;
        }

        public Builder subscriptionId(Varbyteuint32FW field) {
            assert (this.lastFieldSet == 3);
            int newLimit = this.limit() + field.sizeof();
            MqttBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 4;
            return this;
        }

        public Builder properties(Consumer<Array32FW.Builder<MqttUserPropertyFW.Builder, MqttUserPropertyFW>> mutator) {
            if (this.lastFieldSet < 4) {
                this.subscriptionId(0);
            }
            assert (this.lastFieldSet == 4);
            Flyweight.Builder propertiesRW = this.propertiesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept((Array32FW.Builder<MqttUserPropertyFW.Builder, MqttUserPropertyFW>)propertiesRW);
            this.limit(((Array32FW)((Array32FW.Builder)propertiesRW).build()).limit());
            this.lastFieldSet = 5;
            return this;
        }

        public Builder properties(Array32FW<MqttUserPropertyFW> field) {
            if (this.lastFieldSet < 4) {
                this.subscriptionId(0);
            }
            assert (this.lastFieldSet == 4);
            int newLimit = this.limit() + field.sizeof();
            MqttBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 5;
            return this;
        }

        public Builder propertiesItem(Consumer<MqttUserPropertyFW.Builder> mutator) {
            if (this.lastFieldSet < 4) {
                this.subscriptionId(0);
            }
            assert (this.lastFieldSet >= 4);
            if (this.lastFieldSet < 5) {
                this.propertiesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            }
            this.propertiesRW.item((Consumer)mutator);
            this.limit(((Array32FW)this.propertiesRW.build()).limit());
            this.lastFieldSet = 5;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<MqttBeginExFW>, ? extends Flyweight.Builder<MqttBeginExFW>, MqttBeginExFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public MqttBeginExFW build() {
            if (this.lastFieldSet < 5) {
                this.properties((Array32FW.Builder<MqttUserPropertyFW.Builder, MqttUserPropertyFW> b) -> {});
            }
            assert (this.lastFieldSet == 5);
            this.lastFieldSet = -1;
            return (MqttBeginExFW)super.build();
        }
    }
}

