/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.mqtt.internal;

import java.nio.charset.StandardCharsets;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.kaazing.k3po.lang.el.Function;
import org.kaazing.k3po.lang.el.spi.FunctionMapperSpi;
import org.reaktivity.specification.mqtt.internal.types.MqttBinaryFW;
import org.reaktivity.specification.mqtt.internal.types.MqttCapabilities;
import org.reaktivity.specification.mqtt.internal.types.MqttCapabilitiesFW;
import org.reaktivity.specification.mqtt.internal.types.MqttPayloadFormat;
import org.reaktivity.specification.mqtt.internal.types.MqttPayloadFormatFW;
import org.reaktivity.specification.mqtt.internal.types.MqttPublishFlags;
import org.reaktivity.specification.mqtt.internal.types.MqttSubscribeFlags;
import org.reaktivity.specification.mqtt.internal.types.control.MqttRouteExFW;
import org.reaktivity.specification.mqtt.internal.types.stream.MqttAbortExFW;
import org.reaktivity.specification.mqtt.internal.types.stream.MqttBeginExFW;
import org.reaktivity.specification.mqtt.internal.types.stream.MqttDataExFW;

public final class MqttFunctions {
    @Function
    public static byte[] payloadFormat(String format) {
        MqttPayloadFormat mqttPayloadFormat = MqttPayloadFormat.valueOf(format);
        MqttPayloadFormatFW formatFW = new MqttPayloadFormatFW.Builder().wrap((MutableDirectBuffer)new UnsafeBuffer(new byte[1]), 0, 1).set(mqttPayloadFormat).build();
        byte[] array = new byte[formatFW.sizeof()];
        formatFW.buffer().getBytes(formatFW.offset(), array);
        return array;
    }

    @Function
    public static MqttRouteExBuilder routeEx() {
        return new MqttRouteExBuilder();
    }

    @Function
    public static MqttBeginExBuilder beginEx() {
        return new MqttBeginExBuilder();
    }

    @Function
    public static MqttDataExBuilder dataEx() {
        return new MqttDataExBuilder();
    }

    @Function
    public static MqttAbortExBuilder abortEx() {
        return new MqttAbortExBuilder();
    }

    private MqttFunctions() {
    }

    public static class Mapper
    extends FunctionMapperSpi.Reflective {
        public Mapper() {
            super(MqttFunctions.class);
        }

        public String getPrefixName() {
            return "mqtt";
        }
    }

    public static final class MqttAbortExBuilder {
        private final MqttAbortExFW.Builder abortExRW;

        private MqttAbortExBuilder() {
            UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[8192]);
            this.abortExRW = new MqttAbortExFW.Builder().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity());
        }

        public MqttAbortExBuilder typeId(int typeId) {
            this.abortExRW.typeId(typeId);
            return this;
        }

        public MqttAbortExBuilder reason(int reason) {
            this.abortExRW.reason(reason);
            return this;
        }

        public byte[] build() {
            MqttAbortExFW abortEx = this.abortExRW.build();
            byte[] array = new byte[abortEx.sizeof()];
            abortEx.buffer().getBytes(abortEx.offset(), array);
            return array;
        }
    }

    public static final class MqttDataExBuilder {
        private final MqttDataExFW.Builder dataExRW;

        private MqttDataExBuilder() {
            UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[8192]);
            this.dataExRW = new MqttDataExFW.Builder().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity());
        }

        public MqttDataExBuilder typeId(int typeId) {
            this.dataExRW.typeId(typeId);
            return this;
        }

        public MqttDataExBuilder topic(String topic) {
            this.dataExRW.topic(topic);
            return this;
        }

        public MqttDataExBuilder flags(String ... flags) {
            int publishFlags = 0;
            for (int i = 0; i < flags.length; ++i) {
                publishFlags |= 1 << MqttPublishFlags.valueOf(flags[i]).ordinal();
            }
            this.dataExRW.flags(publishFlags);
            return this;
        }

        public MqttDataExBuilder expiryInterval(int msgExp) {
            this.dataExRW.expiryInterval(msgExp);
            return this;
        }

        public MqttDataExBuilder contentType(String contentType) {
            this.dataExRW.contentType(contentType);
            return this;
        }

        public MqttDataExBuilder format(String format) {
            this.dataExRW.format((MqttPayloadFormatFW.Builder p) -> p.set(MqttPayloadFormat.valueOf(format)));
            return this;
        }

        public MqttDataExBuilder responseTopic(String topic) {
            this.dataExRW.responseTopic(topic);
            return this;
        }

        public MqttDataExBuilder correlation(String correlation) {
            this.dataExRW.correlation((MqttBinaryFW.Builder c) -> c.bytes(b -> b.set(correlation.getBytes(StandardCharsets.UTF_8))));
            return this;
        }

        public MqttDataExBuilder correlationBytes(byte[] correlation) {
            this.dataExRW.correlation((MqttBinaryFW.Builder c) -> c.bytes(b -> b.set(correlation)));
            return this;
        }

        public MqttDataExBuilder userProperty(String name, String value) {
            this.dataExRW.propertiesItem(p -> p.key(name).value(value));
            return this;
        }

        public byte[] build() {
            MqttDataExFW dataEx = this.dataExRW.build();
            byte[] array = new byte[dataEx.sizeof()];
            dataEx.buffer().getBytes(dataEx.offset(), array);
            return array;
        }
    }

    public static final class MqttBeginExBuilder {
        private final MqttBeginExFW.Builder beginExRW;

        private MqttBeginExBuilder() {
            UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[8192]);
            this.beginExRW = new MqttBeginExFW.Builder().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity());
        }

        public MqttBeginExBuilder typeId(int typeId) {
            this.beginExRW.typeId(typeId);
            return this;
        }

        public MqttBeginExBuilder clientId(String clientId) {
            this.beginExRW.clientId(clientId);
            return this;
        }

        public MqttBeginExBuilder topic(String topic) {
            this.beginExRW.topic(topic);
            return this;
        }

        public MqttBeginExBuilder flags(String ... flags) {
            int subscribeFlags = 0;
            for (int i = 0; i < flags.length; ++i) {
                subscribeFlags |= 1 << MqttSubscribeFlags.valueOf(flags[i]).ordinal();
            }
            this.beginExRW.flags(subscribeFlags);
            return this;
        }

        public MqttBeginExBuilder capabilities(String capabilities) {
            this.beginExRW.capabilities((MqttCapabilitiesFW.Builder p) -> p.set(MqttCapabilities.valueOf(capabilities)));
            return this;
        }

        public MqttBeginExBuilder subscriptionId(int id) {
            this.beginExRW.subscriptionId(id);
            return this;
        }

        public MqttBeginExBuilder userProperty(String name, String value) {
            if (value == null) {
                this.beginExRW.propertiesItem(p -> p.key(name).value((String)null));
            } else {
                this.beginExRW.propertiesItem(p -> p.key(name).value(value));
            }
            return this;
        }

        public byte[] build() {
            MqttBeginExFW beginEx = this.beginExRW.build();
            byte[] array = new byte[beginEx.sizeof()];
            beginEx.buffer().getBytes(beginEx.offset(), array);
            return array;
        }
    }

    public static final class MqttRouteExBuilder {
        private final MqttRouteExFW.Builder routeExRW;

        private MqttRouteExBuilder() {
            UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[8192]);
            this.routeExRW = new MqttRouteExFW.Builder().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity());
        }

        public MqttRouteExBuilder topic(String topic) {
            this.routeExRW.topic(topic);
            return this;
        }

        public MqttRouteExBuilder capabilities(String capabilities) {
            this.routeExRW.capabilities((MqttCapabilitiesFW.Builder c) -> c.set(MqttCapabilities.valueOf(capabilities)));
            return this;
        }

        public byte[] build() {
            MqttRouteExFW routeEx = this.routeExRW.build();
            byte[] array = new byte[routeEx.sizeof()];
            routeEx.buffer().getBytes(routeEx.offset(), array);
            return array;
        }
    }
}

