/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.mqtt.internal.types.stream;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.mqtt.internal.types.ArrayFW;
import org.reaktivity.specification.mqtt.internal.types.Flyweight;

public final class MqttAbortExFW
extends Flyweight {
    public static final int FIELD_OFFSET_TYPE_ID = 0;
    private static final int FIELD_SIZE_TYPE_ID = 4;
    public static final int FIELD_OFFSET_REASON = 4;
    private static final int FIELD_SIZE_REASON = 1;

    public int typeId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public int reason() {
        return this.buffer().getByte(this.offset() + 4) & 0xFF;
    }

    @Override
    public MqttAbortExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        MqttAbortExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public MqttAbortExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.offset() + 4 + 1;
    }

    public String toString() {
        return String.format("MQTT_ABORT_EX [typeId=%d, reason=%d]", this.typeId(), this.reason());
    }

    public static final class Builder
    extends Flyweight.Builder<MqttAbortExFW> {
        private static final int INDEX_TYPE_ID = 0;
        private static final int INDEX_REASON = 1;
        private static final int FIELD_COUNT = 2;
        private int lastFieldSet = -1;

        public Builder() {
            super(new MqttAbortExFW());
        }

        public Builder typeId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            MqttAbortExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder reason(int value) {
            if (value < 0) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"reason\"", value));
            }
            if (value > 255) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"reason\"", value));
            }
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + 1;
            MqttAbortExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putByte(this.limit(), (byte)(value & 0xFF));
            this.lastFieldSet = 1;
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<MqttAbortExFW>, ? extends Flyweight.Builder<MqttAbortExFW>, MqttAbortExFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public MqttAbortExFW build() {
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (MqttAbortExFW)super.build();
        }
    }
}

