/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.mqtt.internal.types;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.mqtt.internal.types.ArrayFW;
import org.reaktivity.specification.mqtt.internal.types.Flyweight;
import org.reaktivity.specification.mqtt.internal.types.OctetsFW;

public final class MqttBinaryFW
extends Flyweight {
    public static final int FIELD_OFFSET_LENGTH = 0;
    private static final int FIELD_SIZE_LENGTH = 4;
    public static final int FIELD_OFFSET_BYTES = 4;
    private OctetsFW bytesRO = new OctetsFW();

    public int length() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public OctetsFW bytes() {
        return this.length() == -1 ? null : this.bytesRO;
    }

    @Override
    public MqttBinaryFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.bytesRO.wrap(buffer, offset + 4, offset + 4 + (this.length() == -1 ? 0 : this.length()));
        MqttBinaryFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public MqttBinaryFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        int limit = offset + 4 + (this.length() == -1 ? 0 : this.length());
        if (limit > maxLimit || null == this.bytesRO.tryWrap(buffer, offset + 4, limit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.bytesRO.limit();
    }

    public String toString() {
        return String.format("MQTT_BINARY [length=%d, bytes=%s]", this.length(), this.bytes());
    }

    public static final class Builder
    extends Flyweight.Builder<MqttBinaryFW> {
        public static final int DEFAULT_LENGTH = 0;
        private static final int INDEX_BYTES = 0;
        private static final int FIELD_COUNT = 1;
        private int dynamicOffsetLength;
        private final OctetsFW.Builder bytesRW = new OctetsFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new MqttBinaryFW());
        }

        private Builder length(int value) {
            int newLimit = this.limit() + 4;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.dynamicOffsetLength = this.limit();
            this.limit(newLimit);
            return this;
        }

        private OctetsFW.Builder bytes() {
            this.length(0);
            assert (this.lastFieldSet == -1);
            return this.bytesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder bytes(OctetsFW value) {
            int newLimit;
            int size$;
            OctetsFW.Builder bytesRW = this.bytes();
            if (value == null) {
                size$ = -1;
                newLimit = this.limit();
            } else {
                bytesRW.set(value);
                newLimit = ((OctetsFW)bytesRW.build()).limit();
                size$ = newLimit - this.limit();
            }
            this.limit(this.dynamicOffsetLength);
            this.length(size$);
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        public Builder bytes(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder bytesRW = this.bytes();
            mutator.accept(bytesRW);
            int newLimit = ((OctetsFW)bytesRW.build()).limit();
            int size$ = newLimit - this.limit();
            this.limit(this.dynamicOffsetLength);
            this.length(size$);
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        public Builder bytes(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder bytesRW = this.bytes();
            bytesRW.set(buffer, offset, length);
            int newLimit = ((OctetsFW)bytesRW.build()).limit();
            int size$ = newLimit - this.limit();
            this.limit(this.dynamicOffsetLength);
            this.length(size$);
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.dynamicOffsetLength = -1;
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<MqttBinaryFW>, ? extends Flyweight.Builder<MqttBinaryFW>, MqttBinaryFW> array) {
            super.wrap(array);
            this.dynamicOffsetLength = -1;
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public MqttBinaryFW build() {
            if (this.lastFieldSet < 0) {
                this.bytes((OctetsFW.Builder b) -> {});
                int limit = this.limit();
                this.limit(this.dynamicOffsetLength);
                this.length(-1);
                this.limit(limit);
            }
            assert (this.lastFieldSet == 0);
            this.lastFieldSet = -1;
            return (MqttBinaryFW)super.build();
        }
    }
}

