/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.mqtt.internal.types;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.specification.mqtt.internal.types.Flyweight;
import org.reaktivity.specification.mqtt.internal.types.StringFW;

public final class String8FW
extends StringFW {
    private static final int FIELD_SIZE_LENGTH = 1;
    private final DirectBuffer valueRO = new UnsafeBuffer(0L, 0);

    public String8FW() {
    }

    public String8FW(String value) {
        this(value, StandardCharsets.UTF_8);
    }

    public String8FW(String value, Charset charset) {
        if (value != null) {
            byte[] encoded = value.getBytes(charset);
            UnsafeBuffer buffer = new UnsafeBuffer(new byte[1 + Math.max(encoded.length, 1)]);
            buffer.putByte(0, (byte)(encoded.length & 0xFF));
            buffer.putBytes(1, encoded);
            this.wrap((DirectBuffer)buffer, 0, buffer.capacity());
        } else {
            UnsafeBuffer buffer = new UnsafeBuffer(new byte[2]);
            buffer.putByte(0, (byte)-1);
            this.wrap((DirectBuffer)buffer, 0, buffer.capacity());
        }
    }

    @Override
    public int fieldSizeLength() {
        return 1;
    }

    @Override
    public int limit() {
        return this.offset() + 1 + Math.max(this.length(), 0);
    }

    @Override
    public String asString() {
        if (this.maxLimit() == this.offset() || this.length() == -1) {
            return null;
        }
        return this.buffer().getStringWithoutLengthUtf8(this.offset() + 1, this.length());
    }

    @Override
    public String8FW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit) || offset + 1 > this.maxLimit() || this.limit() > maxLimit) {
            return null;
        }
        int length = this.length();
        if (length != -1) {
            this.valueRO.wrap(buffer, offset + 1, length);
        }
        return this;
    }

    @Override
    public String8FW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        String8FW.checkLimit(offset + 1, maxLimit);
        String8FW.checkLimit(this.limit(), maxLimit);
        int length = this.length();
        if (length != -1) {
            this.valueRO.wrap(buffer, offset + 1, length);
        }
        return this;
    }

    public DirectBuffer value() {
        return this.length() == -1 ? null : this.valueRO;
    }

    public String toString() {
        return String.format("\"%s\"", this.asString());
    }

    @Override
    public int length() {
        int length = this.buffer().getByte(this.offset()) & 0xFF;
        return length == 255 ? -1 : length;
    }

    public static final class Builder
    extends StringFW.Builder<String8FW> {
        private boolean valueSet;

        public Builder() {
            super(new String8FW());
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            Flyweight.checkLimit(offset + 1, maxLimit);
            super.wrap(buffer, offset, maxLimit);
            this.valueSet = false;
            return this;
        }

        @Override
        public Builder set(StringFW value) {
            if (value.length() == -1) {
                int newLimit = this.offset() + 1;
                Flyweight.checkLimit(newLimit, this.maxLimit());
                this.buffer().putByte(this.offset(), (byte)-1);
                this.limit(newLimit);
            } else {
                int newLimit = this.offset() + 1 + value.length();
                Flyweight.checkLimit(newLimit, this.maxLimit());
                this.buffer().putByte(this.offset(), (byte)value.length());
                this.buffer().putBytes(this.offset() + 1, value.buffer(), value.offset() + value.fieldSizeLength(), value.length());
                this.limit(newLimit);
            }
            this.valueSet = true;
            return this;
        }

        @Override
        public Builder set(DirectBuffer srcBuffer, int srcOffset, int length) {
            Builder.checkLength(length);
            int offset = this.offset();
            int newLimit = offset + length + 1;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putByte(offset, (byte)length);
            this.buffer().putBytes(offset + 1, srcBuffer, srcOffset, length);
            this.limit(newLimit);
            this.valueSet = true;
            return this;
        }

        @Override
        public Builder set(String value, Charset charset) {
            if (value == null) {
                int newLimit = this.offset() + 1;
                Flyweight.checkLimit(newLimit, this.maxLimit());
                this.buffer().putByte(this.offset(), (byte)-1);
                this.limit(newLimit);
            } else {
                byte[] charBytes = value.getBytes(charset);
                Builder.checkLength(charBytes.length);
                int newLimit = this.offset() + 1 + charBytes.length;
                Flyweight.checkLimit(newLimit, this.maxLimit());
                this.buffer().putByte(this.offset(), (byte)charBytes.length);
                this.buffer().putBytes(this.offset() + 1, charBytes);
                this.limit(newLimit);
            }
            this.valueSet = true;
            return this;
        }

        private static void checkLength(int length) {
            int maxLength = 254;
            if (length > 254) {
                String msg = String.format("length=%d is beyond maximum length=%d", length, 254);
                throw new IllegalArgumentException(msg);
            }
        }

        @Override
        public String8FW build() {
            if (!this.valueSet) {
                this.set(null, StandardCharsets.UTF_8);
            }
            return (String8FW)super.build();
        }
    }
}

