/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.mqtt.internal.types.stream;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.mqtt.internal.types.Array32FW;
import org.reaktivity.specification.mqtt.internal.types.ArrayFW;
import org.reaktivity.specification.mqtt.internal.types.Flyweight;
import org.reaktivity.specification.mqtt.internal.types.MqttBinaryFW;
import org.reaktivity.specification.mqtt.internal.types.MqttPayloadFormat;
import org.reaktivity.specification.mqtt.internal.types.MqttPayloadFormatFW;
import org.reaktivity.specification.mqtt.internal.types.MqttUserPropertyFW;
import org.reaktivity.specification.mqtt.internal.types.String16FW;

public final class MqttDataExFW
extends Flyweight {
    public static final int FIELD_OFFSET_TYPE_ID = 0;
    private static final int FIELD_SIZE_TYPE_ID = 4;
    public static final int FIELD_OFFSET_DEFERRED = 4;
    private static final int FIELD_SIZE_DEFERRED = 4;
    public static final int FIELD_OFFSET_TOPIC = 8;
    public static final int FIELD_OFFSET_FLAGS = 0;
    private static final int FIELD_SIZE_FLAGS = 1;
    public static final int FIELD_OFFSET_EXPIRY_INTERVAL = 1;
    private static final int FIELD_SIZE_EXPIRY_INTERVAL = 4;
    public static final int FIELD_OFFSET_CONTENT_TYPE = 5;
    public static final int FIELD_OFFSET_FORMAT = 0;
    public static final int FIELD_OFFSET_RESPONSE_TOPIC = 0;
    public static final int FIELD_OFFSET_CORRELATION = 0;
    public static final int FIELD_OFFSET_PROPERTIES = 0;
    private String16FW topicRO = new String16FW();
    private String16FW contentTypeRO = new String16FW();
    private MqttPayloadFormatFW formatRO = new MqttPayloadFormatFW();
    private String16FW responseTopicRO = new String16FW();
    private final MqttBinaryFW correlationRO = new MqttBinaryFW();
    private final Array32FW<MqttUserPropertyFW> propertiesRO = new Array32FW<MqttUserPropertyFW>(new MqttUserPropertyFW());

    public int typeId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public int deferred() {
        return this.buffer().getInt(this.offset() + 4);
    }

    public String16FW topic() {
        return this.topicRO;
    }

    public int flags() {
        return this.buffer().getByte(this.topicRO.limit() + 0) & 0xFF;
    }

    public int expiryInterval() {
        return this.buffer().getInt(this.topicRO.limit() + 1);
    }

    public String16FW contentType() {
        return this.contentTypeRO;
    }

    public MqttPayloadFormatFW format() {
        return this.formatRO;
    }

    public String16FW responseTopic() {
        return this.responseTopicRO;
    }

    public MqttBinaryFW correlation() {
        return this.correlationRO;
    }

    public Array32FW<MqttUserPropertyFW> properties() {
        return this.propertiesRO;
    }

    @Override
    public MqttDataExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.topicRO.wrap(buffer, offset + 8, maxLimit);
        this.contentTypeRO.wrap(buffer, this.topicRO.limit() + 5, maxLimit);
        this.formatRO.wrap(buffer, this.contentTypeRO.limit() + 0, maxLimit);
        this.responseTopicRO.wrap(buffer, this.formatRO.limit() + 0, maxLimit);
        this.correlationRO.wrap(buffer, this.responseTopicRO.limit() + 0, maxLimit);
        this.propertiesRO.wrap(buffer, this.correlationRO.limit() + 0, maxLimit);
        MqttDataExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public MqttDataExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.topicRO.tryWrap(buffer, offset + 8, maxLimit)) {
            return null;
        }
        if (null == this.contentTypeRO.tryWrap(buffer, this.topicRO.limit() + 5, maxLimit)) {
            return null;
        }
        if (null == this.formatRO.tryWrap(buffer, this.contentTypeRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.responseTopicRO.tryWrap(buffer, this.formatRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.correlationRO.tryWrap(buffer, this.responseTopicRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.propertiesRO.tryWrap(buffer, this.correlationRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.propertiesRO.limit();
    }

    public String toString() {
        return String.format("MQTT_DATA_EX [typeId=%d, deferred=%d, topic=%s, flags=%d, expiryInterval=%d, contentType=%s, format=%s, responseTopic=%s, correlation=%s, properties=%s]", this.typeId(), this.deferred(), this.topicRO.asString(), this.flags(), this.expiryInterval(), this.contentTypeRO.asString(), this.format(), this.responseTopicRO.asString(), this.correlation(), this.properties());
    }

    public static final class Builder
    extends Flyweight.Builder<MqttDataExFW> {
        private static final int INDEX_TYPE_ID = 0;
        private static final int INDEX_DEFERRED = 1;
        public static final int DEFAULT_DEFERRED = 0;
        private static final int INDEX_TOPIC = 2;
        public static final String DEFAULT_TOPIC = null;
        private static final int INDEX_FLAGS = 3;
        public static final int DEFAULT_FLAGS = 0;
        private static final int INDEX_EXPIRY_INTERVAL = 4;
        public static final int DEFAULT_EXPIRY_INTERVAL = -1;
        private static final int INDEX_CONTENT_TYPE = 5;
        public static final String DEFAULT_CONTENT_TYPE = null;
        private static final int INDEX_FORMAT = 6;
        public static final MqttPayloadFormat DEFAULT_FORMAT = MqttPayloadFormat.BINARY;
        private static final int INDEX_RESPONSE_TOPIC = 7;
        public static final String DEFAULT_RESPONSE_TOPIC = null;
        private static final int INDEX_CORRELATION = 8;
        private static final int INDEX_PROPERTIES = 9;
        private static final int FIELD_COUNT = 10;
        private final String16FW.Builder topicRW = new String16FW.Builder();
        private final String16FW.Builder contentTypeRW = new String16FW.Builder();
        private final MqttPayloadFormatFW.Builder formatRW = new MqttPayloadFormatFW.Builder();
        private final String16FW.Builder responseTopicRW = new String16FW.Builder();
        private final MqttBinaryFW.Builder correlationRW = new MqttBinaryFW.Builder();
        private final Array32FW.Builder<MqttUserPropertyFW.Builder, MqttUserPropertyFW> propertiesRW = new Array32FW.Builder<MqttUserPropertyFW.Builder, MqttUserPropertyFW>(new MqttUserPropertyFW.Builder(), new MqttUserPropertyFW());
        private int lastFieldSet = -1;

        public Builder() {
            super(new MqttDataExFW());
        }

        public Builder typeId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            MqttDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder deferred(int value) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + 4;
            MqttDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 1;
            this.limit(newLimit);
            return this;
        }

        private String16FW.Builder topic() {
            if (this.lastFieldSet < 1) {
                this.deferred(0);
            }
            assert (this.lastFieldSet == 1);
            return this.topicRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder topic(String value) {
            String16FW.Builder topicRW = this.topic();
            topicRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 2;
            this.limit(topicRW.build().limit());
            return this;
        }

        public Builder topic(String16FW value) {
            String16FW.Builder topicRW = this.topic();
            topicRW.set((Flyweight)value);
            this.lastFieldSet = 2;
            this.limit(topicRW.build().limit());
            return this;
        }

        public Builder topic(DirectBuffer buffer, int offset, int length) {
            String16FW.Builder topicRW = this.topic();
            topicRW.set(buffer, offset, length);
            this.lastFieldSet = 2;
            this.limit(topicRW.build().limit());
            return this;
        }

        public Builder flags(int value) {
            if (value < 0) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"flags\"", value));
            }
            if (value > 255) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"flags\"", value));
            }
            if (this.lastFieldSet < 2) {
                this.topic((String)null);
            }
            assert (this.lastFieldSet == 2);
            int newLimit = this.limit() + 1;
            MqttDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putByte(this.limit(), (byte)(value & 0xFF));
            this.lastFieldSet = 3;
            this.limit(newLimit);
            return this;
        }

        public Builder expiryInterval(int value) {
            if (this.lastFieldSet < 3) {
                this.flags(0);
            }
            assert (this.lastFieldSet == 3);
            int newLimit = this.limit() + 4;
            MqttDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 4;
            this.limit(newLimit);
            return this;
        }

        private String16FW.Builder contentType() {
            if (this.lastFieldSet < 4) {
                this.expiryInterval(-1);
            }
            assert (this.lastFieldSet == 4);
            return this.contentTypeRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder contentType(String value) {
            String16FW.Builder contentTypeRW = this.contentType();
            contentTypeRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 5;
            this.limit(contentTypeRW.build().limit());
            return this;
        }

        public Builder contentType(String16FW value) {
            String16FW.Builder contentTypeRW = this.contentType();
            contentTypeRW.set((Flyweight)value);
            this.lastFieldSet = 5;
            this.limit(contentTypeRW.build().limit());
            return this;
        }

        public Builder contentType(DirectBuffer buffer, int offset, int length) {
            String16FW.Builder contentTypeRW = this.contentType();
            contentTypeRW.set(buffer, offset, length);
            this.lastFieldSet = 5;
            this.limit(contentTypeRW.build().limit());
            return this;
        }

        public Builder format(Consumer<MqttPayloadFormatFW.Builder> mutator) {
            if (this.lastFieldSet < 5) {
                this.contentType((String)null);
            }
            assert (this.lastFieldSet == 5);
            MqttPayloadFormatFW.Builder formatRW = this.formatRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(formatRW);
            this.limit(formatRW.build().limit());
            this.lastFieldSet = 6;
            return this;
        }

        public Builder format(MqttPayloadFormatFW field) {
            if (this.lastFieldSet < 5) {
                this.contentType((String)null);
            }
            assert (this.lastFieldSet == 5);
            int newLimit = this.limit() + field.sizeof();
            MqttDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 6;
            return this;
        }

        private String16FW.Builder responseTopic() {
            if (this.lastFieldSet < 6) {
                this.format((MqttPayloadFormatFW.Builder b) -> b.set(DEFAULT_FORMAT));
            }
            assert (this.lastFieldSet == 6);
            return this.responseTopicRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder responseTopic(String value) {
            String16FW.Builder responseTopicRW = this.responseTopic();
            responseTopicRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 7;
            this.limit(responseTopicRW.build().limit());
            return this;
        }

        public Builder responseTopic(String16FW value) {
            String16FW.Builder responseTopicRW = this.responseTopic();
            responseTopicRW.set((Flyweight)value);
            this.lastFieldSet = 7;
            this.limit(responseTopicRW.build().limit());
            return this;
        }

        public Builder responseTopic(DirectBuffer buffer, int offset, int length) {
            String16FW.Builder responseTopicRW = this.responseTopic();
            responseTopicRW.set(buffer, offset, length);
            this.lastFieldSet = 7;
            this.limit(responseTopicRW.build().limit());
            return this;
        }

        public Builder correlation(Consumer<MqttBinaryFW.Builder> mutator) {
            if (this.lastFieldSet < 7) {
                this.responseTopic((String)null);
            }
            assert (this.lastFieldSet == 7);
            MqttBinaryFW.Builder correlationRW = this.correlationRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(correlationRW);
            this.limit(correlationRW.build().limit());
            this.lastFieldSet = 8;
            return this;
        }

        public Builder correlation(MqttBinaryFW field) {
            if (this.lastFieldSet < 7) {
                this.responseTopic((String)null);
            }
            assert (this.lastFieldSet == 7);
            int newLimit = this.limit() + field.sizeof();
            MqttDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 8;
            return this;
        }

        public Builder properties(Consumer<Array32FW.Builder<MqttUserPropertyFW.Builder, MqttUserPropertyFW>> mutator) {
            if (this.lastFieldSet < 8) {
                this.correlation((MqttBinaryFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 8);
            Flyweight.Builder propertiesRW = this.propertiesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept((Array32FW.Builder<MqttUserPropertyFW.Builder, MqttUserPropertyFW>)propertiesRW);
            this.limit(((Array32FW)((Array32FW.Builder)propertiesRW).build()).limit());
            this.lastFieldSet = 9;
            return this;
        }

        public Builder properties(Array32FW<MqttUserPropertyFW> field) {
            if (this.lastFieldSet < 8) {
                this.correlation((MqttBinaryFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 8);
            int newLimit = this.limit() + field.sizeof();
            MqttDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 9;
            return this;
        }

        public Builder propertiesItem(Consumer<MqttUserPropertyFW.Builder> mutator) {
            if (this.lastFieldSet < 8) {
                this.correlation((MqttBinaryFW.Builder b) -> {});
            }
            assert (this.lastFieldSet >= 8);
            if (this.lastFieldSet < 9) {
                this.propertiesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            }
            this.propertiesRW.item((Consumer)mutator);
            this.limit(((Array32FW)this.propertiesRW.build()).limit());
            this.lastFieldSet = 9;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<MqttDataExFW>, ? extends Flyweight.Builder<MqttDataExFW>, MqttDataExFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public MqttDataExFW build() {
            if (this.lastFieldSet < 9) {
                this.properties((Array32FW.Builder<MqttUserPropertyFW.Builder, MqttUserPropertyFW> b) -> {});
            }
            assert (this.lastFieldSet == 9);
            this.lastFieldSet = -1;
            return (MqttDataExFW)super.build();
        }
    }
}

