/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.mqtt.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.mqtt.internal.types.ArrayFW;
import org.reaktivity.specification.mqtt.internal.types.Flyweight;
import org.reaktivity.specification.mqtt.internal.types.MqttCapabilities;
import org.reaktivity.specification.mqtt.internal.types.MqttCapabilitiesFW;

public final class MqttFlushExFW
extends Flyweight {
    public static final int FIELD_OFFSET_TYPE_ID = 0;
    private static final int FIELD_SIZE_TYPE_ID = 4;
    public static final int FIELD_OFFSET_FLAGS = 4;
    private static final int FIELD_SIZE_FLAGS = 1;
    public static final int FIELD_OFFSET_CAPABILITIES = 5;
    private MqttCapabilitiesFW capabilitiesRO = new MqttCapabilitiesFW();

    public int typeId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public int flags() {
        return this.buffer().getByte(this.offset() + 4) & 0xFF;
    }

    public MqttCapabilitiesFW capabilities() {
        return this.capabilitiesRO;
    }

    @Override
    public MqttFlushExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.capabilitiesRO.wrap(buffer, offset + 5, maxLimit);
        MqttFlushExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public MqttFlushExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.capabilitiesRO.tryWrap(buffer, offset + 5, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.capabilitiesRO.limit();
    }

    public String toString() {
        return String.format("MQTT_FLUSH_EX [typeId=%d, flags=%d, capabilities=%s]", this.typeId(), this.flags(), this.capabilities());
    }

    public static final class Builder
    extends Flyweight.Builder<MqttFlushExFW> {
        private static final int INDEX_TYPE_ID = 0;
        private static final int INDEX_FLAGS = 1;
        public static final int DEFAULT_FLAGS = 0;
        private static final int INDEX_CAPABILITIES = 2;
        public static final MqttCapabilities DEFAULT_CAPABILITIES = MqttCapabilities.PUBLISH_AND_SUBSCRIBE;
        private static final int FIELD_COUNT = 3;
        private final MqttCapabilitiesFW.Builder capabilitiesRW = new MqttCapabilitiesFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new MqttFlushExFW());
        }

        public Builder typeId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            MqttFlushExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder flags(int value) {
            if (value < 0) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"flags\"", value));
            }
            if (value > 255) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"flags\"", value));
            }
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + 1;
            MqttFlushExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putByte(this.limit(), (byte)(value & 0xFF));
            this.lastFieldSet = 1;
            this.limit(newLimit);
            return this;
        }

        public Builder capabilities(Consumer<MqttCapabilitiesFW.Builder> mutator) {
            if (this.lastFieldSet < 1) {
                this.flags(0);
            }
            assert (this.lastFieldSet == 1);
            MqttCapabilitiesFW.Builder capabilitiesRW = this.capabilitiesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(capabilitiesRW);
            this.limit(capabilitiesRW.build().limit());
            this.lastFieldSet = 2;
            return this;
        }

        public Builder capabilities(MqttCapabilitiesFW field) {
            if (this.lastFieldSet < 1) {
                this.flags(0);
            }
            assert (this.lastFieldSet == 1);
            int newLimit = this.limit() + field.sizeof();
            MqttFlushExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 2;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<MqttFlushExFW>, ? extends Flyweight.Builder<MqttFlushExFW>, MqttFlushExFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public MqttFlushExFW build() {
            if (this.lastFieldSet < 2) {
                this.capabilities((MqttCapabilitiesFW.Builder b) -> b.set(DEFAULT_CAPABILITIES));
            }
            assert (this.lastFieldSet == 2);
            this.lastFieldSet = -1;
            return (MqttFlushExFW)super.build();
        }
    }
}

