/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.mqtt.internal.types;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.mqtt.internal.types.Flyweight;
import org.reaktivity.specification.mqtt.internal.types.MqttCapabilities;

public final class MqttCapabilitiesFW
extends Flyweight {
    private static final int FIELD_OFFSET_VALUE = 0;
    private static final int FIELD_SIZE_VALUE = 1;

    @Override
    public int limit() {
        return this.offset() + 1;
    }

    public MqttCapabilities get() {
        return MqttCapabilities.valueOf(this.buffer().getByte(this.offset() + 0) & 0xFF);
    }

    @Override
    public MqttCapabilitiesFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null || this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public MqttCapabilitiesFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        MqttCapabilitiesFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    public String toString() {
        return this.maxLimit() == this.offset() ? "null" : this.get().toString();
    }

    public static final class Builder
    extends Flyweight.Builder<MqttCapabilitiesFW> {
        private boolean valueSet;

        public Builder() {
            super(new MqttCapabilitiesFW());
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            return this;
        }

        public Builder set(MqttCapabilitiesFW value) {
            int newLimit = this.offset() + value.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.offset(), value.buffer(), value.offset(), value.sizeof());
            this.limit(newLimit);
            this.valueSet = true;
            return this;
        }

        public Builder set(MqttCapabilities value) {
            MutableDirectBuffer buffer = this.buffer();
            int offset = this.offset();
            int newLimit = offset + 1;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            buffer.putByte(offset, (byte)(value.value() & 0xFF));
            this.limit(newLimit);
            this.valueSet = true;
            return this;
        }

        @Override
        public MqttCapabilitiesFW build() {
            if (!this.valueSet) {
                throw new IllegalStateException("MqttCapabilities not set");
            }
            return (MqttCapabilitiesFW)super.build();
        }
    }
}

