/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.mqtt.internal.types.control;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.mqtt.internal.types.ArrayFW;
import org.reaktivity.specification.mqtt.internal.types.Flyweight;
import org.reaktivity.specification.mqtt.internal.types.MqttCapabilities;
import org.reaktivity.specification.mqtt.internal.types.MqttCapabilitiesFW;
import org.reaktivity.specification.mqtt.internal.types.String16FW;

public final class MqttRouteExFW
extends Flyweight {
    public static final int FIELD_OFFSET_TOPIC = 0;
    public static final int FIELD_OFFSET_CAPABILITIES = 0;
    private final String16FW topicRO = new String16FW();
    private MqttCapabilitiesFW capabilitiesRO = new MqttCapabilitiesFW();

    public String16FW topic() {
        return this.topicRO;
    }

    public MqttCapabilitiesFW capabilities() {
        return this.capabilitiesRO;
    }

    @Override
    public MqttRouteExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.topicRO.wrap(buffer, offset + 0, maxLimit);
        this.capabilitiesRO.wrap(buffer, this.topicRO.limit() + 0, maxLimit);
        MqttRouteExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public MqttRouteExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.topicRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        if (null == this.capabilitiesRO.tryWrap(buffer, this.topicRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.capabilitiesRO.limit();
    }

    public String toString() {
        return String.format("MQTT_ROUTE_EX [topic=%s, capabilities=%s]", this.topicRO.asString(), this.capabilities());
    }

    public static final class Builder
    extends Flyweight.Builder<MqttRouteExFW> {
        private static final int INDEX_TOPIC = 0;
        private static final int INDEX_CAPABILITIES = 1;
        public static final MqttCapabilities DEFAULT_CAPABILITIES = MqttCapabilities.PUBLISH_AND_SUBSCRIBE;
        private static final int FIELD_COUNT = 2;
        private final String16FW.Builder topicRW = new String16FW.Builder();
        private final MqttCapabilitiesFW.Builder capabilitiesRW = new MqttCapabilitiesFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new MqttRouteExFW());
        }

        private String16FW.Builder topic() {
            assert (this.lastFieldSet == -1);
            return this.topicRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder topic(String value) {
            String16FW.Builder topicRW = this.topic();
            topicRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 0;
            this.limit(topicRW.build().limit());
            return this;
        }

        public Builder topic(String16FW value) {
            String16FW.Builder topicRW = this.topic();
            topicRW.set((Flyweight)value);
            this.lastFieldSet = 0;
            this.limit(topicRW.build().limit());
            return this;
        }

        public Builder topic(DirectBuffer buffer, int offset, int length) {
            String16FW.Builder topicRW = this.topic();
            topicRW.set(buffer, offset, length);
            this.lastFieldSet = 0;
            this.limit(topicRW.build().limit());
            return this;
        }

        public Builder capabilities(Consumer<MqttCapabilitiesFW.Builder> mutator) {
            assert (this.lastFieldSet == 0);
            MqttCapabilitiesFW.Builder capabilitiesRW = this.capabilitiesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(capabilitiesRW);
            this.limit(capabilitiesRW.build().limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder capabilities(MqttCapabilitiesFW field) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + field.sizeof();
            MqttRouteExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<MqttRouteExFW>, ? extends Flyweight.Builder<MqttRouteExFW>, MqttRouteExFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public MqttRouteExFW build() {
            if (this.lastFieldSet < 1) {
                this.capabilities((MqttCapabilitiesFW.Builder b) -> b.set(DEFAULT_CAPABILITIES));
            }
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (MqttRouteExFW)super.build();
        }
    }
}

