/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.nukleus.oauth.internal;

import com.hierynomus.asn1.encodingrules.ASN1Decoder;
import com.hierynomus.asn1.encodingrules.der.DERDecoder;
import com.hierynomus.asn1.types.ASN1Tag;
import com.hierynomus.asn1.types.constructed.ASN1Sequence;
import com.hierynomus.asn1.types.primitive.ASN1Integer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.agrona.LangUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.kaazing.k3po.lang.el.Function;
import org.kaazing.k3po.lang.el.spi.FunctionMapperSpi;
import org.reaktivity.specification.nukleus.oauth.internal.OAuthJwtKeys;
import org.reaktivity.specification.oauth.internal.types.control.OAuthResolveExFW;

public final class OAuthFunctions {
    private static final Map<String, Supplier<JwtHelper>> HELPER_FACTORIES;

    @Function
    public static OAuthResolveExBuilder resolveEx() {
        return new OAuthResolveExBuilder();
    }

    @Function
    public static JwtHelper jwt(String kind) {
        Supplier<JwtHelper> helperFactory = HELPER_FACTORIES.get(kind);
        return helperFactory.get();
    }

    static JwtHelper jwt(KeyPair pair, String kind, String algorithm) {
        return new JwtHelper(pair, kind, algorithm);
    }

    static byte[] decodeIntegrity(byte[] integrity) {
        return JwtSigner.decodeDER(integrity);
    }

    private OAuthFunctions() {
    }

    static {
        HashMap<String, Supplier<JwtHelper>> helperFactories = new HashMap<String, Supplier<JwtHelper>>();
        helperFactories.put("RS256", () -> new JwtHelper(OAuthJwtKeys.RFC7515_RS256, "RS256", "SHA256withRSA"));
        helperFactories.put("ES256", () -> new JwtHelper(OAuthJwtKeys.RFC7515_ES256, "ES256", "SHA256withECDSA"));
        HELPER_FACTORIES = Collections.unmodifiableMap(helperFactories);
    }

    public static final class OAuthResolveExBuilder {
        private final OAuthResolveExFW.Builder resolveExRW;

        private OAuthResolveExBuilder() {
            UnsafeBuffer writeExBuffer = new UnsafeBuffer(new byte[8192]);
            this.resolveExRW = new OAuthResolveExFW.Builder().wrap((MutableDirectBuffer)writeExBuffer, 0, writeExBuffer.capacity());
        }

        public OAuthResolveExBuilder issuer(String issuerName) {
            this.resolveExRW.issuer(issuerName);
            return this;
        }

        public OAuthResolveExBuilder audience(String audienceName) {
            this.resolveExRW.audience(audienceName);
            return this;
        }

        public byte[] build() {
            OAuthResolveExFW resolveEx = this.resolveExRW.build();
            byte[] array = new byte[resolveEx.sizeof()];
            resolveEx.buffer().getBytes(resolveEx.offset(), array);
            return array;
        }
    }

    public static final class JwtHelper {
        private final KeyPair keyPair;
        private final String kind;
        private final String algorithm;
        private final List<String> claims;

        private JwtHelper(KeyPair keyPair, String kind, String algorithm) {
            this.keyPair = keyPair;
            this.kind = kind;
            this.algorithm = algorithm;
            this.claims = new ArrayList<String>();
        }

        public JwtHelper expiresInSeconds(int seconds) {
            long expiry = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()) + (long)seconds;
            return this.claim("exp", expiry);
        }

        public JwtHelper claim(String name, Object ... values) {
            if (values != null) {
                if (values.length == 1) {
                    Object value = values[0];
                    String format = value instanceof String ? "\"%s\":\"%s\"" : "\"%s\":%d";
                    this.claims.add(String.format(format, name, value));
                } else {
                    StringBuilder claim = new StringBuilder();
                    claim.append(String.format("\"%s\":[", name));
                    for (int i = 0; i < values.length; ++i) {
                        Object value;
                        if (i > 0) {
                            claim.append(',');
                        }
                        String format = (value = values[i]) instanceof String ? "\"%s\"" : ":%d";
                        claim.append(String.format(format, value));
                    }
                    claim.append(']');
                    this.claims.add(claim.toString());
                }
            }
            return this;
        }

        public String sign() throws GeneralSecurityException {
            String header = String.format("{\"kid\":\"%s\",\"alg\":\"%s\"}", this.kind, this.kind);
            String payload = this.claims.stream().collect(Collectors.joining(",", "{", "}"));
            Base64.Encoder base64 = Base64.getUrlEncoder().withoutPadding();
            String header64 = new String(base64.encode(header.getBytes(StandardCharsets.UTF_8)), StandardCharsets.US_ASCII);
            String payload64 = new String(base64.encode(payload.getBytes(StandardCharsets.UTF_8)), StandardCharsets.US_ASCII);
            String securedInput = String.format("%s.%s", header64, payload64);
            JwtSigner signer = JwtSigner.getInstance(this.algorithm);
            signer.initSign(this.keyPair.getPrivate());
            signer.update(securedInput.getBytes(StandardCharsets.US_ASCII));
            byte[] integrity = signer.sign();
            String integrity64 = new String(base64.encode(integrity), StandardCharsets.US_ASCII);
            return String.format("%s.%s", securedInput, integrity64);
        }
    }

    private static final class JwtSigner {
        private static final Map<String, JwtSigner> SIGNERS = new ConcurrentHashMap<String, JwtSigner>();
        private final Signature signature;
        private final UnaryOperator<byte[]> decoder;

        public static JwtSigner getInstance(String algorithm) {
            return SIGNERS.computeIfAbsent(algorithm, JwtSigner::newSigner);
        }

        public void initSign(PrivateKey privateKey) throws InvalidKeyException {
            this.signature.initSign(privateKey);
        }

        public void update(byte[] data) throws SignatureException {
            this.signature.update(data);
        }

        public byte[] sign() throws SignatureException {
            return (byte[])this.decoder.apply(this.signature.sign());
        }

        static byte[] decodeDER(byte[] integrity) {
            DERDecoder decoder = new DERDecoder();
            ASN1Sequence sequence0 = new ASN1Sequence.Parser((ASN1Decoder)decoder).parse(ASN1Tag.SEQUENCE, integrity);
            ASN1Sequence sequence1 = (ASN1Sequence)sequence0.get(0);
            ASN1Integer element0 = (ASN1Integer)sequence1.get(0);
            ASN1Integer element1 = (ASN1Integer)sequence1.get(1);
            byte[] r = element0.getValue().toByteArray();
            byte[] s = element1.getValue().toByteArray();
            int offsetR = r.length & 1;
            int lengthR = r.length - offsetR;
            int offsetS = s.length & 1;
            int lengthS = s.length - offsetS;
            assert (offsetR == 0 ^ r[0] == 0);
            assert (offsetS == 0 ^ s[0] == 0);
            byte[] rawIntegrity = new byte[lengthR + lengthS];
            System.arraycopy(r, offsetR, rawIntegrity, 0, lengthR);
            System.arraycopy(s, offsetS, rawIntegrity, lengthR, lengthS);
            return rawIntegrity;
        }

        private JwtSigner(Signature signature, UnaryOperator<byte[]> decoder) {
            this.signature = signature;
            this.decoder = decoder;
        }

        private static JwtSigner newSigner(String algorithm) {
            UnaryOperator<byte[]> decoder = algorithm.endsWith("withECDSA") ? JwtSigner::decodeDER : UnaryOperator.identity();
            JwtSigner newSigner = null;
            try {
                Signature signature = Signature.getInstance(algorithm);
                newSigner = new JwtSigner(signature, decoder);
            }
            catch (NoSuchAlgorithmException ex) {
                LangUtil.rethrowUnchecked((Throwable)ex);
            }
            return newSigner;
        }
    }

    public static class Mapper
    extends FunctionMapperSpi.Reflective {
        public Mapper() {
            super(OAuthFunctions.class);
        }

        public String getPrefixName() {
            return "oauth";
        }
    }
}

