/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.nukleus.oauth.internal;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public final class OAuthJwtKeys {
    public static final KeyPair RFC7515_RS256;
    public static final KeyPair RFC7515_ES256;

    private static KeyPair initRSAKeyPair(Map<String, String> params) throws GeneralSecurityException {
        Base64.Decoder base64 = Base64.getUrlDecoder();
        BigInteger n = new BigInteger(1, base64.decode(params.get("n")));
        BigInteger e = new BigInteger(1, base64.decode(params.get("e")));
        BigInteger d = new BigInteger(1, base64.decode(params.get("d")));
        BigInteger p = new BigInteger(1, base64.decode(params.get("p")));
        BigInteger q = new BigInteger(1, base64.decode(params.get("q")));
        BigInteger dp = new BigInteger(1, base64.decode(params.get("dp")));
        BigInteger dq = new BigInteger(1, base64.decode(params.get("dq")));
        BigInteger qi = new BigInteger(1, base64.decode(params.get("qi")));
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(n, e);
        RSAPrivateCrtKeySpec privateKeySpec = new RSAPrivateCrtKeySpec(n, e, d, p, q, dp, dq, qi);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
        PrivateKey privateKey = keyFactory.generatePrivate(privateKeySpec);
        return new KeyPair(publicKey, privateKey);
    }

    private static KeyPair initECKeyPair(Map<String, String> params) throws GeneralSecurityException {
        Base64.Decoder base64 = Base64.getUrlDecoder();
        String crv = params.get("crv");
        BigInteger x = new BigInteger(1, base64.decode(params.get("x")));
        BigInteger y = new BigInteger(1, base64.decode(params.get("y")));
        BigInteger d = new BigInteger(1, base64.decode(params.get("d")));
        AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
        parameters.init(new ECGenParameterSpec(String.format("NIST %s", crv)));
        ECParameterSpec curve = parameters.getParameterSpec(ECParameterSpec.class);
        ECPublicKeySpec publicKeySpec = new ECPublicKeySpec(new ECPoint(x, y), curve);
        ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(d, curve);
        KeyFactory keyFactory = KeyFactory.getInstance("EC");
        PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
        PrivateKey privateKey = keyFactory.generatePrivate(privateKeySpec);
        return new KeyPair(publicKey, privateKey);
    }

    private OAuthJwtKeys() {
    }

    static {
        HashMap<String, String> rsa256 = new HashMap<String, String>();
        rsa256.put("kty", "RSA");
        rsa256.put("n", "ofgWCuLjybRlzo0tZWJjNiuSfb4p4fAkd_wWJcyQoTbji9k0l8W26mPddxHmfHQp-Vaw-4qPCJrcS2mJPMEzP1Pt0Bm4d4QlL-yRT-SFd2lZS-pCgNMsD1W_YpRPEwOWvG6b32690r2jZ47soMZo9wGzjb_7OMg0LOL-bSf63kpaSHSXndS5z5rexMdbBYUsLA9e-KXBdQOS-UTo7WTBEMa2R2CapHg665xsmtdVMTBQY4uDZlxvb3qCo5ZwKh9kG4LT6_I5IhlJH7aGhyxXFvUK-DWNmoudF8NAco9_h9iaGNj8q2ethFkMLs91kzk2PAcDTW9gb54h4FRWyuXpoQ");
        rsa256.put("e", "AQAB");
        rsa256.put("d", "Eq5xpGnNCivDflJsRQBXHx1hdR1k6Ulwe2JZD50LpXyWPEAeP88vLNO97IjlA7_GQ5sLKMgvfTeXZx9SE-7YwVol2NXOoAJe46sui395IW_GO-pWJ1O0BkTGoVEn2bKVRUCgu-GjBVaYLU6f3l9kJfFNS3E0QbVdxzubSu3Mkqzjkn439X0M_V51gfpRLI9JYanrC4D4qAdGcopV_0ZHHzQlBjudU2QvXt4ehNYTCBr6XCLQUShb1juUO1ZdiYoFaFQT5Tw8bGUl_x_jTj3ccPDVZFD9pIuhLhBOneufuBiB4cS98l2SR_RQyGWSeWjnczT0QU91p1DhOVRuOopznQ");
        rsa256.put("p", "4BzEEOtIpmVdVEZNCqS7baC4crd0pqnRH_5IB3jw3bcxGn6QLvnEtfdUdiYrqBdss1l58BQ3KhooKeQTa9AB0Hw_Py5PJdTJNPY8cQn7ouZ2KKDcmnPGBY5t7yLc1QlQ5xHdwW1VhvKn-nXqhJTBgIPgtldC-KDV5z-y2XDwGUc");
        rsa256.put("q", "uQPEfgmVtjL0Uyyx88GZFF1fOunH3-7cepKmtH4pxhtCoHqpWmT8YAmZxaewHgHAjLYsp1ZSe7zFYHj7C6ul7TjeLQeZD_YwD66t62wDmpe_HlB-TnBA-njbglfIsRLtXlnDzQkv5dTltRJ11BKBBypeeF6689rjcJIDEz9RWdc");
        rsa256.put("dp", "BwKfV3Akq5_MFZDFZCnW-wzl-CCo83WoZvnLQwCTeDv8uzluRSnm71I3QCLdhrqE2e9YkxvuxdBfpT_PI7Yz-FOKnu1R6HsJeDCjn12Sk3vmAktV2zb34MCdy7cpdTh_YVr7tss2u6vneTwrA86rZtu5Mbr1C1XsmvkxHQAdYo0");
        rsa256.put("dq", "h_96-mK1R_7glhsum81dZxjTnYynPbZpHziZjeeHcXYsXaaMwkOlODsWa7I9xXDoRwbKgB719rrmI2oKr6N3Do9U0ajaHF-NKJnwgjMd2w9cjz3_-kyNlxAr2v4IKhGNpmM5iIgOS1VZnOZ68m6_pbLBSp3nssTdlqvd0tIiTHU");
        rsa256.put("qi", "IYd7DHOhrWvxkwPQsRM2tOgrjbcrfvtQJipd-DlcxyVuuM9sQLdgjVk2oy26F0EmpScGLq2MowX7fhd_QJQ3ydy5cY7YIBi87w93IKLEdfnbJtoOPLUW0ITrJReOgo1cq9SbsxYawBgfp_gh6A5603k2-ZQwVK0JKSHuLFkuQ3U");
        HashMap<String, String> es256 = new HashMap<String, String>();
        es256.put("kty", "EC");
        es256.put("crv", "P-256");
        es256.put("x", "f83OJ3D2xF1Bg8vub9tLe1gHMzV76e8Tus9uPHvRVEU");
        es256.put("y", "x_FEzRu9m36HLN_tue659LNpXW6pCyStikYjKIWI5a0");
        es256.put("d", "jpsQnnGQmL-YBIffH1136cspYG6-0iY7X1fCE9-E9LI");
        try {
            RFC7515_RS256 = OAuthJwtKeys.initRSAKeyPair(rsa256);
            RFC7515_ES256 = OAuthJwtKeys.initECKeyPair(es256);
        }
        catch (GeneralSecurityException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

