/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.oauth.internal.types;

import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.specification.oauth.internal.types.Flyweight;
import org.reaktivity.specification.oauth.internal.types.StringFW;

public final class String32FW
extends StringFW {
    private static final int FIELD_SIZE_LENGTH = 4;
    private final ByteOrder byteOrder;
    private final DirectBuffer valueRO = new UnsafeBuffer(0L, 0);

    public String32FW() {
        this.byteOrder = ByteOrder.nativeOrder();
    }

    public String32FW(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public String32FW(String value) {
        this(value, StandardCharsets.UTF_8);
    }

    public String32FW(String value, ByteOrder byteOrder) {
        this(value, StandardCharsets.UTF_8, byteOrder);
    }

    public String32FW(String value, Charset charset) {
        this(value, StandardCharsets.UTF_8, ByteOrder.nativeOrder());
    }

    public String32FW(String value, Charset charset, ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
        if (value != null) {
            byte[] encoded = value.getBytes(charset);
            UnsafeBuffer buffer = new UnsafeBuffer(new byte[4 + Math.max(encoded.length, 1)]);
            buffer.putInt(0, encoded.length, byteOrder);
            buffer.putBytes(4, encoded);
            this.wrap((DirectBuffer)buffer, 0, buffer.capacity());
        } else {
            UnsafeBuffer buffer = new UnsafeBuffer(new byte[5]);
            buffer.putInt(0, -1);
            this.wrap((DirectBuffer)buffer, 0, buffer.capacity());
        }
    }

    @Override
    public int fieldSizeLength() {
        return 4;
    }

    @Override
    public int limit() {
        return this.offset() + 4 + Math.max(this.length(), 0);
    }

    public DirectBuffer value() {
        return this.length() == -1 ? null : this.valueRO;
    }

    @Override
    public String asString() {
        if (this.maxLimit() == this.offset() || this.length() == -1) {
            return null;
        }
        return this.buffer().getStringWithoutLengthUtf8(this.offset() + 4, this.length());
    }

    @Override
    public String32FW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit) || offset + 4 > this.maxLimit() || this.limit() > maxLimit) {
            return null;
        }
        int length = this.length();
        if (length != -1) {
            this.valueRO.wrap(buffer, offset + 4, length);
        }
        return this;
    }

    @Override
    public String32FW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        String32FW.checkLimit(offset + 4, maxLimit);
        String32FW.checkLimit(this.limit(), maxLimit);
        int length = this.length();
        if (length != -1) {
            this.valueRO.wrap(buffer, offset + 4, length);
        }
        return this;
    }

    public String toString() {
        return this.maxLimit() == this.offset() ? "null" : String.format("\"%s\"", this.asString());
    }

    @Override
    public int length() {
        int length = this.buffer().getInt(this.offset(), this.byteOrder) & 0xFFFFFFFF;
        return length < 0 ? -1 : length;
    }

    public static final class Builder
    extends StringFW.Builder<String32FW> {
        private final ByteOrder byteOrder;
        private boolean valueSet;

        public Builder() {
            super(new String32FW());
            this.byteOrder = ByteOrder.nativeOrder();
        }

        public Builder(ByteOrder byteOrder) {
            super(new String32FW(byteOrder));
            this.byteOrder = byteOrder;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            Flyweight.checkLimit(offset + 4, maxLimit);
            super.wrap(buffer, offset, maxLimit);
            this.valueSet = false;
            return this;
        }

        public Builder set(StringFW value) {
            if (value.length() == -1) {
                int newLimit = this.offset() + 4;
                Flyweight.checkLimit(newLimit, this.maxLimit());
                this.buffer().putInt(this.offset(), -1, this.byteOrder);
                this.limit(newLimit);
            } else {
                int newLimit = this.offset() + 4 + value.length();
                Flyweight.checkLimit(newLimit, this.maxLimit());
                this.buffer().putInt(this.offset(), value.length(), this.byteOrder);
                this.buffer().putBytes(this.offset() + 4, value.buffer(), value.offset() + value.fieldSizeLength(), value.length());
                this.limit(newLimit);
            }
            this.valueSet = true;
            return this;
        }

        public Builder set(DirectBuffer srcBuffer, int srcOffset, int length) {
            Builder.checkLength(length);
            int offset = this.offset();
            int newLimit = offset + length + 4;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(offset, length, this.byteOrder);
            this.buffer().putBytes(offset + 4, srcBuffer, srcOffset, length);
            this.limit(newLimit);
            this.valueSet = true;
            return this;
        }

        public Builder set(String value, Charset charset) {
            if (value == null) {
                int newLimit = this.offset() + 4;
                Flyweight.checkLimit(newLimit, this.maxLimit());
                this.buffer().putInt(this.offset(), -1, this.byteOrder);
                this.limit(newLimit);
            } else {
                byte[] charBytes = value.getBytes(charset);
                Builder.checkLength(charBytes.length);
                int newLimit = this.offset() + 4 + charBytes.length;
                Flyweight.checkLimit(newLimit, this.maxLimit());
                this.buffer().putInt(this.offset(), charBytes.length, this.byteOrder);
                this.buffer().putBytes(this.offset() + 4, charBytes);
                this.limit(newLimit);
            }
            this.valueSet = true;
            return this;
        }

        private static void checkLength(int length) {
            int maxLength = 0x7FFFFFFE;
            if (length > 0x7FFFFFFE) {
                String msg = String.format("length=%d is beyond maximum length=%d", length, 0x7FFFFFFE);
                throw new IllegalArgumentException(msg);
            }
        }

        @Override
        public String32FW build() {
            if (!this.valueSet) {
                this.set(null, StandardCharsets.UTF_8);
            }
            return (String32FW)super.build();
        }
    }
}

