/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.oauth.internal.types;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.oauth.internal.types.Flyweight;

public final class Varbyteuint32FW
extends Flyweight {
    private int size;

    @Override
    public int limit() {
        return this.offset() + this.size;
    }

    public int value() {
        byte b;
        DirectBuffer buffer = this.buffer();
        int offset = this.offset();
        int limit = this.limit();
        int value = 0;
        int index = 0;
        int multiplier = 1;
        do {
            b = buffer.getByte(offset + index);
            value += (b & 0x7F) * multiplier;
            multiplier *= 128;
        } while (offset + ++index < limit && (b & 0x80) != 0);
        return value;
    }

    @Override
    public Varbyteuint32FW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit) || maxLimit - offset < 1) {
            return null;
        }
        this.size = this.length0();
        if (this.size < 0 || this.size > 5 || this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public Varbyteuint32FW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        Varbyteuint32FW.checkLimit(offset + 1, maxLimit);
        this.size = this.length0();
        if (this.size < 0 || this.size > 5) {
            throw new IllegalArgumentException(String.format("varbyteuint32 value at offset %d exceeds 32 bits", offset));
        }
        Varbyteuint32FW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    public String toString() {
        return Integer.toString(this.value());
    }

    private int length0() {
        DirectBuffer buffer = this.buffer();
        int offset = this.offset();
        int maxPos = Math.min(offset + 5, this.maxLimit());
        int index = 0;
        while (index + offset < maxPos && (buffer.getByte(index + offset) & 0x80) != 0) {
            ++index;
        }
        int size = 1 + index;
        return size;
    }

    public static final class Builder
    extends Flyweight.Builder<Varbyteuint32FW> {
        private boolean valueSet;

        public Builder() {
            super(new Varbyteuint32FW());
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            Flyweight.checkLimit(offset + 1, maxLimit);
            super.wrap(buffer, offset, maxLimit);
            this.valueSet = false;
            return this;
        }

        public Builder set(int value) {
            if (value > 0xFFFFFFF) {
                throw new IllegalArgumentException(String.format("Input value %d too long", value));
            }
            MutableDirectBuffer buffer = this.buffer();
            int progress = this.offset();
            int varint = 0;
            int i = 0;
            do {
                int encodedByte = value % 128;
                if ((value /= 128) > 0) {
                    encodedByte |= 0x80;
                }
                varint |= ((varint & 0x80) > 0 ? encodedByte << 8 * i : encodedByte) | varint;
                buffer.putByte(progress++, (byte)(encodedByte & 0xFF));
                ++i;
            } while (value > 0);
            int newLimit = progress;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.limit(newLimit);
            this.valueSet = true;
            return this;
        }

        @Override
        public Varbyteuint32FW build() {
            if (!this.valueSet) {
                throw new IllegalArgumentException("value not set");
            }
            return (Varbyteuint32FW)super.build();
        }
    }
}

