/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.oauth.internal.types.control;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.oauth.internal.types.Array32FW;
import org.reaktivity.specification.oauth.internal.types.ArrayFW;
import org.reaktivity.specification.oauth.internal.types.Flyweight;
import org.reaktivity.specification.oauth.internal.types.HttpHeaderFW;

public final class HttpRouteExFW
extends Flyweight {
    public static final int FIELD_OFFSET_HEADERS = 0;
    public static final int FIELD_OFFSET_OVERRIDES = 0;
    private final Array32FW<HttpHeaderFW> headersRO = new Array32FW<HttpHeaderFW>(new HttpHeaderFW());
    private final Array32FW<HttpHeaderFW> overridesRO = new Array32FW<HttpHeaderFW>(new HttpHeaderFW());

    public Array32FW<HttpHeaderFW> headers() {
        return this.headersRO;
    }

    public Array32FW<HttpHeaderFW> overrides() {
        return this.overridesRO;
    }

    @Override
    public HttpRouteExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.headersRO.wrap(buffer, offset + 0, maxLimit);
        this.overridesRO.wrap(buffer, this.headersRO.limit() + 0, maxLimit);
        HttpRouteExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public HttpRouteExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.headersRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        if (null == this.overridesRO.tryWrap(buffer, this.headersRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.overridesRO.limit();
    }

    public String toString() {
        return String.format("HTTP_ROUTE_EX [headers=%s, overrides=%s]", this.headers(), this.overrides());
    }

    public static final class Builder
    extends Flyweight.Builder<HttpRouteExFW> {
        private static final int INDEX_HEADERS = 0;
        private static final int INDEX_OVERRIDES = 1;
        private static final int FIELD_COUNT = 2;
        private final Array32FW.Builder<HttpHeaderFW.Builder, HttpHeaderFW> headersRW = new Array32FW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>(new HttpHeaderFW.Builder(), new HttpHeaderFW());
        private final Array32FW.Builder<HttpHeaderFW.Builder, HttpHeaderFW> overridesRW = new Array32FW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>(new HttpHeaderFW.Builder(), new HttpHeaderFW());
        private int lastFieldSet = -1;

        public Builder() {
            super(new HttpRouteExFW());
        }

        public Builder headers(Consumer<Array32FW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>> mutator) {
            assert (this.lastFieldSet == -1);
            Flyweight.Builder headersRW = this.headersRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept((Array32FW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>)headersRW);
            this.limit(((Array32FW)((Array32FW.Builder)headersRW).build()).limit());
            this.lastFieldSet = 0;
            return this;
        }

        public Builder headers(Array32FW<HttpHeaderFW> field) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + field.sizeof();
            HttpRouteExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        public Builder headersItem(Consumer<HttpHeaderFW.Builder> mutator) {
            assert (this.lastFieldSet >= -1);
            if (this.lastFieldSet < 0) {
                this.headersRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            }
            this.headersRW.item((Consumer)mutator);
            this.limit(((Array32FW)this.headersRW.build()).limit());
            this.lastFieldSet = 0;
            return this;
        }

        public Builder overrides(Consumer<Array32FW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>> mutator) {
            if (this.lastFieldSet < 0) {
                this.headers((Array32FW.Builder<HttpHeaderFW.Builder, HttpHeaderFW> b) -> {});
            }
            assert (this.lastFieldSet == 0);
            Flyweight.Builder overridesRW = this.overridesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept((Array32FW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>)overridesRW);
            this.limit(((Array32FW)((Array32FW.Builder)overridesRW).build()).limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder overrides(Array32FW<HttpHeaderFW> field) {
            if (this.lastFieldSet < 0) {
                this.headers((Array32FW.Builder<HttpHeaderFW.Builder, HttpHeaderFW> b) -> {});
            }
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + field.sizeof();
            HttpRouteExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder overridesItem(Consumer<HttpHeaderFW.Builder> mutator) {
            if (this.lastFieldSet < 0) {
                this.headers((Array32FW.Builder<HttpHeaderFW.Builder, HttpHeaderFW> b) -> {});
            }
            assert (this.lastFieldSet >= 0);
            if (this.lastFieldSet < 1) {
                this.overridesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            }
            this.overridesRW.item((Consumer)mutator);
            this.limit(((Array32FW)this.overridesRW.build()).limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public HttpRouteExFW build() {
            if (this.lastFieldSet < 1) {
                this.overrides((Array32FW.Builder<HttpHeaderFW.Builder, HttpHeaderFW> b) -> {});
            }
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (HttpRouteExFW)super.build();
        }
    }
}

