/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.oauth.internal.types.control;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.oauth.internal.types.Array32FW;
import org.reaktivity.specification.oauth.internal.types.ArrayFW;
import org.reaktivity.specification.oauth.internal.types.Flyweight;
import org.reaktivity.specification.oauth.internal.types.OctetsFW;
import org.reaktivity.specification.oauth.internal.types.String8FW;

public final class ResolveFW
extends Flyweight {
    public static final int FIELD_OFFSET_CORRELATION_ID = 0;
    private static final int FIELD_SIZE_CORRELATION_ID = 8;
    public static final int FIELD_OFFSET_NUKLEUS = 8;
    public static final int FIELD_OFFSET_REALM = 0;
    public static final int FIELD_OFFSET_ROLES = 0;
    public static final int FIELD_OFFSET_EXTENSION = 0;
    public static final int TYPE_ID = 17;
    private final String8FW nukleusRO = new String8FW();
    private final String8FW realmRO = new String8FW();
    private final Array32FW<String8FW> rolesRO = new Array32FW<String8FW>(new String8FW());
    private final OctetsFW extensionRO = new OctetsFW();

    public long correlationId() {
        return this.buffer().getLong(this.offset() + 0);
    }

    public String8FW nukleus() {
        return this.nukleusRO;
    }

    public String8FW realm() {
        return this.realmRO;
    }

    public Array32FW<String8FW> roles() {
        return this.rolesRO;
    }

    public OctetsFW extension() {
        return this.extensionRO;
    }

    public int typeId() {
        return 17;
    }

    @Override
    public ResolveFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.nukleusRO.wrap(buffer, offset + 8, maxLimit);
        this.realmRO.wrap(buffer, this.nukleusRO.limit() + 0, maxLimit);
        this.rolesRO.wrap(buffer, this.realmRO.limit() + 0, maxLimit);
        this.extensionRO.wrap(buffer, this.rolesRO.limit() + 0, maxLimit);
        ResolveFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public ResolveFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.nukleusRO.tryWrap(buffer, offset + 8, maxLimit)) {
            return null;
        }
        if (null == this.realmRO.tryWrap(buffer, this.nukleusRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.rolesRO.tryWrap(buffer, this.realmRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.extensionRO.tryWrap(buffer, this.rolesRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.extensionRO.limit();
    }

    public String toString() {
        return String.format("RESOLVE [correlationId=%d, nukleus=%s, realm=%s, roles=%s, extension=%s]", this.correlationId(), this.nukleusRO.asString(), this.realmRO.asString(), this.roles(), this.extension());
    }

    public static final class Builder
    extends Flyweight.Builder<ResolveFW> {
        private static final int INDEX_CORRELATION_ID = 0;
        private static final int INDEX_NUKLEUS = 1;
        private static final int INDEX_REALM = 2;
        private static final int INDEX_ROLES = 3;
        private static final int INDEX_EXTENSION = 4;
        private static final int FIELD_COUNT = 5;
        private final String8FW.Builder nukleusRW = new String8FW.Builder();
        private final String8FW.Builder realmRW = new String8FW.Builder();
        private final Array32FW.Builder<String8FW.Builder, String8FW> rolesRW = new Array32FW.Builder<String8FW.Builder, String8FW>(new String8FW.Builder(), new String8FW());
        private final OctetsFW.Builder extensionRW = new OctetsFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new ResolveFW());
        }

        public Builder correlationId(long value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 8;
            ResolveFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        private String8FW.Builder nukleus() {
            assert (this.lastFieldSet == 0);
            return this.nukleusRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder nukleus(String value) {
            String8FW.Builder nukleusRW = this.nukleus();
            nukleusRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 1;
            this.limit(nukleusRW.build().limit());
            return this;
        }

        public Builder nukleus(String8FW value) {
            String8FW.Builder nukleusRW = this.nukleus();
            nukleusRW.set((Flyweight)value);
            this.lastFieldSet = 1;
            this.limit(nukleusRW.build().limit());
            return this;
        }

        public Builder nukleus(DirectBuffer buffer, int offset, int length) {
            String8FW.Builder nukleusRW = this.nukleus();
            nukleusRW.set(buffer, offset, length);
            this.lastFieldSet = 1;
            this.limit(nukleusRW.build().limit());
            return this;
        }

        private String8FW.Builder realm() {
            assert (this.lastFieldSet == 1);
            return this.realmRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder realm(String value) {
            String8FW.Builder realmRW = this.realm();
            realmRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 2;
            this.limit(realmRW.build().limit());
            return this;
        }

        public Builder realm(String8FW value) {
            String8FW.Builder realmRW = this.realm();
            realmRW.set((Flyweight)value);
            this.lastFieldSet = 2;
            this.limit(realmRW.build().limit());
            return this;
        }

        public Builder realm(DirectBuffer buffer, int offset, int length) {
            String8FW.Builder realmRW = this.realm();
            realmRW.set(buffer, offset, length);
            this.lastFieldSet = 2;
            this.limit(realmRW.build().limit());
            return this;
        }

        public Builder roles(Consumer<Array32FW.Builder<String8FW.Builder, String8FW>> mutator) {
            assert (this.lastFieldSet == 2);
            Flyweight.Builder rolesRW = this.rolesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept((Array32FW.Builder<String8FW.Builder, String8FW>)rolesRW);
            this.limit(((Array32FW)((Array32FW.Builder)rolesRW).build()).limit());
            this.lastFieldSet = 3;
            return this;
        }

        public Builder roles(Array32FW<String8FW> field) {
            assert (this.lastFieldSet == 2);
            int newLimit = this.limit() + field.sizeof();
            ResolveFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 3;
            return this;
        }

        public Builder rolesItem(Consumer<String8FW.Builder> mutator) {
            assert (this.lastFieldSet >= 2);
            if (this.lastFieldSet < 3) {
                this.rolesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            }
            this.rolesRW.item((Consumer)mutator);
            this.limit(((Array32FW)this.rolesRW.build()).limit());
            this.lastFieldSet = 3;
            return this;
        }

        private OctetsFW.Builder extension() {
            if (this.lastFieldSet < 3) {
                this.roles((Array32FW.Builder<String8FW.Builder, String8FW> b) -> {});
            }
            assert (this.lastFieldSet == 3);
            return this.extensionRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder extension(OctetsFW value) {
            OctetsFW.Builder extensionRW = this.extension();
            extensionRW.set(value);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.lastFieldSet = 4;
            return this;
        }

        public Builder extension(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder extensionRW = this.extension();
            mutator.accept(extensionRW);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.lastFieldSet = 4;
            return this;
        }

        public Builder extension(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder extensionRW = this.extension();
            extensionRW.set(buffer, offset, length);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.lastFieldSet = 4;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public ResolveFW build() {
            if (this.lastFieldSet < 4) {
                this.extension((OctetsFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 4);
            this.lastFieldSet = -1;
            return (ResolveFW)super.build();
        }
    }
}

