/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.nukleus.proxy.internal;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Predicate;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.MutableInteger;
import org.agrona.concurrent.UnsafeBuffer;
import org.kaazing.k3po.lang.el.BytesMatcher;
import org.kaazing.k3po.lang.el.Function;
import org.kaazing.k3po.lang.el.spi.FunctionMapperSpi;
import org.reaktivity.specification.nukleus.proxy.internal.types.Array32FW;
import org.reaktivity.specification.nukleus.proxy.internal.types.OctetsFW;
import org.reaktivity.specification.nukleus.proxy.internal.types.ProxyAddressFW;
import org.reaktivity.specification.nukleus.proxy.internal.types.ProxyAddressFamily;
import org.reaktivity.specification.nukleus.proxy.internal.types.ProxyAddressInet4FW;
import org.reaktivity.specification.nukleus.proxy.internal.types.ProxyAddressInet6FW;
import org.reaktivity.specification.nukleus.proxy.internal.types.ProxyAddressInetFW;
import org.reaktivity.specification.nukleus.proxy.internal.types.ProxyAddressNoneFW;
import org.reaktivity.specification.nukleus.proxy.internal.types.ProxyAddressProtocol;
import org.reaktivity.specification.nukleus.proxy.internal.types.ProxyAddressProtocolFW;
import org.reaktivity.specification.nukleus.proxy.internal.types.ProxyAddressUnixFW;
import org.reaktivity.specification.nukleus.proxy.internal.types.ProxyInfoFW;
import org.reaktivity.specification.nukleus.proxy.internal.types.ProxyInfoType;
import org.reaktivity.specification.nukleus.proxy.internal.types.ProxySecureInfoFW;
import org.reaktivity.specification.nukleus.proxy.internal.types.ProxySecureInfoType;
import org.reaktivity.specification.nukleus.proxy.internal.types.String16FW;
import org.reaktivity.specification.nukleus.proxy.internal.types.String8FW;
import org.reaktivity.specification.nukleus.proxy.internal.types.stream.ProxyBeginExFW;

public final class ProxyFunctions {
    @Function
    public static ProxyBeginExBuilder beginEx() {
        return new ProxyBeginExBuilder();
    }

    @Function
    public static ProxyBeginExMatcherBuilder matchBeginEx() {
        return new ProxyBeginExMatcherBuilder();
    }

    private ProxyFunctions() {
    }

    public static final class ProxyBeginExBuilder {
        private final ProxyBeginExFW.Builder beginExRW;

        private ProxyBeginExBuilder() {
            UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[8192]);
            this.beginExRW = new ProxyBeginExFW.Builder().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity());
        }

        public ProxyBeginExBuilder typeId(int typeId) {
            this.beginExRW.typeId(typeId);
            return this;
        }

        public ProxyAddressInetBuilder addressInet() {
            return new ProxyAddressInetBuilder();
        }

        public ProxyAddressInet4Builder addressInet4() {
            return new ProxyAddressInet4Builder();
        }

        public ProxyAddressInet6Builder addressInet6() {
            return new ProxyAddressInet6Builder();
        }

        public ProxyAddressUnixBuilder addressUnix() {
            return new ProxyAddressUnixBuilder();
        }

        public ProxyAddressNoneBuilder addressNone() {
            return new ProxyAddressNoneBuilder();
        }

        public ProxyInfoBuilder info() {
            return new ProxyInfoBuilder();
        }

        public byte[] build() {
            ProxyBeginExFW beginEx = this.beginExRW.build();
            byte[] array = new byte[beginEx.sizeof()];
            beginEx.buffer().getBytes(beginEx.offset(), array);
            return array;
        }

        public final class ProxyAddressInetBuilder {
            private final ProxyAddressFW.Builder addressRW = new ProxyAddressFW.Builder();
            private final ProxyAddressInetFW.Builder addressInetRW = new ProxyAddressInetFW.Builder();

            private ProxyAddressInetBuilder() {
                UnsafeBuffer buffer = new UnsafeBuffer(new byte[128]);
                this.addressRW.wrap((MutableDirectBuffer)buffer, 0, buffer.capacity());
                this.addressInetRW.wrap((MutableDirectBuffer)buffer, 1, buffer.capacity());
            }

            public ProxyAddressInetBuilder protocol(String protocol) {
                this.addressInetRW.protocol((ProxyAddressProtocolFW.Builder p) -> p.set(ProxyAddressProtocol.valueOf(protocol.toUpperCase())));
                return this;
            }

            public ProxyAddressInetBuilder source(String source) throws UnknownHostException {
                this.addressInetRW.source(source);
                return this;
            }

            public ProxyAddressInetBuilder destination(String destination) throws UnknownHostException {
                this.addressInetRW.destination(destination);
                return this;
            }

            public ProxyAddressInetBuilder sourcePort(int sourcePort) {
                this.addressInetRW.sourcePort(sourcePort);
                return this;
            }

            public ProxyAddressInetBuilder destinationPort(int destinationPort) {
                this.addressInetRW.destinationPort(destinationPort);
                return this;
            }

            public ProxyBeginExBuilder build() {
                ProxyBeginExBuilder.this.beginExRW.address((ProxyAddressFW)this.addressRW.inet(this.addressInetRW.build()).build());
                return ProxyBeginExBuilder.this;
            }
        }

        public final class ProxyAddressInet4Builder {
            private final ProxyAddressFW.Builder addressRW = new ProxyAddressFW.Builder();
            private final ProxyAddressInet4FW.Builder addressInet4RW = new ProxyAddressInet4FW.Builder();

            private ProxyAddressInet4Builder() {
                UnsafeBuffer buffer = new UnsafeBuffer(new byte[14]);
                this.addressRW.wrap((MutableDirectBuffer)buffer, 0, buffer.capacity());
                this.addressInet4RW.wrap((MutableDirectBuffer)buffer, 1, buffer.capacity());
            }

            public ProxyAddressInet4Builder protocol(String protocol) {
                this.addressInet4RW.protocol((ProxyAddressProtocolFW.Builder p) -> p.set(ProxyAddressProtocol.valueOf(protocol.toUpperCase())));
                return this;
            }

            public ProxyAddressInet4Builder source(String source) throws UnknownHostException {
                InetAddress inet = InetAddress.getByName(source);
                byte[] ip = inet.getAddress();
                this.addressInet4RW.source((OctetsFW.Builder s) -> s.set(ip));
                return this;
            }

            public ProxyAddressInet4Builder destination(String destination) throws UnknownHostException {
                InetAddress inet = InetAddress.getByName(destination);
                byte[] ip = inet.getAddress();
                this.addressInet4RW.destination((OctetsFW.Builder d) -> d.set(ip));
                return this;
            }

            public ProxyAddressInet4Builder sourcePort(int sourcePort) {
                this.addressInet4RW.sourcePort(sourcePort);
                return this;
            }

            public ProxyAddressInet4Builder destinationPort(int destinationPort) {
                this.addressInet4RW.destinationPort(destinationPort);
                return this;
            }

            public ProxyBeginExBuilder build() {
                ProxyBeginExBuilder.this.beginExRW.address((ProxyAddressFW)this.addressRW.inet4(this.addressInet4RW.build()).build());
                return ProxyBeginExBuilder.this;
            }
        }

        public final class ProxyAddressInet6Builder {
            private final ProxyAddressFW.Builder addressRW = new ProxyAddressFW.Builder();
            private final ProxyAddressInet6FW.Builder addressInet6RW = new ProxyAddressInet6FW.Builder();

            private ProxyAddressInet6Builder() {
                UnsafeBuffer buffer = new UnsafeBuffer(new byte[38]);
                this.addressRW.wrap((MutableDirectBuffer)buffer, 0, buffer.capacity());
                this.addressInet6RW.wrap((MutableDirectBuffer)buffer, 1, buffer.capacity());
            }

            public ProxyAddressInet6Builder protocol(String protocol) {
                this.addressInet6RW.protocol((ProxyAddressProtocolFW.Builder p) -> p.set(ProxyAddressProtocol.valueOf(protocol.toUpperCase())));
                return this;
            }

            public ProxyAddressInet6Builder source(String source) throws UnknownHostException {
                InetAddress inet = InetAddress.getByName(source);
                byte[] ip = inet.getAddress();
                this.addressInet6RW.source((OctetsFW.Builder s) -> s.set(ip));
                return this;
            }

            public ProxyAddressInet6Builder destination(String destination) throws UnknownHostException {
                InetAddress inet = InetAddress.getByName(destination);
                byte[] ip = inet.getAddress();
                this.addressInet6RW.destination((OctetsFW.Builder d) -> d.set(ip));
                return this;
            }

            public ProxyAddressInet6Builder sourcePort(int sourcePort) {
                this.addressInet6RW.sourcePort(sourcePort);
                return this;
            }

            public ProxyAddressInet6Builder destinationPort(int destinationPort) {
                this.addressInet6RW.destinationPort(destinationPort);
                return this;
            }

            public ProxyBeginExBuilder build() {
                ProxyBeginExBuilder.this.beginExRW.address((ProxyAddressFW)this.addressRW.inet6(this.addressInet6RW.build()).build());
                return ProxyBeginExBuilder.this;
            }
        }

        public final class ProxyAddressUnixBuilder {
            private final ProxyAddressFW.Builder addressRW = new ProxyAddressFW.Builder();
            private final ProxyAddressUnixFW.Builder addressUnixRW = new ProxyAddressUnixFW.Builder();

            private ProxyAddressUnixBuilder() {
                UnsafeBuffer buffer = new UnsafeBuffer(new byte[218]);
                this.addressRW.wrap((MutableDirectBuffer)buffer, 0, buffer.capacity());
                this.addressUnixRW.wrap((MutableDirectBuffer)buffer, 1, buffer.capacity());
            }

            public ProxyAddressUnixBuilder protocol(String protocol) {
                this.addressUnixRW.protocol((ProxyAddressProtocolFW.Builder p) -> p.set(ProxyAddressProtocol.valueOf(protocol.toUpperCase())));
                return this;
            }

            public ProxyAddressUnixBuilder source(String source) throws UnknownHostException {
                UnsafeBuffer sourceBuf = new UnsafeBuffer(new byte[108]);
                sourceBuf.putStringWithoutLengthUtf8(0, source);
                this.addressUnixRW.source((DirectBuffer)sourceBuf, 0, sourceBuf.capacity());
                return this;
            }

            public ProxyAddressUnixBuilder destination(String destination) throws UnknownHostException {
                UnsafeBuffer destinationBuf = new UnsafeBuffer(new byte[108]);
                destinationBuf.putStringWithoutLengthUtf8(0, destination);
                this.addressUnixRW.destination((DirectBuffer)destinationBuf, 0, destinationBuf.capacity());
                return this;
            }

            public ProxyBeginExBuilder build() {
                ProxyBeginExBuilder.this.beginExRW.address((ProxyAddressFW)this.addressRW.unix(this.addressUnixRW.build()).build());
                return ProxyBeginExBuilder.this;
            }
        }

        public final class ProxyAddressNoneBuilder {
            private final ProxyAddressFW.Builder addressRW = new ProxyAddressFW.Builder();
            private final ProxyAddressNoneFW.Builder addressNoneRW = new ProxyAddressNoneFW.Builder();

            private ProxyAddressNoneBuilder() {
                UnsafeBuffer buffer = new UnsafeBuffer(new byte[1]);
                this.addressRW.wrap((MutableDirectBuffer)buffer, 0, buffer.capacity());
                this.addressNoneRW.wrap((MutableDirectBuffer)buffer, 1, buffer.capacity());
            }

            public ProxyBeginExBuilder build() {
                ProxyBeginExBuilder.this.beginExRW.address((ProxyAddressFW)this.addressRW.none(this.addressNoneRW.build()).build());
                return ProxyBeginExBuilder.this;
            }
        }

        public final class ProxyInfoBuilder {
            private final Array32FW.Builder<ProxyInfoFW.Builder, ProxyInfoFW> infosRW = new Array32FW.Builder<ProxyInfoFW.Builder, ProxyInfoFW>(new ProxyInfoFW.Builder(), new ProxyInfoFW());

            private ProxyInfoBuilder() {
                UnsafeBuffer buffer = new UnsafeBuffer(new byte[1024]);
                this.infosRW.wrap((MutableDirectBuffer)buffer, 0, buffer.capacity());
            }

            public ProxyInfoBuilder alpn(String alpn) {
                this.infosRW.item(i -> i.alpn(alpn));
                return this;
            }

            public ProxyInfoBuilder authority(String authority) {
                this.infosRW.item(i -> i.authority(authority));
                return this;
            }

            public ProxyInfoBuilder identity(byte[] identity) {
                this.infosRW.item(i -> i.identity(id -> id.value(v -> v.set(identity))));
                return this;
            }

            public ProxyInfoBuilder namespace(String namespace) {
                this.infosRW.item(i -> i.namespace(namespace));
                return this;
            }

            public ProxySecureInfoBuilder secure() {
                return new ProxySecureInfoBuilder();
            }

            public ProxyBeginExBuilder build() {
                ProxyBeginExBuilder.this.beginExRW.infos((Array32FW<ProxyInfoFW>)this.infosRW.build());
                return ProxyBeginExBuilder.this;
            }

            public final class ProxySecureInfoBuilder {
                private ProxySecureInfoBuilder() {
                }

                public ProxySecureInfoBuilder protocol(String protocol) {
                    ProxyInfoBuilder.this.infosRW.item(i -> i.secure(s -> s.protocol(protocol)));
                    return this;
                }

                public ProxySecureInfoBuilder cipher(String cipher) {
                    ProxyInfoBuilder.this.infosRW.item(i -> i.secure(s -> s.cipher(cipher)));
                    return this;
                }

                public ProxySecureInfoBuilder signature(String signature) {
                    ProxyInfoBuilder.this.infosRW.item(i -> i.secure(s -> s.signature(signature)));
                    return this;
                }

                public ProxySecureInfoBuilder name(String name) {
                    ProxyInfoBuilder.this.infosRW.item(i -> i.secure(s -> s.name(name)));
                    return this;
                }

                public ProxySecureInfoBuilder key(String key) {
                    ProxyInfoBuilder.this.infosRW.item(i -> i.secure(s -> s.key(key)));
                    return this;
                }

                public ProxyInfoBuilder build() {
                    return ProxyInfoBuilder.this;
                }
            }
        }
    }

    public static final class ProxyBeginExMatcherBuilder {
        private final DirectBuffer bufferRO = new UnsafeBuffer();
        private final ProxyBeginExFW beginExRO = new ProxyBeginExFW();
        private Integer typeId;
        private Predicate<ProxyAddressFW> address;
        private Predicate<Array32FW<ProxyInfoFW>> infos;

        public ProxyBeginExMatcherBuilder typeId(int typeId) {
            this.typeId = typeId;
            return this;
        }

        public ProxyAddressInetMatcherBuilder addressInet() {
            ProxyAddressInetMatcherBuilder matcher = new ProxyAddressInetMatcherBuilder();
            this.address = x$0 -> matcher.match((ProxyAddressFW)x$0);
            return matcher;
        }

        public ProxyAddressInet4MatcherBuilder addressInet4() {
            ProxyAddressInet4MatcherBuilder matcher = new ProxyAddressInet4MatcherBuilder();
            this.address = x$0 -> matcher.match((ProxyAddressFW)x$0);
            return matcher;
        }

        public ProxyAddressInet6MatcherBuilder addressInet6() {
            ProxyAddressInet6MatcherBuilder matcher = new ProxyAddressInet6MatcherBuilder();
            this.address = x$0 -> matcher.match((ProxyAddressFW)x$0);
            return matcher;
        }

        public ProxyAddressUnixMatcherBuilder addressUnix() {
            ProxyAddressUnixMatcherBuilder matcher = new ProxyAddressUnixMatcherBuilder();
            this.address = x$0 -> matcher.match((ProxyAddressFW)x$0);
            return matcher;
        }

        public ProxyAddressNoneMatcherBuilder addressNone() {
            ProxyAddressNoneMatcherBuilder matcher = new ProxyAddressNoneMatcherBuilder();
            this.address = x$0 -> matcher.match((ProxyAddressFW)x$0);
            return matcher;
        }

        public ProxyInfoMatcherBuilder info() {
            ProxyInfoMatcherBuilder matcher = new ProxyInfoMatcherBuilder();
            this.infos = x$0 -> matcher.match((Array32FW<ProxyInfoFW>)x$0);
            return matcher;
        }

        public BytesMatcher build() {
            return this.typeId != null ? this::match : buf -> null;
        }

        private ProxyBeginExFW match(ByteBuffer byteBuf) throws Exception {
            if (!byteBuf.hasRemaining()) {
                return null;
            }
            this.bufferRO.wrap(byteBuf);
            ProxyBeginExFW beginEx = this.beginExRO.tryWrap(this.bufferRO, byteBuf.position(), byteBuf.capacity());
            if (beginEx != null && this.matchTypeId(beginEx) && this.matchAddress(beginEx) && this.matchInfos(beginEx)) {
                byteBuf.position(byteBuf.position() + beginEx.sizeof());
                return beginEx;
            }
            throw new Exception(beginEx.toString());
        }

        private boolean matchTypeId(ProxyBeginExFW beginEx) {
            return this.typeId.intValue() == beginEx.typeId();
        }

        private boolean matchAddress(ProxyBeginExFW beginEx) {
            return this.address == null || this.address.test(beginEx.address());
        }

        private boolean matchInfos(ProxyBeginExFW beginEx) {
            return this.infos == null || this.infos.test(beginEx.infos());
        }

        public final class ProxyAddressInetMatcherBuilder {
            private ProxyAddressProtocol protocol;
            private String16FW source;
            private String16FW destination;
            private Integer sourcePort;
            private Integer destinationPort;

            private ProxyAddressInetMatcherBuilder() {
            }

            public ProxyAddressInetMatcherBuilder protocol(String protocol) {
                this.protocol = ProxyAddressProtocol.valueOf(protocol.toUpperCase());
                return this;
            }

            public ProxyAddressInetMatcherBuilder source(String source) throws UnknownHostException {
                this.source = new String16FW(source);
                return this;
            }

            public ProxyAddressInetMatcherBuilder destination(String destination) throws UnknownHostException {
                this.destination = new String16FW(destination);
                return this;
            }

            public ProxyAddressInetMatcherBuilder sourcePort(int sourcePort) {
                this.sourcePort = sourcePort;
                return this;
            }

            public ProxyAddressInetMatcherBuilder destinationPort(int destinationPort) {
                this.destinationPort = destinationPort;
                return this;
            }

            public ProxyBeginExMatcherBuilder build() {
                return ProxyBeginExMatcherBuilder.this;
            }

            private boolean match(ProxyAddressFW address) {
                return address.kind() == ProxyAddressFamily.INET && this.match(address.inet());
            }

            private boolean match(ProxyAddressInetFW inet) {
                return this.matchProtocol(inet) && this.matchSource(inet) && this.matchDestination(inet) && this.matchSourcePort(inet) && this.matchDestinationPort(inet);
            }

            private boolean matchProtocol(ProxyAddressInetFW inet) {
                return this.protocol == null || this.protocol == inet.protocol().get();
            }

            private boolean matchSource(ProxyAddressInetFW inet) {
                return this.source == null || this.source.equals(inet.source());
            }

            private boolean matchDestination(ProxyAddressInetFW inet) {
                return this.destination == null || this.destination.equals(inet.destination());
            }

            private boolean matchSourcePort(ProxyAddressInetFW inet) {
                return this.sourcePort == null || this.sourcePort.intValue() == inet.sourcePort();
            }

            private boolean matchDestinationPort(ProxyAddressInetFW inet) {
                return this.destinationPort == null || this.destinationPort.intValue() == inet.destinationPort();
            }
        }

        public final class ProxyAddressInet4MatcherBuilder {
            private ProxyAddressProtocol protocol;
            private OctetsFW source;
            private OctetsFW destination;
            private Integer sourcePort;
            private Integer destinationPort;

            private ProxyAddressInet4MatcherBuilder() {
            }

            public ProxyAddressInet4MatcherBuilder protocol(String protocol) {
                this.protocol = ProxyAddressProtocol.valueOf(protocol.toUpperCase());
                return this;
            }

            public ProxyAddressInet4MatcherBuilder source(String source) throws UnknownHostException {
                InetAddress inet = InetAddress.getByName(source);
                byte[] ip = inet.getAddress();
                this.source = new OctetsFW().wrap((DirectBuffer)new UnsafeBuffer(ip), 0, ip.length);
                return this;
            }

            public ProxyAddressInet4MatcherBuilder destination(String destination) throws UnknownHostException {
                InetAddress inet = InetAddress.getByName(destination);
                byte[] ip = inet.getAddress();
                this.destination = new OctetsFW().wrap((DirectBuffer)new UnsafeBuffer(ip), 0, ip.length);
                return this;
            }

            public ProxyAddressInet4MatcherBuilder sourcePort(int sourcePort) {
                this.sourcePort = sourcePort;
                return this;
            }

            public ProxyAddressInet4MatcherBuilder destinationPort(int destinationPort) {
                this.destinationPort = destinationPort;
                return this;
            }

            public ProxyBeginExMatcherBuilder build() {
                return ProxyBeginExMatcherBuilder.this;
            }

            private boolean match(ProxyAddressFW address) {
                return address.kind() == ProxyAddressFamily.INET4 && this.match(address.inet4());
            }

            private boolean match(ProxyAddressInet4FW inet4) {
                return this.matchProtocol(inet4) && this.matchSource(inet4) && this.matchDestination(inet4) && this.matchSourcePort(inet4) && this.matchDestinationPort(inet4);
            }

            private boolean matchProtocol(ProxyAddressInet4FW inet4) {
                return this.protocol == null || this.protocol == inet4.protocol().get();
            }

            private boolean matchSource(ProxyAddressInet4FW inet4) {
                return this.source == null || this.source.equals(inet4.source());
            }

            private boolean matchDestination(ProxyAddressInet4FW inet4) {
                return this.destination == null || this.destination.equals(inet4.destination());
            }

            private boolean matchSourcePort(ProxyAddressInet4FW inet4) {
                return this.sourcePort == null || this.sourcePort.intValue() == inet4.sourcePort();
            }

            private boolean matchDestinationPort(ProxyAddressInet4FW inet4) {
                return this.destinationPort == null || this.destinationPort.intValue() == inet4.destinationPort();
            }
        }

        public final class ProxyAddressInet6MatcherBuilder {
            private ProxyAddressProtocol protocol;
            private OctetsFW source;
            private OctetsFW destination;
            private Integer sourcePort;
            private Integer destinationPort;

            private ProxyAddressInet6MatcherBuilder() {
            }

            public ProxyAddressInet6MatcherBuilder protocol(String protocol) {
                this.protocol = ProxyAddressProtocol.valueOf(protocol.toUpperCase());
                return this;
            }

            public ProxyAddressInet6MatcherBuilder source(String source) throws UnknownHostException {
                InetAddress inet = InetAddress.getByName(source);
                byte[] ip = inet.getAddress();
                this.source = new OctetsFW().wrap((DirectBuffer)new UnsafeBuffer(ip), 0, ip.length);
                return this;
            }

            public ProxyAddressInet6MatcherBuilder destination(String destination) throws UnknownHostException {
                InetAddress inet = InetAddress.getByName(destination);
                byte[] ip = inet.getAddress();
                this.destination = new OctetsFW().wrap((DirectBuffer)new UnsafeBuffer(ip), 0, ip.length);
                return this;
            }

            public ProxyAddressInet6MatcherBuilder sourcePort(int sourcePort) {
                this.sourcePort = sourcePort;
                return this;
            }

            public ProxyAddressInet6MatcherBuilder destinationPort(int destinationPort) {
                this.destinationPort = destinationPort;
                return this;
            }

            public ProxyBeginExMatcherBuilder build() {
                return ProxyBeginExMatcherBuilder.this;
            }

            private boolean match(ProxyAddressFW address) {
                return address.kind() == ProxyAddressFamily.INET6 && this.match(address.inet6());
            }

            private boolean match(ProxyAddressInet6FW inet6) {
                return this.matchProtocol(inet6) && this.matchSource(inet6) && this.matchDestination(inet6) && this.matchSourcePort(inet6) && this.matchDestinationPort(inet6);
            }

            private boolean matchProtocol(ProxyAddressInet6FW inet6) {
                return this.protocol == null || this.protocol == inet6.protocol().get();
            }

            private boolean matchSource(ProxyAddressInet6FW inet6) {
                return this.source == null || this.source.equals(inet6.source());
            }

            private boolean matchDestination(ProxyAddressInet6FW inet6) {
                return this.destination == null || this.destination.equals(inet6.destination());
            }

            private boolean matchSourcePort(ProxyAddressInet6FW inet6) {
                return this.sourcePort == null || this.sourcePort.intValue() == inet6.sourcePort();
            }

            private boolean matchDestinationPort(ProxyAddressInet6FW inet6) {
                return this.destinationPort == null || this.destinationPort.intValue() == inet6.destinationPort();
            }
        }

        public final class ProxyAddressUnixMatcherBuilder {
            private ProxyAddressProtocol protocol;
            private DirectBuffer source;
            private DirectBuffer destination;

            private ProxyAddressUnixMatcherBuilder() {
            }

            public ProxyAddressUnixMatcherBuilder protocol(String protocol) {
                this.protocol = ProxyAddressProtocol.valueOf(protocol.toUpperCase());
                return this;
            }

            public ProxyAddressUnixMatcherBuilder source(String source) {
                UnsafeBuffer sourceBuf = new UnsafeBuffer(new byte[108]);
                sourceBuf.putStringWithoutLengthUtf8(0, source);
                this.source = sourceBuf;
                return this;
            }

            public ProxyAddressUnixMatcherBuilder destination(String destination) {
                UnsafeBuffer destinationBuf = new UnsafeBuffer(new byte[108]);
                destinationBuf.putStringWithoutLengthUtf8(0, destination);
                this.destination = destinationBuf;
                return this;
            }

            public ProxyBeginExMatcherBuilder build() {
                return ProxyBeginExMatcherBuilder.this;
            }

            private boolean match(ProxyAddressFW address) {
                return address.kind() == ProxyAddressFamily.UNIX && this.match(address.unix());
            }

            private boolean match(ProxyAddressUnixFW unix) {
                return this.matchProtocol(unix) && this.matchSource(unix) && this.matchDestination(unix);
            }

            private boolean matchProtocol(ProxyAddressUnixFW unix) {
                return this.protocol == null || this.protocol == unix.protocol().get();
            }

            private boolean matchSource(ProxyAddressUnixFW unix) {
                return this.source == null || this.source.equals(unix.source().value());
            }

            private boolean matchDestination(ProxyAddressUnixFW unix) {
                return this.destination == null || this.destination.equals(unix.destination().value());
            }
        }

        public final class ProxyAddressNoneMatcherBuilder {
            private ProxyAddressNoneMatcherBuilder() {
            }

            public ProxyBeginExMatcherBuilder build() {
                return ProxyBeginExMatcherBuilder.this;
            }

            private boolean match(ProxyAddressFW address) {
                return address.kind() == ProxyAddressFamily.NONE;
            }
        }

        public final class ProxyInfoMatcherBuilder {
            private final Map<ProxyInfoType, Predicate<ProxyInfoFW>> matchers = new EnumMap<ProxyInfoType, Predicate<ProxyInfoFW>>(ProxyInfoType.class);
            private ProxySecureInfoMatcherBuilder secure;

            private ProxyInfoMatcherBuilder() {
            }

            public ProxyInfoMatcherBuilder alpn(String alpn) {
                String8FW alpn8 = new String8FW(alpn);
                this.matchers.put(ProxyInfoType.ALPN, info -> alpn8.equals(info.alpn()));
                return this;
            }

            public ProxyInfoMatcherBuilder authority(String authority) {
                String16FW authority16 = new String16FW(authority);
                this.matchers.put(ProxyInfoType.AUTHORITY, info -> authority16.equals(info.authority()));
                return this;
            }

            public ProxyInfoMatcherBuilder identity(byte[] identity) {
                UnsafeBuffer identityBuf = new UnsafeBuffer(identity);
                this.matchers.put(ProxyInfoType.IDENTITY, arg_0 -> ProxyInfoMatcherBuilder.lambda$identity$2((DirectBuffer)identityBuf, arg_0));
                return this;
            }

            public ProxyInfoMatcherBuilder namespace(String namespace) {
                String16FW namespace16 = new String16FW(namespace);
                this.matchers.put(ProxyInfoType.NAMESPACE, info -> namespace16.equals(info.namespace()));
                return this;
            }

            public ProxySecureInfoMatcherBuilder secure() {
                if (this.secure == null) {
                    this.secure = new ProxySecureInfoMatcherBuilder();
                }
                this.matchers.put(ProxyInfoType.SECURE, info -> this.secure.match(info.secure()));
                return this.secure;
            }

            public ProxyBeginExMatcherBuilder build() {
                return ProxyBeginExMatcherBuilder.this;
            }

            private boolean match(Array32FW<ProxyInfoFW> infos) {
                MutableInteger match = new MutableInteger(0);
                infos.forEach(info -> {
                    match.value = match.value + (this.match((ProxyInfoFW)info) ? 1 : 0);
                });
                return match.value == (this.matchers.containsKey((Object)ProxyInfoType.SECURE) ? this.matchers.size() + this.secure.matchers.size() - 1 : this.matchers.size());
            }

            private boolean match(ProxyInfoFW info) {
                Predicate<ProxyInfoFW> matcher = this.matchers.get((Object)info.kind());
                return matcher != null && matcher.test(info);
            }

            private static /* synthetic */ boolean lambda$identity$2(DirectBuffer identityBuf, ProxyInfoFW info) {
                return identityBuf.equals(info.identity().value().value());
            }

            public final class ProxySecureInfoMatcherBuilder {
                private final Map<ProxySecureInfoType, Predicate<ProxySecureInfoFW>> matchers = new EnumMap<ProxySecureInfoType, Predicate<ProxySecureInfoFW>>(ProxySecureInfoType.class);

                private ProxySecureInfoMatcherBuilder() {
                }

                public ProxySecureInfoMatcherBuilder protocol(String protocol) {
                    String8FW protocol8 = new String8FW(protocol);
                    this.matchers.put(ProxySecureInfoType.PROTOCOL, info -> protocol8.equals(info.protocol()));
                    return this;
                }

                public ProxySecureInfoMatcherBuilder cipher(String cipher) {
                    String8FW cipher8 = new String8FW(cipher);
                    this.matchers.put(ProxySecureInfoType.CIPHER, info -> cipher8.equals(info.cipher()));
                    return this;
                }

                public ProxySecureInfoMatcherBuilder signature(String signature) {
                    String8FW signature8 = new String8FW(signature);
                    this.matchers.put(ProxySecureInfoType.SIGNATURE, info -> signature8.equals(info.signature()));
                    return this;
                }

                public ProxySecureInfoMatcherBuilder name(String name) {
                    String16FW name16 = new String16FW(name);
                    this.matchers.put(ProxySecureInfoType.NAME, info -> name16.equals(info.name()));
                    return this;
                }

                public ProxySecureInfoMatcherBuilder key(String key) {
                    String8FW key8 = new String8FW(key);
                    this.matchers.put(ProxySecureInfoType.KEY, info -> key8.equals(info.key()));
                    return this;
                }

                public ProxyInfoMatcherBuilder build() {
                    return ProxyInfoMatcherBuilder.this;
                }

                private boolean match(ProxySecureInfoFW secureInfo) {
                    Predicate<ProxySecureInfoFW> matcher = this.matchers.get((Object)secureInfo.kind());
                    return matcher != null && matcher.test(secureInfo);
                }
            }
        }
    }

    public static class Mapper
    extends FunctionMapperSpi.Reflective {
        public Mapper() {
            super(ProxyFunctions.class);
        }

        public String getPrefixName() {
            return "proxy";
        }
    }
}

