/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.nukleus.proxy.internal.types;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.specification.nukleus.proxy.internal.types.BoundedOctetsFW;
import org.reaktivity.specification.nukleus.proxy.internal.types.Flyweight;

public final class BoundedOctets16FW
extends BoundedOctetsFW {
    private static final int LENGTH_SIZE = 2;
    private static final int LENGTH_OFFSET = 0;
    private static final int VALUE_OFFSET = 2;
    private final DirectBuffer valueRO = new UnsafeBuffer(0L, 0);
    private final ByteOrder byteOrder;

    public BoundedOctets16FW() {
        this.byteOrder = ByteOrder.nativeOrder();
    }

    public BoundedOctets16FW(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    @Override
    public <T> T get(Flyweight.Visitor<T> visitor) {
        return visitor.visit(this.buffer(), this.offset() + 2, this.limit());
    }

    @Override
    public DirectBuffer value() {
        return this.valueRO;
    }

    @Override
    public int length() {
        return this.buffer().getShort(this.offset() + 0, this.byteOrder) & 0xFFFF;
    }

    @Override
    public BoundedOctets16FW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null) {
            return null;
        }
        this.valueRO.wrap(buffer, offset + 2, this.length());
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public BoundedOctets16FW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.valueRO.wrap(buffer, offset + 2, this.length());
        BoundedOctets16FW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        return this.offset() + 2 + this.length();
    }

    public String toString() {
        return String.format("boundedOctets16[%d]", this.length());
    }

    public static final class Builder
    extends BoundedOctetsFW.Builder<BoundedOctets16FW> {
        private final ByteOrder byteOrder;

        public Builder() {
            super(new BoundedOctets16FW());
            this.byteOrder = ByteOrder.nativeOrder();
        }

        public Builder(ByteOrder byteOrder) {
            super(new BoundedOctets16FW(byteOrder));
            this.byteOrder = byteOrder;
        }

        public Builder set(BoundedOctetsFW value) {
            int newLimit = this.offset() + 2 + value.length();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putShort(this.offset() + 0, (short)(value.length() & 0xFFFF), this.byteOrder);
            this.buffer().putBytes(this.offset() + 2, value.buffer(), value.offset() + 2, value.length());
            this.limit(newLimit);
            return this;
        }

        public Builder set(DirectBuffer value, int offset, int length) {
            int newLimit = this.offset() + 2 + length;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putShort(this.offset() + 0, (short)(length & 0xFFFF), this.byteOrder);
            this.buffer().putBytes(this.offset() + 2, value, offset, length);
            this.limit(newLimit);
            return this;
        }

        public Builder set(byte[] value) {
            int newLimit = this.offset() + 2 + value.length;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putShort(this.offset() + 0, (short)(value.length & 0xFFFF), this.byteOrder);
            this.buffer().putBytes(this.offset() + 2, value);
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            Flyweight.checkLimit(offset + 2, maxLimit);
            super.wrap(buffer, offset, maxLimit);
            return this;
        }
    }
}

