/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.nukleus.proxy.internal.types;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.nukleus.proxy.internal.types.ArrayFW;
import org.reaktivity.specification.nukleus.proxy.internal.types.Flyweight;
import org.reaktivity.specification.nukleus.proxy.internal.types.OctetsFW;
import org.reaktivity.specification.nukleus.proxy.internal.types.ProxyAddressProtocolFW;

public final class ProxyAddressUnixFW
extends Flyweight {
    public static final int FIELD_OFFSET_PROTOCOL = 0;
    public static final int FIELD_OFFSET_SOURCE = 0;
    public static final int FIELD_OFFSET_DESTINATION = 0;
    private final ProxyAddressProtocolFW protocolRO = new ProxyAddressProtocolFW();
    private final OctetsFW sourceRO = new OctetsFW();
    private final OctetsFW destinationRO = new OctetsFW();

    public ProxyAddressProtocolFW protocol() {
        return this.protocolRO;
    }

    public OctetsFW source() {
        return this.sourceRO;
    }

    public OctetsFW destination() {
        return this.destinationRO;
    }

    @Override
    public ProxyAddressUnixFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.protocolRO.wrap(buffer, offset + 0, maxLimit);
        this.sourceRO.wrap(buffer, this.protocolRO.limit() + 0, this.protocolRO.limit() + 0 + 108);
        this.destinationRO.wrap(buffer, this.sourceRO.limit() + 0, this.sourceRO.limit() + 0 + 108);
        ProxyAddressUnixFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public ProxyAddressUnixFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.protocolRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        int limit = this.protocolRO.limit() + 0 + 108;
        if (limit > maxLimit || null == this.sourceRO.tryWrap(buffer, this.protocolRO.limit() + 0, limit)) {
            return null;
        }
        limit = this.sourceRO.limit() + 0 + 108;
        if (limit > maxLimit || null == this.destinationRO.tryWrap(buffer, this.sourceRO.limit() + 0, limit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.destinationRO.limit();
    }

    public String toString() {
        return String.format("PROXY_ADDRESS_UNIX [protocol=%s, source=%s, destination=%s]", this.protocol(), this.source(), this.destination());
    }

    public static final class Builder
    extends Flyweight.Builder<ProxyAddressUnixFW> {
        private static final int INDEX_PROTOCOL = 0;
        private static final int INDEX_SOURCE = 1;
        private static final int INDEX_DESTINATION = 2;
        private static final int FIELD_COUNT = 3;
        private final ProxyAddressProtocolFW.Builder protocolRW = new ProxyAddressProtocolFW.Builder();
        private final OctetsFW.Builder sourceRW = new OctetsFW.Builder();
        private final OctetsFW.Builder destinationRW = new OctetsFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new ProxyAddressUnixFW());
        }

        public Builder protocol(Consumer<ProxyAddressProtocolFW.Builder> mutator) {
            assert (this.lastFieldSet == -1);
            ProxyAddressProtocolFW.Builder protocolRW = this.protocolRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(protocolRW);
            this.limit(protocolRW.build().limit());
            this.lastFieldSet = 0;
            return this;
        }

        public Builder protocol(ProxyAddressProtocolFW field) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        private OctetsFW.Builder source() {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + 108;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            return this.sourceRW.wrap(this.buffer(), this.limit(), newLimit);
        }

        public Builder source(OctetsFW value) {
            OctetsFW.Builder sourceRW = this.source();
            sourceRW.set(value);
            int expectedLimit = sourceRW.maxLimit();
            int actualLimit = ((OctetsFW)sourceRW.build()).limit();
            if (actualLimit != expectedLimit) {
                throw new IllegalStateException(String.format("%d instead of %d bytes have been set for field \"source\"", actualLimit - this.limit(), expectedLimit - this.limit()));
            }
            this.limit(sourceRW.maxLimit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder source(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder sourceRW = this.source();
            mutator.accept(sourceRW);
            int expectedLimit = sourceRW.maxLimit();
            int actualLimit = ((OctetsFW)sourceRW.build()).limit();
            if (actualLimit != expectedLimit) {
                throw new IllegalStateException(String.format("%d instead of %d bytes have been set for field \"source\"", actualLimit - this.limit(), expectedLimit - this.limit()));
            }
            this.limit(sourceRW.maxLimit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder source(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder sourceRW = this.source();
            int fieldSize = sourceRW.maxLimit() - this.limit();
            if (length != fieldSize) {
                throw new IllegalArgumentException(String.format("Invalid length %d for field \"source\", expected %d", length, fieldSize));
            }
            sourceRW.set(buffer, offset, length);
            this.limit(((OctetsFW)sourceRW.build()).limit());
            this.lastFieldSet = 1;
            return this;
        }

        private OctetsFW.Builder destination() {
            assert (this.lastFieldSet == 1);
            int newLimit = this.limit() + 108;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            return this.destinationRW.wrap(this.buffer(), this.limit(), newLimit);
        }

        public Builder destination(OctetsFW value) {
            OctetsFW.Builder destinationRW = this.destination();
            destinationRW.set(value);
            int expectedLimit = destinationRW.maxLimit();
            int actualLimit = ((OctetsFW)destinationRW.build()).limit();
            if (actualLimit != expectedLimit) {
                throw new IllegalStateException(String.format("%d instead of %d bytes have been set for field \"destination\"", actualLimit - this.limit(), expectedLimit - this.limit()));
            }
            this.limit(destinationRW.maxLimit());
            this.lastFieldSet = 2;
            return this;
        }

        public Builder destination(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder destinationRW = this.destination();
            mutator.accept(destinationRW);
            int expectedLimit = destinationRW.maxLimit();
            int actualLimit = ((OctetsFW)destinationRW.build()).limit();
            if (actualLimit != expectedLimit) {
                throw new IllegalStateException(String.format("%d instead of %d bytes have been set for field \"destination\"", actualLimit - this.limit(), expectedLimit - this.limit()));
            }
            this.limit(destinationRW.maxLimit());
            this.lastFieldSet = 2;
            return this;
        }

        public Builder destination(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder destinationRW = this.destination();
            int fieldSize = destinationRW.maxLimit() - this.limit();
            if (length != fieldSize) {
                throw new IllegalArgumentException(String.format("Invalid length %d for field \"destination\", expected %d", length, fieldSize));
            }
            destinationRW.set(buffer, offset, length);
            this.limit(((OctetsFW)destinationRW.build()).limit());
            this.lastFieldSet = 2;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public ProxyAddressUnixFW build() {
            assert (this.lastFieldSet == 2);
            this.lastFieldSet = -1;
            return (ProxyAddressUnixFW)super.build();
        }
    }
}

